# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['PreparedStatementArgs', 'PreparedStatement']

@pulumi.input_type
class PreparedStatementArgs:
    def __init__(__self__, *,
                 query_statement: pulumi.Input[str],
                 workgroup: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a PreparedStatement resource.
        :param pulumi.Input[str] query_statement: The query string for the prepared statement.
        :param pulumi.Input[str] workgroup: The name of the workgroup to which the prepared statement belongs.
        :param pulumi.Input[str] description: Brief explanation of prepared statement. Maximum length of 1024.
        :param pulumi.Input[str] name: The name of the prepared statement. Maximum length of 256.
        """
        pulumi.set(__self__, "query_statement", query_statement)
        pulumi.set(__self__, "workgroup", workgroup)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="queryStatement")
    def query_statement(self) -> pulumi.Input[str]:
        """
        The query string for the prepared statement.
        """
        return pulumi.get(self, "query_statement")

    @query_statement.setter
    def query_statement(self, value: pulumi.Input[str]):
        pulumi.set(self, "query_statement", value)

    @property
    @pulumi.getter
    def workgroup(self) -> pulumi.Input[str]:
        """
        The name of the workgroup to which the prepared statement belongs.
        """
        return pulumi.get(self, "workgroup")

    @workgroup.setter
    def workgroup(self, value: pulumi.Input[str]):
        pulumi.set(self, "workgroup", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Brief explanation of prepared statement. Maximum length of 1024.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the prepared statement. Maximum length of 256.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _PreparedStatementState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 query_statement: Optional[pulumi.Input[str]] = None,
                 workgroup: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering PreparedStatement resources.
        :param pulumi.Input[str] description: Brief explanation of prepared statement. Maximum length of 1024.
        :param pulumi.Input[str] name: The name of the prepared statement. Maximum length of 256.
        :param pulumi.Input[str] query_statement: The query string for the prepared statement.
        :param pulumi.Input[str] workgroup: The name of the workgroup to which the prepared statement belongs.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if query_statement is not None:
            pulumi.set(__self__, "query_statement", query_statement)
        if workgroup is not None:
            pulumi.set(__self__, "workgroup", workgroup)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Brief explanation of prepared statement. Maximum length of 1024.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the prepared statement. Maximum length of 256.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="queryStatement")
    def query_statement(self) -> Optional[pulumi.Input[str]]:
        """
        The query string for the prepared statement.
        """
        return pulumi.get(self, "query_statement")

    @query_statement.setter
    def query_statement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_statement", value)

    @property
    @pulumi.getter
    def workgroup(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the workgroup to which the prepared statement belongs.
        """
        return pulumi.get(self, "workgroup")

    @workgroup.setter
    def workgroup(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workgroup", value)


class PreparedStatement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 query_statement: Optional[pulumi.Input[str]] = None,
                 workgroup: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource for managing an Athena Prepared Statement.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.s3.BucketV2("test",
            bucket="tf-test",
            force_destroy=True)
        test_workgroup = aws.athena.Workgroup("test", name="tf-test")
        test_database = aws.athena.Database("test",
            name="example",
            bucket=test.bucket)
        test_prepared_statement = aws.athena.PreparedStatement("test",
            name="tf_test",
            query_statement=test_database.name.apply(lambda name: f"SELECT * FROM {name} WHERE x = ?"),
            workgroup=test_workgroup.name)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Athena Prepared Statement using the `WORKGROUP-NAME/STATEMENT-NAME`. For example:

        ```sh
        $ pulumi import aws:athena/preparedStatement:PreparedStatement example 12345abcde/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Brief explanation of prepared statement. Maximum length of 1024.
        :param pulumi.Input[str] name: The name of the prepared statement. Maximum length of 256.
        :param pulumi.Input[str] query_statement: The query string for the prepared statement.
        :param pulumi.Input[str] workgroup: The name of the workgroup to which the prepared statement belongs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PreparedStatementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an Athena Prepared Statement.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.s3.BucketV2("test",
            bucket="tf-test",
            force_destroy=True)
        test_workgroup = aws.athena.Workgroup("test", name="tf-test")
        test_database = aws.athena.Database("test",
            name="example",
            bucket=test.bucket)
        test_prepared_statement = aws.athena.PreparedStatement("test",
            name="tf_test",
            query_statement=test_database.name.apply(lambda name: f"SELECT * FROM {name} WHERE x = ?"),
            workgroup=test_workgroup.name)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Athena Prepared Statement using the `WORKGROUP-NAME/STATEMENT-NAME`. For example:

        ```sh
        $ pulumi import aws:athena/preparedStatement:PreparedStatement example 12345abcde/example
        ```

        :param str resource_name: The name of the resource.
        :param PreparedStatementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PreparedStatementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 query_statement: Optional[pulumi.Input[str]] = None,
                 workgroup: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PreparedStatementArgs.__new__(PreparedStatementArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if query_statement is None and not opts.urn:
                raise TypeError("Missing required property 'query_statement'")
            __props__.__dict__["query_statement"] = query_statement
            if workgroup is None and not opts.urn:
                raise TypeError("Missing required property 'workgroup'")
            __props__.__dict__["workgroup"] = workgroup
        super(PreparedStatement, __self__).__init__(
            'aws:athena/preparedStatement:PreparedStatement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            query_statement: Optional[pulumi.Input[str]] = None,
            workgroup: Optional[pulumi.Input[str]] = None) -> 'PreparedStatement':
        """
        Get an existing PreparedStatement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Brief explanation of prepared statement. Maximum length of 1024.
        :param pulumi.Input[str] name: The name of the prepared statement. Maximum length of 256.
        :param pulumi.Input[str] query_statement: The query string for the prepared statement.
        :param pulumi.Input[str] workgroup: The name of the workgroup to which the prepared statement belongs.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PreparedStatementState.__new__(_PreparedStatementState)

        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["query_statement"] = query_statement
        __props__.__dict__["workgroup"] = workgroup
        return PreparedStatement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Brief explanation of prepared statement. Maximum length of 1024.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the prepared statement. Maximum length of 256.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="queryStatement")
    def query_statement(self) -> pulumi.Output[str]:
        """
        The query string for the prepared statement.
        """
        return pulumi.get(self, "query_statement")

    @property
    @pulumi.getter
    def workgroup(self) -> pulumi.Output[str]:
        """
        The name of the workgroup to which the prepared statement belongs.
        """
        return pulumi.get(self, "workgroup")

