# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['OrganizationAdminAccountRegistrationArgs', 'OrganizationAdminAccountRegistration']

@pulumi.input_type
class OrganizationAdminAccountRegistrationArgs:
    def __init__(__self__, *,
                 admin_account_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a OrganizationAdminAccountRegistration resource.
        :param pulumi.Input[str] admin_account_id: Identifier for the organization administrator account.
        """
        pulumi.set(__self__, "admin_account_id", admin_account_id)

    @property
    @pulumi.getter(name="adminAccountId")
    def admin_account_id(self) -> pulumi.Input[str]:
        """
        Identifier for the organization administrator account.
        """
        return pulumi.get(self, "admin_account_id")

    @admin_account_id.setter
    def admin_account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "admin_account_id", value)


@pulumi.input_type
class _OrganizationAdminAccountRegistrationState:
    def __init__(__self__, *,
                 admin_account_id: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering OrganizationAdminAccountRegistration resources.
        :param pulumi.Input[str] admin_account_id: Identifier for the organization administrator account.
        :param pulumi.Input[str] organization_id: Identifier for the organization.
        """
        if admin_account_id is not None:
            pulumi.set(__self__, "admin_account_id", admin_account_id)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)

    @property
    @pulumi.getter(name="adminAccountId")
    def admin_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier for the organization administrator account.
        """
        return pulumi.get(self, "admin_account_id")

    @admin_account_id.setter
    def admin_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_account_id", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier for the organization.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_id", value)


class OrganizationAdminAccountRegistration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_account_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource for managing AWS Audit Manager Organization Admin Account Registration.

        ## Example Usage

        ### Basic Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.auditmanager.OrganizationAdminAccountRegistration("example", admin_account_id="012345678901")
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Audit Manager Organization Admin Account Registration using the `id`. For example:

        ```sh
        $ pulumi import aws:auditmanager/organizationAdminAccountRegistration:OrganizationAdminAccountRegistration example 012345678901
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] admin_account_id: Identifier for the organization administrator account.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationAdminAccountRegistrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing AWS Audit Manager Organization Admin Account Registration.

        ## Example Usage

        ### Basic Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.auditmanager.OrganizationAdminAccountRegistration("example", admin_account_id="012345678901")
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Audit Manager Organization Admin Account Registration using the `id`. For example:

        ```sh
        $ pulumi import aws:auditmanager/organizationAdminAccountRegistration:OrganizationAdminAccountRegistration example 012345678901
        ```

        :param str resource_name: The name of the resource.
        :param OrganizationAdminAccountRegistrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationAdminAccountRegistrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_account_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationAdminAccountRegistrationArgs.__new__(OrganizationAdminAccountRegistrationArgs)

            if admin_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'admin_account_id'")
            __props__.__dict__["admin_account_id"] = admin_account_id
            __props__.__dict__["organization_id"] = None
        super(OrganizationAdminAccountRegistration, __self__).__init__(
            'aws:auditmanager/organizationAdminAccountRegistration:OrganizationAdminAccountRegistration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_account_id: Optional[pulumi.Input[str]] = None,
            organization_id: Optional[pulumi.Input[str]] = None) -> 'OrganizationAdminAccountRegistration':
        """
        Get an existing OrganizationAdminAccountRegistration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] admin_account_id: Identifier for the organization administrator account.
        :param pulumi.Input[str] organization_id: Identifier for the organization.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationAdminAccountRegistrationState.__new__(_OrganizationAdminAccountRegistrationState)

        __props__.__dict__["admin_account_id"] = admin_account_id
        __props__.__dict__["organization_id"] = organization_id
        return OrganizationAdminAccountRegistration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminAccountId")
    def admin_account_id(self) -> pulumi.Output[str]:
        """
        Identifier for the organization administrator account.
        """
        return pulumi.get(self, "admin_account_id")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[str]:
        """
        Identifier for the organization.
        """
        return pulumi.get(self, "organization_id")

