# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AttachmentArgs', 'Attachment']

@pulumi.input_type
class AttachmentArgs:
    def __init__(__self__, *,
                 autoscaling_group_name: pulumi.Input[str],
                 elb: Optional[pulumi.Input[str]] = None,
                 lb_target_group_arn: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Attachment resource.
        :param pulumi.Input[str] autoscaling_group_name: Name of ASG to associate with the ELB.
        :param pulumi.Input[str] elb: Name of the ELB.
        :param pulumi.Input[str] lb_target_group_arn: ARN of a load balancer target group.
        """
        pulumi.set(__self__, "autoscaling_group_name", autoscaling_group_name)
        if elb is not None:
            pulumi.set(__self__, "elb", elb)
        if lb_target_group_arn is not None:
            pulumi.set(__self__, "lb_target_group_arn", lb_target_group_arn)

    @property
    @pulumi.getter(name="autoscalingGroupName")
    def autoscaling_group_name(self) -> pulumi.Input[str]:
        """
        Name of ASG to associate with the ELB.
        """
        return pulumi.get(self, "autoscaling_group_name")

    @autoscaling_group_name.setter
    def autoscaling_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "autoscaling_group_name", value)

    @property
    @pulumi.getter
    def elb(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the ELB.
        """
        return pulumi.get(self, "elb")

    @elb.setter
    def elb(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "elb", value)

    @property
    @pulumi.getter(name="lbTargetGroupArn")
    def lb_target_group_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of a load balancer target group.
        """
        return pulumi.get(self, "lb_target_group_arn")

    @lb_target_group_arn.setter
    def lb_target_group_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lb_target_group_arn", value)


@pulumi.input_type
class _AttachmentState:
    def __init__(__self__, *,
                 autoscaling_group_name: Optional[pulumi.Input[str]] = None,
                 elb: Optional[pulumi.Input[str]] = None,
                 lb_target_group_arn: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Attachment resources.
        :param pulumi.Input[str] autoscaling_group_name: Name of ASG to associate with the ELB.
        :param pulumi.Input[str] elb: Name of the ELB.
        :param pulumi.Input[str] lb_target_group_arn: ARN of a load balancer target group.
        """
        if autoscaling_group_name is not None:
            pulumi.set(__self__, "autoscaling_group_name", autoscaling_group_name)
        if elb is not None:
            pulumi.set(__self__, "elb", elb)
        if lb_target_group_arn is not None:
            pulumi.set(__self__, "lb_target_group_arn", lb_target_group_arn)

    @property
    @pulumi.getter(name="autoscalingGroupName")
    def autoscaling_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of ASG to associate with the ELB.
        """
        return pulumi.get(self, "autoscaling_group_name")

    @autoscaling_group_name.setter
    def autoscaling_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "autoscaling_group_name", value)

    @property
    @pulumi.getter
    def elb(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the ELB.
        """
        return pulumi.get(self, "elb")

    @elb.setter
    def elb(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "elb", value)

    @property
    @pulumi.getter(name="lbTargetGroupArn")
    def lb_target_group_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of a load balancer target group.
        """
        return pulumi.get(self, "lb_target_group_arn")

    @lb_target_group_arn.setter
    def lb_target_group_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lb_target_group_arn", value)


class Attachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autoscaling_group_name: Optional[pulumi.Input[str]] = None,
                 elb: Optional[pulumi.Input[str]] = None,
                 lb_target_group_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Attaches a load balancer to an Auto Scaling group.

        > **NOTE on Auto Scaling Groups, Attachments and Traffic Source Attachments:** Pulumi provides standalone Attachment (for attaching Classic Load Balancers and Application Load Balancer, Gateway Load Balancer, or Network Load Balancer target groups) and Traffic Source Attachment (for attaching Load Balancers and VPC Lattice target groups) resources and an Auto Scaling Group resource with `load_balancers`, `target_group_arns` and `traffic_source` attributes. Do not use the same traffic source in more than one of these resources. Doing so will cause a conflict of attachments. A `lifecycle` configuration block can be used to suppress differences if necessary.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        # Create a new load balancer attachment
        example = aws.autoscaling.Attachment("example",
            autoscaling_group_name=example_aws_autoscaling_group["id"],
            elb=example_aws_elb["id"])
        ```
        <!--End PulumiCodeChooser -->

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        # Create a new ALB Target Group attachment
        example = aws.autoscaling.Attachment("example",
            autoscaling_group_name=example_aws_autoscaling_group["id"],
            lb_target_group_arn=example_aws_lb_target_group["arn"])
        ```
        <!--End PulumiCodeChooser -->

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] autoscaling_group_name: Name of ASG to associate with the ELB.
        :param pulumi.Input[str] elb: Name of the ELB.
        :param pulumi.Input[str] lb_target_group_arn: ARN of a load balancer target group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Attaches a load balancer to an Auto Scaling group.

        > **NOTE on Auto Scaling Groups, Attachments and Traffic Source Attachments:** Pulumi provides standalone Attachment (for attaching Classic Load Balancers and Application Load Balancer, Gateway Load Balancer, or Network Load Balancer target groups) and Traffic Source Attachment (for attaching Load Balancers and VPC Lattice target groups) resources and an Auto Scaling Group resource with `load_balancers`, `target_group_arns` and `traffic_source` attributes. Do not use the same traffic source in more than one of these resources. Doing so will cause a conflict of attachments. A `lifecycle` configuration block can be used to suppress differences if necessary.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        # Create a new load balancer attachment
        example = aws.autoscaling.Attachment("example",
            autoscaling_group_name=example_aws_autoscaling_group["id"],
            elb=example_aws_elb["id"])
        ```
        <!--End PulumiCodeChooser -->

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        # Create a new ALB Target Group attachment
        example = aws.autoscaling.Attachment("example",
            autoscaling_group_name=example_aws_autoscaling_group["id"],
            lb_target_group_arn=example_aws_lb_target_group["arn"])
        ```
        <!--End PulumiCodeChooser -->

        :param str resource_name: The name of the resource.
        :param AttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autoscaling_group_name: Optional[pulumi.Input[str]] = None,
                 elb: Optional[pulumi.Input[str]] = None,
                 lb_target_group_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AttachmentArgs.__new__(AttachmentArgs)

            if autoscaling_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'autoscaling_group_name'")
            __props__.__dict__["autoscaling_group_name"] = autoscaling_group_name
            __props__.__dict__["elb"] = elb
            __props__.__dict__["lb_target_group_arn"] = lb_target_group_arn
        super(Attachment, __self__).__init__(
            'aws:autoscaling/attachment:Attachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            autoscaling_group_name: Optional[pulumi.Input[str]] = None,
            elb: Optional[pulumi.Input[str]] = None,
            lb_target_group_arn: Optional[pulumi.Input[str]] = None) -> 'Attachment':
        """
        Get an existing Attachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] autoscaling_group_name: Name of ASG to associate with the ELB.
        :param pulumi.Input[str] elb: Name of the ELB.
        :param pulumi.Input[str] lb_target_group_arn: ARN of a load balancer target group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AttachmentState.__new__(_AttachmentState)

        __props__.__dict__["autoscaling_group_name"] = autoscaling_group_name
        __props__.__dict__["elb"] = elb
        __props__.__dict__["lb_target_group_arn"] = lb_target_group_arn
        return Attachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoscalingGroupName")
    def autoscaling_group_name(self) -> pulumi.Output[str]:
        """
        Name of ASG to associate with the ELB.
        """
        return pulumi.get(self, "autoscaling_group_name")

    @property
    @pulumi.getter
    def elb(self) -> pulumi.Output[Optional[str]]:
        """
        Name of the ELB.
        """
        return pulumi.get(self, "elb")

    @property
    @pulumi.getter(name="lbTargetGroupArn")
    def lb_target_group_arn(self) -> pulumi.Output[Optional[str]]:
        """
        ARN of a load balancer target group.
        """
        return pulumi.get(self, "lb_target_group_arn")

