# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ComputeEnvironmentComputeResourcesArgs',
    'ComputeEnvironmentComputeResourcesEc2ConfigurationArgs',
    'ComputeEnvironmentComputeResourcesLaunchTemplateArgs',
    'ComputeEnvironmentEksConfigurationArgs',
    'ComputeEnvironmentUpdatePolicyArgs',
    'JobDefinitionEksPropertiesArgs',
    'JobDefinitionEksPropertiesPodPropertiesArgs',
    'JobDefinitionEksPropertiesPodPropertiesContainersArgs',
    'JobDefinitionEksPropertiesPodPropertiesContainersEnvArgs',
    'JobDefinitionEksPropertiesPodPropertiesContainersResourcesArgs',
    'JobDefinitionEksPropertiesPodPropertiesContainersSecurityContextArgs',
    'JobDefinitionEksPropertiesPodPropertiesContainersVolumeMountArgs',
    'JobDefinitionEksPropertiesPodPropertiesMetadataArgs',
    'JobDefinitionEksPropertiesPodPropertiesVolumeArgs',
    'JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDirArgs',
    'JobDefinitionEksPropertiesPodPropertiesVolumeHostPathArgs',
    'JobDefinitionEksPropertiesPodPropertiesVolumeSecretArgs',
    'JobDefinitionRetryStrategyArgs',
    'JobDefinitionRetryStrategyEvaluateOnExitArgs',
    'JobDefinitionTimeoutArgs',
    'JobQueueComputeEnvironmentOrderArgs',
    'JobQueueTimeoutsArgs',
    'SchedulingPolicyFairSharePolicyArgs',
    'SchedulingPolicyFairSharePolicyShareDistributionArgs',
]

@pulumi.input_type
class ComputeEnvironmentComputeResourcesArgs:
    def __init__(__self__, *,
                 max_vcpus: pulumi.Input[int],
                 subnets: pulumi.Input[Sequence[pulumi.Input[str]]],
                 type: pulumi.Input[str],
                 allocation_strategy: Optional[pulumi.Input[str]] = None,
                 bid_percentage: Optional[pulumi.Input[int]] = None,
                 desired_vcpus: Optional[pulumi.Input[int]] = None,
                 ec2_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeEnvironmentComputeResourcesEc2ConfigurationArgs']]]] = None,
                 ec2_key_pair: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 instance_role: Optional[pulumi.Input[str]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 launch_template: Optional[pulumi.Input['ComputeEnvironmentComputeResourcesLaunchTemplateArgs']] = None,
                 min_vcpus: Optional[pulumi.Input[int]] = None,
                 placement_group: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 spot_iam_fleet_role: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[int] max_vcpus: The maximum number of EC2 vCPUs that an environment can reach.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnets: A list of VPC subnets into which the compute resources are launched.
        :param pulumi.Input[str] type: The type of compute environment. Valid items are `EC2`, `SPOT`, `FARGATE` or `FARGATE_SPOT`.
        :param pulumi.Input[str] allocation_strategy: The allocation strategy to use for the compute resource in case not enough instances of the best fitting instance type can be allocated. For valid values, refer to the [AWS documentation](https://docs.aws.amazon.com/batch/latest/APIReference/API_ComputeResource.html#Batch-Type-ComputeResource-allocationStrategy). Defaults to `BEST_FIT`. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        :param pulumi.Input[int] bid_percentage: Integer of maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance type before instances are launched. For example, if your bid percentage is 20%!((MISSING)`20`), then the Spot price must be below 20%!o(MISSING)f the current On-Demand price for that EC2 instance. If you leave this field empty, the default value is 100%!o(MISSING)f the On-Demand price. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        :param pulumi.Input[int] desired_vcpus: The desired number of EC2 vCPUS in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        :param pulumi.Input[Sequence[pulumi.Input['ComputeEnvironmentComputeResourcesEc2ConfigurationArgs']]] ec2_configurations: Provides information used to select Amazon Machine Images (AMIs) for EC2 instances in the compute environment. If Ec2Configuration isn't specified, the default is ECS_AL2. This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
        :param pulumi.Input[str] ec2_key_pair: The EC2 key pair that is used for instances launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        :param pulumi.Input[str] image_id: The Amazon Machine Image (AMI) ID used for instances launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified. (Deprecated, use `ec2_configuration` `image_id_override` instead)
        :param pulumi.Input[str] instance_role: The Amazon ECS instance role applied to Amazon EC2 instances in a compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_types: A list of instance types that may be launched. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        :param pulumi.Input['ComputeEnvironmentComputeResourcesLaunchTemplateArgs'] launch_template: The launch template to use for your compute resources. See details below. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        :param pulumi.Input[int] min_vcpus: The minimum number of EC2 vCPUs that an environment should maintain. For `EC2` or `SPOT` compute environments, if the parameter is not explicitly defined, a `0` default value will be set. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        :param pulumi.Input[str] placement_group: The Amazon EC2 placement group to associate with your compute resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list of EC2 security group that are associated with instances launched in the compute environment. This parameter is required for Fargate compute environments.
        :param pulumi.Input[str] spot_iam_fleet_role: The Amazon Resource Name (ARN) of the Amazon EC2 Spot Fleet IAM role applied to a SPOT compute environment. This parameter is required for SPOT compute environments. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value pair tags to be applied to resources that are launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        pulumi.set(__self__, "max_vcpus", max_vcpus)
        pulumi.set(__self__, "subnets", subnets)
        pulumi.set(__self__, "type", type)
        if allocation_strategy is not None:
            pulumi.set(__self__, "allocation_strategy", allocation_strategy)
        if bid_percentage is not None:
            pulumi.set(__self__, "bid_percentage", bid_percentage)
        if desired_vcpus is not None:
            pulumi.set(__self__, "desired_vcpus", desired_vcpus)
        if ec2_configurations is not None:
            pulumi.set(__self__, "ec2_configurations", ec2_configurations)
        if ec2_key_pair is not None:
            pulumi.set(__self__, "ec2_key_pair", ec2_key_pair)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if instance_role is not None:
            pulumi.set(__self__, "instance_role", instance_role)
        if instance_types is not None:
            pulumi.set(__self__, "instance_types", instance_types)
        if launch_template is not None:
            pulumi.set(__self__, "launch_template", launch_template)
        if min_vcpus is not None:
            pulumi.set(__self__, "min_vcpus", min_vcpus)
        if placement_group is not None:
            pulumi.set(__self__, "placement_group", placement_group)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if spot_iam_fleet_role is not None:
            pulumi.set(__self__, "spot_iam_fleet_role", spot_iam_fleet_role)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="maxVcpus")
    def max_vcpus(self) -> pulumi.Input[int]:
        """
        The maximum number of EC2 vCPUs that an environment can reach.
        """
        return pulumi.get(self, "max_vcpus")

    @max_vcpus.setter
    def max_vcpus(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_vcpus", value)

    @property
    @pulumi.getter
    def subnets(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of VPC subnets into which the compute resources are launched.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "subnets", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of compute environment. Valid items are `EC2`, `SPOT`, `FARGATE` or `FARGATE_SPOT`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="allocationStrategy")
    def allocation_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The allocation strategy to use for the compute resource in case not enough instances of the best fitting instance type can be allocated. For valid values, refer to the [AWS documentation](https://docs.aws.amazon.com/batch/latest/APIReference/API_ComputeResource.html#Batch-Type-ComputeResource-allocationStrategy). Defaults to `BEST_FIT`. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "allocation_strategy")

    @allocation_strategy.setter
    def allocation_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allocation_strategy", value)

    @property
    @pulumi.getter(name="bidPercentage")
    def bid_percentage(self) -> Optional[pulumi.Input[int]]:
        """
        Integer of maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance type before instances are launched. For example, if your bid percentage is 20%!((MISSING)`20`), then the Spot price must be below 20%!o(MISSING)f the current On-Demand price for that EC2 instance. If you leave this field empty, the default value is 100%!o(MISSING)f the On-Demand price. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "bid_percentage")

    @bid_percentage.setter
    def bid_percentage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bid_percentage", value)

    @property
    @pulumi.getter(name="desiredVcpus")
    def desired_vcpus(self) -> Optional[pulumi.Input[int]]:
        """
        The desired number of EC2 vCPUS in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "desired_vcpus")

    @desired_vcpus.setter
    def desired_vcpus(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "desired_vcpus", value)

    @property
    @pulumi.getter(name="ec2Configurations")
    def ec2_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComputeEnvironmentComputeResourcesEc2ConfigurationArgs']]]]:
        """
        Provides information used to select Amazon Machine Images (AMIs) for EC2 instances in the compute environment. If Ec2Configuration isn't specified, the default is ECS_AL2. This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "ec2_configurations")

    @ec2_configurations.setter
    def ec2_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeEnvironmentComputeResourcesEc2ConfigurationArgs']]]]):
        pulumi.set(self, "ec2_configurations", value)

    @property
    @pulumi.getter(name="ec2KeyPair")
    def ec2_key_pair(self) -> Optional[pulumi.Input[str]]:
        """
        The EC2 key pair that is used for instances launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "ec2_key_pair")

    @ec2_key_pair.setter
    def ec2_key_pair(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ec2_key_pair", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Machine Image (AMI) ID used for instances launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified. (Deprecated, use `ec2_configuration` `image_id_override` instead)
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="instanceRole")
    def instance_role(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon ECS instance role applied to Amazon EC2 instances in a compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "instance_role")

    @instance_role.setter
    def instance_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_role", value)

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of instance types that may be launched. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "instance_types")

    @instance_types.setter
    def instance_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_types", value)

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> Optional[pulumi.Input['ComputeEnvironmentComputeResourcesLaunchTemplateArgs']]:
        """
        The launch template to use for your compute resources. See details below. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "launch_template")

    @launch_template.setter
    def launch_template(self, value: Optional[pulumi.Input['ComputeEnvironmentComputeResourcesLaunchTemplateArgs']]):
        pulumi.set(self, "launch_template", value)

    @property
    @pulumi.getter(name="minVcpus")
    def min_vcpus(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of EC2 vCPUs that an environment should maintain. For `EC2` or `SPOT` compute environments, if the parameter is not explicitly defined, a `0` default value will be set. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "min_vcpus")

    @min_vcpus.setter
    def min_vcpus(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_vcpus", value)

    @property
    @pulumi.getter(name="placementGroup")
    def placement_group(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon EC2 placement group to associate with your compute resources.
        """
        return pulumi.get(self, "placement_group")

    @placement_group.setter
    def placement_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement_group", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of EC2 security group that are associated with instances launched in the compute environment. This parameter is required for Fargate compute environments.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="spotIamFleetRole")
    def spot_iam_fleet_role(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the Amazon EC2 Spot Fleet IAM role applied to a SPOT compute environment. This parameter is required for SPOT compute environments. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "spot_iam_fleet_role")

    @spot_iam_fleet_role.setter
    def spot_iam_fleet_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spot_iam_fleet_role", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value pair tags to be applied to resources that are launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class ComputeEnvironmentComputeResourcesEc2ConfigurationArgs:
    def __init__(__self__, *,
                 image_id_override: Optional[pulumi.Input[str]] = None,
                 image_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] image_id_override: The AMI ID used for instances launched in the compute environment that match the image type. This setting overrides the `image_id` argument in the `compute_resources` block.
        :param pulumi.Input[str] image_type: The image type to match with the instance type to select an AMI. If the `image_id_override` parameter isn't specified, then a recent [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami) (`ECS_AL2`) is used.
        """
        if image_id_override is not None:
            pulumi.set(__self__, "image_id_override", image_id_override)
        if image_type is not None:
            pulumi.set(__self__, "image_type", image_type)

    @property
    @pulumi.getter(name="imageIdOverride")
    def image_id_override(self) -> Optional[pulumi.Input[str]]:
        """
        The AMI ID used for instances launched in the compute environment that match the image type. This setting overrides the `image_id` argument in the `compute_resources` block.
        """
        return pulumi.get(self, "image_id_override")

    @image_id_override.setter
    def image_id_override(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id_override", value)

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> Optional[pulumi.Input[str]]:
        """
        The image type to match with the instance type to select an AMI. If the `image_id_override` parameter isn't specified, then a recent [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami) (`ECS_AL2`) is used.
        """
        return pulumi.get(self, "image_type")

    @image_type.setter
    def image_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_type", value)


@pulumi.input_type
class ComputeEnvironmentComputeResourcesLaunchTemplateArgs:
    def __init__(__self__, *,
                 launch_template_id: Optional[pulumi.Input[str]] = None,
                 launch_template_name: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] launch_template_id: ID of the launch template. You must specify either the launch template ID or launch template name in the request, but not both.
        :param pulumi.Input[str] launch_template_name: Name of the launch template.
        :param pulumi.Input[str] version: The version number of the launch template. Default: The default version of the launch template.
        """
        if launch_template_id is not None:
            pulumi.set(__self__, "launch_template_id", launch_template_id)
        if launch_template_name is not None:
            pulumi.set(__self__, "launch_template_name", launch_template_name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the launch template. You must specify either the launch template ID or launch template name in the request, but not both.
        """
        return pulumi.get(self, "launch_template_id")

    @launch_template_id.setter
    def launch_template_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_template_id", value)

    @property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the launch template.
        """
        return pulumi.get(self, "launch_template_name")

    @launch_template_name.setter
    def launch_template_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_template_name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The version number of the launch template. Default: The default version of the launch template.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class ComputeEnvironmentEksConfigurationArgs:
    def __init__(__self__, *,
                 eks_cluster_arn: pulumi.Input[str],
                 kubernetes_namespace: pulumi.Input[str]):
        """
        :param pulumi.Input[str] eks_cluster_arn: The Amazon Resource Name (ARN) of the Amazon EKS cluster.
        :param pulumi.Input[str] kubernetes_namespace: The namespace of the Amazon EKS cluster. AWS Batch manages pods in this namespace.
        """
        pulumi.set(__self__, "eks_cluster_arn", eks_cluster_arn)
        pulumi.set(__self__, "kubernetes_namespace", kubernetes_namespace)

    @property
    @pulumi.getter(name="eksClusterArn")
    def eks_cluster_arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of the Amazon EKS cluster.
        """
        return pulumi.get(self, "eks_cluster_arn")

    @eks_cluster_arn.setter
    def eks_cluster_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "eks_cluster_arn", value)

    @property
    @pulumi.getter(name="kubernetesNamespace")
    def kubernetes_namespace(self) -> pulumi.Input[str]:
        """
        The namespace of the Amazon EKS cluster. AWS Batch manages pods in this namespace.
        """
        return pulumi.get(self, "kubernetes_namespace")

    @kubernetes_namespace.setter
    def kubernetes_namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "kubernetes_namespace", value)


@pulumi.input_type
class ComputeEnvironmentUpdatePolicyArgs:
    def __init__(__self__, *,
                 job_execution_timeout_minutes: pulumi.Input[int],
                 terminate_jobs_on_update: pulumi.Input[bool]):
        """
        :param pulumi.Input[int] job_execution_timeout_minutes: Specifies the job timeout (in minutes) when the compute environment infrastructure is updated.
        :param pulumi.Input[bool] terminate_jobs_on_update: Specifies whether jobs are automatically terminated when the computer environment infrastructure is updated.
        """
        pulumi.set(__self__, "job_execution_timeout_minutes", job_execution_timeout_minutes)
        pulumi.set(__self__, "terminate_jobs_on_update", terminate_jobs_on_update)

    @property
    @pulumi.getter(name="jobExecutionTimeoutMinutes")
    def job_execution_timeout_minutes(self) -> pulumi.Input[int]:
        """
        Specifies the job timeout (in minutes) when the compute environment infrastructure is updated.
        """
        return pulumi.get(self, "job_execution_timeout_minutes")

    @job_execution_timeout_minutes.setter
    def job_execution_timeout_minutes(self, value: pulumi.Input[int]):
        pulumi.set(self, "job_execution_timeout_minutes", value)

    @property
    @pulumi.getter(name="terminateJobsOnUpdate")
    def terminate_jobs_on_update(self) -> pulumi.Input[bool]:
        """
        Specifies whether jobs are automatically terminated when the computer environment infrastructure is updated.
        """
        return pulumi.get(self, "terminate_jobs_on_update")

    @terminate_jobs_on_update.setter
    def terminate_jobs_on_update(self, value: pulumi.Input[bool]):
        pulumi.set(self, "terminate_jobs_on_update", value)


@pulumi.input_type
class JobDefinitionEksPropertiesArgs:
    def __init__(__self__, *,
                 pod_properties: pulumi.Input['JobDefinitionEksPropertiesPodPropertiesArgs']):
        """
        :param pulumi.Input['JobDefinitionEksPropertiesPodPropertiesArgs'] pod_properties: The properties for the Kubernetes pod resources of a job. See `pod_properties` below.
        """
        pulumi.set(__self__, "pod_properties", pod_properties)

    @property
    @pulumi.getter(name="podProperties")
    def pod_properties(self) -> pulumi.Input['JobDefinitionEksPropertiesPodPropertiesArgs']:
        """
        The properties for the Kubernetes pod resources of a job. See `pod_properties` below.
        """
        return pulumi.get(self, "pod_properties")

    @pod_properties.setter
    def pod_properties(self, value: pulumi.Input['JobDefinitionEksPropertiesPodPropertiesArgs']):
        pulumi.set(self, "pod_properties", value)


@pulumi.input_type
class JobDefinitionEksPropertiesPodPropertiesArgs:
    def __init__(__self__, *,
                 containers: pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainersArgs'],
                 dns_policy: Optional[pulumi.Input[str]] = None,
                 host_network: Optional[pulumi.Input[bool]] = None,
                 metadata: Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesMetadataArgs']] = None,
                 service_account_name: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesVolumeArgs']]]] = None):
        """
        :param pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainersArgs'] containers: The properties of the container that's used on the Amazon EKS pod. See containers below.
        :param pulumi.Input[str] dns_policy: The DNS policy for the pod. The default value is `ClusterFirst`. If the `host_network` argument is not specified, the default is `ClusterFirstWithHostNet`. `ClusterFirst` indicates that any DNS query that does not match the configured cluster domain suffix is forwarded to the upstream nameserver inherited from the node. For more information, see Pod's DNS policy in the Kubernetes documentation.
        :param pulumi.Input[bool] host_network: Indicates if the pod uses the hosts' network IP address. The default value is `true`. Setting this to `false` enables the Kubernetes pod networking model. Most AWS Batch workloads are egress-only and don't require the overhead of IP allocation for each pod for incoming connections.
        :param pulumi.Input['JobDefinitionEksPropertiesPodPropertiesMetadataArgs'] metadata: Metadata about the Kubernetes pod.
        :param pulumi.Input[str] service_account_name: The name of the service account that's used to run the pod.
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesVolumeArgs']]] volumes: Specifies the volumes for a job definition that uses Amazon EKS resources. AWS Batch supports emptyDir, hostPath, and secret volume types.
        """
        pulumi.set(__self__, "containers", containers)
        if dns_policy is not None:
            pulumi.set(__self__, "dns_policy", dns_policy)
        if host_network is not None:
            pulumi.set(__self__, "host_network", host_network)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if service_account_name is not None:
            pulumi.set(__self__, "service_account_name", service_account_name)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter
    def containers(self) -> pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainersArgs']:
        """
        The properties of the container that's used on the Amazon EKS pod. See containers below.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainersArgs']):
        pulumi.set(self, "containers", value)

    @property
    @pulumi.getter(name="dnsPolicy")
    def dns_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The DNS policy for the pod. The default value is `ClusterFirst`. If the `host_network` argument is not specified, the default is `ClusterFirstWithHostNet`. `ClusterFirst` indicates that any DNS query that does not match the configured cluster domain suffix is forwarded to the upstream nameserver inherited from the node. For more information, see Pod's DNS policy in the Kubernetes documentation.
        """
        return pulumi.get(self, "dns_policy")

    @dns_policy.setter
    def dns_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_policy", value)

    @property
    @pulumi.getter(name="hostNetwork")
    def host_network(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the pod uses the hosts' network IP address. The default value is `true`. Setting this to `false` enables the Kubernetes pod networking model. Most AWS Batch workloads are egress-only and don't require the overhead of IP allocation for each pod for incoming connections.
        """
        return pulumi.get(self, "host_network")

    @host_network.setter
    def host_network(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "host_network", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesMetadataArgs']]:
        """
        Metadata about the Kubernetes pod.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="serviceAccountName")
    def service_account_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the service account that's used to run the pod.
        """
        return pulumi.get(self, "service_account_name")

    @service_account_name.setter
    def service_account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_name", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesVolumeArgs']]]]:
        """
        Specifies the volumes for a job definition that uses Amazon EKS resources. AWS Batch supports emptyDir, hostPath, and secret volume types.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


@pulumi.input_type
class JobDefinitionEksPropertiesPodPropertiesContainersArgs:
    def __init__(__self__, *,
                 image: pulumi.Input[str],
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 envs: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainersEnvArgs']]]] = None,
                 image_pull_policy: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 resources: Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainersResourcesArgs']] = None,
                 security_context: Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainersSecurityContextArgs']] = None,
                 volume_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainersVolumeMountArgs']]]] = None):
        """
        :param pulumi.Input[str] image: The Docker image used to start the container.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: An array of arguments to the entrypoint. If this isn't specified, the CMD of the container image is used. This corresponds to the args member in the Entrypoint portion of the Pod in Kubernetes. Environment variable references are expanded using the container's environment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] commands: The entrypoint for the container. This isn't run within a shell. If this isn't specified, the ENTRYPOINT of the container image is used. Environment variable references are expanded using the container's environment.
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainersEnvArgs']]] envs: The environment variables to pass to a container. See EKS Environment below.
        :param pulumi.Input[str] image_pull_policy: The image pull policy for the container. Supported values are `Always`, `IfNotPresent`, and `Never`.
        :param pulumi.Input[str] name: The name of the container. If the name isn't specified, the default name "Default" is used. Each container in a pod must have a unique name.
        :param pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainersResourcesArgs'] resources: The type and amount of resources to assign to a container. The supported resources include `memory`, `cpu`, and `nvidia.com/gpu`.
        :param pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainersSecurityContextArgs'] security_context: The security context for a job.
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainersVolumeMountArgs']]] volume_mounts: The volume mounts for the container.
        """
        pulumi.set(__self__, "image", image)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if image_pull_policy is not None:
            pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if security_context is not None:
            pulumi.set(__self__, "security_context", security_context)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)

    @property
    @pulumi.getter
    def image(self) -> pulumi.Input[str]:
        """
        The Docker image used to start the container.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: pulumi.Input[str]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of arguments to the entrypoint. If this isn't specified, the CMD of the container image is used. This corresponds to the args member in the Entrypoint portion of the Pod in Kubernetes. Environment variable references are expanded using the container's environment.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The entrypoint for the container. This isn't run within a shell. If this isn't specified, the ENTRYPOINT of the container image is used. Environment variable references are expanded using the container's environment.
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "commands", value)

    @property
    @pulumi.getter
    def envs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainersEnvArgs']]]]:
        """
        The environment variables to pass to a container. See EKS Environment below.
        """
        return pulumi.get(self, "envs")

    @envs.setter
    def envs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainersEnvArgs']]]]):
        pulumi.set(self, "envs", value)

    @property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The image pull policy for the container. Supported values are `Always`, `IfNotPresent`, and `Never`.
        """
        return pulumi.get(self, "image_pull_policy")

    @image_pull_policy.setter
    def image_pull_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_pull_policy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the container. If the name isn't specified, the default name "Default" is used. Each container in a pod must have a unique name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainersResourcesArgs']]:
        """
        The type and amount of resources to assign to a container. The supported resources include `memory`, `cpu`, and `nvidia.com/gpu`.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainersResourcesArgs']]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter(name="securityContext")
    def security_context(self) -> Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainersSecurityContextArgs']]:
        """
        The security context for a job.
        """
        return pulumi.get(self, "security_context")

    @security_context.setter
    def security_context(self, value: Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainersSecurityContextArgs']]):
        pulumi.set(self, "security_context", value)

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainersVolumeMountArgs']]]]:
        """
        The volume mounts for the container.
        """
        return pulumi.get(self, "volume_mounts")

    @volume_mounts.setter
    def volume_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainersVolumeMountArgs']]]]):
        pulumi.set(self, "volume_mounts", value)


@pulumi.input_type
class JobDefinitionEksPropertiesPodPropertiesContainersEnvArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: Specifies the name of the job definition.
        :param pulumi.Input[str] value: The value of the environment variable.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Specifies the name of the job definition.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class JobDefinitionEksPropertiesPodPropertiesContainersResourcesArgs:
    def __init__(__self__, *,
                 limits: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 requests: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def limits(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "limits")

    @limits.setter
    def limits(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "limits", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "requests", value)


@pulumi.input_type
class JobDefinitionEksPropertiesPodPropertiesContainersSecurityContextArgs:
    def __init__(__self__, *,
                 privileged: Optional[pulumi.Input[bool]] = None,
                 read_only_root_file_system: Optional[pulumi.Input[bool]] = None,
                 run_as_group: Optional[pulumi.Input[int]] = None,
                 run_as_non_root: Optional[pulumi.Input[bool]] = None,
                 run_as_user: Optional[pulumi.Input[int]] = None):
        if privileged is not None:
            pulumi.set(__self__, "privileged", privileged)
        if read_only_root_file_system is not None:
            pulumi.set(__self__, "read_only_root_file_system", read_only_root_file_system)
        if run_as_group is not None:
            pulumi.set(__self__, "run_as_group", run_as_group)
        if run_as_non_root is not None:
            pulumi.set(__self__, "run_as_non_root", run_as_non_root)
        if run_as_user is not None:
            pulumi.set(__self__, "run_as_user", run_as_user)

    @property
    @pulumi.getter
    def privileged(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "privileged")

    @privileged.setter
    def privileged(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "privileged", value)

    @property
    @pulumi.getter(name="readOnlyRootFileSystem")
    def read_only_root_file_system(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "read_only_root_file_system")

    @read_only_root_file_system.setter
    def read_only_root_file_system(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only_root_file_system", value)

    @property
    @pulumi.getter(name="runAsGroup")
    def run_as_group(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "run_as_group")

    @run_as_group.setter
    def run_as_group(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "run_as_group", value)

    @property
    @pulumi.getter(name="runAsNonRoot")
    def run_as_non_root(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "run_as_non_root")

    @run_as_non_root.setter
    def run_as_non_root(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "run_as_non_root", value)

    @property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "run_as_user")

    @run_as_user.setter
    def run_as_user(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "run_as_user", value)


@pulumi.input_type
class JobDefinitionEksPropertiesPodPropertiesContainersVolumeMountArgs:
    def __init__(__self__, *,
                 mount_path: pulumi.Input[str],
                 name: pulumi.Input[str],
                 read_only: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] name: Specifies the name of the job definition.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "name", name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> pulumi.Input[str]:
        return pulumi.get(self, "mount_path")

    @mount_path.setter
    def mount_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "mount_path", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Specifies the name of the job definition.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)


@pulumi.input_type
class JobDefinitionEksPropertiesPodPropertiesMetadataArgs:
    def __init__(__self__, *,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)


@pulumi.input_type
class JobDefinitionEksPropertiesPodPropertiesVolumeArgs:
    def __init__(__self__, *,
                 empty_dir: Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDirArgs']] = None,
                 host_path: Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesVolumeHostPathArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 secret: Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesVolumeSecretArgs']] = None):
        """
        :param pulumi.Input[str] name: Specifies the name of the job definition.
        """
        if empty_dir is not None:
            pulumi.set(__self__, "empty_dir", empty_dir)
        if host_path is not None:
            pulumi.set(__self__, "host_path", host_path)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter(name="emptyDir")
    def empty_dir(self) -> Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDirArgs']]:
        return pulumi.get(self, "empty_dir")

    @empty_dir.setter
    def empty_dir(self, value: Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDirArgs']]):
        pulumi.set(self, "empty_dir", value)

    @property
    @pulumi.getter(name="hostPath")
    def host_path(self) -> Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesVolumeHostPathArgs']]:
        return pulumi.get(self, "host_path")

    @host_path.setter
    def host_path(self, value: Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesVolumeHostPathArgs']]):
        pulumi.set(self, "host_path", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the job definition.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesVolumeSecretArgs']]:
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesVolumeSecretArgs']]):
        pulumi.set(self, "secret", value)


@pulumi.input_type
class JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDirArgs:
    def __init__(__self__, *,
                 size_limit: pulumi.Input[str],
                 medium: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] size_limit: The maximum size of the volume. By default, there's no maximum size defined.
        :param pulumi.Input[str] medium: The medium to store the volume. The default value is an empty string, which uses the storage of the node.
        """
        pulumi.set(__self__, "size_limit", size_limit)
        if medium is not None:
            pulumi.set(__self__, "medium", medium)

    @property
    @pulumi.getter(name="sizeLimit")
    def size_limit(self) -> pulumi.Input[str]:
        """
        The maximum size of the volume. By default, there's no maximum size defined.
        """
        return pulumi.get(self, "size_limit")

    @size_limit.setter
    def size_limit(self, value: pulumi.Input[str]):
        pulumi.set(self, "size_limit", value)

    @property
    @pulumi.getter
    def medium(self) -> Optional[pulumi.Input[str]]:
        """
        The medium to store the volume. The default value is an empty string, which uses the storage of the node.
        """
        return pulumi.get(self, "medium")

    @medium.setter
    def medium(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "medium", value)


@pulumi.input_type
class JobDefinitionEksPropertiesPodPropertiesVolumeHostPathArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[str]):
        """
        :param pulumi.Input[str] path: The path of the file or directory on the host to mount into containers on the pod.
        """
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        The path of the file or directory on the host to mount into containers on the pod.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class JobDefinitionEksPropertiesPodPropertiesVolumeSecretArgs:
    def __init__(__self__, *,
                 secret_name: pulumi.Input[str],
                 optional: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] secret_name: The name of the secret. The name must be allowed as a DNS subdomain name.
        :param pulumi.Input[bool] optional: Specifies whether the secret or the secret's keys must be defined.
        """
        pulumi.set(__self__, "secret_name", secret_name)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> pulumi.Input[str]:
        """
        The name of the secret. The name must be allowed as a DNS subdomain name.
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_name", value)

    @property
    @pulumi.getter
    def optional(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the secret or the secret's keys must be defined.
        """
        return pulumi.get(self, "optional")

    @optional.setter
    def optional(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "optional", value)


@pulumi.input_type
class JobDefinitionRetryStrategyArgs:
    def __init__(__self__, *,
                 attempts: Optional[pulumi.Input[int]] = None,
                 evaluate_on_exits: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionRetryStrategyEvaluateOnExitArgs']]]] = None):
        """
        :param pulumi.Input[int] attempts: The number of times to move a job to the `RUNNABLE` status. You may specify between `1` and `10` attempts.
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionRetryStrategyEvaluateOnExitArgs']]] evaluate_on_exits: The evaluate on exit conditions under which the job should be retried or failed. If this parameter is specified, then the `attempts` parameter must also be specified. You may specify up to 5 configuration blocks.
        """
        if attempts is not None:
            pulumi.set(__self__, "attempts", attempts)
        if evaluate_on_exits is not None:
            pulumi.set(__self__, "evaluate_on_exits", evaluate_on_exits)

    @property
    @pulumi.getter
    def attempts(self) -> Optional[pulumi.Input[int]]:
        """
        The number of times to move a job to the `RUNNABLE` status. You may specify between `1` and `10` attempts.
        """
        return pulumi.get(self, "attempts")

    @attempts.setter
    def attempts(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "attempts", value)

    @property
    @pulumi.getter(name="evaluateOnExits")
    def evaluate_on_exits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionRetryStrategyEvaluateOnExitArgs']]]]:
        """
        The evaluate on exit conditions under which the job should be retried or failed. If this parameter is specified, then the `attempts` parameter must also be specified. You may specify up to 5 configuration blocks.
        """
        return pulumi.get(self, "evaluate_on_exits")

    @evaluate_on_exits.setter
    def evaluate_on_exits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionRetryStrategyEvaluateOnExitArgs']]]]):
        pulumi.set(self, "evaluate_on_exits", value)


@pulumi.input_type
class JobDefinitionRetryStrategyEvaluateOnExitArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[str],
                 on_exit_code: Optional[pulumi.Input[str]] = None,
                 on_reason: Optional[pulumi.Input[str]] = None,
                 on_status_reason: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] action: Specifies the action to take if all of the specified conditions are met. The values are not case sensitive. Valid values: `RETRY`, `EXIT`.
        :param pulumi.Input[str] on_exit_code: A glob pattern to match against the decimal representation of the exit code returned for a job.
        :param pulumi.Input[str] on_reason: A glob pattern to match against the reason returned for a job.
        :param pulumi.Input[str] on_status_reason: A glob pattern to match against the status reason returned for a job.
        """
        pulumi.set(__self__, "action", action)
        if on_exit_code is not None:
            pulumi.set(__self__, "on_exit_code", on_exit_code)
        if on_reason is not None:
            pulumi.set(__self__, "on_reason", on_reason)
        if on_status_reason is not None:
            pulumi.set(__self__, "on_status_reason", on_status_reason)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[str]:
        """
        Specifies the action to take if all of the specified conditions are met. The values are not case sensitive. Valid values: `RETRY`, `EXIT`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="onExitCode")
    def on_exit_code(self) -> Optional[pulumi.Input[str]]:
        """
        A glob pattern to match against the decimal representation of the exit code returned for a job.
        """
        return pulumi.get(self, "on_exit_code")

    @on_exit_code.setter
    def on_exit_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "on_exit_code", value)

    @property
    @pulumi.getter(name="onReason")
    def on_reason(self) -> Optional[pulumi.Input[str]]:
        """
        A glob pattern to match against the reason returned for a job.
        """
        return pulumi.get(self, "on_reason")

    @on_reason.setter
    def on_reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "on_reason", value)

    @property
    @pulumi.getter(name="onStatusReason")
    def on_status_reason(self) -> Optional[pulumi.Input[str]]:
        """
        A glob pattern to match against the status reason returned for a job.
        """
        return pulumi.get(self, "on_status_reason")

    @on_status_reason.setter
    def on_status_reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "on_status_reason", value)


@pulumi.input_type
class JobDefinitionTimeoutArgs:
    def __init__(__self__, *,
                 attempt_duration_seconds: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] attempt_duration_seconds: The time duration in seconds after which AWS Batch terminates your jobs if they have not finished. The minimum value for the timeout is `60` seconds.
        """
        if attempt_duration_seconds is not None:
            pulumi.set(__self__, "attempt_duration_seconds", attempt_duration_seconds)

    @property
    @pulumi.getter(name="attemptDurationSeconds")
    def attempt_duration_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The time duration in seconds after which AWS Batch terminates your jobs if they have not finished. The minimum value for the timeout is `60` seconds.
        """
        return pulumi.get(self, "attempt_duration_seconds")

    @attempt_duration_seconds.setter
    def attempt_duration_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "attempt_duration_seconds", value)


@pulumi.input_type
class JobQueueComputeEnvironmentOrderArgs:
    def __init__(__self__, *,
                 compute_environment: pulumi.Input[str],
                 order: pulumi.Input[int]):
        """
        :param pulumi.Input[str] compute_environment: The Amazon Resource Name (ARN) of the compute environment.
        :param pulumi.Input[int] order: The order of the compute environment. Compute environments are tried in ascending order. For example, if two compute environments are associated with a job queue, the compute environment with a lower order integer value is tried for job placement first.
        """
        pulumi.set(__self__, "compute_environment", compute_environment)
        pulumi.set(__self__, "order", order)

    @property
    @pulumi.getter(name="computeEnvironment")
    def compute_environment(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of the compute environment.
        """
        return pulumi.get(self, "compute_environment")

    @compute_environment.setter
    def compute_environment(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_environment", value)

    @property
    @pulumi.getter
    def order(self) -> pulumi.Input[int]:
        """
        The order of the compute environment. Compute environments are tried in ascending order. For example, if two compute environments are associated with a job queue, the compute environment with a lower order integer value is tried for job placement first.
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: pulumi.Input[int]):
        pulumi.set(self, "order", value)


@pulumi.input_type
class JobQueueTimeoutsArgs:
    def __init__(__self__, *,
                 create: Optional[pulumi.Input[str]] = None,
                 delete: Optional[pulumi.Input[str]] = None,
                 update: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param pulumi.Input[str] delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param pulumi.Input[str] update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[pulumi.Input[str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @create.setter
    def create(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create", value)

    @property
    @pulumi.getter
    def delete(self) -> Optional[pulumi.Input[str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @delete.setter
    def delete(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delete", value)

    @property
    @pulumi.getter
    def update(self) -> Optional[pulumi.Input[str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")

    @update.setter
    def update(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update", value)


@pulumi.input_type
class SchedulingPolicyFairSharePolicyArgs:
    def __init__(__self__, *,
                 compute_reservation: Optional[pulumi.Input[int]] = None,
                 share_decay_seconds: Optional[pulumi.Input[int]] = None,
                 share_distributions: Optional[pulumi.Input[Sequence[pulumi.Input['SchedulingPolicyFairSharePolicyShareDistributionArgs']]]] = None):
        """
        :param pulumi.Input[int] compute_reservation: A value used to reserve some of the available maximum vCPU for fair share identifiers that have not yet been used. For more information, see [FairsharePolicy](https://docs.aws.amazon.com/batch/latest/APIReference/API_FairsharePolicy.html).
        :param pulumi.Input[Sequence[pulumi.Input['SchedulingPolicyFairSharePolicyShareDistributionArgs']]] share_distributions: One or more share distribution blocks which define the weights for the fair share identifiers for the fair share policy. For more information, see [FairsharePolicy](https://docs.aws.amazon.com/batch/latest/APIReference/API_FairsharePolicy.html). The `share_distribution` block is documented below.
        """
        if compute_reservation is not None:
            pulumi.set(__self__, "compute_reservation", compute_reservation)
        if share_decay_seconds is not None:
            pulumi.set(__self__, "share_decay_seconds", share_decay_seconds)
        if share_distributions is not None:
            pulumi.set(__self__, "share_distributions", share_distributions)

    @property
    @pulumi.getter(name="computeReservation")
    def compute_reservation(self) -> Optional[pulumi.Input[int]]:
        """
        A value used to reserve some of the available maximum vCPU for fair share identifiers that have not yet been used. For more information, see [FairsharePolicy](https://docs.aws.amazon.com/batch/latest/APIReference/API_FairsharePolicy.html).
        """
        return pulumi.get(self, "compute_reservation")

    @compute_reservation.setter
    def compute_reservation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "compute_reservation", value)

    @property
    @pulumi.getter(name="shareDecaySeconds")
    def share_decay_seconds(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "share_decay_seconds")

    @share_decay_seconds.setter
    def share_decay_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "share_decay_seconds", value)

    @property
    @pulumi.getter(name="shareDistributions")
    def share_distributions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SchedulingPolicyFairSharePolicyShareDistributionArgs']]]]:
        """
        One or more share distribution blocks which define the weights for the fair share identifiers for the fair share policy. For more information, see [FairsharePolicy](https://docs.aws.amazon.com/batch/latest/APIReference/API_FairsharePolicy.html). The `share_distribution` block is documented below.
        """
        return pulumi.get(self, "share_distributions")

    @share_distributions.setter
    def share_distributions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SchedulingPolicyFairSharePolicyShareDistributionArgs']]]]):
        pulumi.set(self, "share_distributions", value)


@pulumi.input_type
class SchedulingPolicyFairSharePolicyShareDistributionArgs:
    def __init__(__self__, *,
                 share_identifier: pulumi.Input[str],
                 weight_factor: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[str] share_identifier: A fair share identifier or fair share identifier prefix. For more information, see [ShareAttributes](https://docs.aws.amazon.com/batch/latest/APIReference/API_ShareAttributes.html).
        :param pulumi.Input[float] weight_factor: The weight factor for the fair share identifier. For more information, see [ShareAttributes](https://docs.aws.amazon.com/batch/latest/APIReference/API_ShareAttributes.html).
        """
        pulumi.set(__self__, "share_identifier", share_identifier)
        if weight_factor is not None:
            pulumi.set(__self__, "weight_factor", weight_factor)

    @property
    @pulumi.getter(name="shareIdentifier")
    def share_identifier(self) -> pulumi.Input[str]:
        """
        A fair share identifier or fair share identifier prefix. For more information, see [ShareAttributes](https://docs.aws.amazon.com/batch/latest/APIReference/API_ShareAttributes.html).
        """
        return pulumi.get(self, "share_identifier")

    @share_identifier.setter
    def share_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "share_identifier", value)

    @property
    @pulumi.getter(name="weightFactor")
    def weight_factor(self) -> Optional[pulumi.Input[float]]:
        """
        The weight factor for the fair share identifier. For more information, see [ShareAttributes](https://docs.aws.amazon.com/batch/latest/APIReference/API_ShareAttributes.html).
        """
        return pulumi.get(self, "weight_factor")

    @weight_factor.setter
    def weight_factor(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "weight_factor", value)


