# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BudgetArgs', 'Budget']

@pulumi.input_type
class BudgetArgs:
    def __init__(__self__, *,
                 budget_type: pulumi.Input[str],
                 time_unit: pulumi.Input[str],
                 account_id: Optional[pulumi.Input[str]] = None,
                 auto_adjust_data: Optional[pulumi.Input['BudgetAutoAdjustDataArgs']] = None,
                 cost_filters: Optional[pulumi.Input[Sequence[pulumi.Input['BudgetCostFilterArgs']]]] = None,
                 cost_types: Optional[pulumi.Input['BudgetCostTypesArgs']] = None,
                 limit_amount: Optional[pulumi.Input[str]] = None,
                 limit_unit: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input['BudgetNotificationArgs']]]] = None,
                 planned_limits: Optional[pulumi.Input[Sequence[pulumi.Input['BudgetPlannedLimitArgs']]]] = None,
                 time_period_end: Optional[pulumi.Input[str]] = None,
                 time_period_start: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Budget resource.
        :param pulumi.Input[str] budget_type: Whether this budget tracks monetary cost or usage.
        :param pulumi.Input[str] time_unit: The length of time until a budget resets the actual and forecasted spend. Valid values: `MONTHLY`, `QUARTERLY`, `ANNUALLY`, and `DAILY`.
        :param pulumi.Input[str] account_id: The ID of the target account for budget. Will use current user's account_id by default if omitted.
        :param pulumi.Input['BudgetAutoAdjustDataArgs'] auto_adjust_data: Object containing [AutoAdjustData] which determines the budget amount for an auto-adjusting budget.
        :param pulumi.Input[Sequence[pulumi.Input['BudgetCostFilterArgs']]] cost_filters: A list of CostFilter name/values pair to apply to budget.
        :param pulumi.Input['BudgetCostTypesArgs'] cost_types: Object containing CostTypes The types of cost included in a budget, such as tax and subscriptions.
        :param pulumi.Input[str] limit_amount: The amount of cost or usage being measured for a budget.
        :param pulumi.Input[str] limit_unit: The unit of measurement used for the budget forecast, actual spend, or budget threshold, such as dollars or GB. See [Spend](http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/data-type-spend.html) documentation.
        :param pulumi.Input[str] name: The name of a budget. Unique within accounts.
        :param pulumi.Input[str] name_prefix: The prefix of the name of a budget. Unique within accounts.
        :param pulumi.Input[Sequence[pulumi.Input['BudgetNotificationArgs']]] notifications: Object containing Budget Notifications. Can be used multiple times to define more than one budget notification.
        :param pulumi.Input[Sequence[pulumi.Input['BudgetPlannedLimitArgs']]] planned_limits: Object containing Planned Budget Limits. Can be used multiple times to plan more than one budget limit. See [PlannedBudgetLimits](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_Budget.html#awscostmanagement-Type-budgets_Budget-PlannedBudgetLimits) documentation.
        :param pulumi.Input[str] time_period_end: The end of the time period covered by the budget. There are no restrictions on the end date. Format: `2017-01-01_12:00`.
        :param pulumi.Input[str] time_period_start: The start of the time period covered by the budget. If you don't specify a start date, AWS defaults to the start of your chosen time period. The start date must come before the end date. Format: `2017-01-01_12:00`.
        """
        pulumi.set(__self__, "budget_type", budget_type)
        pulumi.set(__self__, "time_unit", time_unit)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if auto_adjust_data is not None:
            pulumi.set(__self__, "auto_adjust_data", auto_adjust_data)
        if cost_filters is not None:
            pulumi.set(__self__, "cost_filters", cost_filters)
        if cost_types is not None:
            pulumi.set(__self__, "cost_types", cost_types)
        if limit_amount is not None:
            pulumi.set(__self__, "limit_amount", limit_amount)
        if limit_unit is not None:
            pulumi.set(__self__, "limit_unit", limit_unit)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)
        if planned_limits is not None:
            pulumi.set(__self__, "planned_limits", planned_limits)
        if time_period_end is not None:
            pulumi.set(__self__, "time_period_end", time_period_end)
        if time_period_start is not None:
            pulumi.set(__self__, "time_period_start", time_period_start)

    @property
    @pulumi.getter(name="budgetType")
    def budget_type(self) -> pulumi.Input[str]:
        """
        Whether this budget tracks monetary cost or usage.
        """
        return pulumi.get(self, "budget_type")

    @budget_type.setter
    def budget_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "budget_type", value)

    @property
    @pulumi.getter(name="timeUnit")
    def time_unit(self) -> pulumi.Input[str]:
        """
        The length of time until a budget resets the actual and forecasted spend. Valid values: `MONTHLY`, `QUARTERLY`, `ANNUALLY`, and `DAILY`.
        """
        return pulumi.get(self, "time_unit")

    @time_unit.setter
    def time_unit(self, value: pulumi.Input[str]):
        pulumi.set(self, "time_unit", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the target account for budget. Will use current user's account_id by default if omitted.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="autoAdjustData")
    def auto_adjust_data(self) -> Optional[pulumi.Input['BudgetAutoAdjustDataArgs']]:
        """
        Object containing [AutoAdjustData] which determines the budget amount for an auto-adjusting budget.
        """
        return pulumi.get(self, "auto_adjust_data")

    @auto_adjust_data.setter
    def auto_adjust_data(self, value: Optional[pulumi.Input['BudgetAutoAdjustDataArgs']]):
        pulumi.set(self, "auto_adjust_data", value)

    @property
    @pulumi.getter(name="costFilters")
    def cost_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BudgetCostFilterArgs']]]]:
        """
        A list of CostFilter name/values pair to apply to budget.
        """
        return pulumi.get(self, "cost_filters")

    @cost_filters.setter
    def cost_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BudgetCostFilterArgs']]]]):
        pulumi.set(self, "cost_filters", value)

    @property
    @pulumi.getter(name="costTypes")
    def cost_types(self) -> Optional[pulumi.Input['BudgetCostTypesArgs']]:
        """
        Object containing CostTypes The types of cost included in a budget, such as tax and subscriptions.
        """
        return pulumi.get(self, "cost_types")

    @cost_types.setter
    def cost_types(self, value: Optional[pulumi.Input['BudgetCostTypesArgs']]):
        pulumi.set(self, "cost_types", value)

    @property
    @pulumi.getter(name="limitAmount")
    def limit_amount(self) -> Optional[pulumi.Input[str]]:
        """
        The amount of cost or usage being measured for a budget.
        """
        return pulumi.get(self, "limit_amount")

    @limit_amount.setter
    def limit_amount(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "limit_amount", value)

    @property
    @pulumi.getter(name="limitUnit")
    def limit_unit(self) -> Optional[pulumi.Input[str]]:
        """
        The unit of measurement used for the budget forecast, actual spend, or budget threshold, such as dollars or GB. See [Spend](http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/data-type-spend.html) documentation.
        """
        return pulumi.get(self, "limit_unit")

    @limit_unit.setter
    def limit_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "limit_unit", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a budget. Unique within accounts.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The prefix of the name of a budget. Unique within accounts.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter
    def notifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BudgetNotificationArgs']]]]:
        """
        Object containing Budget Notifications. Can be used multiple times to define more than one budget notification.
        """
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BudgetNotificationArgs']]]]):
        pulumi.set(self, "notifications", value)

    @property
    @pulumi.getter(name="plannedLimits")
    def planned_limits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BudgetPlannedLimitArgs']]]]:
        """
        Object containing Planned Budget Limits. Can be used multiple times to plan more than one budget limit. See [PlannedBudgetLimits](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_Budget.html#awscostmanagement-Type-budgets_Budget-PlannedBudgetLimits) documentation.
        """
        return pulumi.get(self, "planned_limits")

    @planned_limits.setter
    def planned_limits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BudgetPlannedLimitArgs']]]]):
        pulumi.set(self, "planned_limits", value)

    @property
    @pulumi.getter(name="timePeriodEnd")
    def time_period_end(self) -> Optional[pulumi.Input[str]]:
        """
        The end of the time period covered by the budget. There are no restrictions on the end date. Format: `2017-01-01_12:00`.
        """
        return pulumi.get(self, "time_period_end")

    @time_period_end.setter
    def time_period_end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_period_end", value)

    @property
    @pulumi.getter(name="timePeriodStart")
    def time_period_start(self) -> Optional[pulumi.Input[str]]:
        """
        The start of the time period covered by the budget. If you don't specify a start date, AWS defaults to the start of your chosen time period. The start date must come before the end date. Format: `2017-01-01_12:00`.
        """
        return pulumi.get(self, "time_period_start")

    @time_period_start.setter
    def time_period_start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_period_start", value)


@pulumi.input_type
class _BudgetState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 auto_adjust_data: Optional[pulumi.Input['BudgetAutoAdjustDataArgs']] = None,
                 budget_type: Optional[pulumi.Input[str]] = None,
                 cost_filters: Optional[pulumi.Input[Sequence[pulumi.Input['BudgetCostFilterArgs']]]] = None,
                 cost_types: Optional[pulumi.Input['BudgetCostTypesArgs']] = None,
                 limit_amount: Optional[pulumi.Input[str]] = None,
                 limit_unit: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input['BudgetNotificationArgs']]]] = None,
                 planned_limits: Optional[pulumi.Input[Sequence[pulumi.Input['BudgetPlannedLimitArgs']]]] = None,
                 time_period_end: Optional[pulumi.Input[str]] = None,
                 time_period_start: Optional[pulumi.Input[str]] = None,
                 time_unit: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Budget resources.
        :param pulumi.Input[str] account_id: The ID of the target account for budget. Will use current user's account_id by default if omitted.
        :param pulumi.Input[str] arn: The ARN of the budget.
        :param pulumi.Input['BudgetAutoAdjustDataArgs'] auto_adjust_data: Object containing [AutoAdjustData] which determines the budget amount for an auto-adjusting budget.
        :param pulumi.Input[str] budget_type: Whether this budget tracks monetary cost or usage.
        :param pulumi.Input[Sequence[pulumi.Input['BudgetCostFilterArgs']]] cost_filters: A list of CostFilter name/values pair to apply to budget.
        :param pulumi.Input['BudgetCostTypesArgs'] cost_types: Object containing CostTypes The types of cost included in a budget, such as tax and subscriptions.
        :param pulumi.Input[str] limit_amount: The amount of cost or usage being measured for a budget.
        :param pulumi.Input[str] limit_unit: The unit of measurement used for the budget forecast, actual spend, or budget threshold, such as dollars or GB. See [Spend](http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/data-type-spend.html) documentation.
        :param pulumi.Input[str] name: The name of a budget. Unique within accounts.
        :param pulumi.Input[str] name_prefix: The prefix of the name of a budget. Unique within accounts.
        :param pulumi.Input[Sequence[pulumi.Input['BudgetNotificationArgs']]] notifications: Object containing Budget Notifications. Can be used multiple times to define more than one budget notification.
        :param pulumi.Input[Sequence[pulumi.Input['BudgetPlannedLimitArgs']]] planned_limits: Object containing Planned Budget Limits. Can be used multiple times to plan more than one budget limit. See [PlannedBudgetLimits](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_Budget.html#awscostmanagement-Type-budgets_Budget-PlannedBudgetLimits) documentation.
        :param pulumi.Input[str] time_period_end: The end of the time period covered by the budget. There are no restrictions on the end date. Format: `2017-01-01_12:00`.
        :param pulumi.Input[str] time_period_start: The start of the time period covered by the budget. If you don't specify a start date, AWS defaults to the start of your chosen time period. The start date must come before the end date. Format: `2017-01-01_12:00`.
        :param pulumi.Input[str] time_unit: The length of time until a budget resets the actual and forecasted spend. Valid values: `MONTHLY`, `QUARTERLY`, `ANNUALLY`, and `DAILY`.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if auto_adjust_data is not None:
            pulumi.set(__self__, "auto_adjust_data", auto_adjust_data)
        if budget_type is not None:
            pulumi.set(__self__, "budget_type", budget_type)
        if cost_filters is not None:
            pulumi.set(__self__, "cost_filters", cost_filters)
        if cost_types is not None:
            pulumi.set(__self__, "cost_types", cost_types)
        if limit_amount is not None:
            pulumi.set(__self__, "limit_amount", limit_amount)
        if limit_unit is not None:
            pulumi.set(__self__, "limit_unit", limit_unit)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)
        if planned_limits is not None:
            pulumi.set(__self__, "planned_limits", planned_limits)
        if time_period_end is not None:
            pulumi.set(__self__, "time_period_end", time_period_end)
        if time_period_start is not None:
            pulumi.set(__self__, "time_period_start", time_period_start)
        if time_unit is not None:
            pulumi.set(__self__, "time_unit", time_unit)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the target account for budget. Will use current user's account_id by default if omitted.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the budget.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="autoAdjustData")
    def auto_adjust_data(self) -> Optional[pulumi.Input['BudgetAutoAdjustDataArgs']]:
        """
        Object containing [AutoAdjustData] which determines the budget amount for an auto-adjusting budget.
        """
        return pulumi.get(self, "auto_adjust_data")

    @auto_adjust_data.setter
    def auto_adjust_data(self, value: Optional[pulumi.Input['BudgetAutoAdjustDataArgs']]):
        pulumi.set(self, "auto_adjust_data", value)

    @property
    @pulumi.getter(name="budgetType")
    def budget_type(self) -> Optional[pulumi.Input[str]]:
        """
        Whether this budget tracks monetary cost or usage.
        """
        return pulumi.get(self, "budget_type")

    @budget_type.setter
    def budget_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "budget_type", value)

    @property
    @pulumi.getter(name="costFilters")
    def cost_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BudgetCostFilterArgs']]]]:
        """
        A list of CostFilter name/values pair to apply to budget.
        """
        return pulumi.get(self, "cost_filters")

    @cost_filters.setter
    def cost_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BudgetCostFilterArgs']]]]):
        pulumi.set(self, "cost_filters", value)

    @property
    @pulumi.getter(name="costTypes")
    def cost_types(self) -> Optional[pulumi.Input['BudgetCostTypesArgs']]:
        """
        Object containing CostTypes The types of cost included in a budget, such as tax and subscriptions.
        """
        return pulumi.get(self, "cost_types")

    @cost_types.setter
    def cost_types(self, value: Optional[pulumi.Input['BudgetCostTypesArgs']]):
        pulumi.set(self, "cost_types", value)

    @property
    @pulumi.getter(name="limitAmount")
    def limit_amount(self) -> Optional[pulumi.Input[str]]:
        """
        The amount of cost or usage being measured for a budget.
        """
        return pulumi.get(self, "limit_amount")

    @limit_amount.setter
    def limit_amount(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "limit_amount", value)

    @property
    @pulumi.getter(name="limitUnit")
    def limit_unit(self) -> Optional[pulumi.Input[str]]:
        """
        The unit of measurement used for the budget forecast, actual spend, or budget threshold, such as dollars or GB. See [Spend](http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/data-type-spend.html) documentation.
        """
        return pulumi.get(self, "limit_unit")

    @limit_unit.setter
    def limit_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "limit_unit", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a budget. Unique within accounts.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The prefix of the name of a budget. Unique within accounts.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter
    def notifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BudgetNotificationArgs']]]]:
        """
        Object containing Budget Notifications. Can be used multiple times to define more than one budget notification.
        """
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BudgetNotificationArgs']]]]):
        pulumi.set(self, "notifications", value)

    @property
    @pulumi.getter(name="plannedLimits")
    def planned_limits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BudgetPlannedLimitArgs']]]]:
        """
        Object containing Planned Budget Limits. Can be used multiple times to plan more than one budget limit. See [PlannedBudgetLimits](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_Budget.html#awscostmanagement-Type-budgets_Budget-PlannedBudgetLimits) documentation.
        """
        return pulumi.get(self, "planned_limits")

    @planned_limits.setter
    def planned_limits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BudgetPlannedLimitArgs']]]]):
        pulumi.set(self, "planned_limits", value)

    @property
    @pulumi.getter(name="timePeriodEnd")
    def time_period_end(self) -> Optional[pulumi.Input[str]]:
        """
        The end of the time period covered by the budget. There are no restrictions on the end date. Format: `2017-01-01_12:00`.
        """
        return pulumi.get(self, "time_period_end")

    @time_period_end.setter
    def time_period_end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_period_end", value)

    @property
    @pulumi.getter(name="timePeriodStart")
    def time_period_start(self) -> Optional[pulumi.Input[str]]:
        """
        The start of the time period covered by the budget. If you don't specify a start date, AWS defaults to the start of your chosen time period. The start date must come before the end date. Format: `2017-01-01_12:00`.
        """
        return pulumi.get(self, "time_period_start")

    @time_period_start.setter
    def time_period_start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_period_start", value)

    @property
    @pulumi.getter(name="timeUnit")
    def time_unit(self) -> Optional[pulumi.Input[str]]:
        """
        The length of time until a budget resets the actual and forecasted spend. Valid values: `MONTHLY`, `QUARTERLY`, `ANNUALLY`, and `DAILY`.
        """
        return pulumi.get(self, "time_unit")

    @time_unit.setter
    def time_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_unit", value)


class Budget(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 auto_adjust_data: Optional[pulumi.Input[pulumi.InputType['BudgetAutoAdjustDataArgs']]] = None,
                 budget_type: Optional[pulumi.Input[str]] = None,
                 cost_filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BudgetCostFilterArgs']]]]] = None,
                 cost_types: Optional[pulumi.Input[pulumi.InputType['BudgetCostTypesArgs']]] = None,
                 limit_amount: Optional[pulumi.Input[str]] = None,
                 limit_unit: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BudgetNotificationArgs']]]]] = None,
                 planned_limits: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BudgetPlannedLimitArgs']]]]] = None,
                 time_period_end: Optional[pulumi.Input[str]] = None,
                 time_period_start: Optional[pulumi.Input[str]] = None,
                 time_unit: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a budgets budget resource. Budgets use the cost visualisation provided by Cost Explorer to show you the status of your budgets, to provide forecasts of your estimated costs, and to track your AWS usage, including your free tier usage.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        ec2 = aws.budgets.Budget("ec2",
            name="budget-ec2-monthly",
            budget_type="COST",
            limit_amount="1200",
            limit_unit="USD",
            time_period_end="2087-06-15_00:00",
            time_period_start="2017-07-01_00:00",
            time_unit="MONTHLY",
            cost_filters=[aws.budgets.BudgetCostFilterArgs(
                name="Service",
                values=["Amazon Elastic Compute Cloud - Compute"],
            )],
            notifications=[aws.budgets.BudgetNotificationArgs(
                comparison_operator="GREATER_THAN",
                threshold=100,
                threshold_type="PERCENTAGE",
                notification_type="FORECASTED",
                subscriber_email_addresses=["test@example.com"],
            )])
        ```
        <!--End PulumiCodeChooser -->

        Create a budget for *$100*.

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        cost = aws.budgets.Budget("cost",
            budget_type="COST",
            limit_amount="100",
            limit_unit="USD")
        ```
        <!--End PulumiCodeChooser -->

        Create a budget with planned budget limits.

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        cost = aws.budgets.Budget("cost", planned_limits=[
            aws.budgets.BudgetPlannedLimitArgs(
                start_time="2017-07-01_00:00",
                amount="100",
                unit="USD",
            ),
            aws.budgets.BudgetPlannedLimitArgs(
                start_time="2017-08-01_00:00",
                amount="200",
                unit="USD",
            ),
        ])
        ```
        <!--End PulumiCodeChooser -->

        Create a budget for s3 with a limit of *3 GB* of storage.

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        s3 = aws.budgets.Budget("s3",
            budget_type="USAGE",
            limit_amount="3",
            limit_unit="GB")
        ```
        <!--End PulumiCodeChooser -->

        Create a Savings Plan Utilization Budget

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        savings_plan_utilization = aws.budgets.Budget("savings_plan_utilization",
            budget_type="SAVINGS_PLANS_UTILIZATION",
            limit_amount="100.0",
            limit_unit="PERCENTAGE",
            cost_types=aws.budgets.BudgetCostTypesArgs(
                include_credit=False,
                include_discount=False,
                include_other_subscription=False,
                include_recurring=False,
                include_refund=False,
                include_subscription=True,
                include_support=False,
                include_tax=False,
                include_upfront=False,
                use_blended=False,
            ))
        ```
        <!--End PulumiCodeChooser -->

        Create a RI Utilization Budget

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        ri_utilization = aws.budgets.Budget("ri_utilization",
            budget_type="RI_UTILIZATION",
            limit_amount="100.0",
            limit_unit="PERCENTAGE",
            cost_types=aws.budgets.BudgetCostTypesArgs(
                include_credit=False,
                include_discount=False,
                include_other_subscription=False,
                include_recurring=False,
                include_refund=False,
                include_subscription=True,
                include_support=False,
                include_tax=False,
                include_upfront=False,
                use_blended=False,
            ),
            cost_filters=[aws.budgets.BudgetCostFilterArgs(
                name="Service",
                values=["Amazon Relational Database Service"],
            )])
        ```
        <!--End PulumiCodeChooser -->

        Create a Cost Filter using Resource Tags

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        cost = aws.budgets.Budget("cost", cost_filters=[aws.budgets.BudgetCostFilterArgs(
            name="TagKeyValue",
            values=["TagKey$TagValue"],
        )])
        ```
        <!--End PulumiCodeChooser -->

        Create a cost_filter using resource tags, obtaining the tag value from a variable

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        cost = aws.budgets.Budget("cost", cost_filters=[aws.budgets.BudgetCostFilterArgs(
            name="TagKeyValue",
            values=[f"TagKey{'$'}{tag_value}"],
        )])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import budgets using `AccountID:BudgetName`. For example:

        ```sh
        $ pulumi import aws:budgets/budget:Budget myBudget 123456789012:myBudget
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The ID of the target account for budget. Will use current user's account_id by default if omitted.
        :param pulumi.Input[pulumi.InputType['BudgetAutoAdjustDataArgs']] auto_adjust_data: Object containing [AutoAdjustData] which determines the budget amount for an auto-adjusting budget.
        :param pulumi.Input[str] budget_type: Whether this budget tracks monetary cost or usage.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BudgetCostFilterArgs']]]] cost_filters: A list of CostFilter name/values pair to apply to budget.
        :param pulumi.Input[pulumi.InputType['BudgetCostTypesArgs']] cost_types: Object containing CostTypes The types of cost included in a budget, such as tax and subscriptions.
        :param pulumi.Input[str] limit_amount: The amount of cost or usage being measured for a budget.
        :param pulumi.Input[str] limit_unit: The unit of measurement used for the budget forecast, actual spend, or budget threshold, such as dollars or GB. See [Spend](http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/data-type-spend.html) documentation.
        :param pulumi.Input[str] name: The name of a budget. Unique within accounts.
        :param pulumi.Input[str] name_prefix: The prefix of the name of a budget. Unique within accounts.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BudgetNotificationArgs']]]] notifications: Object containing Budget Notifications. Can be used multiple times to define more than one budget notification.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BudgetPlannedLimitArgs']]]] planned_limits: Object containing Planned Budget Limits. Can be used multiple times to plan more than one budget limit. See [PlannedBudgetLimits](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_Budget.html#awscostmanagement-Type-budgets_Budget-PlannedBudgetLimits) documentation.
        :param pulumi.Input[str] time_period_end: The end of the time period covered by the budget. There are no restrictions on the end date. Format: `2017-01-01_12:00`.
        :param pulumi.Input[str] time_period_start: The start of the time period covered by the budget. If you don't specify a start date, AWS defaults to the start of your chosen time period. The start date must come before the end date. Format: `2017-01-01_12:00`.
        :param pulumi.Input[str] time_unit: The length of time until a budget resets the actual and forecasted spend. Valid values: `MONTHLY`, `QUARTERLY`, `ANNUALLY`, and `DAILY`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BudgetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a budgets budget resource. Budgets use the cost visualisation provided by Cost Explorer to show you the status of your budgets, to provide forecasts of your estimated costs, and to track your AWS usage, including your free tier usage.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        ec2 = aws.budgets.Budget("ec2",
            name="budget-ec2-monthly",
            budget_type="COST",
            limit_amount="1200",
            limit_unit="USD",
            time_period_end="2087-06-15_00:00",
            time_period_start="2017-07-01_00:00",
            time_unit="MONTHLY",
            cost_filters=[aws.budgets.BudgetCostFilterArgs(
                name="Service",
                values=["Amazon Elastic Compute Cloud - Compute"],
            )],
            notifications=[aws.budgets.BudgetNotificationArgs(
                comparison_operator="GREATER_THAN",
                threshold=100,
                threshold_type="PERCENTAGE",
                notification_type="FORECASTED",
                subscriber_email_addresses=["test@example.com"],
            )])
        ```
        <!--End PulumiCodeChooser -->

        Create a budget for *$100*.

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        cost = aws.budgets.Budget("cost",
            budget_type="COST",
            limit_amount="100",
            limit_unit="USD")
        ```
        <!--End PulumiCodeChooser -->

        Create a budget with planned budget limits.

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        cost = aws.budgets.Budget("cost", planned_limits=[
            aws.budgets.BudgetPlannedLimitArgs(
                start_time="2017-07-01_00:00",
                amount="100",
                unit="USD",
            ),
            aws.budgets.BudgetPlannedLimitArgs(
                start_time="2017-08-01_00:00",
                amount="200",
                unit="USD",
            ),
        ])
        ```
        <!--End PulumiCodeChooser -->

        Create a budget for s3 with a limit of *3 GB* of storage.

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        s3 = aws.budgets.Budget("s3",
            budget_type="USAGE",
            limit_amount="3",
            limit_unit="GB")
        ```
        <!--End PulumiCodeChooser -->

        Create a Savings Plan Utilization Budget

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        savings_plan_utilization = aws.budgets.Budget("savings_plan_utilization",
            budget_type="SAVINGS_PLANS_UTILIZATION",
            limit_amount="100.0",
            limit_unit="PERCENTAGE",
            cost_types=aws.budgets.BudgetCostTypesArgs(
                include_credit=False,
                include_discount=False,
                include_other_subscription=False,
                include_recurring=False,
                include_refund=False,
                include_subscription=True,
                include_support=False,
                include_tax=False,
                include_upfront=False,
                use_blended=False,
            ))
        ```
        <!--End PulumiCodeChooser -->

        Create a RI Utilization Budget

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        ri_utilization = aws.budgets.Budget("ri_utilization",
            budget_type="RI_UTILIZATION",
            limit_amount="100.0",
            limit_unit="PERCENTAGE",
            cost_types=aws.budgets.BudgetCostTypesArgs(
                include_credit=False,
                include_discount=False,
                include_other_subscription=False,
                include_recurring=False,
                include_refund=False,
                include_subscription=True,
                include_support=False,
                include_tax=False,
                include_upfront=False,
                use_blended=False,
            ),
            cost_filters=[aws.budgets.BudgetCostFilterArgs(
                name="Service",
                values=["Amazon Relational Database Service"],
            )])
        ```
        <!--End PulumiCodeChooser -->

        Create a Cost Filter using Resource Tags

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        cost = aws.budgets.Budget("cost", cost_filters=[aws.budgets.BudgetCostFilterArgs(
            name="TagKeyValue",
            values=["TagKey$TagValue"],
        )])
        ```
        <!--End PulumiCodeChooser -->

        Create a cost_filter using resource tags, obtaining the tag value from a variable

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        cost = aws.budgets.Budget("cost", cost_filters=[aws.budgets.BudgetCostFilterArgs(
            name="TagKeyValue",
            values=[f"TagKey{'$'}{tag_value}"],
        )])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import budgets using `AccountID:BudgetName`. For example:

        ```sh
        $ pulumi import aws:budgets/budget:Budget myBudget 123456789012:myBudget
        ```

        :param str resource_name: The name of the resource.
        :param BudgetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BudgetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 auto_adjust_data: Optional[pulumi.Input[pulumi.InputType['BudgetAutoAdjustDataArgs']]] = None,
                 budget_type: Optional[pulumi.Input[str]] = None,
                 cost_filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BudgetCostFilterArgs']]]]] = None,
                 cost_types: Optional[pulumi.Input[pulumi.InputType['BudgetCostTypesArgs']]] = None,
                 limit_amount: Optional[pulumi.Input[str]] = None,
                 limit_unit: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BudgetNotificationArgs']]]]] = None,
                 planned_limits: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BudgetPlannedLimitArgs']]]]] = None,
                 time_period_end: Optional[pulumi.Input[str]] = None,
                 time_period_start: Optional[pulumi.Input[str]] = None,
                 time_unit: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BudgetArgs.__new__(BudgetArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["auto_adjust_data"] = auto_adjust_data
            if budget_type is None and not opts.urn:
                raise TypeError("Missing required property 'budget_type'")
            __props__.__dict__["budget_type"] = budget_type
            __props__.__dict__["cost_filters"] = cost_filters
            __props__.__dict__["cost_types"] = cost_types
            __props__.__dict__["limit_amount"] = limit_amount
            __props__.__dict__["limit_unit"] = limit_unit
            __props__.__dict__["name"] = name
            __props__.__dict__["name_prefix"] = name_prefix
            __props__.__dict__["notifications"] = notifications
            __props__.__dict__["planned_limits"] = planned_limits
            __props__.__dict__["time_period_end"] = time_period_end
            __props__.__dict__["time_period_start"] = time_period_start
            if time_unit is None and not opts.urn:
                raise TypeError("Missing required property 'time_unit'")
            __props__.__dict__["time_unit"] = time_unit
            __props__.__dict__["arn"] = None
        super(Budget, __self__).__init__(
            'aws:budgets/budget:Budget',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            auto_adjust_data: Optional[pulumi.Input[pulumi.InputType['BudgetAutoAdjustDataArgs']]] = None,
            budget_type: Optional[pulumi.Input[str]] = None,
            cost_filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BudgetCostFilterArgs']]]]] = None,
            cost_types: Optional[pulumi.Input[pulumi.InputType['BudgetCostTypesArgs']]] = None,
            limit_amount: Optional[pulumi.Input[str]] = None,
            limit_unit: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            name_prefix: Optional[pulumi.Input[str]] = None,
            notifications: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BudgetNotificationArgs']]]]] = None,
            planned_limits: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BudgetPlannedLimitArgs']]]]] = None,
            time_period_end: Optional[pulumi.Input[str]] = None,
            time_period_start: Optional[pulumi.Input[str]] = None,
            time_unit: Optional[pulumi.Input[str]] = None) -> 'Budget':
        """
        Get an existing Budget resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The ID of the target account for budget. Will use current user's account_id by default if omitted.
        :param pulumi.Input[str] arn: The ARN of the budget.
        :param pulumi.Input[pulumi.InputType['BudgetAutoAdjustDataArgs']] auto_adjust_data: Object containing [AutoAdjustData] which determines the budget amount for an auto-adjusting budget.
        :param pulumi.Input[str] budget_type: Whether this budget tracks monetary cost or usage.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BudgetCostFilterArgs']]]] cost_filters: A list of CostFilter name/values pair to apply to budget.
        :param pulumi.Input[pulumi.InputType['BudgetCostTypesArgs']] cost_types: Object containing CostTypes The types of cost included in a budget, such as tax and subscriptions.
        :param pulumi.Input[str] limit_amount: The amount of cost or usage being measured for a budget.
        :param pulumi.Input[str] limit_unit: The unit of measurement used for the budget forecast, actual spend, or budget threshold, such as dollars or GB. See [Spend](http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/data-type-spend.html) documentation.
        :param pulumi.Input[str] name: The name of a budget. Unique within accounts.
        :param pulumi.Input[str] name_prefix: The prefix of the name of a budget. Unique within accounts.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BudgetNotificationArgs']]]] notifications: Object containing Budget Notifications. Can be used multiple times to define more than one budget notification.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BudgetPlannedLimitArgs']]]] planned_limits: Object containing Planned Budget Limits. Can be used multiple times to plan more than one budget limit. See [PlannedBudgetLimits](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_Budget.html#awscostmanagement-Type-budgets_Budget-PlannedBudgetLimits) documentation.
        :param pulumi.Input[str] time_period_end: The end of the time period covered by the budget. There are no restrictions on the end date. Format: `2017-01-01_12:00`.
        :param pulumi.Input[str] time_period_start: The start of the time period covered by the budget. If you don't specify a start date, AWS defaults to the start of your chosen time period. The start date must come before the end date. Format: `2017-01-01_12:00`.
        :param pulumi.Input[str] time_unit: The length of time until a budget resets the actual and forecasted spend. Valid values: `MONTHLY`, `QUARTERLY`, `ANNUALLY`, and `DAILY`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BudgetState.__new__(_BudgetState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["arn"] = arn
        __props__.__dict__["auto_adjust_data"] = auto_adjust_data
        __props__.__dict__["budget_type"] = budget_type
        __props__.__dict__["cost_filters"] = cost_filters
        __props__.__dict__["cost_types"] = cost_types
        __props__.__dict__["limit_amount"] = limit_amount
        __props__.__dict__["limit_unit"] = limit_unit
        __props__.__dict__["name"] = name
        __props__.__dict__["name_prefix"] = name_prefix
        __props__.__dict__["notifications"] = notifications
        __props__.__dict__["planned_limits"] = planned_limits
        __props__.__dict__["time_period_end"] = time_period_end
        __props__.__dict__["time_period_start"] = time_period_start
        __props__.__dict__["time_unit"] = time_unit
        return Budget(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        The ID of the target account for budget. Will use current user's account_id by default if omitted.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the budget.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoAdjustData")
    def auto_adjust_data(self) -> pulumi.Output[Optional['outputs.BudgetAutoAdjustData']]:
        """
        Object containing [AutoAdjustData] which determines the budget amount for an auto-adjusting budget.
        """
        return pulumi.get(self, "auto_adjust_data")

    @property
    @pulumi.getter(name="budgetType")
    def budget_type(self) -> pulumi.Output[str]:
        """
        Whether this budget tracks monetary cost or usage.
        """
        return pulumi.get(self, "budget_type")

    @property
    @pulumi.getter(name="costFilters")
    def cost_filters(self) -> pulumi.Output[Sequence['outputs.BudgetCostFilter']]:
        """
        A list of CostFilter name/values pair to apply to budget.
        """
        return pulumi.get(self, "cost_filters")

    @property
    @pulumi.getter(name="costTypes")
    def cost_types(self) -> pulumi.Output['outputs.BudgetCostTypes']:
        """
        Object containing CostTypes The types of cost included in a budget, such as tax and subscriptions.
        """
        return pulumi.get(self, "cost_types")

    @property
    @pulumi.getter(name="limitAmount")
    def limit_amount(self) -> pulumi.Output[str]:
        """
        The amount of cost or usage being measured for a budget.
        """
        return pulumi.get(self, "limit_amount")

    @property
    @pulumi.getter(name="limitUnit")
    def limit_unit(self) -> pulumi.Output[str]:
        """
        The unit of measurement used for the budget forecast, actual spend, or budget threshold, such as dollars or GB. See [Spend](http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/data-type-spend.html) documentation.
        """
        return pulumi.get(self, "limit_unit")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of a budget. Unique within accounts.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> pulumi.Output[str]:
        """
        The prefix of the name of a budget. Unique within accounts.
        """
        return pulumi.get(self, "name_prefix")

    @property
    @pulumi.getter
    def notifications(self) -> pulumi.Output[Optional[Sequence['outputs.BudgetNotification']]]:
        """
        Object containing Budget Notifications. Can be used multiple times to define more than one budget notification.
        """
        return pulumi.get(self, "notifications")

    @property
    @pulumi.getter(name="plannedLimits")
    def planned_limits(self) -> pulumi.Output[Optional[Sequence['outputs.BudgetPlannedLimit']]]:
        """
        Object containing Planned Budget Limits. Can be used multiple times to plan more than one budget limit. See [PlannedBudgetLimits](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_Budget.html#awscostmanagement-Type-budgets_Budget-PlannedBudgetLimits) documentation.
        """
        return pulumi.get(self, "planned_limits")

    @property
    @pulumi.getter(name="timePeriodEnd")
    def time_period_end(self) -> pulumi.Output[Optional[str]]:
        """
        The end of the time period covered by the budget. There are no restrictions on the end date. Format: `2017-01-01_12:00`.
        """
        return pulumi.get(self, "time_period_end")

    @property
    @pulumi.getter(name="timePeriodStart")
    def time_period_start(self) -> pulumi.Output[str]:
        """
        The start of the time period covered by the budget. If you don't specify a start date, AWS defaults to the start of your chosen time period. The start date must come before the end date. Format: `2017-01-01_12:00`.
        """
        return pulumi.get(self, "time_period_start")

    @property
    @pulumi.getter(name="timeUnit")
    def time_unit(self) -> pulumi.Output[str]:
        """
        The length of time until a budget resets the actual and forecasted spend. Valid values: `MONTHLY`, `QUARTERLY`, `ANNUALLY`, and `DAILY`.
        """
        return pulumi.get(self, "time_unit")

