# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ContinuousDeploymentPolicyArgs', 'ContinuousDeploymentPolicy']

@pulumi.input_type
class ContinuousDeploymentPolicyArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 staging_distribution_dns_names: Optional[pulumi.Input['ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs']] = None,
                 traffic_config: Optional[pulumi.Input['ContinuousDeploymentPolicyTrafficConfigArgs']] = None):
        """
        The set of arguments for constructing a ContinuousDeploymentPolicy resource.
        :param pulumi.Input[bool] enabled: Whether this continuous deployment policy is enabled.
        :param pulumi.Input['ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs'] staging_distribution_dns_names: CloudFront domain name of the staging distribution. See `staging_distribution_dns_names`.
        :param pulumi.Input['ContinuousDeploymentPolicyTrafficConfigArgs'] traffic_config: Parameters for routing production traffic from primary to staging distributions. See `traffic_config`.
        """
        pulumi.set(__self__, "enabled", enabled)
        if staging_distribution_dns_names is not None:
            pulumi.set(__self__, "staging_distribution_dns_names", staging_distribution_dns_names)
        if traffic_config is not None:
            pulumi.set(__self__, "traffic_config", traffic_config)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Whether this continuous deployment policy is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="stagingDistributionDnsNames")
    def staging_distribution_dns_names(self) -> Optional[pulumi.Input['ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs']]:
        """
        CloudFront domain name of the staging distribution. See `staging_distribution_dns_names`.
        """
        return pulumi.get(self, "staging_distribution_dns_names")

    @staging_distribution_dns_names.setter
    def staging_distribution_dns_names(self, value: Optional[pulumi.Input['ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs']]):
        pulumi.set(self, "staging_distribution_dns_names", value)

    @property
    @pulumi.getter(name="trafficConfig")
    def traffic_config(self) -> Optional[pulumi.Input['ContinuousDeploymentPolicyTrafficConfigArgs']]:
        """
        Parameters for routing production traffic from primary to staging distributions. See `traffic_config`.
        """
        return pulumi.get(self, "traffic_config")

    @traffic_config.setter
    def traffic_config(self, value: Optional[pulumi.Input['ContinuousDeploymentPolicyTrafficConfigArgs']]):
        pulumi.set(self, "traffic_config", value)


@pulumi.input_type
class _ContinuousDeploymentPolicyState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 last_modified_time: Optional[pulumi.Input[str]] = None,
                 staging_distribution_dns_names: Optional[pulumi.Input['ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs']] = None,
                 traffic_config: Optional[pulumi.Input['ContinuousDeploymentPolicyTrafficConfigArgs']] = None):
        """
        Input properties used for looking up and filtering ContinuousDeploymentPolicy resources.
        :param pulumi.Input[bool] enabled: Whether this continuous deployment policy is enabled.
        :param pulumi.Input[str] etag: Current version of the continuous distribution policy.
        :param pulumi.Input[str] last_modified_time: Date and time the continuous deployment policy was last modified.
        :param pulumi.Input['ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs'] staging_distribution_dns_names: CloudFront domain name of the staging distribution. See `staging_distribution_dns_names`.
        :param pulumi.Input['ContinuousDeploymentPolicyTrafficConfigArgs'] traffic_config: Parameters for routing production traffic from primary to staging distributions. See `traffic_config`.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if last_modified_time is not None:
            pulumi.set(__self__, "last_modified_time", last_modified_time)
        if staging_distribution_dns_names is not None:
            pulumi.set(__self__, "staging_distribution_dns_names", staging_distribution_dns_names)
        if traffic_config is not None:
            pulumi.set(__self__, "traffic_config", traffic_config)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this continuous deployment policy is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        Current version of the continuous distribution policy.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[pulumi.Input[str]]:
        """
        Date and time the continuous deployment policy was last modified.
        """
        return pulumi.get(self, "last_modified_time")

    @last_modified_time.setter
    def last_modified_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_modified_time", value)

    @property
    @pulumi.getter(name="stagingDistributionDnsNames")
    def staging_distribution_dns_names(self) -> Optional[pulumi.Input['ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs']]:
        """
        CloudFront domain name of the staging distribution. See `staging_distribution_dns_names`.
        """
        return pulumi.get(self, "staging_distribution_dns_names")

    @staging_distribution_dns_names.setter
    def staging_distribution_dns_names(self, value: Optional[pulumi.Input['ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs']]):
        pulumi.set(self, "staging_distribution_dns_names", value)

    @property
    @pulumi.getter(name="trafficConfig")
    def traffic_config(self) -> Optional[pulumi.Input['ContinuousDeploymentPolicyTrafficConfigArgs']]:
        """
        Parameters for routing production traffic from primary to staging distributions. See `traffic_config`.
        """
        return pulumi.get(self, "traffic_config")

    @traffic_config.setter
    def traffic_config(self, value: Optional[pulumi.Input['ContinuousDeploymentPolicyTrafficConfigArgs']]):
        pulumi.set(self, "traffic_config", value)


class ContinuousDeploymentPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 staging_distribution_dns_names: Optional[pulumi.Input[pulumi.InputType['ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs']]] = None,
                 traffic_config: Optional[pulumi.Input[pulumi.InputType['ContinuousDeploymentPolicyTrafficConfigArgs']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS CloudFront Continuous Deployment Policy.

        ## Example Usage

        ### Basic Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        staging = aws.cloudfront.Distribution("staging",
            enabled=True,
            staging=True)
        example = aws.cloudfront.ContinuousDeploymentPolicy("example",
            enabled=True,
            staging_distribution_dns_names=aws.cloudfront.ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs(
                items=[staging.domain_name],
                quantity=1,
            ),
            traffic_config=aws.cloudfront.ContinuousDeploymentPolicyTrafficConfigArgs(
                type="SingleWeight",
                single_weight_config=aws.cloudfront.ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigArgs(
                    weight=0.01,
                ),
            ))
        production = aws.cloudfront.Distribution("production",
            enabled=True,
            continuous_deployment_policy_id=example.id)
        ```
        <!--End PulumiCodeChooser -->

        ### Single Weight Config with Session Stickiness

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudfront.ContinuousDeploymentPolicy("example",
            enabled=True,
            staging_distribution_dns_names=aws.cloudfront.ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs(
                items=[staging["domainName"]],
                quantity=1,
            ),
            traffic_config=aws.cloudfront.ContinuousDeploymentPolicyTrafficConfigArgs(
                type="SingleWeight",
                single_weight_config=aws.cloudfront.ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigArgs(
                    weight=0.01,
                    session_stickiness_config=aws.cloudfront.ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigSessionStickinessConfigArgs(
                        idle_ttl=300,
                        maximum_ttl=600,
                    ),
                ),
            ))
        ```
        <!--End PulumiCodeChooser -->

        ### Single Header Config

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudfront.ContinuousDeploymentPolicy("example",
            enabled=True,
            staging_distribution_dns_names=aws.cloudfront.ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs(
                items=[staging["domainName"]],
                quantity=1,
            ),
            traffic_config=aws.cloudfront.ContinuousDeploymentPolicyTrafficConfigArgs(
                type="SingleHeader",
                single_header_config=aws.cloudfront.ContinuousDeploymentPolicyTrafficConfigSingleHeaderConfigArgs(
                    header="aws-cf-cd-example",
                    value="example",
                ),
            ))
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import CloudFront Continuous Deployment Policy using the `id`. For example:

        ```sh
        $ pulumi import aws:cloudfront/continuousDeploymentPolicy:ContinuousDeploymentPolicy example abcd-1234
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enabled: Whether this continuous deployment policy is enabled.
        :param pulumi.Input[pulumi.InputType['ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs']] staging_distribution_dns_names: CloudFront domain name of the staging distribution. See `staging_distribution_dns_names`.
        :param pulumi.Input[pulumi.InputType['ContinuousDeploymentPolicyTrafficConfigArgs']] traffic_config: Parameters for routing production traffic from primary to staging distributions. See `traffic_config`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContinuousDeploymentPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS CloudFront Continuous Deployment Policy.

        ## Example Usage

        ### Basic Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        staging = aws.cloudfront.Distribution("staging",
            enabled=True,
            staging=True)
        example = aws.cloudfront.ContinuousDeploymentPolicy("example",
            enabled=True,
            staging_distribution_dns_names=aws.cloudfront.ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs(
                items=[staging.domain_name],
                quantity=1,
            ),
            traffic_config=aws.cloudfront.ContinuousDeploymentPolicyTrafficConfigArgs(
                type="SingleWeight",
                single_weight_config=aws.cloudfront.ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigArgs(
                    weight=0.01,
                ),
            ))
        production = aws.cloudfront.Distribution("production",
            enabled=True,
            continuous_deployment_policy_id=example.id)
        ```
        <!--End PulumiCodeChooser -->

        ### Single Weight Config with Session Stickiness

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudfront.ContinuousDeploymentPolicy("example",
            enabled=True,
            staging_distribution_dns_names=aws.cloudfront.ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs(
                items=[staging["domainName"]],
                quantity=1,
            ),
            traffic_config=aws.cloudfront.ContinuousDeploymentPolicyTrafficConfigArgs(
                type="SingleWeight",
                single_weight_config=aws.cloudfront.ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigArgs(
                    weight=0.01,
                    session_stickiness_config=aws.cloudfront.ContinuousDeploymentPolicyTrafficConfigSingleWeightConfigSessionStickinessConfigArgs(
                        idle_ttl=300,
                        maximum_ttl=600,
                    ),
                ),
            ))
        ```
        <!--End PulumiCodeChooser -->

        ### Single Header Config

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudfront.ContinuousDeploymentPolicy("example",
            enabled=True,
            staging_distribution_dns_names=aws.cloudfront.ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs(
                items=[staging["domainName"]],
                quantity=1,
            ),
            traffic_config=aws.cloudfront.ContinuousDeploymentPolicyTrafficConfigArgs(
                type="SingleHeader",
                single_header_config=aws.cloudfront.ContinuousDeploymentPolicyTrafficConfigSingleHeaderConfigArgs(
                    header="aws-cf-cd-example",
                    value="example",
                ),
            ))
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import CloudFront Continuous Deployment Policy using the `id`. For example:

        ```sh
        $ pulumi import aws:cloudfront/continuousDeploymentPolicy:ContinuousDeploymentPolicy example abcd-1234
        ```

        :param str resource_name: The name of the resource.
        :param ContinuousDeploymentPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContinuousDeploymentPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 staging_distribution_dns_names: Optional[pulumi.Input[pulumi.InputType['ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs']]] = None,
                 traffic_config: Optional[pulumi.Input[pulumi.InputType['ContinuousDeploymentPolicyTrafficConfigArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContinuousDeploymentPolicyArgs.__new__(ContinuousDeploymentPolicyArgs)

            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["staging_distribution_dns_names"] = staging_distribution_dns_names
            __props__.__dict__["traffic_config"] = traffic_config
            __props__.__dict__["etag"] = None
            __props__.__dict__["last_modified_time"] = None
        super(ContinuousDeploymentPolicy, __self__).__init__(
            'aws:cloudfront/continuousDeploymentPolicy:ContinuousDeploymentPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            last_modified_time: Optional[pulumi.Input[str]] = None,
            staging_distribution_dns_names: Optional[pulumi.Input[pulumi.InputType['ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs']]] = None,
            traffic_config: Optional[pulumi.Input[pulumi.InputType['ContinuousDeploymentPolicyTrafficConfigArgs']]] = None) -> 'ContinuousDeploymentPolicy':
        """
        Get an existing ContinuousDeploymentPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enabled: Whether this continuous deployment policy is enabled.
        :param pulumi.Input[str] etag: Current version of the continuous distribution policy.
        :param pulumi.Input[str] last_modified_time: Date and time the continuous deployment policy was last modified.
        :param pulumi.Input[pulumi.InputType['ContinuousDeploymentPolicyStagingDistributionDnsNamesArgs']] staging_distribution_dns_names: CloudFront domain name of the staging distribution. See `staging_distribution_dns_names`.
        :param pulumi.Input[pulumi.InputType['ContinuousDeploymentPolicyTrafficConfigArgs']] traffic_config: Parameters for routing production traffic from primary to staging distributions. See `traffic_config`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContinuousDeploymentPolicyState.__new__(_ContinuousDeploymentPolicyState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["etag"] = etag
        __props__.__dict__["last_modified_time"] = last_modified_time
        __props__.__dict__["staging_distribution_dns_names"] = staging_distribution_dns_names
        __props__.__dict__["traffic_config"] = traffic_config
        return ContinuousDeploymentPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        Whether this continuous deployment policy is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        Current version of the continuous distribution policy.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> pulumi.Output[str]:
        """
        Date and time the continuous deployment policy was last modified.
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter(name="stagingDistributionDnsNames")
    def staging_distribution_dns_names(self) -> pulumi.Output[Optional['outputs.ContinuousDeploymentPolicyStagingDistributionDnsNames']]:
        """
        CloudFront domain name of the staging distribution. See `staging_distribution_dns_names`.
        """
        return pulumi.get(self, "staging_distribution_dns_names")

    @property
    @pulumi.getter(name="trafficConfig")
    def traffic_config(self) -> pulumi.Output[Optional['outputs.ContinuousDeploymentPolicyTrafficConfig']]:
        """
        Parameters for routing production traffic from primary to staging distributions. See `traffic_config`.
        """
        return pulumi.get(self, "traffic_config")

