# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'CompositeAlarmActionsSuppressorArgs',
    'EventConnectionAuthParametersArgs',
    'EventConnectionAuthParametersApiKeyArgs',
    'EventConnectionAuthParametersBasicArgs',
    'EventConnectionAuthParametersInvocationHttpParametersArgs',
    'EventConnectionAuthParametersInvocationHttpParametersBodyArgs',
    'EventConnectionAuthParametersInvocationHttpParametersHeaderArgs',
    'EventConnectionAuthParametersInvocationHttpParametersQueryStringArgs',
    'EventConnectionAuthParametersOauthArgs',
    'EventConnectionAuthParametersOauthClientParametersArgs',
    'EventConnectionAuthParametersOauthOauthHttpParametersArgs',
    'EventConnectionAuthParametersOauthOauthHttpParametersBodyArgs',
    'EventConnectionAuthParametersOauthOauthHttpParametersHeaderArgs',
    'EventConnectionAuthParametersOauthOauthHttpParametersQueryStringArgs',
    'EventEndpointEventBusArgs',
    'EventEndpointReplicationConfigArgs',
    'EventEndpointRoutingConfigArgs',
    'EventEndpointRoutingConfigFailoverConfigArgs',
    'EventEndpointRoutingConfigFailoverConfigPrimaryArgs',
    'EventEndpointRoutingConfigFailoverConfigSecondaryArgs',
    'EventPermissionConditionArgs',
    'EventTargetBatchTargetArgs',
    'EventTargetDeadLetterConfigArgs',
    'EventTargetEcsTargetArgs',
    'EventTargetEcsTargetCapacityProviderStrategyArgs',
    'EventTargetEcsTargetNetworkConfigurationArgs',
    'EventTargetEcsTargetOrderedPlacementStrategyArgs',
    'EventTargetEcsTargetPlacementConstraintArgs',
    'EventTargetHttpTargetArgs',
    'EventTargetInputTransformerArgs',
    'EventTargetKinesisTargetArgs',
    'EventTargetRedshiftTargetArgs',
    'EventTargetRetryPolicyArgs',
    'EventTargetRunCommandTargetArgs',
    'EventTargetSagemakerPipelineTargetArgs',
    'EventTargetSagemakerPipelineTargetPipelineParameterListArgs',
    'EventTargetSqsTargetArgs',
    'InternetMonitorHealthEventsConfigArgs',
    'InternetMonitorInternetMeasurementsLogDeliveryArgs',
    'InternetMonitorInternetMeasurementsLogDeliveryS3ConfigArgs',
    'LogMetricFilterMetricTransformationArgs',
    'MetricAlarmMetricQueryArgs',
    'MetricAlarmMetricQueryMetricArgs',
    'MetricStreamExcludeFilterArgs',
    'MetricStreamIncludeFilterArgs',
    'MetricStreamStatisticsConfigurationArgs',
    'MetricStreamStatisticsConfigurationIncludeMetricArgs',
    'GetLogDataProtectionPolicyDocumentStatementArgs',
    'GetLogDataProtectionPolicyDocumentStatementOperationArgs',
    'GetLogDataProtectionPolicyDocumentStatementOperationAuditArgs',
    'GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationArgs',
    'GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationCloudwatchLogsArgs',
    'GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationFirehoseArgs',
    'GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationS3Args',
    'GetLogDataProtectionPolicyDocumentStatementOperationDeidentifyArgs',
    'GetLogDataProtectionPolicyDocumentStatementOperationDeidentifyMaskConfigArgs',
]

@pulumi.input_type
class CompositeAlarmActionsSuppressorArgs:
    def __init__(__self__, *,
                 alarm: pulumi.Input[str],
                 extension_period: pulumi.Input[int],
                 wait_period: pulumi.Input[int]):
        """
        :param pulumi.Input[str] alarm: Can be an AlarmName or an Amazon Resource Name (ARN) from an existing alarm.
        :param pulumi.Input[int] extension_period: The maximum time in seconds that the composite alarm waits after suppressor alarm goes out of the `ALARM` state. After this time, the composite alarm performs its actions.
        :param pulumi.Input[int] wait_period: The maximum time in seconds that the composite alarm waits for the suppressor alarm to go into the `ALARM` state. After this time, the composite alarm performs its actions.
        """
        pulumi.set(__self__, "alarm", alarm)
        pulumi.set(__self__, "extension_period", extension_period)
        pulumi.set(__self__, "wait_period", wait_period)

    @property
    @pulumi.getter
    def alarm(self) -> pulumi.Input[str]:
        """
        Can be an AlarmName or an Amazon Resource Name (ARN) from an existing alarm.
        """
        return pulumi.get(self, "alarm")

    @alarm.setter
    def alarm(self, value: pulumi.Input[str]):
        pulumi.set(self, "alarm", value)

    @property
    @pulumi.getter(name="extensionPeriod")
    def extension_period(self) -> pulumi.Input[int]:
        """
        The maximum time in seconds that the composite alarm waits after suppressor alarm goes out of the `ALARM` state. After this time, the composite alarm performs its actions.
        """
        return pulumi.get(self, "extension_period")

    @extension_period.setter
    def extension_period(self, value: pulumi.Input[int]):
        pulumi.set(self, "extension_period", value)

    @property
    @pulumi.getter(name="waitPeriod")
    def wait_period(self) -> pulumi.Input[int]:
        """
        The maximum time in seconds that the composite alarm waits for the suppressor alarm to go into the `ALARM` state. After this time, the composite alarm performs its actions.
        """
        return pulumi.get(self, "wait_period")

    @wait_period.setter
    def wait_period(self, value: pulumi.Input[int]):
        pulumi.set(self, "wait_period", value)


@pulumi.input_type
class EventConnectionAuthParametersArgs:
    def __init__(__self__, *,
                 api_key: Optional[pulumi.Input['EventConnectionAuthParametersApiKeyArgs']] = None,
                 basic: Optional[pulumi.Input['EventConnectionAuthParametersBasicArgs']] = None,
                 invocation_http_parameters: Optional[pulumi.Input['EventConnectionAuthParametersInvocationHttpParametersArgs']] = None,
                 oauth: Optional[pulumi.Input['EventConnectionAuthParametersOauthArgs']] = None):
        """
        :param pulumi.Input['EventConnectionAuthParametersApiKeyArgs'] api_key: Parameters used for API_KEY authorization. An API key to include in the header for each authentication request. A maximum of 1 are allowed. Conflicts with `basic` and `oauth`. Documented below.
        :param pulumi.Input['EventConnectionAuthParametersBasicArgs'] basic: Parameters used for BASIC authorization. A maximum of 1 are allowed. Conflicts with `api_key` and `oauth`. Documented below.
        :param pulumi.Input['EventConnectionAuthParametersInvocationHttpParametersArgs'] invocation_http_parameters: Invocation Http Parameters are additional credentials used to sign each Invocation of the ApiDestination created from this Connection. If the ApiDestination Rule Target has additional HttpParameters, the values will be merged together, with the Connection Invocation Http Parameters taking precedence. Secret values are stored and managed by AWS Secrets Manager. A maximum of 1 are allowed. Documented below.
        :param pulumi.Input['EventConnectionAuthParametersOauthArgs'] oauth: Parameters used for OAUTH_CLIENT_CREDENTIALS authorization. A maximum of 1 are allowed. Conflicts with `basic` and `api_key`. Documented below.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if basic is not None:
            pulumi.set(__self__, "basic", basic)
        if invocation_http_parameters is not None:
            pulumi.set(__self__, "invocation_http_parameters", invocation_http_parameters)
        if oauth is not None:
            pulumi.set(__self__, "oauth", oauth)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input['EventConnectionAuthParametersApiKeyArgs']]:
        """
        Parameters used for API_KEY authorization. An API key to include in the header for each authentication request. A maximum of 1 are allowed. Conflicts with `basic` and `oauth`. Documented below.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input['EventConnectionAuthParametersApiKeyArgs']]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter
    def basic(self) -> Optional[pulumi.Input['EventConnectionAuthParametersBasicArgs']]:
        """
        Parameters used for BASIC authorization. A maximum of 1 are allowed. Conflicts with `api_key` and `oauth`. Documented below.
        """
        return pulumi.get(self, "basic")

    @basic.setter
    def basic(self, value: Optional[pulumi.Input['EventConnectionAuthParametersBasicArgs']]):
        pulumi.set(self, "basic", value)

    @property
    @pulumi.getter(name="invocationHttpParameters")
    def invocation_http_parameters(self) -> Optional[pulumi.Input['EventConnectionAuthParametersInvocationHttpParametersArgs']]:
        """
        Invocation Http Parameters are additional credentials used to sign each Invocation of the ApiDestination created from this Connection. If the ApiDestination Rule Target has additional HttpParameters, the values will be merged together, with the Connection Invocation Http Parameters taking precedence. Secret values are stored and managed by AWS Secrets Manager. A maximum of 1 are allowed. Documented below.
        """
        return pulumi.get(self, "invocation_http_parameters")

    @invocation_http_parameters.setter
    def invocation_http_parameters(self, value: Optional[pulumi.Input['EventConnectionAuthParametersInvocationHttpParametersArgs']]):
        pulumi.set(self, "invocation_http_parameters", value)

    @property
    @pulumi.getter
    def oauth(self) -> Optional[pulumi.Input['EventConnectionAuthParametersOauthArgs']]:
        """
        Parameters used for OAUTH_CLIENT_CREDENTIALS authorization. A maximum of 1 are allowed. Conflicts with `basic` and `api_key`. Documented below.
        """
        return pulumi.get(self, "oauth")

    @oauth.setter
    def oauth(self, value: Optional[pulumi.Input['EventConnectionAuthParametersOauthArgs']]):
        pulumi.set(self, "oauth", value)


@pulumi.input_type
class EventConnectionAuthParametersApiKeyArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] key: Header Name.
        :param pulumi.Input[str] value: Header Value. Created and stored in AWS Secrets Manager.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        Header Name.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Header Value. Created and stored in AWS Secrets Manager.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class EventConnectionAuthParametersBasicArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[str],
                 username: pulumi.Input[str]):
        """
        :param pulumi.Input[str] password: A password for the authorization. Created and stored in AWS Secrets Manager.
        :param pulumi.Input[str] username: A username for the authorization.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        A password for the authorization. Created and stored in AWS Secrets Manager.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        A username for the authorization.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class EventConnectionAuthParametersInvocationHttpParametersArgs:
    def __init__(__self__, *,
                 bodies: Optional[pulumi.Input[Sequence[pulumi.Input['EventConnectionAuthParametersInvocationHttpParametersBodyArgs']]]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['EventConnectionAuthParametersInvocationHttpParametersHeaderArgs']]]] = None,
                 query_strings: Optional[pulumi.Input[Sequence[pulumi.Input['EventConnectionAuthParametersInvocationHttpParametersQueryStringArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['EventConnectionAuthParametersInvocationHttpParametersBodyArgs']]] bodies: Contains additional body string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
        :param pulumi.Input[Sequence[pulumi.Input['EventConnectionAuthParametersInvocationHttpParametersHeaderArgs']]] headers: Contains additional header parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
        :param pulumi.Input[Sequence[pulumi.Input['EventConnectionAuthParametersInvocationHttpParametersQueryStringArgs']]] query_strings: Contains additional query string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
        """
        if bodies is not None:
            pulumi.set(__self__, "bodies", bodies)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if query_strings is not None:
            pulumi.set(__self__, "query_strings", query_strings)

    @property
    @pulumi.getter
    def bodies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventConnectionAuthParametersInvocationHttpParametersBodyArgs']]]]:
        """
        Contains additional body string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
        """
        return pulumi.get(self, "bodies")

    @bodies.setter
    def bodies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventConnectionAuthParametersInvocationHttpParametersBodyArgs']]]]):
        pulumi.set(self, "bodies", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventConnectionAuthParametersInvocationHttpParametersHeaderArgs']]]]:
        """
        Contains additional header parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventConnectionAuthParametersInvocationHttpParametersHeaderArgs']]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter(name="queryStrings")
    def query_strings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventConnectionAuthParametersInvocationHttpParametersQueryStringArgs']]]]:
        """
        Contains additional query string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
        """
        return pulumi.get(self, "query_strings")

    @query_strings.setter
    def query_strings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventConnectionAuthParametersInvocationHttpParametersQueryStringArgs']]]]):
        pulumi.set(self, "query_strings", value)


@pulumi.input_type
class EventConnectionAuthParametersInvocationHttpParametersBodyArgs:
    def __init__(__self__, *,
                 is_value_secret: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] is_value_secret: Specified whether the value is secret.
        :param pulumi.Input[str] key: Header Name.
        :param pulumi.Input[str] value: Header Value. Created and stored in AWS Secrets Manager.
        """
        if is_value_secret is not None:
            pulumi.set(__self__, "is_value_secret", is_value_secret)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="isValueSecret")
    def is_value_secret(self) -> Optional[pulumi.Input[bool]]:
        """
        Specified whether the value is secret.
        """
        return pulumi.get(self, "is_value_secret")

    @is_value_secret.setter
    def is_value_secret(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_value_secret", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Header Name.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Header Value. Created and stored in AWS Secrets Manager.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class EventConnectionAuthParametersInvocationHttpParametersHeaderArgs:
    def __init__(__self__, *,
                 is_value_secret: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] is_value_secret: Specified whether the value is secret.
        :param pulumi.Input[str] key: Header Name.
        :param pulumi.Input[str] value: Header Value. Created and stored in AWS Secrets Manager.
        """
        if is_value_secret is not None:
            pulumi.set(__self__, "is_value_secret", is_value_secret)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="isValueSecret")
    def is_value_secret(self) -> Optional[pulumi.Input[bool]]:
        """
        Specified whether the value is secret.
        """
        return pulumi.get(self, "is_value_secret")

    @is_value_secret.setter
    def is_value_secret(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_value_secret", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Header Name.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Header Value. Created and stored in AWS Secrets Manager.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class EventConnectionAuthParametersInvocationHttpParametersQueryStringArgs:
    def __init__(__self__, *,
                 is_value_secret: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] is_value_secret: Specified whether the value is secret.
        :param pulumi.Input[str] key: Header Name.
        :param pulumi.Input[str] value: Header Value. Created and stored in AWS Secrets Manager.
        """
        if is_value_secret is not None:
            pulumi.set(__self__, "is_value_secret", is_value_secret)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="isValueSecret")
    def is_value_secret(self) -> Optional[pulumi.Input[bool]]:
        """
        Specified whether the value is secret.
        """
        return pulumi.get(self, "is_value_secret")

    @is_value_secret.setter
    def is_value_secret(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_value_secret", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Header Name.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Header Value. Created and stored in AWS Secrets Manager.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class EventConnectionAuthParametersOauthArgs:
    def __init__(__self__, *,
                 authorization_endpoint: pulumi.Input[str],
                 http_method: pulumi.Input[str],
                 oauth_http_parameters: pulumi.Input['EventConnectionAuthParametersOauthOauthHttpParametersArgs'],
                 client_parameters: Optional[pulumi.Input['EventConnectionAuthParametersOauthClientParametersArgs']] = None):
        """
        :param pulumi.Input[str] authorization_endpoint: The URL to the authorization endpoint.
        :param pulumi.Input[str] http_method: A password for the authorization. Created and stored in AWS Secrets Manager.
        :param pulumi.Input['EventConnectionAuthParametersOauthOauthHttpParametersArgs'] oauth_http_parameters: OAuth Http Parameters are additional credentials used to sign the request to the authorization endpoint to exchange the OAuth Client information for an access token. Secret values are stored and managed by AWS Secrets Manager. A maximum of 1 are allowed. Documented below.
        :param pulumi.Input['EventConnectionAuthParametersOauthClientParametersArgs'] client_parameters: Contains the client parameters for OAuth authorization. Contains the following two parameters.
        """
        pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        pulumi.set(__self__, "http_method", http_method)
        pulumi.set(__self__, "oauth_http_parameters", oauth_http_parameters)
        if client_parameters is not None:
            pulumi.set(__self__, "client_parameters", client_parameters)

    @property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> pulumi.Input[str]:
        """
        The URL to the authorization endpoint.
        """
        return pulumi.get(self, "authorization_endpoint")

    @authorization_endpoint.setter
    def authorization_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "authorization_endpoint", value)

    @property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> pulumi.Input[str]:
        """
        A password for the authorization. Created and stored in AWS Secrets Manager.
        """
        return pulumi.get(self, "http_method")

    @http_method.setter
    def http_method(self, value: pulumi.Input[str]):
        pulumi.set(self, "http_method", value)

    @property
    @pulumi.getter(name="oauthHttpParameters")
    def oauth_http_parameters(self) -> pulumi.Input['EventConnectionAuthParametersOauthOauthHttpParametersArgs']:
        """
        OAuth Http Parameters are additional credentials used to sign the request to the authorization endpoint to exchange the OAuth Client information for an access token. Secret values are stored and managed by AWS Secrets Manager. A maximum of 1 are allowed. Documented below.
        """
        return pulumi.get(self, "oauth_http_parameters")

    @oauth_http_parameters.setter
    def oauth_http_parameters(self, value: pulumi.Input['EventConnectionAuthParametersOauthOauthHttpParametersArgs']):
        pulumi.set(self, "oauth_http_parameters", value)

    @property
    @pulumi.getter(name="clientParameters")
    def client_parameters(self) -> Optional[pulumi.Input['EventConnectionAuthParametersOauthClientParametersArgs']]:
        """
        Contains the client parameters for OAuth authorization. Contains the following two parameters.
        """
        return pulumi.get(self, "client_parameters")

    @client_parameters.setter
    def client_parameters(self, value: Optional[pulumi.Input['EventConnectionAuthParametersOauthClientParametersArgs']]):
        pulumi.set(self, "client_parameters", value)


@pulumi.input_type
class EventConnectionAuthParametersOauthClientParametersArgs:
    def __init__(__self__, *,
                 client_id: pulumi.Input[str],
                 client_secret: pulumi.Input[str]):
        """
        :param pulumi.Input[str] client_id: The client ID for the credentials to use for authorization. Created and stored in AWS Secrets Manager.
        :param pulumi.Input[str] client_secret: The client secret for the credentials to use for authorization. Created and stored in AWS Secrets Manager.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[str]:
        """
        The client ID for the credentials to use for authorization. Created and stored in AWS Secrets Manager.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Input[str]:
        """
        The client secret for the credentials to use for authorization. Created and stored in AWS Secrets Manager.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_secret", value)


@pulumi.input_type
class EventConnectionAuthParametersOauthOauthHttpParametersArgs:
    def __init__(__self__, *,
                 bodies: Optional[pulumi.Input[Sequence[pulumi.Input['EventConnectionAuthParametersOauthOauthHttpParametersBodyArgs']]]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['EventConnectionAuthParametersOauthOauthHttpParametersHeaderArgs']]]] = None,
                 query_strings: Optional[pulumi.Input[Sequence[pulumi.Input['EventConnectionAuthParametersOauthOauthHttpParametersQueryStringArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['EventConnectionAuthParametersOauthOauthHttpParametersBodyArgs']]] bodies: Contains additional body string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
        :param pulumi.Input[Sequence[pulumi.Input['EventConnectionAuthParametersOauthOauthHttpParametersHeaderArgs']]] headers: Contains additional header parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
        :param pulumi.Input[Sequence[pulumi.Input['EventConnectionAuthParametersOauthOauthHttpParametersQueryStringArgs']]] query_strings: Contains additional query string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
        """
        if bodies is not None:
            pulumi.set(__self__, "bodies", bodies)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if query_strings is not None:
            pulumi.set(__self__, "query_strings", query_strings)

    @property
    @pulumi.getter
    def bodies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventConnectionAuthParametersOauthOauthHttpParametersBodyArgs']]]]:
        """
        Contains additional body string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
        """
        return pulumi.get(self, "bodies")

    @bodies.setter
    def bodies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventConnectionAuthParametersOauthOauthHttpParametersBodyArgs']]]]):
        pulumi.set(self, "bodies", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventConnectionAuthParametersOauthOauthHttpParametersHeaderArgs']]]]:
        """
        Contains additional header parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventConnectionAuthParametersOauthOauthHttpParametersHeaderArgs']]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter(name="queryStrings")
    def query_strings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventConnectionAuthParametersOauthOauthHttpParametersQueryStringArgs']]]]:
        """
        Contains additional query string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
        """
        return pulumi.get(self, "query_strings")

    @query_strings.setter
    def query_strings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventConnectionAuthParametersOauthOauthHttpParametersQueryStringArgs']]]]):
        pulumi.set(self, "query_strings", value)


@pulumi.input_type
class EventConnectionAuthParametersOauthOauthHttpParametersBodyArgs:
    def __init__(__self__, *,
                 is_value_secret: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] is_value_secret: Specified whether the value is secret.
        :param pulumi.Input[str] key: Header Name.
        :param pulumi.Input[str] value: Header Value. Created and stored in AWS Secrets Manager.
        """
        if is_value_secret is not None:
            pulumi.set(__self__, "is_value_secret", is_value_secret)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="isValueSecret")
    def is_value_secret(self) -> Optional[pulumi.Input[bool]]:
        """
        Specified whether the value is secret.
        """
        return pulumi.get(self, "is_value_secret")

    @is_value_secret.setter
    def is_value_secret(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_value_secret", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Header Name.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Header Value. Created and stored in AWS Secrets Manager.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class EventConnectionAuthParametersOauthOauthHttpParametersHeaderArgs:
    def __init__(__self__, *,
                 is_value_secret: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] is_value_secret: Specified whether the value is secret.
        :param pulumi.Input[str] key: Header Name.
        :param pulumi.Input[str] value: Header Value. Created and stored in AWS Secrets Manager.
        """
        if is_value_secret is not None:
            pulumi.set(__self__, "is_value_secret", is_value_secret)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="isValueSecret")
    def is_value_secret(self) -> Optional[pulumi.Input[bool]]:
        """
        Specified whether the value is secret.
        """
        return pulumi.get(self, "is_value_secret")

    @is_value_secret.setter
    def is_value_secret(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_value_secret", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Header Name.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Header Value. Created and stored in AWS Secrets Manager.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class EventConnectionAuthParametersOauthOauthHttpParametersQueryStringArgs:
    def __init__(__self__, *,
                 is_value_secret: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] is_value_secret: Specified whether the value is secret.
        :param pulumi.Input[str] key: Header Name.
        :param pulumi.Input[str] value: Header Value. Created and stored in AWS Secrets Manager.
        """
        if is_value_secret is not None:
            pulumi.set(__self__, "is_value_secret", is_value_secret)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="isValueSecret")
    def is_value_secret(self) -> Optional[pulumi.Input[bool]]:
        """
        Specified whether the value is secret.
        """
        return pulumi.get(self, "is_value_secret")

    @is_value_secret.setter
    def is_value_secret(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_value_secret", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Header Name.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Header Value. Created and stored in AWS Secrets Manager.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class EventEndpointEventBusArgs:
    def __init__(__self__, *,
                 event_bus_arn: pulumi.Input[str]):
        """
        :param pulumi.Input[str] event_bus_arn: The ARN of the event bus the endpoint is associated with.
        """
        pulumi.set(__self__, "event_bus_arn", event_bus_arn)

    @property
    @pulumi.getter(name="eventBusArn")
    def event_bus_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the event bus the endpoint is associated with.
        """
        return pulumi.get(self, "event_bus_arn")

    @event_bus_arn.setter
    def event_bus_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "event_bus_arn", value)


@pulumi.input_type
class EventEndpointReplicationConfigArgs:
    def __init__(__self__, *,
                 state: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] state: The state of event replication. Valid values: `ENABLED`, `DISABLED`. The default state is `ENABLED`, which means you must supply a `role_arn`. If you don't have a `role_arn` or you don't want event replication enabled, set `state` to `DISABLED`.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of event replication. Valid values: `ENABLED`, `DISABLED`. The default state is `ENABLED`, which means you must supply a `role_arn`. If you don't have a `role_arn` or you don't want event replication enabled, set `state` to `DISABLED`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class EventEndpointRoutingConfigArgs:
    def __init__(__self__, *,
                 failover_config: pulumi.Input['EventEndpointRoutingConfigFailoverConfigArgs']):
        """
        :param pulumi.Input['EventEndpointRoutingConfigFailoverConfigArgs'] failover_config: Parameters used for failover. This includes what triggers failover and what happens when it's triggered. Documented below.
        """
        pulumi.set(__self__, "failover_config", failover_config)

    @property
    @pulumi.getter(name="failoverConfig")
    def failover_config(self) -> pulumi.Input['EventEndpointRoutingConfigFailoverConfigArgs']:
        """
        Parameters used for failover. This includes what triggers failover and what happens when it's triggered. Documented below.
        """
        return pulumi.get(self, "failover_config")

    @failover_config.setter
    def failover_config(self, value: pulumi.Input['EventEndpointRoutingConfigFailoverConfigArgs']):
        pulumi.set(self, "failover_config", value)


@pulumi.input_type
class EventEndpointRoutingConfigFailoverConfigArgs:
    def __init__(__self__, *,
                 primary: pulumi.Input['EventEndpointRoutingConfigFailoverConfigPrimaryArgs'],
                 secondary: pulumi.Input['EventEndpointRoutingConfigFailoverConfigSecondaryArgs']):
        """
        :param pulumi.Input['EventEndpointRoutingConfigFailoverConfigPrimaryArgs'] primary: Parameters used for the primary Region. Documented below.
        :param pulumi.Input['EventEndpointRoutingConfigFailoverConfigSecondaryArgs'] secondary: Parameters used for the secondary Region, the Region that events are routed to when failover is triggered or event replication is enabled. Documented below.
        """
        pulumi.set(__self__, "primary", primary)
        pulumi.set(__self__, "secondary", secondary)

    @property
    @pulumi.getter
    def primary(self) -> pulumi.Input['EventEndpointRoutingConfigFailoverConfigPrimaryArgs']:
        """
        Parameters used for the primary Region. Documented below.
        """
        return pulumi.get(self, "primary")

    @primary.setter
    def primary(self, value: pulumi.Input['EventEndpointRoutingConfigFailoverConfigPrimaryArgs']):
        pulumi.set(self, "primary", value)

    @property
    @pulumi.getter
    def secondary(self) -> pulumi.Input['EventEndpointRoutingConfigFailoverConfigSecondaryArgs']:
        """
        Parameters used for the secondary Region, the Region that events are routed to when failover is triggered or event replication is enabled. Documented below.
        """
        return pulumi.get(self, "secondary")

    @secondary.setter
    def secondary(self, value: pulumi.Input['EventEndpointRoutingConfigFailoverConfigSecondaryArgs']):
        pulumi.set(self, "secondary", value)


@pulumi.input_type
class EventEndpointRoutingConfigFailoverConfigPrimaryArgs:
    def __init__(__self__, *,
                 health_check: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] health_check: The ARN of the health check used by the endpoint to determine whether failover is triggered.
        """
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the health check used by the endpoint to determine whether failover is triggered.
        """
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check", value)


@pulumi.input_type
class EventEndpointRoutingConfigFailoverConfigSecondaryArgs:
    def __init__(__self__, *,
                 route: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] route: The name of the secondary Region.
        """
        if route is not None:
            pulumi.set(__self__, "route", route)

    @property
    @pulumi.getter
    def route(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the secondary Region.
        """
        return pulumi.get(self, "route")

    @route.setter
    def route(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "route", value)


@pulumi.input_type
class EventPermissionConditionArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 type: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] key: Key for the condition. Valid values: `aws:PrincipalOrgID`.
        :param pulumi.Input[str] type: Type of condition. Value values: `StringEquals`.
        :param pulumi.Input[str] value: Value for the key.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        Key for the condition. Valid values: `aws:PrincipalOrgID`.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of condition. Value values: `StringEquals`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Value for the key.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class EventTargetBatchTargetArgs:
    def __init__(__self__, *,
                 job_definition: pulumi.Input[str],
                 job_name: pulumi.Input[str],
                 array_size: Optional[pulumi.Input[int]] = None,
                 job_attempts: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] job_definition: The ARN or name of the job definition to use if the event target is an AWS Batch job. This job definition must already exist.
        :param pulumi.Input[str] job_name: The name to use for this execution of the job, if the target is an AWS Batch job.
        :param pulumi.Input[int] array_size: The size of the array, if this is an array batch job. Valid values are integers between 2 and 10,000.
        :param pulumi.Input[int] job_attempts: The number of times to attempt to retry, if the job fails. Valid values are 1 to 10.
        """
        pulumi.set(__self__, "job_definition", job_definition)
        pulumi.set(__self__, "job_name", job_name)
        if array_size is not None:
            pulumi.set(__self__, "array_size", array_size)
        if job_attempts is not None:
            pulumi.set(__self__, "job_attempts", job_attempts)

    @property
    @pulumi.getter(name="jobDefinition")
    def job_definition(self) -> pulumi.Input[str]:
        """
        The ARN or name of the job definition to use if the event target is an AWS Batch job. This job definition must already exist.
        """
        return pulumi.get(self, "job_definition")

    @job_definition.setter
    def job_definition(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_definition", value)

    @property
    @pulumi.getter(name="jobName")
    def job_name(self) -> pulumi.Input[str]:
        """
        The name to use for this execution of the job, if the target is an AWS Batch job.
        """
        return pulumi.get(self, "job_name")

    @job_name.setter
    def job_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_name", value)

    @property
    @pulumi.getter(name="arraySize")
    def array_size(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the array, if this is an array batch job. Valid values are integers between 2 and 10,000.
        """
        return pulumi.get(self, "array_size")

    @array_size.setter
    def array_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "array_size", value)

    @property
    @pulumi.getter(name="jobAttempts")
    def job_attempts(self) -> Optional[pulumi.Input[int]]:
        """
        The number of times to attempt to retry, if the job fails. Valid values are 1 to 10.
        """
        return pulumi.get(self, "job_attempts")

    @job_attempts.setter
    def job_attempts(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "job_attempts", value)


@pulumi.input_type
class EventTargetDeadLetterConfigArgs:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] arn: ARN of the SQS queue specified as the target for the dead-letter queue.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the SQS queue specified as the target for the dead-letter queue.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)


@pulumi.input_type
class EventTargetEcsTargetArgs:
    def __init__(__self__, *,
                 task_definition_arn: pulumi.Input[str],
                 capacity_provider_strategies: Optional[pulumi.Input[Sequence[pulumi.Input['EventTargetEcsTargetCapacityProviderStrategyArgs']]]] = None,
                 enable_ecs_managed_tags: Optional[pulumi.Input[bool]] = None,
                 enable_execute_command: Optional[pulumi.Input[bool]] = None,
                 group: Optional[pulumi.Input[str]] = None,
                 launch_type: Optional[pulumi.Input[str]] = None,
                 network_configuration: Optional[pulumi.Input['EventTargetEcsTargetNetworkConfigurationArgs']] = None,
                 ordered_placement_strategies: Optional[pulumi.Input[Sequence[pulumi.Input['EventTargetEcsTargetOrderedPlacementStrategyArgs']]]] = None,
                 placement_constraints: Optional[pulumi.Input[Sequence[pulumi.Input['EventTargetEcsTargetPlacementConstraintArgs']]]] = None,
                 platform_version: Optional[pulumi.Input[str]] = None,
                 propagate_tags: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 task_count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] task_definition_arn: The ARN of the task definition to use if the event target is an Amazon ECS cluster.
        :param pulumi.Input[Sequence[pulumi.Input['EventTargetEcsTargetCapacityProviderStrategyArgs']]] capacity_provider_strategies: The capacity provider strategy to use for the task. If a `capacity_provider_strategy` specified, the `launch_type` parameter must be omitted. If no `capacity_provider_strategy` or `launch_type` is specified, the default capacity provider strategy for the cluster is used. Can be one or more. See below.
        :param pulumi.Input[bool] enable_ecs_managed_tags: Specifies whether to enable Amazon ECS managed tags for the task.
        :param pulumi.Input[bool] enable_execute_command: Whether or not to enable the execute command functionality for the containers in this task. If true, this enables execute command functionality on all containers in the task.
        :param pulumi.Input[str] group: Specifies an ECS task group for the task. The maximum length is 255 characters.
        :param pulumi.Input[str] launch_type: Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. Valid values include: `EC2`, `EXTERNAL`, or `FARGATE`.
        :param pulumi.Input['EventTargetEcsTargetNetworkConfigurationArgs'] network_configuration: Use this if the ECS task uses the awsvpc network mode. This specifies the VPC subnets and security groups associated with the task, and whether a public IP address is to be used. Required if `launch_type` is `FARGATE` because the awsvpc mode is required for Fargate tasks.
        :param pulumi.Input[Sequence[pulumi.Input['EventTargetEcsTargetOrderedPlacementStrategyArgs']]] ordered_placement_strategies: An array of placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task.
        :param pulumi.Input[Sequence[pulumi.Input['EventTargetEcsTargetPlacementConstraintArgs']]] placement_constraints: An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime). See Below.
        :param pulumi.Input[str] platform_version: Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as `1.1.0`. This is used only if LaunchType is FARGATE. For more information about valid platform versions, see [AWS Fargate Platform Versions](http://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
        :param pulumi.Input[str] propagate_tags: Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. The only valid value is: `TASK_DEFINITION`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to ecs resources.
        :param pulumi.Input[int] task_count: The number of tasks to create based on the TaskDefinition. Defaults to `1`.
        """
        pulumi.set(__self__, "task_definition_arn", task_definition_arn)
        if capacity_provider_strategies is not None:
            pulumi.set(__self__, "capacity_provider_strategies", capacity_provider_strategies)
        if enable_ecs_managed_tags is not None:
            pulumi.set(__self__, "enable_ecs_managed_tags", enable_ecs_managed_tags)
        if enable_execute_command is not None:
            pulumi.set(__self__, "enable_execute_command", enable_execute_command)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if launch_type is not None:
            pulumi.set(__self__, "launch_type", launch_type)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if ordered_placement_strategies is not None:
            pulumi.set(__self__, "ordered_placement_strategies", ordered_placement_strategies)
        if placement_constraints is not None:
            pulumi.set(__self__, "placement_constraints", placement_constraints)
        if platform_version is not None:
            pulumi.set(__self__, "platform_version", platform_version)
        if propagate_tags is not None:
            pulumi.set(__self__, "propagate_tags", propagate_tags)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if task_count is not None:
            pulumi.set(__self__, "task_count", task_count)

    @property
    @pulumi.getter(name="taskDefinitionArn")
    def task_definition_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the task definition to use if the event target is an Amazon ECS cluster.
        """
        return pulumi.get(self, "task_definition_arn")

    @task_definition_arn.setter
    def task_definition_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_definition_arn", value)

    @property
    @pulumi.getter(name="capacityProviderStrategies")
    def capacity_provider_strategies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventTargetEcsTargetCapacityProviderStrategyArgs']]]]:
        """
        The capacity provider strategy to use for the task. If a `capacity_provider_strategy` specified, the `launch_type` parameter must be omitted. If no `capacity_provider_strategy` or `launch_type` is specified, the default capacity provider strategy for the cluster is used. Can be one or more. See below.
        """
        return pulumi.get(self, "capacity_provider_strategies")

    @capacity_provider_strategies.setter
    def capacity_provider_strategies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventTargetEcsTargetCapacityProviderStrategyArgs']]]]):
        pulumi.set(self, "capacity_provider_strategies", value)

    @property
    @pulumi.getter(name="enableEcsManagedTags")
    def enable_ecs_managed_tags(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable Amazon ECS managed tags for the task.
        """
        return pulumi.get(self, "enable_ecs_managed_tags")

    @enable_ecs_managed_tags.setter
    def enable_ecs_managed_tags(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ecs_managed_tags", value)

    @property
    @pulumi.getter(name="enableExecuteCommand")
    def enable_execute_command(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to enable the execute command functionality for the containers in this task. If true, this enables execute command functionality on all containers in the task.
        """
        return pulumi.get(self, "enable_execute_command")

    @enable_execute_command.setter
    def enable_execute_command(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_execute_command", value)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies an ECS task group for the task. The maximum length is 255 characters.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter(name="launchType")
    def launch_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. Valid values include: `EC2`, `EXTERNAL`, or `FARGATE`.
        """
        return pulumi.get(self, "launch_type")

    @launch_type.setter
    def launch_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_type", value)

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['EventTargetEcsTargetNetworkConfigurationArgs']]:
        """
        Use this if the ECS task uses the awsvpc network mode. This specifies the VPC subnets and security groups associated with the task, and whether a public IP address is to be used. Required if `launch_type` is `FARGATE` because the awsvpc mode is required for Fargate tasks.
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['EventTargetEcsTargetNetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)

    @property
    @pulumi.getter(name="orderedPlacementStrategies")
    def ordered_placement_strategies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventTargetEcsTargetOrderedPlacementStrategyArgs']]]]:
        """
        An array of placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task.
        """
        return pulumi.get(self, "ordered_placement_strategies")

    @ordered_placement_strategies.setter
    def ordered_placement_strategies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventTargetEcsTargetOrderedPlacementStrategyArgs']]]]):
        pulumi.set(self, "ordered_placement_strategies", value)

    @property
    @pulumi.getter(name="placementConstraints")
    def placement_constraints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventTargetEcsTargetPlacementConstraintArgs']]]]:
        """
        An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime). See Below.
        """
        return pulumi.get(self, "placement_constraints")

    @placement_constraints.setter
    def placement_constraints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventTargetEcsTargetPlacementConstraintArgs']]]]):
        pulumi.set(self, "placement_constraints", value)

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as `1.1.0`. This is used only if LaunchType is FARGATE. For more information about valid platform versions, see [AWS Fargate Platform Versions](http://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
        """
        return pulumi.get(self, "platform_version")

    @platform_version.setter
    def platform_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform_version", value)

    @property
    @pulumi.getter(name="propagateTags")
    def propagate_tags(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. The only valid value is: `TASK_DEFINITION`.
        """
        return pulumi.get(self, "propagate_tags")

    @propagate_tags.setter
    def propagate_tags(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "propagate_tags", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to ecs resources.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="taskCount")
    def task_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of tasks to create based on the TaskDefinition. Defaults to `1`.
        """
        return pulumi.get(self, "task_count")

    @task_count.setter
    def task_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "task_count", value)


@pulumi.input_type
class EventTargetEcsTargetCapacityProviderStrategyArgs:
    def __init__(__self__, *,
                 capacity_provider: pulumi.Input[str],
                 base: Optional[pulumi.Input[int]] = None,
                 weight: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] capacity_provider: Short name of the capacity provider.
        :param pulumi.Input[int] base: The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. Defaults to `0`.
        :param pulumi.Input[int] weight: The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied.
        """
        pulumi.set(__self__, "capacity_provider", capacity_provider)
        if base is not None:
            pulumi.set(__self__, "base", base)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="capacityProvider")
    def capacity_provider(self) -> pulumi.Input[str]:
        """
        Short name of the capacity provider.
        """
        return pulumi.get(self, "capacity_provider")

    @capacity_provider.setter
    def capacity_provider(self, value: pulumi.Input[str]):
        pulumi.set(self, "capacity_provider", value)

    @property
    @pulumi.getter
    def base(self) -> Optional[pulumi.Input[int]]:
        """
        The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. Defaults to `0`.
        """
        return pulumi.get(self, "base")

    @base.setter
    def base(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "base", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[int]]:
        """
        The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class EventTargetEcsTargetNetworkConfigurationArgs:
    def __init__(__self__, *,
                 subnets: pulumi.Input[Sequence[pulumi.Input[str]]],
                 assign_public_ip: Optional[pulumi.Input[bool]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnets: The subnets associated with the task or service.
        :param pulumi.Input[bool] assign_public_ip: Assign a public IP address to the ENI (Fargate launch type only). Valid values are `true` or `false`. Defaults to `false`.
               
               For more information, see [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: The security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used.
        """
        pulumi.set(__self__, "subnets", subnets)
        if assign_public_ip is not None:
            pulumi.set(__self__, "assign_public_ip", assign_public_ip)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)

    @property
    @pulumi.getter
    def subnets(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The subnets associated with the task or service.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "subnets", value)

    @property
    @pulumi.getter(name="assignPublicIp")
    def assign_public_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Assign a public IP address to the ENI (Fargate launch type only). Valid values are `true` or `false`. Defaults to `false`.

        For more information, see [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html)
        """
        return pulumi.get(self, "assign_public_ip")

    @assign_public_ip.setter
    def assign_public_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "assign_public_ip", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_groups", value)


@pulumi.input_type
class EventTargetEcsTargetOrderedPlacementStrategyArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 field: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: Type of placement strategy. The only valid values at this time are `binpack`, `random` and `spread`.
        :param pulumi.Input[str] field: The field to apply the placement strategy against. For the `spread` placement strategy, valid values are `instanceId` (or `host`, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as `attribute:ecs.availability-zone`. For the `binpack` placement strategy, valid values are `cpu` and `memory`. For the `random` placement strategy, this field is not used. For more information, see [Amazon ECS task placement strategies](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html).
        """
        pulumi.set(__self__, "type", type)
        if field is not None:
            pulumi.set(__self__, "field", field)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of placement strategy. The only valid values at this time are `binpack`, `random` and `spread`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def field(self) -> Optional[pulumi.Input[str]]:
        """
        The field to apply the placement strategy against. For the `spread` placement strategy, valid values are `instanceId` (or `host`, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as `attribute:ecs.availability-zone`. For the `binpack` placement strategy, valid values are `cpu` and `memory`. For the `random` placement strategy, this field is not used. For more information, see [Amazon ECS task placement strategies](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html).
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field", value)


@pulumi.input_type
class EventTargetEcsTargetPlacementConstraintArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 expression: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: Type of constraint. The only valid values at this time are `memberOf` and `distinctInstance`.
        :param pulumi.Input[str] expression: Cluster Query Language expression to apply to the constraint. Does not need to be specified for the `distinctInstance` type. For more information, see [Cluster Query Language in the Amazon EC2 Container Service Developer Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html).
        """
        pulumi.set(__self__, "type", type)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of constraint. The only valid values at this time are `memberOf` and `distinctInstance`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster Query Language expression to apply to the constraint. Does not need to be specified for the `distinctInstance` type. For more information, see [Cluster Query Language in the Amazon EC2 Container Service Developer Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html).
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)


@pulumi.input_type
class EventTargetHttpTargetArgs:
    def __init__(__self__, *,
                 header_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 path_parameter_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 query_string_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] header_parameters: Enables you to specify HTTP headers to add to the request.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] path_parameter_values: The list of values that correspond sequentially to any path variables in your endpoint ARN (for example `arn:aws:execute-api:us-east-1:123456:myapi/*/POST/pets/*`).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] query_string_parameters: Represents keys/values of query string parameters that are appended to the invoked endpoint.
        """
        if header_parameters is not None:
            pulumi.set(__self__, "header_parameters", header_parameters)
        if path_parameter_values is not None:
            pulumi.set(__self__, "path_parameter_values", path_parameter_values)
        if query_string_parameters is not None:
            pulumi.set(__self__, "query_string_parameters", query_string_parameters)

    @property
    @pulumi.getter(name="headerParameters")
    def header_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Enables you to specify HTTP headers to add to the request.
        """
        return pulumi.get(self, "header_parameters")

    @header_parameters.setter
    def header_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "header_parameters", value)

    @property
    @pulumi.getter(name="pathParameterValues")
    def path_parameter_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of values that correspond sequentially to any path variables in your endpoint ARN (for example `arn:aws:execute-api:us-east-1:123456:myapi/*/POST/pets/*`).
        """
        return pulumi.get(self, "path_parameter_values")

    @path_parameter_values.setter
    def path_parameter_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "path_parameter_values", value)

    @property
    @pulumi.getter(name="queryStringParameters")
    def query_string_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Represents keys/values of query string parameters that are appended to the invoked endpoint.
        """
        return pulumi.get(self, "query_string_parameters")

    @query_string_parameters.setter
    def query_string_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "query_string_parameters", value)


@pulumi.input_type
class EventTargetInputTransformerArgs:
    def __init__(__self__, *,
                 input_template: pulumi.Input[str],
                 input_paths: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] input_template: Template to customize data sent to the target. Must be valid JSON. To send a string value, the string value must include double quotes.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] input_paths: Key value pairs specified in the form of JSONPath (for example, time = $.time)
               * You can have as many as 100 key-value pairs.
               * You must use JSON dot notation, not bracket notation.
               * The keys can't start with "AWS".
        """
        pulumi.set(__self__, "input_template", input_template)
        if input_paths is not None:
            pulumi.set(__self__, "input_paths", input_paths)

    @property
    @pulumi.getter(name="inputTemplate")
    def input_template(self) -> pulumi.Input[str]:
        """
        Template to customize data sent to the target. Must be valid JSON. To send a string value, the string value must include double quotes.
        """
        return pulumi.get(self, "input_template")

    @input_template.setter
    def input_template(self, value: pulumi.Input[str]):
        pulumi.set(self, "input_template", value)

    @property
    @pulumi.getter(name="inputPaths")
    def input_paths(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key value pairs specified in the form of JSONPath (for example, time = $.time)
        * You can have as many as 100 key-value pairs.
        * You must use JSON dot notation, not bracket notation.
        * The keys can't start with "AWS".
        """
        return pulumi.get(self, "input_paths")

    @input_paths.setter
    def input_paths(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "input_paths", value)


@pulumi.input_type
class EventTargetKinesisTargetArgs:
    def __init__(__self__, *,
                 partition_key_path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] partition_key_path: The JSON path to be extracted from the event and used as the partition key.
        """
        if partition_key_path is not None:
            pulumi.set(__self__, "partition_key_path", partition_key_path)

    @property
    @pulumi.getter(name="partitionKeyPath")
    def partition_key_path(self) -> Optional[pulumi.Input[str]]:
        """
        The JSON path to be extracted from the event and used as the partition key.
        """
        return pulumi.get(self, "partition_key_path")

    @partition_key_path.setter
    def partition_key_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "partition_key_path", value)


@pulumi.input_type
class EventTargetRedshiftTargetArgs:
    def __init__(__self__, *,
                 database: pulumi.Input[str],
                 db_user: Optional[pulumi.Input[str]] = None,
                 secrets_manager_arn: Optional[pulumi.Input[str]] = None,
                 sql: Optional[pulumi.Input[str]] = None,
                 statement_name: Optional[pulumi.Input[str]] = None,
                 with_event: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] database: The name of the database.
        :param pulumi.Input[str] db_user: The database user name.
        :param pulumi.Input[str] secrets_manager_arn: The name or ARN of the secret that enables access to the database.
        :param pulumi.Input[str] sql: The SQL statement text to run.
        :param pulumi.Input[str] statement_name: The name of the SQL statement.
        :param pulumi.Input[bool] with_event: Indicates whether to send an event back to EventBridge after the SQL statement runs.
        """
        pulumi.set(__self__, "database", database)
        if db_user is not None:
            pulumi.set(__self__, "db_user", db_user)
        if secrets_manager_arn is not None:
            pulumi.set(__self__, "secrets_manager_arn", secrets_manager_arn)
        if sql is not None:
            pulumi.set(__self__, "sql", sql)
        if statement_name is not None:
            pulumi.set(__self__, "statement_name", statement_name)
        if with_event is not None:
            pulumi.set(__self__, "with_event", with_event)

    @property
    @pulumi.getter
    def database(self) -> pulumi.Input[str]:
        """
        The name of the database.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[str]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter(name="dbUser")
    def db_user(self) -> Optional[pulumi.Input[str]]:
        """
        The database user name.
        """
        return pulumi.get(self, "db_user")

    @db_user.setter
    def db_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_user", value)

    @property
    @pulumi.getter(name="secretsManagerArn")
    def secrets_manager_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The name or ARN of the secret that enables access to the database.
        """
        return pulumi.get(self, "secrets_manager_arn")

    @secrets_manager_arn.setter
    def secrets_manager_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secrets_manager_arn", value)

    @property
    @pulumi.getter
    def sql(self) -> Optional[pulumi.Input[str]]:
        """
        The SQL statement text to run.
        """
        return pulumi.get(self, "sql")

    @sql.setter
    def sql(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sql", value)

    @property
    @pulumi.getter(name="statementName")
    def statement_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the SQL statement.
        """
        return pulumi.get(self, "statement_name")

    @statement_name.setter
    def statement_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "statement_name", value)

    @property
    @pulumi.getter(name="withEvent")
    def with_event(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to send an event back to EventBridge after the SQL statement runs.
        """
        return pulumi.get(self, "with_event")

    @with_event.setter
    def with_event(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "with_event", value)


@pulumi.input_type
class EventTargetRetryPolicyArgs:
    def __init__(__self__, *,
                 maximum_event_age_in_seconds: Optional[pulumi.Input[int]] = None,
                 maximum_retry_attempts: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] maximum_event_age_in_seconds: The age in seconds to continue to make retry attempts.
        :param pulumi.Input[int] maximum_retry_attempts: maximum number of retry attempts to make before the request fails
        """
        if maximum_event_age_in_seconds is not None:
            pulumi.set(__self__, "maximum_event_age_in_seconds", maximum_event_age_in_seconds)
        if maximum_retry_attempts is not None:
            pulumi.set(__self__, "maximum_retry_attempts", maximum_retry_attempts)

    @property
    @pulumi.getter(name="maximumEventAgeInSeconds")
    def maximum_event_age_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The age in seconds to continue to make retry attempts.
        """
        return pulumi.get(self, "maximum_event_age_in_seconds")

    @maximum_event_age_in_seconds.setter
    def maximum_event_age_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum_event_age_in_seconds", value)

    @property
    @pulumi.getter(name="maximumRetryAttempts")
    def maximum_retry_attempts(self) -> Optional[pulumi.Input[int]]:
        """
        maximum number of retry attempts to make before the request fails
        """
        return pulumi.get(self, "maximum_retry_attempts")

    @maximum_retry_attempts.setter
    def maximum_retry_attempts(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum_retry_attempts", value)


@pulumi.input_type
class EventTargetRunCommandTargetArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 values: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[str] key: Can be either `tag:tag-key` or `InstanceIds`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: If Key is `tag:tag-key`, Values is a list of tag values. If Key is `InstanceIds`, Values is a list of Amazon EC2 instance IDs.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        Can be either `tag:tag-key` or `InstanceIds`.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        If Key is `tag:tag-key`, Values is a list of tag values. If Key is `InstanceIds`, Values is a list of Amazon EC2 instance IDs.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class EventTargetSagemakerPipelineTargetArgs:
    def __init__(__self__, *,
                 pipeline_parameter_lists: Optional[pulumi.Input[Sequence[pulumi.Input['EventTargetSagemakerPipelineTargetPipelineParameterListArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['EventTargetSagemakerPipelineTargetPipelineParameterListArgs']]] pipeline_parameter_lists: List of Parameter names and values for SageMaker Model Building Pipeline execution.
        """
        if pipeline_parameter_lists is not None:
            pulumi.set(__self__, "pipeline_parameter_lists", pipeline_parameter_lists)

    @property
    @pulumi.getter(name="pipelineParameterLists")
    def pipeline_parameter_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventTargetSagemakerPipelineTargetPipelineParameterListArgs']]]]:
        """
        List of Parameter names and values for SageMaker Model Building Pipeline execution.
        """
        return pulumi.get(self, "pipeline_parameter_lists")

    @pipeline_parameter_lists.setter
    def pipeline_parameter_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventTargetSagemakerPipelineTargetPipelineParameterListArgs']]]]):
        pulumi.set(self, "pipeline_parameter_lists", value)


@pulumi.input_type
class EventTargetSagemakerPipelineTargetPipelineParameterListArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: Name of parameter to start execution of a SageMaker Model Building Pipeline.
        :param pulumi.Input[str] value: Value of parameter to start execution of a SageMaker Model Building Pipeline.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of parameter to start execution of a SageMaker Model Building Pipeline.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Value of parameter to start execution of a SageMaker Model Building Pipeline.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class EventTargetSqsTargetArgs:
    def __init__(__self__, *,
                 message_group_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] message_group_id: The FIFO message group ID to use as the target.
        """
        if message_group_id is not None:
            pulumi.set(__self__, "message_group_id", message_group_id)

    @property
    @pulumi.getter(name="messageGroupId")
    def message_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The FIFO message group ID to use as the target.
        """
        return pulumi.get(self, "message_group_id")

    @message_group_id.setter
    def message_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_group_id", value)


@pulumi.input_type
class InternetMonitorHealthEventsConfigArgs:
    def __init__(__self__, *,
                 availability_score_threshold: Optional[pulumi.Input[float]] = None,
                 performance_score_threshold: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[float] availability_score_threshold: The health event threshold percentage set for availability scores.
        :param pulumi.Input[float] performance_score_threshold: The health event threshold percentage set for performance scores.
        """
        if availability_score_threshold is not None:
            pulumi.set(__self__, "availability_score_threshold", availability_score_threshold)
        if performance_score_threshold is not None:
            pulumi.set(__self__, "performance_score_threshold", performance_score_threshold)

    @property
    @pulumi.getter(name="availabilityScoreThreshold")
    def availability_score_threshold(self) -> Optional[pulumi.Input[float]]:
        """
        The health event threshold percentage set for availability scores.
        """
        return pulumi.get(self, "availability_score_threshold")

    @availability_score_threshold.setter
    def availability_score_threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "availability_score_threshold", value)

    @property
    @pulumi.getter(name="performanceScoreThreshold")
    def performance_score_threshold(self) -> Optional[pulumi.Input[float]]:
        """
        The health event threshold percentage set for performance scores.
        """
        return pulumi.get(self, "performance_score_threshold")

    @performance_score_threshold.setter
    def performance_score_threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "performance_score_threshold", value)


@pulumi.input_type
class InternetMonitorInternetMeasurementsLogDeliveryArgs:
    def __init__(__self__, *,
                 s3_config: Optional[pulumi.Input['InternetMonitorInternetMeasurementsLogDeliveryS3ConfigArgs']] = None):
        if s3_config is not None:
            pulumi.set(__self__, "s3_config", s3_config)

    @property
    @pulumi.getter(name="s3Config")
    def s3_config(self) -> Optional[pulumi.Input['InternetMonitorInternetMeasurementsLogDeliveryS3ConfigArgs']]:
        return pulumi.get(self, "s3_config")

    @s3_config.setter
    def s3_config(self, value: Optional[pulumi.Input['InternetMonitorInternetMeasurementsLogDeliveryS3ConfigArgs']]):
        pulumi.set(self, "s3_config", value)


@pulumi.input_type
class InternetMonitorInternetMeasurementsLogDeliveryS3ConfigArgs:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[str],
                 bucket_prefix: Optional[pulumi.Input[str]] = None,
                 log_delivery_status: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "bucket_name", bucket_name)
        if bucket_prefix is not None:
            pulumi.set(__self__, "bucket_prefix", bucket_prefix)
        if log_delivery_status is not None:
            pulumi.set(__self__, "log_delivery_status", log_delivery_status)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "bucket_prefix")

    @bucket_prefix.setter
    def bucket_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket_prefix", value)

    @property
    @pulumi.getter(name="logDeliveryStatus")
    def log_delivery_status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "log_delivery_status")

    @log_delivery_status.setter
    def log_delivery_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_delivery_status", value)


@pulumi.input_type
class LogMetricFilterMetricTransformationArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 namespace: pulumi.Input[str],
                 value: pulumi.Input[str],
                 default_value: Optional[pulumi.Input[str]] = None,
                 dimensions: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 unit: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The name of the CloudWatch metric to which the monitored log information should be published (e.g., `ErrorCount`)
        :param pulumi.Input[str] namespace: The destination namespace of the CloudWatch metric.
        :param pulumi.Input[str] value: What to publish to the metric. For example, if you're counting the occurrences of a particular term like "Error", the value will be "1" for each occurrence. If you're counting the bytes transferred the published value will be the value in the log event.
        :param pulumi.Input[str] default_value: The value to emit when a filter pattern does not match a log event. Conflicts with `dimensions`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] dimensions: Map of fields to use as dimensions for the metric. Up to 3 dimensions are allowed. Conflicts with `default_value`.
        :param pulumi.Input[str] unit: The unit to assign to the metric. If you omit this, the unit is set as `None`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "value", value)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the CloudWatch metric to which the monitored log information should be published (e.g., `ErrorCount`)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        The destination namespace of the CloudWatch metric.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        What to publish to the metric. For example, if you're counting the occurrences of a particular term like "Error", the value will be "1" for each occurrence. If you're counting the bytes transferred the published value will be the value in the log event.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[pulumi.Input[str]]:
        """
        The value to emit when a filter pattern does not match a log event. Conflicts with `dimensions`.
        """
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_value", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of fields to use as dimensions for the metric. Up to 3 dimensions are allowed. Conflicts with `default_value`.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input[str]]:
        """
        The unit to assign to the metric. If you omit this, the unit is set as `None`.
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unit", value)


@pulumi.input_type
class MetricAlarmMetricQueryArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 account_id: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 metric: Optional[pulumi.Input['MetricAlarmMetricQueryMetricArgs']] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 return_data: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] id: A short name used to tie this object to the results in the response. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the mathematical expression. The valid characters are letters, numbers, and underscore. The first character must be a lowercase letter.
        :param pulumi.Input[str] account_id: The ID of the account where the metrics are located, if this is a cross-account alarm.
        :param pulumi.Input[str] expression: The math expression to be performed on the returned data, if this object is performing a math expression. This expression can use the id of the other metrics to refer to those metrics, and can also use the id of other expressions to use the result of those expressions. For more information about metric math expressions, see Metric Math Syntax and Functions in the [Amazon CloudWatch User Guide](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax).
        :param pulumi.Input[str] label: A human-readable label for this metric or expression. This is especially useful if this is an expression, so that you know what the value represents.
        :param pulumi.Input['MetricAlarmMetricQueryMetricArgs'] metric: The metric to be returned, along with statistics, period, and units. Use this parameter only if this object is retrieving a metric and not performing a math expression on returned data.
        :param pulumi.Input[int] period: Granularity in seconds of returned data points.
               For metrics with regular resolution, valid values are any multiple of `60`.
               For high-resolution metrics, valid values are `1`, `5`, `10`, `30`, or any multiple of `60`.
        :param pulumi.Input[bool] return_data: Specify exactly one `metric_query` to be `true` to use that `metric_query` result as the alarm.
               
               > **NOTE:**  You must specify either `metric` or `expression`. Not both.
        """
        pulumi.set(__self__, "id", id)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if return_data is not None:
            pulumi.set(__self__, "return_data", return_data)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        A short name used to tie this object to the results in the response. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the mathematical expression. The valid characters are letters, numbers, and underscore. The first character must be a lowercase letter.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the account where the metrics are located, if this is a cross-account alarm.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        The math expression to be performed on the returned data, if this object is performing a math expression. This expression can use the id of the other metrics to refer to those metrics, and can also use the id of other expressions to use the result of those expressions. For more information about metric math expressions, see Metric Math Syntax and Functions in the [Amazon CloudWatch User Guide](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax).
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        A human-readable label for this metric or expression. This is especially useful if this is an expression, so that you know what the value represents.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def metric(self) -> Optional[pulumi.Input['MetricAlarmMetricQueryMetricArgs']]:
        """
        The metric to be returned, along with statistics, period, and units. Use this parameter only if this object is retrieving a metric and not performing a math expression on returned data.
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: Optional[pulumi.Input['MetricAlarmMetricQueryMetricArgs']]):
        pulumi.set(self, "metric", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Granularity in seconds of returned data points.
        For metrics with regular resolution, valid values are any multiple of `60`.
        For high-resolution metrics, valid values are `1`, `5`, `10`, `30`, or any multiple of `60`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="returnData")
    def return_data(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify exactly one `metric_query` to be `true` to use that `metric_query` result as the alarm.

        > **NOTE:**  You must specify either `metric` or `expression`. Not both.
        """
        return pulumi.get(self, "return_data")

    @return_data.setter
    def return_data(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "return_data", value)


@pulumi.input_type
class MetricAlarmMetricQueryMetricArgs:
    def __init__(__self__, *,
                 metric_name: pulumi.Input[str],
                 period: pulumi.Input[int],
                 stat: pulumi.Input[str],
                 dimensions: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 unit: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] metric_name: The name for this metric.
               See docs for [supported metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
        :param pulumi.Input[int] period: Granularity in seconds of returned data points.
               For metrics with regular resolution, valid values are any multiple of `60`.
               For high-resolution metrics, valid values are `1`, `5`, `10`, `30`, or any multiple of `60`.
        :param pulumi.Input[str] stat: The statistic to apply to this metric.
               See docs for [supported statistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] dimensions: The dimensions for this metric.  For the list of available dimensions see the AWS documentation [here](http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
        :param pulumi.Input[str] namespace: The namespace for this metric. See docs for the [list of namespaces](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/aws-namespaces.html).
               See docs for [supported metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
        :param pulumi.Input[str] unit: The unit for this metric.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "period", period)
        pulumi.set(__self__, "stat", stat)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[str]:
        """
        The name for this metric.
        See docs for [supported metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter
    def period(self) -> pulumi.Input[int]:
        """
        Granularity in seconds of returned data points.
        For metrics with regular resolution, valid values are any multiple of `60`.
        For high-resolution metrics, valid values are `1`, `5`, `10`, `30`, or any multiple of `60`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: pulumi.Input[int]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def stat(self) -> pulumi.Input[str]:
        """
        The statistic to apply to this metric.
        See docs for [supported statistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html).
        """
        return pulumi.get(self, "stat")

    @stat.setter
    def stat(self, value: pulumi.Input[str]):
        pulumi.set(self, "stat", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The dimensions for this metric.  For the list of available dimensions see the AWS documentation [here](http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace for this metric. See docs for the [list of namespaces](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/aws-namespaces.html).
        See docs for [supported metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input[str]]:
        """
        The unit for this metric.
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unit", value)


@pulumi.input_type
class MetricStreamExcludeFilterArgs:
    def __init__(__self__, *,
                 namespace: pulumi.Input[str],
                 metric_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] namespace: Name of the metric namespace in the filter.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] metric_names: An array that defines the metrics you want to exclude for this metric namespace
        """
        pulumi.set(__self__, "namespace", namespace)
        if metric_names is not None:
            pulumi.set(__self__, "metric_names", metric_names)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        Name of the metric namespace in the filter.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="metricNames")
    def metric_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array that defines the metrics you want to exclude for this metric namespace
        """
        return pulumi.get(self, "metric_names")

    @metric_names.setter
    def metric_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "metric_names", value)


@pulumi.input_type
class MetricStreamIncludeFilterArgs:
    def __init__(__self__, *,
                 namespace: pulumi.Input[str],
                 metric_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] namespace: Name of the metric namespace in the filter.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] metric_names: An array that defines the metrics you want to include for this metric namespace
        """
        pulumi.set(__self__, "namespace", namespace)
        if metric_names is not None:
            pulumi.set(__self__, "metric_names", metric_names)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        Name of the metric namespace in the filter.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="metricNames")
    def metric_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array that defines the metrics you want to include for this metric namespace
        """
        return pulumi.get(self, "metric_names")

    @metric_names.setter
    def metric_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "metric_names", value)


@pulumi.input_type
class MetricStreamStatisticsConfigurationArgs:
    def __init__(__self__, *,
                 additional_statistics: pulumi.Input[Sequence[pulumi.Input[str]]],
                 include_metrics: pulumi.Input[Sequence[pulumi.Input['MetricStreamStatisticsConfigurationIncludeMetricArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] additional_statistics: The additional statistics to stream for the metrics listed in `include_metrics`.
        :param pulumi.Input[Sequence[pulumi.Input['MetricStreamStatisticsConfigurationIncludeMetricArgs']]] include_metrics: An array that defines the metrics that are to have additional statistics streamed. See details below.
        """
        pulumi.set(__self__, "additional_statistics", additional_statistics)
        pulumi.set(__self__, "include_metrics", include_metrics)

    @property
    @pulumi.getter(name="additionalStatistics")
    def additional_statistics(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The additional statistics to stream for the metrics listed in `include_metrics`.
        """
        return pulumi.get(self, "additional_statistics")

    @additional_statistics.setter
    def additional_statistics(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "additional_statistics", value)

    @property
    @pulumi.getter(name="includeMetrics")
    def include_metrics(self) -> pulumi.Input[Sequence[pulumi.Input['MetricStreamStatisticsConfigurationIncludeMetricArgs']]]:
        """
        An array that defines the metrics that are to have additional statistics streamed. See details below.
        """
        return pulumi.get(self, "include_metrics")

    @include_metrics.setter
    def include_metrics(self, value: pulumi.Input[Sequence[pulumi.Input['MetricStreamStatisticsConfigurationIncludeMetricArgs']]]):
        pulumi.set(self, "include_metrics", value)


@pulumi.input_type
class MetricStreamStatisticsConfigurationIncludeMetricArgs:
    def __init__(__self__, *,
                 metric_name: pulumi.Input[str],
                 namespace: pulumi.Input[str]):
        """
        :param pulumi.Input[str] metric_name: The name of the metric.
        :param pulumi.Input[str] namespace: Name of the metric namespace in the filter.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[str]:
        """
        The name of the metric.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        Name of the metric namespace in the filter.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)


@pulumi.input_type
class GetLogDataProtectionPolicyDocumentStatementArgs:
    def __init__(__self__, *,
                 data_identifiers: Sequence[str],
                 operation: 'GetLogDataProtectionPolicyDocumentStatementOperationArgs',
                 sid: Optional[str] = None):
        """
        :param Sequence[str] data_identifiers: Set of at least 1 sensitive data identifiers that you want to mask. Read more in [Types of data that you can protect](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/protect-sensitive-log-data-types.html).
        :param 'GetLogDataProtectionPolicyDocumentStatementOperationArgs' operation: Configures the data protection operation applied by this statement.
        :param str sid: Name of this statement.
        """
        pulumi.set(__self__, "data_identifiers", data_identifiers)
        pulumi.set(__self__, "operation", operation)
        if sid is not None:
            pulumi.set(__self__, "sid", sid)

    @property
    @pulumi.getter(name="dataIdentifiers")
    def data_identifiers(self) -> Sequence[str]:
        """
        Set of at least 1 sensitive data identifiers that you want to mask. Read more in [Types of data that you can protect](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/protect-sensitive-log-data-types.html).
        """
        return pulumi.get(self, "data_identifiers")

    @data_identifiers.setter
    def data_identifiers(self, value: Sequence[str]):
        pulumi.set(self, "data_identifiers", value)

    @property
    @pulumi.getter
    def operation(self) -> 'GetLogDataProtectionPolicyDocumentStatementOperationArgs':
        """
        Configures the data protection operation applied by this statement.
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: 'GetLogDataProtectionPolicyDocumentStatementOperationArgs'):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter
    def sid(self) -> Optional[str]:
        """
        Name of this statement.
        """
        return pulumi.get(self, "sid")

    @sid.setter
    def sid(self, value: Optional[str]):
        pulumi.set(self, "sid", value)


@pulumi.input_type
class GetLogDataProtectionPolicyDocumentStatementOperationArgs:
    def __init__(__self__, *,
                 audit: Optional['GetLogDataProtectionPolicyDocumentStatementOperationAuditArgs'] = None,
                 deidentify: Optional['GetLogDataProtectionPolicyDocumentStatementOperationDeidentifyArgs'] = None):
        """
        :param 'GetLogDataProtectionPolicyDocumentStatementOperationAuditArgs' audit: Configures the detection of sensitive data.
        :param 'GetLogDataProtectionPolicyDocumentStatementOperationDeidentifyArgs' deidentify: Configures the masking of sensitive data.
               
               > Every policy statement must specify exactly one operation.
        """
        if audit is not None:
            pulumi.set(__self__, "audit", audit)
        if deidentify is not None:
            pulumi.set(__self__, "deidentify", deidentify)

    @property
    @pulumi.getter
    def audit(self) -> Optional['GetLogDataProtectionPolicyDocumentStatementOperationAuditArgs']:
        """
        Configures the detection of sensitive data.
        """
        return pulumi.get(self, "audit")

    @audit.setter
    def audit(self, value: Optional['GetLogDataProtectionPolicyDocumentStatementOperationAuditArgs']):
        pulumi.set(self, "audit", value)

    @property
    @pulumi.getter
    def deidentify(self) -> Optional['GetLogDataProtectionPolicyDocumentStatementOperationDeidentifyArgs']:
        """
        Configures the masking of sensitive data.

        > Every policy statement must specify exactly one operation.
        """
        return pulumi.get(self, "deidentify")

    @deidentify.setter
    def deidentify(self, value: Optional['GetLogDataProtectionPolicyDocumentStatementOperationDeidentifyArgs']):
        pulumi.set(self, "deidentify", value)


@pulumi.input_type
class GetLogDataProtectionPolicyDocumentStatementOperationAuditArgs:
    def __init__(__self__, *,
                 findings_destination: 'GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationArgs'):
        """
        :param 'GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationArgs' findings_destination: Configures destinations to send audit findings to.
        """
        pulumi.set(__self__, "findings_destination", findings_destination)

    @property
    @pulumi.getter(name="findingsDestination")
    def findings_destination(self) -> 'GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationArgs':
        """
        Configures destinations to send audit findings to.
        """
        return pulumi.get(self, "findings_destination")

    @findings_destination.setter
    def findings_destination(self, value: 'GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationArgs'):
        pulumi.set(self, "findings_destination", value)


@pulumi.input_type
class GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationArgs:
    def __init__(__self__, *,
                 cloudwatch_logs: Optional['GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationCloudwatchLogsArgs'] = None,
                 firehose: Optional['GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationFirehoseArgs'] = None,
                 s3: Optional['GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationS3Args'] = None):
        """
        :param 'GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationCloudwatchLogsArgs' cloudwatch_logs: Configures CloudWatch Logs as a findings destination.
        :param 'GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationFirehoseArgs' firehose: Configures Kinesis Firehose as a findings destination.
        :param 'GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationS3Args' s3: Configures S3 as a findings destination.
        """
        if cloudwatch_logs is not None:
            pulumi.set(__self__, "cloudwatch_logs", cloudwatch_logs)
        if firehose is not None:
            pulumi.set(__self__, "firehose", firehose)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)

    @property
    @pulumi.getter(name="cloudwatchLogs")
    def cloudwatch_logs(self) -> Optional['GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationCloudwatchLogsArgs']:
        """
        Configures CloudWatch Logs as a findings destination.
        """
        return pulumi.get(self, "cloudwatch_logs")

    @cloudwatch_logs.setter
    def cloudwatch_logs(self, value: Optional['GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationCloudwatchLogsArgs']):
        pulumi.set(self, "cloudwatch_logs", value)

    @property
    @pulumi.getter
    def firehose(self) -> Optional['GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationFirehoseArgs']:
        """
        Configures Kinesis Firehose as a findings destination.
        """
        return pulumi.get(self, "firehose")

    @firehose.setter
    def firehose(self, value: Optional['GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationFirehoseArgs']):
        pulumi.set(self, "firehose", value)

    @property
    @pulumi.getter
    def s3(self) -> Optional['GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationS3Args']:
        """
        Configures S3 as a findings destination.
        """
        return pulumi.get(self, "s3")

    @s3.setter
    def s3(self, value: Optional['GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationS3Args']):
        pulumi.set(self, "s3", value)


@pulumi.input_type
class GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationCloudwatchLogsArgs:
    def __init__(__self__, *,
                 log_group: str):
        """
        :param str log_group: Name of the CloudWatch Log Group to send findings to.
        """
        pulumi.set(__self__, "log_group", log_group)

    @property
    @pulumi.getter(name="logGroup")
    def log_group(self) -> str:
        """
        Name of the CloudWatch Log Group to send findings to.
        """
        return pulumi.get(self, "log_group")

    @log_group.setter
    def log_group(self, value: str):
        pulumi.set(self, "log_group", value)


@pulumi.input_type
class GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationFirehoseArgs:
    def __init__(__self__, *,
                 delivery_stream: str):
        """
        :param str delivery_stream: Name of the Kinesis Firehose Delivery Stream to send findings to.
        """
        pulumi.set(__self__, "delivery_stream", delivery_stream)

    @property
    @pulumi.getter(name="deliveryStream")
    def delivery_stream(self) -> str:
        """
        Name of the Kinesis Firehose Delivery Stream to send findings to.
        """
        return pulumi.get(self, "delivery_stream")

    @delivery_stream.setter
    def delivery_stream(self, value: str):
        pulumi.set(self, "delivery_stream", value)


@pulumi.input_type
class GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationS3Args:
    def __init__(__self__, *,
                 bucket: str):
        """
        :param str bucket: Name of the S3 Bucket to send findings to.
        """
        pulumi.set(__self__, "bucket", bucket)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Name of the S3 Bucket to send findings to.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: str):
        pulumi.set(self, "bucket", value)


@pulumi.input_type
class GetLogDataProtectionPolicyDocumentStatementOperationDeidentifyArgs:
    def __init__(__self__, *,
                 mask_config: 'GetLogDataProtectionPolicyDocumentStatementOperationDeidentifyMaskConfigArgs'):
        """
        :param 'GetLogDataProtectionPolicyDocumentStatementOperationDeidentifyMaskConfigArgs' mask_config: An empty object that configures masking.
        """
        pulumi.set(__self__, "mask_config", mask_config)

    @property
    @pulumi.getter(name="maskConfig")
    def mask_config(self) -> 'GetLogDataProtectionPolicyDocumentStatementOperationDeidentifyMaskConfigArgs':
        """
        An empty object that configures masking.
        """
        return pulumi.get(self, "mask_config")

    @mask_config.setter
    def mask_config(self, value: 'GetLogDataProtectionPolicyDocumentStatementOperationDeidentifyMaskConfigArgs'):
        pulumi.set(self, "mask_config", value)


@pulumi.input_type
class GetLogDataProtectionPolicyDocumentStatementOperationDeidentifyMaskConfigArgs:
    def __init__(__self__):
        pass


