# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EventTargetArgs', 'EventTarget']

@pulumi.input_type
class EventTargetArgs:
    def __init__(__self__, *,
                 arn: pulumi.Input[str],
                 rule: pulumi.Input[str],
                 batch_target: Optional[pulumi.Input['EventTargetBatchTargetArgs']] = None,
                 dead_letter_config: Optional[pulumi.Input['EventTargetDeadLetterConfigArgs']] = None,
                 ecs_target: Optional[pulumi.Input['EventTargetEcsTargetArgs']] = None,
                 event_bus_name: Optional[pulumi.Input[str]] = None,
                 http_target: Optional[pulumi.Input['EventTargetHttpTargetArgs']] = None,
                 input: Optional[pulumi.Input[str]] = None,
                 input_path: Optional[pulumi.Input[str]] = None,
                 input_transformer: Optional[pulumi.Input['EventTargetInputTransformerArgs']] = None,
                 kinesis_target: Optional[pulumi.Input['EventTargetKinesisTargetArgs']] = None,
                 redshift_target: Optional[pulumi.Input['EventTargetRedshiftTargetArgs']] = None,
                 retry_policy: Optional[pulumi.Input['EventTargetRetryPolicyArgs']] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 run_command_targets: Optional[pulumi.Input[Sequence[pulumi.Input['EventTargetRunCommandTargetArgs']]]] = None,
                 sagemaker_pipeline_target: Optional[pulumi.Input['EventTargetSagemakerPipelineTargetArgs']] = None,
                 sqs_target: Optional[pulumi.Input['EventTargetSqsTargetArgs']] = None,
                 target_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a EventTarget resource.
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) of the target.
        :param pulumi.Input[str] rule: The name of the rule you want to add targets to.
               
               The following arguments are optional:
        :param pulumi.Input['EventTargetBatchTargetArgs'] batch_target: Parameters used when you are using the rule to invoke an Amazon Batch Job. Documented below. A maximum of 1 are allowed.
        :param pulumi.Input['EventTargetDeadLetterConfigArgs'] dead_letter_config: Parameters used when you are providing a dead letter config. Documented below. A maximum of 1 are allowed.
        :param pulumi.Input['EventTargetEcsTargetArgs'] ecs_target: Parameters used when you are using the rule to invoke Amazon ECS Task. Documented below. A maximum of 1 are allowed.
        :param pulumi.Input[str] event_bus_name: The name or ARN of the event bus to associate with the rule.
               If you omit this, the `default` event bus is used.
        :param pulumi.Input['EventTargetHttpTargetArgs'] http_target: Parameters used when you are using the rule to invoke an API Gateway REST endpoint. Documented below. A maximum of 1 is allowed.
        :param pulumi.Input[str] input: Valid JSON text passed to the target. Conflicts with `input_path` and `input_transformer`.
        :param pulumi.Input[str] input_path: The value of the [JSONPath](http://goessner.net/articles/JsonPath/) that is used for extracting part of the matched event when passing it to the target. Conflicts with `input` and `input_transformer`.
        :param pulumi.Input['EventTargetInputTransformerArgs'] input_transformer: Parameters used when you are providing a custom input to a target based on certain event data. Conflicts with `input` and `input_path`.
        :param pulumi.Input['EventTargetKinesisTargetArgs'] kinesis_target: Parameters used when you are using the rule to invoke an Amazon Kinesis Stream. Documented below. A maximum of 1 are allowed.
        :param pulumi.Input['EventTargetRedshiftTargetArgs'] redshift_target: Parameters used when you are using the rule to invoke an Amazon Redshift Statement. Documented below. A maximum of 1 are allowed.
        :param pulumi.Input['EventTargetRetryPolicyArgs'] retry_policy: Parameters used when you are providing retry policies. Documented below. A maximum of 1 are allowed.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is triggered. Required if `ecs_target` is used or target in `arn` is EC2 instance, Kinesis data stream, Step Functions state machine, or Event Bus in different account or region.
        :param pulumi.Input[Sequence[pulumi.Input['EventTargetRunCommandTargetArgs']]] run_command_targets: Parameters used when you are using the rule to invoke Amazon EC2 Run Command. Documented below. A maximum of 5 are allowed.
        :param pulumi.Input['EventTargetSagemakerPipelineTargetArgs'] sagemaker_pipeline_target: Parameters used when you are using the rule to invoke an Amazon SageMaker Pipeline. Documented below. A maximum of 1 are allowed.
        :param pulumi.Input['EventTargetSqsTargetArgs'] sqs_target: Parameters used when you are using the rule to invoke an Amazon SQS Queue. Documented below. A maximum of 1 are allowed.
        :param pulumi.Input[str] target_id: The unique target assignment ID. If missing, will generate a random, unique id.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "rule", rule)
        if batch_target is not None:
            pulumi.set(__self__, "batch_target", batch_target)
        if dead_letter_config is not None:
            pulumi.set(__self__, "dead_letter_config", dead_letter_config)
        if ecs_target is not None:
            pulumi.set(__self__, "ecs_target", ecs_target)
        if event_bus_name is not None:
            pulumi.set(__self__, "event_bus_name", event_bus_name)
        if http_target is not None:
            pulumi.set(__self__, "http_target", http_target)
        if input is not None:
            pulumi.set(__self__, "input", input)
        if input_path is not None:
            pulumi.set(__self__, "input_path", input_path)
        if input_transformer is not None:
            pulumi.set(__self__, "input_transformer", input_transformer)
        if kinesis_target is not None:
            pulumi.set(__self__, "kinesis_target", kinesis_target)
        if redshift_target is not None:
            pulumi.set(__self__, "redshift_target", redshift_target)
        if retry_policy is not None:
            pulumi.set(__self__, "retry_policy", retry_policy)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if run_command_targets is not None:
            pulumi.set(__self__, "run_command_targets", run_command_targets)
        if sagemaker_pipeline_target is not None:
            pulumi.set(__self__, "sagemaker_pipeline_target", sagemaker_pipeline_target)
        if sqs_target is not None:
            pulumi.set(__self__, "sqs_target", sqs_target)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of the target.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def rule(self) -> pulumi.Input[str]:
        """
        The name of the rule you want to add targets to.

        The following arguments are optional:
        """
        return pulumi.get(self, "rule")

    @rule.setter
    def rule(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule", value)

    @property
    @pulumi.getter(name="batchTarget")
    def batch_target(self) -> Optional[pulumi.Input['EventTargetBatchTargetArgs']]:
        """
        Parameters used when you are using the rule to invoke an Amazon Batch Job. Documented below. A maximum of 1 are allowed.
        """
        return pulumi.get(self, "batch_target")

    @batch_target.setter
    def batch_target(self, value: Optional[pulumi.Input['EventTargetBatchTargetArgs']]):
        pulumi.set(self, "batch_target", value)

    @property
    @pulumi.getter(name="deadLetterConfig")
    def dead_letter_config(self) -> Optional[pulumi.Input['EventTargetDeadLetterConfigArgs']]:
        """
        Parameters used when you are providing a dead letter config. Documented below. A maximum of 1 are allowed.
        """
        return pulumi.get(self, "dead_letter_config")

    @dead_letter_config.setter
    def dead_letter_config(self, value: Optional[pulumi.Input['EventTargetDeadLetterConfigArgs']]):
        pulumi.set(self, "dead_letter_config", value)

    @property
    @pulumi.getter(name="ecsTarget")
    def ecs_target(self) -> Optional[pulumi.Input['EventTargetEcsTargetArgs']]:
        """
        Parameters used when you are using the rule to invoke Amazon ECS Task. Documented below. A maximum of 1 are allowed.
        """
        return pulumi.get(self, "ecs_target")

    @ecs_target.setter
    def ecs_target(self, value: Optional[pulumi.Input['EventTargetEcsTargetArgs']]):
        pulumi.set(self, "ecs_target", value)

    @property
    @pulumi.getter(name="eventBusName")
    def event_bus_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name or ARN of the event bus to associate with the rule.
        If you omit this, the `default` event bus is used.
        """
        return pulumi.get(self, "event_bus_name")

    @event_bus_name.setter
    def event_bus_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_bus_name", value)

    @property
    @pulumi.getter(name="httpTarget")
    def http_target(self) -> Optional[pulumi.Input['EventTargetHttpTargetArgs']]:
        """
        Parameters used when you are using the rule to invoke an API Gateway REST endpoint. Documented below. A maximum of 1 is allowed.
        """
        return pulumi.get(self, "http_target")

    @http_target.setter
    def http_target(self, value: Optional[pulumi.Input['EventTargetHttpTargetArgs']]):
        pulumi.set(self, "http_target", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input[str]]:
        """
        Valid JSON text passed to the target. Conflicts with `input_path` and `input_transformer`.
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "input", value)

    @property
    @pulumi.getter(name="inputPath")
    def input_path(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the [JSONPath](http://goessner.net/articles/JsonPath/) that is used for extracting part of the matched event when passing it to the target. Conflicts with `input` and `input_transformer`.
        """
        return pulumi.get(self, "input_path")

    @input_path.setter
    def input_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "input_path", value)

    @property
    @pulumi.getter(name="inputTransformer")
    def input_transformer(self) -> Optional[pulumi.Input['EventTargetInputTransformerArgs']]:
        """
        Parameters used when you are providing a custom input to a target based on certain event data. Conflicts with `input` and `input_path`.
        """
        return pulumi.get(self, "input_transformer")

    @input_transformer.setter
    def input_transformer(self, value: Optional[pulumi.Input['EventTargetInputTransformerArgs']]):
        pulumi.set(self, "input_transformer", value)

    @property
    @pulumi.getter(name="kinesisTarget")
    def kinesis_target(self) -> Optional[pulumi.Input['EventTargetKinesisTargetArgs']]:
        """
        Parameters used when you are using the rule to invoke an Amazon Kinesis Stream. Documented below. A maximum of 1 are allowed.
        """
        return pulumi.get(self, "kinesis_target")

    @kinesis_target.setter
    def kinesis_target(self, value: Optional[pulumi.Input['EventTargetKinesisTargetArgs']]):
        pulumi.set(self, "kinesis_target", value)

    @property
    @pulumi.getter(name="redshiftTarget")
    def redshift_target(self) -> Optional[pulumi.Input['EventTargetRedshiftTargetArgs']]:
        """
        Parameters used when you are using the rule to invoke an Amazon Redshift Statement. Documented below. A maximum of 1 are allowed.
        """
        return pulumi.get(self, "redshift_target")

    @redshift_target.setter
    def redshift_target(self, value: Optional[pulumi.Input['EventTargetRedshiftTargetArgs']]):
        pulumi.set(self, "redshift_target", value)

    @property
    @pulumi.getter(name="retryPolicy")
    def retry_policy(self) -> Optional[pulumi.Input['EventTargetRetryPolicyArgs']]:
        """
        Parameters used when you are providing retry policies. Documented below. A maximum of 1 are allowed.
        """
        return pulumi.get(self, "retry_policy")

    @retry_policy.setter
    def retry_policy(self, value: Optional[pulumi.Input['EventTargetRetryPolicyArgs']]):
        pulumi.set(self, "retry_policy", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is triggered. Required if `ecs_target` is used or target in `arn` is EC2 instance, Kinesis data stream, Step Functions state machine, or Event Bus in different account or region.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="runCommandTargets")
    def run_command_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventTargetRunCommandTargetArgs']]]]:
        """
        Parameters used when you are using the rule to invoke Amazon EC2 Run Command. Documented below. A maximum of 5 are allowed.
        """
        return pulumi.get(self, "run_command_targets")

    @run_command_targets.setter
    def run_command_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventTargetRunCommandTargetArgs']]]]):
        pulumi.set(self, "run_command_targets", value)

    @property
    @pulumi.getter(name="sagemakerPipelineTarget")
    def sagemaker_pipeline_target(self) -> Optional[pulumi.Input['EventTargetSagemakerPipelineTargetArgs']]:
        """
        Parameters used when you are using the rule to invoke an Amazon SageMaker Pipeline. Documented below. A maximum of 1 are allowed.
        """
        return pulumi.get(self, "sagemaker_pipeline_target")

    @sagemaker_pipeline_target.setter
    def sagemaker_pipeline_target(self, value: Optional[pulumi.Input['EventTargetSagemakerPipelineTargetArgs']]):
        pulumi.set(self, "sagemaker_pipeline_target", value)

    @property
    @pulumi.getter(name="sqsTarget")
    def sqs_target(self) -> Optional[pulumi.Input['EventTargetSqsTargetArgs']]:
        """
        Parameters used when you are using the rule to invoke an Amazon SQS Queue. Documented below. A maximum of 1 are allowed.
        """
        return pulumi.get(self, "sqs_target")

    @sqs_target.setter
    def sqs_target(self, value: Optional[pulumi.Input['EventTargetSqsTargetArgs']]):
        pulumi.set(self, "sqs_target", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique target assignment ID. If missing, will generate a random, unique id.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_id", value)


@pulumi.input_type
class _EventTargetState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 batch_target: Optional[pulumi.Input['EventTargetBatchTargetArgs']] = None,
                 dead_letter_config: Optional[pulumi.Input['EventTargetDeadLetterConfigArgs']] = None,
                 ecs_target: Optional[pulumi.Input['EventTargetEcsTargetArgs']] = None,
                 event_bus_name: Optional[pulumi.Input[str]] = None,
                 http_target: Optional[pulumi.Input['EventTargetHttpTargetArgs']] = None,
                 input: Optional[pulumi.Input[str]] = None,
                 input_path: Optional[pulumi.Input[str]] = None,
                 input_transformer: Optional[pulumi.Input['EventTargetInputTransformerArgs']] = None,
                 kinesis_target: Optional[pulumi.Input['EventTargetKinesisTargetArgs']] = None,
                 redshift_target: Optional[pulumi.Input['EventTargetRedshiftTargetArgs']] = None,
                 retry_policy: Optional[pulumi.Input['EventTargetRetryPolicyArgs']] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 rule: Optional[pulumi.Input[str]] = None,
                 run_command_targets: Optional[pulumi.Input[Sequence[pulumi.Input['EventTargetRunCommandTargetArgs']]]] = None,
                 sagemaker_pipeline_target: Optional[pulumi.Input['EventTargetSagemakerPipelineTargetArgs']] = None,
                 sqs_target: Optional[pulumi.Input['EventTargetSqsTargetArgs']] = None,
                 target_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering EventTarget resources.
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) of the target.
        :param pulumi.Input['EventTargetBatchTargetArgs'] batch_target: Parameters used when you are using the rule to invoke an Amazon Batch Job. Documented below. A maximum of 1 are allowed.
        :param pulumi.Input['EventTargetDeadLetterConfigArgs'] dead_letter_config: Parameters used when you are providing a dead letter config. Documented below. A maximum of 1 are allowed.
        :param pulumi.Input['EventTargetEcsTargetArgs'] ecs_target: Parameters used when you are using the rule to invoke Amazon ECS Task. Documented below. A maximum of 1 are allowed.
        :param pulumi.Input[str] event_bus_name: The name or ARN of the event bus to associate with the rule.
               If you omit this, the `default` event bus is used.
        :param pulumi.Input['EventTargetHttpTargetArgs'] http_target: Parameters used when you are using the rule to invoke an API Gateway REST endpoint. Documented below. A maximum of 1 is allowed.
        :param pulumi.Input[str] input: Valid JSON text passed to the target. Conflicts with `input_path` and `input_transformer`.
        :param pulumi.Input[str] input_path: The value of the [JSONPath](http://goessner.net/articles/JsonPath/) that is used for extracting part of the matched event when passing it to the target. Conflicts with `input` and `input_transformer`.
        :param pulumi.Input['EventTargetInputTransformerArgs'] input_transformer: Parameters used when you are providing a custom input to a target based on certain event data. Conflicts with `input` and `input_path`.
        :param pulumi.Input['EventTargetKinesisTargetArgs'] kinesis_target: Parameters used when you are using the rule to invoke an Amazon Kinesis Stream. Documented below. A maximum of 1 are allowed.
        :param pulumi.Input['EventTargetRedshiftTargetArgs'] redshift_target: Parameters used when you are using the rule to invoke an Amazon Redshift Statement. Documented below. A maximum of 1 are allowed.
        :param pulumi.Input['EventTargetRetryPolicyArgs'] retry_policy: Parameters used when you are providing retry policies. Documented below. A maximum of 1 are allowed.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is triggered. Required if `ecs_target` is used or target in `arn` is EC2 instance, Kinesis data stream, Step Functions state machine, or Event Bus in different account or region.
        :param pulumi.Input[str] rule: The name of the rule you want to add targets to.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input['EventTargetRunCommandTargetArgs']]] run_command_targets: Parameters used when you are using the rule to invoke Amazon EC2 Run Command. Documented below. A maximum of 5 are allowed.
        :param pulumi.Input['EventTargetSagemakerPipelineTargetArgs'] sagemaker_pipeline_target: Parameters used when you are using the rule to invoke an Amazon SageMaker Pipeline. Documented below. A maximum of 1 are allowed.
        :param pulumi.Input['EventTargetSqsTargetArgs'] sqs_target: Parameters used when you are using the rule to invoke an Amazon SQS Queue. Documented below. A maximum of 1 are allowed.
        :param pulumi.Input[str] target_id: The unique target assignment ID. If missing, will generate a random, unique id.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if batch_target is not None:
            pulumi.set(__self__, "batch_target", batch_target)
        if dead_letter_config is not None:
            pulumi.set(__self__, "dead_letter_config", dead_letter_config)
        if ecs_target is not None:
            pulumi.set(__self__, "ecs_target", ecs_target)
        if event_bus_name is not None:
            pulumi.set(__self__, "event_bus_name", event_bus_name)
        if http_target is not None:
            pulumi.set(__self__, "http_target", http_target)
        if input is not None:
            pulumi.set(__self__, "input", input)
        if input_path is not None:
            pulumi.set(__self__, "input_path", input_path)
        if input_transformer is not None:
            pulumi.set(__self__, "input_transformer", input_transformer)
        if kinesis_target is not None:
            pulumi.set(__self__, "kinesis_target", kinesis_target)
        if redshift_target is not None:
            pulumi.set(__self__, "redshift_target", redshift_target)
        if retry_policy is not None:
            pulumi.set(__self__, "retry_policy", retry_policy)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)
        if run_command_targets is not None:
            pulumi.set(__self__, "run_command_targets", run_command_targets)
        if sagemaker_pipeline_target is not None:
            pulumi.set(__self__, "sagemaker_pipeline_target", sagemaker_pipeline_target)
        if sqs_target is not None:
            pulumi.set(__self__, "sqs_target", sqs_target)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the target.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="batchTarget")
    def batch_target(self) -> Optional[pulumi.Input['EventTargetBatchTargetArgs']]:
        """
        Parameters used when you are using the rule to invoke an Amazon Batch Job. Documented below. A maximum of 1 are allowed.
        """
        return pulumi.get(self, "batch_target")

    @batch_target.setter
    def batch_target(self, value: Optional[pulumi.Input['EventTargetBatchTargetArgs']]):
        pulumi.set(self, "batch_target", value)

    @property
    @pulumi.getter(name="deadLetterConfig")
    def dead_letter_config(self) -> Optional[pulumi.Input['EventTargetDeadLetterConfigArgs']]:
        """
        Parameters used when you are providing a dead letter config. Documented below. A maximum of 1 are allowed.
        """
        return pulumi.get(self, "dead_letter_config")

    @dead_letter_config.setter
    def dead_letter_config(self, value: Optional[pulumi.Input['EventTargetDeadLetterConfigArgs']]):
        pulumi.set(self, "dead_letter_config", value)

    @property
    @pulumi.getter(name="ecsTarget")
    def ecs_target(self) -> Optional[pulumi.Input['EventTargetEcsTargetArgs']]:
        """
        Parameters used when you are using the rule to invoke Amazon ECS Task. Documented below. A maximum of 1 are allowed.
        """
        return pulumi.get(self, "ecs_target")

    @ecs_target.setter
    def ecs_target(self, value: Optional[pulumi.Input['EventTargetEcsTargetArgs']]):
        pulumi.set(self, "ecs_target", value)

    @property
    @pulumi.getter(name="eventBusName")
    def event_bus_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name or ARN of the event bus to associate with the rule.
        If you omit this, the `default` event bus is used.
        """
        return pulumi.get(self, "event_bus_name")

    @event_bus_name.setter
    def event_bus_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_bus_name", value)

    @property
    @pulumi.getter(name="httpTarget")
    def http_target(self) -> Optional[pulumi.Input['EventTargetHttpTargetArgs']]:
        """
        Parameters used when you are using the rule to invoke an API Gateway REST endpoint. Documented below. A maximum of 1 is allowed.
        """
        return pulumi.get(self, "http_target")

    @http_target.setter
    def http_target(self, value: Optional[pulumi.Input['EventTargetHttpTargetArgs']]):
        pulumi.set(self, "http_target", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input[str]]:
        """
        Valid JSON text passed to the target. Conflicts with `input_path` and `input_transformer`.
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "input", value)

    @property
    @pulumi.getter(name="inputPath")
    def input_path(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the [JSONPath](http://goessner.net/articles/JsonPath/) that is used for extracting part of the matched event when passing it to the target. Conflicts with `input` and `input_transformer`.
        """
        return pulumi.get(self, "input_path")

    @input_path.setter
    def input_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "input_path", value)

    @property
    @pulumi.getter(name="inputTransformer")
    def input_transformer(self) -> Optional[pulumi.Input['EventTargetInputTransformerArgs']]:
        """
        Parameters used when you are providing a custom input to a target based on certain event data. Conflicts with `input` and `input_path`.
        """
        return pulumi.get(self, "input_transformer")

    @input_transformer.setter
    def input_transformer(self, value: Optional[pulumi.Input['EventTargetInputTransformerArgs']]):
        pulumi.set(self, "input_transformer", value)

    @property
    @pulumi.getter(name="kinesisTarget")
    def kinesis_target(self) -> Optional[pulumi.Input['EventTargetKinesisTargetArgs']]:
        """
        Parameters used when you are using the rule to invoke an Amazon Kinesis Stream. Documented below. A maximum of 1 are allowed.
        """
        return pulumi.get(self, "kinesis_target")

    @kinesis_target.setter
    def kinesis_target(self, value: Optional[pulumi.Input['EventTargetKinesisTargetArgs']]):
        pulumi.set(self, "kinesis_target", value)

    @property
    @pulumi.getter(name="redshiftTarget")
    def redshift_target(self) -> Optional[pulumi.Input['EventTargetRedshiftTargetArgs']]:
        """
        Parameters used when you are using the rule to invoke an Amazon Redshift Statement. Documented below. A maximum of 1 are allowed.
        """
        return pulumi.get(self, "redshift_target")

    @redshift_target.setter
    def redshift_target(self, value: Optional[pulumi.Input['EventTargetRedshiftTargetArgs']]):
        pulumi.set(self, "redshift_target", value)

    @property
    @pulumi.getter(name="retryPolicy")
    def retry_policy(self) -> Optional[pulumi.Input['EventTargetRetryPolicyArgs']]:
        """
        Parameters used when you are providing retry policies. Documented below. A maximum of 1 are allowed.
        """
        return pulumi.get(self, "retry_policy")

    @retry_policy.setter
    def retry_policy(self, value: Optional[pulumi.Input['EventTargetRetryPolicyArgs']]):
        pulumi.set(self, "retry_policy", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is triggered. Required if `ecs_target` is used or target in `arn` is EC2 instance, Kinesis data stream, Step Functions state machine, or Event Bus in different account or region.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def rule(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the rule you want to add targets to.

        The following arguments are optional:
        """
        return pulumi.get(self, "rule")

    @rule.setter
    def rule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule", value)

    @property
    @pulumi.getter(name="runCommandTargets")
    def run_command_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventTargetRunCommandTargetArgs']]]]:
        """
        Parameters used when you are using the rule to invoke Amazon EC2 Run Command. Documented below. A maximum of 5 are allowed.
        """
        return pulumi.get(self, "run_command_targets")

    @run_command_targets.setter
    def run_command_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventTargetRunCommandTargetArgs']]]]):
        pulumi.set(self, "run_command_targets", value)

    @property
    @pulumi.getter(name="sagemakerPipelineTarget")
    def sagemaker_pipeline_target(self) -> Optional[pulumi.Input['EventTargetSagemakerPipelineTargetArgs']]:
        """
        Parameters used when you are using the rule to invoke an Amazon SageMaker Pipeline. Documented below. A maximum of 1 are allowed.
        """
        return pulumi.get(self, "sagemaker_pipeline_target")

    @sagemaker_pipeline_target.setter
    def sagemaker_pipeline_target(self, value: Optional[pulumi.Input['EventTargetSagemakerPipelineTargetArgs']]):
        pulumi.set(self, "sagemaker_pipeline_target", value)

    @property
    @pulumi.getter(name="sqsTarget")
    def sqs_target(self) -> Optional[pulumi.Input['EventTargetSqsTargetArgs']]:
        """
        Parameters used when you are using the rule to invoke an Amazon SQS Queue. Documented below. A maximum of 1 are allowed.
        """
        return pulumi.get(self, "sqs_target")

    @sqs_target.setter
    def sqs_target(self, value: Optional[pulumi.Input['EventTargetSqsTargetArgs']]):
        pulumi.set(self, "sqs_target", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique target assignment ID. If missing, will generate a random, unique id.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_id", value)


class EventTarget(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 batch_target: Optional[pulumi.Input[pulumi.InputType['EventTargetBatchTargetArgs']]] = None,
                 dead_letter_config: Optional[pulumi.Input[pulumi.InputType['EventTargetDeadLetterConfigArgs']]] = None,
                 ecs_target: Optional[pulumi.Input[pulumi.InputType['EventTargetEcsTargetArgs']]] = None,
                 event_bus_name: Optional[pulumi.Input[str]] = None,
                 http_target: Optional[pulumi.Input[pulumi.InputType['EventTargetHttpTargetArgs']]] = None,
                 input: Optional[pulumi.Input[str]] = None,
                 input_path: Optional[pulumi.Input[str]] = None,
                 input_transformer: Optional[pulumi.Input[pulumi.InputType['EventTargetInputTransformerArgs']]] = None,
                 kinesis_target: Optional[pulumi.Input[pulumi.InputType['EventTargetKinesisTargetArgs']]] = None,
                 redshift_target: Optional[pulumi.Input[pulumi.InputType['EventTargetRedshiftTargetArgs']]] = None,
                 retry_policy: Optional[pulumi.Input[pulumi.InputType['EventTargetRetryPolicyArgs']]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 rule: Optional[pulumi.Input[str]] = None,
                 run_command_targets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EventTargetRunCommandTargetArgs']]]]] = None,
                 sagemaker_pipeline_target: Optional[pulumi.Input[pulumi.InputType['EventTargetSagemakerPipelineTargetArgs']]] = None,
                 sqs_target: Optional[pulumi.Input[pulumi.InputType['EventTargetSqsTargetArgs']]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides an EventBridge Target resource.

        > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.

        ## Example Usage

        ### Kinesis Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        console = aws.cloudwatch.EventRule("console",
            name="capture-ec2-scaling-events",
            description="Capture all EC2 scaling events",
            event_pattern=json.dumps({
                "source": ["aws.autoscaling"],
                "detail-type": [
                    "EC2 Instance Launch Successful",
                    "EC2 Instance Terminate Successful",
                    "EC2 Instance Launch Unsuccessful",
                    "EC2 Instance Terminate Unsuccessful",
                ],
            }))
        test_stream = aws.kinesis.Stream("test_stream",
            name="kinesis-test",
            shard_count=1)
        yada = aws.cloudwatch.EventTarget("yada",
            target_id="Yada",
            rule=console.name,
            arn=test_stream.arn,
            run_command_targets=[
                aws.cloudwatch.EventTargetRunCommandTargetArgs(
                    key="tag:Name",
                    values=["FooBar"],
                ),
                aws.cloudwatch.EventTargetRunCommandTargetArgs(
                    key="InstanceIds",
                    values=["i-162058cd308bffec2"],
                ),
            ])
        ```
        <!--End PulumiCodeChooser -->

        ### SSM Document Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        ssm_lifecycle_trust = aws.iam.get_policy_document(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            actions=["sts:AssumeRole"],
            principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                type="Service",
                identifiers=["events.amazonaws.com"],
            )],
        )])
        stop_instance = aws.ssm.Document("stop_instance",
            name="stop_instance",
            document_type="Command",
            content=json.dumps({
                "schemaVersion": "1.2",
                "description": "Stop an instance",
                "parameters": {},
                "runtimeConfig": {
                    "aws:runShellScript": {
                        "properties": [{
                            "id": "0.aws:runShellScript",
                            "runCommand": ["halt"],
                        }],
                    },
                },
            }))
        ssm_lifecycle = aws.iam.get_policy_document_output(statements=[
            aws.iam.GetPolicyDocumentStatementArgs(
                effect="Allow",
                actions=["ssm:SendCommand"],
                resources=["arn:aws:ec2:eu-west-1:1234567890:instance/*"],
                conditions=[aws.iam.GetPolicyDocumentStatementConditionArgs(
                    test="StringEquals",
                    variable="ec2:ResourceTag/Terminate",
                    values=["*"],
                )],
            ),
            aws.iam.GetPolicyDocumentStatementArgs(
                effect="Allow",
                actions=["ssm:SendCommand"],
                resources=[stop_instance.arn],
            ),
        ])
        ssm_lifecycle_role = aws.iam.Role("ssm_lifecycle",
            name="SSMLifecycle",
            assume_role_policy=ssm_lifecycle_trust.json)
        ssm_lifecycle_policy = aws.iam.Policy("ssm_lifecycle",
            name="SSMLifecycle",
            policy=ssm_lifecycle.json)
        ssm_lifecycle_role_policy_attachment = aws.iam.RolePolicyAttachment("ssm_lifecycle",
            policy_arn=ssm_lifecycle_policy.arn,
            role=ssm_lifecycle_role.name)
        stop_instances = aws.cloudwatch.EventRule("stop_instances",
            name="StopInstance",
            description="Stop instances nightly",
            schedule_expression="cron(0 0 * * ? *)")
        stop_instances_event_target = aws.cloudwatch.EventTarget("stop_instances",
            target_id="StopInstance",
            arn=stop_instance.arn,
            rule=stop_instances.name,
            role_arn=ssm_lifecycle_role.arn,
            run_command_targets=[aws.cloudwatch.EventTargetRunCommandTargetArgs(
                key="tag:Terminate",
                values=["midnight"],
            )])
        ```
        <!--End PulumiCodeChooser -->

        ### RunCommand Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        stop_instances = aws.cloudwatch.EventRule("stop_instances",
            name="StopInstance",
            description="Stop instances nightly",
            schedule_expression="cron(0 0 * * ? *)")
        stop_instances_event_target = aws.cloudwatch.EventTarget("stop_instances",
            target_id="StopInstance",
            arn=f"arn:aws:ssm:{aws_region}::document/AWS-RunShellScript",
            input="{\\"commands\\":[\\"halt\\"]}",
            rule=stop_instances.name,
            role_arn=ssm_lifecycle["arn"],
            run_command_targets=[aws.cloudwatch.EventTargetRunCommandTargetArgs(
                key="tag:Terminate",
                values=["midnight"],
            )])
        ```
        <!--End PulumiCodeChooser -->

        ### ECS Run Task with Role and Task Override Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import json
        import pulumi_aws as aws
        import pulumi_std as std

        assume_role = aws.iam.get_policy_document(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            effect="Allow",
            principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                type="Service",
                identifiers=["events.amazonaws.com"],
            )],
            actions=["sts:AssumeRole"],
        )])
        ecs_events = aws.iam.Role("ecs_events",
            name="ecs_events",
            assume_role_policy=assume_role.json)
        ecs_events_run_task_with_any_role = aws.iam.get_policy_document(statements=[
            aws.iam.GetPolicyDocumentStatementArgs(
                effect="Allow",
                actions=["iam:PassRole"],
                resources=["*"],
            ),
            aws.iam.GetPolicyDocumentStatementArgs(
                effect="Allow",
                actions=["ecs:RunTask"],
                resources=[std.replace(text=task_name["arn"],
                    search="/:\\\\d+$/",
                    replace=":*").result],
            ),
        ])
        ecs_events_run_task_with_any_role_role_policy = aws.iam.RolePolicy("ecs_events_run_task_with_any_role",
            name="ecs_events_run_task_with_any_role",
            role=ecs_events.id,
            policy=ecs_events_run_task_with_any_role.json)
        ecs_scheduled_task = aws.cloudwatch.EventTarget("ecs_scheduled_task",
            target_id="run-scheduled-task-every-hour",
            arn=cluster_name["arn"],
            rule=every_hour["name"],
            role_arn=ecs_events.arn,
            ecs_target=aws.cloudwatch.EventTargetEcsTargetArgs(
                task_count=1,
                task_definition_arn=task_name["arn"],
            ),
            input=json.dumps({
                "containerOverrides": [{
                    "name": "name-of-container-to-override",
                    "command": [
                        "bin/console",
                        "scheduled-task",
                    ],
                }],
            }))
        ```
        <!--End PulumiCodeChooser -->

        ### API Gateway target

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example_event_rule = aws.cloudwatch.EventRule("example")
        example_deployment = aws.apigateway.Deployment("example", rest_api=example_aws_api_gateway_rest_api["id"])
        example_stage = aws.apigateway.Stage("example",
            rest_api=example_aws_api_gateway_rest_api["id"],
            deployment=example_deployment.id)
        example = aws.cloudwatch.EventTarget("example",
            arn=example_stage.execution_arn.apply(lambda execution_arn: f"{execution_arn}/GET"),
            rule=example_event_rule.id,
            http_target=aws.cloudwatch.EventTargetHttpTargetArgs(
                query_string_parameters={
                    "Body": "$.detail.body",
                },
                header_parameters={
                    "Env": "Test",
                },
            ))
        ```
        <!--End PulumiCodeChooser -->

        ### Cross-Account Event Bus target

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        assume_role = aws.iam.get_policy_document(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            effect="Allow",
            principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                type="Service",
                identifiers=["events.amazonaws.com"],
            )],
            actions=["sts:AssumeRole"],
        )])
        event_bus_invoke_remote_event_bus_role = aws.iam.Role("event_bus_invoke_remote_event_bus",
            name="event-bus-invoke-remote-event-bus",
            assume_role_policy=assume_role.json)
        event_bus_invoke_remote_event_bus = aws.iam.get_policy_document(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            effect="Allow",
            actions=["events:PutEvents"],
            resources=["arn:aws:events:eu-west-1:1234567890:event-bus/My-Event-Bus"],
        )])
        event_bus_invoke_remote_event_bus_policy = aws.iam.Policy("event_bus_invoke_remote_event_bus",
            name="event_bus_invoke_remote_event_bus",
            policy=event_bus_invoke_remote_event_bus.json)
        event_bus_invoke_remote_event_bus_role_policy_attachment = aws.iam.RolePolicyAttachment("event_bus_invoke_remote_event_bus",
            role=event_bus_invoke_remote_event_bus_role.name,
            policy_arn=event_bus_invoke_remote_event_bus_policy.arn)
        stop_instances = aws.cloudwatch.EventRule("stop_instances",
            name="StopInstance",
            description="Stop instances nightly",
            schedule_expression="cron(0 0 * * ? *)")
        stop_instances_event_target = aws.cloudwatch.EventTarget("stop_instances",
            target_id="StopInstance",
            arn="arn:aws:events:eu-west-1:1234567890:event-bus/My-Event-Bus",
            rule=stop_instances.name,
            role_arn=event_bus_invoke_remote_event_bus_role.arn)
        ```
        <!--End PulumiCodeChooser -->

        ### Input Transformer Usage - JSON Object

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example_event_rule = aws.cloudwatch.EventRule("example")
        example = aws.cloudwatch.EventTarget("example",
            arn=example_aws_lambda_function["arn"],
            rule=example_event_rule.id,
            input_transformer=aws.cloudwatch.EventTargetInputTransformerArgs(
                input_paths={
                    "instance": "$.detail.instance",
                    "status": "$.detail.status",
                },
                input_template=\"\"\"{
          "instance_id": <instance>,
          "instance_status": <status>
        }
        \"\"\",
            ))
        ```
        <!--End PulumiCodeChooser -->

        ### Input Transformer Usage - Simple String

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example_event_rule = aws.cloudwatch.EventRule("example")
        example = aws.cloudwatch.EventTarget("example",
            arn=example_aws_lambda_function["arn"],
            rule=example_event_rule.id,
            input_transformer=aws.cloudwatch.EventTargetInputTransformerArgs(
                input_paths={
                    "instance": "$.detail.instance",
                    "status": "$.detail.status",
                },
                input_template="\\"<instance> is in state <status>\\"",
            ))
        ```
        <!--End PulumiCodeChooser -->

        ### Cloudwatch Log Group Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.cloudwatch.LogGroup("example",
            name="/aws/events/guardduty/logs",
            retention_in_days=1)
        example_event_rule = aws.cloudwatch.EventRule("example",
            name="guard-duty_event_rule",
            description="GuardDuty Findings",
            event_pattern=json.dumps({
                "source": ["aws.guardduty"],
            }),
            tags={
                "Environment": "example",
            })
        example_log_policy = aws.iam.get_policy_document_output(statements=[
            aws.iam.GetPolicyDocumentStatementArgs(
                effect="Allow",
                actions=["logs:CreateLogStream"],
                resources=[example.arn.apply(lambda arn: f"{arn}:*")],
                principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                    type="Service",
                    identifiers=[
                        "events.amazonaws.com",
                        "delivery.logs.amazonaws.com",
                    ],
                )],
            ),
            aws.iam.GetPolicyDocumentStatementArgs(
                effect="Allow",
                actions=["logs:PutLogEvents"],
                resources=[example.arn.apply(lambda arn: f"{arn}:*:*")],
                principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                    type="Service",
                    identifiers=[
                        "events.amazonaws.com",
                        "delivery.logs.amazonaws.com",
                    ],
                )],
                conditions=[aws.iam.GetPolicyDocumentStatementConditionArgs(
                    test="ArnEquals",
                    values=[example_event_rule.arn],
                    variable="aws:SourceArn",
                )],
            ),
        ])
        example_log_resource_policy = aws.cloudwatch.LogResourcePolicy("example",
            policy_document=example_log_policy.json,
            policy_name="guardduty-log-publishing-policy")
        example_event_target = aws.cloudwatch.EventTarget("example",
            rule=example_event_rule.name,
            arn=example.arn)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import EventBridge Targets using `event_bus_name/rule-name/target-id` (if you omit `event_bus_name`, the `default` event bus will be used). For example:

        ```sh
        $ pulumi import aws:cloudwatch/eventTarget:EventTarget test-event-target rule-name/target-id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) of the target.
        :param pulumi.Input[pulumi.InputType['EventTargetBatchTargetArgs']] batch_target: Parameters used when you are using the rule to invoke an Amazon Batch Job. Documented below. A maximum of 1 are allowed.
        :param pulumi.Input[pulumi.InputType['EventTargetDeadLetterConfigArgs']] dead_letter_config: Parameters used when you are providing a dead letter config. Documented below. A maximum of 1 are allowed.
        :param pulumi.Input[pulumi.InputType['EventTargetEcsTargetArgs']] ecs_target: Parameters used when you are using the rule to invoke Amazon ECS Task. Documented below. A maximum of 1 are allowed.
        :param pulumi.Input[str] event_bus_name: The name or ARN of the event bus to associate with the rule.
               If you omit this, the `default` event bus is used.
        :param pulumi.Input[pulumi.InputType['EventTargetHttpTargetArgs']] http_target: Parameters used when you are using the rule to invoke an API Gateway REST endpoint. Documented below. A maximum of 1 is allowed.
        :param pulumi.Input[str] input: Valid JSON text passed to the target. Conflicts with `input_path` and `input_transformer`.
        :param pulumi.Input[str] input_path: The value of the [JSONPath](http://goessner.net/articles/JsonPath/) that is used for extracting part of the matched event when passing it to the target. Conflicts with `input` and `input_transformer`.
        :param pulumi.Input[pulumi.InputType['EventTargetInputTransformerArgs']] input_transformer: Parameters used when you are providing a custom input to a target based on certain event data. Conflicts with `input` and `input_path`.
        :param pulumi.Input[pulumi.InputType['EventTargetKinesisTargetArgs']] kinesis_target: Parameters used when you are using the rule to invoke an Amazon Kinesis Stream. Documented below. A maximum of 1 are allowed.
        :param pulumi.Input[pulumi.InputType['EventTargetRedshiftTargetArgs']] redshift_target: Parameters used when you are using the rule to invoke an Amazon Redshift Statement. Documented below. A maximum of 1 are allowed.
        :param pulumi.Input[pulumi.InputType['EventTargetRetryPolicyArgs']] retry_policy: Parameters used when you are providing retry policies. Documented below. A maximum of 1 are allowed.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is triggered. Required if `ecs_target` is used or target in `arn` is EC2 instance, Kinesis data stream, Step Functions state machine, or Event Bus in different account or region.
        :param pulumi.Input[str] rule: The name of the rule you want to add targets to.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EventTargetRunCommandTargetArgs']]]] run_command_targets: Parameters used when you are using the rule to invoke Amazon EC2 Run Command. Documented below. A maximum of 5 are allowed.
        :param pulumi.Input[pulumi.InputType['EventTargetSagemakerPipelineTargetArgs']] sagemaker_pipeline_target: Parameters used when you are using the rule to invoke an Amazon SageMaker Pipeline. Documented below. A maximum of 1 are allowed.
        :param pulumi.Input[pulumi.InputType['EventTargetSqsTargetArgs']] sqs_target: Parameters used when you are using the rule to invoke an Amazon SQS Queue. Documented below. A maximum of 1 are allowed.
        :param pulumi.Input[str] target_id: The unique target assignment ID. If missing, will generate a random, unique id.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EventTargetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an EventBridge Target resource.

        > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.

        ## Example Usage

        ### Kinesis Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        console = aws.cloudwatch.EventRule("console",
            name="capture-ec2-scaling-events",
            description="Capture all EC2 scaling events",
            event_pattern=json.dumps({
                "source": ["aws.autoscaling"],
                "detail-type": [
                    "EC2 Instance Launch Successful",
                    "EC2 Instance Terminate Successful",
                    "EC2 Instance Launch Unsuccessful",
                    "EC2 Instance Terminate Unsuccessful",
                ],
            }))
        test_stream = aws.kinesis.Stream("test_stream",
            name="kinesis-test",
            shard_count=1)
        yada = aws.cloudwatch.EventTarget("yada",
            target_id="Yada",
            rule=console.name,
            arn=test_stream.arn,
            run_command_targets=[
                aws.cloudwatch.EventTargetRunCommandTargetArgs(
                    key="tag:Name",
                    values=["FooBar"],
                ),
                aws.cloudwatch.EventTargetRunCommandTargetArgs(
                    key="InstanceIds",
                    values=["i-162058cd308bffec2"],
                ),
            ])
        ```
        <!--End PulumiCodeChooser -->

        ### SSM Document Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        ssm_lifecycle_trust = aws.iam.get_policy_document(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            actions=["sts:AssumeRole"],
            principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                type="Service",
                identifiers=["events.amazonaws.com"],
            )],
        )])
        stop_instance = aws.ssm.Document("stop_instance",
            name="stop_instance",
            document_type="Command",
            content=json.dumps({
                "schemaVersion": "1.2",
                "description": "Stop an instance",
                "parameters": {},
                "runtimeConfig": {
                    "aws:runShellScript": {
                        "properties": [{
                            "id": "0.aws:runShellScript",
                            "runCommand": ["halt"],
                        }],
                    },
                },
            }))
        ssm_lifecycle = aws.iam.get_policy_document_output(statements=[
            aws.iam.GetPolicyDocumentStatementArgs(
                effect="Allow",
                actions=["ssm:SendCommand"],
                resources=["arn:aws:ec2:eu-west-1:1234567890:instance/*"],
                conditions=[aws.iam.GetPolicyDocumentStatementConditionArgs(
                    test="StringEquals",
                    variable="ec2:ResourceTag/Terminate",
                    values=["*"],
                )],
            ),
            aws.iam.GetPolicyDocumentStatementArgs(
                effect="Allow",
                actions=["ssm:SendCommand"],
                resources=[stop_instance.arn],
            ),
        ])
        ssm_lifecycle_role = aws.iam.Role("ssm_lifecycle",
            name="SSMLifecycle",
            assume_role_policy=ssm_lifecycle_trust.json)
        ssm_lifecycle_policy = aws.iam.Policy("ssm_lifecycle",
            name="SSMLifecycle",
            policy=ssm_lifecycle.json)
        ssm_lifecycle_role_policy_attachment = aws.iam.RolePolicyAttachment("ssm_lifecycle",
            policy_arn=ssm_lifecycle_policy.arn,
            role=ssm_lifecycle_role.name)
        stop_instances = aws.cloudwatch.EventRule("stop_instances",
            name="StopInstance",
            description="Stop instances nightly",
            schedule_expression="cron(0 0 * * ? *)")
        stop_instances_event_target = aws.cloudwatch.EventTarget("stop_instances",
            target_id="StopInstance",
            arn=stop_instance.arn,
            rule=stop_instances.name,
            role_arn=ssm_lifecycle_role.arn,
            run_command_targets=[aws.cloudwatch.EventTargetRunCommandTargetArgs(
                key="tag:Terminate",
                values=["midnight"],
            )])
        ```
        <!--End PulumiCodeChooser -->

        ### RunCommand Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        stop_instances = aws.cloudwatch.EventRule("stop_instances",
            name="StopInstance",
            description="Stop instances nightly",
            schedule_expression="cron(0 0 * * ? *)")
        stop_instances_event_target = aws.cloudwatch.EventTarget("stop_instances",
            target_id="StopInstance",
            arn=f"arn:aws:ssm:{aws_region}::document/AWS-RunShellScript",
            input="{\\"commands\\":[\\"halt\\"]}",
            rule=stop_instances.name,
            role_arn=ssm_lifecycle["arn"],
            run_command_targets=[aws.cloudwatch.EventTargetRunCommandTargetArgs(
                key="tag:Terminate",
                values=["midnight"],
            )])
        ```
        <!--End PulumiCodeChooser -->

        ### ECS Run Task with Role and Task Override Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import json
        import pulumi_aws as aws
        import pulumi_std as std

        assume_role = aws.iam.get_policy_document(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            effect="Allow",
            principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                type="Service",
                identifiers=["events.amazonaws.com"],
            )],
            actions=["sts:AssumeRole"],
        )])
        ecs_events = aws.iam.Role("ecs_events",
            name="ecs_events",
            assume_role_policy=assume_role.json)
        ecs_events_run_task_with_any_role = aws.iam.get_policy_document(statements=[
            aws.iam.GetPolicyDocumentStatementArgs(
                effect="Allow",
                actions=["iam:PassRole"],
                resources=["*"],
            ),
            aws.iam.GetPolicyDocumentStatementArgs(
                effect="Allow",
                actions=["ecs:RunTask"],
                resources=[std.replace(text=task_name["arn"],
                    search="/:\\\\d+$/",
                    replace=":*").result],
            ),
        ])
        ecs_events_run_task_with_any_role_role_policy = aws.iam.RolePolicy("ecs_events_run_task_with_any_role",
            name="ecs_events_run_task_with_any_role",
            role=ecs_events.id,
            policy=ecs_events_run_task_with_any_role.json)
        ecs_scheduled_task = aws.cloudwatch.EventTarget("ecs_scheduled_task",
            target_id="run-scheduled-task-every-hour",
            arn=cluster_name["arn"],
            rule=every_hour["name"],
            role_arn=ecs_events.arn,
            ecs_target=aws.cloudwatch.EventTargetEcsTargetArgs(
                task_count=1,
                task_definition_arn=task_name["arn"],
            ),
            input=json.dumps({
                "containerOverrides": [{
                    "name": "name-of-container-to-override",
                    "command": [
                        "bin/console",
                        "scheduled-task",
                    ],
                }],
            }))
        ```
        <!--End PulumiCodeChooser -->

        ### API Gateway target

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example_event_rule = aws.cloudwatch.EventRule("example")
        example_deployment = aws.apigateway.Deployment("example", rest_api=example_aws_api_gateway_rest_api["id"])
        example_stage = aws.apigateway.Stage("example",
            rest_api=example_aws_api_gateway_rest_api["id"],
            deployment=example_deployment.id)
        example = aws.cloudwatch.EventTarget("example",
            arn=example_stage.execution_arn.apply(lambda execution_arn: f"{execution_arn}/GET"),
            rule=example_event_rule.id,
            http_target=aws.cloudwatch.EventTargetHttpTargetArgs(
                query_string_parameters={
                    "Body": "$.detail.body",
                },
                header_parameters={
                    "Env": "Test",
                },
            ))
        ```
        <!--End PulumiCodeChooser -->

        ### Cross-Account Event Bus target

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        assume_role = aws.iam.get_policy_document(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            effect="Allow",
            principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                type="Service",
                identifiers=["events.amazonaws.com"],
            )],
            actions=["sts:AssumeRole"],
        )])
        event_bus_invoke_remote_event_bus_role = aws.iam.Role("event_bus_invoke_remote_event_bus",
            name="event-bus-invoke-remote-event-bus",
            assume_role_policy=assume_role.json)
        event_bus_invoke_remote_event_bus = aws.iam.get_policy_document(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            effect="Allow",
            actions=["events:PutEvents"],
            resources=["arn:aws:events:eu-west-1:1234567890:event-bus/My-Event-Bus"],
        )])
        event_bus_invoke_remote_event_bus_policy = aws.iam.Policy("event_bus_invoke_remote_event_bus",
            name="event_bus_invoke_remote_event_bus",
            policy=event_bus_invoke_remote_event_bus.json)
        event_bus_invoke_remote_event_bus_role_policy_attachment = aws.iam.RolePolicyAttachment("event_bus_invoke_remote_event_bus",
            role=event_bus_invoke_remote_event_bus_role.name,
            policy_arn=event_bus_invoke_remote_event_bus_policy.arn)
        stop_instances = aws.cloudwatch.EventRule("stop_instances",
            name="StopInstance",
            description="Stop instances nightly",
            schedule_expression="cron(0 0 * * ? *)")
        stop_instances_event_target = aws.cloudwatch.EventTarget("stop_instances",
            target_id="StopInstance",
            arn="arn:aws:events:eu-west-1:1234567890:event-bus/My-Event-Bus",
            rule=stop_instances.name,
            role_arn=event_bus_invoke_remote_event_bus_role.arn)
        ```
        <!--End PulumiCodeChooser -->

        ### Input Transformer Usage - JSON Object

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example_event_rule = aws.cloudwatch.EventRule("example")
        example = aws.cloudwatch.EventTarget("example",
            arn=example_aws_lambda_function["arn"],
            rule=example_event_rule.id,
            input_transformer=aws.cloudwatch.EventTargetInputTransformerArgs(
                input_paths={
                    "instance": "$.detail.instance",
                    "status": "$.detail.status",
                },
                input_template=\"\"\"{
          "instance_id": <instance>,
          "instance_status": <status>
        }
        \"\"\",
            ))
        ```
        <!--End PulumiCodeChooser -->

        ### Input Transformer Usage - Simple String

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example_event_rule = aws.cloudwatch.EventRule("example")
        example = aws.cloudwatch.EventTarget("example",
            arn=example_aws_lambda_function["arn"],
            rule=example_event_rule.id,
            input_transformer=aws.cloudwatch.EventTargetInputTransformerArgs(
                input_paths={
                    "instance": "$.detail.instance",
                    "status": "$.detail.status",
                },
                input_template="\\"<instance> is in state <status>\\"",
            ))
        ```
        <!--End PulumiCodeChooser -->

        ### Cloudwatch Log Group Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.cloudwatch.LogGroup("example",
            name="/aws/events/guardduty/logs",
            retention_in_days=1)
        example_event_rule = aws.cloudwatch.EventRule("example",
            name="guard-duty_event_rule",
            description="GuardDuty Findings",
            event_pattern=json.dumps({
                "source": ["aws.guardduty"],
            }),
            tags={
                "Environment": "example",
            })
        example_log_policy = aws.iam.get_policy_document_output(statements=[
            aws.iam.GetPolicyDocumentStatementArgs(
                effect="Allow",
                actions=["logs:CreateLogStream"],
                resources=[example.arn.apply(lambda arn: f"{arn}:*")],
                principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                    type="Service",
                    identifiers=[
                        "events.amazonaws.com",
                        "delivery.logs.amazonaws.com",
                    ],
                )],
            ),
            aws.iam.GetPolicyDocumentStatementArgs(
                effect="Allow",
                actions=["logs:PutLogEvents"],
                resources=[example.arn.apply(lambda arn: f"{arn}:*:*")],
                principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                    type="Service",
                    identifiers=[
                        "events.amazonaws.com",
                        "delivery.logs.amazonaws.com",
                    ],
                )],
                conditions=[aws.iam.GetPolicyDocumentStatementConditionArgs(
                    test="ArnEquals",
                    values=[example_event_rule.arn],
                    variable="aws:SourceArn",
                )],
            ),
        ])
        example_log_resource_policy = aws.cloudwatch.LogResourcePolicy("example",
            policy_document=example_log_policy.json,
            policy_name="guardduty-log-publishing-policy")
        example_event_target = aws.cloudwatch.EventTarget("example",
            rule=example_event_rule.name,
            arn=example.arn)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import EventBridge Targets using `event_bus_name/rule-name/target-id` (if you omit `event_bus_name`, the `default` event bus will be used). For example:

        ```sh
        $ pulumi import aws:cloudwatch/eventTarget:EventTarget test-event-target rule-name/target-id
        ```

        :param str resource_name: The name of the resource.
        :param EventTargetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EventTargetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 batch_target: Optional[pulumi.Input[pulumi.InputType['EventTargetBatchTargetArgs']]] = None,
                 dead_letter_config: Optional[pulumi.Input[pulumi.InputType['EventTargetDeadLetterConfigArgs']]] = None,
                 ecs_target: Optional[pulumi.Input[pulumi.InputType['EventTargetEcsTargetArgs']]] = None,
                 event_bus_name: Optional[pulumi.Input[str]] = None,
                 http_target: Optional[pulumi.Input[pulumi.InputType['EventTargetHttpTargetArgs']]] = None,
                 input: Optional[pulumi.Input[str]] = None,
                 input_path: Optional[pulumi.Input[str]] = None,
                 input_transformer: Optional[pulumi.Input[pulumi.InputType['EventTargetInputTransformerArgs']]] = None,
                 kinesis_target: Optional[pulumi.Input[pulumi.InputType['EventTargetKinesisTargetArgs']]] = None,
                 redshift_target: Optional[pulumi.Input[pulumi.InputType['EventTargetRedshiftTargetArgs']]] = None,
                 retry_policy: Optional[pulumi.Input[pulumi.InputType['EventTargetRetryPolicyArgs']]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 rule: Optional[pulumi.Input[str]] = None,
                 run_command_targets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EventTargetRunCommandTargetArgs']]]]] = None,
                 sagemaker_pipeline_target: Optional[pulumi.Input[pulumi.InputType['EventTargetSagemakerPipelineTargetArgs']]] = None,
                 sqs_target: Optional[pulumi.Input[pulumi.InputType['EventTargetSqsTargetArgs']]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EventTargetArgs.__new__(EventTargetArgs)

            if arn is None and not opts.urn:
                raise TypeError("Missing required property 'arn'")
            __props__.__dict__["arn"] = arn
            __props__.__dict__["batch_target"] = batch_target
            __props__.__dict__["dead_letter_config"] = dead_letter_config
            __props__.__dict__["ecs_target"] = ecs_target
            __props__.__dict__["event_bus_name"] = event_bus_name
            __props__.__dict__["http_target"] = http_target
            __props__.__dict__["input"] = input
            __props__.__dict__["input_path"] = input_path
            __props__.__dict__["input_transformer"] = input_transformer
            __props__.__dict__["kinesis_target"] = kinesis_target
            __props__.__dict__["redshift_target"] = redshift_target
            __props__.__dict__["retry_policy"] = retry_policy
            __props__.__dict__["role_arn"] = role_arn
            if rule is None and not opts.urn:
                raise TypeError("Missing required property 'rule'")
            __props__.__dict__["rule"] = rule
            __props__.__dict__["run_command_targets"] = run_command_targets
            __props__.__dict__["sagemaker_pipeline_target"] = sagemaker_pipeline_target
            __props__.__dict__["sqs_target"] = sqs_target
            __props__.__dict__["target_id"] = target_id
        super(EventTarget, __self__).__init__(
            'aws:cloudwatch/eventTarget:EventTarget',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            batch_target: Optional[pulumi.Input[pulumi.InputType['EventTargetBatchTargetArgs']]] = None,
            dead_letter_config: Optional[pulumi.Input[pulumi.InputType['EventTargetDeadLetterConfigArgs']]] = None,
            ecs_target: Optional[pulumi.Input[pulumi.InputType['EventTargetEcsTargetArgs']]] = None,
            event_bus_name: Optional[pulumi.Input[str]] = None,
            http_target: Optional[pulumi.Input[pulumi.InputType['EventTargetHttpTargetArgs']]] = None,
            input: Optional[pulumi.Input[str]] = None,
            input_path: Optional[pulumi.Input[str]] = None,
            input_transformer: Optional[pulumi.Input[pulumi.InputType['EventTargetInputTransformerArgs']]] = None,
            kinesis_target: Optional[pulumi.Input[pulumi.InputType['EventTargetKinesisTargetArgs']]] = None,
            redshift_target: Optional[pulumi.Input[pulumi.InputType['EventTargetRedshiftTargetArgs']]] = None,
            retry_policy: Optional[pulumi.Input[pulumi.InputType['EventTargetRetryPolicyArgs']]] = None,
            role_arn: Optional[pulumi.Input[str]] = None,
            rule: Optional[pulumi.Input[str]] = None,
            run_command_targets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EventTargetRunCommandTargetArgs']]]]] = None,
            sagemaker_pipeline_target: Optional[pulumi.Input[pulumi.InputType['EventTargetSagemakerPipelineTargetArgs']]] = None,
            sqs_target: Optional[pulumi.Input[pulumi.InputType['EventTargetSqsTargetArgs']]] = None,
            target_id: Optional[pulumi.Input[str]] = None) -> 'EventTarget':
        """
        Get an existing EventTarget resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) of the target.
        :param pulumi.Input[pulumi.InputType['EventTargetBatchTargetArgs']] batch_target: Parameters used when you are using the rule to invoke an Amazon Batch Job. Documented below. A maximum of 1 are allowed.
        :param pulumi.Input[pulumi.InputType['EventTargetDeadLetterConfigArgs']] dead_letter_config: Parameters used when you are providing a dead letter config. Documented below. A maximum of 1 are allowed.
        :param pulumi.Input[pulumi.InputType['EventTargetEcsTargetArgs']] ecs_target: Parameters used when you are using the rule to invoke Amazon ECS Task. Documented below. A maximum of 1 are allowed.
        :param pulumi.Input[str] event_bus_name: The name or ARN of the event bus to associate with the rule.
               If you omit this, the `default` event bus is used.
        :param pulumi.Input[pulumi.InputType['EventTargetHttpTargetArgs']] http_target: Parameters used when you are using the rule to invoke an API Gateway REST endpoint. Documented below. A maximum of 1 is allowed.
        :param pulumi.Input[str] input: Valid JSON text passed to the target. Conflicts with `input_path` and `input_transformer`.
        :param pulumi.Input[str] input_path: The value of the [JSONPath](http://goessner.net/articles/JsonPath/) that is used for extracting part of the matched event when passing it to the target. Conflicts with `input` and `input_transformer`.
        :param pulumi.Input[pulumi.InputType['EventTargetInputTransformerArgs']] input_transformer: Parameters used when you are providing a custom input to a target based on certain event data. Conflicts with `input` and `input_path`.
        :param pulumi.Input[pulumi.InputType['EventTargetKinesisTargetArgs']] kinesis_target: Parameters used when you are using the rule to invoke an Amazon Kinesis Stream. Documented below. A maximum of 1 are allowed.
        :param pulumi.Input[pulumi.InputType['EventTargetRedshiftTargetArgs']] redshift_target: Parameters used when you are using the rule to invoke an Amazon Redshift Statement. Documented below. A maximum of 1 are allowed.
        :param pulumi.Input[pulumi.InputType['EventTargetRetryPolicyArgs']] retry_policy: Parameters used when you are providing retry policies. Documented below. A maximum of 1 are allowed.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is triggered. Required if `ecs_target` is used or target in `arn` is EC2 instance, Kinesis data stream, Step Functions state machine, or Event Bus in different account or region.
        :param pulumi.Input[str] rule: The name of the rule you want to add targets to.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EventTargetRunCommandTargetArgs']]]] run_command_targets: Parameters used when you are using the rule to invoke Amazon EC2 Run Command. Documented below. A maximum of 5 are allowed.
        :param pulumi.Input[pulumi.InputType['EventTargetSagemakerPipelineTargetArgs']] sagemaker_pipeline_target: Parameters used when you are using the rule to invoke an Amazon SageMaker Pipeline. Documented below. A maximum of 1 are allowed.
        :param pulumi.Input[pulumi.InputType['EventTargetSqsTargetArgs']] sqs_target: Parameters used when you are using the rule to invoke an Amazon SQS Queue. Documented below. A maximum of 1 are allowed.
        :param pulumi.Input[str] target_id: The unique target assignment ID. If missing, will generate a random, unique id.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EventTargetState.__new__(_EventTargetState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["batch_target"] = batch_target
        __props__.__dict__["dead_letter_config"] = dead_letter_config
        __props__.__dict__["ecs_target"] = ecs_target
        __props__.__dict__["event_bus_name"] = event_bus_name
        __props__.__dict__["http_target"] = http_target
        __props__.__dict__["input"] = input
        __props__.__dict__["input_path"] = input_path
        __props__.__dict__["input_transformer"] = input_transformer
        __props__.__dict__["kinesis_target"] = kinesis_target
        __props__.__dict__["redshift_target"] = redshift_target
        __props__.__dict__["retry_policy"] = retry_policy
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["rule"] = rule
        __props__.__dict__["run_command_targets"] = run_command_targets
        __props__.__dict__["sagemaker_pipeline_target"] = sagemaker_pipeline_target
        __props__.__dict__["sqs_target"] = sqs_target
        __props__.__dict__["target_id"] = target_id
        return EventTarget(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the target.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="batchTarget")
    def batch_target(self) -> pulumi.Output[Optional['outputs.EventTargetBatchTarget']]:
        """
        Parameters used when you are using the rule to invoke an Amazon Batch Job. Documented below. A maximum of 1 are allowed.
        """
        return pulumi.get(self, "batch_target")

    @property
    @pulumi.getter(name="deadLetterConfig")
    def dead_letter_config(self) -> pulumi.Output[Optional['outputs.EventTargetDeadLetterConfig']]:
        """
        Parameters used when you are providing a dead letter config. Documented below. A maximum of 1 are allowed.
        """
        return pulumi.get(self, "dead_letter_config")

    @property
    @pulumi.getter(name="ecsTarget")
    def ecs_target(self) -> pulumi.Output[Optional['outputs.EventTargetEcsTarget']]:
        """
        Parameters used when you are using the rule to invoke Amazon ECS Task. Documented below. A maximum of 1 are allowed.
        """
        return pulumi.get(self, "ecs_target")

    @property
    @pulumi.getter(name="eventBusName")
    def event_bus_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name or ARN of the event bus to associate with the rule.
        If you omit this, the `default` event bus is used.
        """
        return pulumi.get(self, "event_bus_name")

    @property
    @pulumi.getter(name="httpTarget")
    def http_target(self) -> pulumi.Output[Optional['outputs.EventTargetHttpTarget']]:
        """
        Parameters used when you are using the rule to invoke an API Gateway REST endpoint. Documented below. A maximum of 1 is allowed.
        """
        return pulumi.get(self, "http_target")

    @property
    @pulumi.getter
    def input(self) -> pulumi.Output[Optional[str]]:
        """
        Valid JSON text passed to the target. Conflicts with `input_path` and `input_transformer`.
        """
        return pulumi.get(self, "input")

    @property
    @pulumi.getter(name="inputPath")
    def input_path(self) -> pulumi.Output[Optional[str]]:
        """
        The value of the [JSONPath](http://goessner.net/articles/JsonPath/) that is used for extracting part of the matched event when passing it to the target. Conflicts with `input` and `input_transformer`.
        """
        return pulumi.get(self, "input_path")

    @property
    @pulumi.getter(name="inputTransformer")
    def input_transformer(self) -> pulumi.Output[Optional['outputs.EventTargetInputTransformer']]:
        """
        Parameters used when you are providing a custom input to a target based on certain event data. Conflicts with `input` and `input_path`.
        """
        return pulumi.get(self, "input_transformer")

    @property
    @pulumi.getter(name="kinesisTarget")
    def kinesis_target(self) -> pulumi.Output[Optional['outputs.EventTargetKinesisTarget']]:
        """
        Parameters used when you are using the rule to invoke an Amazon Kinesis Stream. Documented below. A maximum of 1 are allowed.
        """
        return pulumi.get(self, "kinesis_target")

    @property
    @pulumi.getter(name="redshiftTarget")
    def redshift_target(self) -> pulumi.Output[Optional['outputs.EventTargetRedshiftTarget']]:
        """
        Parameters used when you are using the rule to invoke an Amazon Redshift Statement. Documented below. A maximum of 1 are allowed.
        """
        return pulumi.get(self, "redshift_target")

    @property
    @pulumi.getter(name="retryPolicy")
    def retry_policy(self) -> pulumi.Output[Optional['outputs.EventTargetRetryPolicy']]:
        """
        Parameters used when you are providing retry policies. Documented below. A maximum of 1 are allowed.
        """
        return pulumi.get(self, "retry_policy")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is triggered. Required if `ecs_target` is used or target in `arn` is EC2 instance, Kinesis data stream, Step Functions state machine, or Event Bus in different account or region.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def rule(self) -> pulumi.Output[str]:
        """
        The name of the rule you want to add targets to.

        The following arguments are optional:
        """
        return pulumi.get(self, "rule")

    @property
    @pulumi.getter(name="runCommandTargets")
    def run_command_targets(self) -> pulumi.Output[Optional[Sequence['outputs.EventTargetRunCommandTarget']]]:
        """
        Parameters used when you are using the rule to invoke Amazon EC2 Run Command. Documented below. A maximum of 5 are allowed.
        """
        return pulumi.get(self, "run_command_targets")

    @property
    @pulumi.getter(name="sagemakerPipelineTarget")
    def sagemaker_pipeline_target(self) -> pulumi.Output[Optional['outputs.EventTargetSagemakerPipelineTarget']]:
        """
        Parameters used when you are using the rule to invoke an Amazon SageMaker Pipeline. Documented below. A maximum of 1 are allowed.
        """
        return pulumi.get(self, "sagemaker_pipeline_target")

    @property
    @pulumi.getter(name="sqsTarget")
    def sqs_target(self) -> pulumi.Output[Optional['outputs.EventTargetSqsTarget']]:
        """
        Parameters used when you are using the rule to invoke an Amazon SQS Queue. Documented below. A maximum of 1 are allowed.
        """
        return pulumi.get(self, "sqs_target")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Output[str]:
        """
        The unique target assignment ID. If missing, will generate a random, unique id.
        """
        return pulumi.get(self, "target_id")

