# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetEventBusResult',
    'AwaitableGetEventBusResult',
    'get_event_bus',
    'get_event_bus_output',
]

@pulumi.output_type
class GetEventBusResult:
    """
    A collection of values returned by getEventBus.
    """
    def __init__(__self__, arn=None, id=None, name=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        ARN.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")


class AwaitableGetEventBusResult(GetEventBusResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEventBusResult(
            arn=self.arn,
            id=self.id,
            name=self.name)


def get_event_bus(name: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEventBusResult:
    """
    This data source can be used to fetch information about a specific
    EventBridge event bus. Use this data source to compute the ARN of
    an event bus, given the name of the bus.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.cloudwatch.get_event_bus(name="example-bus-name")
    ```
    <!--End PulumiCodeChooser -->


    :param str name: Friendly EventBridge event bus name.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:cloudwatch/getEventBus:getEventBus', __args__, opts=opts, typ=GetEventBusResult).value

    return AwaitableGetEventBusResult(
        arn=pulumi.get(__ret__, 'arn'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'))


@_utilities.lift_output_func(get_event_bus)
def get_event_bus_output(name: Optional[pulumi.Input[str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEventBusResult]:
    """
    This data source can be used to fetch information about a specific
    EventBridge event bus. Use this data source to compute the ARN of
    an event bus, given the name of the bus.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.cloudwatch.get_event_bus(name="example-bus-name")
    ```
    <!--End PulumiCodeChooser -->


    :param str name: Friendly EventBridge event bus name.
    """
    ...
