# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DevEnvironmentArgs', 'DevEnvironment']

@pulumi.input_type
class DevEnvironmentArgs:
    def __init__(__self__, *,
                 ides: pulumi.Input['DevEnvironmentIdesArgs'],
                 instance_type: pulumi.Input[str],
                 persistent_storage: pulumi.Input['DevEnvironmentPersistentStorageArgs'],
                 project_name: pulumi.Input[str],
                 space_name: pulumi.Input[str],
                 alias: Optional[pulumi.Input[str]] = None,
                 inactivity_timeout_minutes: Optional[pulumi.Input[int]] = None,
                 repositories: Optional[pulumi.Input[Sequence[pulumi.Input['DevEnvironmentRepositoryArgs']]]] = None):
        """
        The set of arguments for constructing a DevEnvironment resource.
        :param pulumi.Input['DevEnvironmentIdesArgs'] ides: Information about the integrated development environment (IDE) configured for a Dev Environment.
        :param pulumi.Input[str] instance_type: The Amazon EC2 instace type to use for the Dev Environment. Valid values include dev.standard1.small,dev.standard1.medium,dev.standard1.large,dev.standard1.xlarge
               
               The following arguments are optional:
        :param pulumi.Input['DevEnvironmentPersistentStorageArgs'] persistent_storage: Information about the amount of storage allocated to the Dev Environment.
        :param pulumi.Input[str] project_name: The name of the project in the space.
        :param pulumi.Input[str] space_name: The name of the space.
        :param pulumi.Input[int] inactivity_timeout_minutes: The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Only whole integers are allowed. Dev Environments consume compute minutes when running.
        :param pulumi.Input[Sequence[pulumi.Input['DevEnvironmentRepositoryArgs']]] repositories: The source repository that contains the branch to clone into the Dev Environment.
        """
        pulumi.set(__self__, "ides", ides)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "persistent_storage", persistent_storage)
        pulumi.set(__self__, "project_name", project_name)
        pulumi.set(__self__, "space_name", space_name)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if inactivity_timeout_minutes is not None:
            pulumi.set(__self__, "inactivity_timeout_minutes", inactivity_timeout_minutes)
        if repositories is not None:
            pulumi.set(__self__, "repositories", repositories)

    @property
    @pulumi.getter
    def ides(self) -> pulumi.Input['DevEnvironmentIdesArgs']:
        """
        Information about the integrated development environment (IDE) configured for a Dev Environment.
        """
        return pulumi.get(self, "ides")

    @ides.setter
    def ides(self, value: pulumi.Input['DevEnvironmentIdesArgs']):
        pulumi.set(self, "ides", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        """
        The Amazon EC2 instace type to use for the Dev Environment. Valid values include dev.standard1.small,dev.standard1.medium,dev.standard1.large,dev.standard1.xlarge

        The following arguments are optional:
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="persistentStorage")
    def persistent_storage(self) -> pulumi.Input['DevEnvironmentPersistentStorageArgs']:
        """
        Information about the amount of storage allocated to the Dev Environment.
        """
        return pulumi.get(self, "persistent_storage")

    @persistent_storage.setter
    def persistent_storage(self, value: pulumi.Input['DevEnvironmentPersistentStorageArgs']):
        pulumi.set(self, "persistent_storage", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Input[str]:
        """
        The name of the project in the space.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter(name="spaceName")
    def space_name(self) -> pulumi.Input[str]:
        """
        The name of the space.
        """
        return pulumi.get(self, "space_name")

    @space_name.setter
    def space_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "space_name", value)

    @property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alias", value)

    @property
    @pulumi.getter(name="inactivityTimeoutMinutes")
    def inactivity_timeout_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Only whole integers are allowed. Dev Environments consume compute minutes when running.
        """
        return pulumi.get(self, "inactivity_timeout_minutes")

    @inactivity_timeout_minutes.setter
    def inactivity_timeout_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "inactivity_timeout_minutes", value)

    @property
    @pulumi.getter
    def repositories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DevEnvironmentRepositoryArgs']]]]:
        """
        The source repository that contains the branch to clone into the Dev Environment.
        """
        return pulumi.get(self, "repositories")

    @repositories.setter
    def repositories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DevEnvironmentRepositoryArgs']]]]):
        pulumi.set(self, "repositories", value)


@pulumi.input_type
class _DevEnvironmentState:
    def __init__(__self__, *,
                 alias: Optional[pulumi.Input[str]] = None,
                 ides: Optional[pulumi.Input['DevEnvironmentIdesArgs']] = None,
                 inactivity_timeout_minutes: Optional[pulumi.Input[int]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 persistent_storage: Optional[pulumi.Input['DevEnvironmentPersistentStorageArgs']] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 repositories: Optional[pulumi.Input[Sequence[pulumi.Input['DevEnvironmentRepositoryArgs']]]] = None,
                 space_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DevEnvironment resources.
        :param pulumi.Input['DevEnvironmentIdesArgs'] ides: Information about the integrated development environment (IDE) configured for a Dev Environment.
        :param pulumi.Input[int] inactivity_timeout_minutes: The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Only whole integers are allowed. Dev Environments consume compute minutes when running.
        :param pulumi.Input[str] instance_type: The Amazon EC2 instace type to use for the Dev Environment. Valid values include dev.standard1.small,dev.standard1.medium,dev.standard1.large,dev.standard1.xlarge
               
               The following arguments are optional:
        :param pulumi.Input['DevEnvironmentPersistentStorageArgs'] persistent_storage: Information about the amount of storage allocated to the Dev Environment.
        :param pulumi.Input[str] project_name: The name of the project in the space.
        :param pulumi.Input[Sequence[pulumi.Input['DevEnvironmentRepositoryArgs']]] repositories: The source repository that contains the branch to clone into the Dev Environment.
        :param pulumi.Input[str] space_name: The name of the space.
        """
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if ides is not None:
            pulumi.set(__self__, "ides", ides)
        if inactivity_timeout_minutes is not None:
            pulumi.set(__self__, "inactivity_timeout_minutes", inactivity_timeout_minutes)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if persistent_storage is not None:
            pulumi.set(__self__, "persistent_storage", persistent_storage)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if repositories is not None:
            pulumi.set(__self__, "repositories", repositories)
        if space_name is not None:
            pulumi.set(__self__, "space_name", space_name)

    @property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alias", value)

    @property
    @pulumi.getter
    def ides(self) -> Optional[pulumi.Input['DevEnvironmentIdesArgs']]:
        """
        Information about the integrated development environment (IDE) configured for a Dev Environment.
        """
        return pulumi.get(self, "ides")

    @ides.setter
    def ides(self, value: Optional[pulumi.Input['DevEnvironmentIdesArgs']]):
        pulumi.set(self, "ides", value)

    @property
    @pulumi.getter(name="inactivityTimeoutMinutes")
    def inactivity_timeout_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Only whole integers are allowed. Dev Environments consume compute minutes when running.
        """
        return pulumi.get(self, "inactivity_timeout_minutes")

    @inactivity_timeout_minutes.setter
    def inactivity_timeout_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "inactivity_timeout_minutes", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon EC2 instace type to use for the Dev Environment. Valid values include dev.standard1.small,dev.standard1.medium,dev.standard1.large,dev.standard1.xlarge

        The following arguments are optional:
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="persistentStorage")
    def persistent_storage(self) -> Optional[pulumi.Input['DevEnvironmentPersistentStorageArgs']]:
        """
        Information about the amount of storage allocated to the Dev Environment.
        """
        return pulumi.get(self, "persistent_storage")

    @persistent_storage.setter
    def persistent_storage(self, value: Optional[pulumi.Input['DevEnvironmentPersistentStorageArgs']]):
        pulumi.set(self, "persistent_storage", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the project in the space.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter
    def repositories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DevEnvironmentRepositoryArgs']]]]:
        """
        The source repository that contains the branch to clone into the Dev Environment.
        """
        return pulumi.get(self, "repositories")

    @repositories.setter
    def repositories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DevEnvironmentRepositoryArgs']]]]):
        pulumi.set(self, "repositories", value)

    @property
    @pulumi.getter(name="spaceName")
    def space_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the space.
        """
        return pulumi.get(self, "space_name")

    @space_name.setter
    def space_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "space_name", value)


class DevEnvironment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias: Optional[pulumi.Input[str]] = None,
                 ides: Optional[pulumi.Input[pulumi.InputType['DevEnvironmentIdesArgs']]] = None,
                 inactivity_timeout_minutes: Optional[pulumi.Input[int]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 persistent_storage: Optional[pulumi.Input[pulumi.InputType['DevEnvironmentPersistentStorageArgs']]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 repositories: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DevEnvironmentRepositoryArgs']]]]] = None,
                 space_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS CodeCatalyst Dev Environment.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.codecatalyst.DevEnvironment("test",
            alias="devenv",
            space_name="myspace",
            project_name="myproject",
            instance_type="dev.standard1.small",
            persistent_storage=aws.codecatalyst.DevEnvironmentPersistentStorageArgs(
                size=16,
            ),
            ides=aws.codecatalyst.DevEnvironmentIdesArgs(
                name="PyCharm",
                runtime="public.ecr.aws/jetbrains/py",
            ),
            inactivity_timeout_minutes=40,
            repositories=[aws.codecatalyst.DevEnvironmentRepositoryArgs(
                repository_name="pulumi-provider-aws",
                branch_name="main",
            )])
        ```
        <!--End PulumiCodeChooser -->

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['DevEnvironmentIdesArgs']] ides: Information about the integrated development environment (IDE) configured for a Dev Environment.
        :param pulumi.Input[int] inactivity_timeout_minutes: The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Only whole integers are allowed. Dev Environments consume compute minutes when running.
        :param pulumi.Input[str] instance_type: The Amazon EC2 instace type to use for the Dev Environment. Valid values include dev.standard1.small,dev.standard1.medium,dev.standard1.large,dev.standard1.xlarge
               
               The following arguments are optional:
        :param pulumi.Input[pulumi.InputType['DevEnvironmentPersistentStorageArgs']] persistent_storage: Information about the amount of storage allocated to the Dev Environment.
        :param pulumi.Input[str] project_name: The name of the project in the space.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DevEnvironmentRepositoryArgs']]]] repositories: The source repository that contains the branch to clone into the Dev Environment.
        :param pulumi.Input[str] space_name: The name of the space.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DevEnvironmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS CodeCatalyst Dev Environment.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.codecatalyst.DevEnvironment("test",
            alias="devenv",
            space_name="myspace",
            project_name="myproject",
            instance_type="dev.standard1.small",
            persistent_storage=aws.codecatalyst.DevEnvironmentPersistentStorageArgs(
                size=16,
            ),
            ides=aws.codecatalyst.DevEnvironmentIdesArgs(
                name="PyCharm",
                runtime="public.ecr.aws/jetbrains/py",
            ),
            inactivity_timeout_minutes=40,
            repositories=[aws.codecatalyst.DevEnvironmentRepositoryArgs(
                repository_name="pulumi-provider-aws",
                branch_name="main",
            )])
        ```
        <!--End PulumiCodeChooser -->

        :param str resource_name: The name of the resource.
        :param DevEnvironmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DevEnvironmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias: Optional[pulumi.Input[str]] = None,
                 ides: Optional[pulumi.Input[pulumi.InputType['DevEnvironmentIdesArgs']]] = None,
                 inactivity_timeout_minutes: Optional[pulumi.Input[int]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 persistent_storage: Optional[pulumi.Input[pulumi.InputType['DevEnvironmentPersistentStorageArgs']]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 repositories: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DevEnvironmentRepositoryArgs']]]]] = None,
                 space_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DevEnvironmentArgs.__new__(DevEnvironmentArgs)

            __props__.__dict__["alias"] = alias
            if ides is None and not opts.urn:
                raise TypeError("Missing required property 'ides'")
            __props__.__dict__["ides"] = ides
            __props__.__dict__["inactivity_timeout_minutes"] = inactivity_timeout_minutes
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            if persistent_storage is None and not opts.urn:
                raise TypeError("Missing required property 'persistent_storage'")
            __props__.__dict__["persistent_storage"] = persistent_storage
            if project_name is None and not opts.urn:
                raise TypeError("Missing required property 'project_name'")
            __props__.__dict__["project_name"] = project_name
            __props__.__dict__["repositories"] = repositories
            if space_name is None and not opts.urn:
                raise TypeError("Missing required property 'space_name'")
            __props__.__dict__["space_name"] = space_name
        super(DevEnvironment, __self__).__init__(
            'aws:codecatalyst/devEnvironment:DevEnvironment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alias: Optional[pulumi.Input[str]] = None,
            ides: Optional[pulumi.Input[pulumi.InputType['DevEnvironmentIdesArgs']]] = None,
            inactivity_timeout_minutes: Optional[pulumi.Input[int]] = None,
            instance_type: Optional[pulumi.Input[str]] = None,
            persistent_storage: Optional[pulumi.Input[pulumi.InputType['DevEnvironmentPersistentStorageArgs']]] = None,
            project_name: Optional[pulumi.Input[str]] = None,
            repositories: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DevEnvironmentRepositoryArgs']]]]] = None,
            space_name: Optional[pulumi.Input[str]] = None) -> 'DevEnvironment':
        """
        Get an existing DevEnvironment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['DevEnvironmentIdesArgs']] ides: Information about the integrated development environment (IDE) configured for a Dev Environment.
        :param pulumi.Input[int] inactivity_timeout_minutes: The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Only whole integers are allowed. Dev Environments consume compute minutes when running.
        :param pulumi.Input[str] instance_type: The Amazon EC2 instace type to use for the Dev Environment. Valid values include dev.standard1.small,dev.standard1.medium,dev.standard1.large,dev.standard1.xlarge
               
               The following arguments are optional:
        :param pulumi.Input[pulumi.InputType['DevEnvironmentPersistentStorageArgs']] persistent_storage: Information about the amount of storage allocated to the Dev Environment.
        :param pulumi.Input[str] project_name: The name of the project in the space.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DevEnvironmentRepositoryArgs']]]] repositories: The source repository that contains the branch to clone into the Dev Environment.
        :param pulumi.Input[str] space_name: The name of the space.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DevEnvironmentState.__new__(_DevEnvironmentState)

        __props__.__dict__["alias"] = alias
        __props__.__dict__["ides"] = ides
        __props__.__dict__["inactivity_timeout_minutes"] = inactivity_timeout_minutes
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["persistent_storage"] = persistent_storage
        __props__.__dict__["project_name"] = project_name
        __props__.__dict__["repositories"] = repositories
        __props__.__dict__["space_name"] = space_name
        return DevEnvironment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def alias(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter
    def ides(self) -> pulumi.Output['outputs.DevEnvironmentIdes']:
        """
        Information about the integrated development environment (IDE) configured for a Dev Environment.
        """
        return pulumi.get(self, "ides")

    @property
    @pulumi.getter(name="inactivityTimeoutMinutes")
    def inactivity_timeout_minutes(self) -> pulumi.Output[Optional[int]]:
        """
        The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Only whole integers are allowed. Dev Environments consume compute minutes when running.
        """
        return pulumi.get(self, "inactivity_timeout_minutes")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[str]:
        """
        The Amazon EC2 instace type to use for the Dev Environment. Valid values include dev.standard1.small,dev.standard1.medium,dev.standard1.large,dev.standard1.xlarge

        The following arguments are optional:
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="persistentStorage")
    def persistent_storage(self) -> pulumi.Output['outputs.DevEnvironmentPersistentStorage']:
        """
        Information about the amount of storage allocated to the Dev Environment.
        """
        return pulumi.get(self, "persistent_storage")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[str]:
        """
        The name of the project in the space.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter
    def repositories(self) -> pulumi.Output[Optional[Sequence['outputs.DevEnvironmentRepository']]]:
        """
        The source repository that contains the branch to clone into the Dev Environment.
        """
        return pulumi.get(self, "repositories")

    @property
    @pulumi.getter(name="spaceName")
    def space_name(self) -> pulumi.Output[str]:
        """
        The name of the space.
        """
        return pulumi.get(self, "space_name")

