# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDevEnvironmentResult',
    'AwaitableGetDevEnvironmentResult',
    'get_dev_environment',
    'get_dev_environment_output',
]

@pulumi.output_type
class GetDevEnvironmentResult:
    """
    A collection of values returned by getDevEnvironment.
    """
    def __init__(__self__, alias=None, creator_id=None, env_id=None, id=None, ides=None, inactivity_timeout_minutes=None, instance_type=None, last_updated_time=None, persistent_storages=None, project_name=None, repositories=None, space_name=None, status=None, status_reason=None, tags=None):
        if alias and not isinstance(alias, str):
            raise TypeError("Expected argument 'alias' to be a str")
        pulumi.set(__self__, "alias", alias)
        if creator_id and not isinstance(creator_id, str):
            raise TypeError("Expected argument 'creator_id' to be a str")
        pulumi.set(__self__, "creator_id", creator_id)
        if env_id and not isinstance(env_id, str):
            raise TypeError("Expected argument 'env_id' to be a str")
        pulumi.set(__self__, "env_id", env_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ides and not isinstance(ides, list):
            raise TypeError("Expected argument 'ides' to be a list")
        pulumi.set(__self__, "ides", ides)
        if inactivity_timeout_minutes and not isinstance(inactivity_timeout_minutes, int):
            raise TypeError("Expected argument 'inactivity_timeout_minutes' to be a int")
        pulumi.set(__self__, "inactivity_timeout_minutes", inactivity_timeout_minutes)
        if instance_type and not isinstance(instance_type, str):
            raise TypeError("Expected argument 'instance_type' to be a str")
        pulumi.set(__self__, "instance_type", instance_type)
        if last_updated_time and not isinstance(last_updated_time, str):
            raise TypeError("Expected argument 'last_updated_time' to be a str")
        pulumi.set(__self__, "last_updated_time", last_updated_time)
        if persistent_storages and not isinstance(persistent_storages, list):
            raise TypeError("Expected argument 'persistent_storages' to be a list")
        pulumi.set(__self__, "persistent_storages", persistent_storages)
        if project_name and not isinstance(project_name, str):
            raise TypeError("Expected argument 'project_name' to be a str")
        pulumi.set(__self__, "project_name", project_name)
        if repositories and not isinstance(repositories, list):
            raise TypeError("Expected argument 'repositories' to be a list")
        pulumi.set(__self__, "repositories", repositories)
        if space_name and not isinstance(space_name, str):
            raise TypeError("Expected argument 'space_name' to be a str")
        pulumi.set(__self__, "space_name", space_name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if status_reason and not isinstance(status_reason, str):
            raise TypeError("Expected argument 'status_reason' to be a str")
        pulumi.set(__self__, "status_reason", status_reason)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def alias(self) -> Optional[str]:
        """
        The user-specified alias for the Dev Environment.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="creatorId")
    def creator_id(self) -> Optional[str]:
        """
        The system-generated unique ID of the user who created the Dev Environment.
        """
        return pulumi.get(self, "creator_id")

    @property
    @pulumi.getter(name="envId")
    def env_id(self) -> str:
        return pulumi.get(self, "env_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ides(self) -> Sequence['outputs.GetDevEnvironmentIdeResult']:
        """
        Information about the integrated development environment (IDE) configured for a Dev Environment.
        """
        return pulumi.get(self, "ides")

    @property
    @pulumi.getter(name="inactivityTimeoutMinutes")
    def inactivity_timeout_minutes(self) -> int:
        """
        The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Only whole integers are allowed. Dev Environments consume compute minutes when running.
        """
        return pulumi.get(self, "inactivity_timeout_minutes")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        The Amazon EC2 instace type to use for the Dev Environment.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> str:
        """
        The time when the Dev Environment was last updated, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
        """
        return pulumi.get(self, "last_updated_time")

    @property
    @pulumi.getter(name="persistentStorages")
    def persistent_storages(self) -> Sequence['outputs.GetDevEnvironmentPersistentStorageResult']:
        """
        Information about the amount of storage allocated to the Dev Environment.
        """
        return pulumi.get(self, "persistent_storages")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> str:
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter
    def repositories(self) -> Optional[Sequence['outputs.GetDevEnvironmentRepositoryResult']]:
        """
        The source repository that contains the branch to clone into the Dev Environment.
        """
        return pulumi.get(self, "repositories")

    @property
    @pulumi.getter(name="spaceName")
    def space_name(self) -> str:
        return pulumi.get(self, "space_name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The current status of the Dev Environment. From: PENDING | RUNNING | STARTING | STOPPING | STOPPED | FAILED | DELETING | DELETED.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> str:
        """
        The reason for the status.
        """
        return pulumi.get(self, "status_reason")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        return pulumi.get(self, "tags")


class AwaitableGetDevEnvironmentResult(GetDevEnvironmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDevEnvironmentResult(
            alias=self.alias,
            creator_id=self.creator_id,
            env_id=self.env_id,
            id=self.id,
            ides=self.ides,
            inactivity_timeout_minutes=self.inactivity_timeout_minutes,
            instance_type=self.instance_type,
            last_updated_time=self.last_updated_time,
            persistent_storages=self.persistent_storages,
            project_name=self.project_name,
            repositories=self.repositories,
            space_name=self.space_name,
            status=self.status,
            status_reason=self.status_reason,
            tags=self.tags)


def get_dev_environment(alias: Optional[str] = None,
                        creator_id: Optional[str] = None,
                        env_id: Optional[str] = None,
                        project_name: Optional[str] = None,
                        repositories: Optional[Sequence[pulumi.InputType['GetDevEnvironmentRepositoryArgs']]] = None,
                        space_name: Optional[str] = None,
                        tags: Optional[Mapping[str, str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDevEnvironmentResult:
    """
    Data source for managing an AWS CodeCatalyst Dev Environment.

    ## Example Usage

    ### Basic Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.codecatalyst.get_dev_environment(space_name="myspace",
        project_name="myproject",
        env_id=example_aws_codecatalyst_dev_environment["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str alias: The user-specified alias for the Dev Environment.
    :param str creator_id: The system-generated unique ID of the user who created the Dev Environment.
    :param str env_id: - (Required) The system-generated unique ID of the Dev Environment for which you want to view information. To retrieve a list of Dev Environment IDs, use [ListDevEnvironments](https://docs.aws.amazon.com/codecatalyst/latest/APIReference/API_ListDevEnvironments.html).
    :param str project_name: The name of the project in the space.
    :param Sequence[pulumi.InputType['GetDevEnvironmentRepositoryArgs']] repositories: The source repository that contains the branch to clone into the Dev Environment.
    :param str space_name: The name of the space.
    """
    __args__ = dict()
    __args__['alias'] = alias
    __args__['creatorId'] = creator_id
    __args__['envId'] = env_id
    __args__['projectName'] = project_name
    __args__['repositories'] = repositories
    __args__['spaceName'] = space_name
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:codecatalyst/getDevEnvironment:getDevEnvironment', __args__, opts=opts, typ=GetDevEnvironmentResult).value

    return AwaitableGetDevEnvironmentResult(
        alias=pulumi.get(__ret__, 'alias'),
        creator_id=pulumi.get(__ret__, 'creator_id'),
        env_id=pulumi.get(__ret__, 'env_id'),
        id=pulumi.get(__ret__, 'id'),
        ides=pulumi.get(__ret__, 'ides'),
        inactivity_timeout_minutes=pulumi.get(__ret__, 'inactivity_timeout_minutes'),
        instance_type=pulumi.get(__ret__, 'instance_type'),
        last_updated_time=pulumi.get(__ret__, 'last_updated_time'),
        persistent_storages=pulumi.get(__ret__, 'persistent_storages'),
        project_name=pulumi.get(__ret__, 'project_name'),
        repositories=pulumi.get(__ret__, 'repositories'),
        space_name=pulumi.get(__ret__, 'space_name'),
        status=pulumi.get(__ret__, 'status'),
        status_reason=pulumi.get(__ret__, 'status_reason'),
        tags=pulumi.get(__ret__, 'tags'))


@_utilities.lift_output_func(get_dev_environment)
def get_dev_environment_output(alias: Optional[pulumi.Input[Optional[str]]] = None,
                               creator_id: Optional[pulumi.Input[Optional[str]]] = None,
                               env_id: Optional[pulumi.Input[str]] = None,
                               project_name: Optional[pulumi.Input[str]] = None,
                               repositories: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetDevEnvironmentRepositoryArgs']]]]] = None,
                               space_name: Optional[pulumi.Input[str]] = None,
                               tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDevEnvironmentResult]:
    """
    Data source for managing an AWS CodeCatalyst Dev Environment.

    ## Example Usage

    ### Basic Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.codecatalyst.get_dev_environment(space_name="myspace",
        project_name="myproject",
        env_id=example_aws_codecatalyst_dev_environment["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str alias: The user-specified alias for the Dev Environment.
    :param str creator_id: The system-generated unique ID of the user who created the Dev Environment.
    :param str env_id: - (Required) The system-generated unique ID of the Dev Environment for which you want to view information. To retrieve a list of Dev Environment IDs, use [ListDevEnvironments](https://docs.aws.amazon.com/codecatalyst/latest/APIReference/API_ListDevEnvironments.html).
    :param str project_name: The name of the project in the space.
    :param Sequence[pulumi.InputType['GetDevEnvironmentRepositoryArgs']] repositories: The source repository that contains the branch to clone into the Dev Environment.
    :param str space_name: The name of the space.
    """
    ...
