# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DeploymentGroupArgs', 'DeploymentGroup']

@pulumi.input_type
class DeploymentGroupArgs:
    def __init__(__self__, *,
                 app_name: pulumi.Input[str],
                 deployment_group_name: pulumi.Input[str],
                 service_role_arn: pulumi.Input[str],
                 alarm_configuration: Optional[pulumi.Input['DeploymentGroupAlarmConfigurationArgs']] = None,
                 auto_rollback_configuration: Optional[pulumi.Input['DeploymentGroupAutoRollbackConfigurationArgs']] = None,
                 autoscaling_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blue_green_deployment_config: Optional[pulumi.Input['DeploymentGroupBlueGreenDeploymentConfigArgs']] = None,
                 deployment_config_name: Optional[pulumi.Input[str]] = None,
                 deployment_style: Optional[pulumi.Input['DeploymentGroupDeploymentStyleArgs']] = None,
                 ec2_tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentGroupEc2TagFilterArgs']]]] = None,
                 ec2_tag_sets: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentGroupEc2TagSetArgs']]]] = None,
                 ecs_service: Optional[pulumi.Input['DeploymentGroupEcsServiceArgs']] = None,
                 load_balancer_info: Optional[pulumi.Input['DeploymentGroupLoadBalancerInfoArgs']] = None,
                 on_premises_instance_tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentGroupOnPremisesInstanceTagFilterArgs']]]] = None,
                 outdated_instances_strategy: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 trigger_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentGroupTriggerConfigurationArgs']]]] = None):
        """
        The set of arguments for constructing a DeploymentGroup resource.
        :param pulumi.Input[str] app_name: The name of the application.
        :param pulumi.Input[str] deployment_group_name: The name of the deployment group.
        :param pulumi.Input[str] service_role_arn: The service role ARN that allows deployments.
        :param pulumi.Input['DeploymentGroupAlarmConfigurationArgs'] alarm_configuration: Configuration block of alarms associated with the deployment group (documented below).
        :param pulumi.Input['DeploymentGroupAutoRollbackConfigurationArgs'] auto_rollback_configuration: Configuration block of the automatic rollback configuration associated with the deployment group (documented below).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] autoscaling_groups: Autoscaling groups associated with the deployment group.
        :param pulumi.Input['DeploymentGroupBlueGreenDeploymentConfigArgs'] blue_green_deployment_config: Configuration block of the blue/green deployment options for a deployment group (documented below).
        :param pulumi.Input[str] deployment_config_name: The name of the group's deployment config. The default is "CodeDeployDefault.OneAtATime".
        :param pulumi.Input['DeploymentGroupDeploymentStyleArgs'] deployment_style: Configuration block of the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer (documented below).
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentGroupEc2TagFilterArgs']]] ec2_tag_filters: Tag filters associated with the deployment group. See the AWS docs for details.
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentGroupEc2TagSetArgs']]] ec2_tag_sets: Configuration block(s) of Tag filters associated with the deployment group, which are also referred to as tag groups (documented below). See the AWS docs for details.
        :param pulumi.Input['DeploymentGroupEcsServiceArgs'] ecs_service: Configuration block(s) of the ECS services for a deployment group (documented below).
        :param pulumi.Input['DeploymentGroupLoadBalancerInfoArgs'] load_balancer_info: Single configuration block of the load balancer to use in a blue/green deployment (documented below).
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentGroupOnPremisesInstanceTagFilterArgs']]] on_premises_instance_tag_filters: On premise tag filters associated with the group. See the AWS docs for details.
        :param pulumi.Input[str] outdated_instances_strategy: Configuration block of Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the deployed application revision. Valid values are `UPDATE` and `IGNORE`. Defaults to `UPDATE`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentGroupTriggerConfigurationArgs']]] trigger_configurations: Configuration block(s) of the triggers for the deployment group (documented below).
        """
        pulumi.set(__self__, "app_name", app_name)
        pulumi.set(__self__, "deployment_group_name", deployment_group_name)
        pulumi.set(__self__, "service_role_arn", service_role_arn)
        if alarm_configuration is not None:
            pulumi.set(__self__, "alarm_configuration", alarm_configuration)
        if auto_rollback_configuration is not None:
            pulumi.set(__self__, "auto_rollback_configuration", auto_rollback_configuration)
        if autoscaling_groups is not None:
            pulumi.set(__self__, "autoscaling_groups", autoscaling_groups)
        if blue_green_deployment_config is not None:
            pulumi.set(__self__, "blue_green_deployment_config", blue_green_deployment_config)
        if deployment_config_name is not None:
            pulumi.set(__self__, "deployment_config_name", deployment_config_name)
        if deployment_style is not None:
            pulumi.set(__self__, "deployment_style", deployment_style)
        if ec2_tag_filters is not None:
            pulumi.set(__self__, "ec2_tag_filters", ec2_tag_filters)
        if ec2_tag_sets is not None:
            pulumi.set(__self__, "ec2_tag_sets", ec2_tag_sets)
        if ecs_service is not None:
            pulumi.set(__self__, "ecs_service", ecs_service)
        if load_balancer_info is not None:
            pulumi.set(__self__, "load_balancer_info", load_balancer_info)
        if on_premises_instance_tag_filters is not None:
            pulumi.set(__self__, "on_premises_instance_tag_filters", on_premises_instance_tag_filters)
        if outdated_instances_strategy is not None:
            pulumi.set(__self__, "outdated_instances_strategy", outdated_instances_strategy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if trigger_configurations is not None:
            pulumi.set(__self__, "trigger_configurations", trigger_configurations)

    @property
    @pulumi.getter(name="appName")
    def app_name(self) -> pulumi.Input[str]:
        """
        The name of the application.
        """
        return pulumi.get(self, "app_name")

    @app_name.setter
    def app_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "app_name", value)

    @property
    @pulumi.getter(name="deploymentGroupName")
    def deployment_group_name(self) -> pulumi.Input[str]:
        """
        The name of the deployment group.
        """
        return pulumi.get(self, "deployment_group_name")

    @deployment_group_name.setter
    def deployment_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "deployment_group_name", value)

    @property
    @pulumi.getter(name="serviceRoleArn")
    def service_role_arn(self) -> pulumi.Input[str]:
        """
        The service role ARN that allows deployments.
        """
        return pulumi.get(self, "service_role_arn")

    @service_role_arn.setter
    def service_role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_role_arn", value)

    @property
    @pulumi.getter(name="alarmConfiguration")
    def alarm_configuration(self) -> Optional[pulumi.Input['DeploymentGroupAlarmConfigurationArgs']]:
        """
        Configuration block of alarms associated with the deployment group (documented below).
        """
        return pulumi.get(self, "alarm_configuration")

    @alarm_configuration.setter
    def alarm_configuration(self, value: Optional[pulumi.Input['DeploymentGroupAlarmConfigurationArgs']]):
        pulumi.set(self, "alarm_configuration", value)

    @property
    @pulumi.getter(name="autoRollbackConfiguration")
    def auto_rollback_configuration(self) -> Optional[pulumi.Input['DeploymentGroupAutoRollbackConfigurationArgs']]:
        """
        Configuration block of the automatic rollback configuration associated with the deployment group (documented below).
        """
        return pulumi.get(self, "auto_rollback_configuration")

    @auto_rollback_configuration.setter
    def auto_rollback_configuration(self, value: Optional[pulumi.Input['DeploymentGroupAutoRollbackConfigurationArgs']]):
        pulumi.set(self, "auto_rollback_configuration", value)

    @property
    @pulumi.getter(name="autoscalingGroups")
    def autoscaling_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Autoscaling groups associated with the deployment group.
        """
        return pulumi.get(self, "autoscaling_groups")

    @autoscaling_groups.setter
    def autoscaling_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "autoscaling_groups", value)

    @property
    @pulumi.getter(name="blueGreenDeploymentConfig")
    def blue_green_deployment_config(self) -> Optional[pulumi.Input['DeploymentGroupBlueGreenDeploymentConfigArgs']]:
        """
        Configuration block of the blue/green deployment options for a deployment group (documented below).
        """
        return pulumi.get(self, "blue_green_deployment_config")

    @blue_green_deployment_config.setter
    def blue_green_deployment_config(self, value: Optional[pulumi.Input['DeploymentGroupBlueGreenDeploymentConfigArgs']]):
        pulumi.set(self, "blue_green_deployment_config", value)

    @property
    @pulumi.getter(name="deploymentConfigName")
    def deployment_config_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the group's deployment config. The default is "CodeDeployDefault.OneAtATime".
        """
        return pulumi.get(self, "deployment_config_name")

    @deployment_config_name.setter
    def deployment_config_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_config_name", value)

    @property
    @pulumi.getter(name="deploymentStyle")
    def deployment_style(self) -> Optional[pulumi.Input['DeploymentGroupDeploymentStyleArgs']]:
        """
        Configuration block of the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer (documented below).
        """
        return pulumi.get(self, "deployment_style")

    @deployment_style.setter
    def deployment_style(self, value: Optional[pulumi.Input['DeploymentGroupDeploymentStyleArgs']]):
        pulumi.set(self, "deployment_style", value)

    @property
    @pulumi.getter(name="ec2TagFilters")
    def ec2_tag_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentGroupEc2TagFilterArgs']]]]:
        """
        Tag filters associated with the deployment group. See the AWS docs for details.
        """
        return pulumi.get(self, "ec2_tag_filters")

    @ec2_tag_filters.setter
    def ec2_tag_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentGroupEc2TagFilterArgs']]]]):
        pulumi.set(self, "ec2_tag_filters", value)

    @property
    @pulumi.getter(name="ec2TagSets")
    def ec2_tag_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentGroupEc2TagSetArgs']]]]:
        """
        Configuration block(s) of Tag filters associated with the deployment group, which are also referred to as tag groups (documented below). See the AWS docs for details.
        """
        return pulumi.get(self, "ec2_tag_sets")

    @ec2_tag_sets.setter
    def ec2_tag_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentGroupEc2TagSetArgs']]]]):
        pulumi.set(self, "ec2_tag_sets", value)

    @property
    @pulumi.getter(name="ecsService")
    def ecs_service(self) -> Optional[pulumi.Input['DeploymentGroupEcsServiceArgs']]:
        """
        Configuration block(s) of the ECS services for a deployment group (documented below).
        """
        return pulumi.get(self, "ecs_service")

    @ecs_service.setter
    def ecs_service(self, value: Optional[pulumi.Input['DeploymentGroupEcsServiceArgs']]):
        pulumi.set(self, "ecs_service", value)

    @property
    @pulumi.getter(name="loadBalancerInfo")
    def load_balancer_info(self) -> Optional[pulumi.Input['DeploymentGroupLoadBalancerInfoArgs']]:
        """
        Single configuration block of the load balancer to use in a blue/green deployment (documented below).
        """
        return pulumi.get(self, "load_balancer_info")

    @load_balancer_info.setter
    def load_balancer_info(self, value: Optional[pulumi.Input['DeploymentGroupLoadBalancerInfoArgs']]):
        pulumi.set(self, "load_balancer_info", value)

    @property
    @pulumi.getter(name="onPremisesInstanceTagFilters")
    def on_premises_instance_tag_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentGroupOnPremisesInstanceTagFilterArgs']]]]:
        """
        On premise tag filters associated with the group. See the AWS docs for details.
        """
        return pulumi.get(self, "on_premises_instance_tag_filters")

    @on_premises_instance_tag_filters.setter
    def on_premises_instance_tag_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentGroupOnPremisesInstanceTagFilterArgs']]]]):
        pulumi.set(self, "on_premises_instance_tag_filters", value)

    @property
    @pulumi.getter(name="outdatedInstancesStrategy")
    def outdated_instances_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        Configuration block of Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the deployed application revision. Valid values are `UPDATE` and `IGNORE`. Defaults to `UPDATE`.
        """
        return pulumi.get(self, "outdated_instances_strategy")

    @outdated_instances_strategy.setter
    def outdated_instances_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "outdated_instances_strategy", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="triggerConfigurations")
    def trigger_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentGroupTriggerConfigurationArgs']]]]:
        """
        Configuration block(s) of the triggers for the deployment group (documented below).
        """
        return pulumi.get(self, "trigger_configurations")

    @trigger_configurations.setter
    def trigger_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentGroupTriggerConfigurationArgs']]]]):
        pulumi.set(self, "trigger_configurations", value)


@pulumi.input_type
class _DeploymentGroupState:
    def __init__(__self__, *,
                 alarm_configuration: Optional[pulumi.Input['DeploymentGroupAlarmConfigurationArgs']] = None,
                 app_name: Optional[pulumi.Input[str]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 auto_rollback_configuration: Optional[pulumi.Input['DeploymentGroupAutoRollbackConfigurationArgs']] = None,
                 autoscaling_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blue_green_deployment_config: Optional[pulumi.Input['DeploymentGroupBlueGreenDeploymentConfigArgs']] = None,
                 compute_platform: Optional[pulumi.Input[str]] = None,
                 deployment_config_name: Optional[pulumi.Input[str]] = None,
                 deployment_group_id: Optional[pulumi.Input[str]] = None,
                 deployment_group_name: Optional[pulumi.Input[str]] = None,
                 deployment_style: Optional[pulumi.Input['DeploymentGroupDeploymentStyleArgs']] = None,
                 ec2_tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentGroupEc2TagFilterArgs']]]] = None,
                 ec2_tag_sets: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentGroupEc2TagSetArgs']]]] = None,
                 ecs_service: Optional[pulumi.Input['DeploymentGroupEcsServiceArgs']] = None,
                 load_balancer_info: Optional[pulumi.Input['DeploymentGroupLoadBalancerInfoArgs']] = None,
                 on_premises_instance_tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentGroupOnPremisesInstanceTagFilterArgs']]]] = None,
                 outdated_instances_strategy: Optional[pulumi.Input[str]] = None,
                 service_role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 trigger_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentGroupTriggerConfigurationArgs']]]] = None):
        """
        Input properties used for looking up and filtering DeploymentGroup resources.
        :param pulumi.Input['DeploymentGroupAlarmConfigurationArgs'] alarm_configuration: Configuration block of alarms associated with the deployment group (documented below).
        :param pulumi.Input[str] app_name: The name of the application.
        :param pulumi.Input[str] arn: The ARN of the CodeDeploy deployment group.
        :param pulumi.Input['DeploymentGroupAutoRollbackConfigurationArgs'] auto_rollback_configuration: Configuration block of the automatic rollback configuration associated with the deployment group (documented below).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] autoscaling_groups: Autoscaling groups associated with the deployment group.
        :param pulumi.Input['DeploymentGroupBlueGreenDeploymentConfigArgs'] blue_green_deployment_config: Configuration block of the blue/green deployment options for a deployment group (documented below).
        :param pulumi.Input[str] compute_platform: The destination platform type for the deployment.
        :param pulumi.Input[str] deployment_config_name: The name of the group's deployment config. The default is "CodeDeployDefault.OneAtATime".
        :param pulumi.Input[str] deployment_group_id: The ID of the CodeDeploy deployment group.
        :param pulumi.Input[str] deployment_group_name: The name of the deployment group.
        :param pulumi.Input['DeploymentGroupDeploymentStyleArgs'] deployment_style: Configuration block of the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer (documented below).
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentGroupEc2TagFilterArgs']]] ec2_tag_filters: Tag filters associated with the deployment group. See the AWS docs for details.
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentGroupEc2TagSetArgs']]] ec2_tag_sets: Configuration block(s) of Tag filters associated with the deployment group, which are also referred to as tag groups (documented below). See the AWS docs for details.
        :param pulumi.Input['DeploymentGroupEcsServiceArgs'] ecs_service: Configuration block(s) of the ECS services for a deployment group (documented below).
        :param pulumi.Input['DeploymentGroupLoadBalancerInfoArgs'] load_balancer_info: Single configuration block of the load balancer to use in a blue/green deployment (documented below).
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentGroupOnPremisesInstanceTagFilterArgs']]] on_premises_instance_tag_filters: On premise tag filters associated with the group. See the AWS docs for details.
        :param pulumi.Input[str] outdated_instances_strategy: Configuration block of Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the deployed application revision. Valid values are `UPDATE` and `IGNORE`. Defaults to `UPDATE`.
        :param pulumi.Input[str] service_role_arn: The service role ARN that allows deployments.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentGroupTriggerConfigurationArgs']]] trigger_configurations: Configuration block(s) of the triggers for the deployment group (documented below).
        """
        if alarm_configuration is not None:
            pulumi.set(__self__, "alarm_configuration", alarm_configuration)
        if app_name is not None:
            pulumi.set(__self__, "app_name", app_name)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if auto_rollback_configuration is not None:
            pulumi.set(__self__, "auto_rollback_configuration", auto_rollback_configuration)
        if autoscaling_groups is not None:
            pulumi.set(__self__, "autoscaling_groups", autoscaling_groups)
        if blue_green_deployment_config is not None:
            pulumi.set(__self__, "blue_green_deployment_config", blue_green_deployment_config)
        if compute_platform is not None:
            pulumi.set(__self__, "compute_platform", compute_platform)
        if deployment_config_name is not None:
            pulumi.set(__self__, "deployment_config_name", deployment_config_name)
        if deployment_group_id is not None:
            pulumi.set(__self__, "deployment_group_id", deployment_group_id)
        if deployment_group_name is not None:
            pulumi.set(__self__, "deployment_group_name", deployment_group_name)
        if deployment_style is not None:
            pulumi.set(__self__, "deployment_style", deployment_style)
        if ec2_tag_filters is not None:
            pulumi.set(__self__, "ec2_tag_filters", ec2_tag_filters)
        if ec2_tag_sets is not None:
            pulumi.set(__self__, "ec2_tag_sets", ec2_tag_sets)
        if ecs_service is not None:
            pulumi.set(__self__, "ecs_service", ecs_service)
        if load_balancer_info is not None:
            pulumi.set(__self__, "load_balancer_info", load_balancer_info)
        if on_premises_instance_tag_filters is not None:
            pulumi.set(__self__, "on_premises_instance_tag_filters", on_premises_instance_tag_filters)
        if outdated_instances_strategy is not None:
            pulumi.set(__self__, "outdated_instances_strategy", outdated_instances_strategy)
        if service_role_arn is not None:
            pulumi.set(__self__, "service_role_arn", service_role_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if trigger_configurations is not None:
            pulumi.set(__self__, "trigger_configurations", trigger_configurations)

    @property
    @pulumi.getter(name="alarmConfiguration")
    def alarm_configuration(self) -> Optional[pulumi.Input['DeploymentGroupAlarmConfigurationArgs']]:
        """
        Configuration block of alarms associated with the deployment group (documented below).
        """
        return pulumi.get(self, "alarm_configuration")

    @alarm_configuration.setter
    def alarm_configuration(self, value: Optional[pulumi.Input['DeploymentGroupAlarmConfigurationArgs']]):
        pulumi.set(self, "alarm_configuration", value)

    @property
    @pulumi.getter(name="appName")
    def app_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the application.
        """
        return pulumi.get(self, "app_name")

    @app_name.setter
    def app_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_name", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the CodeDeploy deployment group.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="autoRollbackConfiguration")
    def auto_rollback_configuration(self) -> Optional[pulumi.Input['DeploymentGroupAutoRollbackConfigurationArgs']]:
        """
        Configuration block of the automatic rollback configuration associated with the deployment group (documented below).
        """
        return pulumi.get(self, "auto_rollback_configuration")

    @auto_rollback_configuration.setter
    def auto_rollback_configuration(self, value: Optional[pulumi.Input['DeploymentGroupAutoRollbackConfigurationArgs']]):
        pulumi.set(self, "auto_rollback_configuration", value)

    @property
    @pulumi.getter(name="autoscalingGroups")
    def autoscaling_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Autoscaling groups associated with the deployment group.
        """
        return pulumi.get(self, "autoscaling_groups")

    @autoscaling_groups.setter
    def autoscaling_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "autoscaling_groups", value)

    @property
    @pulumi.getter(name="blueGreenDeploymentConfig")
    def blue_green_deployment_config(self) -> Optional[pulumi.Input['DeploymentGroupBlueGreenDeploymentConfigArgs']]:
        """
        Configuration block of the blue/green deployment options for a deployment group (documented below).
        """
        return pulumi.get(self, "blue_green_deployment_config")

    @blue_green_deployment_config.setter
    def blue_green_deployment_config(self, value: Optional[pulumi.Input['DeploymentGroupBlueGreenDeploymentConfigArgs']]):
        pulumi.set(self, "blue_green_deployment_config", value)

    @property
    @pulumi.getter(name="computePlatform")
    def compute_platform(self) -> Optional[pulumi.Input[str]]:
        """
        The destination platform type for the deployment.
        """
        return pulumi.get(self, "compute_platform")

    @compute_platform.setter
    def compute_platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_platform", value)

    @property
    @pulumi.getter(name="deploymentConfigName")
    def deployment_config_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the group's deployment config. The default is "CodeDeployDefault.OneAtATime".
        """
        return pulumi.get(self, "deployment_config_name")

    @deployment_config_name.setter
    def deployment_config_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_config_name", value)

    @property
    @pulumi.getter(name="deploymentGroupId")
    def deployment_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the CodeDeploy deployment group.
        """
        return pulumi.get(self, "deployment_group_id")

    @deployment_group_id.setter
    def deployment_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_group_id", value)

    @property
    @pulumi.getter(name="deploymentGroupName")
    def deployment_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the deployment group.
        """
        return pulumi.get(self, "deployment_group_name")

    @deployment_group_name.setter
    def deployment_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_group_name", value)

    @property
    @pulumi.getter(name="deploymentStyle")
    def deployment_style(self) -> Optional[pulumi.Input['DeploymentGroupDeploymentStyleArgs']]:
        """
        Configuration block of the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer (documented below).
        """
        return pulumi.get(self, "deployment_style")

    @deployment_style.setter
    def deployment_style(self, value: Optional[pulumi.Input['DeploymentGroupDeploymentStyleArgs']]):
        pulumi.set(self, "deployment_style", value)

    @property
    @pulumi.getter(name="ec2TagFilters")
    def ec2_tag_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentGroupEc2TagFilterArgs']]]]:
        """
        Tag filters associated with the deployment group. See the AWS docs for details.
        """
        return pulumi.get(self, "ec2_tag_filters")

    @ec2_tag_filters.setter
    def ec2_tag_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentGroupEc2TagFilterArgs']]]]):
        pulumi.set(self, "ec2_tag_filters", value)

    @property
    @pulumi.getter(name="ec2TagSets")
    def ec2_tag_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentGroupEc2TagSetArgs']]]]:
        """
        Configuration block(s) of Tag filters associated with the deployment group, which are also referred to as tag groups (documented below). See the AWS docs for details.
        """
        return pulumi.get(self, "ec2_tag_sets")

    @ec2_tag_sets.setter
    def ec2_tag_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentGroupEc2TagSetArgs']]]]):
        pulumi.set(self, "ec2_tag_sets", value)

    @property
    @pulumi.getter(name="ecsService")
    def ecs_service(self) -> Optional[pulumi.Input['DeploymentGroupEcsServiceArgs']]:
        """
        Configuration block(s) of the ECS services for a deployment group (documented below).
        """
        return pulumi.get(self, "ecs_service")

    @ecs_service.setter
    def ecs_service(self, value: Optional[pulumi.Input['DeploymentGroupEcsServiceArgs']]):
        pulumi.set(self, "ecs_service", value)

    @property
    @pulumi.getter(name="loadBalancerInfo")
    def load_balancer_info(self) -> Optional[pulumi.Input['DeploymentGroupLoadBalancerInfoArgs']]:
        """
        Single configuration block of the load balancer to use in a blue/green deployment (documented below).
        """
        return pulumi.get(self, "load_balancer_info")

    @load_balancer_info.setter
    def load_balancer_info(self, value: Optional[pulumi.Input['DeploymentGroupLoadBalancerInfoArgs']]):
        pulumi.set(self, "load_balancer_info", value)

    @property
    @pulumi.getter(name="onPremisesInstanceTagFilters")
    def on_premises_instance_tag_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentGroupOnPremisesInstanceTagFilterArgs']]]]:
        """
        On premise tag filters associated with the group. See the AWS docs for details.
        """
        return pulumi.get(self, "on_premises_instance_tag_filters")

    @on_premises_instance_tag_filters.setter
    def on_premises_instance_tag_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentGroupOnPremisesInstanceTagFilterArgs']]]]):
        pulumi.set(self, "on_premises_instance_tag_filters", value)

    @property
    @pulumi.getter(name="outdatedInstancesStrategy")
    def outdated_instances_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        Configuration block of Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the deployed application revision. Valid values are `UPDATE` and `IGNORE`. Defaults to `UPDATE`.
        """
        return pulumi.get(self, "outdated_instances_strategy")

    @outdated_instances_strategy.setter
    def outdated_instances_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "outdated_instances_strategy", value)

    @property
    @pulumi.getter(name="serviceRoleArn")
    def service_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The service role ARN that allows deployments.
        """
        return pulumi.get(self, "service_role_arn")

    @service_role_arn.setter
    def service_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_role_arn", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="triggerConfigurations")
    def trigger_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentGroupTriggerConfigurationArgs']]]]:
        """
        Configuration block(s) of the triggers for the deployment group (documented below).
        """
        return pulumi.get(self, "trigger_configurations")

    @trigger_configurations.setter
    def trigger_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentGroupTriggerConfigurationArgs']]]]):
        pulumi.set(self, "trigger_configurations", value)


class DeploymentGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alarm_configuration: Optional[pulumi.Input[pulumi.InputType['DeploymentGroupAlarmConfigurationArgs']]] = None,
                 app_name: Optional[pulumi.Input[str]] = None,
                 auto_rollback_configuration: Optional[pulumi.Input[pulumi.InputType['DeploymentGroupAutoRollbackConfigurationArgs']]] = None,
                 autoscaling_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blue_green_deployment_config: Optional[pulumi.Input[pulumi.InputType['DeploymentGroupBlueGreenDeploymentConfigArgs']]] = None,
                 deployment_config_name: Optional[pulumi.Input[str]] = None,
                 deployment_group_name: Optional[pulumi.Input[str]] = None,
                 deployment_style: Optional[pulumi.Input[pulumi.InputType['DeploymentGroupDeploymentStyleArgs']]] = None,
                 ec2_tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DeploymentGroupEc2TagFilterArgs']]]]] = None,
                 ec2_tag_sets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DeploymentGroupEc2TagSetArgs']]]]] = None,
                 ecs_service: Optional[pulumi.Input[pulumi.InputType['DeploymentGroupEcsServiceArgs']]] = None,
                 load_balancer_info: Optional[pulumi.Input[pulumi.InputType['DeploymentGroupLoadBalancerInfoArgs']]] = None,
                 on_premises_instance_tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DeploymentGroupOnPremisesInstanceTagFilterArgs']]]]] = None,
                 outdated_instances_strategy: Optional[pulumi.Input[str]] = None,
                 service_role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 trigger_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DeploymentGroupTriggerConfigurationArgs']]]]] = None,
                 __props__=None):
        """
        Provides a CodeDeploy Deployment Group for a CodeDeploy Application

        > **NOTE on blue/green deployments:** When using `green_fleet_provisioning_option` with the `COPY_AUTO_SCALING_GROUP` action, CodeDeploy will create a new ASG with a different name. This ASG is _not_ managed by this provider and will conflict with existing configuration and state. You may want to use a different approach to managing deployments that involve multiple ASG, such as `DISCOVER_EXISTING` with separate blue and green ASG.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        assume_role = aws.iam.get_policy_document(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            effect="Allow",
            principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                type="Service",
                identifiers=["codedeploy.amazonaws.com"],
            )],
            actions=["sts:AssumeRole"],
        )])
        example = aws.iam.Role("example",
            name="example-role",
            assume_role_policy=assume_role.json)
        a_ws_code_deploy_role = aws.iam.RolePolicyAttachment("AWSCodeDeployRole",
            policy_arn="arn:aws:iam::aws:policy/service-role/AWSCodeDeployRole",
            role=example.name)
        example_application = aws.codedeploy.Application("example", name="example-app")
        example_topic = aws.sns.Topic("example", name="example-topic")
        example_deployment_group = aws.codedeploy.DeploymentGroup("example",
            app_name=example_application.name,
            deployment_group_name="example-group",
            service_role_arn=example.arn,
            ec2_tag_sets=[aws.codedeploy.DeploymentGroupEc2TagSetArgs(
                ec2_tag_filters=[
                    aws.codedeploy.DeploymentGroupEc2TagSetEc2TagFilterArgs(
                        key="filterkey1",
                        type="KEY_AND_VALUE",
                        value="filtervalue",
                    ),
                    aws.codedeploy.DeploymentGroupEc2TagSetEc2TagFilterArgs(
                        key="filterkey2",
                        type="KEY_AND_VALUE",
                        value="filtervalue",
                    ),
                ],
            )],
            trigger_configurations=[aws.codedeploy.DeploymentGroupTriggerConfigurationArgs(
                trigger_events=["DeploymentFailure"],
                trigger_name="example-trigger",
                trigger_target_arn=example_topic.arn,
            )],
            auto_rollback_configuration=aws.codedeploy.DeploymentGroupAutoRollbackConfigurationArgs(
                enabled=True,
                events=["DEPLOYMENT_FAILURE"],
            ),
            alarm_configuration=aws.codedeploy.DeploymentGroupAlarmConfigurationArgs(
                alarms=["my-alarm-name"],
                enabled=True,
            ),
            outdated_instances_strategy="UPDATE")
        ```
        <!--End PulumiCodeChooser -->

        ### Blue Green Deployments with ECS

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.codedeploy.Application("example",
            compute_platform="ECS",
            name="example")
        example_deployment_group = aws.codedeploy.DeploymentGroup("example",
            app_name=example.name,
            deployment_config_name="CodeDeployDefault.ECSAllAtOnce",
            deployment_group_name="example",
            service_role_arn=example_aws_iam_role["arn"],
            auto_rollback_configuration=aws.codedeploy.DeploymentGroupAutoRollbackConfigurationArgs(
                enabled=True,
                events=["DEPLOYMENT_FAILURE"],
            ),
            blue_green_deployment_config=aws.codedeploy.DeploymentGroupBlueGreenDeploymentConfigArgs(
                deployment_ready_option=aws.codedeploy.DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs(
                    action_on_timeout="CONTINUE_DEPLOYMENT",
                ),
                terminate_blue_instances_on_deployment_success=aws.codedeploy.DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs(
                    action="TERMINATE",
                    termination_wait_time_in_minutes=5,
                ),
            ),
            deployment_style=aws.codedeploy.DeploymentGroupDeploymentStyleArgs(
                deployment_option="WITH_TRAFFIC_CONTROL",
                deployment_type="BLUE_GREEN",
            ),
            ecs_service=aws.codedeploy.DeploymentGroupEcsServiceArgs(
                cluster_name=example_aws_ecs_cluster["name"],
                service_name=example_aws_ecs_service["name"],
            ),
            load_balancer_info=aws.codedeploy.DeploymentGroupLoadBalancerInfoArgs(
                target_group_pair_info=aws.codedeploy.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoArgs(
                    prod_traffic_route=aws.codedeploy.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoProdTrafficRouteArgs(
                        listener_arns=[example_aws_lb_listener["arn"]],
                    ),
                    target_groups=[
                        aws.codedeploy.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs(
                            name=blue["name"],
                        ),
                        aws.codedeploy.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs(
                            name=green["name"],
                        ),
                    ],
                ),
            ))
        ```
        <!--End PulumiCodeChooser -->

        ### Blue Green Deployments with Servers and Classic ELB

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.codedeploy.Application("example", name="example-app")
        example_deployment_group = aws.codedeploy.DeploymentGroup("example",
            app_name=example.name,
            deployment_group_name="example-group",
            service_role_arn=example_aws_iam_role["arn"],
            deployment_style=aws.codedeploy.DeploymentGroupDeploymentStyleArgs(
                deployment_option="WITH_TRAFFIC_CONTROL",
                deployment_type="BLUE_GREEN",
            ),
            load_balancer_info=aws.codedeploy.DeploymentGroupLoadBalancerInfoArgs(
                elb_infos=[aws.codedeploy.DeploymentGroupLoadBalancerInfoElbInfoArgs(
                    name=example_aws_elb["name"],
                )],
            ),
            blue_green_deployment_config=aws.codedeploy.DeploymentGroupBlueGreenDeploymentConfigArgs(
                deployment_ready_option=aws.codedeploy.DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs(
                    action_on_timeout="STOP_DEPLOYMENT",
                    wait_time_in_minutes=60,
                ),
                green_fleet_provisioning_option=aws.codedeploy.DeploymentGroupBlueGreenDeploymentConfigGreenFleetProvisioningOptionArgs(
                    action="DISCOVER_EXISTING",
                ),
                terminate_blue_instances_on_deployment_success=aws.codedeploy.DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs(
                    action="KEEP_ALIVE",
                ),
            ))
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import CodeDeploy Deployment Groups using `app_name`, a colon, and `deployment_group_name`. For example:

        ```sh
        $ pulumi import aws:codedeploy/deploymentGroup:DeploymentGroup example my-application:my-deployment-group
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['DeploymentGroupAlarmConfigurationArgs']] alarm_configuration: Configuration block of alarms associated with the deployment group (documented below).
        :param pulumi.Input[str] app_name: The name of the application.
        :param pulumi.Input[pulumi.InputType['DeploymentGroupAutoRollbackConfigurationArgs']] auto_rollback_configuration: Configuration block of the automatic rollback configuration associated with the deployment group (documented below).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] autoscaling_groups: Autoscaling groups associated with the deployment group.
        :param pulumi.Input[pulumi.InputType['DeploymentGroupBlueGreenDeploymentConfigArgs']] blue_green_deployment_config: Configuration block of the blue/green deployment options for a deployment group (documented below).
        :param pulumi.Input[str] deployment_config_name: The name of the group's deployment config. The default is "CodeDeployDefault.OneAtATime".
        :param pulumi.Input[str] deployment_group_name: The name of the deployment group.
        :param pulumi.Input[pulumi.InputType['DeploymentGroupDeploymentStyleArgs']] deployment_style: Configuration block of the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer (documented below).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DeploymentGroupEc2TagFilterArgs']]]] ec2_tag_filters: Tag filters associated with the deployment group. See the AWS docs for details.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DeploymentGroupEc2TagSetArgs']]]] ec2_tag_sets: Configuration block(s) of Tag filters associated with the deployment group, which are also referred to as tag groups (documented below). See the AWS docs for details.
        :param pulumi.Input[pulumi.InputType['DeploymentGroupEcsServiceArgs']] ecs_service: Configuration block(s) of the ECS services for a deployment group (documented below).
        :param pulumi.Input[pulumi.InputType['DeploymentGroupLoadBalancerInfoArgs']] load_balancer_info: Single configuration block of the load balancer to use in a blue/green deployment (documented below).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DeploymentGroupOnPremisesInstanceTagFilterArgs']]]] on_premises_instance_tag_filters: On premise tag filters associated with the group. See the AWS docs for details.
        :param pulumi.Input[str] outdated_instances_strategy: Configuration block of Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the deployed application revision. Valid values are `UPDATE` and `IGNORE`. Defaults to `UPDATE`.
        :param pulumi.Input[str] service_role_arn: The service role ARN that allows deployments.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DeploymentGroupTriggerConfigurationArgs']]]] trigger_configurations: Configuration block(s) of the triggers for the deployment group (documented below).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeploymentGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a CodeDeploy Deployment Group for a CodeDeploy Application

        > **NOTE on blue/green deployments:** When using `green_fleet_provisioning_option` with the `COPY_AUTO_SCALING_GROUP` action, CodeDeploy will create a new ASG with a different name. This ASG is _not_ managed by this provider and will conflict with existing configuration and state. You may want to use a different approach to managing deployments that involve multiple ASG, such as `DISCOVER_EXISTING` with separate blue and green ASG.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        assume_role = aws.iam.get_policy_document(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            effect="Allow",
            principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                type="Service",
                identifiers=["codedeploy.amazonaws.com"],
            )],
            actions=["sts:AssumeRole"],
        )])
        example = aws.iam.Role("example",
            name="example-role",
            assume_role_policy=assume_role.json)
        a_ws_code_deploy_role = aws.iam.RolePolicyAttachment("AWSCodeDeployRole",
            policy_arn="arn:aws:iam::aws:policy/service-role/AWSCodeDeployRole",
            role=example.name)
        example_application = aws.codedeploy.Application("example", name="example-app")
        example_topic = aws.sns.Topic("example", name="example-topic")
        example_deployment_group = aws.codedeploy.DeploymentGroup("example",
            app_name=example_application.name,
            deployment_group_name="example-group",
            service_role_arn=example.arn,
            ec2_tag_sets=[aws.codedeploy.DeploymentGroupEc2TagSetArgs(
                ec2_tag_filters=[
                    aws.codedeploy.DeploymentGroupEc2TagSetEc2TagFilterArgs(
                        key="filterkey1",
                        type="KEY_AND_VALUE",
                        value="filtervalue",
                    ),
                    aws.codedeploy.DeploymentGroupEc2TagSetEc2TagFilterArgs(
                        key="filterkey2",
                        type="KEY_AND_VALUE",
                        value="filtervalue",
                    ),
                ],
            )],
            trigger_configurations=[aws.codedeploy.DeploymentGroupTriggerConfigurationArgs(
                trigger_events=["DeploymentFailure"],
                trigger_name="example-trigger",
                trigger_target_arn=example_topic.arn,
            )],
            auto_rollback_configuration=aws.codedeploy.DeploymentGroupAutoRollbackConfigurationArgs(
                enabled=True,
                events=["DEPLOYMENT_FAILURE"],
            ),
            alarm_configuration=aws.codedeploy.DeploymentGroupAlarmConfigurationArgs(
                alarms=["my-alarm-name"],
                enabled=True,
            ),
            outdated_instances_strategy="UPDATE")
        ```
        <!--End PulumiCodeChooser -->

        ### Blue Green Deployments with ECS

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.codedeploy.Application("example",
            compute_platform="ECS",
            name="example")
        example_deployment_group = aws.codedeploy.DeploymentGroup("example",
            app_name=example.name,
            deployment_config_name="CodeDeployDefault.ECSAllAtOnce",
            deployment_group_name="example",
            service_role_arn=example_aws_iam_role["arn"],
            auto_rollback_configuration=aws.codedeploy.DeploymentGroupAutoRollbackConfigurationArgs(
                enabled=True,
                events=["DEPLOYMENT_FAILURE"],
            ),
            blue_green_deployment_config=aws.codedeploy.DeploymentGroupBlueGreenDeploymentConfigArgs(
                deployment_ready_option=aws.codedeploy.DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs(
                    action_on_timeout="CONTINUE_DEPLOYMENT",
                ),
                terminate_blue_instances_on_deployment_success=aws.codedeploy.DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs(
                    action="TERMINATE",
                    termination_wait_time_in_minutes=5,
                ),
            ),
            deployment_style=aws.codedeploy.DeploymentGroupDeploymentStyleArgs(
                deployment_option="WITH_TRAFFIC_CONTROL",
                deployment_type="BLUE_GREEN",
            ),
            ecs_service=aws.codedeploy.DeploymentGroupEcsServiceArgs(
                cluster_name=example_aws_ecs_cluster["name"],
                service_name=example_aws_ecs_service["name"],
            ),
            load_balancer_info=aws.codedeploy.DeploymentGroupLoadBalancerInfoArgs(
                target_group_pair_info=aws.codedeploy.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoArgs(
                    prod_traffic_route=aws.codedeploy.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoProdTrafficRouteArgs(
                        listener_arns=[example_aws_lb_listener["arn"]],
                    ),
                    target_groups=[
                        aws.codedeploy.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs(
                            name=blue["name"],
                        ),
                        aws.codedeploy.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroupArgs(
                            name=green["name"],
                        ),
                    ],
                ),
            ))
        ```
        <!--End PulumiCodeChooser -->

        ### Blue Green Deployments with Servers and Classic ELB

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.codedeploy.Application("example", name="example-app")
        example_deployment_group = aws.codedeploy.DeploymentGroup("example",
            app_name=example.name,
            deployment_group_name="example-group",
            service_role_arn=example_aws_iam_role["arn"],
            deployment_style=aws.codedeploy.DeploymentGroupDeploymentStyleArgs(
                deployment_option="WITH_TRAFFIC_CONTROL",
                deployment_type="BLUE_GREEN",
            ),
            load_balancer_info=aws.codedeploy.DeploymentGroupLoadBalancerInfoArgs(
                elb_infos=[aws.codedeploy.DeploymentGroupLoadBalancerInfoElbInfoArgs(
                    name=example_aws_elb["name"],
                )],
            ),
            blue_green_deployment_config=aws.codedeploy.DeploymentGroupBlueGreenDeploymentConfigArgs(
                deployment_ready_option=aws.codedeploy.DeploymentGroupBlueGreenDeploymentConfigDeploymentReadyOptionArgs(
                    action_on_timeout="STOP_DEPLOYMENT",
                    wait_time_in_minutes=60,
                ),
                green_fleet_provisioning_option=aws.codedeploy.DeploymentGroupBlueGreenDeploymentConfigGreenFleetProvisioningOptionArgs(
                    action="DISCOVER_EXISTING",
                ),
                terminate_blue_instances_on_deployment_success=aws.codedeploy.DeploymentGroupBlueGreenDeploymentConfigTerminateBlueInstancesOnDeploymentSuccessArgs(
                    action="KEEP_ALIVE",
                ),
            ))
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import CodeDeploy Deployment Groups using `app_name`, a colon, and `deployment_group_name`. For example:

        ```sh
        $ pulumi import aws:codedeploy/deploymentGroup:DeploymentGroup example my-application:my-deployment-group
        ```

        :param str resource_name: The name of the resource.
        :param DeploymentGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeploymentGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alarm_configuration: Optional[pulumi.Input[pulumi.InputType['DeploymentGroupAlarmConfigurationArgs']]] = None,
                 app_name: Optional[pulumi.Input[str]] = None,
                 auto_rollback_configuration: Optional[pulumi.Input[pulumi.InputType['DeploymentGroupAutoRollbackConfigurationArgs']]] = None,
                 autoscaling_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 blue_green_deployment_config: Optional[pulumi.Input[pulumi.InputType['DeploymentGroupBlueGreenDeploymentConfigArgs']]] = None,
                 deployment_config_name: Optional[pulumi.Input[str]] = None,
                 deployment_group_name: Optional[pulumi.Input[str]] = None,
                 deployment_style: Optional[pulumi.Input[pulumi.InputType['DeploymentGroupDeploymentStyleArgs']]] = None,
                 ec2_tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DeploymentGroupEc2TagFilterArgs']]]]] = None,
                 ec2_tag_sets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DeploymentGroupEc2TagSetArgs']]]]] = None,
                 ecs_service: Optional[pulumi.Input[pulumi.InputType['DeploymentGroupEcsServiceArgs']]] = None,
                 load_balancer_info: Optional[pulumi.Input[pulumi.InputType['DeploymentGroupLoadBalancerInfoArgs']]] = None,
                 on_premises_instance_tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DeploymentGroupOnPremisesInstanceTagFilterArgs']]]]] = None,
                 outdated_instances_strategy: Optional[pulumi.Input[str]] = None,
                 service_role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 trigger_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DeploymentGroupTriggerConfigurationArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeploymentGroupArgs.__new__(DeploymentGroupArgs)

            __props__.__dict__["alarm_configuration"] = alarm_configuration
            if app_name is None and not opts.urn:
                raise TypeError("Missing required property 'app_name'")
            __props__.__dict__["app_name"] = app_name
            __props__.__dict__["auto_rollback_configuration"] = auto_rollback_configuration
            __props__.__dict__["autoscaling_groups"] = autoscaling_groups
            __props__.__dict__["blue_green_deployment_config"] = blue_green_deployment_config
            __props__.__dict__["deployment_config_name"] = deployment_config_name
            if deployment_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'deployment_group_name'")
            __props__.__dict__["deployment_group_name"] = deployment_group_name
            __props__.__dict__["deployment_style"] = deployment_style
            __props__.__dict__["ec2_tag_filters"] = ec2_tag_filters
            __props__.__dict__["ec2_tag_sets"] = ec2_tag_sets
            __props__.__dict__["ecs_service"] = ecs_service
            __props__.__dict__["load_balancer_info"] = load_balancer_info
            __props__.__dict__["on_premises_instance_tag_filters"] = on_premises_instance_tag_filters
            __props__.__dict__["outdated_instances_strategy"] = outdated_instances_strategy
            if service_role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'service_role_arn'")
            __props__.__dict__["service_role_arn"] = service_role_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["trigger_configurations"] = trigger_configurations
            __props__.__dict__["arn"] = None
            __props__.__dict__["compute_platform"] = None
            __props__.__dict__["deployment_group_id"] = None
            __props__.__dict__["tags_all"] = None
        super(DeploymentGroup, __self__).__init__(
            'aws:codedeploy/deploymentGroup:DeploymentGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alarm_configuration: Optional[pulumi.Input[pulumi.InputType['DeploymentGroupAlarmConfigurationArgs']]] = None,
            app_name: Optional[pulumi.Input[str]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            auto_rollback_configuration: Optional[pulumi.Input[pulumi.InputType['DeploymentGroupAutoRollbackConfigurationArgs']]] = None,
            autoscaling_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            blue_green_deployment_config: Optional[pulumi.Input[pulumi.InputType['DeploymentGroupBlueGreenDeploymentConfigArgs']]] = None,
            compute_platform: Optional[pulumi.Input[str]] = None,
            deployment_config_name: Optional[pulumi.Input[str]] = None,
            deployment_group_id: Optional[pulumi.Input[str]] = None,
            deployment_group_name: Optional[pulumi.Input[str]] = None,
            deployment_style: Optional[pulumi.Input[pulumi.InputType['DeploymentGroupDeploymentStyleArgs']]] = None,
            ec2_tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DeploymentGroupEc2TagFilterArgs']]]]] = None,
            ec2_tag_sets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DeploymentGroupEc2TagSetArgs']]]]] = None,
            ecs_service: Optional[pulumi.Input[pulumi.InputType['DeploymentGroupEcsServiceArgs']]] = None,
            load_balancer_info: Optional[pulumi.Input[pulumi.InputType['DeploymentGroupLoadBalancerInfoArgs']]] = None,
            on_premises_instance_tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DeploymentGroupOnPremisesInstanceTagFilterArgs']]]]] = None,
            outdated_instances_strategy: Optional[pulumi.Input[str]] = None,
            service_role_arn: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            trigger_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DeploymentGroupTriggerConfigurationArgs']]]]] = None) -> 'DeploymentGroup':
        """
        Get an existing DeploymentGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['DeploymentGroupAlarmConfigurationArgs']] alarm_configuration: Configuration block of alarms associated with the deployment group (documented below).
        :param pulumi.Input[str] app_name: The name of the application.
        :param pulumi.Input[str] arn: The ARN of the CodeDeploy deployment group.
        :param pulumi.Input[pulumi.InputType['DeploymentGroupAutoRollbackConfigurationArgs']] auto_rollback_configuration: Configuration block of the automatic rollback configuration associated with the deployment group (documented below).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] autoscaling_groups: Autoscaling groups associated with the deployment group.
        :param pulumi.Input[pulumi.InputType['DeploymentGroupBlueGreenDeploymentConfigArgs']] blue_green_deployment_config: Configuration block of the blue/green deployment options for a deployment group (documented below).
        :param pulumi.Input[str] compute_platform: The destination platform type for the deployment.
        :param pulumi.Input[str] deployment_config_name: The name of the group's deployment config. The default is "CodeDeployDefault.OneAtATime".
        :param pulumi.Input[str] deployment_group_id: The ID of the CodeDeploy deployment group.
        :param pulumi.Input[str] deployment_group_name: The name of the deployment group.
        :param pulumi.Input[pulumi.InputType['DeploymentGroupDeploymentStyleArgs']] deployment_style: Configuration block of the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer (documented below).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DeploymentGroupEc2TagFilterArgs']]]] ec2_tag_filters: Tag filters associated with the deployment group. See the AWS docs for details.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DeploymentGroupEc2TagSetArgs']]]] ec2_tag_sets: Configuration block(s) of Tag filters associated with the deployment group, which are also referred to as tag groups (documented below). See the AWS docs for details.
        :param pulumi.Input[pulumi.InputType['DeploymentGroupEcsServiceArgs']] ecs_service: Configuration block(s) of the ECS services for a deployment group (documented below).
        :param pulumi.Input[pulumi.InputType['DeploymentGroupLoadBalancerInfoArgs']] load_balancer_info: Single configuration block of the load balancer to use in a blue/green deployment (documented below).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DeploymentGroupOnPremisesInstanceTagFilterArgs']]]] on_premises_instance_tag_filters: On premise tag filters associated with the group. See the AWS docs for details.
        :param pulumi.Input[str] outdated_instances_strategy: Configuration block of Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the deployed application revision. Valid values are `UPDATE` and `IGNORE`. Defaults to `UPDATE`.
        :param pulumi.Input[str] service_role_arn: The service role ARN that allows deployments.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DeploymentGroupTriggerConfigurationArgs']]]] trigger_configurations: Configuration block(s) of the triggers for the deployment group (documented below).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DeploymentGroupState.__new__(_DeploymentGroupState)

        __props__.__dict__["alarm_configuration"] = alarm_configuration
        __props__.__dict__["app_name"] = app_name
        __props__.__dict__["arn"] = arn
        __props__.__dict__["auto_rollback_configuration"] = auto_rollback_configuration
        __props__.__dict__["autoscaling_groups"] = autoscaling_groups
        __props__.__dict__["blue_green_deployment_config"] = blue_green_deployment_config
        __props__.__dict__["compute_platform"] = compute_platform
        __props__.__dict__["deployment_config_name"] = deployment_config_name
        __props__.__dict__["deployment_group_id"] = deployment_group_id
        __props__.__dict__["deployment_group_name"] = deployment_group_name
        __props__.__dict__["deployment_style"] = deployment_style
        __props__.__dict__["ec2_tag_filters"] = ec2_tag_filters
        __props__.__dict__["ec2_tag_sets"] = ec2_tag_sets
        __props__.__dict__["ecs_service"] = ecs_service
        __props__.__dict__["load_balancer_info"] = load_balancer_info
        __props__.__dict__["on_premises_instance_tag_filters"] = on_premises_instance_tag_filters
        __props__.__dict__["outdated_instances_strategy"] = outdated_instances_strategy
        __props__.__dict__["service_role_arn"] = service_role_arn
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["trigger_configurations"] = trigger_configurations
        return DeploymentGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alarmConfiguration")
    def alarm_configuration(self) -> pulumi.Output[Optional['outputs.DeploymentGroupAlarmConfiguration']]:
        """
        Configuration block of alarms associated with the deployment group (documented below).
        """
        return pulumi.get(self, "alarm_configuration")

    @property
    @pulumi.getter(name="appName")
    def app_name(self) -> pulumi.Output[str]:
        """
        The name of the application.
        """
        return pulumi.get(self, "app_name")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the CodeDeploy deployment group.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoRollbackConfiguration")
    def auto_rollback_configuration(self) -> pulumi.Output[Optional['outputs.DeploymentGroupAutoRollbackConfiguration']]:
        """
        Configuration block of the automatic rollback configuration associated with the deployment group (documented below).
        """
        return pulumi.get(self, "auto_rollback_configuration")

    @property
    @pulumi.getter(name="autoscalingGroups")
    def autoscaling_groups(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Autoscaling groups associated with the deployment group.
        """
        return pulumi.get(self, "autoscaling_groups")

    @property
    @pulumi.getter(name="blueGreenDeploymentConfig")
    def blue_green_deployment_config(self) -> pulumi.Output['outputs.DeploymentGroupBlueGreenDeploymentConfig']:
        """
        Configuration block of the blue/green deployment options for a deployment group (documented below).
        """
        return pulumi.get(self, "blue_green_deployment_config")

    @property
    @pulumi.getter(name="computePlatform")
    def compute_platform(self) -> pulumi.Output[str]:
        """
        The destination platform type for the deployment.
        """
        return pulumi.get(self, "compute_platform")

    @property
    @pulumi.getter(name="deploymentConfigName")
    def deployment_config_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the group's deployment config. The default is "CodeDeployDefault.OneAtATime".
        """
        return pulumi.get(self, "deployment_config_name")

    @property
    @pulumi.getter(name="deploymentGroupId")
    def deployment_group_id(self) -> pulumi.Output[str]:
        """
        The ID of the CodeDeploy deployment group.
        """
        return pulumi.get(self, "deployment_group_id")

    @property
    @pulumi.getter(name="deploymentGroupName")
    def deployment_group_name(self) -> pulumi.Output[str]:
        """
        The name of the deployment group.
        """
        return pulumi.get(self, "deployment_group_name")

    @property
    @pulumi.getter(name="deploymentStyle")
    def deployment_style(self) -> pulumi.Output[Optional['outputs.DeploymentGroupDeploymentStyle']]:
        """
        Configuration block of the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer (documented below).
        """
        return pulumi.get(self, "deployment_style")

    @property
    @pulumi.getter(name="ec2TagFilters")
    def ec2_tag_filters(self) -> pulumi.Output[Optional[Sequence['outputs.DeploymentGroupEc2TagFilter']]]:
        """
        Tag filters associated with the deployment group. See the AWS docs for details.
        """
        return pulumi.get(self, "ec2_tag_filters")

    @property
    @pulumi.getter(name="ec2TagSets")
    def ec2_tag_sets(self) -> pulumi.Output[Optional[Sequence['outputs.DeploymentGroupEc2TagSet']]]:
        """
        Configuration block(s) of Tag filters associated with the deployment group, which are also referred to as tag groups (documented below). See the AWS docs for details.
        """
        return pulumi.get(self, "ec2_tag_sets")

    @property
    @pulumi.getter(name="ecsService")
    def ecs_service(self) -> pulumi.Output[Optional['outputs.DeploymentGroupEcsService']]:
        """
        Configuration block(s) of the ECS services for a deployment group (documented below).
        """
        return pulumi.get(self, "ecs_service")

    @property
    @pulumi.getter(name="loadBalancerInfo")
    def load_balancer_info(self) -> pulumi.Output[Optional['outputs.DeploymentGroupLoadBalancerInfo']]:
        """
        Single configuration block of the load balancer to use in a blue/green deployment (documented below).
        """
        return pulumi.get(self, "load_balancer_info")

    @property
    @pulumi.getter(name="onPremisesInstanceTagFilters")
    def on_premises_instance_tag_filters(self) -> pulumi.Output[Optional[Sequence['outputs.DeploymentGroupOnPremisesInstanceTagFilter']]]:
        """
        On premise tag filters associated with the group. See the AWS docs for details.
        """
        return pulumi.get(self, "on_premises_instance_tag_filters")

    @property
    @pulumi.getter(name="outdatedInstancesStrategy")
    def outdated_instances_strategy(self) -> pulumi.Output[Optional[str]]:
        """
        Configuration block of Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the deployed application revision. Valid values are `UPDATE` and `IGNORE`. Defaults to `UPDATE`.
        """
        return pulumi.get(self, "outdated_instances_strategy")

    @property
    @pulumi.getter(name="serviceRoleArn")
    def service_role_arn(self) -> pulumi.Output[str]:
        """
        The service role ARN that allows deployments.
        """
        return pulumi.get(self, "service_role_arn")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="triggerConfigurations")
    def trigger_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.DeploymentGroupTriggerConfiguration']]]:
        """
        Configuration block(s) of the triggers for the deployment group (documented below).
        """
        return pulumi.get(self, "trigger_configurations")

