# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'CustomActionTypeConfigurationPropertyArgs',
    'CustomActionTypeInputArtifactDetailsArgs',
    'CustomActionTypeOutputArtifactDetailsArgs',
    'CustomActionTypeSettingsArgs',
    'PipelineArtifactStoreArgs',
    'PipelineArtifactStoreEncryptionKeyArgs',
    'PipelineStageArgs',
    'PipelineStageActionArgs',
    'PipelineTriggerArgs',
    'PipelineTriggerGitConfigurationArgs',
    'PipelineTriggerGitConfigurationPullRequestArgs',
    'PipelineTriggerGitConfigurationPullRequestBranchesArgs',
    'PipelineTriggerGitConfigurationPullRequestFilePathsArgs',
    'PipelineTriggerGitConfigurationPushArgs',
    'PipelineTriggerGitConfigurationPushBranchesArgs',
    'PipelineTriggerGitConfigurationPushFilePathsArgs',
    'PipelineTriggerGitConfigurationPushTagsArgs',
    'PipelineVariableArgs',
    'WebhookAuthenticationConfigurationArgs',
    'WebhookFilterArgs',
]

@pulumi.input_type
class CustomActionTypeConfigurationPropertyArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[bool],
                 name: pulumi.Input[str],
                 required: pulumi.Input[bool],
                 secret: pulumi.Input[bool],
                 description: Optional[pulumi.Input[str]] = None,
                 queryable: Optional[pulumi.Input[bool]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] key: Whether the configuration property is a key.
        :param pulumi.Input[str] name: The name of the action configuration property.
        :param pulumi.Input[bool] required: Whether the configuration property is a required value.
        :param pulumi.Input[bool] secret: Whether the configuration property is secret.
        :param pulumi.Input[str] description: The description of the action configuration property.
        :param pulumi.Input[bool] queryable: Indicates that the property will be used in conjunction with PollForJobs.
        :param pulumi.Input[str] type: The type of the configuration property. Valid values: `String`, `Number`, `Boolean`
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "required", required)
        pulumi.set(__self__, "secret", secret)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if queryable is not None:
            pulumi.set(__self__, "queryable", queryable)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[bool]:
        """
        Whether the configuration property is a key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[bool]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the action configuration property.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def required(self) -> pulumi.Input[bool]:
        """
        Whether the configuration property is a required value.
        """
        return pulumi.get(self, "required")

    @required.setter
    def required(self, value: pulumi.Input[bool]):
        pulumi.set(self, "required", value)

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Input[bool]:
        """
        Whether the configuration property is secret.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: pulumi.Input[bool]):
        pulumi.set(self, "secret", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the action configuration property.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def queryable(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates that the property will be used in conjunction with PollForJobs.
        """
        return pulumi.get(self, "queryable")

    @queryable.setter
    def queryable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "queryable", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the configuration property. Valid values: `String`, `Number`, `Boolean`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class CustomActionTypeInputArtifactDetailsArgs:
    def __init__(__self__, *,
                 maximum_count: pulumi.Input[int],
                 minimum_count: pulumi.Input[int]):
        """
        :param pulumi.Input[int] maximum_count: The maximum number of artifacts allowed for the action type. Min: 0, Max: 5
        :param pulumi.Input[int] minimum_count: The minimum number of artifacts allowed for the action type. Min: 0, Max: 5
        """
        pulumi.set(__self__, "maximum_count", maximum_count)
        pulumi.set(__self__, "minimum_count", minimum_count)

    @property
    @pulumi.getter(name="maximumCount")
    def maximum_count(self) -> pulumi.Input[int]:
        """
        The maximum number of artifacts allowed for the action type. Min: 0, Max: 5
        """
        return pulumi.get(self, "maximum_count")

    @maximum_count.setter
    def maximum_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "maximum_count", value)

    @property
    @pulumi.getter(name="minimumCount")
    def minimum_count(self) -> pulumi.Input[int]:
        """
        The minimum number of artifacts allowed for the action type. Min: 0, Max: 5
        """
        return pulumi.get(self, "minimum_count")

    @minimum_count.setter
    def minimum_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "minimum_count", value)


@pulumi.input_type
class CustomActionTypeOutputArtifactDetailsArgs:
    def __init__(__self__, *,
                 maximum_count: pulumi.Input[int],
                 minimum_count: pulumi.Input[int]):
        """
        :param pulumi.Input[int] maximum_count: The maximum number of artifacts allowed for the action type. Min: 0, Max: 5
        :param pulumi.Input[int] minimum_count: The minimum number of artifacts allowed for the action type. Min: 0, Max: 5
        """
        pulumi.set(__self__, "maximum_count", maximum_count)
        pulumi.set(__self__, "minimum_count", minimum_count)

    @property
    @pulumi.getter(name="maximumCount")
    def maximum_count(self) -> pulumi.Input[int]:
        """
        The maximum number of artifacts allowed for the action type. Min: 0, Max: 5
        """
        return pulumi.get(self, "maximum_count")

    @maximum_count.setter
    def maximum_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "maximum_count", value)

    @property
    @pulumi.getter(name="minimumCount")
    def minimum_count(self) -> pulumi.Input[int]:
        """
        The minimum number of artifacts allowed for the action type. Min: 0, Max: 5
        """
        return pulumi.get(self, "minimum_count")

    @minimum_count.setter
    def minimum_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "minimum_count", value)


@pulumi.input_type
class CustomActionTypeSettingsArgs:
    def __init__(__self__, *,
                 entity_url_template: Optional[pulumi.Input[str]] = None,
                 execution_url_template: Optional[pulumi.Input[str]] = None,
                 revision_url_template: Optional[pulumi.Input[str]] = None,
                 third_party_configuration_url: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] entity_url_template: The URL returned to the AWS CodePipeline console that provides a deep link to the resources of the external system.
        :param pulumi.Input[str] execution_url_template: The URL returned to the AWS CodePipeline console that contains a link to the top-level landing page for the external system.
        :param pulumi.Input[str] revision_url_template: The URL returned to the AWS CodePipeline console that contains a link to the page where customers can update or change the configuration of the external action.
        :param pulumi.Input[str] third_party_configuration_url: The URL of a sign-up page where users can sign up for an external service and perform initial configuration of the action provided by that service.
        """
        if entity_url_template is not None:
            pulumi.set(__self__, "entity_url_template", entity_url_template)
        if execution_url_template is not None:
            pulumi.set(__self__, "execution_url_template", execution_url_template)
        if revision_url_template is not None:
            pulumi.set(__self__, "revision_url_template", revision_url_template)
        if third_party_configuration_url is not None:
            pulumi.set(__self__, "third_party_configuration_url", third_party_configuration_url)

    @property
    @pulumi.getter(name="entityUrlTemplate")
    def entity_url_template(self) -> Optional[pulumi.Input[str]]:
        """
        The URL returned to the AWS CodePipeline console that provides a deep link to the resources of the external system.
        """
        return pulumi.get(self, "entity_url_template")

    @entity_url_template.setter
    def entity_url_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity_url_template", value)

    @property
    @pulumi.getter(name="executionUrlTemplate")
    def execution_url_template(self) -> Optional[pulumi.Input[str]]:
        """
        The URL returned to the AWS CodePipeline console that contains a link to the top-level landing page for the external system.
        """
        return pulumi.get(self, "execution_url_template")

    @execution_url_template.setter
    def execution_url_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "execution_url_template", value)

    @property
    @pulumi.getter(name="revisionUrlTemplate")
    def revision_url_template(self) -> Optional[pulumi.Input[str]]:
        """
        The URL returned to the AWS CodePipeline console that contains a link to the page where customers can update or change the configuration of the external action.
        """
        return pulumi.get(self, "revision_url_template")

    @revision_url_template.setter
    def revision_url_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision_url_template", value)

    @property
    @pulumi.getter(name="thirdPartyConfigurationUrl")
    def third_party_configuration_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of a sign-up page where users can sign up for an external service and perform initial configuration of the action provided by that service.
        """
        return pulumi.get(self, "third_party_configuration_url")

    @third_party_configuration_url.setter
    def third_party_configuration_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "third_party_configuration_url", value)


@pulumi.input_type
class PipelineArtifactStoreArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 type: pulumi.Input[str],
                 encryption_key: Optional[pulumi.Input['PipelineArtifactStoreEncryptionKeyArgs']] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] location: The location where AWS CodePipeline stores artifacts for a pipeline; currently only `S3` is supported.
        :param pulumi.Input[str] type: The type of the artifact store, such as Amazon S3
        :param pulumi.Input['PipelineArtifactStoreEncryptionKeyArgs'] encryption_key: The encryption key block AWS CodePipeline uses to encrypt the data in the artifact store, such as an AWS Key Management Service (AWS KMS) key. If you don't specify a key, AWS CodePipeline uses the default key for Amazon Simple Storage Service (Amazon S3). An `encryption_key` block is documented below.
        :param pulumi.Input[str] region: The region where the artifact store is located. Required for a cross-region CodePipeline, do not provide for a single-region CodePipeline.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "type", type)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The location where AWS CodePipeline stores artifacts for a pipeline; currently only `S3` is supported.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the artifact store, such as Amazon S3
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input['PipelineArtifactStoreEncryptionKeyArgs']]:
        """
        The encryption key block AWS CodePipeline uses to encrypt the data in the artifact store, such as an AWS Key Management Service (AWS KMS) key. If you don't specify a key, AWS CodePipeline uses the default key for Amazon Simple Storage Service (Amazon S3). An `encryption_key` block is documented below.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input['PipelineArtifactStoreEncryptionKeyArgs']]):
        pulumi.set(self, "encryption_key", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region where the artifact store is located. Required for a cross-region CodePipeline, do not provide for a single-region CodePipeline.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class PipelineArtifactStoreEncryptionKeyArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] id: The KMS key ARN or ID
        :param pulumi.Input[str] type: The type of key; currently only `KMS` is supported
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        The KMS key ARN or ID
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of key; currently only `KMS` is supported
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class PipelineStageArgs:
    def __init__(__self__, *,
                 actions: pulumi.Input[Sequence[pulumi.Input['PipelineStageActionArgs']]],
                 name: pulumi.Input[str]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['PipelineStageActionArgs']]] actions: The action(s) to include in the stage. Defined as an `action` block below
        :param pulumi.Input[str] name: The name of the stage.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def actions(self) -> pulumi.Input[Sequence[pulumi.Input['PipelineStageActionArgs']]]:
        """
        The action(s) to include in the stage. Defined as an `action` block below
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: pulumi.Input[Sequence[pulumi.Input['PipelineStageActionArgs']]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the stage.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class PipelineStageActionArgs:
    def __init__(__self__, *,
                 category: pulumi.Input[str],
                 name: pulumi.Input[str],
                 owner: pulumi.Input[str],
                 provider: pulumi.Input[str],
                 version: pulumi.Input[str],
                 configuration: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 input_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 output_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 run_order: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] category: A category defines what kind of action can be taken in the stage, and constrains the provider type for the action. Possible values are `Approval`, `Build`, `Deploy`, `Invoke`, `Source` and `Test`.
        :param pulumi.Input[str] name: The action declaration's name.
        :param pulumi.Input[str] owner: The creator of the action being called. Possible values are `AWS`, `Custom` and `ThirdParty`.
        :param pulumi.Input[str] provider: The provider of the service being called by the action. Valid providers are determined by the action category. Provider names are listed in the [Action Structure Reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) documentation.
        :param pulumi.Input[str] version: A string that identifies the action type.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] configuration: A map of the action declaration's configuration. Configurations options for action types and providers can be found in the [Pipeline Structure Reference](http://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements) and [Action Structure Reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) documentation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] input_artifacts: A list of artifact names to be worked on.
        :param pulumi.Input[str] namespace: The namespace all output variables will be accessed from.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] output_artifacts: A list of artifact names to output. Output artifact names must be unique within a pipeline.
        :param pulumi.Input[str] region: The region in which to run the action.
        :param pulumi.Input[str] role_arn: The ARN of the IAM service role that will perform the declared action. This is assumed through the roleArn for the pipeline.
        :param pulumi.Input[int] run_order: The order in which actions are run.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "owner", owner)
        pulumi.set(__self__, "provider", provider)
        pulumi.set(__self__, "version", version)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if input_artifacts is not None:
            pulumi.set(__self__, "input_artifacts", input_artifacts)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if output_artifacts is not None:
            pulumi.set(__self__, "output_artifacts", output_artifacts)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if run_order is not None:
            pulumi.set(__self__, "run_order", run_order)

    @property
    @pulumi.getter
    def category(self) -> pulumi.Input[str]:
        """
        A category defines what kind of action can be taken in the stage, and constrains the provider type for the action. Possible values are `Approval`, `Build`, `Deploy`, `Invoke`, `Source` and `Test`.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: pulumi.Input[str]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The action declaration's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Input[str]:
        """
        The creator of the action being called. Possible values are `AWS`, `Custom` and `ThirdParty`.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: pulumi.Input[str]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter
    def provider(self) -> pulumi.Input[str]:
        """
        The provider of the service being called by the action. Valid providers are determined by the action category. Provider names are listed in the [Action Structure Reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) documentation.
        """
        return pulumi.get(self, "provider")

    @provider.setter
    def provider(self, value: pulumi.Input[str]):
        pulumi.set(self, "provider", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[str]:
        """
        A string that identifies the action type.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of the action declaration's configuration. Configurations options for action types and providers can be found in the [Pipeline Structure Reference](http://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements) and [Action Structure Reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) documentation.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter(name="inputArtifacts")
    def input_artifacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of artifact names to be worked on.
        """
        return pulumi.get(self, "input_artifacts")

    @input_artifacts.setter
    def input_artifacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "input_artifacts", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace all output variables will be accessed from.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="outputArtifacts")
    def output_artifacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of artifact names to output. Output artifact names must be unique within a pipeline.
        """
        return pulumi.get(self, "output_artifacts")

    @output_artifacts.setter
    def output_artifacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "output_artifacts", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to run the action.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the IAM service role that will perform the declared action. This is assumed through the roleArn for the pipeline.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="runOrder")
    def run_order(self) -> Optional[pulumi.Input[int]]:
        """
        The order in which actions are run.
        """
        return pulumi.get(self, "run_order")

    @run_order.setter
    def run_order(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "run_order", value)


@pulumi.input_type
class PipelineTriggerArgs:
    def __init__(__self__, *,
                 git_configuration: pulumi.Input['PipelineTriggerGitConfigurationArgs'],
                 provider_type: pulumi.Input[str]):
        """
        :param pulumi.Input['PipelineTriggerGitConfigurationArgs'] git_configuration: Provides the filter criteria and the source stage for the repository event that starts the pipeline. For more information, refer to the [AWS documentation](https://docs.aws.amazon.com/codepipeline/latest/userguide/pipelines-filter.html). A `git_configuration` block is documented below.
        :param pulumi.Input[str] provider_type: The source provider for the event. Possible value is `CodeStarSourceConnection`.
        """
        pulumi.set(__self__, "git_configuration", git_configuration)
        pulumi.set(__self__, "provider_type", provider_type)

    @property
    @pulumi.getter(name="gitConfiguration")
    def git_configuration(self) -> pulumi.Input['PipelineTriggerGitConfigurationArgs']:
        """
        Provides the filter criteria and the source stage for the repository event that starts the pipeline. For more information, refer to the [AWS documentation](https://docs.aws.amazon.com/codepipeline/latest/userguide/pipelines-filter.html). A `git_configuration` block is documented below.
        """
        return pulumi.get(self, "git_configuration")

    @git_configuration.setter
    def git_configuration(self, value: pulumi.Input['PipelineTriggerGitConfigurationArgs']):
        pulumi.set(self, "git_configuration", value)

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> pulumi.Input[str]:
        """
        The source provider for the event. Possible value is `CodeStarSourceConnection`.
        """
        return pulumi.get(self, "provider_type")

    @provider_type.setter
    def provider_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "provider_type", value)


@pulumi.input_type
class PipelineTriggerGitConfigurationArgs:
    def __init__(__self__, *,
                 source_action_name: pulumi.Input[str],
                 pull_requests: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineTriggerGitConfigurationPullRequestArgs']]]] = None,
                 pushes: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineTriggerGitConfigurationPushArgs']]]] = None):
        """
        :param pulumi.Input[str] source_action_name: The name of the pipeline source action where the trigger configuration.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineTriggerGitConfigurationPullRequestArgs']]] pull_requests: The field where the repository event that will start the pipeline is specified as pull requests. A `pull_request` block is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineTriggerGitConfigurationPushArgs']]] pushes: The field where the repository event that will start the pipeline, such as pushing Git tags, is specified with details. A `push` block is documented below.
        """
        pulumi.set(__self__, "source_action_name", source_action_name)
        if pull_requests is not None:
            pulumi.set(__self__, "pull_requests", pull_requests)
        if pushes is not None:
            pulumi.set(__self__, "pushes", pushes)

    @property
    @pulumi.getter(name="sourceActionName")
    def source_action_name(self) -> pulumi.Input[str]:
        """
        The name of the pipeline source action where the trigger configuration.
        """
        return pulumi.get(self, "source_action_name")

    @source_action_name.setter
    def source_action_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_action_name", value)

    @property
    @pulumi.getter(name="pullRequests")
    def pull_requests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineTriggerGitConfigurationPullRequestArgs']]]]:
        """
        The field where the repository event that will start the pipeline is specified as pull requests. A `pull_request` block is documented below.
        """
        return pulumi.get(self, "pull_requests")

    @pull_requests.setter
    def pull_requests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineTriggerGitConfigurationPullRequestArgs']]]]):
        pulumi.set(self, "pull_requests", value)

    @property
    @pulumi.getter
    def pushes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineTriggerGitConfigurationPushArgs']]]]:
        """
        The field where the repository event that will start the pipeline, such as pushing Git tags, is specified with details. A `push` block is documented below.
        """
        return pulumi.get(self, "pushes")

    @pushes.setter
    def pushes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineTriggerGitConfigurationPushArgs']]]]):
        pulumi.set(self, "pushes", value)


@pulumi.input_type
class PipelineTriggerGitConfigurationPullRequestArgs:
    def __init__(__self__, *,
                 branches: Optional[pulumi.Input['PipelineTriggerGitConfigurationPullRequestBranchesArgs']] = None,
                 events: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 file_paths: Optional[pulumi.Input['PipelineTriggerGitConfigurationPullRequestFilePathsArgs']] = None):
        """
        :param pulumi.Input['PipelineTriggerGitConfigurationPullRequestBranchesArgs'] branches: The field that specifies to filter on branches for the pull request trigger configuration. A `branches` block is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] events: A list that specifies which pull request events to filter on (opened, updated, closed) for the trigger configuration. Possible values are `OPEN`, `UPDATED ` and `CLOSED`.
        :param pulumi.Input['PipelineTriggerGitConfigurationPullRequestFilePathsArgs'] file_paths: The field that specifies to filter on file paths for the pull request trigger configuration. A `file_paths` block is documented below.
        """
        if branches is not None:
            pulumi.set(__self__, "branches", branches)
        if events is not None:
            pulumi.set(__self__, "events", events)
        if file_paths is not None:
            pulumi.set(__self__, "file_paths", file_paths)

    @property
    @pulumi.getter
    def branches(self) -> Optional[pulumi.Input['PipelineTriggerGitConfigurationPullRequestBranchesArgs']]:
        """
        The field that specifies to filter on branches for the pull request trigger configuration. A `branches` block is documented below.
        """
        return pulumi.get(self, "branches")

    @branches.setter
    def branches(self, value: Optional[pulumi.Input['PipelineTriggerGitConfigurationPullRequestBranchesArgs']]):
        pulumi.set(self, "branches", value)

    @property
    @pulumi.getter
    def events(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list that specifies which pull request events to filter on (opened, updated, closed) for the trigger configuration. Possible values are `OPEN`, `UPDATED ` and `CLOSED`.
        """
        return pulumi.get(self, "events")

    @events.setter
    def events(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "events", value)

    @property
    @pulumi.getter(name="filePaths")
    def file_paths(self) -> Optional[pulumi.Input['PipelineTriggerGitConfigurationPullRequestFilePathsArgs']]:
        """
        The field that specifies to filter on file paths for the pull request trigger configuration. A `file_paths` block is documented below.
        """
        return pulumi.get(self, "file_paths")

    @file_paths.setter
    def file_paths(self, value: Optional[pulumi.Input['PipelineTriggerGitConfigurationPullRequestFilePathsArgs']]):
        pulumi.set(self, "file_paths", value)


@pulumi.input_type
class PipelineTriggerGitConfigurationPullRequestBranchesArgs:
    def __init__(__self__, *,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excludes: A list of patterns of Git branches that, when a commit is pushed, are to be excluded from starting the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] includes: A list of patterns of Git branches that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of patterns of Git branches that, when a commit is pushed, are to be excluded from starting the pipeline.
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excludes", value)

    @property
    @pulumi.getter
    def includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of patterns of Git branches that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        return pulumi.get(self, "includes")

    @includes.setter
    def includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "includes", value)


@pulumi.input_type
class PipelineTriggerGitConfigurationPullRequestFilePathsArgs:
    def __init__(__self__, *,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excludes: A list of patterns of Git repository file paths that, when a commit is pushed, are to be excluded from starting the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] includes: A list of patterns of Git repository file paths that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of patterns of Git repository file paths that, when a commit is pushed, are to be excluded from starting the pipeline.
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excludes", value)

    @property
    @pulumi.getter
    def includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of patterns of Git repository file paths that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        return pulumi.get(self, "includes")

    @includes.setter
    def includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "includes", value)


@pulumi.input_type
class PipelineTriggerGitConfigurationPushArgs:
    def __init__(__self__, *,
                 branches: Optional[pulumi.Input['PipelineTriggerGitConfigurationPushBranchesArgs']] = None,
                 file_paths: Optional[pulumi.Input['PipelineTriggerGitConfigurationPushFilePathsArgs']] = None,
                 tags: Optional[pulumi.Input['PipelineTriggerGitConfigurationPushTagsArgs']] = None):
        """
        :param pulumi.Input['PipelineTriggerGitConfigurationPushBranchesArgs'] branches: The field that specifies to filter on branches for the push trigger configuration. A `branches` block is documented below.
        :param pulumi.Input['PipelineTriggerGitConfigurationPushFilePathsArgs'] file_paths: The field that specifies to filter on file paths for the push trigger configuration. A `file_paths` block is documented below.
        :param pulumi.Input['PipelineTriggerGitConfigurationPushTagsArgs'] tags: The field that contains the details for the Git tags trigger configuration. A `tags` block is documented below.
        """
        if branches is not None:
            pulumi.set(__self__, "branches", branches)
        if file_paths is not None:
            pulumi.set(__self__, "file_paths", file_paths)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def branches(self) -> Optional[pulumi.Input['PipelineTriggerGitConfigurationPushBranchesArgs']]:
        """
        The field that specifies to filter on branches for the push trigger configuration. A `branches` block is documented below.
        """
        return pulumi.get(self, "branches")

    @branches.setter
    def branches(self, value: Optional[pulumi.Input['PipelineTriggerGitConfigurationPushBranchesArgs']]):
        pulumi.set(self, "branches", value)

    @property
    @pulumi.getter(name="filePaths")
    def file_paths(self) -> Optional[pulumi.Input['PipelineTriggerGitConfigurationPushFilePathsArgs']]:
        """
        The field that specifies to filter on file paths for the push trigger configuration. A `file_paths` block is documented below.
        """
        return pulumi.get(self, "file_paths")

    @file_paths.setter
    def file_paths(self, value: Optional[pulumi.Input['PipelineTriggerGitConfigurationPushFilePathsArgs']]):
        pulumi.set(self, "file_paths", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input['PipelineTriggerGitConfigurationPushTagsArgs']]:
        """
        The field that contains the details for the Git tags trigger configuration. A `tags` block is documented below.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input['PipelineTriggerGitConfigurationPushTagsArgs']]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class PipelineTriggerGitConfigurationPushBranchesArgs:
    def __init__(__self__, *,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excludes: A list of patterns of Git branches that, when a commit is pushed, are to be excluded from starting the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] includes: A list of patterns of Git branches that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of patterns of Git branches that, when a commit is pushed, are to be excluded from starting the pipeline.
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excludes", value)

    @property
    @pulumi.getter
    def includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of patterns of Git branches that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        return pulumi.get(self, "includes")

    @includes.setter
    def includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "includes", value)


@pulumi.input_type
class PipelineTriggerGitConfigurationPushFilePathsArgs:
    def __init__(__self__, *,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excludes: A list of patterns of Git repository file paths that, when a commit is pushed, are to be excluded from starting the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] includes: A list of patterns of Git repository file paths that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of patterns of Git repository file paths that, when a commit is pushed, are to be excluded from starting the pipeline.
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excludes", value)

    @property
    @pulumi.getter
    def includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of patterns of Git repository file paths that, when a commit is pushed, are to be included as criteria that starts the pipeline.
        """
        return pulumi.get(self, "includes")

    @includes.setter
    def includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "includes", value)


@pulumi.input_type
class PipelineTriggerGitConfigurationPushTagsArgs:
    def __init__(__self__, *,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excludes: A list of patterns of Git tags that, when pushed, are to be excluded from starting the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] includes: A list of patterns of Git tags that, when pushed, are to be included as criteria that starts the pipeline.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of patterns of Git tags that, when pushed, are to be excluded from starting the pipeline.
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excludes", value)

    @property
    @pulumi.getter
    def includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of patterns of Git tags that, when pushed, are to be included as criteria that starts the pipeline.
        """
        return pulumi.get(self, "includes")

    @includes.setter
    def includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "includes", value)


@pulumi.input_type
class PipelineVariableArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 default_value: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The name of a pipeline-level variable.
        :param pulumi.Input[str] default_value: The default value of a pipeline-level variable.
        :param pulumi.Input[str] description: The description of a pipeline-level variable.
               
               > **Note:** The input artifact of an action must exactly match the output artifact declared in a preceding action, but the input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.
        """
        pulumi.set(__self__, "name", name)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of a pipeline-level variable.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[pulumi.Input[str]]:
        """
        The default value of a pipeline-level variable.
        """
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_value", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of a pipeline-level variable.

        > **Note:** The input artifact of an action must exactly match the output artifact declared in a preceding action, but the input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class WebhookAuthenticationConfigurationArgs:
    def __init__(__self__, *,
                 allowed_ip_range: Optional[pulumi.Input[str]] = None,
                 secret_token: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] allowed_ip_range: A valid CIDR block for `IP` filtering. Required for `IP`.
        :param pulumi.Input[str] secret_token: The shared secret for the GitHub repository webhook. Set this as `secret` in your `github_repository_webhook`'s `configuration` block. Required for `GITHUB_HMAC`.
        """
        if allowed_ip_range is not None:
            pulumi.set(__self__, "allowed_ip_range", allowed_ip_range)
        if secret_token is not None:
            pulumi.set(__self__, "secret_token", secret_token)

    @property
    @pulumi.getter(name="allowedIpRange")
    def allowed_ip_range(self) -> Optional[pulumi.Input[str]]:
        """
        A valid CIDR block for `IP` filtering. Required for `IP`.
        """
        return pulumi.get(self, "allowed_ip_range")

    @allowed_ip_range.setter
    def allowed_ip_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allowed_ip_range", value)

    @property
    @pulumi.getter(name="secretToken")
    def secret_token(self) -> Optional[pulumi.Input[str]]:
        """
        The shared secret for the GitHub repository webhook. Set this as `secret` in your `github_repository_webhook`'s `configuration` block. Required for `GITHUB_HMAC`.
        """
        return pulumi.get(self, "secret_token")

    @secret_token.setter
    def secret_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_token", value)


@pulumi.input_type
class WebhookFilterArgs:
    def __init__(__self__, *,
                 json_path: pulumi.Input[str],
                 match_equals: pulumi.Input[str]):
        """
        :param pulumi.Input[str] json_path: The [JSON path](https://github.com/json-path/JsonPath) to filter on.
        :param pulumi.Input[str] match_equals: The value to match on (e.g., `refs/heads/{Branch}`). See [AWS docs](https://docs.aws.amazon.com/codepipeline/latest/APIReference/API_WebhookFilterRule.html) for details.
        """
        pulumi.set(__self__, "json_path", json_path)
        pulumi.set(__self__, "match_equals", match_equals)

    @property
    @pulumi.getter(name="jsonPath")
    def json_path(self) -> pulumi.Input[str]:
        """
        The [JSON path](https://github.com/json-path/JsonPath) to filter on.
        """
        return pulumi.get(self, "json_path")

    @json_path.setter
    def json_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "json_path", value)

    @property
    @pulumi.getter(name="matchEquals")
    def match_equals(self) -> pulumi.Input[str]:
        """
        The value to match on (e.g., `refs/heads/{Branch}`). See [AWS docs](https://docs.aws.amazon.com/codepipeline/latest/APIReference/API_WebhookFilterRule.html) for details.
        """
        return pulumi.get(self, "match_equals")

    @match_equals.setter
    def match_equals(self, value: pulumi.Input[str]):
        pulumi.set(self, "match_equals", value)


