# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 user_pool_id: pulumi.Input[str],
                 username: pulumi.Input[str],
                 attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 client_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 desired_delivery_mediums: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 force_alias_creation: Optional[pulumi.Input[bool]] = None,
                 message_action: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 temporary_password: Optional[pulumi.Input[str]] = None,
                 validation_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[str] user_pool_id: The user pool ID for the user pool where the user will be created.
        :param pulumi.Input[str] username: The username for the user. Must be unique within the user pool. Must be a UTF-8 string between 1 and 128 characters. After the user is created, the username cannot be changed.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] attributes: A map that contains user attributes and attribute values to be set for the user.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_metadata: A map of custom key-value pairs that you can provide as input for any custom workflows that user creation triggers. Amazon Cognito does not store the `client_metadata` value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] desired_delivery_mediums: A list of mediums to the welcome message will be sent through. Allowed values are `EMAIL` and `SMS`. If it's provided, make sure you have also specified `email` attribute for the `EMAIL` medium and `phone_number` for the `SMS`. More than one value can be specified. Amazon Cognito does not store the `desired_delivery_mediums` value. Defaults to `["SMS"]`.
        :param pulumi.Input[bool] enabled: Specifies whether the user should be enabled after creation. The welcome message will be sent regardless of the `enabled` value. The behavior can be changed with `message_action` argument. Defaults to `true`.
        :param pulumi.Input[bool] force_alias_creation: If this parameter is set to True and the `phone_number` or `email` address specified in the `attributes` parameter already exists as an alias with a different user, Amazon Cognito will migrate the alias from the previous user to the newly created user. The previous user will no longer be able to log in using that alias. Amazon Cognito does not store the `force_alias_creation` value. Defaults to `false`.
        :param pulumi.Input[str] message_action: Set to `RESEND` to resend the invitation message to a user that already exists and reset the expiration limit on the user's account. Set to `SUPPRESS` to suppress sending the message. Only one value can be specified. Amazon Cognito does not store the `message_action` value.
        :param pulumi.Input[str] password: The user's permanent password. This password must conform to the password policy specified by user pool the user belongs to. The welcome message always contains only `temporary_password` value. You can suppress sending the welcome message with the `message_action` argument. Amazon Cognito does not store the `password` value. Conflicts with `temporary_password`.
        :param pulumi.Input[str] temporary_password: The user's temporary password. Conflicts with `password`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] validation_data: The user's validation data. This is an array of name-value pairs that contain user attributes and attribute values that you can use for custom validation, such as restricting the types of user accounts that can be registered. Amazon Cognito does not store the `validation_data` value. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).
               
               > **NOTE:** Clearing `password` or `temporary_password` does not reset user's password in Cognito.
        """
        pulumi.set(__self__, "user_pool_id", user_pool_id)
        pulumi.set(__self__, "username", username)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if client_metadata is not None:
            pulumi.set(__self__, "client_metadata", client_metadata)
        if desired_delivery_mediums is not None:
            pulumi.set(__self__, "desired_delivery_mediums", desired_delivery_mediums)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if force_alias_creation is not None:
            pulumi.set(__self__, "force_alias_creation", force_alias_creation)
        if message_action is not None:
            pulumi.set(__self__, "message_action", message_action)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if temporary_password is not None:
            pulumi.set(__self__, "temporary_password", temporary_password)
        if validation_data is not None:
            pulumi.set(__self__, "validation_data", validation_data)

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> pulumi.Input[str]:
        """
        The user pool ID for the user pool where the user will be created.
        """
        return pulumi.get(self, "user_pool_id")

    @user_pool_id.setter
    def user_pool_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_pool_id", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        The username for the user. Must be unique within the user pool. Must be a UTF-8 string between 1 and 128 characters. After the user is created, the username cannot be changed.

        The following arguments are optional:
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map that contains user attributes and attribute values to be set for the user.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter(name="clientMetadata")
    def client_metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of custom key-value pairs that you can provide as input for any custom workflows that user creation triggers. Amazon Cognito does not store the `client_metadata` value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).
        """
        return pulumi.get(self, "client_metadata")

    @client_metadata.setter
    def client_metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_metadata", value)

    @property
    @pulumi.getter(name="desiredDeliveryMediums")
    def desired_delivery_mediums(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of mediums to the welcome message will be sent through. Allowed values are `EMAIL` and `SMS`. If it's provided, make sure you have also specified `email` attribute for the `EMAIL` medium and `phone_number` for the `SMS`. More than one value can be specified. Amazon Cognito does not store the `desired_delivery_mediums` value. Defaults to `["SMS"]`.
        """
        return pulumi.get(self, "desired_delivery_mediums")

    @desired_delivery_mediums.setter
    def desired_delivery_mediums(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "desired_delivery_mediums", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the user should be enabled after creation. The welcome message will be sent regardless of the `enabled` value. The behavior can be changed with `message_action` argument. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="forceAliasCreation")
    def force_alias_creation(self) -> Optional[pulumi.Input[bool]]:
        """
        If this parameter is set to True and the `phone_number` or `email` address specified in the `attributes` parameter already exists as an alias with a different user, Amazon Cognito will migrate the alias from the previous user to the newly created user. The previous user will no longer be able to log in using that alias. Amazon Cognito does not store the `force_alias_creation` value. Defaults to `false`.
        """
        return pulumi.get(self, "force_alias_creation")

    @force_alias_creation.setter
    def force_alias_creation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_alias_creation", value)

    @property
    @pulumi.getter(name="messageAction")
    def message_action(self) -> Optional[pulumi.Input[str]]:
        """
        Set to `RESEND` to resend the invitation message to a user that already exists and reset the expiration limit on the user's account. Set to `SUPPRESS` to suppress sending the message. Only one value can be specified. Amazon Cognito does not store the `message_action` value.
        """
        return pulumi.get(self, "message_action")

    @message_action.setter
    def message_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_action", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The user's permanent password. This password must conform to the password policy specified by user pool the user belongs to. The welcome message always contains only `temporary_password` value. You can suppress sending the welcome message with the `message_action` argument. Amazon Cognito does not store the `password` value. Conflicts with `temporary_password`.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="temporaryPassword")
    def temporary_password(self) -> Optional[pulumi.Input[str]]:
        """
        The user's temporary password. Conflicts with `password`.
        """
        return pulumi.get(self, "temporary_password")

    @temporary_password.setter
    def temporary_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "temporary_password", value)

    @property
    @pulumi.getter(name="validationData")
    def validation_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The user's validation data. This is an array of name-value pairs that contain user attributes and attribute values that you can use for custom validation, such as restricting the types of user accounts that can be registered. Amazon Cognito does not store the `validation_data` value. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).

        > **NOTE:** Clearing `password` or `temporary_password` does not reset user's password in Cognito.
        """
        return pulumi.get(self, "validation_data")

    @validation_data.setter
    def validation_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "validation_data", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 client_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 creation_date: Optional[pulumi.Input[str]] = None,
                 desired_delivery_mediums: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 force_alias_creation: Optional[pulumi.Input[bool]] = None,
                 last_modified_date: Optional[pulumi.Input[str]] = None,
                 message_action: Optional[pulumi.Input[str]] = None,
                 mfa_setting_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 preferred_mfa_setting: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 sub: Optional[pulumi.Input[str]] = None,
                 temporary_password: Optional[pulumi.Input[str]] = None,
                 user_pool_id: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 validation_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] attributes: A map that contains user attributes and attribute values to be set for the user.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_metadata: A map of custom key-value pairs that you can provide as input for any custom workflows that user creation triggers. Amazon Cognito does not store the `client_metadata` value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] desired_delivery_mediums: A list of mediums to the welcome message will be sent through. Allowed values are `EMAIL` and `SMS`. If it's provided, make sure you have also specified `email` attribute for the `EMAIL` medium and `phone_number` for the `SMS`. More than one value can be specified. Amazon Cognito does not store the `desired_delivery_mediums` value. Defaults to `["SMS"]`.
        :param pulumi.Input[bool] enabled: Specifies whether the user should be enabled after creation. The welcome message will be sent regardless of the `enabled` value. The behavior can be changed with `message_action` argument. Defaults to `true`.
        :param pulumi.Input[bool] force_alias_creation: If this parameter is set to True and the `phone_number` or `email` address specified in the `attributes` parameter already exists as an alias with a different user, Amazon Cognito will migrate the alias from the previous user to the newly created user. The previous user will no longer be able to log in using that alias. Amazon Cognito does not store the `force_alias_creation` value. Defaults to `false`.
        :param pulumi.Input[str] message_action: Set to `RESEND` to resend the invitation message to a user that already exists and reset the expiration limit on the user's account. Set to `SUPPRESS` to suppress sending the message. Only one value can be specified. Amazon Cognito does not store the `message_action` value.
        :param pulumi.Input[str] password: The user's permanent password. This password must conform to the password policy specified by user pool the user belongs to. The welcome message always contains only `temporary_password` value. You can suppress sending the welcome message with the `message_action` argument. Amazon Cognito does not store the `password` value. Conflicts with `temporary_password`.
        :param pulumi.Input[str] status: current user status.
        :param pulumi.Input[str] sub: unique user id that is never reassignable to another user.
        :param pulumi.Input[str] temporary_password: The user's temporary password. Conflicts with `password`.
        :param pulumi.Input[str] user_pool_id: The user pool ID for the user pool where the user will be created.
        :param pulumi.Input[str] username: The username for the user. Must be unique within the user pool. Must be a UTF-8 string between 1 and 128 characters. After the user is created, the username cannot be changed.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] validation_data: The user's validation data. This is an array of name-value pairs that contain user attributes and attribute values that you can use for custom validation, such as restricting the types of user accounts that can be registered. Amazon Cognito does not store the `validation_data` value. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).
               
               > **NOTE:** Clearing `password` or `temporary_password` does not reset user's password in Cognito.
        """
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if client_metadata is not None:
            pulumi.set(__self__, "client_metadata", client_metadata)
        if creation_date is not None:
            pulumi.set(__self__, "creation_date", creation_date)
        if desired_delivery_mediums is not None:
            pulumi.set(__self__, "desired_delivery_mediums", desired_delivery_mediums)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if force_alias_creation is not None:
            pulumi.set(__self__, "force_alias_creation", force_alias_creation)
        if last_modified_date is not None:
            pulumi.set(__self__, "last_modified_date", last_modified_date)
        if message_action is not None:
            pulumi.set(__self__, "message_action", message_action)
        if mfa_setting_lists is not None:
            pulumi.set(__self__, "mfa_setting_lists", mfa_setting_lists)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if preferred_mfa_setting is not None:
            pulumi.set(__self__, "preferred_mfa_setting", preferred_mfa_setting)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if sub is not None:
            pulumi.set(__self__, "sub", sub)
        if temporary_password is not None:
            pulumi.set(__self__, "temporary_password", temporary_password)
        if user_pool_id is not None:
            pulumi.set(__self__, "user_pool_id", user_pool_id)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if validation_data is not None:
            pulumi.set(__self__, "validation_data", validation_data)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map that contains user attributes and attribute values to be set for the user.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter(name="clientMetadata")
    def client_metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of custom key-value pairs that you can provide as input for any custom workflows that user creation triggers. Amazon Cognito does not store the `client_metadata` value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).
        """
        return pulumi.get(self, "client_metadata")

    @client_metadata.setter
    def client_metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "client_metadata", value)

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "creation_date")

    @creation_date.setter
    def creation_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_date", value)

    @property
    @pulumi.getter(name="desiredDeliveryMediums")
    def desired_delivery_mediums(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of mediums to the welcome message will be sent through. Allowed values are `EMAIL` and `SMS`. If it's provided, make sure you have also specified `email` attribute for the `EMAIL` medium and `phone_number` for the `SMS`. More than one value can be specified. Amazon Cognito does not store the `desired_delivery_mediums` value. Defaults to `["SMS"]`.
        """
        return pulumi.get(self, "desired_delivery_mediums")

    @desired_delivery_mediums.setter
    def desired_delivery_mediums(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "desired_delivery_mediums", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the user should be enabled after creation. The welcome message will be sent regardless of the `enabled` value. The behavior can be changed with `message_action` argument. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="forceAliasCreation")
    def force_alias_creation(self) -> Optional[pulumi.Input[bool]]:
        """
        If this parameter is set to True and the `phone_number` or `email` address specified in the `attributes` parameter already exists as an alias with a different user, Amazon Cognito will migrate the alias from the previous user to the newly created user. The previous user will no longer be able to log in using that alias. Amazon Cognito does not store the `force_alias_creation` value. Defaults to `false`.
        """
        return pulumi.get(self, "force_alias_creation")

    @force_alias_creation.setter
    def force_alias_creation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_alias_creation", value)

    @property
    @pulumi.getter(name="lastModifiedDate")
    def last_modified_date(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "last_modified_date")

    @last_modified_date.setter
    def last_modified_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_modified_date", value)

    @property
    @pulumi.getter(name="messageAction")
    def message_action(self) -> Optional[pulumi.Input[str]]:
        """
        Set to `RESEND` to resend the invitation message to a user that already exists and reset the expiration limit on the user's account. Set to `SUPPRESS` to suppress sending the message. Only one value can be specified. Amazon Cognito does not store the `message_action` value.
        """
        return pulumi.get(self, "message_action")

    @message_action.setter
    def message_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_action", value)

    @property
    @pulumi.getter(name="mfaSettingLists")
    def mfa_setting_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "mfa_setting_lists")

    @mfa_setting_lists.setter
    def mfa_setting_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "mfa_setting_lists", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The user's permanent password. This password must conform to the password policy specified by user pool the user belongs to. The welcome message always contains only `temporary_password` value. You can suppress sending the welcome message with the `message_action` argument. Amazon Cognito does not store the `password` value. Conflicts with `temporary_password`.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="preferredMfaSetting")
    def preferred_mfa_setting(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "preferred_mfa_setting")

    @preferred_mfa_setting.setter
    def preferred_mfa_setting(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_mfa_setting", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        current user status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def sub(self) -> Optional[pulumi.Input[str]]:
        """
        unique user id that is never reassignable to another user.
        """
        return pulumi.get(self, "sub")

    @sub.setter
    def sub(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sub", value)

    @property
    @pulumi.getter(name="temporaryPassword")
    def temporary_password(self) -> Optional[pulumi.Input[str]]:
        """
        The user's temporary password. Conflicts with `password`.
        """
        return pulumi.get(self, "temporary_password")

    @temporary_password.setter
    def temporary_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "temporary_password", value)

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        The user pool ID for the user pool where the user will be created.
        """
        return pulumi.get(self, "user_pool_id")

    @user_pool_id.setter
    def user_pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_pool_id", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The username for the user. Must be unique within the user pool. Must be a UTF-8 string between 1 and 128 characters. After the user is created, the username cannot be changed.

        The following arguments are optional:
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="validationData")
    def validation_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The user's validation data. This is an array of name-value pairs that contain user attributes and attribute values that you can use for custom validation, such as restricting the types of user accounts that can be registered. Amazon Cognito does not store the `validation_data` value. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).

        > **NOTE:** Clearing `password` or `temporary_password` does not reset user's password in Cognito.
        """
        return pulumi.get(self, "validation_data")

    @validation_data.setter
    def validation_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "validation_data", value)


class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 client_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 desired_delivery_mediums: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 force_alias_creation: Optional[pulumi.Input[bool]] = None,
                 message_action: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 temporary_password: Optional[pulumi.Input[str]] = None,
                 user_pool_id: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 validation_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides a Cognito User Resource.

        ## Example Usage

        ### Basic configuration

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cognito.UserPool("example", name="MyExamplePool")
        example_user = aws.cognito.User("example",
            user_pool_id=example.id,
            username="example")
        ```
        <!--End PulumiCodeChooser -->

        ### Setting user attributes

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cognito.UserPool("example",
            name="mypool",
            schemas=[
                aws.cognito.UserPoolSchemaArgs(
                    name="example",
                    attribute_data_type="Boolean",
                    mutable=False,
                    required=False,
                    developer_only_attribute=False,
                ),
                aws.cognito.UserPoolSchemaArgs(
                    name="foo",
                    attribute_data_type="String",
                    mutable=False,
                    required=False,
                    developer_only_attribute=False,
                    string_attribute_constraints=aws.cognito.UserPoolSchemaStringAttributeConstraintsArgs(),
                ),
            ])
        example_user = aws.cognito.User("example",
            user_pool_id=example.id,
            username="example",
            attributes={
                "example": "true",
                "foo": "bar",
                "email": "no-reply@example.com",
                "email_verified": "true",
            })
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Cognito User using the `user_pool_id`/`name` attributes concatenated. For example:

        ```sh
        $ pulumi import aws:cognito/user:User user us-east-1_vG78M4goG/user
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] attributes: A map that contains user attributes and attribute values to be set for the user.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_metadata: A map of custom key-value pairs that you can provide as input for any custom workflows that user creation triggers. Amazon Cognito does not store the `client_metadata` value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] desired_delivery_mediums: A list of mediums to the welcome message will be sent through. Allowed values are `EMAIL` and `SMS`. If it's provided, make sure you have also specified `email` attribute for the `EMAIL` medium and `phone_number` for the `SMS`. More than one value can be specified. Amazon Cognito does not store the `desired_delivery_mediums` value. Defaults to `["SMS"]`.
        :param pulumi.Input[bool] enabled: Specifies whether the user should be enabled after creation. The welcome message will be sent regardless of the `enabled` value. The behavior can be changed with `message_action` argument. Defaults to `true`.
        :param pulumi.Input[bool] force_alias_creation: If this parameter is set to True and the `phone_number` or `email` address specified in the `attributes` parameter already exists as an alias with a different user, Amazon Cognito will migrate the alias from the previous user to the newly created user. The previous user will no longer be able to log in using that alias. Amazon Cognito does not store the `force_alias_creation` value. Defaults to `false`.
        :param pulumi.Input[str] message_action: Set to `RESEND` to resend the invitation message to a user that already exists and reset the expiration limit on the user's account. Set to `SUPPRESS` to suppress sending the message. Only one value can be specified. Amazon Cognito does not store the `message_action` value.
        :param pulumi.Input[str] password: The user's permanent password. This password must conform to the password policy specified by user pool the user belongs to. The welcome message always contains only `temporary_password` value. You can suppress sending the welcome message with the `message_action` argument. Amazon Cognito does not store the `password` value. Conflicts with `temporary_password`.
        :param pulumi.Input[str] temporary_password: The user's temporary password. Conflicts with `password`.
        :param pulumi.Input[str] user_pool_id: The user pool ID for the user pool where the user will be created.
        :param pulumi.Input[str] username: The username for the user. Must be unique within the user pool. Must be a UTF-8 string between 1 and 128 characters. After the user is created, the username cannot be changed.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] validation_data: The user's validation data. This is an array of name-value pairs that contain user attributes and attribute values that you can use for custom validation, such as restricting the types of user accounts that can be registered. Amazon Cognito does not store the `validation_data` value. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).
               
               > **NOTE:** Clearing `password` or `temporary_password` does not reset user's password in Cognito.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cognito User Resource.

        ## Example Usage

        ### Basic configuration

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cognito.UserPool("example", name="MyExamplePool")
        example_user = aws.cognito.User("example",
            user_pool_id=example.id,
            username="example")
        ```
        <!--End PulumiCodeChooser -->

        ### Setting user attributes

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cognito.UserPool("example",
            name="mypool",
            schemas=[
                aws.cognito.UserPoolSchemaArgs(
                    name="example",
                    attribute_data_type="Boolean",
                    mutable=False,
                    required=False,
                    developer_only_attribute=False,
                ),
                aws.cognito.UserPoolSchemaArgs(
                    name="foo",
                    attribute_data_type="String",
                    mutable=False,
                    required=False,
                    developer_only_attribute=False,
                    string_attribute_constraints=aws.cognito.UserPoolSchemaStringAttributeConstraintsArgs(),
                ),
            ])
        example_user = aws.cognito.User("example",
            user_pool_id=example.id,
            username="example",
            attributes={
                "example": "true",
                "foo": "bar",
                "email": "no-reply@example.com",
                "email_verified": "true",
            })
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Cognito User using the `user_pool_id`/`name` attributes concatenated. For example:

        ```sh
        $ pulumi import aws:cognito/user:User user us-east-1_vG78M4goG/user
        ```

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 client_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 desired_delivery_mediums: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 force_alias_creation: Optional[pulumi.Input[bool]] = None,
                 message_action: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 temporary_password: Optional[pulumi.Input[str]] = None,
                 user_pool_id: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 validation_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            __props__.__dict__["attributes"] = attributes
            __props__.__dict__["client_metadata"] = client_metadata
            __props__.__dict__["desired_delivery_mediums"] = desired_delivery_mediums
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["force_alias_creation"] = force_alias_creation
            __props__.__dict__["message_action"] = message_action
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["temporary_password"] = None if temporary_password is None else pulumi.Output.secret(temporary_password)
            if user_pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_pool_id'")
            __props__.__dict__["user_pool_id"] = user_pool_id
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
            __props__.__dict__["validation_data"] = validation_data
            __props__.__dict__["creation_date"] = None
            __props__.__dict__["last_modified_date"] = None
            __props__.__dict__["mfa_setting_lists"] = None
            __props__.__dict__["preferred_mfa_setting"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["sub"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password", "temporaryPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(User, __self__).__init__(
            'aws:cognito/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            client_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            creation_date: Optional[pulumi.Input[str]] = None,
            desired_delivery_mediums: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            force_alias_creation: Optional[pulumi.Input[bool]] = None,
            last_modified_date: Optional[pulumi.Input[str]] = None,
            message_action: Optional[pulumi.Input[str]] = None,
            mfa_setting_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            password: Optional[pulumi.Input[str]] = None,
            preferred_mfa_setting: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            sub: Optional[pulumi.Input[str]] = None,
            temporary_password: Optional[pulumi.Input[str]] = None,
            user_pool_id: Optional[pulumi.Input[str]] = None,
            username: Optional[pulumi.Input[str]] = None,
            validation_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] attributes: A map that contains user attributes and attribute values to be set for the user.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] client_metadata: A map of custom key-value pairs that you can provide as input for any custom workflows that user creation triggers. Amazon Cognito does not store the `client_metadata` value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] desired_delivery_mediums: A list of mediums to the welcome message will be sent through. Allowed values are `EMAIL` and `SMS`. If it's provided, make sure you have also specified `email` attribute for the `EMAIL` medium and `phone_number` for the `SMS`. More than one value can be specified. Amazon Cognito does not store the `desired_delivery_mediums` value. Defaults to `["SMS"]`.
        :param pulumi.Input[bool] enabled: Specifies whether the user should be enabled after creation. The welcome message will be sent regardless of the `enabled` value. The behavior can be changed with `message_action` argument. Defaults to `true`.
        :param pulumi.Input[bool] force_alias_creation: If this parameter is set to True and the `phone_number` or `email` address specified in the `attributes` parameter already exists as an alias with a different user, Amazon Cognito will migrate the alias from the previous user to the newly created user. The previous user will no longer be able to log in using that alias. Amazon Cognito does not store the `force_alias_creation` value. Defaults to `false`.
        :param pulumi.Input[str] message_action: Set to `RESEND` to resend the invitation message to a user that already exists and reset the expiration limit on the user's account. Set to `SUPPRESS` to suppress sending the message. Only one value can be specified. Amazon Cognito does not store the `message_action` value.
        :param pulumi.Input[str] password: The user's permanent password. This password must conform to the password policy specified by user pool the user belongs to. The welcome message always contains only `temporary_password` value. You can suppress sending the welcome message with the `message_action` argument. Amazon Cognito does not store the `password` value. Conflicts with `temporary_password`.
        :param pulumi.Input[str] status: current user status.
        :param pulumi.Input[str] sub: unique user id that is never reassignable to another user.
        :param pulumi.Input[str] temporary_password: The user's temporary password. Conflicts with `password`.
        :param pulumi.Input[str] user_pool_id: The user pool ID for the user pool where the user will be created.
        :param pulumi.Input[str] username: The username for the user. Must be unique within the user pool. Must be a UTF-8 string between 1 and 128 characters. After the user is created, the username cannot be changed.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] validation_data: The user's validation data. This is an array of name-value pairs that contain user attributes and attribute values that you can use for custom validation, such as restricting the types of user accounts that can be registered. Amazon Cognito does not store the `validation_data` value. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).
               
               > **NOTE:** Clearing `password` or `temporary_password` does not reset user's password in Cognito.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["attributes"] = attributes
        __props__.__dict__["client_metadata"] = client_metadata
        __props__.__dict__["creation_date"] = creation_date
        __props__.__dict__["desired_delivery_mediums"] = desired_delivery_mediums
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["force_alias_creation"] = force_alias_creation
        __props__.__dict__["last_modified_date"] = last_modified_date
        __props__.__dict__["message_action"] = message_action
        __props__.__dict__["mfa_setting_lists"] = mfa_setting_lists
        __props__.__dict__["password"] = password
        __props__.__dict__["preferred_mfa_setting"] = preferred_mfa_setting
        __props__.__dict__["status"] = status
        __props__.__dict__["sub"] = sub
        __props__.__dict__["temporary_password"] = temporary_password
        __props__.__dict__["user_pool_id"] = user_pool_id
        __props__.__dict__["username"] = username
        __props__.__dict__["validation_data"] = validation_data
        return User(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map that contains user attributes and attribute values to be set for the user.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter(name="clientMetadata")
    def client_metadata(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of custom key-value pairs that you can provide as input for any custom workflows that user creation triggers. Amazon Cognito does not store the `client_metadata` value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).
        """
        return pulumi.get(self, "client_metadata")

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> pulumi.Output[str]:
        return pulumi.get(self, "creation_date")

    @property
    @pulumi.getter(name="desiredDeliveryMediums")
    def desired_delivery_mediums(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of mediums to the welcome message will be sent through. Allowed values are `EMAIL` and `SMS`. If it's provided, make sure you have also specified `email` attribute for the `EMAIL` medium and `phone_number` for the `SMS`. More than one value can be specified. Amazon Cognito does not store the `desired_delivery_mediums` value. Defaults to `["SMS"]`.
        """
        return pulumi.get(self, "desired_delivery_mediums")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether the user should be enabled after creation. The welcome message will be sent regardless of the `enabled` value. The behavior can be changed with `message_action` argument. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="forceAliasCreation")
    def force_alias_creation(self) -> pulumi.Output[Optional[bool]]:
        """
        If this parameter is set to True and the `phone_number` or `email` address specified in the `attributes` parameter already exists as an alias with a different user, Amazon Cognito will migrate the alias from the previous user to the newly created user. The previous user will no longer be able to log in using that alias. Amazon Cognito does not store the `force_alias_creation` value. Defaults to `false`.
        """
        return pulumi.get(self, "force_alias_creation")

    @property
    @pulumi.getter(name="lastModifiedDate")
    def last_modified_date(self) -> pulumi.Output[str]:
        return pulumi.get(self, "last_modified_date")

    @property
    @pulumi.getter(name="messageAction")
    def message_action(self) -> pulumi.Output[Optional[str]]:
        """
        Set to `RESEND` to resend the invitation message to a user that already exists and reset the expiration limit on the user's account. Set to `SUPPRESS` to suppress sending the message. Only one value can be specified. Amazon Cognito does not store the `message_action` value.
        """
        return pulumi.get(self, "message_action")

    @property
    @pulumi.getter(name="mfaSettingLists")
    def mfa_setting_lists(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "mfa_setting_lists")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        The user's permanent password. This password must conform to the password policy specified by user pool the user belongs to. The welcome message always contains only `temporary_password` value. You can suppress sending the welcome message with the `message_action` argument. Amazon Cognito does not store the `password` value. Conflicts with `temporary_password`.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="preferredMfaSetting")
    def preferred_mfa_setting(self) -> pulumi.Output[str]:
        return pulumi.get(self, "preferred_mfa_setting")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        current user status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def sub(self) -> pulumi.Output[str]:
        """
        unique user id that is never reassignable to another user.
        """
        return pulumi.get(self, "sub")

    @property
    @pulumi.getter(name="temporaryPassword")
    def temporary_password(self) -> pulumi.Output[Optional[str]]:
        """
        The user's temporary password. Conflicts with `password`.
        """
        return pulumi.get(self, "temporary_password")

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> pulumi.Output[str]:
        """
        The user pool ID for the user pool where the user will be created.
        """
        return pulumi.get(self, "user_pool_id")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        The username for the user. Must be unique within the user pool. Must be a UTF-8 string between 1 and 128 characters. After the user is created, the username cannot be changed.

        The following arguments are optional:
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="validationData")
    def validation_data(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The user's validation data. This is an array of name-value pairs that contain user attributes and attribute values that you can use for custom validation, such as restricting the types of user accounts that can be registered. Amazon Cognito does not store the `validation_data` value. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).

        > **NOTE:** Clearing `password` or `temporary_password` does not reset user's password in Cognito.
        """
        return pulumi.get(self, "validation_data")

