# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DocumentClassifierArgs', 'DocumentClassifier']

@pulumi.input_type
class DocumentClassifierArgs:
    def __init__(__self__, *,
                 data_access_role_arn: pulumi.Input[str],
                 input_data_config: pulumi.Input['DocumentClassifierInputDataConfigArgs'],
                 language_code: pulumi.Input[str],
                 mode: Optional[pulumi.Input[str]] = None,
                 model_kms_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_data_config: Optional[pulumi.Input['DocumentClassifierOutputDataConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 version_name: Optional[pulumi.Input[str]] = None,
                 version_name_prefix: Optional[pulumi.Input[str]] = None,
                 volume_kms_key_id: Optional[pulumi.Input[str]] = None,
                 vpc_config: Optional[pulumi.Input['DocumentClassifierVpcConfigArgs']] = None):
        """
        The set of arguments for constructing a DocumentClassifier resource.
        :param pulumi.Input[str] data_access_role_arn: The ARN for an IAM Role which allows Comprehend to read the training and testing data.
        :param pulumi.Input['DocumentClassifierInputDataConfigArgs'] input_data_config: Configuration for the training and testing data.
               See the `input_data_config` Configuration Block section below.
        :param pulumi.Input[str] language_code: Two-letter language code for the language.
               One of `en`, `es`, `fr`, `it`, `de`, or `pt`.
        :param pulumi.Input[str] mode: The document classification mode.
               One of `MULTI_CLASS` or `MULTI_LABEL`.
               `MULTI_CLASS` is also known as "Single Label" in the AWS Console.
        :param pulumi.Input[str] model_kms_key_id: KMS Key used to encrypt trained Document Classifiers.
               Can be a KMS Key ID or a KMS Key ARN.
        :param pulumi.Input[str] name: Name for the Document Classifier.
               Has a maximum length of 63 characters.
               Can contain upper- and lower-case letters, numbers, and hypen (`-`).
               
               The following arguments are optional:
        :param pulumi.Input['DocumentClassifierOutputDataConfigArgs'] output_data_config: Configuration for the output results of training.
               See the `output_data_config` Configuration Block section below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` Configuration Block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] version_name: Name for the version of the Document Classifier.
               Each version must have a unique name within the Document Classifier.
               If omitted, the provider will assign a random, unique version name.
               If explicitly set to `""`, no version name will be set.
               Has a maximum length of 63 characters.
               Can contain upper- and lower-case letters, numbers, and hypen (`-`).
               Conflicts with `version_name_prefix`.
        :param pulumi.Input[str] version_name_prefix: Creates a unique version name beginning with the specified prefix.
               Has a maximum length of 37 characters.
               Can contain upper- and lower-case letters, numbers, and hypen (`-`).
               Conflicts with `version_name`.
        :param pulumi.Input[str] volume_kms_key_id: KMS Key used to encrypt storage volumes during job processing.
               Can be a KMS Key ID or a KMS Key ARN.
        :param pulumi.Input['DocumentClassifierVpcConfigArgs'] vpc_config: Configuration parameters for VPC to contain Document Classifier resources.
               See the `vpc_config` Configuration Block section below.
        """
        pulumi.set(__self__, "data_access_role_arn", data_access_role_arn)
        pulumi.set(__self__, "input_data_config", input_data_config)
        pulumi.set(__self__, "language_code", language_code)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if model_kms_key_id is not None:
            pulumi.set(__self__, "model_kms_key_id", model_kms_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output_data_config is not None:
            pulumi.set(__self__, "output_data_config", output_data_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version_name is not None:
            pulumi.set(__self__, "version_name", version_name)
        if version_name_prefix is not None:
            pulumi.set(__self__, "version_name_prefix", version_name_prefix)
        if volume_kms_key_id is not None:
            pulumi.set(__self__, "volume_kms_key_id", volume_kms_key_id)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @property
    @pulumi.getter(name="dataAccessRoleArn")
    def data_access_role_arn(self) -> pulumi.Input[str]:
        """
        The ARN for an IAM Role which allows Comprehend to read the training and testing data.
        """
        return pulumi.get(self, "data_access_role_arn")

    @data_access_role_arn.setter
    def data_access_role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_access_role_arn", value)

    @property
    @pulumi.getter(name="inputDataConfig")
    def input_data_config(self) -> pulumi.Input['DocumentClassifierInputDataConfigArgs']:
        """
        Configuration for the training and testing data.
        See the `input_data_config` Configuration Block section below.
        """
        return pulumi.get(self, "input_data_config")

    @input_data_config.setter
    def input_data_config(self, value: pulumi.Input['DocumentClassifierInputDataConfigArgs']):
        pulumi.set(self, "input_data_config", value)

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> pulumi.Input[str]:
        """
        Two-letter language code for the language.
        One of `en`, `es`, `fr`, `it`, `de`, or `pt`.
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "language_code", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        The document classification mode.
        One of `MULTI_CLASS` or `MULTI_LABEL`.
        `MULTI_CLASS` is also known as "Single Label" in the AWS Console.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="modelKmsKeyId")
    def model_kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        KMS Key used to encrypt trained Document Classifiers.
        Can be a KMS Key ID or a KMS Key ARN.
        """
        return pulumi.get(self, "model_kms_key_id")

    @model_kms_key_id.setter
    def model_kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_kms_key_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for the Document Classifier.
        Has a maximum length of 63 characters.
        Can contain upper- and lower-case letters, numbers, and hypen (`-`).

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outputDataConfig")
    def output_data_config(self) -> Optional[pulumi.Input['DocumentClassifierOutputDataConfigArgs']]:
        """
        Configuration for the output results of training.
        See the `output_data_config` Configuration Block section below.
        """
        return pulumi.get(self, "output_data_config")

    @output_data_config.setter
    def output_data_config(self, value: Optional[pulumi.Input['DocumentClassifierOutputDataConfigArgs']]):
        pulumi.set(self, "output_data_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` Configuration Block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="versionName")
    def version_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for the version of the Document Classifier.
        Each version must have a unique name within the Document Classifier.
        If omitted, the provider will assign a random, unique version name.
        If explicitly set to `""`, no version name will be set.
        Has a maximum length of 63 characters.
        Can contain upper- and lower-case letters, numbers, and hypen (`-`).
        Conflicts with `version_name_prefix`.
        """
        return pulumi.get(self, "version_name")

    @version_name.setter
    def version_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_name", value)

    @property
    @pulumi.getter(name="versionNamePrefix")
    def version_name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Creates a unique version name beginning with the specified prefix.
        Has a maximum length of 37 characters.
        Can contain upper- and lower-case letters, numbers, and hypen (`-`).
        Conflicts with `version_name`.
        """
        return pulumi.get(self, "version_name_prefix")

    @version_name_prefix.setter
    def version_name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_name_prefix", value)

    @property
    @pulumi.getter(name="volumeKmsKeyId")
    def volume_kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        KMS Key used to encrypt storage volumes during job processing.
        Can be a KMS Key ID or a KMS Key ARN.
        """
        return pulumi.get(self, "volume_kms_key_id")

    @volume_kms_key_id.setter
    def volume_kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_kms_key_id", value)

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional[pulumi.Input['DocumentClassifierVpcConfigArgs']]:
        """
        Configuration parameters for VPC to contain Document Classifier resources.
        See the `vpc_config` Configuration Block section below.
        """
        return pulumi.get(self, "vpc_config")

    @vpc_config.setter
    def vpc_config(self, value: Optional[pulumi.Input['DocumentClassifierVpcConfigArgs']]):
        pulumi.set(self, "vpc_config", value)


@pulumi.input_type
class _DocumentClassifierState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 data_access_role_arn: Optional[pulumi.Input[str]] = None,
                 input_data_config: Optional[pulumi.Input['DocumentClassifierInputDataConfigArgs']] = None,
                 language_code: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 model_kms_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_data_config: Optional[pulumi.Input['DocumentClassifierOutputDataConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 version_name: Optional[pulumi.Input[str]] = None,
                 version_name_prefix: Optional[pulumi.Input[str]] = None,
                 volume_kms_key_id: Optional[pulumi.Input[str]] = None,
                 vpc_config: Optional[pulumi.Input['DocumentClassifierVpcConfigArgs']] = None):
        """
        Input properties used for looking up and filtering DocumentClassifier resources.
        :param pulumi.Input[str] arn: ARN of the Document Classifier version.
        :param pulumi.Input[str] data_access_role_arn: The ARN for an IAM Role which allows Comprehend to read the training and testing data.
        :param pulumi.Input['DocumentClassifierInputDataConfigArgs'] input_data_config: Configuration for the training and testing data.
               See the `input_data_config` Configuration Block section below.
        :param pulumi.Input[str] language_code: Two-letter language code for the language.
               One of `en`, `es`, `fr`, `it`, `de`, or `pt`.
        :param pulumi.Input[str] mode: The document classification mode.
               One of `MULTI_CLASS` or `MULTI_LABEL`.
               `MULTI_CLASS` is also known as "Single Label" in the AWS Console.
        :param pulumi.Input[str] model_kms_key_id: KMS Key used to encrypt trained Document Classifiers.
               Can be a KMS Key ID or a KMS Key ARN.
        :param pulumi.Input[str] name: Name for the Document Classifier.
               Has a maximum length of 63 characters.
               Can contain upper- and lower-case letters, numbers, and hypen (`-`).
               
               The following arguments are optional:
        :param pulumi.Input['DocumentClassifierOutputDataConfigArgs'] output_data_config: Configuration for the output results of training.
               See the `output_data_config` Configuration Block section below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` Configuration Block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] version_name: Name for the version of the Document Classifier.
               Each version must have a unique name within the Document Classifier.
               If omitted, the provider will assign a random, unique version name.
               If explicitly set to `""`, no version name will be set.
               Has a maximum length of 63 characters.
               Can contain upper- and lower-case letters, numbers, and hypen (`-`).
               Conflicts with `version_name_prefix`.
        :param pulumi.Input[str] version_name_prefix: Creates a unique version name beginning with the specified prefix.
               Has a maximum length of 37 characters.
               Can contain upper- and lower-case letters, numbers, and hypen (`-`).
               Conflicts with `version_name`.
        :param pulumi.Input[str] volume_kms_key_id: KMS Key used to encrypt storage volumes during job processing.
               Can be a KMS Key ID or a KMS Key ARN.
        :param pulumi.Input['DocumentClassifierVpcConfigArgs'] vpc_config: Configuration parameters for VPC to contain Document Classifier resources.
               See the `vpc_config` Configuration Block section below.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if data_access_role_arn is not None:
            pulumi.set(__self__, "data_access_role_arn", data_access_role_arn)
        if input_data_config is not None:
            pulumi.set(__self__, "input_data_config", input_data_config)
        if language_code is not None:
            pulumi.set(__self__, "language_code", language_code)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if model_kms_key_id is not None:
            pulumi.set(__self__, "model_kms_key_id", model_kms_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output_data_config is not None:
            pulumi.set(__self__, "output_data_config", output_data_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if version_name is not None:
            pulumi.set(__self__, "version_name", version_name)
        if version_name_prefix is not None:
            pulumi.set(__self__, "version_name_prefix", version_name_prefix)
        if volume_kms_key_id is not None:
            pulumi.set(__self__, "volume_kms_key_id", volume_kms_key_id)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the Document Classifier version.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="dataAccessRoleArn")
    def data_access_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN for an IAM Role which allows Comprehend to read the training and testing data.
        """
        return pulumi.get(self, "data_access_role_arn")

    @data_access_role_arn.setter
    def data_access_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_access_role_arn", value)

    @property
    @pulumi.getter(name="inputDataConfig")
    def input_data_config(self) -> Optional[pulumi.Input['DocumentClassifierInputDataConfigArgs']]:
        """
        Configuration for the training and testing data.
        See the `input_data_config` Configuration Block section below.
        """
        return pulumi.get(self, "input_data_config")

    @input_data_config.setter
    def input_data_config(self, value: Optional[pulumi.Input['DocumentClassifierInputDataConfigArgs']]):
        pulumi.set(self, "input_data_config", value)

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[pulumi.Input[str]]:
        """
        Two-letter language code for the language.
        One of `en`, `es`, `fr`, `it`, `de`, or `pt`.
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "language_code", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        The document classification mode.
        One of `MULTI_CLASS` or `MULTI_LABEL`.
        `MULTI_CLASS` is also known as "Single Label" in the AWS Console.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="modelKmsKeyId")
    def model_kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        KMS Key used to encrypt trained Document Classifiers.
        Can be a KMS Key ID or a KMS Key ARN.
        """
        return pulumi.get(self, "model_kms_key_id")

    @model_kms_key_id.setter
    def model_kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_kms_key_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for the Document Classifier.
        Has a maximum length of 63 characters.
        Can contain upper- and lower-case letters, numbers, and hypen (`-`).

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outputDataConfig")
    def output_data_config(self) -> Optional[pulumi.Input['DocumentClassifierOutputDataConfigArgs']]:
        """
        Configuration for the output results of training.
        See the `output_data_config` Configuration Block section below.
        """
        return pulumi.get(self, "output_data_config")

    @output_data_config.setter
    def output_data_config(self, value: Optional[pulumi.Input['DocumentClassifierOutputDataConfigArgs']]):
        pulumi.set(self, "output_data_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` Configuration Block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="versionName")
    def version_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for the version of the Document Classifier.
        Each version must have a unique name within the Document Classifier.
        If omitted, the provider will assign a random, unique version name.
        If explicitly set to `""`, no version name will be set.
        Has a maximum length of 63 characters.
        Can contain upper- and lower-case letters, numbers, and hypen (`-`).
        Conflicts with `version_name_prefix`.
        """
        return pulumi.get(self, "version_name")

    @version_name.setter
    def version_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_name", value)

    @property
    @pulumi.getter(name="versionNamePrefix")
    def version_name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Creates a unique version name beginning with the specified prefix.
        Has a maximum length of 37 characters.
        Can contain upper- and lower-case letters, numbers, and hypen (`-`).
        Conflicts with `version_name`.
        """
        return pulumi.get(self, "version_name_prefix")

    @version_name_prefix.setter
    def version_name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_name_prefix", value)

    @property
    @pulumi.getter(name="volumeKmsKeyId")
    def volume_kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        KMS Key used to encrypt storage volumes during job processing.
        Can be a KMS Key ID or a KMS Key ARN.
        """
        return pulumi.get(self, "volume_kms_key_id")

    @volume_kms_key_id.setter
    def volume_kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_kms_key_id", value)

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional[pulumi.Input['DocumentClassifierVpcConfigArgs']]:
        """
        Configuration parameters for VPC to contain Document Classifier resources.
        See the `vpc_config` Configuration Block section below.
        """
        return pulumi.get(self, "vpc_config")

    @vpc_config.setter
    def vpc_config(self, value: Optional[pulumi.Input['DocumentClassifierVpcConfigArgs']]):
        pulumi.set(self, "vpc_config", value)


class DocumentClassifier(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_access_role_arn: Optional[pulumi.Input[str]] = None,
                 input_data_config: Optional[pulumi.Input[pulumi.InputType['DocumentClassifierInputDataConfigArgs']]] = None,
                 language_code: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 model_kms_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_data_config: Optional[pulumi.Input[pulumi.InputType['DocumentClassifierOutputDataConfigArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 version_name: Optional[pulumi.Input[str]] = None,
                 version_name_prefix: Optional[pulumi.Input[str]] = None,
                 volume_kms_key_id: Optional[pulumi.Input[str]] = None,
                 vpc_config: Optional[pulumi.Input[pulumi.InputType['DocumentClassifierVpcConfigArgs']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Comprehend Document Classifier.

        ## Example Usage

        ### Basic Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        documents = aws.s3.BucketObjectv2("documents")
        example = aws.comprehend.DocumentClassifier("example",
            name="example",
            data_access_role_arn=example_aws_iam_role["arn"],
            language_code="en",
            input_data_config=aws.comprehend.DocumentClassifierInputDataConfigArgs(
                s3_uri=documents.id.apply(lambda id: f"s3://{test['bucket']}/{id}"),
            ))
        entities = aws.s3.BucketObjectv2("entities")
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Comprehend Document Classifier using the ARN. For example:

        ```sh
        $ pulumi import aws:comprehend/documentClassifier:DocumentClassifier example arn:aws:comprehend:us-west-2:123456789012:document_classifier/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] data_access_role_arn: The ARN for an IAM Role which allows Comprehend to read the training and testing data.
        :param pulumi.Input[pulumi.InputType['DocumentClassifierInputDataConfigArgs']] input_data_config: Configuration for the training and testing data.
               See the `input_data_config` Configuration Block section below.
        :param pulumi.Input[str] language_code: Two-letter language code for the language.
               One of `en`, `es`, `fr`, `it`, `de`, or `pt`.
        :param pulumi.Input[str] mode: The document classification mode.
               One of `MULTI_CLASS` or `MULTI_LABEL`.
               `MULTI_CLASS` is also known as "Single Label" in the AWS Console.
        :param pulumi.Input[str] model_kms_key_id: KMS Key used to encrypt trained Document Classifiers.
               Can be a KMS Key ID or a KMS Key ARN.
        :param pulumi.Input[str] name: Name for the Document Classifier.
               Has a maximum length of 63 characters.
               Can contain upper- and lower-case letters, numbers, and hypen (`-`).
               
               The following arguments are optional:
        :param pulumi.Input[pulumi.InputType['DocumentClassifierOutputDataConfigArgs']] output_data_config: Configuration for the output results of training.
               See the `output_data_config` Configuration Block section below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` Configuration Block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] version_name: Name for the version of the Document Classifier.
               Each version must have a unique name within the Document Classifier.
               If omitted, the provider will assign a random, unique version name.
               If explicitly set to `""`, no version name will be set.
               Has a maximum length of 63 characters.
               Can contain upper- and lower-case letters, numbers, and hypen (`-`).
               Conflicts with `version_name_prefix`.
        :param pulumi.Input[str] version_name_prefix: Creates a unique version name beginning with the specified prefix.
               Has a maximum length of 37 characters.
               Can contain upper- and lower-case letters, numbers, and hypen (`-`).
               Conflicts with `version_name`.
        :param pulumi.Input[str] volume_kms_key_id: KMS Key used to encrypt storage volumes during job processing.
               Can be a KMS Key ID or a KMS Key ARN.
        :param pulumi.Input[pulumi.InputType['DocumentClassifierVpcConfigArgs']] vpc_config: Configuration parameters for VPC to contain Document Classifier resources.
               See the `vpc_config` Configuration Block section below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DocumentClassifierArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Comprehend Document Classifier.

        ## Example Usage

        ### Basic Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        documents = aws.s3.BucketObjectv2("documents")
        example = aws.comprehend.DocumentClassifier("example",
            name="example",
            data_access_role_arn=example_aws_iam_role["arn"],
            language_code="en",
            input_data_config=aws.comprehend.DocumentClassifierInputDataConfigArgs(
                s3_uri=documents.id.apply(lambda id: f"s3://{test['bucket']}/{id}"),
            ))
        entities = aws.s3.BucketObjectv2("entities")
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Comprehend Document Classifier using the ARN. For example:

        ```sh
        $ pulumi import aws:comprehend/documentClassifier:DocumentClassifier example arn:aws:comprehend:us-west-2:123456789012:document_classifier/example
        ```

        :param str resource_name: The name of the resource.
        :param DocumentClassifierArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DocumentClassifierArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_access_role_arn: Optional[pulumi.Input[str]] = None,
                 input_data_config: Optional[pulumi.Input[pulumi.InputType['DocumentClassifierInputDataConfigArgs']]] = None,
                 language_code: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 model_kms_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_data_config: Optional[pulumi.Input[pulumi.InputType['DocumentClassifierOutputDataConfigArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 version_name: Optional[pulumi.Input[str]] = None,
                 version_name_prefix: Optional[pulumi.Input[str]] = None,
                 volume_kms_key_id: Optional[pulumi.Input[str]] = None,
                 vpc_config: Optional[pulumi.Input[pulumi.InputType['DocumentClassifierVpcConfigArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DocumentClassifierArgs.__new__(DocumentClassifierArgs)

            if data_access_role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'data_access_role_arn'")
            __props__.__dict__["data_access_role_arn"] = data_access_role_arn
            if input_data_config is None and not opts.urn:
                raise TypeError("Missing required property 'input_data_config'")
            __props__.__dict__["input_data_config"] = input_data_config
            if language_code is None and not opts.urn:
                raise TypeError("Missing required property 'language_code'")
            __props__.__dict__["language_code"] = language_code
            __props__.__dict__["mode"] = mode
            __props__.__dict__["model_kms_key_id"] = model_kms_key_id
            __props__.__dict__["name"] = name
            __props__.__dict__["output_data_config"] = output_data_config
            __props__.__dict__["tags"] = tags
            __props__.__dict__["version_name"] = version_name
            __props__.__dict__["version_name_prefix"] = version_name_prefix
            __props__.__dict__["volume_kms_key_id"] = volume_kms_key_id
            __props__.__dict__["vpc_config"] = vpc_config
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(DocumentClassifier, __self__).__init__(
            'aws:comprehend/documentClassifier:DocumentClassifier',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            data_access_role_arn: Optional[pulumi.Input[str]] = None,
            input_data_config: Optional[pulumi.Input[pulumi.InputType['DocumentClassifierInputDataConfigArgs']]] = None,
            language_code: Optional[pulumi.Input[str]] = None,
            mode: Optional[pulumi.Input[str]] = None,
            model_kms_key_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            output_data_config: Optional[pulumi.Input[pulumi.InputType['DocumentClassifierOutputDataConfigArgs']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            version_name: Optional[pulumi.Input[str]] = None,
            version_name_prefix: Optional[pulumi.Input[str]] = None,
            volume_kms_key_id: Optional[pulumi.Input[str]] = None,
            vpc_config: Optional[pulumi.Input[pulumi.InputType['DocumentClassifierVpcConfigArgs']]] = None) -> 'DocumentClassifier':
        """
        Get an existing DocumentClassifier resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: ARN of the Document Classifier version.
        :param pulumi.Input[str] data_access_role_arn: The ARN for an IAM Role which allows Comprehend to read the training and testing data.
        :param pulumi.Input[pulumi.InputType['DocumentClassifierInputDataConfigArgs']] input_data_config: Configuration for the training and testing data.
               See the `input_data_config` Configuration Block section below.
        :param pulumi.Input[str] language_code: Two-letter language code for the language.
               One of `en`, `es`, `fr`, `it`, `de`, or `pt`.
        :param pulumi.Input[str] mode: The document classification mode.
               One of `MULTI_CLASS` or `MULTI_LABEL`.
               `MULTI_CLASS` is also known as "Single Label" in the AWS Console.
        :param pulumi.Input[str] model_kms_key_id: KMS Key used to encrypt trained Document Classifiers.
               Can be a KMS Key ID or a KMS Key ARN.
        :param pulumi.Input[str] name: Name for the Document Classifier.
               Has a maximum length of 63 characters.
               Can contain upper- and lower-case letters, numbers, and hypen (`-`).
               
               The following arguments are optional:
        :param pulumi.Input[pulumi.InputType['DocumentClassifierOutputDataConfigArgs']] output_data_config: Configuration for the output results of training.
               See the `output_data_config` Configuration Block section below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` Configuration Block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] version_name: Name for the version of the Document Classifier.
               Each version must have a unique name within the Document Classifier.
               If omitted, the provider will assign a random, unique version name.
               If explicitly set to `""`, no version name will be set.
               Has a maximum length of 63 characters.
               Can contain upper- and lower-case letters, numbers, and hypen (`-`).
               Conflicts with `version_name_prefix`.
        :param pulumi.Input[str] version_name_prefix: Creates a unique version name beginning with the specified prefix.
               Has a maximum length of 37 characters.
               Can contain upper- and lower-case letters, numbers, and hypen (`-`).
               Conflicts with `version_name`.
        :param pulumi.Input[str] volume_kms_key_id: KMS Key used to encrypt storage volumes during job processing.
               Can be a KMS Key ID or a KMS Key ARN.
        :param pulumi.Input[pulumi.InputType['DocumentClassifierVpcConfigArgs']] vpc_config: Configuration parameters for VPC to contain Document Classifier resources.
               See the `vpc_config` Configuration Block section below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DocumentClassifierState.__new__(_DocumentClassifierState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["data_access_role_arn"] = data_access_role_arn
        __props__.__dict__["input_data_config"] = input_data_config
        __props__.__dict__["language_code"] = language_code
        __props__.__dict__["mode"] = mode
        __props__.__dict__["model_kms_key_id"] = model_kms_key_id
        __props__.__dict__["name"] = name
        __props__.__dict__["output_data_config"] = output_data_config
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["version_name"] = version_name
        __props__.__dict__["version_name_prefix"] = version_name_prefix
        __props__.__dict__["volume_kms_key_id"] = volume_kms_key_id
        __props__.__dict__["vpc_config"] = vpc_config
        return DocumentClassifier(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN of the Document Classifier version.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="dataAccessRoleArn")
    def data_access_role_arn(self) -> pulumi.Output[str]:
        """
        The ARN for an IAM Role which allows Comprehend to read the training and testing data.
        """
        return pulumi.get(self, "data_access_role_arn")

    @property
    @pulumi.getter(name="inputDataConfig")
    def input_data_config(self) -> pulumi.Output['outputs.DocumentClassifierInputDataConfig']:
        """
        Configuration for the training and testing data.
        See the `input_data_config` Configuration Block section below.
        """
        return pulumi.get(self, "input_data_config")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> pulumi.Output[str]:
        """
        Two-letter language code for the language.
        One of `en`, `es`, `fr`, `it`, `de`, or `pt`.
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Output[Optional[str]]:
        """
        The document classification mode.
        One of `MULTI_CLASS` or `MULTI_LABEL`.
        `MULTI_CLASS` is also known as "Single Label" in the AWS Console.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="modelKmsKeyId")
    def model_kms_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        KMS Key used to encrypt trained Document Classifiers.
        Can be a KMS Key ID or a KMS Key ARN.
        """
        return pulumi.get(self, "model_kms_key_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name for the Document Classifier.
        Has a maximum length of 63 characters.
        Can contain upper- and lower-case letters, numbers, and hypen (`-`).

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outputDataConfig")
    def output_data_config(self) -> pulumi.Output['outputs.DocumentClassifierOutputDataConfig']:
        """
        Configuration for the output results of training.
        See the `output_data_config` Configuration Block section below.
        """
        return pulumi.get(self, "output_data_config")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` Configuration Block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="versionName")
    def version_name(self) -> pulumi.Output[str]:
        """
        Name for the version of the Document Classifier.
        Each version must have a unique name within the Document Classifier.
        If omitted, the provider will assign a random, unique version name.
        If explicitly set to `""`, no version name will be set.
        Has a maximum length of 63 characters.
        Can contain upper- and lower-case letters, numbers, and hypen (`-`).
        Conflicts with `version_name_prefix`.
        """
        return pulumi.get(self, "version_name")

    @property
    @pulumi.getter(name="versionNamePrefix")
    def version_name_prefix(self) -> pulumi.Output[str]:
        """
        Creates a unique version name beginning with the specified prefix.
        Has a maximum length of 37 characters.
        Can contain upper- and lower-case letters, numbers, and hypen (`-`).
        Conflicts with `version_name`.
        """
        return pulumi.get(self, "version_name_prefix")

    @property
    @pulumi.getter(name="volumeKmsKeyId")
    def volume_kms_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        KMS Key used to encrypt storage volumes during job processing.
        Can be a KMS Key ID or a KMS Key ARN.
        """
        return pulumi.get(self, "volume_kms_key_id")

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> pulumi.Output[Optional['outputs.DocumentClassifierVpcConfig']]:
        """
        Configuration parameters for VPC to contain Document Classifier resources.
        See the `vpc_config` Configuration Block section below.
        """
        return pulumi.get(self, "vpc_config")

