# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetBotAssociationResult',
    'AwaitableGetBotAssociationResult',
    'get_bot_association',
    'get_bot_association_output',
]

@pulumi.output_type
class GetBotAssociationResult:
    """
    A collection of values returned by getBotAssociation.
    """
    def __init__(__self__, id=None, instance_id=None, lex_bot=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if lex_bot and not isinstance(lex_bot, dict):
            raise TypeError("Expected argument 'lex_bot' to be a dict")
        pulumi.set(__self__, "lex_bot", lex_bot)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="lexBot")
    def lex_bot(self) -> 'outputs.GetBotAssociationLexBotResult':
        return pulumi.get(self, "lex_bot")


class AwaitableGetBotAssociationResult(GetBotAssociationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBotAssociationResult(
            id=self.id,
            instance_id=self.instance_id,
            lex_bot=self.lex_bot)


def get_bot_association(instance_id: Optional[str] = None,
                        lex_bot: Optional[pulumi.InputType['GetBotAssociationLexBotArgs']] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBotAssociationResult:
    """
    Provides details about a specific Lex (V1) Bot associated with an Amazon Connect instance.

    ## Example Usage

    ### By name

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_bot_association(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        lex_bot=aws.connect.GetBotAssociationLexBotArgs(
            name="Test",
        ))
    ```
    <!--End PulumiCodeChooser -->


    :param str instance_id: Identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
    :param pulumi.InputType['GetBotAssociationLexBotArgs'] lex_bot: Configuration information of an Amazon Lex (V1) bot. Detailed below.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['lexBot'] = lex_bot
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:connect/getBotAssociation:getBotAssociation', __args__, opts=opts, typ=GetBotAssociationResult).value

    return AwaitableGetBotAssociationResult(
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        lex_bot=pulumi.get(__ret__, 'lex_bot'))


@_utilities.lift_output_func(get_bot_association)
def get_bot_association_output(instance_id: Optional[pulumi.Input[str]] = None,
                               lex_bot: Optional[pulumi.Input[pulumi.InputType['GetBotAssociationLexBotArgs']]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBotAssociationResult]:
    """
    Provides details about a specific Lex (V1) Bot associated with an Amazon Connect instance.

    ## Example Usage

    ### By name

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_bot_association(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        lex_bot=aws.connect.GetBotAssociationLexBotArgs(
            name="Test",
        ))
    ```
    <!--End PulumiCodeChooser -->


    :param str instance_id: Identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
    :param pulumi.InputType['GetBotAssociationLexBotArgs'] lex_bot: Configuration information of an Amazon Lex (V1) bot. Detailed below.
    """
    ...
