# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetInstanceStorageConfigResult',
    'AwaitableGetInstanceStorageConfigResult',
    'get_instance_storage_config',
    'get_instance_storage_config_output',
]

@pulumi.output_type
class GetInstanceStorageConfigResult:
    """
    A collection of values returned by getInstanceStorageConfig.
    """
    def __init__(__self__, association_id=None, id=None, instance_id=None, resource_type=None, storage_configs=None):
        if association_id and not isinstance(association_id, str):
            raise TypeError("Expected argument 'association_id' to be a str")
        pulumi.set(__self__, "association_id", association_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if storage_configs and not isinstance(storage_configs, list):
            raise TypeError("Expected argument 'storage_configs' to be a list")
        pulumi.set(__self__, "storage_configs", storage_configs)

    @property
    @pulumi.getter(name="associationId")
    def association_id(self) -> str:
        return pulumi.get(self, "association_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="storageConfigs")
    def storage_configs(self) -> Sequence['outputs.GetInstanceStorageConfigStorageConfigResult']:
        """
        Specifies the storage configuration options for the Connect Instance. Documented below.
        """
        return pulumi.get(self, "storage_configs")


class AwaitableGetInstanceStorageConfigResult(GetInstanceStorageConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceStorageConfigResult(
            association_id=self.association_id,
            id=self.id,
            instance_id=self.instance_id,
            resource_type=self.resource_type,
            storage_configs=self.storage_configs)


def get_instance_storage_config(association_id: Optional[str] = None,
                                instance_id: Optional[str] = None,
                                resource_type: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstanceStorageConfigResult:
    """
    Provides details about a specific Amazon Connect Instance Storage Config.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_instance_storage_config(association_id="1234567890123456789012345678901234567890123456789012345678901234",
        instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        resource_type="CONTACT_TRACE_RECORDS")
    ```
    <!--End PulumiCodeChooser -->


    :param str association_id: The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.
    :param str instance_id: Reference to the hosting Amazon Connect Instance
    :param str resource_type: A valid resource type. Valid Values: `AGENT_EVENTS` | `ATTACHMENTS` | `CALL_RECORDINGS` | `CHAT_TRANSCRIPTS` | `CONTACT_EVALUATIONS` | `CONTACT_TRACE_RECORDS` | `MEDIA_STREAMS` | `REAL_TIME_CONTACT_ANALYSIS_SEGMENTS` | `SCHEDULED_REPORTS` |  `SCREEN_RECORDINGS`.
    """
    __args__ = dict()
    __args__['associationId'] = association_id
    __args__['instanceId'] = instance_id
    __args__['resourceType'] = resource_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:connect/getInstanceStorageConfig:getInstanceStorageConfig', __args__, opts=opts, typ=GetInstanceStorageConfigResult).value

    return AwaitableGetInstanceStorageConfigResult(
        association_id=pulumi.get(__ret__, 'association_id'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        storage_configs=pulumi.get(__ret__, 'storage_configs'))


@_utilities.lift_output_func(get_instance_storage_config)
def get_instance_storage_config_output(association_id: Optional[pulumi.Input[str]] = None,
                                       instance_id: Optional[pulumi.Input[str]] = None,
                                       resource_type: Optional[pulumi.Input[str]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetInstanceStorageConfigResult]:
    """
    Provides details about a specific Amazon Connect Instance Storage Config.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_instance_storage_config(association_id="1234567890123456789012345678901234567890123456789012345678901234",
        instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
        resource_type="CONTACT_TRACE_RECORDS")
    ```
    <!--End PulumiCodeChooser -->


    :param str association_id: The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.
    :param str instance_id: Reference to the hosting Amazon Connect Instance
    :param str resource_type: A valid resource type. Valid Values: `AGENT_EVENTS` | `ATTACHMENTS` | `CALL_RECORDINGS` | `CHAT_TRANSCRIPTS` | `CONTACT_EVALUATIONS` | `CONTACT_TRACE_RECORDS` | `MEDIA_STREAMS` | `REAL_TIME_CONTACT_ANALYSIS_SEGMENTS` | `SCHEDULED_REPORTS` |  `SCREEN_RECORDINGS`.
    """
    ...
