# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetLambdaFunctionAssociationResult',
    'AwaitableGetLambdaFunctionAssociationResult',
    'get_lambda_function_association',
    'get_lambda_function_association_output',
]

@pulumi.output_type
class GetLambdaFunctionAssociationResult:
    """
    A collection of values returned by getLambdaFunctionAssociation.
    """
    def __init__(__self__, function_arn=None, id=None, instance_id=None):
        if function_arn and not isinstance(function_arn, str):
            raise TypeError("Expected argument 'function_arn' to be a str")
        pulumi.set(__self__, "function_arn", function_arn)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> str:
        return pulumi.get(self, "function_arn")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        return pulumi.get(self, "instance_id")


class AwaitableGetLambdaFunctionAssociationResult(GetLambdaFunctionAssociationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLambdaFunctionAssociationResult(
            function_arn=self.function_arn,
            id=self.id,
            instance_id=self.instance_id)


def get_lambda_function_association(function_arn: Optional[str] = None,
                                    instance_id: Optional[str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLambdaFunctionAssociationResult:
    """
    Provides details about a specific Connect Lambda Function Association.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_lambda_function_association(function_arn="arn:aws:lambda:us-west-2:123456789123:function:abcdefg",
        instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111")
    ```
    <!--End PulumiCodeChooser -->


    :param str function_arn: ARN of the Lambda Function, omitting any version or alias qualifier.
    :param str instance_id: Identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
    """
    __args__ = dict()
    __args__['functionArn'] = function_arn
    __args__['instanceId'] = instance_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:connect/getLambdaFunctionAssociation:getLambdaFunctionAssociation', __args__, opts=opts, typ=GetLambdaFunctionAssociationResult).value

    return AwaitableGetLambdaFunctionAssociationResult(
        function_arn=pulumi.get(__ret__, 'function_arn'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'))


@_utilities.lift_output_func(get_lambda_function_association)
def get_lambda_function_association_output(function_arn: Optional[pulumi.Input[str]] = None,
                                           instance_id: Optional[pulumi.Input[str]] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLambdaFunctionAssociationResult]:
    """
    Provides details about a specific Connect Lambda Function Association.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.connect.get_lambda_function_association(function_arn="arn:aws:lambda:us-west-2:123456789123:function:abcdefg",
        instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111")
    ```
    <!--End PulumiCodeChooser -->


    :param str function_arn: ARN of the Lambda Function, omitting any version or alias qualifier.
    :param str instance_id: Identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
    """
    ...
