# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[str],
                 phone_config: pulumi.Input['UserPhoneConfigArgs'],
                 routing_profile_id: pulumi.Input[str],
                 security_profile_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 directory_user_id: Optional[pulumi.Input[str]] = None,
                 hierarchy_group_id: Optional[pulumi.Input[str]] = None,
                 identity_info: Optional[pulumi.Input['UserIdentityInfoArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[str] instance_id: Specifies the identifier of the hosting Amazon Connect Instance.
        :param pulumi.Input['UserPhoneConfigArgs'] phone_config: A block that contains information about the phone settings for the user. Documented below.
        :param pulumi.Input[str] routing_profile_id: The identifier of the routing profile for the user.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_profile_ids: A list of identifiers for the security profiles for the user. Specify a minimum of 1 and maximum of 10 security profile ids. For more information, see [Best Practices for Security Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-best-practices.html) in the Amazon Connect Administrator Guide.
        :param pulumi.Input[str] directory_user_id: The identifier of the user account in the directory used for identity management. If Amazon Connect cannot access the directory, you can specify this identifier to authenticate users. If you include the identifier, we assume that Amazon Connect cannot access the directory. Otherwise, the identity information is used to authenticate users from your directory. This parameter is required if you are using an existing directory for identity management in Amazon Connect when Amazon Connect cannot access your directory to authenticate users. If you are using SAML for identity management and include this parameter, an error is returned.
        :param pulumi.Input[str] hierarchy_group_id: The identifier of the hierarchy group for the user.
        :param pulumi.Input['UserIdentityInfoArgs'] identity_info: A block that contains information about the identity of the user. Documented below.
        :param pulumi.Input[str] name: The user name for the account. For instances not using SAML for identity management, the user name can include up to 20 characters. If you are using SAML for identity management, the user name can include up to 64 characters from `[a-zA-Z0-9_-.\\@]+`.
        :param pulumi.Input[str] password: The password for the user account. A password is required if you are using Amazon Connect for identity management. Otherwise, it is an error to include a password.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tags to apply to the user. If configured with a provider
               `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "phone_config", phone_config)
        pulumi.set(__self__, "routing_profile_id", routing_profile_id)
        pulumi.set(__self__, "security_profile_ids", security_profile_ids)
        if directory_user_id is not None:
            pulumi.set(__self__, "directory_user_id", directory_user_id)
        if hierarchy_group_id is not None:
            pulumi.set(__self__, "hierarchy_group_id", hierarchy_group_id)
        if identity_info is not None:
            pulumi.set(__self__, "identity_info", identity_info)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        Specifies the identifier of the hosting Amazon Connect Instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="phoneConfig")
    def phone_config(self) -> pulumi.Input['UserPhoneConfigArgs']:
        """
        A block that contains information about the phone settings for the user. Documented below.
        """
        return pulumi.get(self, "phone_config")

    @phone_config.setter
    def phone_config(self, value: pulumi.Input['UserPhoneConfigArgs']):
        pulumi.set(self, "phone_config", value)

    @property
    @pulumi.getter(name="routingProfileId")
    def routing_profile_id(self) -> pulumi.Input[str]:
        """
        The identifier of the routing profile for the user.
        """
        return pulumi.get(self, "routing_profile_id")

    @routing_profile_id.setter
    def routing_profile_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "routing_profile_id", value)

    @property
    @pulumi.getter(name="securityProfileIds")
    def security_profile_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of identifiers for the security profiles for the user. Specify a minimum of 1 and maximum of 10 security profile ids. For more information, see [Best Practices for Security Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-best-practices.html) in the Amazon Connect Administrator Guide.
        """
        return pulumi.get(self, "security_profile_ids")

    @security_profile_ids.setter
    def security_profile_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "security_profile_ids", value)

    @property
    @pulumi.getter(name="directoryUserId")
    def directory_user_id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the user account in the directory used for identity management. If Amazon Connect cannot access the directory, you can specify this identifier to authenticate users. If you include the identifier, we assume that Amazon Connect cannot access the directory. Otherwise, the identity information is used to authenticate users from your directory. This parameter is required if you are using an existing directory for identity management in Amazon Connect when Amazon Connect cannot access your directory to authenticate users. If you are using SAML for identity management and include this parameter, an error is returned.
        """
        return pulumi.get(self, "directory_user_id")

    @directory_user_id.setter
    def directory_user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "directory_user_id", value)

    @property
    @pulumi.getter(name="hierarchyGroupId")
    def hierarchy_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the hierarchy group for the user.
        """
        return pulumi.get(self, "hierarchy_group_id")

    @hierarchy_group_id.setter
    def hierarchy_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hierarchy_group_id", value)

    @property
    @pulumi.getter(name="identityInfo")
    def identity_info(self) -> Optional[pulumi.Input['UserIdentityInfoArgs']]:
        """
        A block that contains information about the identity of the user. Documented below.
        """
        return pulumi.get(self, "identity_info")

    @identity_info.setter
    def identity_info(self, value: Optional[pulumi.Input['UserIdentityInfoArgs']]):
        pulumi.set(self, "identity_info", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The user name for the account. For instances not using SAML for identity management, the user name can include up to 20 characters. If you are using SAML for identity management, the user name can include up to 64 characters from `[a-zA-Z0-9_-.\\@]+`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password for the user account. A password is required if you are using Amazon Connect for identity management. Otherwise, it is an error to include a password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tags to apply to the user. If configured with a provider
        `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 directory_user_id: Optional[pulumi.Input[str]] = None,
                 hierarchy_group_id: Optional[pulumi.Input[str]] = None,
                 identity_info: Optional[pulumi.Input['UserIdentityInfoArgs']] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 phone_config: Optional[pulumi.Input['UserPhoneConfigArgs']] = None,
                 routing_profile_id: Optional[pulumi.Input[str]] = None,
                 security_profile_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) of the user.
        :param pulumi.Input[str] directory_user_id: The identifier of the user account in the directory used for identity management. If Amazon Connect cannot access the directory, you can specify this identifier to authenticate users. If you include the identifier, we assume that Amazon Connect cannot access the directory. Otherwise, the identity information is used to authenticate users from your directory. This parameter is required if you are using an existing directory for identity management in Amazon Connect when Amazon Connect cannot access your directory to authenticate users. If you are using SAML for identity management and include this parameter, an error is returned.
        :param pulumi.Input[str] hierarchy_group_id: The identifier of the hierarchy group for the user.
        :param pulumi.Input['UserIdentityInfoArgs'] identity_info: A block that contains information about the identity of the user. Documented below.
        :param pulumi.Input[str] instance_id: Specifies the identifier of the hosting Amazon Connect Instance.
        :param pulumi.Input[str] name: The user name for the account. For instances not using SAML for identity management, the user name can include up to 20 characters. If you are using SAML for identity management, the user name can include up to 64 characters from `[a-zA-Z0-9_-.\\@]+`.
        :param pulumi.Input[str] password: The password for the user account. A password is required if you are using Amazon Connect for identity management. Otherwise, it is an error to include a password.
        :param pulumi.Input['UserPhoneConfigArgs'] phone_config: A block that contains information about the phone settings for the user. Documented below.
        :param pulumi.Input[str] routing_profile_id: The identifier of the routing profile for the user.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_profile_ids: A list of identifiers for the security profiles for the user. Specify a minimum of 1 and maximum of 10 security profile ids. For more information, see [Best Practices for Security Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-best-practices.html) in the Amazon Connect Administrator Guide.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tags to apply to the user. If configured with a provider
               `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] user_id: The identifier for the user.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if directory_user_id is not None:
            pulumi.set(__self__, "directory_user_id", directory_user_id)
        if hierarchy_group_id is not None:
            pulumi.set(__self__, "hierarchy_group_id", hierarchy_group_id)
        if identity_info is not None:
            pulumi.set(__self__, "identity_info", identity_info)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if phone_config is not None:
            pulumi.set(__self__, "phone_config", phone_config)
        if routing_profile_id is not None:
            pulumi.set(__self__, "routing_profile_id", routing_profile_id)
        if security_profile_ids is not None:
            pulumi.set(__self__, "security_profile_ids", security_profile_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the user.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="directoryUserId")
    def directory_user_id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the user account in the directory used for identity management. If Amazon Connect cannot access the directory, you can specify this identifier to authenticate users. If you include the identifier, we assume that Amazon Connect cannot access the directory. Otherwise, the identity information is used to authenticate users from your directory. This parameter is required if you are using an existing directory for identity management in Amazon Connect when Amazon Connect cannot access your directory to authenticate users. If you are using SAML for identity management and include this parameter, an error is returned.
        """
        return pulumi.get(self, "directory_user_id")

    @directory_user_id.setter
    def directory_user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "directory_user_id", value)

    @property
    @pulumi.getter(name="hierarchyGroupId")
    def hierarchy_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the hierarchy group for the user.
        """
        return pulumi.get(self, "hierarchy_group_id")

    @hierarchy_group_id.setter
    def hierarchy_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hierarchy_group_id", value)

    @property
    @pulumi.getter(name="identityInfo")
    def identity_info(self) -> Optional[pulumi.Input['UserIdentityInfoArgs']]:
        """
        A block that contains information about the identity of the user. Documented below.
        """
        return pulumi.get(self, "identity_info")

    @identity_info.setter
    def identity_info(self, value: Optional[pulumi.Input['UserIdentityInfoArgs']]):
        pulumi.set(self, "identity_info", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the identifier of the hosting Amazon Connect Instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The user name for the account. For instances not using SAML for identity management, the user name can include up to 20 characters. If you are using SAML for identity management, the user name can include up to 64 characters from `[a-zA-Z0-9_-.\\@]+`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password for the user account. A password is required if you are using Amazon Connect for identity management. Otherwise, it is an error to include a password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="phoneConfig")
    def phone_config(self) -> Optional[pulumi.Input['UserPhoneConfigArgs']]:
        """
        A block that contains information about the phone settings for the user. Documented below.
        """
        return pulumi.get(self, "phone_config")

    @phone_config.setter
    def phone_config(self, value: Optional[pulumi.Input['UserPhoneConfigArgs']]):
        pulumi.set(self, "phone_config", value)

    @property
    @pulumi.getter(name="routingProfileId")
    def routing_profile_id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the routing profile for the user.
        """
        return pulumi.get(self, "routing_profile_id")

    @routing_profile_id.setter
    def routing_profile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "routing_profile_id", value)

    @property
    @pulumi.getter(name="securityProfileIds")
    def security_profile_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of identifiers for the security profiles for the user. Specify a minimum of 1 and maximum of 10 security profile ids. For more information, see [Best Practices for Security Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-best-practices.html) in the Amazon Connect Administrator Guide.
        """
        return pulumi.get(self, "security_profile_ids")

    @security_profile_ids.setter
    def security_profile_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_profile_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tags to apply to the user. If configured with a provider
        `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the user.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)


class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 directory_user_id: Optional[pulumi.Input[str]] = None,
                 hierarchy_group_id: Optional[pulumi.Input[str]] = None,
                 identity_info: Optional[pulumi.Input[pulumi.InputType['UserIdentityInfoArgs']]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 phone_config: Optional[pulumi.Input[pulumi.InputType['UserPhoneConfigArgs']]] = None,
                 routing_profile_id: Optional[pulumi.Input[str]] = None,
                 security_profile_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides an Amazon Connect User resource. For more information see
        [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)

        ## Example Usage

        ### Basic

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.connect.User("example",
            instance_id=example_aws_connect_instance["id"],
            name="example",
            password="Password123",
            routing_profile_id=example_aws_connect_routing_profile["routingProfileId"],
            security_profile_ids=[example_aws_connect_security_profile["securityProfileId"]],
            identity_info=aws.connect.UserIdentityInfoArgs(
                first_name="example",
                last_name="example2",
            ),
            phone_config=aws.connect.UserPhoneConfigArgs(
                after_contact_work_time_limit=0,
                phone_type="SOFT_PHONE",
            ))
        ```
        <!--End PulumiCodeChooser -->

        ### With hierarchy_group_id

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.connect.User("example",
            instance_id=example_aws_connect_instance["id"],
            name="example",
            password="Password123",
            routing_profile_id=example_aws_connect_routing_profile["routingProfileId"],
            hierarchy_group_id=example_aws_connect_user_hierarchy_group["hierarchyGroupId"],
            security_profile_ids=[example_aws_connect_security_profile["securityProfileId"]],
            identity_info=aws.connect.UserIdentityInfoArgs(
                first_name="example",
                last_name="example2",
            ),
            phone_config=aws.connect.UserPhoneConfigArgs(
                after_contact_work_time_limit=0,
                phone_type="SOFT_PHONE",
            ))
        ```
        <!--End PulumiCodeChooser -->

        ### With identity_info filled

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.connect.User("example",
            instance_id=example_aws_connect_instance["id"],
            name="example",
            password="Password123",
            routing_profile_id=example_aws_connect_routing_profile["routingProfileId"],
            security_profile_ids=[example_aws_connect_security_profile["securityProfileId"]],
            identity_info=aws.connect.UserIdentityInfoArgs(
                email="example@example.com",
                first_name="example",
                last_name="example2",
            ),
            phone_config=aws.connect.UserPhoneConfigArgs(
                after_contact_work_time_limit=0,
                phone_type="SOFT_PHONE",
            ))
        ```
        <!--End PulumiCodeChooser -->

        ### With phone_config phone type as desk phone

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.connect.User("example",
            instance_id=example_aws_connect_instance["id"],
            name="example",
            password="Password123",
            routing_profile_id=example_aws_connect_routing_profile["routingProfileId"],
            security_profile_ids=[example_aws_connect_security_profile["securityProfileId"]],
            phone_config=aws.connect.UserPhoneConfigArgs(
                after_contact_work_time_limit=0,
                phone_type="SOFT_PHONE",
            ))
        ```
        <!--End PulumiCodeChooser -->

        ### With multiple Security profile ids specified in security_profile_ids

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.connect.User("example",
            instance_id=example_aws_connect_instance["id"],
            name="example",
            password="Password123",
            routing_profile_id=example_aws_connect_routing_profile["routingProfileId"],
            security_profile_ids=[
                example_aws_connect_security_profile["securityProfileId"],
                example2["securityProfileId"],
            ],
            phone_config=aws.connect.UserPhoneConfigArgs(
                after_contact_work_time_limit=0,
                auto_accept=False,
                desk_phone_number="+112345678912",
                phone_type="DESK_PHONE",
            ))
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Amazon Connect Users using the `instance_id` and `user_id` separated by a colon (`:`). For example:

        ```sh
        $ pulumi import aws:connect/user:User example f1288a1f-6193-445a-b47e-af739b2:c1d4e5f6-1b3c-1b3c-1b3c-c1d4e5f6c1d4e5
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] directory_user_id: The identifier of the user account in the directory used for identity management. If Amazon Connect cannot access the directory, you can specify this identifier to authenticate users. If you include the identifier, we assume that Amazon Connect cannot access the directory. Otherwise, the identity information is used to authenticate users from your directory. This parameter is required if you are using an existing directory for identity management in Amazon Connect when Amazon Connect cannot access your directory to authenticate users. If you are using SAML for identity management and include this parameter, an error is returned.
        :param pulumi.Input[str] hierarchy_group_id: The identifier of the hierarchy group for the user.
        :param pulumi.Input[pulumi.InputType['UserIdentityInfoArgs']] identity_info: A block that contains information about the identity of the user. Documented below.
        :param pulumi.Input[str] instance_id: Specifies the identifier of the hosting Amazon Connect Instance.
        :param pulumi.Input[str] name: The user name for the account. For instances not using SAML for identity management, the user name can include up to 20 characters. If you are using SAML for identity management, the user name can include up to 64 characters from `[a-zA-Z0-9_-.\\@]+`.
        :param pulumi.Input[str] password: The password for the user account. A password is required if you are using Amazon Connect for identity management. Otherwise, it is an error to include a password.
        :param pulumi.Input[pulumi.InputType['UserPhoneConfigArgs']] phone_config: A block that contains information about the phone settings for the user. Documented below.
        :param pulumi.Input[str] routing_profile_id: The identifier of the routing profile for the user.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_profile_ids: A list of identifiers for the security profiles for the user. Specify a minimum of 1 and maximum of 10 security profile ids. For more information, see [Best Practices for Security Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-best-practices.html) in the Amazon Connect Administrator Guide.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tags to apply to the user. If configured with a provider
               `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Amazon Connect User resource. For more information see
        [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)

        ## Example Usage

        ### Basic

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.connect.User("example",
            instance_id=example_aws_connect_instance["id"],
            name="example",
            password="Password123",
            routing_profile_id=example_aws_connect_routing_profile["routingProfileId"],
            security_profile_ids=[example_aws_connect_security_profile["securityProfileId"]],
            identity_info=aws.connect.UserIdentityInfoArgs(
                first_name="example",
                last_name="example2",
            ),
            phone_config=aws.connect.UserPhoneConfigArgs(
                after_contact_work_time_limit=0,
                phone_type="SOFT_PHONE",
            ))
        ```
        <!--End PulumiCodeChooser -->

        ### With hierarchy_group_id

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.connect.User("example",
            instance_id=example_aws_connect_instance["id"],
            name="example",
            password="Password123",
            routing_profile_id=example_aws_connect_routing_profile["routingProfileId"],
            hierarchy_group_id=example_aws_connect_user_hierarchy_group["hierarchyGroupId"],
            security_profile_ids=[example_aws_connect_security_profile["securityProfileId"]],
            identity_info=aws.connect.UserIdentityInfoArgs(
                first_name="example",
                last_name="example2",
            ),
            phone_config=aws.connect.UserPhoneConfigArgs(
                after_contact_work_time_limit=0,
                phone_type="SOFT_PHONE",
            ))
        ```
        <!--End PulumiCodeChooser -->

        ### With identity_info filled

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.connect.User("example",
            instance_id=example_aws_connect_instance["id"],
            name="example",
            password="Password123",
            routing_profile_id=example_aws_connect_routing_profile["routingProfileId"],
            security_profile_ids=[example_aws_connect_security_profile["securityProfileId"]],
            identity_info=aws.connect.UserIdentityInfoArgs(
                email="example@example.com",
                first_name="example",
                last_name="example2",
            ),
            phone_config=aws.connect.UserPhoneConfigArgs(
                after_contact_work_time_limit=0,
                phone_type="SOFT_PHONE",
            ))
        ```
        <!--End PulumiCodeChooser -->

        ### With phone_config phone type as desk phone

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.connect.User("example",
            instance_id=example_aws_connect_instance["id"],
            name="example",
            password="Password123",
            routing_profile_id=example_aws_connect_routing_profile["routingProfileId"],
            security_profile_ids=[example_aws_connect_security_profile["securityProfileId"]],
            phone_config=aws.connect.UserPhoneConfigArgs(
                after_contact_work_time_limit=0,
                phone_type="SOFT_PHONE",
            ))
        ```
        <!--End PulumiCodeChooser -->

        ### With multiple Security profile ids specified in security_profile_ids

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.connect.User("example",
            instance_id=example_aws_connect_instance["id"],
            name="example",
            password="Password123",
            routing_profile_id=example_aws_connect_routing_profile["routingProfileId"],
            security_profile_ids=[
                example_aws_connect_security_profile["securityProfileId"],
                example2["securityProfileId"],
            ],
            phone_config=aws.connect.UserPhoneConfigArgs(
                after_contact_work_time_limit=0,
                auto_accept=False,
                desk_phone_number="+112345678912",
                phone_type="DESK_PHONE",
            ))
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Amazon Connect Users using the `instance_id` and `user_id` separated by a colon (`:`). For example:

        ```sh
        $ pulumi import aws:connect/user:User example f1288a1f-6193-445a-b47e-af739b2:c1d4e5f6-1b3c-1b3c-1b3c-c1d4e5f6c1d4e5
        ```

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 directory_user_id: Optional[pulumi.Input[str]] = None,
                 hierarchy_group_id: Optional[pulumi.Input[str]] = None,
                 identity_info: Optional[pulumi.Input[pulumi.InputType['UserIdentityInfoArgs']]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 phone_config: Optional[pulumi.Input[pulumi.InputType['UserPhoneConfigArgs']]] = None,
                 routing_profile_id: Optional[pulumi.Input[str]] = None,
                 security_profile_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            __props__.__dict__["directory_user_id"] = directory_user_id
            __props__.__dict__["hierarchy_group_id"] = hierarchy_group_id
            __props__.__dict__["identity_info"] = identity_info
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if phone_config is None and not opts.urn:
                raise TypeError("Missing required property 'phone_config'")
            __props__.__dict__["phone_config"] = phone_config
            if routing_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'routing_profile_id'")
            __props__.__dict__["routing_profile_id"] = routing_profile_id
            if security_profile_ids is None and not opts.urn:
                raise TypeError("Missing required property 'security_profile_ids'")
            __props__.__dict__["security_profile_ids"] = security_profile_ids
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["user_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(User, __self__).__init__(
            'aws:connect/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            directory_user_id: Optional[pulumi.Input[str]] = None,
            hierarchy_group_id: Optional[pulumi.Input[str]] = None,
            identity_info: Optional[pulumi.Input[pulumi.InputType['UserIdentityInfoArgs']]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            phone_config: Optional[pulumi.Input[pulumi.InputType['UserPhoneConfigArgs']]] = None,
            routing_profile_id: Optional[pulumi.Input[str]] = None,
            security_profile_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            user_id: Optional[pulumi.Input[str]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) of the user.
        :param pulumi.Input[str] directory_user_id: The identifier of the user account in the directory used for identity management. If Amazon Connect cannot access the directory, you can specify this identifier to authenticate users. If you include the identifier, we assume that Amazon Connect cannot access the directory. Otherwise, the identity information is used to authenticate users from your directory. This parameter is required if you are using an existing directory for identity management in Amazon Connect when Amazon Connect cannot access your directory to authenticate users. If you are using SAML for identity management and include this parameter, an error is returned.
        :param pulumi.Input[str] hierarchy_group_id: The identifier of the hierarchy group for the user.
        :param pulumi.Input[pulumi.InputType['UserIdentityInfoArgs']] identity_info: A block that contains information about the identity of the user. Documented below.
        :param pulumi.Input[str] instance_id: Specifies the identifier of the hosting Amazon Connect Instance.
        :param pulumi.Input[str] name: The user name for the account. For instances not using SAML for identity management, the user name can include up to 20 characters. If you are using SAML for identity management, the user name can include up to 64 characters from `[a-zA-Z0-9_-.\\@]+`.
        :param pulumi.Input[str] password: The password for the user account. A password is required if you are using Amazon Connect for identity management. Otherwise, it is an error to include a password.
        :param pulumi.Input[pulumi.InputType['UserPhoneConfigArgs']] phone_config: A block that contains information about the phone settings for the user. Documented below.
        :param pulumi.Input[str] routing_profile_id: The identifier of the routing profile for the user.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_profile_ids: A list of identifiers for the security profiles for the user. Specify a minimum of 1 and maximum of 10 security profile ids. For more information, see [Best Practices for Security Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-best-practices.html) in the Amazon Connect Administrator Guide.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tags to apply to the user. If configured with a provider
               `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] user_id: The identifier for the user.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["directory_user_id"] = directory_user_id
        __props__.__dict__["hierarchy_group_id"] = hierarchy_group_id
        __props__.__dict__["identity_info"] = identity_info
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["phone_config"] = phone_config
        __props__.__dict__["routing_profile_id"] = routing_profile_id
        __props__.__dict__["security_profile_ids"] = security_profile_ids
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["user_id"] = user_id
        return User(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the user.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="directoryUserId")
    def directory_user_id(self) -> pulumi.Output[str]:
        """
        The identifier of the user account in the directory used for identity management. If Amazon Connect cannot access the directory, you can specify this identifier to authenticate users. If you include the identifier, we assume that Amazon Connect cannot access the directory. Otherwise, the identity information is used to authenticate users from your directory. This parameter is required if you are using an existing directory for identity management in Amazon Connect when Amazon Connect cannot access your directory to authenticate users. If you are using SAML for identity management and include this parameter, an error is returned.
        """
        return pulumi.get(self, "directory_user_id")

    @property
    @pulumi.getter(name="hierarchyGroupId")
    def hierarchy_group_id(self) -> pulumi.Output[Optional[str]]:
        """
        The identifier of the hierarchy group for the user.
        """
        return pulumi.get(self, "hierarchy_group_id")

    @property
    @pulumi.getter(name="identityInfo")
    def identity_info(self) -> pulumi.Output[Optional['outputs.UserIdentityInfo']]:
        """
        A block that contains information about the identity of the user. Documented below.
        """
        return pulumi.get(self, "identity_info")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        Specifies the identifier of the hosting Amazon Connect Instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The user name for the account. For instances not using SAML for identity management, the user name can include up to 20 characters. If you are using SAML for identity management, the user name can include up to 64 characters from `[a-zA-Z0-9_-.\\@]+`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        The password for the user account. A password is required if you are using Amazon Connect for identity management. Otherwise, it is an error to include a password.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="phoneConfig")
    def phone_config(self) -> pulumi.Output['outputs.UserPhoneConfig']:
        """
        A block that contains information about the phone settings for the user. Documented below.
        """
        return pulumi.get(self, "phone_config")

    @property
    @pulumi.getter(name="routingProfileId")
    def routing_profile_id(self) -> pulumi.Output[str]:
        """
        The identifier of the routing profile for the user.
        """
        return pulumi.get(self, "routing_profile_id")

    @property
    @pulumi.getter(name="securityProfileIds")
    def security_profile_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of identifiers for the security profiles for the user. Specify a minimum of 1 and maximum of 10 security profile ids. For more information, see [Best Practices for Security Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-best-practices.html) in the Amazon Connect Administrator Guide.
        """
        return pulumi.get(self, "security_profile_ids")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Tags to apply to the user. If configured with a provider
        `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        """
        The identifier for the user.
        """
        return pulumi.get(self, "user_id")

