# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'DomainMatchingArgs',
    'DomainMatchingAutoMergingArgs',
    'DomainMatchingAutoMergingConflictResolutionArgs',
    'DomainMatchingAutoMergingConsolidationArgs',
    'DomainMatchingExportingConfigArgs',
    'DomainMatchingExportingConfigS3ExportingArgs',
    'DomainMatchingJobScheduleArgs',
    'DomainRuleBasedMatchingArgs',
    'DomainRuleBasedMatchingAttributeTypesSelectorArgs',
    'DomainRuleBasedMatchingConflictResolutionArgs',
    'DomainRuleBasedMatchingExportingConfigArgs',
    'DomainRuleBasedMatchingExportingConfigS3ExportingArgs',
    'DomainRuleBasedMatchingMatchingRuleArgs',
    'ProfileAddressArgs',
    'ProfileBillingAddressArgs',
    'ProfileMailingAddressArgs',
    'ProfileShippingAddressArgs',
]

@pulumi.input_type
class DomainMatchingArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 auto_merging: Optional[pulumi.Input['DomainMatchingAutoMergingArgs']] = None,
                 exporting_config: Optional[pulumi.Input['DomainMatchingExportingConfigArgs']] = None,
                 job_schedule: Optional[pulumi.Input['DomainMatchingJobScheduleArgs']] = None):
        """
        :param pulumi.Input[bool] enabled: The flag that enables the matching process of duplicate profiles.
        :param pulumi.Input['DomainMatchingAutoMergingArgs'] auto_merging: A block that specifies the configuration about the auto-merging process. Documented below.
        :param pulumi.Input['DomainMatchingExportingConfigArgs'] exporting_config: A block that specifies the configuration for exporting Identity Resolution results. Documented below.
        :param pulumi.Input['DomainMatchingJobScheduleArgs'] job_schedule: A block that specifies the day and time when you want to start the Identity Resolution Job every week. Documented below.
        """
        pulumi.set(__self__, "enabled", enabled)
        if auto_merging is not None:
            pulumi.set(__self__, "auto_merging", auto_merging)
        if exporting_config is not None:
            pulumi.set(__self__, "exporting_config", exporting_config)
        if job_schedule is not None:
            pulumi.set(__self__, "job_schedule", job_schedule)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        The flag that enables the matching process of duplicate profiles.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="autoMerging")
    def auto_merging(self) -> Optional[pulumi.Input['DomainMatchingAutoMergingArgs']]:
        """
        A block that specifies the configuration about the auto-merging process. Documented below.
        """
        return pulumi.get(self, "auto_merging")

    @auto_merging.setter
    def auto_merging(self, value: Optional[pulumi.Input['DomainMatchingAutoMergingArgs']]):
        pulumi.set(self, "auto_merging", value)

    @property
    @pulumi.getter(name="exportingConfig")
    def exporting_config(self) -> Optional[pulumi.Input['DomainMatchingExportingConfigArgs']]:
        """
        A block that specifies the configuration for exporting Identity Resolution results. Documented below.
        """
        return pulumi.get(self, "exporting_config")

    @exporting_config.setter
    def exporting_config(self, value: Optional[pulumi.Input['DomainMatchingExportingConfigArgs']]):
        pulumi.set(self, "exporting_config", value)

    @property
    @pulumi.getter(name="jobSchedule")
    def job_schedule(self) -> Optional[pulumi.Input['DomainMatchingJobScheduleArgs']]:
        """
        A block that specifies the day and time when you want to start the Identity Resolution Job every week. Documented below.
        """
        return pulumi.get(self, "job_schedule")

    @job_schedule.setter
    def job_schedule(self, value: Optional[pulumi.Input['DomainMatchingJobScheduleArgs']]):
        pulumi.set(self, "job_schedule", value)


@pulumi.input_type
class DomainMatchingAutoMergingArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 conflict_resolution: Optional[pulumi.Input['DomainMatchingAutoMergingConflictResolutionArgs']] = None,
                 consolidation: Optional[pulumi.Input['DomainMatchingAutoMergingConsolidationArgs']] = None,
                 min_allowed_confidence_score_for_merging: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[bool] enabled: The flag that enables the auto-merging of duplicate profiles.
        :param pulumi.Input['DomainMatchingAutoMergingConflictResolutionArgs'] conflict_resolution: A block that specifies how the auto-merging process should resolve conflicts between different profiles. Documented below.
        :param pulumi.Input['DomainMatchingAutoMergingConsolidationArgs'] consolidation: A block that specifies a list of matching attributes that represent matching criteria. If two profiles meet at least one of the requirements in the matching attributes list, they will be merged. Documented below.
               * `min_allowed_confidence_score_for_merging ` - (Optional) A number between 0 and 1 that represents the minimum confidence score required for profiles within a matching group to be merged during the auto-merge process. A higher score means higher similarity required to merge profiles.
        """
        pulumi.set(__self__, "enabled", enabled)
        if conflict_resolution is not None:
            pulumi.set(__self__, "conflict_resolution", conflict_resolution)
        if consolidation is not None:
            pulumi.set(__self__, "consolidation", consolidation)
        if min_allowed_confidence_score_for_merging is not None:
            pulumi.set(__self__, "min_allowed_confidence_score_for_merging", min_allowed_confidence_score_for_merging)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        The flag that enables the auto-merging of duplicate profiles.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="conflictResolution")
    def conflict_resolution(self) -> Optional[pulumi.Input['DomainMatchingAutoMergingConflictResolutionArgs']]:
        """
        A block that specifies how the auto-merging process should resolve conflicts between different profiles. Documented below.
        """
        return pulumi.get(self, "conflict_resolution")

    @conflict_resolution.setter
    def conflict_resolution(self, value: Optional[pulumi.Input['DomainMatchingAutoMergingConflictResolutionArgs']]):
        pulumi.set(self, "conflict_resolution", value)

    @property
    @pulumi.getter
    def consolidation(self) -> Optional[pulumi.Input['DomainMatchingAutoMergingConsolidationArgs']]:
        """
        A block that specifies a list of matching attributes that represent matching criteria. If two profiles meet at least one of the requirements in the matching attributes list, they will be merged. Documented below.
        * `min_allowed_confidence_score_for_merging ` - (Optional) A number between 0 and 1 that represents the minimum confidence score required for profiles within a matching group to be merged during the auto-merge process. A higher score means higher similarity required to merge profiles.
        """
        return pulumi.get(self, "consolidation")

    @consolidation.setter
    def consolidation(self, value: Optional[pulumi.Input['DomainMatchingAutoMergingConsolidationArgs']]):
        pulumi.set(self, "consolidation", value)

    @property
    @pulumi.getter(name="minAllowedConfidenceScoreForMerging")
    def min_allowed_confidence_score_for_merging(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "min_allowed_confidence_score_for_merging")

    @min_allowed_confidence_score_for_merging.setter
    def min_allowed_confidence_score_for_merging(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "min_allowed_confidence_score_for_merging", value)


@pulumi.input_type
class DomainMatchingAutoMergingConflictResolutionArgs:
    def __init__(__self__, *,
                 conflict_resolving_model: pulumi.Input[str],
                 source_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] conflict_resolving_model: How the auto-merging process should resolve conflicts between different profiles. Valid values are `RECENCY` and `SOURCE`
        :param pulumi.Input[str] source_name: The `ObjectType` name that is used to resolve profile merging conflicts when choosing `SOURCE` as the `ConflictResolvingModel`.
        """
        pulumi.set(__self__, "conflict_resolving_model", conflict_resolving_model)
        if source_name is not None:
            pulumi.set(__self__, "source_name", source_name)

    @property
    @pulumi.getter(name="conflictResolvingModel")
    def conflict_resolving_model(self) -> pulumi.Input[str]:
        """
        How the auto-merging process should resolve conflicts between different profiles. Valid values are `RECENCY` and `SOURCE`
        """
        return pulumi.get(self, "conflict_resolving_model")

    @conflict_resolving_model.setter
    def conflict_resolving_model(self, value: pulumi.Input[str]):
        pulumi.set(self, "conflict_resolving_model", value)

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> Optional[pulumi.Input[str]]:
        """
        The `ObjectType` name that is used to resolve profile merging conflicts when choosing `SOURCE` as the `ConflictResolvingModel`.
        """
        return pulumi.get(self, "source_name")

    @source_name.setter
    def source_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_name", value)


@pulumi.input_type
class DomainMatchingAutoMergingConsolidationArgs:
    def __init__(__self__, *,
                 matching_attributes_lists: pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]] matching_attributes_lists: A list of matching criteria.
        """
        pulumi.set(__self__, "matching_attributes_lists", matching_attributes_lists)

    @property
    @pulumi.getter(name="matchingAttributesLists")
    def matching_attributes_lists(self) -> pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]]:
        """
        A list of matching criteria.
        """
        return pulumi.get(self, "matching_attributes_lists")

    @matching_attributes_lists.setter
    def matching_attributes_lists(self, value: pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[str]]]]]):
        pulumi.set(self, "matching_attributes_lists", value)


@pulumi.input_type
class DomainMatchingExportingConfigArgs:
    def __init__(__self__, *,
                 s3_exporting: Optional[pulumi.Input['DomainMatchingExportingConfigS3ExportingArgs']] = None):
        if s3_exporting is not None:
            pulumi.set(__self__, "s3_exporting", s3_exporting)

    @property
    @pulumi.getter(name="s3Exporting")
    def s3_exporting(self) -> Optional[pulumi.Input['DomainMatchingExportingConfigS3ExportingArgs']]:
        return pulumi.get(self, "s3_exporting")

    @s3_exporting.setter
    def s3_exporting(self, value: Optional[pulumi.Input['DomainMatchingExportingConfigS3ExportingArgs']]):
        pulumi.set(self, "s3_exporting", value)


@pulumi.input_type
class DomainMatchingExportingConfigS3ExportingArgs:
    def __init__(__self__, *,
                 s3_bucket_name: pulumi.Input[str],
                 s3_key_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] s3_bucket_name: The name of the S3 bucket where Identity Resolution Jobs write result files.
        :param pulumi.Input[str] s3_key_name: The S3 key name of the location where Identity Resolution Jobs write result files.
        """
        pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        if s3_key_name is not None:
            pulumi.set(__self__, "s3_key_name", s3_key_name)

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> pulumi.Input[str]:
        """
        The name of the S3 bucket where Identity Resolution Jobs write result files.
        """
        return pulumi.get(self, "s3_bucket_name")

    @s3_bucket_name.setter
    def s3_bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "s3_bucket_name", value)

    @property
    @pulumi.getter(name="s3KeyName")
    def s3_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The S3 key name of the location where Identity Resolution Jobs write result files.
        """
        return pulumi.get(self, "s3_key_name")

    @s3_key_name.setter
    def s3_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_key_name", value)


@pulumi.input_type
class DomainMatchingJobScheduleArgs:
    def __init__(__self__, *,
                 day_of_the_week: pulumi.Input[str],
                 time: pulumi.Input[str]):
        """
        :param pulumi.Input[str] day_of_the_week: The day when the Identity Resolution Job should run every week.
        :param pulumi.Input[str] time: The time when the Identity Resolution Job should run every week.
        """
        pulumi.set(__self__, "day_of_the_week", day_of_the_week)
        pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter(name="dayOfTheWeek")
    def day_of_the_week(self) -> pulumi.Input[str]:
        """
        The day when the Identity Resolution Job should run every week.
        """
        return pulumi.get(self, "day_of_the_week")

    @day_of_the_week.setter
    def day_of_the_week(self, value: pulumi.Input[str]):
        pulumi.set(self, "day_of_the_week", value)

    @property
    @pulumi.getter
    def time(self) -> pulumi.Input[str]:
        """
        The time when the Identity Resolution Job should run every week.
        """
        return pulumi.get(self, "time")

    @time.setter
    def time(self, value: pulumi.Input[str]):
        pulumi.set(self, "time", value)


@pulumi.input_type
class DomainRuleBasedMatchingArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 attribute_types_selector: Optional[pulumi.Input['DomainRuleBasedMatchingAttributeTypesSelectorArgs']] = None,
                 conflict_resolution: Optional[pulumi.Input['DomainRuleBasedMatchingConflictResolutionArgs']] = None,
                 exporting_config: Optional[pulumi.Input['DomainRuleBasedMatchingExportingConfigArgs']] = None,
                 matching_rules: Optional[pulumi.Input[Sequence[pulumi.Input['DomainRuleBasedMatchingMatchingRuleArgs']]]] = None,
                 max_allowed_rule_level_for_matching: Optional[pulumi.Input[int]] = None,
                 max_allowed_rule_level_for_merging: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] enabled: The flag that enables the rule-based matching process of duplicate profiles.
        :param pulumi.Input['DomainRuleBasedMatchingAttributeTypesSelectorArgs'] attribute_types_selector: A block that configures information about the `AttributeTypesSelector` where the rule-based identity resolution uses to match profiles. Documented below.
        :param pulumi.Input['DomainRuleBasedMatchingConflictResolutionArgs'] conflict_resolution: A block that specifies how the auto-merging process should resolve conflicts between different profiles. Documented below.
        :param pulumi.Input['DomainRuleBasedMatchingExportingConfigArgs'] exporting_config: A block that specifies the configuration for exporting Identity Resolution results. Documented below.
        :param pulumi.Input[Sequence[pulumi.Input['DomainRuleBasedMatchingMatchingRuleArgs']]] matching_rules: A block that configures how the rule-based matching process should match profiles. You can have up to 15 `rule` in the `natching_rules`. Documented below.
        :param pulumi.Input[int] max_allowed_rule_level_for_matching: Indicates the maximum allowed rule level for matching.
        :param pulumi.Input[int] max_allowed_rule_level_for_merging: Indicates the maximum allowed rule level for merging.
        """
        pulumi.set(__self__, "enabled", enabled)
        if attribute_types_selector is not None:
            pulumi.set(__self__, "attribute_types_selector", attribute_types_selector)
        if conflict_resolution is not None:
            pulumi.set(__self__, "conflict_resolution", conflict_resolution)
        if exporting_config is not None:
            pulumi.set(__self__, "exporting_config", exporting_config)
        if matching_rules is not None:
            pulumi.set(__self__, "matching_rules", matching_rules)
        if max_allowed_rule_level_for_matching is not None:
            pulumi.set(__self__, "max_allowed_rule_level_for_matching", max_allowed_rule_level_for_matching)
        if max_allowed_rule_level_for_merging is not None:
            pulumi.set(__self__, "max_allowed_rule_level_for_merging", max_allowed_rule_level_for_merging)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        The flag that enables the rule-based matching process of duplicate profiles.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="attributeTypesSelector")
    def attribute_types_selector(self) -> Optional[pulumi.Input['DomainRuleBasedMatchingAttributeTypesSelectorArgs']]:
        """
        A block that configures information about the `AttributeTypesSelector` where the rule-based identity resolution uses to match profiles. Documented below.
        """
        return pulumi.get(self, "attribute_types_selector")

    @attribute_types_selector.setter
    def attribute_types_selector(self, value: Optional[pulumi.Input['DomainRuleBasedMatchingAttributeTypesSelectorArgs']]):
        pulumi.set(self, "attribute_types_selector", value)

    @property
    @pulumi.getter(name="conflictResolution")
    def conflict_resolution(self) -> Optional[pulumi.Input['DomainRuleBasedMatchingConflictResolutionArgs']]:
        """
        A block that specifies how the auto-merging process should resolve conflicts between different profiles. Documented below.
        """
        return pulumi.get(self, "conflict_resolution")

    @conflict_resolution.setter
    def conflict_resolution(self, value: Optional[pulumi.Input['DomainRuleBasedMatchingConflictResolutionArgs']]):
        pulumi.set(self, "conflict_resolution", value)

    @property
    @pulumi.getter(name="exportingConfig")
    def exporting_config(self) -> Optional[pulumi.Input['DomainRuleBasedMatchingExportingConfigArgs']]:
        """
        A block that specifies the configuration for exporting Identity Resolution results. Documented below.
        """
        return pulumi.get(self, "exporting_config")

    @exporting_config.setter
    def exporting_config(self, value: Optional[pulumi.Input['DomainRuleBasedMatchingExportingConfigArgs']]):
        pulumi.set(self, "exporting_config", value)

    @property
    @pulumi.getter(name="matchingRules")
    def matching_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainRuleBasedMatchingMatchingRuleArgs']]]]:
        """
        A block that configures how the rule-based matching process should match profiles. You can have up to 15 `rule` in the `natching_rules`. Documented below.
        """
        return pulumi.get(self, "matching_rules")

    @matching_rules.setter
    def matching_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainRuleBasedMatchingMatchingRuleArgs']]]]):
        pulumi.set(self, "matching_rules", value)

    @property
    @pulumi.getter(name="maxAllowedRuleLevelForMatching")
    def max_allowed_rule_level_for_matching(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates the maximum allowed rule level for matching.
        """
        return pulumi.get(self, "max_allowed_rule_level_for_matching")

    @max_allowed_rule_level_for_matching.setter
    def max_allowed_rule_level_for_matching(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_allowed_rule_level_for_matching", value)

    @property
    @pulumi.getter(name="maxAllowedRuleLevelForMerging")
    def max_allowed_rule_level_for_merging(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates the maximum allowed rule level for merging.
        """
        return pulumi.get(self, "max_allowed_rule_level_for_merging")

    @max_allowed_rule_level_for_merging.setter
    def max_allowed_rule_level_for_merging(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_allowed_rule_level_for_merging", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class DomainRuleBasedMatchingAttributeTypesSelectorArgs:
    def __init__(__self__, *,
                 attribute_matching_model: pulumi.Input[str],
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 email_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 phone_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] attribute_matching_model: Configures the `AttributeMatchingModel`, you can either choose `ONE_TO_ONE` or `MANY_TO_MANY`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] addresses: The `Address` type. You can choose from `Address`, `BusinessAddress`, `MaillingAddress`, and `ShippingAddress`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] email_addresses: The `Email` type. You can choose from `EmailAddress`, `BusinessEmailAddress` and `PersonalEmailAddress`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] phone_numbers: The `PhoneNumber` type. You can choose from `PhoneNumber`, `HomePhoneNumber`, and `MobilePhoneNumber`.
        """
        pulumi.set(__self__, "attribute_matching_model", attribute_matching_model)
        if addresses is not None:
            pulumi.set(__self__, "addresses", addresses)
        if email_addresses is not None:
            pulumi.set(__self__, "email_addresses", email_addresses)
        if phone_numbers is not None:
            pulumi.set(__self__, "phone_numbers", phone_numbers)

    @property
    @pulumi.getter(name="attributeMatchingModel")
    def attribute_matching_model(self) -> pulumi.Input[str]:
        """
        Configures the `AttributeMatchingModel`, you can either choose `ONE_TO_ONE` or `MANY_TO_MANY`.
        """
        return pulumi.get(self, "attribute_matching_model")

    @attribute_matching_model.setter
    def attribute_matching_model(self, value: pulumi.Input[str]):
        pulumi.set(self, "attribute_matching_model", value)

    @property
    @pulumi.getter
    def addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The `Address` type. You can choose from `Address`, `BusinessAddress`, `MaillingAddress`, and `ShippingAddress`.
        """
        return pulumi.get(self, "addresses")

    @addresses.setter
    def addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "addresses", value)

    @property
    @pulumi.getter(name="emailAddresses")
    def email_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The `Email` type. You can choose from `EmailAddress`, `BusinessEmailAddress` and `PersonalEmailAddress`.
        """
        return pulumi.get(self, "email_addresses")

    @email_addresses.setter
    def email_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "email_addresses", value)

    @property
    @pulumi.getter(name="phoneNumbers")
    def phone_numbers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The `PhoneNumber` type. You can choose from `PhoneNumber`, `HomePhoneNumber`, and `MobilePhoneNumber`.
        """
        return pulumi.get(self, "phone_numbers")

    @phone_numbers.setter
    def phone_numbers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "phone_numbers", value)


@pulumi.input_type
class DomainRuleBasedMatchingConflictResolutionArgs:
    def __init__(__self__, *,
                 conflict_resolving_model: pulumi.Input[str],
                 source_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] conflict_resolving_model: How the auto-merging process should resolve conflicts between different profiles. Valid values are `RECENCY` and `SOURCE`
        :param pulumi.Input[str] source_name: The `ObjectType` name that is used to resolve profile merging conflicts when choosing `SOURCE` as the `ConflictResolvingModel`.
        """
        pulumi.set(__self__, "conflict_resolving_model", conflict_resolving_model)
        if source_name is not None:
            pulumi.set(__self__, "source_name", source_name)

    @property
    @pulumi.getter(name="conflictResolvingModel")
    def conflict_resolving_model(self) -> pulumi.Input[str]:
        """
        How the auto-merging process should resolve conflicts between different profiles. Valid values are `RECENCY` and `SOURCE`
        """
        return pulumi.get(self, "conflict_resolving_model")

    @conflict_resolving_model.setter
    def conflict_resolving_model(self, value: pulumi.Input[str]):
        pulumi.set(self, "conflict_resolving_model", value)

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> Optional[pulumi.Input[str]]:
        """
        The `ObjectType` name that is used to resolve profile merging conflicts when choosing `SOURCE` as the `ConflictResolvingModel`.
        """
        return pulumi.get(self, "source_name")

    @source_name.setter
    def source_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_name", value)


@pulumi.input_type
class DomainRuleBasedMatchingExportingConfigArgs:
    def __init__(__self__, *,
                 s3_exporting: Optional[pulumi.Input['DomainRuleBasedMatchingExportingConfigS3ExportingArgs']] = None):
        if s3_exporting is not None:
            pulumi.set(__self__, "s3_exporting", s3_exporting)

    @property
    @pulumi.getter(name="s3Exporting")
    def s3_exporting(self) -> Optional[pulumi.Input['DomainRuleBasedMatchingExportingConfigS3ExportingArgs']]:
        return pulumi.get(self, "s3_exporting")

    @s3_exporting.setter
    def s3_exporting(self, value: Optional[pulumi.Input['DomainRuleBasedMatchingExportingConfigS3ExportingArgs']]):
        pulumi.set(self, "s3_exporting", value)


@pulumi.input_type
class DomainRuleBasedMatchingExportingConfigS3ExportingArgs:
    def __init__(__self__, *,
                 s3_bucket_name: pulumi.Input[str],
                 s3_key_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] s3_bucket_name: The name of the S3 bucket where Identity Resolution Jobs write result files.
        :param pulumi.Input[str] s3_key_name: The S3 key name of the location where Identity Resolution Jobs write result files.
        """
        pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        if s3_key_name is not None:
            pulumi.set(__self__, "s3_key_name", s3_key_name)

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> pulumi.Input[str]:
        """
        The name of the S3 bucket where Identity Resolution Jobs write result files.
        """
        return pulumi.get(self, "s3_bucket_name")

    @s3_bucket_name.setter
    def s3_bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "s3_bucket_name", value)

    @property
    @pulumi.getter(name="s3KeyName")
    def s3_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The S3 key name of the location where Identity Resolution Jobs write result files.
        """
        return pulumi.get(self, "s3_key_name")

    @s3_key_name.setter
    def s3_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_key_name", value)


@pulumi.input_type
class DomainRuleBasedMatchingMatchingRuleArgs:
    def __init__(__self__, *,
                 rules: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rules: A single rule level of the `match_rules`. Configures how the rule-based matching process should match profiles.
        """
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A single rule level of the `match_rules`. Configures how the rule-based matching process should match profiles.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class ProfileAddressArgs:
    def __init__(__self__, *,
                 address1: Optional[pulumi.Input[str]] = None,
                 address2: Optional[pulumi.Input[str]] = None,
                 address3: Optional[pulumi.Input[str]] = None,
                 address4: Optional[pulumi.Input[str]] = None,
                 city: Optional[pulumi.Input[str]] = None,
                 country: Optional[pulumi.Input[str]] = None,
                 county: Optional[pulumi.Input[str]] = None,
                 postal_code: Optional[pulumi.Input[str]] = None,
                 province: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] address1: The first line of a customer address.
        :param pulumi.Input[str] address2: The second line of a customer address.
        :param pulumi.Input[str] address3: The third line of a customer address.
        :param pulumi.Input[str] address4: The fourth line of a customer address.
        :param pulumi.Input[str] city: The city in which a customer lives.
        :param pulumi.Input[str] country: The country in which a customer lives.
        :param pulumi.Input[str] county: The county in which a customer lives.
        :param pulumi.Input[str] postal_code: The postal code of a customer address.
        :param pulumi.Input[str] province: The province in which a customer lives.
        :param pulumi.Input[str] state: The state in which a customer lives.
        """
        if address1 is not None:
            pulumi.set(__self__, "address1", address1)
        if address2 is not None:
            pulumi.set(__self__, "address2", address2)
        if address3 is not None:
            pulumi.set(__self__, "address3", address3)
        if address4 is not None:
            pulumi.set(__self__, "address4", address4)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if county is not None:
            pulumi.set(__self__, "county", county)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if province is not None:
            pulumi.set(__self__, "province", province)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def address1(self) -> Optional[pulumi.Input[str]]:
        """
        The first line of a customer address.
        """
        return pulumi.get(self, "address1")

    @address1.setter
    def address1(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address1", value)

    @property
    @pulumi.getter
    def address2(self) -> Optional[pulumi.Input[str]]:
        """
        The second line of a customer address.
        """
        return pulumi.get(self, "address2")

    @address2.setter
    def address2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address2", value)

    @property
    @pulumi.getter
    def address3(self) -> Optional[pulumi.Input[str]]:
        """
        The third line of a customer address.
        """
        return pulumi.get(self, "address3")

    @address3.setter
    def address3(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address3", value)

    @property
    @pulumi.getter
    def address4(self) -> Optional[pulumi.Input[str]]:
        """
        The fourth line of a customer address.
        """
        return pulumi.get(self, "address4")

    @address4.setter
    def address4(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address4", value)

    @property
    @pulumi.getter
    def city(self) -> Optional[pulumi.Input[str]]:
        """
        The city in which a customer lives.
        """
        return pulumi.get(self, "city")

    @city.setter
    def city(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "city", value)

    @property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[str]]:
        """
        The country in which a customer lives.
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter
    def county(self) -> Optional[pulumi.Input[str]]:
        """
        The county in which a customer lives.
        """
        return pulumi.get(self, "county")

    @county.setter
    def county(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "county", value)

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[pulumi.Input[str]]:
        """
        The postal code of a customer address.
        """
        return pulumi.get(self, "postal_code")

    @postal_code.setter
    def postal_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "postal_code", value)

    @property
    @pulumi.getter
    def province(self) -> Optional[pulumi.Input[str]]:
        """
        The province in which a customer lives.
        """
        return pulumi.get(self, "province")

    @province.setter
    def province(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "province", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state in which a customer lives.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class ProfileBillingAddressArgs:
    def __init__(__self__, *,
                 address1: Optional[pulumi.Input[str]] = None,
                 address2: Optional[pulumi.Input[str]] = None,
                 address3: Optional[pulumi.Input[str]] = None,
                 address4: Optional[pulumi.Input[str]] = None,
                 city: Optional[pulumi.Input[str]] = None,
                 country: Optional[pulumi.Input[str]] = None,
                 county: Optional[pulumi.Input[str]] = None,
                 postal_code: Optional[pulumi.Input[str]] = None,
                 province: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] address1: The first line of a customer address.
        :param pulumi.Input[str] address2: The second line of a customer address.
        :param pulumi.Input[str] address3: The third line of a customer address.
        :param pulumi.Input[str] address4: The fourth line of a customer address.
        :param pulumi.Input[str] city: The city in which a customer lives.
        :param pulumi.Input[str] country: The country in which a customer lives.
        :param pulumi.Input[str] county: The county in which a customer lives.
        :param pulumi.Input[str] postal_code: The postal code of a customer address.
        :param pulumi.Input[str] province: The province in which a customer lives.
        :param pulumi.Input[str] state: The state in which a customer lives.
        """
        if address1 is not None:
            pulumi.set(__self__, "address1", address1)
        if address2 is not None:
            pulumi.set(__self__, "address2", address2)
        if address3 is not None:
            pulumi.set(__self__, "address3", address3)
        if address4 is not None:
            pulumi.set(__self__, "address4", address4)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if county is not None:
            pulumi.set(__self__, "county", county)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if province is not None:
            pulumi.set(__self__, "province", province)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def address1(self) -> Optional[pulumi.Input[str]]:
        """
        The first line of a customer address.
        """
        return pulumi.get(self, "address1")

    @address1.setter
    def address1(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address1", value)

    @property
    @pulumi.getter
    def address2(self) -> Optional[pulumi.Input[str]]:
        """
        The second line of a customer address.
        """
        return pulumi.get(self, "address2")

    @address2.setter
    def address2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address2", value)

    @property
    @pulumi.getter
    def address3(self) -> Optional[pulumi.Input[str]]:
        """
        The third line of a customer address.
        """
        return pulumi.get(self, "address3")

    @address3.setter
    def address3(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address3", value)

    @property
    @pulumi.getter
    def address4(self) -> Optional[pulumi.Input[str]]:
        """
        The fourth line of a customer address.
        """
        return pulumi.get(self, "address4")

    @address4.setter
    def address4(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address4", value)

    @property
    @pulumi.getter
    def city(self) -> Optional[pulumi.Input[str]]:
        """
        The city in which a customer lives.
        """
        return pulumi.get(self, "city")

    @city.setter
    def city(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "city", value)

    @property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[str]]:
        """
        The country in which a customer lives.
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter
    def county(self) -> Optional[pulumi.Input[str]]:
        """
        The county in which a customer lives.
        """
        return pulumi.get(self, "county")

    @county.setter
    def county(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "county", value)

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[pulumi.Input[str]]:
        """
        The postal code of a customer address.
        """
        return pulumi.get(self, "postal_code")

    @postal_code.setter
    def postal_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "postal_code", value)

    @property
    @pulumi.getter
    def province(self) -> Optional[pulumi.Input[str]]:
        """
        The province in which a customer lives.
        """
        return pulumi.get(self, "province")

    @province.setter
    def province(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "province", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state in which a customer lives.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class ProfileMailingAddressArgs:
    def __init__(__self__, *,
                 address1: Optional[pulumi.Input[str]] = None,
                 address2: Optional[pulumi.Input[str]] = None,
                 address3: Optional[pulumi.Input[str]] = None,
                 address4: Optional[pulumi.Input[str]] = None,
                 city: Optional[pulumi.Input[str]] = None,
                 country: Optional[pulumi.Input[str]] = None,
                 county: Optional[pulumi.Input[str]] = None,
                 postal_code: Optional[pulumi.Input[str]] = None,
                 province: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] address1: The first line of a customer address.
        :param pulumi.Input[str] address2: The second line of a customer address.
        :param pulumi.Input[str] address3: The third line of a customer address.
        :param pulumi.Input[str] address4: The fourth line of a customer address.
        :param pulumi.Input[str] city: The city in which a customer lives.
        :param pulumi.Input[str] country: The country in which a customer lives.
        :param pulumi.Input[str] county: The county in which a customer lives.
        :param pulumi.Input[str] postal_code: The postal code of a customer address.
        :param pulumi.Input[str] province: The province in which a customer lives.
        :param pulumi.Input[str] state: The state in which a customer lives.
        """
        if address1 is not None:
            pulumi.set(__self__, "address1", address1)
        if address2 is not None:
            pulumi.set(__self__, "address2", address2)
        if address3 is not None:
            pulumi.set(__self__, "address3", address3)
        if address4 is not None:
            pulumi.set(__self__, "address4", address4)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if county is not None:
            pulumi.set(__self__, "county", county)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if province is not None:
            pulumi.set(__self__, "province", province)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def address1(self) -> Optional[pulumi.Input[str]]:
        """
        The first line of a customer address.
        """
        return pulumi.get(self, "address1")

    @address1.setter
    def address1(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address1", value)

    @property
    @pulumi.getter
    def address2(self) -> Optional[pulumi.Input[str]]:
        """
        The second line of a customer address.
        """
        return pulumi.get(self, "address2")

    @address2.setter
    def address2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address2", value)

    @property
    @pulumi.getter
    def address3(self) -> Optional[pulumi.Input[str]]:
        """
        The third line of a customer address.
        """
        return pulumi.get(self, "address3")

    @address3.setter
    def address3(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address3", value)

    @property
    @pulumi.getter
    def address4(self) -> Optional[pulumi.Input[str]]:
        """
        The fourth line of a customer address.
        """
        return pulumi.get(self, "address4")

    @address4.setter
    def address4(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address4", value)

    @property
    @pulumi.getter
    def city(self) -> Optional[pulumi.Input[str]]:
        """
        The city in which a customer lives.
        """
        return pulumi.get(self, "city")

    @city.setter
    def city(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "city", value)

    @property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[str]]:
        """
        The country in which a customer lives.
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter
    def county(self) -> Optional[pulumi.Input[str]]:
        """
        The county in which a customer lives.
        """
        return pulumi.get(self, "county")

    @county.setter
    def county(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "county", value)

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[pulumi.Input[str]]:
        """
        The postal code of a customer address.
        """
        return pulumi.get(self, "postal_code")

    @postal_code.setter
    def postal_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "postal_code", value)

    @property
    @pulumi.getter
    def province(self) -> Optional[pulumi.Input[str]]:
        """
        The province in which a customer lives.
        """
        return pulumi.get(self, "province")

    @province.setter
    def province(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "province", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state in which a customer lives.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class ProfileShippingAddressArgs:
    def __init__(__self__, *,
                 address1: Optional[pulumi.Input[str]] = None,
                 address2: Optional[pulumi.Input[str]] = None,
                 address3: Optional[pulumi.Input[str]] = None,
                 address4: Optional[pulumi.Input[str]] = None,
                 city: Optional[pulumi.Input[str]] = None,
                 country: Optional[pulumi.Input[str]] = None,
                 county: Optional[pulumi.Input[str]] = None,
                 postal_code: Optional[pulumi.Input[str]] = None,
                 province: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] address1: The first line of a customer address.
        :param pulumi.Input[str] address2: The second line of a customer address.
        :param pulumi.Input[str] address3: The third line of a customer address.
        :param pulumi.Input[str] address4: The fourth line of a customer address.
        :param pulumi.Input[str] city: The city in which a customer lives.
        :param pulumi.Input[str] country: The country in which a customer lives.
        :param pulumi.Input[str] county: The county in which a customer lives.
        :param pulumi.Input[str] postal_code: The postal code of a customer address.
        :param pulumi.Input[str] province: The province in which a customer lives.
        :param pulumi.Input[str] state: The state in which a customer lives.
        """
        if address1 is not None:
            pulumi.set(__self__, "address1", address1)
        if address2 is not None:
            pulumi.set(__self__, "address2", address2)
        if address3 is not None:
            pulumi.set(__self__, "address3", address3)
        if address4 is not None:
            pulumi.set(__self__, "address4", address4)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if county is not None:
            pulumi.set(__self__, "county", county)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if province is not None:
            pulumi.set(__self__, "province", province)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def address1(self) -> Optional[pulumi.Input[str]]:
        """
        The first line of a customer address.
        """
        return pulumi.get(self, "address1")

    @address1.setter
    def address1(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address1", value)

    @property
    @pulumi.getter
    def address2(self) -> Optional[pulumi.Input[str]]:
        """
        The second line of a customer address.
        """
        return pulumi.get(self, "address2")

    @address2.setter
    def address2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address2", value)

    @property
    @pulumi.getter
    def address3(self) -> Optional[pulumi.Input[str]]:
        """
        The third line of a customer address.
        """
        return pulumi.get(self, "address3")

    @address3.setter
    def address3(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address3", value)

    @property
    @pulumi.getter
    def address4(self) -> Optional[pulumi.Input[str]]:
        """
        The fourth line of a customer address.
        """
        return pulumi.get(self, "address4")

    @address4.setter
    def address4(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address4", value)

    @property
    @pulumi.getter
    def city(self) -> Optional[pulumi.Input[str]]:
        """
        The city in which a customer lives.
        """
        return pulumi.get(self, "city")

    @city.setter
    def city(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "city", value)

    @property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[str]]:
        """
        The country in which a customer lives.
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter
    def county(self) -> Optional[pulumi.Input[str]]:
        """
        The county in which a customer lives.
        """
        return pulumi.get(self, "county")

    @county.setter
    def county(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "county", value)

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[pulumi.Input[str]]:
        """
        The postal code of a customer address.
        """
        return pulumi.get(self, "postal_code")

    @postal_code.setter
    def postal_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "postal_code", value)

    @property
    @pulumi.getter
    def province(self) -> Optional[pulumi.Input[str]]:
        """
        The province in which a customer lives.
        """
        return pulumi.get(self, "province")

    @province.setter
    def province(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "province", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state in which a customer lives.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


