# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['InvitationAccepterArgs', 'InvitationAccepter']

@pulumi.input_type
class InvitationAccepterArgs:
    def __init__(__self__, *,
                 graph_arn: pulumi.Input[str]):
        """
        The set of arguments for constructing a InvitationAccepter resource.
        :param pulumi.Input[str] graph_arn: ARN of the behavior graph that the member account is accepting the invitation for.
        """
        pulumi.set(__self__, "graph_arn", graph_arn)

    @property
    @pulumi.getter(name="graphArn")
    def graph_arn(self) -> pulumi.Input[str]:
        """
        ARN of the behavior graph that the member account is accepting the invitation for.
        """
        return pulumi.get(self, "graph_arn")

    @graph_arn.setter
    def graph_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "graph_arn", value)


@pulumi.input_type
class _InvitationAccepterState:
    def __init__(__self__, *,
                 graph_arn: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering InvitationAccepter resources.
        :param pulumi.Input[str] graph_arn: ARN of the behavior graph that the member account is accepting the invitation for.
        """
        if graph_arn is not None:
            pulumi.set(__self__, "graph_arn", graph_arn)

    @property
    @pulumi.getter(name="graphArn")
    def graph_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the behavior graph that the member account is accepting the invitation for.
        """
        return pulumi.get(self, "graph_arn")

    @graph_arn.setter
    def graph_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "graph_arn", value)


class InvitationAccepter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 graph_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage an [Amazon Detective Invitation Accepter](https://docs.aws.amazon.com/detective/latest/APIReference/API_AcceptInvitation.html). Ensure that the accepter is configured to use the AWS account you wish to _accept_ the invitation from the primary graph owner account.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        primary = aws.detective.Graph("primary")
        primary_member = aws.detective.Member("primary",
            account_id="ACCOUNT ID",
            email_address="EMAIL",
            graph_arn=primary.id,
            message="Message of the invite")
        member = aws.detective.InvitationAccepter("member", graph_arn=primary.graph_arn)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import `aws_detective_invitation_accepter` using the graph ARN. For example:

        ```sh
        $ pulumi import aws:detective/invitationAccepter:InvitationAccepter example arn:aws:detective:us-east-1:123456789101:graph:231684d34gh74g4bae1dbc7bd807d02d
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] graph_arn: ARN of the behavior graph that the member account is accepting the invitation for.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InvitationAccepterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage an [Amazon Detective Invitation Accepter](https://docs.aws.amazon.com/detective/latest/APIReference/API_AcceptInvitation.html). Ensure that the accepter is configured to use the AWS account you wish to _accept_ the invitation from the primary graph owner account.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        primary = aws.detective.Graph("primary")
        primary_member = aws.detective.Member("primary",
            account_id="ACCOUNT ID",
            email_address="EMAIL",
            graph_arn=primary.id,
            message="Message of the invite")
        member = aws.detective.InvitationAccepter("member", graph_arn=primary.graph_arn)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import `aws_detective_invitation_accepter` using the graph ARN. For example:

        ```sh
        $ pulumi import aws:detective/invitationAccepter:InvitationAccepter example arn:aws:detective:us-east-1:123456789101:graph:231684d34gh74g4bae1dbc7bd807d02d
        ```

        :param str resource_name: The name of the resource.
        :param InvitationAccepterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InvitationAccepterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 graph_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InvitationAccepterArgs.__new__(InvitationAccepterArgs)

            if graph_arn is None and not opts.urn:
                raise TypeError("Missing required property 'graph_arn'")
            __props__.__dict__["graph_arn"] = graph_arn
        super(InvitationAccepter, __self__).__init__(
            'aws:detective/invitationAccepter:InvitationAccepter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            graph_arn: Optional[pulumi.Input[str]] = None) -> 'InvitationAccepter':
        """
        Get an existing InvitationAccepter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] graph_arn: ARN of the behavior graph that the member account is accepting the invitation for.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InvitationAccepterState.__new__(_InvitationAccepterState)

        __props__.__dict__["graph_arn"] = graph_arn
        return InvitationAccepter(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="graphArn")
    def graph_arn(self) -> pulumi.Output[str]:
        """
        ARN of the behavior graph that the member account is accepting the invitation for.
        """
        return pulumi.get(self, "graph_arn")

