# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetReplicationSubnetGroupResult',
    'AwaitableGetReplicationSubnetGroupResult',
    'get_replication_subnet_group',
    'get_replication_subnet_group_output',
]

@pulumi.output_type
class GetReplicationSubnetGroupResult:
    """
    A collection of values returned by getReplicationSubnetGroup.
    """
    def __init__(__self__, id=None, replication_subnet_group_arn=None, replication_subnet_group_description=None, replication_subnet_group_id=None, subnet_group_status=None, subnet_ids=None, tags=None, vpc_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if replication_subnet_group_arn and not isinstance(replication_subnet_group_arn, str):
            raise TypeError("Expected argument 'replication_subnet_group_arn' to be a str")
        pulumi.set(__self__, "replication_subnet_group_arn", replication_subnet_group_arn)
        if replication_subnet_group_description and not isinstance(replication_subnet_group_description, str):
            raise TypeError("Expected argument 'replication_subnet_group_description' to be a str")
        pulumi.set(__self__, "replication_subnet_group_description", replication_subnet_group_description)
        if replication_subnet_group_id and not isinstance(replication_subnet_group_id, str):
            raise TypeError("Expected argument 'replication_subnet_group_id' to be a str")
        pulumi.set(__self__, "replication_subnet_group_id", replication_subnet_group_id)
        if subnet_group_status and not isinstance(subnet_group_status, str):
            raise TypeError("Expected argument 'subnet_group_status' to be a str")
        pulumi.set(__self__, "subnet_group_status", subnet_group_status)
        if subnet_ids and not isinstance(subnet_ids, list):
            raise TypeError("Expected argument 'subnet_ids' to be a list")
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="replicationSubnetGroupArn")
    def replication_subnet_group_arn(self) -> str:
        return pulumi.get(self, "replication_subnet_group_arn")

    @property
    @pulumi.getter(name="replicationSubnetGroupDescription")
    def replication_subnet_group_description(self) -> str:
        """
        Description for the subnet group.
        """
        return pulumi.get(self, "replication_subnet_group_description")

    @property
    @pulumi.getter(name="replicationSubnetGroupId")
    def replication_subnet_group_id(self) -> str:
        return pulumi.get(self, "replication_subnet_group_id")

    @property
    @pulumi.getter(name="subnetGroupStatus")
    def subnet_group_status(self) -> str:
        return pulumi.get(self, "subnet_group_status")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[str]:
        """
        List of at least 2 EC2 subnet IDs for the subnet group. The subnets must cover at least 2 availability zones.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The ID of the VPC the subnet group is in.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetReplicationSubnetGroupResult(GetReplicationSubnetGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetReplicationSubnetGroupResult(
            id=self.id,
            replication_subnet_group_arn=self.replication_subnet_group_arn,
            replication_subnet_group_description=self.replication_subnet_group_description,
            replication_subnet_group_id=self.replication_subnet_group_id,
            subnet_group_status=self.subnet_group_status,
            subnet_ids=self.subnet_ids,
            tags=self.tags,
            vpc_id=self.vpc_id)


def get_replication_subnet_group(replication_subnet_group_id: Optional[str] = None,
                                 tags: Optional[Mapping[str, str]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetReplicationSubnetGroupResult:
    """
    Data source for managing an AWS DMS (Database Migration) Replication Subnet Group.

    ## Example Usage

    ### Basic Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.dms.get_replication_subnet_group(replication_subnet_group_id=test_aws_dms_replication_subnet_group["replicationSubnetGroupId"])
    ```
    <!--End PulumiCodeChooser -->


    :param str replication_subnet_group_id: Name for the replication subnet group. This value is stored as a lowercase string. It must contain no more than 255 alphanumeric characters, periods, spaces, underscores, or hyphens and cannot be `default`.
    """
    __args__ = dict()
    __args__['replicationSubnetGroupId'] = replication_subnet_group_id
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:dms/getReplicationSubnetGroup:getReplicationSubnetGroup', __args__, opts=opts, typ=GetReplicationSubnetGroupResult).value

    return AwaitableGetReplicationSubnetGroupResult(
        id=pulumi.get(__ret__, 'id'),
        replication_subnet_group_arn=pulumi.get(__ret__, 'replication_subnet_group_arn'),
        replication_subnet_group_description=pulumi.get(__ret__, 'replication_subnet_group_description'),
        replication_subnet_group_id=pulumi.get(__ret__, 'replication_subnet_group_id'),
        subnet_group_status=pulumi.get(__ret__, 'subnet_group_status'),
        subnet_ids=pulumi.get(__ret__, 'subnet_ids'),
        tags=pulumi.get(__ret__, 'tags'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))


@_utilities.lift_output_func(get_replication_subnet_group)
def get_replication_subnet_group_output(replication_subnet_group_id: Optional[pulumi.Input[str]] = None,
                                        tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetReplicationSubnetGroupResult]:
    """
    Data source for managing an AWS DMS (Database Migration) Replication Subnet Group.

    ## Example Usage

    ### Basic Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.dms.get_replication_subnet_group(replication_subnet_group_id=test_aws_dms_replication_subnet_group["replicationSubnetGroupId"])
    ```
    <!--End PulumiCodeChooser -->


    :param str replication_subnet_group_id: Name for the replication subnet group. This value is stored as a lowercase string. It must contain no more than 255 alphanumeric characters, periods, spaces, underscores, or hyphens and cannot be `default`.
    """
    ...
