# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetEipsResult',
    'AwaitableGetEipsResult',
    'get_eips',
    'get_eips_output',
]

@pulumi.output_type
class GetEipsResult:
    """
    A collection of values returned by getEips.
    """
    def __init__(__self__, allocation_ids=None, filters=None, id=None, public_ips=None, tags=None):
        if allocation_ids and not isinstance(allocation_ids, list):
            raise TypeError("Expected argument 'allocation_ids' to be a list")
        pulumi.set(__self__, "allocation_ids", allocation_ids)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if public_ips and not isinstance(public_ips, list):
            raise TypeError("Expected argument 'public_ips' to be a list")
        pulumi.set(__self__, "public_ips", public_ips)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="allocationIds")
    def allocation_ids(self) -> Sequence[str]:
        """
        List of all the allocation IDs for address for use with EC2-VPC.
        """
        return pulumi.get(self, "allocation_ids")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetEipsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="publicIps")
    def public_ips(self) -> Sequence[str]:
        """
        List of all the Elastic IP addresses.
        """
        return pulumi.get(self, "public_ips")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        return pulumi.get(self, "tags")


class AwaitableGetEipsResult(GetEipsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEipsResult(
            allocation_ids=self.allocation_ids,
            filters=self.filters,
            id=self.id,
            public_ips=self.public_ips,
            tags=self.tags)


def get_eips(filters: Optional[Sequence[pulumi.InputType['GetEipsFilterArgs']]] = None,
             tags: Optional[Mapping[str, str]] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEipsResult:
    """
    Provides a list of Elastic IPs in a region.

    ## Example Usage

    The following shows outputting all Elastic IPs with the a specific tag value.

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_eips(tags={
        "Env": "dev",
    })
    pulumi.export("allocationIds", example.allocation_ids)
    pulumi.export("publicIps", example.public_ips)
    ```
    <!--End PulumiCodeChooser -->


    :param Sequence[pulumi.InputType['GetEipsFilterArgs']] filters: Custom filter block as described below.
    :param Mapping[str, str] tags: Map of tags, each pair of which must exactly match a pair on the desired Elastic IPs.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2/getEips:getEips', __args__, opts=opts, typ=GetEipsResult).value

    return AwaitableGetEipsResult(
        allocation_ids=pulumi.get(__ret__, 'allocation_ids'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        public_ips=pulumi.get(__ret__, 'public_ips'),
        tags=pulumi.get(__ret__, 'tags'))


@_utilities.lift_output_func(get_eips)
def get_eips_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetEipsFilterArgs']]]]] = None,
                    tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEipsResult]:
    """
    Provides a list of Elastic IPs in a region.

    ## Example Usage

    The following shows outputting all Elastic IPs with the a specific tag value.

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ec2.get_eips(tags={
        "Env": "dev",
    })
    pulumi.export("allocationIds", example.allocation_ids)
    pulumi.export("publicIps", example.public_ips)
    ```
    <!--End PulumiCodeChooser -->


    :param Sequence[pulumi.InputType['GetEipsFilterArgs']] filters: Custom filter block as described below.
    :param Mapping[str, str] tags: Map of tags, each pair of which must exactly match a pair on the desired Elastic IPs.
    """
    ...
