# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SecurityGroupAssociationArgs', 'SecurityGroupAssociation']

@pulumi.input_type
class SecurityGroupAssociationArgs:
    def __init__(__self__, *,
                 security_group_id: pulumi.Input[str],
                 vpc_endpoint_id: pulumi.Input[str],
                 replace_default_association: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a SecurityGroupAssociation resource.
        :param pulumi.Input[str] security_group_id: The ID of the security group to be associated with the VPC endpoint.
        :param pulumi.Input[str] vpc_endpoint_id: The ID of the VPC endpoint with which the security group will be associated.
        :param pulumi.Input[bool] replace_default_association: Whether this association should replace the association with the VPC's default security group that is created when no security groups are specified during VPC endpoint creation. At most 1 association per-VPC endpoint should be configured with `replace_default_association = true`.
        """
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "vpc_endpoint_id", vpc_endpoint_id)
        if replace_default_association is not None:
            pulumi.set(__self__, "replace_default_association", replace_default_association)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[str]:
        """
        The ID of the security group to be associated with the VPC endpoint.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="vpcEndpointId")
    def vpc_endpoint_id(self) -> pulumi.Input[str]:
        """
        The ID of the VPC endpoint with which the security group will be associated.
        """
        return pulumi.get(self, "vpc_endpoint_id")

    @vpc_endpoint_id.setter
    def vpc_endpoint_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_endpoint_id", value)

    @property
    @pulumi.getter(name="replaceDefaultAssociation")
    def replace_default_association(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this association should replace the association with the VPC's default security group that is created when no security groups are specified during VPC endpoint creation. At most 1 association per-VPC endpoint should be configured with `replace_default_association = true`.
        """
        return pulumi.get(self, "replace_default_association")

    @replace_default_association.setter
    def replace_default_association(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "replace_default_association", value)


@pulumi.input_type
class _SecurityGroupAssociationState:
    def __init__(__self__, *,
                 replace_default_association: Optional[pulumi.Input[bool]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 vpc_endpoint_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SecurityGroupAssociation resources.
        :param pulumi.Input[bool] replace_default_association: Whether this association should replace the association with the VPC's default security group that is created when no security groups are specified during VPC endpoint creation. At most 1 association per-VPC endpoint should be configured with `replace_default_association = true`.
        :param pulumi.Input[str] security_group_id: The ID of the security group to be associated with the VPC endpoint.
        :param pulumi.Input[str] vpc_endpoint_id: The ID of the VPC endpoint with which the security group will be associated.
        """
        if replace_default_association is not None:
            pulumi.set(__self__, "replace_default_association", replace_default_association)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if vpc_endpoint_id is not None:
            pulumi.set(__self__, "vpc_endpoint_id", vpc_endpoint_id)

    @property
    @pulumi.getter(name="replaceDefaultAssociation")
    def replace_default_association(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this association should replace the association with the VPC's default security group that is created when no security groups are specified during VPC endpoint creation. At most 1 association per-VPC endpoint should be configured with `replace_default_association = true`.
        """
        return pulumi.get(self, "replace_default_association")

    @replace_default_association.setter
    def replace_default_association(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "replace_default_association", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the security group to be associated with the VPC endpoint.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="vpcEndpointId")
    def vpc_endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the VPC endpoint with which the security group will be associated.
        """
        return pulumi.get(self, "vpc_endpoint_id")

    @vpc_endpoint_id.setter
    def vpc_endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_endpoint_id", value)


class SecurityGroupAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 replace_default_association: Optional[pulumi.Input[bool]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 vpc_endpoint_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to create an association between a VPC endpoint and a security group.

        > **NOTE on VPC Endpoints and VPC Endpoint Security Group Associations:** The provider provides
        both a standalone VPC Endpoint Security Group Association (an association between a VPC endpoint
        and a single `security_group_id`) and a VPC Endpoint resource with a `security_group_ids`
        attribute. Do not use the same security group ID in both a VPC Endpoint resource and a VPC Endpoint Security
        Group Association resource. Doing so will cause a conflict of associations and will overwrite the association.

        ## Example Usage

        Basic usage:

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        sg_ec2 = aws.ec2.SecurityGroupAssociation("sg_ec2",
            vpc_endpoint_id=ec2["id"],
            security_group_id=sg["id"])
        ```
        <!--End PulumiCodeChooser -->

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] replace_default_association: Whether this association should replace the association with the VPC's default security group that is created when no security groups are specified during VPC endpoint creation. At most 1 association per-VPC endpoint should be configured with `replace_default_association = true`.
        :param pulumi.Input[str] security_group_id: The ID of the security group to be associated with the VPC endpoint.
        :param pulumi.Input[str] vpc_endpoint_id: The ID of the VPC endpoint with which the security group will be associated.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityGroupAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to create an association between a VPC endpoint and a security group.

        > **NOTE on VPC Endpoints and VPC Endpoint Security Group Associations:** The provider provides
        both a standalone VPC Endpoint Security Group Association (an association between a VPC endpoint
        and a single `security_group_id`) and a VPC Endpoint resource with a `security_group_ids`
        attribute. Do not use the same security group ID in both a VPC Endpoint resource and a VPC Endpoint Security
        Group Association resource. Doing so will cause a conflict of associations and will overwrite the association.

        ## Example Usage

        Basic usage:

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        sg_ec2 = aws.ec2.SecurityGroupAssociation("sg_ec2",
            vpc_endpoint_id=ec2["id"],
            security_group_id=sg["id"])
        ```
        <!--End PulumiCodeChooser -->

        :param str resource_name: The name of the resource.
        :param SecurityGroupAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityGroupAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 replace_default_association: Optional[pulumi.Input[bool]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 vpc_endpoint_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityGroupAssociationArgs.__new__(SecurityGroupAssociationArgs)

            __props__.__dict__["replace_default_association"] = replace_default_association
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
            if vpc_endpoint_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_endpoint_id'")
            __props__.__dict__["vpc_endpoint_id"] = vpc_endpoint_id
        super(SecurityGroupAssociation, __self__).__init__(
            'aws:ec2/securityGroupAssociation:SecurityGroupAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            replace_default_association: Optional[pulumi.Input[bool]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None,
            vpc_endpoint_id: Optional[pulumi.Input[str]] = None) -> 'SecurityGroupAssociation':
        """
        Get an existing SecurityGroupAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] replace_default_association: Whether this association should replace the association with the VPC's default security group that is created when no security groups are specified during VPC endpoint creation. At most 1 association per-VPC endpoint should be configured with `replace_default_association = true`.
        :param pulumi.Input[str] security_group_id: The ID of the security group to be associated with the VPC endpoint.
        :param pulumi.Input[str] vpc_endpoint_id: The ID of the VPC endpoint with which the security group will be associated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityGroupAssociationState.__new__(_SecurityGroupAssociationState)

        __props__.__dict__["replace_default_association"] = replace_default_association
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["vpc_endpoint_id"] = vpc_endpoint_id
        return SecurityGroupAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="replaceDefaultAssociation")
    def replace_default_association(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether this association should replace the association with the VPC's default security group that is created when no security groups are specified during VPC endpoint creation. At most 1 association per-VPC endpoint should be configured with `replace_default_association = true`.
        """
        return pulumi.get(self, "replace_default_association")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[str]:
        """
        The ID of the security group to be associated with the VPC endpoint.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="vpcEndpointId")
    def vpc_endpoint_id(self) -> pulumi.Output[str]:
        """
        The ID of the VPC endpoint with which the security group will be associated.
        """
        return pulumi.get(self, "vpc_endpoint_id")

