# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'EndpointAuthenticationOptionArgs',
    'EndpointClientConnectOptionsArgs',
    'EndpointClientLoginBannerOptionsArgs',
    'EndpointConnectionLogOptionsArgs',
    'GetEndpointFilterArgs',
]

@pulumi.input_type
class EndpointAuthenticationOptionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 active_directory_id: Optional[pulumi.Input[str]] = None,
                 root_certificate_chain_arn: Optional[pulumi.Input[str]] = None,
                 saml_provider_arn: Optional[pulumi.Input[str]] = None,
                 self_service_saml_provider_arn: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: The type of client authentication to be used. Specify `certificate-authentication` to use certificate-based authentication, `directory-service-authentication` to use Active Directory authentication, or `federated-authentication` to use Federated Authentication via SAML 2.0.
        :param pulumi.Input[str] active_directory_id: The ID of the Active Directory to be used for authentication if type is `directory-service-authentication`.
        :param pulumi.Input[str] root_certificate_chain_arn: The ARN of the client certificate. The certificate must be signed by a certificate authority (CA) and it must be provisioned in AWS Certificate Manager (ACM). Only necessary when type is set to `certificate-authentication`.
        :param pulumi.Input[str] saml_provider_arn: The ARN of the IAM SAML identity provider if type is `federated-authentication`.
        :param pulumi.Input[str] self_service_saml_provider_arn: The ARN of the IAM SAML identity provider for the self service portal if type is `federated-authentication`.
        """
        pulumi.set(__self__, "type", type)
        if active_directory_id is not None:
            pulumi.set(__self__, "active_directory_id", active_directory_id)
        if root_certificate_chain_arn is not None:
            pulumi.set(__self__, "root_certificate_chain_arn", root_certificate_chain_arn)
        if saml_provider_arn is not None:
            pulumi.set(__self__, "saml_provider_arn", saml_provider_arn)
        if self_service_saml_provider_arn is not None:
            pulumi.set(__self__, "self_service_saml_provider_arn", self_service_saml_provider_arn)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of client authentication to be used. Specify `certificate-authentication` to use certificate-based authentication, `directory-service-authentication` to use Active Directory authentication, or `federated-authentication` to use Federated Authentication via SAML 2.0.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="activeDirectoryId")
    def active_directory_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Active Directory to be used for authentication if type is `directory-service-authentication`.
        """
        return pulumi.get(self, "active_directory_id")

    @active_directory_id.setter
    def active_directory_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "active_directory_id", value)

    @property
    @pulumi.getter(name="rootCertificateChainArn")
    def root_certificate_chain_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the client certificate. The certificate must be signed by a certificate authority (CA) and it must be provisioned in AWS Certificate Manager (ACM). Only necessary when type is set to `certificate-authentication`.
        """
        return pulumi.get(self, "root_certificate_chain_arn")

    @root_certificate_chain_arn.setter
    def root_certificate_chain_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root_certificate_chain_arn", value)

    @property
    @pulumi.getter(name="samlProviderArn")
    def saml_provider_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the IAM SAML identity provider if type is `federated-authentication`.
        """
        return pulumi.get(self, "saml_provider_arn")

    @saml_provider_arn.setter
    def saml_provider_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "saml_provider_arn", value)

    @property
    @pulumi.getter(name="selfServiceSamlProviderArn")
    def self_service_saml_provider_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the IAM SAML identity provider for the self service portal if type is `federated-authentication`.
        """
        return pulumi.get(self, "self_service_saml_provider_arn")

    @self_service_saml_provider_arn.setter
    def self_service_saml_provider_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_service_saml_provider_arn", value)


@pulumi.input_type
class EndpointClientConnectOptionsArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 lambda_function_arn: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] enabled: Indicates whether client connect options are enabled. The default is `false` (not enabled).
        :param pulumi.Input[str] lambda_function_arn: The Amazon Resource Name (ARN) of the Lambda function used for connection authorization.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if lambda_function_arn is not None:
            pulumi.set(__self__, "lambda_function_arn", lambda_function_arn)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether client connect options are enabled. The default is `false` (not enabled).
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="lambdaFunctionArn")
    def lambda_function_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the Lambda function used for connection authorization.
        """
        return pulumi.get(self, "lambda_function_arn")

    @lambda_function_arn.setter
    def lambda_function_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lambda_function_arn", value)


@pulumi.input_type
class EndpointClientLoginBannerOptionsArgs:
    def __init__(__self__, *,
                 banner_text: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] banner_text: Customizable text that will be displayed in a banner on AWS provided clients when a VPN session is established. UTF-8 encoded characters only. Maximum of 1400 characters.
        :param pulumi.Input[bool] enabled: Enable or disable a customizable text banner that will be displayed on AWS provided clients when a VPN session is established. The default is `false` (not enabled).
        """
        if banner_text is not None:
            pulumi.set(__self__, "banner_text", banner_text)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="bannerText")
    def banner_text(self) -> Optional[pulumi.Input[str]]:
        """
        Customizable text that will be displayed in a banner on AWS provided clients when a VPN session is established. UTF-8 encoded characters only. Maximum of 1400 characters.
        """
        return pulumi.get(self, "banner_text")

    @banner_text.setter
    def banner_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "banner_text", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable a customizable text banner that will be displayed on AWS provided clients when a VPN session is established. The default is `false` (not enabled).
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class EndpointConnectionLogOptionsArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 cloudwatch_log_group: Optional[pulumi.Input[str]] = None,
                 cloudwatch_log_stream: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] enabled: Indicates whether connection logging is enabled.
        :param pulumi.Input[str] cloudwatch_log_group: The name of the CloudWatch Logs log group.
        :param pulumi.Input[str] cloudwatch_log_stream: The name of the CloudWatch Logs log stream to which the connection data is published.
        """
        pulumi.set(__self__, "enabled", enabled)
        if cloudwatch_log_group is not None:
            pulumi.set(__self__, "cloudwatch_log_group", cloudwatch_log_group)
        if cloudwatch_log_stream is not None:
            pulumi.set(__self__, "cloudwatch_log_stream", cloudwatch_log_stream)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Indicates whether connection logging is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="cloudwatchLogGroup")
    def cloudwatch_log_group(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the CloudWatch Logs log group.
        """
        return pulumi.get(self, "cloudwatch_log_group")

    @cloudwatch_log_group.setter
    def cloudwatch_log_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloudwatch_log_group", value)

    @property
    @pulumi.getter(name="cloudwatchLogStream")
    def cloudwatch_log_stream(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the CloudWatch Logs log stream to which the connection data is published.
        """
        return pulumi.get(self, "cloudwatch_log_stream")

    @cloudwatch_log_stream.setter
    def cloudwatch_log_stream(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloudwatch_log_stream", value)


@pulumi.input_type
class GetEndpointFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Name of the field to filter by, as defined by [the underlying AWS API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeClientVpnEndpoints.html).
        :param Sequence[str] values: Set of values that are accepted for the given field. An endpoint will be selected if any one of the given values matches.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the field to filter by, as defined by [the underlying AWS API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeClientVpnEndpoints.html).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Set of values that are accepted for the given field. An endpoint will be selected if any one of the given values matches.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


