# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AddonArgs', 'Addon']

@pulumi.input_type
class AddonArgs:
    def __init__(__self__, *,
                 addon_name: pulumi.Input[str],
                 cluster_name: pulumi.Input[str],
                 addon_version: Optional[pulumi.Input[str]] = None,
                 configuration_values: Optional[pulumi.Input[str]] = None,
                 preserve: Optional[pulumi.Input[bool]] = None,
                 resolve_conflicts: Optional[pulumi.Input[str]] = None,
                 resolve_conflicts_on_create: Optional[pulumi.Input[str]] = None,
                 resolve_conflicts_on_update: Optional[pulumi.Input[str]] = None,
                 service_account_role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Addon resource.
        :param pulumi.Input[str] addon_name: Name of the EKS add-on. The name must match one of
               the names returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        :param pulumi.Input[str] cluster_name: Name of the EKS Cluster.
               
               The following arguments are optional:
        :param pulumi.Input[str] addon_version: The version of the EKS add-on. The version must
               match one of the versions returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        :param pulumi.Input[str] configuration_values: custom configuration values for addons with single JSON string. This JSON string value must match the JSON schema derived from [describe-addon-configuration](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-configuration.html).
        :param pulumi.Input[bool] preserve: Indicates if you want to preserve the created resources when deleting the EKS add-on.
        :param pulumi.Input[str] resolve_conflicts: Define how to resolve parameter value conflicts when migrating an existing add-on to an Amazon EKS add-on or when applying version updates to the add-on. Valid values are `NONE`, `OVERWRITE` and `PRESERVE`. Note that `PRESERVE` is only valid on addon update, not for initial addon creation. If you need to set this to `PRESERVE`, use the `resolve_conflicts_on_create` and `resolve_conflicts_on_update` attributes instead. For more details check [UpdateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html) API Docs.
        :param pulumi.Input[str] resolve_conflicts_on_create: How to resolve field value conflicts when migrating a self-managed add-on to an Amazon EKS add-on. Valid values are `NONE` and `OVERWRITE`. For more details see the [CreateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_CreateAddon.html) API Docs.
        :param pulumi.Input[str] resolve_conflicts_on_update: How to resolve field value conflicts for an Amazon EKS add-on if you've changed a value from the Amazon EKS default value. Valid values are `NONE`, `OVERWRITE`, and `PRESERVE`. For more details see the [UpdateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html) API Docs.
        :param pulumi.Input[str] service_account_role_arn: The Amazon Resource Name (ARN) of an
               existing IAM role to bind to the add-on's service account. The role must be
               assigned the IAM permissions required by the add-on. If you don't specify
               an existing IAM role, then the add-on uses the permissions assigned to the node
               IAM role. For more information, see [Amazon EKS node IAM role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html)
               in the Amazon EKS User Guide.
               
               > **Note:** To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC)
               provider created for your cluster. For more information, [see Enabling IAM roles
               for service accounts on your cluster](https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html)
               in the Amazon EKS User Guide.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "addon_name", addon_name)
        pulumi.set(__self__, "cluster_name", cluster_name)
        if addon_version is not None:
            pulumi.set(__self__, "addon_version", addon_version)
        if configuration_values is not None:
            pulumi.set(__self__, "configuration_values", configuration_values)
        if preserve is not None:
            pulumi.set(__self__, "preserve", preserve)
        if resolve_conflicts is not None:
            warnings.warn("""The \"resolve_conflicts\" attribute can't be set to \"PRESERVE\" on initial resource creation. Use \"resolve_conflicts_on_create\" and/or \"resolve_conflicts_on_update\" instead""", DeprecationWarning)
            pulumi.log.warn("""resolve_conflicts is deprecated: The \"resolve_conflicts\" attribute can't be set to \"PRESERVE\" on initial resource creation. Use \"resolve_conflicts_on_create\" and/or \"resolve_conflicts_on_update\" instead""")
        if resolve_conflicts is not None:
            pulumi.set(__self__, "resolve_conflicts", resolve_conflicts)
        if resolve_conflicts_on_create is not None:
            pulumi.set(__self__, "resolve_conflicts_on_create", resolve_conflicts_on_create)
        if resolve_conflicts_on_update is not None:
            pulumi.set(__self__, "resolve_conflicts_on_update", resolve_conflicts_on_update)
        if service_account_role_arn is not None:
            pulumi.set(__self__, "service_account_role_arn", service_account_role_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="addonName")
    def addon_name(self) -> pulumi.Input[str]:
        """
        Name of the EKS add-on. The name must match one of
        the names returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        """
        return pulumi.get(self, "addon_name")

    @addon_name.setter
    def addon_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "addon_name", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[str]:
        """
        Name of the EKS Cluster.

        The following arguments are optional:
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="addonVersion")
    def addon_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the EKS add-on. The version must
        match one of the versions returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        """
        return pulumi.get(self, "addon_version")

    @addon_version.setter
    def addon_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "addon_version", value)

    @property
    @pulumi.getter(name="configurationValues")
    def configuration_values(self) -> Optional[pulumi.Input[str]]:
        """
        custom configuration values for addons with single JSON string. This JSON string value must match the JSON schema derived from [describe-addon-configuration](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-configuration.html).
        """
        return pulumi.get(self, "configuration_values")

    @configuration_values.setter
    def configuration_values(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_values", value)

    @property
    @pulumi.getter
    def preserve(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if you want to preserve the created resources when deleting the EKS add-on.
        """
        return pulumi.get(self, "preserve")

    @preserve.setter
    def preserve(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "preserve", value)

    @property
    @pulumi.getter(name="resolveConflicts")
    def resolve_conflicts(self) -> Optional[pulumi.Input[str]]:
        """
        Define how to resolve parameter value conflicts when migrating an existing add-on to an Amazon EKS add-on or when applying version updates to the add-on. Valid values are `NONE`, `OVERWRITE` and `PRESERVE`. Note that `PRESERVE` is only valid on addon update, not for initial addon creation. If you need to set this to `PRESERVE`, use the `resolve_conflicts_on_create` and `resolve_conflicts_on_update` attributes instead. For more details check [UpdateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html) API Docs.
        """
        warnings.warn("""The \"resolve_conflicts\" attribute can't be set to \"PRESERVE\" on initial resource creation. Use \"resolve_conflicts_on_create\" and/or \"resolve_conflicts_on_update\" instead""", DeprecationWarning)
        pulumi.log.warn("""resolve_conflicts is deprecated: The \"resolve_conflicts\" attribute can't be set to \"PRESERVE\" on initial resource creation. Use \"resolve_conflicts_on_create\" and/or \"resolve_conflicts_on_update\" instead""")

        return pulumi.get(self, "resolve_conflicts")

    @resolve_conflicts.setter
    def resolve_conflicts(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resolve_conflicts", value)

    @property
    @pulumi.getter(name="resolveConflictsOnCreate")
    def resolve_conflicts_on_create(self) -> Optional[pulumi.Input[str]]:
        """
        How to resolve field value conflicts when migrating a self-managed add-on to an Amazon EKS add-on. Valid values are `NONE` and `OVERWRITE`. For more details see the [CreateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_CreateAddon.html) API Docs.
        """
        return pulumi.get(self, "resolve_conflicts_on_create")

    @resolve_conflicts_on_create.setter
    def resolve_conflicts_on_create(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resolve_conflicts_on_create", value)

    @property
    @pulumi.getter(name="resolveConflictsOnUpdate")
    def resolve_conflicts_on_update(self) -> Optional[pulumi.Input[str]]:
        """
        How to resolve field value conflicts for an Amazon EKS add-on if you've changed a value from the Amazon EKS default value. Valid values are `NONE`, `OVERWRITE`, and `PRESERVE`. For more details see the [UpdateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html) API Docs.
        """
        return pulumi.get(self, "resolve_conflicts_on_update")

    @resolve_conflicts_on_update.setter
    def resolve_conflicts_on_update(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resolve_conflicts_on_update", value)

    @property
    @pulumi.getter(name="serviceAccountRoleArn")
    def service_account_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of an
        existing IAM role to bind to the add-on's service account. The role must be
        assigned the IAM permissions required by the add-on. If you don't specify
        an existing IAM role, then the add-on uses the permissions assigned to the node
        IAM role. For more information, see [Amazon EKS node IAM role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html)
        in the Amazon EKS User Guide.

        > **Note:** To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC)
        provider created for your cluster. For more information, [see Enabling IAM roles
        for service accounts on your cluster](https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html)
        in the Amazon EKS User Guide.
        """
        return pulumi.get(self, "service_account_role_arn")

    @service_account_role_arn.setter
    def service_account_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_role_arn", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AddonState:
    def __init__(__self__, *,
                 addon_name: Optional[pulumi.Input[str]] = None,
                 addon_version: Optional[pulumi.Input[str]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 configuration_values: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 modified_at: Optional[pulumi.Input[str]] = None,
                 preserve: Optional[pulumi.Input[bool]] = None,
                 resolve_conflicts: Optional[pulumi.Input[str]] = None,
                 resolve_conflicts_on_create: Optional[pulumi.Input[str]] = None,
                 resolve_conflicts_on_update: Optional[pulumi.Input[str]] = None,
                 service_account_role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Addon resources.
        :param pulumi.Input[str] addon_name: Name of the EKS add-on. The name must match one of
               the names returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        :param pulumi.Input[str] addon_version: The version of the EKS add-on. The version must
               match one of the versions returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        :param pulumi.Input[str] arn: Amazon Resource Name (ARN) of the EKS add-on.
        :param pulumi.Input[str] cluster_name: Name of the EKS Cluster.
               
               The following arguments are optional:
        :param pulumi.Input[str] configuration_values: custom configuration values for addons with single JSON string. This JSON string value must match the JSON schema derived from [describe-addon-configuration](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-configuration.html).
        :param pulumi.Input[str] created_at: Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was created.
        :param pulumi.Input[str] modified_at: Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was updated.
        :param pulumi.Input[bool] preserve: Indicates if you want to preserve the created resources when deleting the EKS add-on.
        :param pulumi.Input[str] resolve_conflicts: Define how to resolve parameter value conflicts when migrating an existing add-on to an Amazon EKS add-on or when applying version updates to the add-on. Valid values are `NONE`, `OVERWRITE` and `PRESERVE`. Note that `PRESERVE` is only valid on addon update, not for initial addon creation. If you need to set this to `PRESERVE`, use the `resolve_conflicts_on_create` and `resolve_conflicts_on_update` attributes instead. For more details check [UpdateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html) API Docs.
        :param pulumi.Input[str] resolve_conflicts_on_create: How to resolve field value conflicts when migrating a self-managed add-on to an Amazon EKS add-on. Valid values are `NONE` and `OVERWRITE`. For more details see the [CreateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_CreateAddon.html) API Docs.
        :param pulumi.Input[str] resolve_conflicts_on_update: How to resolve field value conflicts for an Amazon EKS add-on if you've changed a value from the Amazon EKS default value. Valid values are `NONE`, `OVERWRITE`, and `PRESERVE`. For more details see the [UpdateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html) API Docs.
        :param pulumi.Input[str] service_account_role_arn: The Amazon Resource Name (ARN) of an
               existing IAM role to bind to the add-on's service account. The role must be
               assigned the IAM permissions required by the add-on. If you don't specify
               an existing IAM role, then the add-on uses the permissions assigned to the node
               IAM role. For more information, see [Amazon EKS node IAM role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html)
               in the Amazon EKS User Guide.
               
               > **Note:** To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC)
               provider created for your cluster. For more information, [see Enabling IAM roles
               for service accounts on your cluster](https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html)
               in the Amazon EKS User Guide.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: (Optional) Key-value map of resource tags, including those inherited from the provider `default_tags` configuration block.
        """
        if addon_name is not None:
            pulumi.set(__self__, "addon_name", addon_name)
        if addon_version is not None:
            pulumi.set(__self__, "addon_version", addon_version)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if configuration_values is not None:
            pulumi.set(__self__, "configuration_values", configuration_values)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if modified_at is not None:
            pulumi.set(__self__, "modified_at", modified_at)
        if preserve is not None:
            pulumi.set(__self__, "preserve", preserve)
        if resolve_conflicts is not None:
            warnings.warn("""The \"resolve_conflicts\" attribute can't be set to \"PRESERVE\" on initial resource creation. Use \"resolve_conflicts_on_create\" and/or \"resolve_conflicts_on_update\" instead""", DeprecationWarning)
            pulumi.log.warn("""resolve_conflicts is deprecated: The \"resolve_conflicts\" attribute can't be set to \"PRESERVE\" on initial resource creation. Use \"resolve_conflicts_on_create\" and/or \"resolve_conflicts_on_update\" instead""")
        if resolve_conflicts is not None:
            pulumi.set(__self__, "resolve_conflicts", resolve_conflicts)
        if resolve_conflicts_on_create is not None:
            pulumi.set(__self__, "resolve_conflicts_on_create", resolve_conflicts_on_create)
        if resolve_conflicts_on_update is not None:
            pulumi.set(__self__, "resolve_conflicts_on_update", resolve_conflicts_on_update)
        if service_account_role_arn is not None:
            pulumi.set(__self__, "service_account_role_arn", service_account_role_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter(name="addonName")
    def addon_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the EKS add-on. The name must match one of
        the names returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        """
        return pulumi.get(self, "addon_name")

    @addon_name.setter
    def addon_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "addon_name", value)

    @property
    @pulumi.getter(name="addonVersion")
    def addon_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the EKS add-on. The version must
        match one of the versions returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        """
        return pulumi.get(self, "addon_version")

    @addon_version.setter
    def addon_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "addon_version", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of the EKS add-on.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the EKS Cluster.

        The following arguments are optional:
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="configurationValues")
    def configuration_values(self) -> Optional[pulumi.Input[str]]:
        """
        custom configuration values for addons with single JSON string. This JSON string value must match the JSON schema derived from [describe-addon-configuration](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-configuration.html).
        """
        return pulumi.get(self, "configuration_values")

    @configuration_values.setter
    def configuration_values(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_values", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> Optional[pulumi.Input[str]]:
        """
        Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was updated.
        """
        return pulumi.get(self, "modified_at")

    @modified_at.setter
    def modified_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modified_at", value)

    @property
    @pulumi.getter
    def preserve(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if you want to preserve the created resources when deleting the EKS add-on.
        """
        return pulumi.get(self, "preserve")

    @preserve.setter
    def preserve(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "preserve", value)

    @property
    @pulumi.getter(name="resolveConflicts")
    def resolve_conflicts(self) -> Optional[pulumi.Input[str]]:
        """
        Define how to resolve parameter value conflicts when migrating an existing add-on to an Amazon EKS add-on or when applying version updates to the add-on. Valid values are `NONE`, `OVERWRITE` and `PRESERVE`. Note that `PRESERVE` is only valid on addon update, not for initial addon creation. If you need to set this to `PRESERVE`, use the `resolve_conflicts_on_create` and `resolve_conflicts_on_update` attributes instead. For more details check [UpdateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html) API Docs.
        """
        warnings.warn("""The \"resolve_conflicts\" attribute can't be set to \"PRESERVE\" on initial resource creation. Use \"resolve_conflicts_on_create\" and/or \"resolve_conflicts_on_update\" instead""", DeprecationWarning)
        pulumi.log.warn("""resolve_conflicts is deprecated: The \"resolve_conflicts\" attribute can't be set to \"PRESERVE\" on initial resource creation. Use \"resolve_conflicts_on_create\" and/or \"resolve_conflicts_on_update\" instead""")

        return pulumi.get(self, "resolve_conflicts")

    @resolve_conflicts.setter
    def resolve_conflicts(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resolve_conflicts", value)

    @property
    @pulumi.getter(name="resolveConflictsOnCreate")
    def resolve_conflicts_on_create(self) -> Optional[pulumi.Input[str]]:
        """
        How to resolve field value conflicts when migrating a self-managed add-on to an Amazon EKS add-on. Valid values are `NONE` and `OVERWRITE`. For more details see the [CreateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_CreateAddon.html) API Docs.
        """
        return pulumi.get(self, "resolve_conflicts_on_create")

    @resolve_conflicts_on_create.setter
    def resolve_conflicts_on_create(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resolve_conflicts_on_create", value)

    @property
    @pulumi.getter(name="resolveConflictsOnUpdate")
    def resolve_conflicts_on_update(self) -> Optional[pulumi.Input[str]]:
        """
        How to resolve field value conflicts for an Amazon EKS add-on if you've changed a value from the Amazon EKS default value. Valid values are `NONE`, `OVERWRITE`, and `PRESERVE`. For more details see the [UpdateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html) API Docs.
        """
        return pulumi.get(self, "resolve_conflicts_on_update")

    @resolve_conflicts_on_update.setter
    def resolve_conflicts_on_update(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resolve_conflicts_on_update", value)

    @property
    @pulumi.getter(name="serviceAccountRoleArn")
    def service_account_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of an
        existing IAM role to bind to the add-on's service account. The role must be
        assigned the IAM permissions required by the add-on. If you don't specify
        an existing IAM role, then the add-on uses the permissions assigned to the node
        IAM role. For more information, see [Amazon EKS node IAM role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html)
        in the Amazon EKS User Guide.

        > **Note:** To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC)
        provider created for your cluster. For more information, [see Enabling IAM roles
        for service accounts on your cluster](https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html)
        in the Amazon EKS User Guide.
        """
        return pulumi.get(self, "service_account_role_arn")

    @service_account_role_arn.setter
    def service_account_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_role_arn", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Optional) Key-value map of resource tags, including those inherited from the provider `default_tags` configuration block.
        """
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)


class Addon(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addon_name: Optional[pulumi.Input[str]] = None,
                 addon_version: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 configuration_values: Optional[pulumi.Input[str]] = None,
                 preserve: Optional[pulumi.Input[bool]] = None,
                 resolve_conflicts: Optional[pulumi.Input[str]] = None,
                 resolve_conflicts_on_create: Optional[pulumi.Input[str]] = None,
                 resolve_conflicts_on_update: Optional[pulumi.Input[str]] = None,
                 service_account_role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Manages an EKS add-on.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.eks.Addon("example",
            cluster_name=example_aws_eks_cluster["name"],
            addon_name="vpc-cni")
        ```
        <!--End PulumiCodeChooser -->

        ## Example Update add-on usage with resolve_conflicts_on_update and PRESERVE

        `resolve_conflicts_on_update` with `PRESERVE` can be used to retain the config changes applied to the add-on with kubectl while upgrading to a newer version of the add-on.

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.eks.Addon("example",
            cluster_name=example_aws_eks_cluster["name"],
            addon_name="coredns",
            addon_version="v1.10.1-eksbuild.1",
            resolve_conflicts_on_update="PRESERVE")
        ```
        <!--End PulumiCodeChooser -->

        ## Example add-on usage with custom configuration_values

        Custom add-on configuration can be passed using `configuration_values` as a single JSON string while creating or updating the add-on.

        > **Note:** `configuration_values` is a single JSON string should match the valid JSON schema for each add-on with specific version.

        To find the correct JSON schema for each add-on can be extracted using [describe-addon-configuration](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-configuration.html) call.
        This below is an example for extracting the `configuration_values` schema for `coredns`.

        Example to create a `coredns` managed addon with custom `configuration_values`.

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.eks.Addon("example",
            cluster_name="mycluster",
            addon_name="coredns",
            addon_version="v1.10.1-eksbuild.1",
            resolve_conflicts_on_create="OVERWRITE",
            configuration_values=json.dumps({
                "replicaCount": 4,
                "resources": {
                    "limits": {
                        "cpu": "100m",
                        "memory": "150Mi",
                    },
                    "requests": {
                        "cpu": "100m",
                        "memory": "150Mi",
                    },
                },
            }))
        ```
        <!--End PulumiCodeChooser -->

        ### Example IAM Role for EKS Addon "vpc-cni" with AWS managed policy

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std
        import pulumi_tls as tls

        example_cluster = aws.eks.Cluster("example")
        example = example_cluster.identities.apply(lambda identities: tls.get_certificate_output(url=identities[0].oidcs[0].issuer))
        example_open_id_connect_provider = aws.iam.OpenIdConnectProvider("example",
            client_id_lists=["sts.amazonaws.com"],
            thumbprint_lists=[example.certificates[0].sha1_fingerprint],
            url=example_cluster.identities[0].oidcs[0].issuer)
        example_assume_role_policy = aws.iam.get_policy_document_output(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            actions=["sts:AssumeRoleWithWebIdentity"],
            effect="Allow",
            conditions=[aws.iam.GetPolicyDocumentStatementConditionArgs(
                test="StringEquals",
                variable=std.replace_output(text=example_open_id_connect_provider.url,
                    search="https://",
                    replace="").apply(lambda invoke: f"{invoke.result}:sub"),
                values=["system:serviceaccount:kube-system:aws-node"],
            )],
            principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                identifiers=[example_open_id_connect_provider.arn],
                type="Federated",
            )],
        )])
        example_role = aws.iam.Role("example",
            assume_role_policy=example_assume_role_policy.json,
            name="example-vpc-cni-role")
        example_role_policy_attachment = aws.iam.RolePolicyAttachment("example",
            policy_arn="arn:aws:iam::aws:policy/AmazonEKS_CNI_Policy",
            role=example_role.name)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import EKS add-on using the `cluster_name` and `addon_name` separated by a colon (`:`). For example:

        ```sh
        $ pulumi import aws:eks/addon:Addon my_eks_addon my_cluster_name:my_addon_name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] addon_name: Name of the EKS add-on. The name must match one of
               the names returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        :param pulumi.Input[str] addon_version: The version of the EKS add-on. The version must
               match one of the versions returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        :param pulumi.Input[str] cluster_name: Name of the EKS Cluster.
               
               The following arguments are optional:
        :param pulumi.Input[str] configuration_values: custom configuration values for addons with single JSON string. This JSON string value must match the JSON schema derived from [describe-addon-configuration](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-configuration.html).
        :param pulumi.Input[bool] preserve: Indicates if you want to preserve the created resources when deleting the EKS add-on.
        :param pulumi.Input[str] resolve_conflicts: Define how to resolve parameter value conflicts when migrating an existing add-on to an Amazon EKS add-on or when applying version updates to the add-on. Valid values are `NONE`, `OVERWRITE` and `PRESERVE`. Note that `PRESERVE` is only valid on addon update, not for initial addon creation. If you need to set this to `PRESERVE`, use the `resolve_conflicts_on_create` and `resolve_conflicts_on_update` attributes instead. For more details check [UpdateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html) API Docs.
        :param pulumi.Input[str] resolve_conflicts_on_create: How to resolve field value conflicts when migrating a self-managed add-on to an Amazon EKS add-on. Valid values are `NONE` and `OVERWRITE`. For more details see the [CreateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_CreateAddon.html) API Docs.
        :param pulumi.Input[str] resolve_conflicts_on_update: How to resolve field value conflicts for an Amazon EKS add-on if you've changed a value from the Amazon EKS default value. Valid values are `NONE`, `OVERWRITE`, and `PRESERVE`. For more details see the [UpdateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html) API Docs.
        :param pulumi.Input[str] service_account_role_arn: The Amazon Resource Name (ARN) of an
               existing IAM role to bind to the add-on's service account. The role must be
               assigned the IAM permissions required by the add-on. If you don't specify
               an existing IAM role, then the add-on uses the permissions assigned to the node
               IAM role. For more information, see [Amazon EKS node IAM role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html)
               in the Amazon EKS User Guide.
               
               > **Note:** To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC)
               provider created for your cluster. For more information, [see Enabling IAM roles
               for service accounts on your cluster](https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html)
               in the Amazon EKS User Guide.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AddonArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an EKS add-on.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.eks.Addon("example",
            cluster_name=example_aws_eks_cluster["name"],
            addon_name="vpc-cni")
        ```
        <!--End PulumiCodeChooser -->

        ## Example Update add-on usage with resolve_conflicts_on_update and PRESERVE

        `resolve_conflicts_on_update` with `PRESERVE` can be used to retain the config changes applied to the add-on with kubectl while upgrading to a newer version of the add-on.

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.eks.Addon("example",
            cluster_name=example_aws_eks_cluster["name"],
            addon_name="coredns",
            addon_version="v1.10.1-eksbuild.1",
            resolve_conflicts_on_update="PRESERVE")
        ```
        <!--End PulumiCodeChooser -->

        ## Example add-on usage with custom configuration_values

        Custom add-on configuration can be passed using `configuration_values` as a single JSON string while creating or updating the add-on.

        > **Note:** `configuration_values` is a single JSON string should match the valid JSON schema for each add-on with specific version.

        To find the correct JSON schema for each add-on can be extracted using [describe-addon-configuration](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-configuration.html) call.
        This below is an example for extracting the `configuration_values` schema for `coredns`.

        Example to create a `coredns` managed addon with custom `configuration_values`.

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.eks.Addon("example",
            cluster_name="mycluster",
            addon_name="coredns",
            addon_version="v1.10.1-eksbuild.1",
            resolve_conflicts_on_create="OVERWRITE",
            configuration_values=json.dumps({
                "replicaCount": 4,
                "resources": {
                    "limits": {
                        "cpu": "100m",
                        "memory": "150Mi",
                    },
                    "requests": {
                        "cpu": "100m",
                        "memory": "150Mi",
                    },
                },
            }))
        ```
        <!--End PulumiCodeChooser -->

        ### Example IAM Role for EKS Addon "vpc-cni" with AWS managed policy

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std
        import pulumi_tls as tls

        example_cluster = aws.eks.Cluster("example")
        example = example_cluster.identities.apply(lambda identities: tls.get_certificate_output(url=identities[0].oidcs[0].issuer))
        example_open_id_connect_provider = aws.iam.OpenIdConnectProvider("example",
            client_id_lists=["sts.amazonaws.com"],
            thumbprint_lists=[example.certificates[0].sha1_fingerprint],
            url=example_cluster.identities[0].oidcs[0].issuer)
        example_assume_role_policy = aws.iam.get_policy_document_output(statements=[aws.iam.GetPolicyDocumentStatementArgs(
            actions=["sts:AssumeRoleWithWebIdentity"],
            effect="Allow",
            conditions=[aws.iam.GetPolicyDocumentStatementConditionArgs(
                test="StringEquals",
                variable=std.replace_output(text=example_open_id_connect_provider.url,
                    search="https://",
                    replace="").apply(lambda invoke: f"{invoke.result}:sub"),
                values=["system:serviceaccount:kube-system:aws-node"],
            )],
            principals=[aws.iam.GetPolicyDocumentStatementPrincipalArgs(
                identifiers=[example_open_id_connect_provider.arn],
                type="Federated",
            )],
        )])
        example_role = aws.iam.Role("example",
            assume_role_policy=example_assume_role_policy.json,
            name="example-vpc-cni-role")
        example_role_policy_attachment = aws.iam.RolePolicyAttachment("example",
            policy_arn="arn:aws:iam::aws:policy/AmazonEKS_CNI_Policy",
            role=example_role.name)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import EKS add-on using the `cluster_name` and `addon_name` separated by a colon (`:`). For example:

        ```sh
        $ pulumi import aws:eks/addon:Addon my_eks_addon my_cluster_name:my_addon_name
        ```

        :param str resource_name: The name of the resource.
        :param AddonArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AddonArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addon_name: Optional[pulumi.Input[str]] = None,
                 addon_version: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 configuration_values: Optional[pulumi.Input[str]] = None,
                 preserve: Optional[pulumi.Input[bool]] = None,
                 resolve_conflicts: Optional[pulumi.Input[str]] = None,
                 resolve_conflicts_on_create: Optional[pulumi.Input[str]] = None,
                 resolve_conflicts_on_update: Optional[pulumi.Input[str]] = None,
                 service_account_role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AddonArgs.__new__(AddonArgs)

            if addon_name is None and not opts.urn:
                raise TypeError("Missing required property 'addon_name'")
            __props__.__dict__["addon_name"] = addon_name
            __props__.__dict__["addon_version"] = addon_version
            if cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_name'")
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["configuration_values"] = configuration_values
            __props__.__dict__["preserve"] = preserve
            __props__.__dict__["resolve_conflicts"] = resolve_conflicts
            __props__.__dict__["resolve_conflicts_on_create"] = resolve_conflicts_on_create
            __props__.__dict__["resolve_conflicts_on_update"] = resolve_conflicts_on_update
            __props__.__dict__["service_account_role_arn"] = service_account_role_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["modified_at"] = None
            __props__.__dict__["tags_all"] = None
        super(Addon, __self__).__init__(
            'aws:eks/addon:Addon',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            addon_name: Optional[pulumi.Input[str]] = None,
            addon_version: Optional[pulumi.Input[str]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            cluster_name: Optional[pulumi.Input[str]] = None,
            configuration_values: Optional[pulumi.Input[str]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            modified_at: Optional[pulumi.Input[str]] = None,
            preserve: Optional[pulumi.Input[bool]] = None,
            resolve_conflicts: Optional[pulumi.Input[str]] = None,
            resolve_conflicts_on_create: Optional[pulumi.Input[str]] = None,
            resolve_conflicts_on_update: Optional[pulumi.Input[str]] = None,
            service_account_role_arn: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'Addon':
        """
        Get an existing Addon resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] addon_name: Name of the EKS add-on. The name must match one of
               the names returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        :param pulumi.Input[str] addon_version: The version of the EKS add-on. The version must
               match one of the versions returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        :param pulumi.Input[str] arn: Amazon Resource Name (ARN) of the EKS add-on.
        :param pulumi.Input[str] cluster_name: Name of the EKS Cluster.
               
               The following arguments are optional:
        :param pulumi.Input[str] configuration_values: custom configuration values for addons with single JSON string. This JSON string value must match the JSON schema derived from [describe-addon-configuration](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-configuration.html).
        :param pulumi.Input[str] created_at: Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was created.
        :param pulumi.Input[str] modified_at: Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was updated.
        :param pulumi.Input[bool] preserve: Indicates if you want to preserve the created resources when deleting the EKS add-on.
        :param pulumi.Input[str] resolve_conflicts: Define how to resolve parameter value conflicts when migrating an existing add-on to an Amazon EKS add-on or when applying version updates to the add-on. Valid values are `NONE`, `OVERWRITE` and `PRESERVE`. Note that `PRESERVE` is only valid on addon update, not for initial addon creation. If you need to set this to `PRESERVE`, use the `resolve_conflicts_on_create` and `resolve_conflicts_on_update` attributes instead. For more details check [UpdateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html) API Docs.
        :param pulumi.Input[str] resolve_conflicts_on_create: How to resolve field value conflicts when migrating a self-managed add-on to an Amazon EKS add-on. Valid values are `NONE` and `OVERWRITE`. For more details see the [CreateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_CreateAddon.html) API Docs.
        :param pulumi.Input[str] resolve_conflicts_on_update: How to resolve field value conflicts for an Amazon EKS add-on if you've changed a value from the Amazon EKS default value. Valid values are `NONE`, `OVERWRITE`, and `PRESERVE`. For more details see the [UpdateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html) API Docs.
        :param pulumi.Input[str] service_account_role_arn: The Amazon Resource Name (ARN) of an
               existing IAM role to bind to the add-on's service account. The role must be
               assigned the IAM permissions required by the add-on. If you don't specify
               an existing IAM role, then the add-on uses the permissions assigned to the node
               IAM role. For more information, see [Amazon EKS node IAM role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html)
               in the Amazon EKS User Guide.
               
               > **Note:** To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC)
               provider created for your cluster. For more information, [see Enabling IAM roles
               for service accounts on your cluster](https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html)
               in the Amazon EKS User Guide.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: (Optional) Key-value map of resource tags, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AddonState.__new__(_AddonState)

        __props__.__dict__["addon_name"] = addon_name
        __props__.__dict__["addon_version"] = addon_version
        __props__.__dict__["arn"] = arn
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["configuration_values"] = configuration_values
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["modified_at"] = modified_at
        __props__.__dict__["preserve"] = preserve
        __props__.__dict__["resolve_conflicts"] = resolve_conflicts
        __props__.__dict__["resolve_conflicts_on_create"] = resolve_conflicts_on_create
        __props__.__dict__["resolve_conflicts_on_update"] = resolve_conflicts_on_update
        __props__.__dict__["service_account_role_arn"] = service_account_role_arn
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return Addon(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="addonName")
    def addon_name(self) -> pulumi.Output[str]:
        """
        Name of the EKS add-on. The name must match one of
        the names returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        """
        return pulumi.get(self, "addon_name")

    @property
    @pulumi.getter(name="addonVersion")
    def addon_version(self) -> pulumi.Output[str]:
        """
        The version of the EKS add-on. The version must
        match one of the versions returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        """
        return pulumi.get(self, "addon_version")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        Amazon Resource Name (ARN) of the EKS add-on.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[str]:
        """
        Name of the EKS Cluster.

        The following arguments are optional:
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="configurationValues")
    def configuration_values(self) -> pulumi.Output[str]:
        """
        custom configuration values for addons with single JSON string. This JSON string value must match the JSON schema derived from [describe-addon-configuration](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-configuration.html).
        """
        return pulumi.get(self, "configuration_values")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> pulumi.Output[str]:
        """
        Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was updated.
        """
        return pulumi.get(self, "modified_at")

    @property
    @pulumi.getter
    def preserve(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates if you want to preserve the created resources when deleting the EKS add-on.
        """
        return pulumi.get(self, "preserve")

    @property
    @pulumi.getter(name="resolveConflicts")
    def resolve_conflicts(self) -> pulumi.Output[Optional[str]]:
        """
        Define how to resolve parameter value conflicts when migrating an existing add-on to an Amazon EKS add-on or when applying version updates to the add-on. Valid values are `NONE`, `OVERWRITE` and `PRESERVE`. Note that `PRESERVE` is only valid on addon update, not for initial addon creation. If you need to set this to `PRESERVE`, use the `resolve_conflicts_on_create` and `resolve_conflicts_on_update` attributes instead. For more details check [UpdateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html) API Docs.
        """
        warnings.warn("""The \"resolve_conflicts\" attribute can't be set to \"PRESERVE\" on initial resource creation. Use \"resolve_conflicts_on_create\" and/or \"resolve_conflicts_on_update\" instead""", DeprecationWarning)
        pulumi.log.warn("""resolve_conflicts is deprecated: The \"resolve_conflicts\" attribute can't be set to \"PRESERVE\" on initial resource creation. Use \"resolve_conflicts_on_create\" and/or \"resolve_conflicts_on_update\" instead""")

        return pulumi.get(self, "resolve_conflicts")

    @property
    @pulumi.getter(name="resolveConflictsOnCreate")
    def resolve_conflicts_on_create(self) -> pulumi.Output[Optional[str]]:
        """
        How to resolve field value conflicts when migrating a self-managed add-on to an Amazon EKS add-on. Valid values are `NONE` and `OVERWRITE`. For more details see the [CreateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_CreateAddon.html) API Docs.
        """
        return pulumi.get(self, "resolve_conflicts_on_create")

    @property
    @pulumi.getter(name="resolveConflictsOnUpdate")
    def resolve_conflicts_on_update(self) -> pulumi.Output[Optional[str]]:
        """
        How to resolve field value conflicts for an Amazon EKS add-on if you've changed a value from the Amazon EKS default value. Valid values are `NONE`, `OVERWRITE`, and `PRESERVE`. For more details see the [UpdateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html) API Docs.
        """
        return pulumi.get(self, "resolve_conflicts_on_update")

    @property
    @pulumi.getter(name="serviceAccountRoleArn")
    def service_account_role_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon Resource Name (ARN) of an
        existing IAM role to bind to the add-on's service account. The role must be
        assigned the IAM permissions required by the add-on. If you don't specify
        an existing IAM role, then the add-on uses the permissions assigned to the node
        IAM role. For more information, see [Amazon EKS node IAM role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html)
        in the Amazon EKS User Guide.

        > **Note:** To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC)
        provider created for your cluster. For more information, [see Enabling IAM roles
        for service accounts on your cluster](https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html)
        in the Amazon EKS User Guide.
        """
        return pulumi.get(self, "service_account_role_arn")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Optional) Key-value map of resource tags, including those inherited from the provider `default_tags` configuration block.
        """
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

