# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetAddonVersionResult',
    'AwaitableGetAddonVersionResult',
    'get_addon_version',
    'get_addon_version_output',
]

@pulumi.output_type
class GetAddonVersionResult:
    """
    A collection of values returned by getAddonVersion.
    """
    def __init__(__self__, addon_name=None, id=None, kubernetes_version=None, most_recent=None, version=None):
        if addon_name and not isinstance(addon_name, str):
            raise TypeError("Expected argument 'addon_name' to be a str")
        pulumi.set(__self__, "addon_name", addon_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kubernetes_version and not isinstance(kubernetes_version, str):
            raise TypeError("Expected argument 'kubernetes_version' to be a str")
        pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        if most_recent and not isinstance(most_recent, bool):
            raise TypeError("Expected argument 'most_recent' to be a bool")
        pulumi.set(__self__, "most_recent", most_recent)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="addonName")
    def addon_name(self) -> str:
        return pulumi.get(self, "addon_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> str:
        return pulumi.get(self, "kubernetes_version")

    @property
    @pulumi.getter(name="mostRecent")
    def most_recent(self) -> Optional[bool]:
        return pulumi.get(self, "most_recent")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Version of the EKS add-on.
        """
        return pulumi.get(self, "version")


class AwaitableGetAddonVersionResult(GetAddonVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAddonVersionResult(
            addon_name=self.addon_name,
            id=self.id,
            kubernetes_version=self.kubernetes_version,
            most_recent=self.most_recent,
            version=self.version)


def get_addon_version(addon_name: Optional[str] = None,
                      kubernetes_version: Optional[str] = None,
                      most_recent: Optional[bool] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAddonVersionResult:
    """
    Retrieve information about a specific EKS add-on version compatible with an EKS cluster version.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    default = aws.eks.get_addon_version(addon_name="vpc-cni",
        kubernetes_version=example["version"])
    latest = aws.eks.get_addon_version(addon_name="vpc-cni",
        kubernetes_version=example["version"],
        most_recent=True)
    vpc_cni = aws.eks.Addon("vpc_cni",
        cluster_name=example["name"],
        addon_name="vpc-cni",
        addon_version=latest.version)
    pulumi.export("default", default.version)
    pulumi.export("latest", latest.version)
    ```
    <!--End PulumiCodeChooser -->


    :param str addon_name: Name of the EKS add-on. The name must match one of
           the names returned by [list-addon](https://docs.aws.amazon.com/cli/latest/reference/eks/list-addons.html).
    :param str kubernetes_version: Version of the EKS Cluster. Must be between 1-100 characters in length. Must begin with an alphanumeric character, and must only contain alphanumeric characters, dashes and underscores (`^[0-9A-Za-z][A-Za-z0-9\\-_]+$`).
    :param bool most_recent: Determines if the most recent or default version of the addon should be returned.
    """
    __args__ = dict()
    __args__['addonName'] = addon_name
    __args__['kubernetesVersion'] = kubernetes_version
    __args__['mostRecent'] = most_recent
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:eks/getAddonVersion:getAddonVersion', __args__, opts=opts, typ=GetAddonVersionResult).value

    return AwaitableGetAddonVersionResult(
        addon_name=pulumi.get(__ret__, 'addon_name'),
        id=pulumi.get(__ret__, 'id'),
        kubernetes_version=pulumi.get(__ret__, 'kubernetes_version'),
        most_recent=pulumi.get(__ret__, 'most_recent'),
        version=pulumi.get(__ret__, 'version'))


@_utilities.lift_output_func(get_addon_version)
def get_addon_version_output(addon_name: Optional[pulumi.Input[str]] = None,
                             kubernetes_version: Optional[pulumi.Input[str]] = None,
                             most_recent: Optional[pulumi.Input[Optional[bool]]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAddonVersionResult]:
    """
    Retrieve information about a specific EKS add-on version compatible with an EKS cluster version.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    default = aws.eks.get_addon_version(addon_name="vpc-cni",
        kubernetes_version=example["version"])
    latest = aws.eks.get_addon_version(addon_name="vpc-cni",
        kubernetes_version=example["version"],
        most_recent=True)
    vpc_cni = aws.eks.Addon("vpc_cni",
        cluster_name=example["name"],
        addon_name="vpc-cni",
        addon_version=latest.version)
    pulumi.export("default", default.version)
    pulumi.export("latest", latest.version)
    ```
    <!--End PulumiCodeChooser -->


    :param str addon_name: Name of the EKS add-on. The name must match one of
           the names returned by [list-addon](https://docs.aws.amazon.com/cli/latest/reference/eks/list-addons.html).
    :param str kubernetes_version: Version of the EKS Cluster. Must be between 1-100 characters in length. Must begin with an alphanumeric character, and must only contain alphanumeric characters, dashes and underscores (`^[0-9A-Za-z][A-Za-z0-9\\-_]+$`).
    :param bool most_recent: Determines if the most recent or default version of the addon should be returned.
    """
    ...
