# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EnvironmentArgs', 'Environment']

@pulumi.input_type
class EnvironmentArgs:
    def __init__(__self__, *,
                 application: pulumi.Input[str],
                 cname_prefix: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 platform_arn: Optional[pulumi.Input[str]] = None,
                 poll_interval: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentSettingArgs']]]] = None,
                 solution_stack_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 template_name: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 wait_for_ready_timeout: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Environment resource.
        :param pulumi.Input[str] application: Name of the application that contains the version
               to be deployed
        :param pulumi.Input[str] cname_prefix: Prefix to use for the fully qualified DNS name of
               the Environment.
        :param pulumi.Input[str] description: Short description of the Environment
        :param pulumi.Input[str] name: A unique name for this Environment. This name is used
               in the application URL
        :param pulumi.Input[str] platform_arn: The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the Elastic Beanstalk [Platform](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-platformarn)
               to use in deployment
        :param pulumi.Input[str] poll_interval: The time between polling the AWS API to
               check if changes have been applied. Use this to adjust the rate of API calls
               for any `create` or `update` action. Minimum `10s`, maximum `180s`. Omit this to
               use the default behavior, which is an exponential backoff
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentSettingArgs']]] settings: Option settings to configure the new Environment. These
               override specific values that are set as defaults. The format is detailed
               below in Option Settings
        :param pulumi.Input[str] solution_stack_name: A solution stack to base your environment
               off of. Example stacks can be found in the [Amazon API documentation](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html)
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A set of tags to apply to the Environment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] template_name: The name of the Elastic Beanstalk Configuration
               template to use in deployment
        :param pulumi.Input[str] tier: Elastic Beanstalk Environment tier. Valid values are `Worker`
               or `WebServer`. If tier is left blank `WebServer` will be used.
        :param pulumi.Input[str] version: The name of the Elastic Beanstalk Application Version
               to use in deployment.
        :param pulumi.Input[str] wait_for_ready_timeout: The maximum
               [duration](https://golang.org/pkg/time/#ParseDuration) that this provider should
               wait for an Elastic Beanstalk Environment to be in a ready state before timing
               out.
        """
        pulumi.set(__self__, "application", application)
        if cname_prefix is not None:
            pulumi.set(__self__, "cname_prefix", cname_prefix)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if platform_arn is not None:
            pulumi.set(__self__, "platform_arn", platform_arn)
        if poll_interval is not None:
            pulumi.set(__self__, "poll_interval", poll_interval)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if solution_stack_name is not None:
            pulumi.set(__self__, "solution_stack_name", solution_stack_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_name is not None:
            pulumi.set(__self__, "template_name", template_name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if wait_for_ready_timeout is not None:
            pulumi.set(__self__, "wait_for_ready_timeout", wait_for_ready_timeout)

    @property
    @pulumi.getter
    def application(self) -> pulumi.Input[str]:
        """
        Name of the application that contains the version
        to be deployed
        """
        return pulumi.get(self, "application")

    @application.setter
    def application(self, value: pulumi.Input[str]):
        pulumi.set(self, "application", value)

    @property
    @pulumi.getter(name="cnamePrefix")
    def cname_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Prefix to use for the fully qualified DNS name of
        the Environment.
        """
        return pulumi.get(self, "cname_prefix")

    @cname_prefix.setter
    def cname_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cname_prefix", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Short description of the Environment
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A unique name for this Environment. This name is used
        in the application URL
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="platformArn")
    def platform_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the Elastic Beanstalk [Platform](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-platformarn)
        to use in deployment
        """
        return pulumi.get(self, "platform_arn")

    @platform_arn.setter
    def platform_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform_arn", value)

    @property
    @pulumi.getter(name="pollInterval")
    def poll_interval(self) -> Optional[pulumi.Input[str]]:
        """
        The time between polling the AWS API to
        check if changes have been applied. Use this to adjust the rate of API calls
        for any `create` or `update` action. Minimum `10s`, maximum `180s`. Omit this to
        use the default behavior, which is an exponential backoff
        """
        return pulumi.get(self, "poll_interval")

    @poll_interval.setter
    def poll_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "poll_interval", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentSettingArgs']]]]:
        """
        Option settings to configure the new Environment. These
        override specific values that are set as defaults. The format is detailed
        below in Option Settings
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentSettingArgs']]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter(name="solutionStackName")
    def solution_stack_name(self) -> Optional[pulumi.Input[str]]:
        """
        A solution stack to base your environment
        off of. Example stacks can be found in the [Amazon API documentation](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html)
        """
        return pulumi.get(self, "solution_stack_name")

    @solution_stack_name.setter
    def solution_stack_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "solution_stack_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of tags to apply to the Environment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Elastic Beanstalk Configuration
        template to use in deployment
        """
        return pulumi.get(self, "template_name")

    @template_name.setter
    def template_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_name", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        Elastic Beanstalk Environment tier. Valid values are `Worker`
        or `WebServer`. If tier is left blank `WebServer` will be used.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Elastic Beanstalk Application Version
        to use in deployment.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="waitForReadyTimeout")
    def wait_for_ready_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum
        [duration](https://golang.org/pkg/time/#ParseDuration) that this provider should
        wait for an Elastic Beanstalk Environment to be in a ready state before timing
        out.
        """
        return pulumi.get(self, "wait_for_ready_timeout")

    @wait_for_ready_timeout.setter
    def wait_for_ready_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wait_for_ready_timeout", value)


@pulumi.input_type
class _EnvironmentState:
    def __init__(__self__, *,
                 all_settings: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentAllSettingArgs']]]] = None,
                 application: Optional[pulumi.Input[str]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 autoscaling_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cname: Optional[pulumi.Input[str]] = None,
                 cname_prefix: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 endpoint_url: Optional[pulumi.Input[str]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 launch_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 platform_arn: Optional[pulumi.Input[str]] = None,
                 poll_interval: Optional[pulumi.Input[str]] = None,
                 queues: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 settings: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentSettingArgs']]]] = None,
                 solution_stack_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 template_name: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None,
                 triggers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 wait_for_ready_timeout: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Environment resources.
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentAllSettingArgs']]] all_settings: List of all option settings configured in this Environment. These
               are a combination of default settings and their overrides from `setting` in
               the configuration.
        :param pulumi.Input[str] application: Name of the application that contains the version
               to be deployed
        :param pulumi.Input[Sequence[pulumi.Input[str]]] autoscaling_groups: The autoscaling groups used by this Environment.
        :param pulumi.Input[str] cname: Fully qualified DNS name for this Environment.
        :param pulumi.Input[str] cname_prefix: Prefix to use for the fully qualified DNS name of
               the Environment.
        :param pulumi.Input[str] description: Short description of the Environment
        :param pulumi.Input[str] endpoint_url: The URL to the Load Balancer for this Environment
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instances: Instances used by this Environment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] launch_configurations: Launch configurations in use by this Environment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] load_balancers: Elastic load balancers in use by this Environment.
        :param pulumi.Input[str] name: A unique name for this Environment. This name is used
               in the application URL
        :param pulumi.Input[str] platform_arn: The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the Elastic Beanstalk [Platform](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-platformarn)
               to use in deployment
        :param pulumi.Input[str] poll_interval: The time between polling the AWS API to
               check if changes have been applied. Use this to adjust the rate of API calls
               for any `create` or `update` action. Minimum `10s`, maximum `180s`. Omit this to
               use the default behavior, which is an exponential backoff
        :param pulumi.Input[Sequence[pulumi.Input[str]]] queues: SQS queues in use by this Environment.
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentSettingArgs']]] settings: Option settings to configure the new Environment. These
               override specific values that are set as defaults. The format is detailed
               below in Option Settings
        :param pulumi.Input[str] solution_stack_name: A solution stack to base your environment
               off of. Example stacks can be found in the [Amazon API documentation](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html)
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A set of tags to apply to the Environment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] template_name: The name of the Elastic Beanstalk Configuration
               template to use in deployment
        :param pulumi.Input[str] tier: Elastic Beanstalk Environment tier. Valid values are `Worker`
               or `WebServer`. If tier is left blank `WebServer` will be used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] triggers: Autoscaling triggers in use by this Environment.
        :param pulumi.Input[str] version: The name of the Elastic Beanstalk Application Version
               to use in deployment.
        :param pulumi.Input[str] wait_for_ready_timeout: The maximum
               [duration](https://golang.org/pkg/time/#ParseDuration) that this provider should
               wait for an Elastic Beanstalk Environment to be in a ready state before timing
               out.
        """
        if all_settings is not None:
            pulumi.set(__self__, "all_settings", all_settings)
        if application is not None:
            pulumi.set(__self__, "application", application)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if autoscaling_groups is not None:
            pulumi.set(__self__, "autoscaling_groups", autoscaling_groups)
        if cname is not None:
            pulumi.set(__self__, "cname", cname)
        if cname_prefix is not None:
            pulumi.set(__self__, "cname_prefix", cname_prefix)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if endpoint_url is not None:
            pulumi.set(__self__, "endpoint_url", endpoint_url)
        if instances is not None:
            pulumi.set(__self__, "instances", instances)
        if launch_configurations is not None:
            pulumi.set(__self__, "launch_configurations", launch_configurations)
        if load_balancers is not None:
            pulumi.set(__self__, "load_balancers", load_balancers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if platform_arn is not None:
            pulumi.set(__self__, "platform_arn", platform_arn)
        if poll_interval is not None:
            pulumi.set(__self__, "poll_interval", poll_interval)
        if queues is not None:
            pulumi.set(__self__, "queues", queues)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if solution_stack_name is not None:
            pulumi.set(__self__, "solution_stack_name", solution_stack_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if template_name is not None:
            pulumi.set(__self__, "template_name", template_name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if wait_for_ready_timeout is not None:
            pulumi.set(__self__, "wait_for_ready_timeout", wait_for_ready_timeout)

    @property
    @pulumi.getter(name="allSettings")
    def all_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentAllSettingArgs']]]]:
        """
        List of all option settings configured in this Environment. These
        are a combination of default settings and their overrides from `setting` in
        the configuration.
        """
        return pulumi.get(self, "all_settings")

    @all_settings.setter
    def all_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentAllSettingArgs']]]]):
        pulumi.set(self, "all_settings", value)

    @property
    @pulumi.getter
    def application(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the application that contains the version
        to be deployed
        """
        return pulumi.get(self, "application")

    @application.setter
    def application(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="autoscalingGroups")
    def autoscaling_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The autoscaling groups used by this Environment.
        """
        return pulumi.get(self, "autoscaling_groups")

    @autoscaling_groups.setter
    def autoscaling_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "autoscaling_groups", value)

    @property
    @pulumi.getter
    def cname(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified DNS name for this Environment.
        """
        return pulumi.get(self, "cname")

    @cname.setter
    def cname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cname", value)

    @property
    @pulumi.getter(name="cnamePrefix")
    def cname_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Prefix to use for the fully qualified DNS name of
        the Environment.
        """
        return pulumi.get(self, "cname_prefix")

    @cname_prefix.setter
    def cname_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cname_prefix", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Short description of the Environment
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="endpointUrl")
    def endpoint_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL to the Load Balancer for this Environment
        """
        return pulumi.get(self, "endpoint_url")

    @endpoint_url.setter
    def endpoint_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_url", value)

    @property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Instances used by this Environment.
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instances", value)

    @property
    @pulumi.getter(name="launchConfigurations")
    def launch_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Launch configurations in use by this Environment.
        """
        return pulumi.get(self, "launch_configurations")

    @launch_configurations.setter
    def launch_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "launch_configurations", value)

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Elastic load balancers in use by this Environment.
        """
        return pulumi.get(self, "load_balancers")

    @load_balancers.setter
    def load_balancers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "load_balancers", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A unique name for this Environment. This name is used
        in the application URL
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="platformArn")
    def platform_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the Elastic Beanstalk [Platform](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-platformarn)
        to use in deployment
        """
        return pulumi.get(self, "platform_arn")

    @platform_arn.setter
    def platform_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform_arn", value)

    @property
    @pulumi.getter(name="pollInterval")
    def poll_interval(self) -> Optional[pulumi.Input[str]]:
        """
        The time between polling the AWS API to
        check if changes have been applied. Use this to adjust the rate of API calls
        for any `create` or `update` action. Minimum `10s`, maximum `180s`. Omit this to
        use the default behavior, which is an exponential backoff
        """
        return pulumi.get(self, "poll_interval")

    @poll_interval.setter
    def poll_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "poll_interval", value)

    @property
    @pulumi.getter
    def queues(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        SQS queues in use by this Environment.
        """
        return pulumi.get(self, "queues")

    @queues.setter
    def queues(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "queues", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentSettingArgs']]]]:
        """
        Option settings to configure the new Environment. These
        override specific values that are set as defaults. The format is detailed
        below in Option Settings
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentSettingArgs']]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter(name="solutionStackName")
    def solution_stack_name(self) -> Optional[pulumi.Input[str]]:
        """
        A solution stack to base your environment
        off of. Example stacks can be found in the [Amazon API documentation](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html)
        """
        return pulumi.get(self, "solution_stack_name")

    @solution_stack_name.setter
    def solution_stack_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "solution_stack_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of tags to apply to the Environment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Elastic Beanstalk Configuration
        template to use in deployment
        """
        return pulumi.get(self, "template_name")

    @template_name.setter
    def template_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_name", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        Elastic Beanstalk Environment tier. Valid values are `Worker`
        or `WebServer`. If tier is left blank `WebServer` will be used.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)

    @property
    @pulumi.getter
    def triggers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Autoscaling triggers in use by this Environment.
        """
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "triggers", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Elastic Beanstalk Application Version
        to use in deployment.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="waitForReadyTimeout")
    def wait_for_ready_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum
        [duration](https://golang.org/pkg/time/#ParseDuration) that this provider should
        wait for an Elastic Beanstalk Environment to be in a ready state before timing
        out.
        """
        return pulumi.get(self, "wait_for_ready_timeout")

    @wait_for_ready_timeout.setter
    def wait_for_ready_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wait_for_ready_timeout", value)


class Environment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application: Optional[pulumi.Input[str]] = None,
                 cname_prefix: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 platform_arn: Optional[pulumi.Input[str]] = None,
                 poll_interval: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnvironmentSettingArgs']]]]] = None,
                 solution_stack_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 template_name: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 wait_for_ready_timeout: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides an Elastic Beanstalk Environment Resource. Elastic Beanstalk allows
        you to deploy and manage applications in the AWS cloud without worrying about
        the infrastructure that runs those applications.

        Environments are often things such as `development`, `integration`, or
        `production`.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        tftest = aws.elasticbeanstalk.Application("tftest",
            name="tf-test-name",
            description="tf-test-desc")
        tfenvtest = aws.elasticbeanstalk.Environment("tfenvtest",
            name="tf-test-name",
            application=tftest.name,
            solution_stack_name="64bit Amazon Linux 2015.03 v2.0.3 running Go 1.4")
        ```
        <!--End PulumiCodeChooser -->

        ## Option Settings

        Some options can be stack-specific, check [AWS Docs](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options-general.html)
        for supported options and examples.

        The `setting` and `all_settings` mappings support the following format:

        * `namespace` - unique namespace identifying the option's associated AWS resource
        * `name` - name of the configuration option
        * `value` - value for the configuration option
        * `resource` - (Optional) resource name for [scheduled action](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options-general.html#command-options-general-autoscalingscheduledaction)

        ### Example With Options

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        tftest = aws.elasticbeanstalk.Application("tftest",
            name="tf-test-name",
            description="tf-test-desc")
        tfenvtest = aws.elasticbeanstalk.Environment("tfenvtest",
            name="tf-test-name",
            application=tftest.name,
            solution_stack_name="64bit Amazon Linux 2015.03 v2.0.3 running Go 1.4",
            settings=[
                aws.elasticbeanstalk.EnvironmentSettingArgs(
                    namespace="aws:ec2:vpc",
                    name="VPCId",
                    value="vpc-xxxxxxxx",
                ),
                aws.elasticbeanstalk.EnvironmentSettingArgs(
                    namespace="aws:ec2:vpc",
                    name="Subnets",
                    value="subnet-xxxxxxxx",
                ),
            ])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Elastic Beanstalk Environments using the `id`. For example:

        ```sh
        $ pulumi import aws:elasticbeanstalk/environment:Environment prodenv e-rpqsewtp2j
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application: Name of the application that contains the version
               to be deployed
        :param pulumi.Input[str] cname_prefix: Prefix to use for the fully qualified DNS name of
               the Environment.
        :param pulumi.Input[str] description: Short description of the Environment
        :param pulumi.Input[str] name: A unique name for this Environment. This name is used
               in the application URL
        :param pulumi.Input[str] platform_arn: The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the Elastic Beanstalk [Platform](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-platformarn)
               to use in deployment
        :param pulumi.Input[str] poll_interval: The time between polling the AWS API to
               check if changes have been applied. Use this to adjust the rate of API calls
               for any `create` or `update` action. Minimum `10s`, maximum `180s`. Omit this to
               use the default behavior, which is an exponential backoff
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnvironmentSettingArgs']]]] settings: Option settings to configure the new Environment. These
               override specific values that are set as defaults. The format is detailed
               below in Option Settings
        :param pulumi.Input[str] solution_stack_name: A solution stack to base your environment
               off of. Example stacks can be found in the [Amazon API documentation](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html)
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A set of tags to apply to the Environment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] template_name: The name of the Elastic Beanstalk Configuration
               template to use in deployment
        :param pulumi.Input[str] tier: Elastic Beanstalk Environment tier. Valid values are `Worker`
               or `WebServer`. If tier is left blank `WebServer` will be used.
        :param pulumi.Input[str] version: The name of the Elastic Beanstalk Application Version
               to use in deployment.
        :param pulumi.Input[str] wait_for_ready_timeout: The maximum
               [duration](https://golang.org/pkg/time/#ParseDuration) that this provider should
               wait for an Elastic Beanstalk Environment to be in a ready state before timing
               out.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnvironmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Elastic Beanstalk Environment Resource. Elastic Beanstalk allows
        you to deploy and manage applications in the AWS cloud without worrying about
        the infrastructure that runs those applications.

        Environments are often things such as `development`, `integration`, or
        `production`.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        tftest = aws.elasticbeanstalk.Application("tftest",
            name="tf-test-name",
            description="tf-test-desc")
        tfenvtest = aws.elasticbeanstalk.Environment("tfenvtest",
            name="tf-test-name",
            application=tftest.name,
            solution_stack_name="64bit Amazon Linux 2015.03 v2.0.3 running Go 1.4")
        ```
        <!--End PulumiCodeChooser -->

        ## Option Settings

        Some options can be stack-specific, check [AWS Docs](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options-general.html)
        for supported options and examples.

        The `setting` and `all_settings` mappings support the following format:

        * `namespace` - unique namespace identifying the option's associated AWS resource
        * `name` - name of the configuration option
        * `value` - value for the configuration option
        * `resource` - (Optional) resource name for [scheduled action](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options-general.html#command-options-general-autoscalingscheduledaction)

        ### Example With Options

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        tftest = aws.elasticbeanstalk.Application("tftest",
            name="tf-test-name",
            description="tf-test-desc")
        tfenvtest = aws.elasticbeanstalk.Environment("tfenvtest",
            name="tf-test-name",
            application=tftest.name,
            solution_stack_name="64bit Amazon Linux 2015.03 v2.0.3 running Go 1.4",
            settings=[
                aws.elasticbeanstalk.EnvironmentSettingArgs(
                    namespace="aws:ec2:vpc",
                    name="VPCId",
                    value="vpc-xxxxxxxx",
                ),
                aws.elasticbeanstalk.EnvironmentSettingArgs(
                    namespace="aws:ec2:vpc",
                    name="Subnets",
                    value="subnet-xxxxxxxx",
                ),
            ])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Elastic Beanstalk Environments using the `id`. For example:

        ```sh
        $ pulumi import aws:elasticbeanstalk/environment:Environment prodenv e-rpqsewtp2j
        ```

        :param str resource_name: The name of the resource.
        :param EnvironmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvironmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application: Optional[pulumi.Input[str]] = None,
                 cname_prefix: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 platform_arn: Optional[pulumi.Input[str]] = None,
                 poll_interval: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnvironmentSettingArgs']]]]] = None,
                 solution_stack_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 template_name: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 wait_for_ready_timeout: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvironmentArgs.__new__(EnvironmentArgs)

            if application is None and not opts.urn:
                raise TypeError("Missing required property 'application'")
            __props__.__dict__["application"] = application
            __props__.__dict__["cname_prefix"] = cname_prefix
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["platform_arn"] = platform_arn
            __props__.__dict__["poll_interval"] = poll_interval
            __props__.__dict__["settings"] = settings
            __props__.__dict__["solution_stack_name"] = solution_stack_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["template_name"] = template_name
            __props__.__dict__["tier"] = tier
            __props__.__dict__["version"] = version
            __props__.__dict__["wait_for_ready_timeout"] = wait_for_ready_timeout
            __props__.__dict__["all_settings"] = None
            __props__.__dict__["arn"] = None
            __props__.__dict__["autoscaling_groups"] = None
            __props__.__dict__["cname"] = None
            __props__.__dict__["endpoint_url"] = None
            __props__.__dict__["instances"] = None
            __props__.__dict__["launch_configurations"] = None
            __props__.__dict__["load_balancers"] = None
            __props__.__dict__["queues"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["triggers"] = None
        super(Environment, __self__).__init__(
            'aws:elasticbeanstalk/environment:Environment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            all_settings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnvironmentAllSettingArgs']]]]] = None,
            application: Optional[pulumi.Input[str]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            autoscaling_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            cname: Optional[pulumi.Input[str]] = None,
            cname_prefix: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            endpoint_url: Optional[pulumi.Input[str]] = None,
            instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            launch_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            platform_arn: Optional[pulumi.Input[str]] = None,
            poll_interval: Optional[pulumi.Input[str]] = None,
            queues: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            settings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnvironmentSettingArgs']]]]] = None,
            solution_stack_name: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            template_name: Optional[pulumi.Input[str]] = None,
            tier: Optional[pulumi.Input[str]] = None,
            triggers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            version: Optional[pulumi.Input[str]] = None,
            wait_for_ready_timeout: Optional[pulumi.Input[str]] = None) -> 'Environment':
        """
        Get an existing Environment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnvironmentAllSettingArgs']]]] all_settings: List of all option settings configured in this Environment. These
               are a combination of default settings and their overrides from `setting` in
               the configuration.
        :param pulumi.Input[str] application: Name of the application that contains the version
               to be deployed
        :param pulumi.Input[Sequence[pulumi.Input[str]]] autoscaling_groups: The autoscaling groups used by this Environment.
        :param pulumi.Input[str] cname: Fully qualified DNS name for this Environment.
        :param pulumi.Input[str] cname_prefix: Prefix to use for the fully qualified DNS name of
               the Environment.
        :param pulumi.Input[str] description: Short description of the Environment
        :param pulumi.Input[str] endpoint_url: The URL to the Load Balancer for this Environment
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instances: Instances used by this Environment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] launch_configurations: Launch configurations in use by this Environment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] load_balancers: Elastic load balancers in use by this Environment.
        :param pulumi.Input[str] name: A unique name for this Environment. This name is used
               in the application URL
        :param pulumi.Input[str] platform_arn: The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the Elastic Beanstalk [Platform](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-platformarn)
               to use in deployment
        :param pulumi.Input[str] poll_interval: The time between polling the AWS API to
               check if changes have been applied. Use this to adjust the rate of API calls
               for any `create` or `update` action. Minimum `10s`, maximum `180s`. Omit this to
               use the default behavior, which is an exponential backoff
        :param pulumi.Input[Sequence[pulumi.Input[str]]] queues: SQS queues in use by this Environment.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnvironmentSettingArgs']]]] settings: Option settings to configure the new Environment. These
               override specific values that are set as defaults. The format is detailed
               below in Option Settings
        :param pulumi.Input[str] solution_stack_name: A solution stack to base your environment
               off of. Example stacks can be found in the [Amazon API documentation](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html)
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A set of tags to apply to the Environment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] template_name: The name of the Elastic Beanstalk Configuration
               template to use in deployment
        :param pulumi.Input[str] tier: Elastic Beanstalk Environment tier. Valid values are `Worker`
               or `WebServer`. If tier is left blank `WebServer` will be used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] triggers: Autoscaling triggers in use by this Environment.
        :param pulumi.Input[str] version: The name of the Elastic Beanstalk Application Version
               to use in deployment.
        :param pulumi.Input[str] wait_for_ready_timeout: The maximum
               [duration](https://golang.org/pkg/time/#ParseDuration) that this provider should
               wait for an Elastic Beanstalk Environment to be in a ready state before timing
               out.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnvironmentState.__new__(_EnvironmentState)

        __props__.__dict__["all_settings"] = all_settings
        __props__.__dict__["application"] = application
        __props__.__dict__["arn"] = arn
        __props__.__dict__["autoscaling_groups"] = autoscaling_groups
        __props__.__dict__["cname"] = cname
        __props__.__dict__["cname_prefix"] = cname_prefix
        __props__.__dict__["description"] = description
        __props__.__dict__["endpoint_url"] = endpoint_url
        __props__.__dict__["instances"] = instances
        __props__.__dict__["launch_configurations"] = launch_configurations
        __props__.__dict__["load_balancers"] = load_balancers
        __props__.__dict__["name"] = name
        __props__.__dict__["platform_arn"] = platform_arn
        __props__.__dict__["poll_interval"] = poll_interval
        __props__.__dict__["queues"] = queues
        __props__.__dict__["settings"] = settings
        __props__.__dict__["solution_stack_name"] = solution_stack_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["template_name"] = template_name
        __props__.__dict__["tier"] = tier
        __props__.__dict__["triggers"] = triggers
        __props__.__dict__["version"] = version
        __props__.__dict__["wait_for_ready_timeout"] = wait_for_ready_timeout
        return Environment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allSettings")
    def all_settings(self) -> pulumi.Output[Sequence['outputs.EnvironmentAllSetting']]:
        """
        List of all option settings configured in this Environment. These
        are a combination of default settings and their overrides from `setting` in
        the configuration.
        """
        return pulumi.get(self, "all_settings")

    @property
    @pulumi.getter
    def application(self) -> pulumi.Output[str]:
        """
        Name of the application that contains the version
        to be deployed
        """
        return pulumi.get(self, "application")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoscalingGroups")
    def autoscaling_groups(self) -> pulumi.Output[Sequence[str]]:
        """
        The autoscaling groups used by this Environment.
        """
        return pulumi.get(self, "autoscaling_groups")

    @property
    @pulumi.getter
    def cname(self) -> pulumi.Output[str]:
        """
        Fully qualified DNS name for this Environment.
        """
        return pulumi.get(self, "cname")

    @property
    @pulumi.getter(name="cnamePrefix")
    def cname_prefix(self) -> pulumi.Output[str]:
        """
        Prefix to use for the fully qualified DNS name of
        the Environment.
        """
        return pulumi.get(self, "cname_prefix")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Short description of the Environment
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="endpointUrl")
    def endpoint_url(self) -> pulumi.Output[str]:
        """
        The URL to the Load Balancer for this Environment
        """
        return pulumi.get(self, "endpoint_url")

    @property
    @pulumi.getter
    def instances(self) -> pulumi.Output[Sequence[str]]:
        """
        Instances used by this Environment.
        """
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter(name="launchConfigurations")
    def launch_configurations(self) -> pulumi.Output[Sequence[str]]:
        """
        Launch configurations in use by this Environment.
        """
        return pulumi.get(self, "launch_configurations")

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> pulumi.Output[Sequence[str]]:
        """
        Elastic load balancers in use by this Environment.
        """
        return pulumi.get(self, "load_balancers")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A unique name for this Environment. This name is used
        in the application URL
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="platformArn")
    def platform_arn(self) -> pulumi.Output[str]:
        """
        The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the Elastic Beanstalk [Platform](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-platformarn)
        to use in deployment
        """
        return pulumi.get(self, "platform_arn")

    @property
    @pulumi.getter(name="pollInterval")
    def poll_interval(self) -> pulumi.Output[Optional[str]]:
        """
        The time between polling the AWS API to
        check if changes have been applied. Use this to adjust the rate of API calls
        for any `create` or `update` action. Minimum `10s`, maximum `180s`. Omit this to
        use the default behavior, which is an exponential backoff
        """
        return pulumi.get(self, "poll_interval")

    @property
    @pulumi.getter
    def queues(self) -> pulumi.Output[Sequence[str]]:
        """
        SQS queues in use by this Environment.
        """
        return pulumi.get(self, "queues")

    @property
    @pulumi.getter
    def settings(self) -> pulumi.Output[Optional[Sequence['outputs.EnvironmentSetting']]]:
        """
        Option settings to configure the new Environment. These
        override specific values that are set as defaults. The format is detailed
        below in Option Settings
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter(name="solutionStackName")
    def solution_stack_name(self) -> pulumi.Output[str]:
        """
        A solution stack to base your environment
        off of. Example stacks can be found in the [Amazon API documentation](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html)
        """
        return pulumi.get(self, "solution_stack_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A set of tags to apply to the Environment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the Elastic Beanstalk Configuration
        template to use in deployment
        """
        return pulumi.get(self, "template_name")

    @property
    @pulumi.getter
    def tier(self) -> pulumi.Output[Optional[str]]:
        """
        Elastic Beanstalk Environment tier. Valid values are `Worker`
        or `WebServer`. If tier is left blank `WebServer` will be used.
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter
    def triggers(self) -> pulumi.Output[Sequence[str]]:
        """
        Autoscaling triggers in use by this Environment.
        """
        return pulumi.get(self, "triggers")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        The name of the Elastic Beanstalk Application Version
        to use in deployment.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="waitForReadyTimeout")
    def wait_for_ready_timeout(self) -> pulumi.Output[Optional[str]]:
        """
        The maximum
        [duration](https://golang.org/pkg/time/#ParseDuration) that this provider should
        wait for an Elastic Beanstalk Environment to be in a ready state before timing
        out.
        """
        return pulumi.get(self, "wait_for_ready_timeout")

