# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AppCookieStickinessPolicyArgs', 'AppCookieStickinessPolicy']

@pulumi.input_type
class AppCookieStickinessPolicyArgs:
    def __init__(__self__, *,
                 cookie_name: pulumi.Input[str],
                 lb_port: pulumi.Input[int],
                 load_balancer: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AppCookieStickinessPolicy resource.
        :param pulumi.Input[str] cookie_name: Application cookie whose lifetime the ELB's cookie should follow.
        :param pulumi.Input[int] lb_port: Load balancer port to which the policy
               should be applied. This must be an active listener on the load
               balancer.
        :param pulumi.Input[str] load_balancer: Name of load balancer to which the policy
               should be attached.
        :param pulumi.Input[str] name: Name of the stickiness policy.
        """
        pulumi.set(__self__, "cookie_name", cookie_name)
        pulumi.set(__self__, "lb_port", lb_port)
        pulumi.set(__self__, "load_balancer", load_balancer)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> pulumi.Input[str]:
        """
        Application cookie whose lifetime the ELB's cookie should follow.
        """
        return pulumi.get(self, "cookie_name")

    @cookie_name.setter
    def cookie_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "cookie_name", value)

    @property
    @pulumi.getter(name="lbPort")
    def lb_port(self) -> pulumi.Input[int]:
        """
        Load balancer port to which the policy
        should be applied. This must be an active listener on the load
        balancer.
        """
        return pulumi.get(self, "lb_port")

    @lb_port.setter
    def lb_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "lb_port", value)

    @property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> pulumi.Input[str]:
        """
        Name of load balancer to which the policy
        should be attached.
        """
        return pulumi.get(self, "load_balancer")

    @load_balancer.setter
    def load_balancer(self, value: pulumi.Input[str]):
        pulumi.set(self, "load_balancer", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the stickiness policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _AppCookieStickinessPolicyState:
    def __init__(__self__, *,
                 cookie_name: Optional[pulumi.Input[str]] = None,
                 lb_port: Optional[pulumi.Input[int]] = None,
                 load_balancer: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AppCookieStickinessPolicy resources.
        :param pulumi.Input[str] cookie_name: Application cookie whose lifetime the ELB's cookie should follow.
        :param pulumi.Input[int] lb_port: Load balancer port to which the policy
               should be applied. This must be an active listener on the load
               balancer.
        :param pulumi.Input[str] load_balancer: Name of load balancer to which the policy
               should be attached.
        :param pulumi.Input[str] name: Name of the stickiness policy.
        """
        if cookie_name is not None:
            pulumi.set(__self__, "cookie_name", cookie_name)
        if lb_port is not None:
            pulumi.set(__self__, "lb_port", lb_port)
        if load_balancer is not None:
            pulumi.set(__self__, "load_balancer", load_balancer)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> Optional[pulumi.Input[str]]:
        """
        Application cookie whose lifetime the ELB's cookie should follow.
        """
        return pulumi.get(self, "cookie_name")

    @cookie_name.setter
    def cookie_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cookie_name", value)

    @property
    @pulumi.getter(name="lbPort")
    def lb_port(self) -> Optional[pulumi.Input[int]]:
        """
        Load balancer port to which the policy
        should be applied. This must be an active listener on the load
        balancer.
        """
        return pulumi.get(self, "lb_port")

    @lb_port.setter
    def lb_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "lb_port", value)

    @property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> Optional[pulumi.Input[str]]:
        """
        Name of load balancer to which the policy
        should be attached.
        """
        return pulumi.get(self, "load_balancer")

    @load_balancer.setter
    def load_balancer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the stickiness policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


class AppCookieStickinessPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cookie_name: Optional[pulumi.Input[str]] = None,
                 lb_port: Optional[pulumi.Input[int]] = None,
                 load_balancer: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides an application cookie stickiness policy, which allows an ELB to wed its sticky cookie's expiration to a cookie generated by your application.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        lb = aws.elb.LoadBalancer("lb",
            name="test-lb",
            availability_zones=["us-east-1a"],
            listeners=[aws.elb.LoadBalancerListenerArgs(
                instance_port=8000,
                instance_protocol="http",
                lb_port=80,
                lb_protocol="http",
            )])
        foo = aws.elb.AppCookieStickinessPolicy("foo",
            name="foo_policy",
            load_balancer=lb.name,
            lb_port=80,
            cookie_name="MyAppCookie")
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import application cookie stickiness policies using the ELB name, port, and policy name separated by colons (`:`). For example:

        ```sh
        $ pulumi import aws:elb/appCookieStickinessPolicy:AppCookieStickinessPolicy example my-elb:80:my-policy
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cookie_name: Application cookie whose lifetime the ELB's cookie should follow.
        :param pulumi.Input[int] lb_port: Load balancer port to which the policy
               should be applied. This must be an active listener on the load
               balancer.
        :param pulumi.Input[str] load_balancer: Name of load balancer to which the policy
               should be attached.
        :param pulumi.Input[str] name: Name of the stickiness policy.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppCookieStickinessPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an application cookie stickiness policy, which allows an ELB to wed its sticky cookie's expiration to a cookie generated by your application.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        lb = aws.elb.LoadBalancer("lb",
            name="test-lb",
            availability_zones=["us-east-1a"],
            listeners=[aws.elb.LoadBalancerListenerArgs(
                instance_port=8000,
                instance_protocol="http",
                lb_port=80,
                lb_protocol="http",
            )])
        foo = aws.elb.AppCookieStickinessPolicy("foo",
            name="foo_policy",
            load_balancer=lb.name,
            lb_port=80,
            cookie_name="MyAppCookie")
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import application cookie stickiness policies using the ELB name, port, and policy name separated by colons (`:`). For example:

        ```sh
        $ pulumi import aws:elb/appCookieStickinessPolicy:AppCookieStickinessPolicy example my-elb:80:my-policy
        ```

        :param str resource_name: The name of the resource.
        :param AppCookieStickinessPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppCookieStickinessPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cookie_name: Optional[pulumi.Input[str]] = None,
                 lb_port: Optional[pulumi.Input[int]] = None,
                 load_balancer: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppCookieStickinessPolicyArgs.__new__(AppCookieStickinessPolicyArgs)

            if cookie_name is None and not opts.urn:
                raise TypeError("Missing required property 'cookie_name'")
            __props__.__dict__["cookie_name"] = cookie_name
            if lb_port is None and not opts.urn:
                raise TypeError("Missing required property 'lb_port'")
            __props__.__dict__["lb_port"] = lb_port
            if load_balancer is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancer'")
            __props__.__dict__["load_balancer"] = load_balancer
            __props__.__dict__["name"] = name
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="aws:elasticloadbalancing/appCookieStickinessPolicy:AppCookieStickinessPolicy")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(AppCookieStickinessPolicy, __self__).__init__(
            'aws:elb/appCookieStickinessPolicy:AppCookieStickinessPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cookie_name: Optional[pulumi.Input[str]] = None,
            lb_port: Optional[pulumi.Input[int]] = None,
            load_balancer: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None) -> 'AppCookieStickinessPolicy':
        """
        Get an existing AppCookieStickinessPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cookie_name: Application cookie whose lifetime the ELB's cookie should follow.
        :param pulumi.Input[int] lb_port: Load balancer port to which the policy
               should be applied. This must be an active listener on the load
               balancer.
        :param pulumi.Input[str] load_balancer: Name of load balancer to which the policy
               should be attached.
        :param pulumi.Input[str] name: Name of the stickiness policy.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppCookieStickinessPolicyState.__new__(_AppCookieStickinessPolicyState)

        __props__.__dict__["cookie_name"] = cookie_name
        __props__.__dict__["lb_port"] = lb_port
        __props__.__dict__["load_balancer"] = load_balancer
        __props__.__dict__["name"] = name
        return AppCookieStickinessPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> pulumi.Output[str]:
        """
        Application cookie whose lifetime the ELB's cookie should follow.
        """
        return pulumi.get(self, "cookie_name")

    @property
    @pulumi.getter(name="lbPort")
    def lb_port(self) -> pulumi.Output[int]:
        """
        Load balancer port to which the policy
        should be applied. This must be an active listener on the load
        balancer.
        """
        return pulumi.get(self, "lb_port")

    @property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> pulumi.Output[str]:
        """
        Name of load balancer to which the policy
        should be attached.
        """
        return pulumi.get(self, "load_balancer")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the stickiness policy.
        """
        return pulumi.get(self, "name")

