# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'DataRepositoryAssociationS3Args',
    'DataRepositoryAssociationS3AutoExportPolicyArgs',
    'DataRepositoryAssociationS3AutoImportPolicyArgs',
    'FileCacheDataRepositoryAssociationArgs',
    'FileCacheDataRepositoryAssociationNfArgs',
    'FileCacheLustreConfigurationArgs',
    'FileCacheLustreConfigurationLogConfigurationArgs',
    'FileCacheLustreConfigurationMetadataConfigurationArgs',
    'LustreFileSystemLogConfigurationArgs',
    'LustreFileSystemRootSquashConfigurationArgs',
    'OntapFileSystemDiskIopsConfigurationArgs',
    'OntapFileSystemEndpointArgs',
    'OntapFileSystemEndpointInterclusterArgs',
    'OntapFileSystemEndpointManagementArgs',
    'OntapStorageVirtualMachineActiveDirectoryConfigurationArgs',
    'OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfigurationArgs',
    'OntapStorageVirtualMachineEndpointArgs',
    'OntapStorageVirtualMachineEndpointIscsiArgs',
    'OntapStorageVirtualMachineEndpointManagementArgs',
    'OntapStorageVirtualMachineEndpointNfArgs',
    'OntapStorageVirtualMachineEndpointSmbArgs',
    'OntapVolumeSnaplockConfigurationArgs',
    'OntapVolumeSnaplockConfigurationAutocommitPeriodArgs',
    'OntapVolumeSnaplockConfigurationRetentionPeriodArgs',
    'OntapVolumeSnaplockConfigurationRetentionPeriodDefaultRetentionArgs',
    'OntapVolumeSnaplockConfigurationRetentionPeriodMaximumRetentionArgs',
    'OntapVolumeSnaplockConfigurationRetentionPeriodMinimumRetentionArgs',
    'OntapVolumeTieringPolicyArgs',
    'OpenZfsFileSystemDiskIopsConfigurationArgs',
    'OpenZfsFileSystemRootVolumeConfigurationArgs',
    'OpenZfsFileSystemRootVolumeConfigurationNfsExportsArgs',
    'OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfigurationArgs',
    'OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgs',
    'OpenZfsVolumeNfsExportsArgs',
    'OpenZfsVolumeNfsExportsClientConfigurationArgs',
    'OpenZfsVolumeOriginSnapshotArgs',
    'OpenZfsVolumeUserAndGroupQuotaArgs',
    'WindowsFileSystemAuditLogConfigurationArgs',
    'WindowsFileSystemDiskIopsConfigurationArgs',
    'WindowsFileSystemSelfManagedActiveDirectoryArgs',
    'GetOntapStorageVirtualMachineFilterArgs',
    'GetOntapStorageVirtualMachinesFilterArgs',
    'GetOpenZfsSnapshotFilterArgs',
]

@pulumi.input_type
class DataRepositoryAssociationS3Args:
    def __init__(__self__, *,
                 auto_export_policy: Optional[pulumi.Input['DataRepositoryAssociationS3AutoExportPolicyArgs']] = None,
                 auto_import_policy: Optional[pulumi.Input['DataRepositoryAssociationS3AutoImportPolicyArgs']] = None):
        """
        :param pulumi.Input['DataRepositoryAssociationS3AutoExportPolicyArgs'] auto_export_policy: Specifies the type of updated objects that will be automatically exported from your file system to the linked S3 bucket. See the `events` configuration block.
        :param pulumi.Input['DataRepositoryAssociationS3AutoImportPolicyArgs'] auto_import_policy: Specifies the type of updated objects that will be automatically imported from the linked S3 bucket to your file system. See the `events` configuration block.
        """
        if auto_export_policy is not None:
            pulumi.set(__self__, "auto_export_policy", auto_export_policy)
        if auto_import_policy is not None:
            pulumi.set(__self__, "auto_import_policy", auto_import_policy)

    @property
    @pulumi.getter(name="autoExportPolicy")
    def auto_export_policy(self) -> Optional[pulumi.Input['DataRepositoryAssociationS3AutoExportPolicyArgs']]:
        """
        Specifies the type of updated objects that will be automatically exported from your file system to the linked S3 bucket. See the `events` configuration block.
        """
        return pulumi.get(self, "auto_export_policy")

    @auto_export_policy.setter
    def auto_export_policy(self, value: Optional[pulumi.Input['DataRepositoryAssociationS3AutoExportPolicyArgs']]):
        pulumi.set(self, "auto_export_policy", value)

    @property
    @pulumi.getter(name="autoImportPolicy")
    def auto_import_policy(self) -> Optional[pulumi.Input['DataRepositoryAssociationS3AutoImportPolicyArgs']]:
        """
        Specifies the type of updated objects that will be automatically imported from the linked S3 bucket to your file system. See the `events` configuration block.
        """
        return pulumi.get(self, "auto_import_policy")

    @auto_import_policy.setter
    def auto_import_policy(self, value: Optional[pulumi.Input['DataRepositoryAssociationS3AutoImportPolicyArgs']]):
        pulumi.set(self, "auto_import_policy", value)


@pulumi.input_type
class DataRepositoryAssociationS3AutoExportPolicyArgs:
    def __init__(__self__, *,
                 events: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] events: A list of file event types to automatically export to your linked S3 bucket or import from the linked S3 bucket. Valid values are `NEW`, `CHANGED`, `DELETED`. Max of 3.
        """
        if events is not None:
            pulumi.set(__self__, "events", events)

    @property
    @pulumi.getter
    def events(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of file event types to automatically export to your linked S3 bucket or import from the linked S3 bucket. Valid values are `NEW`, `CHANGED`, `DELETED`. Max of 3.
        """
        return pulumi.get(self, "events")

    @events.setter
    def events(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "events", value)


@pulumi.input_type
class DataRepositoryAssociationS3AutoImportPolicyArgs:
    def __init__(__self__, *,
                 events: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] events: A list of file event types to automatically export to your linked S3 bucket or import from the linked S3 bucket. Valid values are `NEW`, `CHANGED`, `DELETED`. Max of 3.
        """
        if events is not None:
            pulumi.set(__self__, "events", events)

    @property
    @pulumi.getter
    def events(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of file event types to automatically export to your linked S3 bucket or import from the linked S3 bucket. Valid values are `NEW`, `CHANGED`, `DELETED`. Max of 3.
        """
        return pulumi.get(self, "events")

    @events.setter
    def events(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "events", value)


@pulumi.input_type
class FileCacheDataRepositoryAssociationArgs:
    def __init__(__self__, *,
                 data_repository_path: pulumi.Input[str],
                 file_cache_path: pulumi.Input[str],
                 association_id: Optional[pulumi.Input[str]] = None,
                 data_repository_subdirectories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 file_cache_id: Optional[pulumi.Input[str]] = None,
                 file_system_id: Optional[pulumi.Input[str]] = None,
                 file_system_path: Optional[pulumi.Input[str]] = None,
                 imported_file_chunk_size: Optional[pulumi.Input[int]] = None,
                 nfs: Optional[pulumi.Input[Sequence[pulumi.Input['FileCacheDataRepositoryAssociationNfArgs']]]] = None,
                 resource_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] data_repository_path: The path to the S3 or NFS data repository that links to the cache.
        :param pulumi.Input[str] file_cache_path: A path on the cache that points to a high-level directory (such as /ns1/) or subdirectory (such as /ns1/subdir/) that will be mapped 1-1 with DataRepositoryPath. The leading forward slash in the name is required. Two data repository associations cannot have overlapping cache paths. For example, if a data repository is associated with cache path /ns1/, then you cannot link another data repository with cache path /ns1/ns2. This path specifies where in your cache files will be exported from. This cache directory can be linked to only one data repository, and no data repository other can be linked to the directory. Note: The cache path can only be set to root (/) on an NFS DRA when DataRepositorySubdirectories is specified. If you specify root (/) as the cache path, you can create only one DRA on the cache. The cache path cannot be set to root (/) for an S3 DRA.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] data_repository_subdirectories: A list of NFS Exports that will be linked with this data repository association. The Export paths are in the format /exportpath1. To use this parameter, you must configure DataRepositoryPath as the domain name of the NFS file system. The NFS file system domain name in effect is the root of the subdirectories. Note that DataRepositorySubdirectories is not supported for S3 data repositories. Max of 500.
        :param pulumi.Input[str] file_cache_id: The system-generated, unique ID of the cache.
        :param pulumi.Input[Sequence[pulumi.Input['FileCacheDataRepositoryAssociationNfArgs']]] nfs: (Optional) See the `nfs` configuration block.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the file cache. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "data_repository_path", data_repository_path)
        pulumi.set(__self__, "file_cache_path", file_cache_path)
        if association_id is not None:
            pulumi.set(__self__, "association_id", association_id)
        if data_repository_subdirectories is not None:
            pulumi.set(__self__, "data_repository_subdirectories", data_repository_subdirectories)
        if file_cache_id is not None:
            pulumi.set(__self__, "file_cache_id", file_cache_id)
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if file_system_path is not None:
            pulumi.set(__self__, "file_system_path", file_system_path)
        if imported_file_chunk_size is not None:
            pulumi.set(__self__, "imported_file_chunk_size", imported_file_chunk_size)
        if nfs is not None:
            pulumi.set(__self__, "nfs", nfs)
        if resource_arn is not None:
            pulumi.set(__self__, "resource_arn", resource_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="dataRepositoryPath")
    def data_repository_path(self) -> pulumi.Input[str]:
        """
        The path to the S3 or NFS data repository that links to the cache.
        """
        return pulumi.get(self, "data_repository_path")

    @data_repository_path.setter
    def data_repository_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_repository_path", value)

    @property
    @pulumi.getter(name="fileCachePath")
    def file_cache_path(self) -> pulumi.Input[str]:
        """
        A path on the cache that points to a high-level directory (such as /ns1/) or subdirectory (such as /ns1/subdir/) that will be mapped 1-1 with DataRepositoryPath. The leading forward slash in the name is required. Two data repository associations cannot have overlapping cache paths. For example, if a data repository is associated with cache path /ns1/, then you cannot link another data repository with cache path /ns1/ns2. This path specifies where in your cache files will be exported from. This cache directory can be linked to only one data repository, and no data repository other can be linked to the directory. Note: The cache path can only be set to root (/) on an NFS DRA when DataRepositorySubdirectories is specified. If you specify root (/) as the cache path, you can create only one DRA on the cache. The cache path cannot be set to root (/) for an S3 DRA.
        """
        return pulumi.get(self, "file_cache_path")

    @file_cache_path.setter
    def file_cache_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "file_cache_path", value)

    @property
    @pulumi.getter(name="associationId")
    def association_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "association_id")

    @association_id.setter
    def association_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "association_id", value)

    @property
    @pulumi.getter(name="dataRepositorySubdirectories")
    def data_repository_subdirectories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of NFS Exports that will be linked with this data repository association. The Export paths are in the format /exportpath1. To use this parameter, you must configure DataRepositoryPath as the domain name of the NFS file system. The NFS file system domain name in effect is the root of the subdirectories. Note that DataRepositorySubdirectories is not supported for S3 data repositories. Max of 500.
        """
        return pulumi.get(self, "data_repository_subdirectories")

    @data_repository_subdirectories.setter
    def data_repository_subdirectories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "data_repository_subdirectories", value)

    @property
    @pulumi.getter(name="fileCacheId")
    def file_cache_id(self) -> Optional[pulumi.Input[str]]:
        """
        The system-generated, unique ID of the cache.
        """
        return pulumi.get(self, "file_cache_id")

    @file_cache_id.setter
    def file_cache_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_cache_id", value)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_system_id", value)

    @property
    @pulumi.getter(name="fileSystemPath")
    def file_system_path(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "file_system_path")

    @file_system_path.setter
    def file_system_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_system_path", value)

    @property
    @pulumi.getter(name="importedFileChunkSize")
    def imported_file_chunk_size(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "imported_file_chunk_size")

    @imported_file_chunk_size.setter
    def imported_file_chunk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "imported_file_chunk_size", value)

    @property
    @pulumi.getter
    def nfs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileCacheDataRepositoryAssociationNfArgs']]]]:
        """
        (Optional) See the `nfs` configuration block.
        """
        return pulumi.get(self, "nfs")

    @nfs.setter
    def nfs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileCacheDataRepositoryAssociationNfArgs']]]]):
        pulumi.set(self, "nfs", value)

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "resource_arn")

    @resource_arn.setter
    def resource_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_arn", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the file cache. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class FileCacheDataRepositoryAssociationNfArgs:
    def __init__(__self__, *,
                 version: pulumi.Input[str],
                 dns_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] version: The version of the NFS (Network File System) protocol of the NFS data repository. The only supported value is NFS3, which indicates that the data repository must support the NFSv3 protocol. The only supported value is `NFS3`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_ips: A list of up to 2 IP addresses of DNS servers used to resolve the NFS file system domain name. The provided IP addresses can either be the IP addresses of a DNS forwarder or resolver that the customer manages and runs inside the customer VPC, or the IP addresses of the on-premises DNS servers.
        """
        pulumi.set(__self__, "version", version)
        if dns_ips is not None:
            pulumi.set(__self__, "dns_ips", dns_ips)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[str]:
        """
        The version of the NFS (Network File System) protocol of the NFS data repository. The only supported value is NFS3, which indicates that the data repository must support the NFSv3 protocol. The only supported value is `NFS3`.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="dnsIps")
    def dns_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of up to 2 IP addresses of DNS servers used to resolve the NFS file system domain name. The provided IP addresses can either be the IP addresses of a DNS forwarder or resolver that the customer manages and runs inside the customer VPC, or the IP addresses of the on-premises DNS servers.
        """
        return pulumi.get(self, "dns_ips")

    @dns_ips.setter
    def dns_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_ips", value)


@pulumi.input_type
class FileCacheLustreConfigurationArgs:
    def __init__(__self__, *,
                 deployment_type: pulumi.Input[str],
                 metadata_configurations: pulumi.Input[Sequence[pulumi.Input['FileCacheLustreConfigurationMetadataConfigurationArgs']]],
                 per_unit_storage_throughput: pulumi.Input[int],
                 log_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FileCacheLustreConfigurationLogConfigurationArgs']]]] = None,
                 mount_name: Optional[pulumi.Input[str]] = None,
                 weekly_maintenance_start_time: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] deployment_type: Specifies the cache deployment type. The only supported value is `CACHE_1`.
        :param pulumi.Input[Sequence[pulumi.Input['FileCacheLustreConfigurationMetadataConfigurationArgs']]] metadata_configurations: The configuration for a Lustre MDT (Metadata Target) storage volume. See the `metadata_configuration` block.
        :param pulumi.Input[int] per_unit_storage_throughput: Provisions the amount of read and write throughput for each 1 tebibyte (TiB) of cache storage capacity, in MB/s/TiB. The only supported value is `1000`.
        :param pulumi.Input[str] weekly_maintenance_start_time: A recurring weekly time, in the format `D:HH:MM`. `D` is the day of the week, for which `1` represents Monday and `7` represents Sunday. `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour. For example, 1:05:00 specifies maintenance at 5 AM Monday. See the [ISO week date](https://en.wikipedia.org/wiki/ISO_week_date) for more information.
        """
        pulumi.set(__self__, "deployment_type", deployment_type)
        pulumi.set(__self__, "metadata_configurations", metadata_configurations)
        pulumi.set(__self__, "per_unit_storage_throughput", per_unit_storage_throughput)
        if log_configurations is not None:
            pulumi.set(__self__, "log_configurations", log_configurations)
        if mount_name is not None:
            pulumi.set(__self__, "mount_name", mount_name)
        if weekly_maintenance_start_time is not None:
            pulumi.set(__self__, "weekly_maintenance_start_time", weekly_maintenance_start_time)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> pulumi.Input[str]:
        """
        Specifies the cache deployment type. The only supported value is `CACHE_1`.
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter(name="metadataConfigurations")
    def metadata_configurations(self) -> pulumi.Input[Sequence[pulumi.Input['FileCacheLustreConfigurationMetadataConfigurationArgs']]]:
        """
        The configuration for a Lustre MDT (Metadata Target) storage volume. See the `metadata_configuration` block.
        """
        return pulumi.get(self, "metadata_configurations")

    @metadata_configurations.setter
    def metadata_configurations(self, value: pulumi.Input[Sequence[pulumi.Input['FileCacheLustreConfigurationMetadataConfigurationArgs']]]):
        pulumi.set(self, "metadata_configurations", value)

    @property
    @pulumi.getter(name="perUnitStorageThroughput")
    def per_unit_storage_throughput(self) -> pulumi.Input[int]:
        """
        Provisions the amount of read and write throughput for each 1 tebibyte (TiB) of cache storage capacity, in MB/s/TiB. The only supported value is `1000`.
        """
        return pulumi.get(self, "per_unit_storage_throughput")

    @per_unit_storage_throughput.setter
    def per_unit_storage_throughput(self, value: pulumi.Input[int]):
        pulumi.set(self, "per_unit_storage_throughput", value)

    @property
    @pulumi.getter(name="logConfigurations")
    def log_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileCacheLustreConfigurationLogConfigurationArgs']]]]:
        return pulumi.get(self, "log_configurations")

    @log_configurations.setter
    def log_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileCacheLustreConfigurationLogConfigurationArgs']]]]):
        pulumi.set(self, "log_configurations", value)

    @property
    @pulumi.getter(name="mountName")
    def mount_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "mount_name")

    @mount_name.setter
    def mount_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount_name", value)

    @property
    @pulumi.getter(name="weeklyMaintenanceStartTime")
    def weekly_maintenance_start_time(self) -> Optional[pulumi.Input[str]]:
        """
        A recurring weekly time, in the format `D:HH:MM`. `D` is the day of the week, for which `1` represents Monday and `7` represents Sunday. `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour. For example, 1:05:00 specifies maintenance at 5 AM Monday. See the [ISO week date](https://en.wikipedia.org/wiki/ISO_week_date) for more information.
        """
        return pulumi.get(self, "weekly_maintenance_start_time")

    @weekly_maintenance_start_time.setter
    def weekly_maintenance_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "weekly_maintenance_start_time", value)


@pulumi.input_type
class FileCacheLustreConfigurationLogConfigurationArgs:
    def __init__(__self__, *,
                 destination: Optional[pulumi.Input[str]] = None,
                 level: Optional[pulumi.Input[str]] = None):
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if level is not None:
            pulumi.set(__self__, "level", level)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "level", value)


@pulumi.input_type
class FileCacheLustreConfigurationMetadataConfigurationArgs:
    def __init__(__self__, *,
                 storage_capacity: pulumi.Input[int]):
        """
        :param pulumi.Input[int] storage_capacity: The storage capacity of the Lustre MDT (Metadata Target) storage volume in gibibytes (GiB). The only supported value is `2400` GiB.
        """
        pulumi.set(__self__, "storage_capacity", storage_capacity)

    @property
    @pulumi.getter(name="storageCapacity")
    def storage_capacity(self) -> pulumi.Input[int]:
        """
        The storage capacity of the Lustre MDT (Metadata Target) storage volume in gibibytes (GiB). The only supported value is `2400` GiB.
        """
        return pulumi.get(self, "storage_capacity")

    @storage_capacity.setter
    def storage_capacity(self, value: pulumi.Input[int]):
        pulumi.set(self, "storage_capacity", value)


@pulumi.input_type
class LustreFileSystemLogConfigurationArgs:
    def __init__(__self__, *,
                 destination: Optional[pulumi.Input[str]] = None,
                 level: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] destination: The Amazon Resource Name (ARN) that specifies the destination of the logs. The name of the Amazon CloudWatch Logs log group must begin with the `/aws/fsx` prefix. If you do not provide a destination, Amazon FSx will create and use a log stream in the CloudWatch Logs `/aws/fsx/lustre` log group.
        :param pulumi.Input[str] level: Sets which data repository events are logged by Amazon FSx. Valid values are `WARN_ONLY`, `FAILURE_ONLY`, `ERROR_ONLY`, `WARN_ERROR` and `DISABLED`. Default value is `DISABLED`.
        """
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if level is not None:
            pulumi.set(__self__, "level", level)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) that specifies the destination of the logs. The name of the Amazon CloudWatch Logs log group must begin with the `/aws/fsx` prefix. If you do not provide a destination, Amazon FSx will create and use a log stream in the CloudWatch Logs `/aws/fsx/lustre` log group.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input[str]]:
        """
        Sets which data repository events are logged by Amazon FSx. Valid values are `WARN_ONLY`, `FAILURE_ONLY`, `ERROR_ONLY`, `WARN_ERROR` and `DISABLED`. Default value is `DISABLED`.
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "level", value)


@pulumi.input_type
class LustreFileSystemRootSquashConfigurationArgs:
    def __init__(__self__, *,
                 no_squash_nids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 root_squash: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] no_squash_nids: When root squash is enabled, you can optionally specify an array of NIDs of clients for which root squash does not apply. A client NID is a Lustre Network Identifier used to uniquely identify a client. You can specify the NID as either a single address or a range of addresses: 1. A single address is described in standard Lustre NID format by specifying the client’s IP address followed by the Lustre network ID (for example, 10.0.1.6@tcp). 2. An address range is described using a dash to separate the range (for example, 10.0.[2-10].[1-255]@tcp).
        :param pulumi.Input[str] root_squash: You enable root squash by setting a user ID (UID) and group ID (GID) for the file system in the format UID:GID (for example, 365534:65534). The UID and GID values can range from 0 to 4294967294.
        """
        if no_squash_nids is not None:
            pulumi.set(__self__, "no_squash_nids", no_squash_nids)
        if root_squash is not None:
            pulumi.set(__self__, "root_squash", root_squash)

    @property
    @pulumi.getter(name="noSquashNids")
    def no_squash_nids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        When root squash is enabled, you can optionally specify an array of NIDs of clients for which root squash does not apply. A client NID is a Lustre Network Identifier used to uniquely identify a client. You can specify the NID as either a single address or a range of addresses: 1. A single address is described in standard Lustre NID format by specifying the client’s IP address followed by the Lustre network ID (for example, 10.0.1.6@tcp). 2. An address range is described using a dash to separate the range (for example, 10.0.[2-10].[1-255]@tcp).
        """
        return pulumi.get(self, "no_squash_nids")

    @no_squash_nids.setter
    def no_squash_nids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "no_squash_nids", value)

    @property
    @pulumi.getter(name="rootSquash")
    def root_squash(self) -> Optional[pulumi.Input[str]]:
        """
        You enable root squash by setting a user ID (UID) and group ID (GID) for the file system in the format UID:GID (for example, 365534:65534). The UID and GID values can range from 0 to 4294967294.
        """
        return pulumi.get(self, "root_squash")

    @root_squash.setter
    def root_squash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root_squash", value)


@pulumi.input_type
class OntapFileSystemDiskIopsConfigurationArgs:
    def __init__(__self__, *,
                 iops: Optional[pulumi.Input[int]] = None,
                 mode: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] iops: The total number of SSD IOPS provisioned for the file system.
        :param pulumi.Input[str] mode: Specifies whether the number of IOPS for the file system is using the system. Valid values are `AUTOMATIC` and `USER_PROVISIONED`. Default value is `AUTOMATIC`.
        """
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        The total number of SSD IOPS provisioned for the file system.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the number of IOPS for the file system is using the system. Valid values are `AUTOMATIC` and `USER_PROVISIONED`. Default value is `AUTOMATIC`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class OntapFileSystemEndpointArgs:
    def __init__(__self__, *,
                 interclusters: Optional[pulumi.Input[Sequence[pulumi.Input['OntapFileSystemEndpointInterclusterArgs']]]] = None,
                 managements: Optional[pulumi.Input[Sequence[pulumi.Input['OntapFileSystemEndpointManagementArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['OntapFileSystemEndpointInterclusterArgs']]] interclusters: An endpoint for managing your file system by setting up NetApp SnapMirror with other ONTAP systems. See Endpoint.
        :param pulumi.Input[Sequence[pulumi.Input['OntapFileSystemEndpointManagementArgs']]] managements: An endpoint for managing your file system using the NetApp ONTAP CLI and NetApp ONTAP API. See Endpoint.
        """
        if interclusters is not None:
            pulumi.set(__self__, "interclusters", interclusters)
        if managements is not None:
            pulumi.set(__self__, "managements", managements)

    @property
    @pulumi.getter
    def interclusters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OntapFileSystemEndpointInterclusterArgs']]]]:
        """
        An endpoint for managing your file system by setting up NetApp SnapMirror with other ONTAP systems. See Endpoint.
        """
        return pulumi.get(self, "interclusters")

    @interclusters.setter
    def interclusters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OntapFileSystemEndpointInterclusterArgs']]]]):
        pulumi.set(self, "interclusters", value)

    @property
    @pulumi.getter
    def managements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OntapFileSystemEndpointManagementArgs']]]]:
        """
        An endpoint for managing your file system using the NetApp ONTAP CLI and NetApp ONTAP API. See Endpoint.
        """
        return pulumi.get(self, "managements")

    @managements.setter
    def managements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OntapFileSystemEndpointManagementArgs']]]]):
        pulumi.set(self, "managements", value)


@pulumi.input_type
class OntapFileSystemEndpointInterclusterArgs:
    def __init__(__self__, *,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] dns_name: The Domain Name Service (DNS) name for the file system. You can mount your file system using its DNS name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_addresses: IP addresses of the file system endpoint.
        """
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Domain Name Service (DNS) name for the file system. You can mount your file system using its DNS name.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        IP addresses of the file system endpoint.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_addresses", value)


@pulumi.input_type
class OntapFileSystemEndpointManagementArgs:
    def __init__(__self__, *,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] dns_name: The Domain Name Service (DNS) name for the file system. You can mount your file system using its DNS name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_addresses: IP addresses of the file system endpoint.
        """
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Domain Name Service (DNS) name for the file system. You can mount your file system using its DNS name.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        IP addresses of the file system endpoint.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_addresses", value)


@pulumi.input_type
class OntapStorageVirtualMachineActiveDirectoryConfigurationArgs:
    def __init__(__self__, *,
                 netbios_name: Optional[pulumi.Input[str]] = None,
                 self_managed_active_directory_configuration: Optional[pulumi.Input['OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfigurationArgs']] = None):
        """
        :param pulumi.Input[str] netbios_name: The NetBIOS name of the Active Directory computer object that will be created for your SVM. This is often the same as the SVM name but can be different. AWS limits to 15 characters because of standard NetBIOS naming limits.
        """
        if netbios_name is not None:
            pulumi.set(__self__, "netbios_name", netbios_name)
        if self_managed_active_directory_configuration is not None:
            pulumi.set(__self__, "self_managed_active_directory_configuration", self_managed_active_directory_configuration)

    @property
    @pulumi.getter(name="netbiosName")
    def netbios_name(self) -> Optional[pulumi.Input[str]]:
        """
        The NetBIOS name of the Active Directory computer object that will be created for your SVM. This is often the same as the SVM name but can be different. AWS limits to 15 characters because of standard NetBIOS naming limits.
        """
        return pulumi.get(self, "netbios_name")

    @netbios_name.setter
    def netbios_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "netbios_name", value)

    @property
    @pulumi.getter(name="selfManagedActiveDirectoryConfiguration")
    def self_managed_active_directory_configuration(self) -> Optional[pulumi.Input['OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfigurationArgs']]:
        return pulumi.get(self, "self_managed_active_directory_configuration")

    @self_managed_active_directory_configuration.setter
    def self_managed_active_directory_configuration(self, value: Optional[pulumi.Input['OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfigurationArgs']]):
        pulumi.set(self, "self_managed_active_directory_configuration", value)


@pulumi.input_type
class OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfigurationArgs:
    def __init__(__self__, *,
                 dns_ips: pulumi.Input[Sequence[pulumi.Input[str]]],
                 domain_name: pulumi.Input[str],
                 password: pulumi.Input[str],
                 username: pulumi.Input[str],
                 file_system_administrators_group: Optional[pulumi.Input[str]] = None,
                 organizational_unit_distinguished_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_ips: A list of up to three IP addresses of DNS servers or domain controllers in the self-managed AD directory.
        :param pulumi.Input[str] domain_name: The fully qualified domain name of the self-managed AD directory. For example, `corp.example.com`.
        :param pulumi.Input[str] password: The password for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        :param pulumi.Input[str] username: The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        :param pulumi.Input[str] file_system_administrators_group: The name of the domain group whose members are granted administrative privileges for the SVM. The group that you specify must already exist in your domain. Defaults to `Domain Admins`.
        :param pulumi.Input[str] organizational_unit_distinguished_name: The fully qualified distinguished name of the organizational unit within your self-managed AD directory that the Windows File Server instance will join. For example, `OU=FSx,DC=yourdomain,DC=corp,DC=com`. Only accepts OU as the direct parent of the SVM. If none is provided, the SVM is created in the default location of your self-managed AD directory. To learn more, see [RFC 2253](https://tools.ietf.org/html/rfc2253).
        """
        pulumi.set(__self__, "dns_ips", dns_ips)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if file_system_administrators_group is not None:
            pulumi.set(__self__, "file_system_administrators_group", file_system_administrators_group)
        if organizational_unit_distinguished_name is not None:
            pulumi.set(__self__, "organizational_unit_distinguished_name", organizational_unit_distinguished_name)

    @property
    @pulumi.getter(name="dnsIps")
    def dns_ips(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of up to three IP addresses of DNS servers or domain controllers in the self-managed AD directory.
        """
        return pulumi.get(self, "dns_ips")

    @dns_ips.setter
    def dns_ips(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "dns_ips", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[str]:
        """
        The fully qualified domain name of the self-managed AD directory. For example, `corp.example.com`.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        The password for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="fileSystemAdministratorsGroup")
    def file_system_administrators_group(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the domain group whose members are granted administrative privileges for the SVM. The group that you specify must already exist in your domain. Defaults to `Domain Admins`.
        """
        return pulumi.get(self, "file_system_administrators_group")

    @file_system_administrators_group.setter
    def file_system_administrators_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_system_administrators_group", value)

    @property
    @pulumi.getter(name="organizationalUnitDistinguishedName")
    def organizational_unit_distinguished_name(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified distinguished name of the organizational unit within your self-managed AD directory that the Windows File Server instance will join. For example, `OU=FSx,DC=yourdomain,DC=corp,DC=com`. Only accepts OU as the direct parent of the SVM. If none is provided, the SVM is created in the default location of your self-managed AD directory. To learn more, see [RFC 2253](https://tools.ietf.org/html/rfc2253).
        """
        return pulumi.get(self, "organizational_unit_distinguished_name")

    @organizational_unit_distinguished_name.setter
    def organizational_unit_distinguished_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organizational_unit_distinguished_name", value)


@pulumi.input_type
class OntapStorageVirtualMachineEndpointArgs:
    def __init__(__self__, *,
                 iscsis: Optional[pulumi.Input[Sequence[pulumi.Input['OntapStorageVirtualMachineEndpointIscsiArgs']]]] = None,
                 managements: Optional[pulumi.Input[Sequence[pulumi.Input['OntapStorageVirtualMachineEndpointManagementArgs']]]] = None,
                 nfs: Optional[pulumi.Input[Sequence[pulumi.Input['OntapStorageVirtualMachineEndpointNfArgs']]]] = None,
                 smbs: Optional[pulumi.Input[Sequence[pulumi.Input['OntapStorageVirtualMachineEndpointSmbArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['OntapStorageVirtualMachineEndpointIscsiArgs']]] iscsis: An endpoint for accessing data on your storage virtual machine via iSCSI protocol. See Endpoint.
        :param pulumi.Input[Sequence[pulumi.Input['OntapStorageVirtualMachineEndpointManagementArgs']]] managements: An endpoint for managing your file system using the NetApp ONTAP CLI and NetApp ONTAP API. See Endpoint.
        :param pulumi.Input[Sequence[pulumi.Input['OntapStorageVirtualMachineEndpointNfArgs']]] nfs: An endpoint for accessing data on your storage virtual machine via NFS protocol. See Endpoint.
        :param pulumi.Input[Sequence[pulumi.Input['OntapStorageVirtualMachineEndpointSmbArgs']]] smbs: An endpoint for accessing data on your storage virtual machine via SMB protocol. This is only set if an active_directory_configuration has been set. See Endpoint.
        """
        if iscsis is not None:
            pulumi.set(__self__, "iscsis", iscsis)
        if managements is not None:
            pulumi.set(__self__, "managements", managements)
        if nfs is not None:
            pulumi.set(__self__, "nfs", nfs)
        if smbs is not None:
            pulumi.set(__self__, "smbs", smbs)

    @property
    @pulumi.getter
    def iscsis(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OntapStorageVirtualMachineEndpointIscsiArgs']]]]:
        """
        An endpoint for accessing data on your storage virtual machine via iSCSI protocol. See Endpoint.
        """
        return pulumi.get(self, "iscsis")

    @iscsis.setter
    def iscsis(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OntapStorageVirtualMachineEndpointIscsiArgs']]]]):
        pulumi.set(self, "iscsis", value)

    @property
    @pulumi.getter
    def managements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OntapStorageVirtualMachineEndpointManagementArgs']]]]:
        """
        An endpoint for managing your file system using the NetApp ONTAP CLI and NetApp ONTAP API. See Endpoint.
        """
        return pulumi.get(self, "managements")

    @managements.setter
    def managements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OntapStorageVirtualMachineEndpointManagementArgs']]]]):
        pulumi.set(self, "managements", value)

    @property
    @pulumi.getter
    def nfs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OntapStorageVirtualMachineEndpointNfArgs']]]]:
        """
        An endpoint for accessing data on your storage virtual machine via NFS protocol. See Endpoint.
        """
        return pulumi.get(self, "nfs")

    @nfs.setter
    def nfs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OntapStorageVirtualMachineEndpointNfArgs']]]]):
        pulumi.set(self, "nfs", value)

    @property
    @pulumi.getter
    def smbs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OntapStorageVirtualMachineEndpointSmbArgs']]]]:
        """
        An endpoint for accessing data on your storage virtual machine via SMB protocol. This is only set if an active_directory_configuration has been set. See Endpoint.
        """
        return pulumi.get(self, "smbs")

    @smbs.setter
    def smbs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OntapStorageVirtualMachineEndpointSmbArgs']]]]):
        pulumi.set(self, "smbs", value)


@pulumi.input_type
class OntapStorageVirtualMachineEndpointIscsiArgs:
    def __init__(__self__, *,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] dns_name: The Domain Name Service (DNS) name for the storage virtual machine. You can mount your storage virtual machine using its DNS name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_addresses: IP addresses of the storage virtual machine endpoint.
        """
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Domain Name Service (DNS) name for the storage virtual machine. You can mount your storage virtual machine using its DNS name.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        IP addresses of the storage virtual machine endpoint.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_addresses", value)


@pulumi.input_type
class OntapStorageVirtualMachineEndpointManagementArgs:
    def __init__(__self__, *,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] dns_name: The Domain Name Service (DNS) name for the storage virtual machine. You can mount your storage virtual machine using its DNS name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_addresses: IP addresses of the storage virtual machine endpoint.
        """
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Domain Name Service (DNS) name for the storage virtual machine. You can mount your storage virtual machine using its DNS name.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        IP addresses of the storage virtual machine endpoint.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_addresses", value)


@pulumi.input_type
class OntapStorageVirtualMachineEndpointNfArgs:
    def __init__(__self__, *,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] dns_name: The Domain Name Service (DNS) name for the storage virtual machine. You can mount your storage virtual machine using its DNS name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_addresses: IP addresses of the storage virtual machine endpoint.
        """
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Domain Name Service (DNS) name for the storage virtual machine. You can mount your storage virtual machine using its DNS name.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        IP addresses of the storage virtual machine endpoint.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_addresses", value)


@pulumi.input_type
class OntapStorageVirtualMachineEndpointSmbArgs:
    def __init__(__self__, *,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] dns_name: The Domain Name Service (DNS) name for the storage virtual machine. You can mount your storage virtual machine using its DNS name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_addresses: IP addresses of the storage virtual machine endpoint.
        """
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Domain Name Service (DNS) name for the storage virtual machine. You can mount your storage virtual machine using its DNS name.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        IP addresses of the storage virtual machine endpoint.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_addresses", value)


@pulumi.input_type
class OntapVolumeSnaplockConfigurationArgs:
    def __init__(__self__, *,
                 snaplock_type: pulumi.Input[str],
                 audit_log_volume: Optional[pulumi.Input[bool]] = None,
                 autocommit_period: Optional[pulumi.Input['OntapVolumeSnaplockConfigurationAutocommitPeriodArgs']] = None,
                 privileged_delete: Optional[pulumi.Input[str]] = None,
                 retention_period: Optional[pulumi.Input['OntapVolumeSnaplockConfigurationRetentionPeriodArgs']] = None,
                 volume_append_mode_enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] snaplock_type: Specifies the retention mode of an FSx for ONTAP SnapLock volume. After it is set, it can't be changed. Valid values: `COMPLIANCE`, `ENTERPRISE`.
        :param pulumi.Input[bool] audit_log_volume: Enables or disables the audit log volume for an FSx for ONTAP SnapLock volume. The default value is `false`.
        :param pulumi.Input['OntapVolumeSnaplockConfigurationAutocommitPeriodArgs'] autocommit_period: The configuration object for setting the autocommit period of files in an FSx for ONTAP SnapLock volume. See Autocommit Period below.
        :param pulumi.Input[str] privileged_delete: Enables, disables, or permanently disables privileged delete on an FSx for ONTAP SnapLock Enterprise volume. Valid values: `DISABLED`, `ENABLED`, `PERMANENTLY_DISABLED`. The default value is `DISABLED`.
        :param pulumi.Input['OntapVolumeSnaplockConfigurationRetentionPeriodArgs'] retention_period: The retention period of an FSx for ONTAP SnapLock volume. See SnapLock Retention Period below.
        :param pulumi.Input[bool] volume_append_mode_enabled: Enables or disables volume-append mode on an FSx for ONTAP SnapLock volume. The default value is `false`.
        """
        pulumi.set(__self__, "snaplock_type", snaplock_type)
        if audit_log_volume is not None:
            pulumi.set(__self__, "audit_log_volume", audit_log_volume)
        if autocommit_period is not None:
            pulumi.set(__self__, "autocommit_period", autocommit_period)
        if privileged_delete is not None:
            pulumi.set(__self__, "privileged_delete", privileged_delete)
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)
        if volume_append_mode_enabled is not None:
            pulumi.set(__self__, "volume_append_mode_enabled", volume_append_mode_enabled)

    @property
    @pulumi.getter(name="snaplockType")
    def snaplock_type(self) -> pulumi.Input[str]:
        """
        Specifies the retention mode of an FSx for ONTAP SnapLock volume. After it is set, it can't be changed. Valid values: `COMPLIANCE`, `ENTERPRISE`.
        """
        return pulumi.get(self, "snaplock_type")

    @snaplock_type.setter
    def snaplock_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "snaplock_type", value)

    @property
    @pulumi.getter(name="auditLogVolume")
    def audit_log_volume(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables or disables the audit log volume for an FSx for ONTAP SnapLock volume. The default value is `false`.
        """
        return pulumi.get(self, "audit_log_volume")

    @audit_log_volume.setter
    def audit_log_volume(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "audit_log_volume", value)

    @property
    @pulumi.getter(name="autocommitPeriod")
    def autocommit_period(self) -> Optional[pulumi.Input['OntapVolumeSnaplockConfigurationAutocommitPeriodArgs']]:
        """
        The configuration object for setting the autocommit period of files in an FSx for ONTAP SnapLock volume. See Autocommit Period below.
        """
        return pulumi.get(self, "autocommit_period")

    @autocommit_period.setter
    def autocommit_period(self, value: Optional[pulumi.Input['OntapVolumeSnaplockConfigurationAutocommitPeriodArgs']]):
        pulumi.set(self, "autocommit_period", value)

    @property
    @pulumi.getter(name="privilegedDelete")
    def privileged_delete(self) -> Optional[pulumi.Input[str]]:
        """
        Enables, disables, or permanently disables privileged delete on an FSx for ONTAP SnapLock Enterprise volume. Valid values: `DISABLED`, `ENABLED`, `PERMANENTLY_DISABLED`. The default value is `DISABLED`.
        """
        return pulumi.get(self, "privileged_delete")

    @privileged_delete.setter
    def privileged_delete(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "privileged_delete", value)

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[pulumi.Input['OntapVolumeSnaplockConfigurationRetentionPeriodArgs']]:
        """
        The retention period of an FSx for ONTAP SnapLock volume. See SnapLock Retention Period below.
        """
        return pulumi.get(self, "retention_period")

    @retention_period.setter
    def retention_period(self, value: Optional[pulumi.Input['OntapVolumeSnaplockConfigurationRetentionPeriodArgs']]):
        pulumi.set(self, "retention_period", value)

    @property
    @pulumi.getter(name="volumeAppendModeEnabled")
    def volume_append_mode_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables or disables volume-append mode on an FSx for ONTAP SnapLock volume. The default value is `false`.
        """
        return pulumi.get(self, "volume_append_mode_enabled")

    @volume_append_mode_enabled.setter
    def volume_append_mode_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "volume_append_mode_enabled", value)


@pulumi.input_type
class OntapVolumeSnaplockConfigurationAutocommitPeriodArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] type: The type of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume. Setting this value to `NONE` disables autocommit. Valid values: `MINUTES`, `HOURS`, `DAYS`, `MONTHS`, `YEARS`, `NONE`.
        :param pulumi.Input[int] value: The amount of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume. Setting this value to `NONE` disables autocommit. Valid values: `MINUTES`, `HOURS`, `DAYS`, `MONTHS`, `YEARS`, `NONE`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class OntapVolumeSnaplockConfigurationRetentionPeriodArgs:
    def __init__(__self__, *,
                 default_retention: Optional[pulumi.Input['OntapVolumeSnaplockConfigurationRetentionPeriodDefaultRetentionArgs']] = None,
                 maximum_retention: Optional[pulumi.Input['OntapVolumeSnaplockConfigurationRetentionPeriodMaximumRetentionArgs']] = None,
                 minimum_retention: Optional[pulumi.Input['OntapVolumeSnaplockConfigurationRetentionPeriodMinimumRetentionArgs']] = None):
        """
        :param pulumi.Input['OntapVolumeSnaplockConfigurationRetentionPeriodDefaultRetentionArgs'] default_retention: The retention period assigned to a write once, read many (WORM) file by default if an explicit retention period is not set for an FSx for ONTAP SnapLock volume. The default retention period must be greater than or equal to the minimum retention period and less than or equal to the maximum retention period. See Retention Period below.
        :param pulumi.Input['OntapVolumeSnaplockConfigurationRetentionPeriodMaximumRetentionArgs'] maximum_retention: The longest retention period that can be assigned to a WORM file on an FSx for ONTAP SnapLock volume. See Retention Period below.
        :param pulumi.Input['OntapVolumeSnaplockConfigurationRetentionPeriodMinimumRetentionArgs'] minimum_retention: The shortest retention period that can be assigned to a WORM file on an FSx for ONTAP SnapLock volume. See Retention Period below.
        """
        if default_retention is not None:
            pulumi.set(__self__, "default_retention", default_retention)
        if maximum_retention is not None:
            pulumi.set(__self__, "maximum_retention", maximum_retention)
        if minimum_retention is not None:
            pulumi.set(__self__, "minimum_retention", minimum_retention)

    @property
    @pulumi.getter(name="defaultRetention")
    def default_retention(self) -> Optional[pulumi.Input['OntapVolumeSnaplockConfigurationRetentionPeriodDefaultRetentionArgs']]:
        """
        The retention period assigned to a write once, read many (WORM) file by default if an explicit retention period is not set for an FSx for ONTAP SnapLock volume. The default retention period must be greater than or equal to the minimum retention period and less than or equal to the maximum retention period. See Retention Period below.
        """
        return pulumi.get(self, "default_retention")

    @default_retention.setter
    def default_retention(self, value: Optional[pulumi.Input['OntapVolumeSnaplockConfigurationRetentionPeriodDefaultRetentionArgs']]):
        pulumi.set(self, "default_retention", value)

    @property
    @pulumi.getter(name="maximumRetention")
    def maximum_retention(self) -> Optional[pulumi.Input['OntapVolumeSnaplockConfigurationRetentionPeriodMaximumRetentionArgs']]:
        """
        The longest retention period that can be assigned to a WORM file on an FSx for ONTAP SnapLock volume. See Retention Period below.
        """
        return pulumi.get(self, "maximum_retention")

    @maximum_retention.setter
    def maximum_retention(self, value: Optional[pulumi.Input['OntapVolumeSnaplockConfigurationRetentionPeriodMaximumRetentionArgs']]):
        pulumi.set(self, "maximum_retention", value)

    @property
    @pulumi.getter(name="minimumRetention")
    def minimum_retention(self) -> Optional[pulumi.Input['OntapVolumeSnaplockConfigurationRetentionPeriodMinimumRetentionArgs']]:
        """
        The shortest retention period that can be assigned to a WORM file on an FSx for ONTAP SnapLock volume. See Retention Period below.
        """
        return pulumi.get(self, "minimum_retention")

    @minimum_retention.setter
    def minimum_retention(self, value: Optional[pulumi.Input['OntapVolumeSnaplockConfigurationRetentionPeriodMinimumRetentionArgs']]):
        pulumi.set(self, "minimum_retention", value)


@pulumi.input_type
class OntapVolumeSnaplockConfigurationRetentionPeriodDefaultRetentionArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] type: The type of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume. Setting this value to `NONE` disables autocommit. Valid values: `MINUTES`, `HOURS`, `DAYS`, `MONTHS`, `YEARS`, `NONE`.
        :param pulumi.Input[int] value: The amount of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume. Setting this value to `NONE` disables autocommit. Valid values: `MINUTES`, `HOURS`, `DAYS`, `MONTHS`, `YEARS`, `NONE`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class OntapVolumeSnaplockConfigurationRetentionPeriodMaximumRetentionArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] type: The type of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume. Setting this value to `NONE` disables autocommit. Valid values: `MINUTES`, `HOURS`, `DAYS`, `MONTHS`, `YEARS`, `NONE`.
        :param pulumi.Input[int] value: The amount of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume. Setting this value to `NONE` disables autocommit. Valid values: `MINUTES`, `HOURS`, `DAYS`, `MONTHS`, `YEARS`, `NONE`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class OntapVolumeSnaplockConfigurationRetentionPeriodMinimumRetentionArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] type: The type of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume. Setting this value to `NONE` disables autocommit. Valid values: `MINUTES`, `HOURS`, `DAYS`, `MONTHS`, `YEARS`, `NONE`.
        :param pulumi.Input[int] value: The amount of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume. Setting this value to `NONE` disables autocommit. Valid values: `MINUTES`, `HOURS`, `DAYS`, `MONTHS`, `YEARS`, `NONE`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class OntapVolumeTieringPolicyArgs:
    def __init__(__self__, *,
                 cooling_period: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] cooling_period: Specifies the number of days that user data in a volume must remain inactive before it is considered "cold" and moved to the capacity pool. Used with `AUTO` and `SNAPSHOT_ONLY` tiering policies only. Valid values are whole numbers between 2 and 183. Default values are 31 days for `AUTO` and 2 days for `SNAPSHOT_ONLY`.
        :param pulumi.Input[str] name: Specifies the tiering policy for the ONTAP volume for moving data to the capacity pool storage. Valid values are `SNAPSHOT_ONLY`, `AUTO`, `ALL`, `NONE`. Default value is `SNAPSHOT_ONLY`.
        """
        if cooling_period is not None:
            pulumi.set(__self__, "cooling_period", cooling_period)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="coolingPeriod")
    def cooling_period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of days that user data in a volume must remain inactive before it is considered "cold" and moved to the capacity pool. Used with `AUTO` and `SNAPSHOT_ONLY` tiering policies only. Valid values are whole numbers between 2 and 183. Default values are 31 days for `AUTO` and 2 days for `SNAPSHOT_ONLY`.
        """
        return pulumi.get(self, "cooling_period")

    @cooling_period.setter
    def cooling_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cooling_period", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the tiering policy for the ONTAP volume for moving data to the capacity pool storage. Valid values are `SNAPSHOT_ONLY`, `AUTO`, `ALL`, `NONE`. Default value is `SNAPSHOT_ONLY`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class OpenZfsFileSystemDiskIopsConfigurationArgs:
    def __init__(__self__, *,
                 iops: Optional[pulumi.Input[int]] = None,
                 mode: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] iops: The total number of SSD IOPS provisioned for the file system.
        :param pulumi.Input[str] mode: Specifies whether the number of IOPS for the file system is using the system. Valid values are `AUTOMATIC` and `USER_PROVISIONED`. Default value is `AUTOMATIC`.
        """
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        The total number of SSD IOPS provisioned for the file system.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the number of IOPS for the file system is using the system. Valid values are `AUTOMATIC` and `USER_PROVISIONED`. Default value is `AUTOMATIC`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class OpenZfsFileSystemRootVolumeConfigurationArgs:
    def __init__(__self__, *,
                 copy_tags_to_snapshots: Optional[pulumi.Input[bool]] = None,
                 data_compression_type: Optional[pulumi.Input[str]] = None,
                 nfs_exports: Optional[pulumi.Input['OpenZfsFileSystemRootVolumeConfigurationNfsExportsArgs']] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 record_size_kib: Optional[pulumi.Input[int]] = None,
                 user_and_group_quotas: Optional[pulumi.Input[Sequence[pulumi.Input['OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgs']]]] = None):
        """
        :param pulumi.Input[bool] copy_tags_to_snapshots: A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
        :param pulumi.Input[str] data_compression_type: Method used to compress the data on the volume. Valid values are `LZ4`, `NONE` or `ZSTD`. Child volumes that don't specify compression option will inherit from parent volume. This option on file system applies to the root volume.
        :param pulumi.Input['OpenZfsFileSystemRootVolumeConfigurationNfsExportsArgs'] nfs_exports: NFS export configuration for the root volume. Exactly 1 item. See NFS Exports Below.
        :param pulumi.Input[bool] read_only: specifies whether the volume is read-only. Default is false.
        :param pulumi.Input[int] record_size_kib: Specifies the record size of an OpenZFS root volume, in kibibytes (KiB). Valid values are `4`, `8`, `16`, `32`, `64`, `128`, `256`, `512`, or `1024` KiB. The default is `128` KiB.
        :param pulumi.Input[Sequence[pulumi.Input['OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgs']]] user_and_group_quotas: Specify how much storage users or groups can use on the volume. Maximum of 100 items. See User and Group Quotas Below.
        """
        if copy_tags_to_snapshots is not None:
            pulumi.set(__self__, "copy_tags_to_snapshots", copy_tags_to_snapshots)
        if data_compression_type is not None:
            pulumi.set(__self__, "data_compression_type", data_compression_type)
        if nfs_exports is not None:
            pulumi.set(__self__, "nfs_exports", nfs_exports)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if record_size_kib is not None:
            pulumi.set(__self__, "record_size_kib", record_size_kib)
        if user_and_group_quotas is not None:
            pulumi.set(__self__, "user_and_group_quotas", user_and_group_quotas)

    @property
    @pulumi.getter(name="copyTagsToSnapshots")
    def copy_tags_to_snapshots(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
        """
        return pulumi.get(self, "copy_tags_to_snapshots")

    @copy_tags_to_snapshots.setter
    def copy_tags_to_snapshots(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "copy_tags_to_snapshots", value)

    @property
    @pulumi.getter(name="dataCompressionType")
    def data_compression_type(self) -> Optional[pulumi.Input[str]]:
        """
        Method used to compress the data on the volume. Valid values are `LZ4`, `NONE` or `ZSTD`. Child volumes that don't specify compression option will inherit from parent volume. This option on file system applies to the root volume.
        """
        return pulumi.get(self, "data_compression_type")

    @data_compression_type.setter
    def data_compression_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_compression_type", value)

    @property
    @pulumi.getter(name="nfsExports")
    def nfs_exports(self) -> Optional[pulumi.Input['OpenZfsFileSystemRootVolumeConfigurationNfsExportsArgs']]:
        """
        NFS export configuration for the root volume. Exactly 1 item. See NFS Exports Below.
        """
        return pulumi.get(self, "nfs_exports")

    @nfs_exports.setter
    def nfs_exports(self, value: Optional[pulumi.Input['OpenZfsFileSystemRootVolumeConfigurationNfsExportsArgs']]):
        pulumi.set(self, "nfs_exports", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        specifies whether the volume is read-only. Default is false.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="recordSizeKib")
    def record_size_kib(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the record size of an OpenZFS root volume, in kibibytes (KiB). Valid values are `4`, `8`, `16`, `32`, `64`, `128`, `256`, `512`, or `1024` KiB. The default is `128` KiB.
        """
        return pulumi.get(self, "record_size_kib")

    @record_size_kib.setter
    def record_size_kib(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "record_size_kib", value)

    @property
    @pulumi.getter(name="userAndGroupQuotas")
    def user_and_group_quotas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgs']]]]:
        """
        Specify how much storage users or groups can use on the volume. Maximum of 100 items. See User and Group Quotas Below.
        """
        return pulumi.get(self, "user_and_group_quotas")

    @user_and_group_quotas.setter
    def user_and_group_quotas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgs']]]]):
        pulumi.set(self, "user_and_group_quotas", value)


@pulumi.input_type
class OpenZfsFileSystemRootVolumeConfigurationNfsExportsArgs:
    def __init__(__self__, *,
                 client_configurations: pulumi.Input[Sequence[pulumi.Input['OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfigurationArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfigurationArgs']]] client_configurations: A list of configuration objects that contain the client and options for mounting the OpenZFS file system. Maximum of 25 items. See Client Configurations Below.
        """
        pulumi.set(__self__, "client_configurations", client_configurations)

    @property
    @pulumi.getter(name="clientConfigurations")
    def client_configurations(self) -> pulumi.Input[Sequence[pulumi.Input['OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfigurationArgs']]]:
        """
        A list of configuration objects that contain the client and options for mounting the OpenZFS file system. Maximum of 25 items. See Client Configurations Below.
        """
        return pulumi.get(self, "client_configurations")

    @client_configurations.setter
    def client_configurations(self, value: pulumi.Input[Sequence[pulumi.Input['OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfigurationArgs']]]):
        pulumi.set(self, "client_configurations", value)


@pulumi.input_type
class OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfigurationArgs:
    def __init__(__self__, *,
                 clients: pulumi.Input[str],
                 options: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[str] clients: A value that specifies who can mount the file system. You can provide a wildcard character (*), an IP address (0.0.0.0), or a CIDR address (192.0.2.0/24. By default, Amazon FSx uses the wildcard character when specifying the client.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] options: The options to use when mounting the file system. Maximum of 20 items. See the [Linix NFS exports man page](https://linux.die.net/man/5/exports) for more information. `crossmount` and `sync` are used by default.
        """
        pulumi.set(__self__, "clients", clients)
        pulumi.set(__self__, "options", options)

    @property
    @pulumi.getter
    def clients(self) -> pulumi.Input[str]:
        """
        A value that specifies who can mount the file system. You can provide a wildcard character (*), an IP address (0.0.0.0), or a CIDR address (192.0.2.0/24. By default, Amazon FSx uses the wildcard character when specifying the client.
        """
        return pulumi.get(self, "clients")

    @clients.setter
    def clients(self, value: pulumi.Input[str]):
        pulumi.set(self, "clients", value)

    @property
    @pulumi.getter
    def options(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The options to use when mounting the file system. Maximum of 20 items. See the [Linix NFS exports man page](https://linux.die.net/man/5/exports) for more information. `crossmount` and `sync` are used by default.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "options", value)


@pulumi.input_type
class OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[int],
                 storage_capacity_quota_gib: pulumi.Input[int],
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[int] id: The ID of the user or group. Valid values between `0` and `2147483647`
        :param pulumi.Input[int] storage_capacity_quota_gib: The amount of storage that the user or group can use in gibibytes (GiB). Valid values between `0` and `2147483647`
        :param pulumi.Input[str] type: A value that specifies whether the quota applies to a user or group. Valid values are `USER` or `GROUP`.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "storage_capacity_quota_gib", storage_capacity_quota_gib)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[int]:
        """
        The ID of the user or group. Valid values between `0` and `2147483647`
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[int]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="storageCapacityQuotaGib")
    def storage_capacity_quota_gib(self) -> pulumi.Input[int]:
        """
        The amount of storage that the user or group can use in gibibytes (GiB). Valid values between `0` and `2147483647`
        """
        return pulumi.get(self, "storage_capacity_quota_gib")

    @storage_capacity_quota_gib.setter
    def storage_capacity_quota_gib(self, value: pulumi.Input[int]):
        pulumi.set(self, "storage_capacity_quota_gib", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        A value that specifies whether the quota applies to a user or group. Valid values are `USER` or `GROUP`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class OpenZfsVolumeNfsExportsArgs:
    def __init__(__self__, *,
                 client_configurations: pulumi.Input[Sequence[pulumi.Input['OpenZfsVolumeNfsExportsClientConfigurationArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['OpenZfsVolumeNfsExportsClientConfigurationArgs']]] client_configurations: A list of configuration objects that contain the client and options for mounting the OpenZFS file system. Maximum of 25 items. See `client_configurations` Block below for details.
        """
        pulumi.set(__self__, "client_configurations", client_configurations)

    @property
    @pulumi.getter(name="clientConfigurations")
    def client_configurations(self) -> pulumi.Input[Sequence[pulumi.Input['OpenZfsVolumeNfsExportsClientConfigurationArgs']]]:
        """
        A list of configuration objects that contain the client and options for mounting the OpenZFS file system. Maximum of 25 items. See `client_configurations` Block below for details.
        """
        return pulumi.get(self, "client_configurations")

    @client_configurations.setter
    def client_configurations(self, value: pulumi.Input[Sequence[pulumi.Input['OpenZfsVolumeNfsExportsClientConfigurationArgs']]]):
        pulumi.set(self, "client_configurations", value)


@pulumi.input_type
class OpenZfsVolumeNfsExportsClientConfigurationArgs:
    def __init__(__self__, *,
                 clients: pulumi.Input[str],
                 options: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[str] clients: A value that specifies who can mount the file system. You can provide a wildcard character (*), an IP address (0.0.0.0), or a CIDR address (192.0.2.0/24. By default, Amazon FSx uses the wildcard character when specifying the client.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] options: The options to use when mounting the file system. Maximum of 20 items. See the [Linix NFS exports man page](https://linux.die.net/man/5/exports) for more information. `crossmount` and `sync` are used by default.
        """
        pulumi.set(__self__, "clients", clients)
        pulumi.set(__self__, "options", options)

    @property
    @pulumi.getter
    def clients(self) -> pulumi.Input[str]:
        """
        A value that specifies who can mount the file system. You can provide a wildcard character (*), an IP address (0.0.0.0), or a CIDR address (192.0.2.0/24. By default, Amazon FSx uses the wildcard character when specifying the client.
        """
        return pulumi.get(self, "clients")

    @clients.setter
    def clients(self, value: pulumi.Input[str]):
        pulumi.set(self, "clients", value)

    @property
    @pulumi.getter
    def options(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The options to use when mounting the file system. Maximum of 20 items. See the [Linix NFS exports man page](https://linux.die.net/man/5/exports) for more information. `crossmount` and `sync` are used by default.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "options", value)


@pulumi.input_type
class OpenZfsVolumeOriginSnapshotArgs:
    def __init__(__self__, *,
                 copy_strategy: pulumi.Input[str],
                 snapshot_arn: pulumi.Input[str]):
        """
        :param pulumi.Input[str] copy_strategy: Specifies the strategy used when copying data from the snapshot to the new volume. Valid values are `CLONE`, `FULL_COPY`, `INCREMENTAL_COPY`.
        :param pulumi.Input[str] snapshot_arn: The Amazon Resource Name (ARN) of the origin snapshot.
        """
        pulumi.set(__self__, "copy_strategy", copy_strategy)
        pulumi.set(__self__, "snapshot_arn", snapshot_arn)

    @property
    @pulumi.getter(name="copyStrategy")
    def copy_strategy(self) -> pulumi.Input[str]:
        """
        Specifies the strategy used when copying data from the snapshot to the new volume. Valid values are `CLONE`, `FULL_COPY`, `INCREMENTAL_COPY`.
        """
        return pulumi.get(self, "copy_strategy")

    @copy_strategy.setter
    def copy_strategy(self, value: pulumi.Input[str]):
        pulumi.set(self, "copy_strategy", value)

    @property
    @pulumi.getter(name="snapshotArn")
    def snapshot_arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of the origin snapshot.
        """
        return pulumi.get(self, "snapshot_arn")

    @snapshot_arn.setter
    def snapshot_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "snapshot_arn", value)


@pulumi.input_type
class OpenZfsVolumeUserAndGroupQuotaArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[int],
                 storage_capacity_quota_gib: pulumi.Input[int],
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[int] id: The ID of the user or group. Valid values between `0` and `2147483647`
        :param pulumi.Input[int] storage_capacity_quota_gib: The amount of storage that the user or group can use in gibibytes (GiB). Valid values between `0` and `2147483647`
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "storage_capacity_quota_gib", storage_capacity_quota_gib)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[int]:
        """
        The ID of the user or group. Valid values between `0` and `2147483647`
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[int]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="storageCapacityQuotaGib")
    def storage_capacity_quota_gib(self) -> pulumi.Input[int]:
        """
        The amount of storage that the user or group can use in gibibytes (GiB). Valid values between `0` and `2147483647`
        """
        return pulumi.get(self, "storage_capacity_quota_gib")

    @storage_capacity_quota_gib.setter
    def storage_capacity_quota_gib(self, value: pulumi.Input[int]):
        pulumi.set(self, "storage_capacity_quota_gib", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class WindowsFileSystemAuditLogConfigurationArgs:
    def __init__(__self__, *,
                 audit_log_destination: Optional[pulumi.Input[str]] = None,
                 file_access_audit_log_level: Optional[pulumi.Input[str]] = None,
                 file_share_access_audit_log_level: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] audit_log_destination: The Amazon Resource Name (ARN) for the destination of the audit logs. The destination can be any Amazon CloudWatch Logs log group ARN or Amazon Kinesis Data Firehose delivery stream ARN. Can be specified when `file_access_audit_log_level` and `file_share_access_audit_log_level` are not set to `DISABLED`. The name of the Amazon CloudWatch Logs log group must begin with the `/aws/fsx` prefix. The name of the Amazon Kinesis Data Firehouse delivery stream must begin with the `aws-fsx` prefix. If you do not provide a destination in `audit_log_destionation`, Amazon FSx will create and use a log stream in the CloudWatch Logs /aws/fsx/windows log group.
        :param pulumi.Input[str] file_access_audit_log_level: Sets which attempt type is logged by Amazon FSx for file and folder accesses. Valid values are `SUCCESS_ONLY`, `FAILURE_ONLY`, `SUCCESS_AND_FAILURE`, and `DISABLED`. Default value is `DISABLED`.
        :param pulumi.Input[str] file_share_access_audit_log_level: Sets which attempt type is logged by Amazon FSx for file share accesses. Valid values are `SUCCESS_ONLY`, `FAILURE_ONLY`, `SUCCESS_AND_FAILURE`, and `DISABLED`. Default value is `DISABLED`.
        """
        if audit_log_destination is not None:
            pulumi.set(__self__, "audit_log_destination", audit_log_destination)
        if file_access_audit_log_level is not None:
            pulumi.set(__self__, "file_access_audit_log_level", file_access_audit_log_level)
        if file_share_access_audit_log_level is not None:
            pulumi.set(__self__, "file_share_access_audit_log_level", file_share_access_audit_log_level)

    @property
    @pulumi.getter(name="auditLogDestination")
    def audit_log_destination(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) for the destination of the audit logs. The destination can be any Amazon CloudWatch Logs log group ARN or Amazon Kinesis Data Firehose delivery stream ARN. Can be specified when `file_access_audit_log_level` and `file_share_access_audit_log_level` are not set to `DISABLED`. The name of the Amazon CloudWatch Logs log group must begin with the `/aws/fsx` prefix. The name of the Amazon Kinesis Data Firehouse delivery stream must begin with the `aws-fsx` prefix. If you do not provide a destination in `audit_log_destionation`, Amazon FSx will create and use a log stream in the CloudWatch Logs /aws/fsx/windows log group.
        """
        return pulumi.get(self, "audit_log_destination")

    @audit_log_destination.setter
    def audit_log_destination(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audit_log_destination", value)

    @property
    @pulumi.getter(name="fileAccessAuditLogLevel")
    def file_access_audit_log_level(self) -> Optional[pulumi.Input[str]]:
        """
        Sets which attempt type is logged by Amazon FSx for file and folder accesses. Valid values are `SUCCESS_ONLY`, `FAILURE_ONLY`, `SUCCESS_AND_FAILURE`, and `DISABLED`. Default value is `DISABLED`.
        """
        return pulumi.get(self, "file_access_audit_log_level")

    @file_access_audit_log_level.setter
    def file_access_audit_log_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_access_audit_log_level", value)

    @property
    @pulumi.getter(name="fileShareAccessAuditLogLevel")
    def file_share_access_audit_log_level(self) -> Optional[pulumi.Input[str]]:
        """
        Sets which attempt type is logged by Amazon FSx for file share accesses. Valid values are `SUCCESS_ONLY`, `FAILURE_ONLY`, `SUCCESS_AND_FAILURE`, and `DISABLED`. Default value is `DISABLED`.
        """
        return pulumi.get(self, "file_share_access_audit_log_level")

    @file_share_access_audit_log_level.setter
    def file_share_access_audit_log_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_share_access_audit_log_level", value)


@pulumi.input_type
class WindowsFileSystemDiskIopsConfigurationArgs:
    def __init__(__self__, *,
                 iops: Optional[pulumi.Input[int]] = None,
                 mode: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] iops: The total number of SSD IOPS provisioned for the file system.
        :param pulumi.Input[str] mode: Specifies whether the number of IOPS for the file system is using the system. Valid values are `AUTOMATIC` and `USER_PROVISIONED`. Default value is `AUTOMATIC`.
        """
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        The total number of SSD IOPS provisioned for the file system.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the number of IOPS for the file system is using the system. Valid values are `AUTOMATIC` and `USER_PROVISIONED`. Default value is `AUTOMATIC`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class WindowsFileSystemSelfManagedActiveDirectoryArgs:
    def __init__(__self__, *,
                 dns_ips: pulumi.Input[Sequence[pulumi.Input[str]]],
                 domain_name: pulumi.Input[str],
                 password: pulumi.Input[str],
                 username: pulumi.Input[str],
                 file_system_administrators_group: Optional[pulumi.Input[str]] = None,
                 organizational_unit_distinguished_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_ips: A list of up to two IP addresses of DNS servers or domain controllers in the self-managed AD directory. The IP addresses need to be either in the same VPC CIDR range as the file system or in the private IP version 4 (IPv4) address ranges as specified in [RFC 1918](https://tools.ietf.org/html/rfc1918).
        :param pulumi.Input[str] domain_name: The fully qualified domain name of the self-managed AD directory. For example, `corp.example.com`.
        :param pulumi.Input[str] password: The password for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        :param pulumi.Input[str] username: The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        :param pulumi.Input[str] file_system_administrators_group: The name of the domain group whose members are granted administrative privileges for the file system. Administrative privileges include taking ownership of files and folders, and setting audit controls (audit ACLs) on files and folders. The group that you specify must already exist in your domain. Defaults to `Domain Admins`.
        :param pulumi.Input[str] organizational_unit_distinguished_name: The fully qualified distinguished name of the organizational unit within your self-managed AD directory that the Windows File Server instance will join. For example, `OU=FSx,DC=yourdomain,DC=corp,DC=com`. Only accepts OU as the direct parent of the file system. If none is provided, the FSx file system is created in the default location of your self-managed AD directory. To learn more, see [RFC 2253](https://tools.ietf.org/html/rfc2253).
        """
        pulumi.set(__self__, "dns_ips", dns_ips)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if file_system_administrators_group is not None:
            pulumi.set(__self__, "file_system_administrators_group", file_system_administrators_group)
        if organizational_unit_distinguished_name is not None:
            pulumi.set(__self__, "organizational_unit_distinguished_name", organizational_unit_distinguished_name)

    @property
    @pulumi.getter(name="dnsIps")
    def dns_ips(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of up to two IP addresses of DNS servers or domain controllers in the self-managed AD directory. The IP addresses need to be either in the same VPC CIDR range as the file system or in the private IP version 4 (IPv4) address ranges as specified in [RFC 1918](https://tools.ietf.org/html/rfc1918).
        """
        return pulumi.get(self, "dns_ips")

    @dns_ips.setter
    def dns_ips(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "dns_ips", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[str]:
        """
        The fully qualified domain name of the self-managed AD directory. For example, `corp.example.com`.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        The password for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="fileSystemAdministratorsGroup")
    def file_system_administrators_group(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the domain group whose members are granted administrative privileges for the file system. Administrative privileges include taking ownership of files and folders, and setting audit controls (audit ACLs) on files and folders. The group that you specify must already exist in your domain. Defaults to `Domain Admins`.
        """
        return pulumi.get(self, "file_system_administrators_group")

    @file_system_administrators_group.setter
    def file_system_administrators_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_system_administrators_group", value)

    @property
    @pulumi.getter(name="organizationalUnitDistinguishedName")
    def organizational_unit_distinguished_name(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified distinguished name of the organizational unit within your self-managed AD directory that the Windows File Server instance will join. For example, `OU=FSx,DC=yourdomain,DC=corp,DC=com`. Only accepts OU as the direct parent of the file system. If none is provided, the FSx file system is created in the default location of your self-managed AD directory. To learn more, see [RFC 2253](https://tools.ietf.org/html/rfc2253).
        """
        return pulumi.get(self, "organizational_unit_distinguished_name")

    @organizational_unit_distinguished_name.setter
    def organizational_unit_distinguished_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organizational_unit_distinguished_name", value)


@pulumi.input_type
class GetOntapStorageVirtualMachineFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Name of the field to filter by, as defined by [the underlying AWS API](https://docs.aws.amazon.com/fsx/latest/APIReference/API_StorageVirtualMachineFilter.html).
        :param Sequence[str] values: Set of values that are accepted for the given field. An SVM will be selected if any one of the given values matches.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the field to filter by, as defined by [the underlying AWS API](https://docs.aws.amazon.com/fsx/latest/APIReference/API_StorageVirtualMachineFilter.html).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Set of values that are accepted for the given field. An SVM will be selected if any one of the given values matches.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetOntapStorageVirtualMachinesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Name of the field to filter by, as defined by [the underlying AWS API](https://docs.aws.amazon.com/fsx/latest/APIReference/API_StorageVirtualMachineFilter.html).
        :param Sequence[str] values: Set of values that are accepted for the given field. An SVM will be selected if any one of the given values matches.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the field to filter by, as defined by [the underlying AWS API](https://docs.aws.amazon.com/fsx/latest/APIReference/API_StorageVirtualMachineFilter.html).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Set of values that are accepted for the given field. An SVM will be selected if any one of the given values matches.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetOpenZfsSnapshotFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Name of the snapshot.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the snapshot.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


