# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetOntapStorageVirtualMachineResult',
    'AwaitableGetOntapStorageVirtualMachineResult',
    'get_ontap_storage_virtual_machine',
    'get_ontap_storage_virtual_machine_output',
]

@pulumi.output_type
class GetOntapStorageVirtualMachineResult:
    """
    A collection of values returned by getOntapStorageVirtualMachine.
    """
    def __init__(__self__, active_directory_configurations=None, arn=None, creation_time=None, endpoints=None, file_system_id=None, filters=None, id=None, lifecycle_status=None, lifecycle_transition_reasons=None, name=None, subtype=None, tags=None, uuid=None):
        if active_directory_configurations and not isinstance(active_directory_configurations, list):
            raise TypeError("Expected argument 'active_directory_configurations' to be a list")
        pulumi.set(__self__, "active_directory_configurations", active_directory_configurations)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if creation_time and not isinstance(creation_time, str):
            raise TypeError("Expected argument 'creation_time' to be a str")
        pulumi.set(__self__, "creation_time", creation_time)
        if endpoints and not isinstance(endpoints, list):
            raise TypeError("Expected argument 'endpoints' to be a list")
        pulumi.set(__self__, "endpoints", endpoints)
        if file_system_id and not isinstance(file_system_id, str):
            raise TypeError("Expected argument 'file_system_id' to be a str")
        pulumi.set(__self__, "file_system_id", file_system_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_status and not isinstance(lifecycle_status, str):
            raise TypeError("Expected argument 'lifecycle_status' to be a str")
        pulumi.set(__self__, "lifecycle_status", lifecycle_status)
        if lifecycle_transition_reasons and not isinstance(lifecycle_transition_reasons, list):
            raise TypeError("Expected argument 'lifecycle_transition_reasons' to be a list")
        pulumi.set(__self__, "lifecycle_transition_reasons", lifecycle_transition_reasons)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if subtype and not isinstance(subtype, str):
            raise TypeError("Expected argument 'subtype' to be a str")
        pulumi.set(__self__, "subtype", subtype)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if uuid and not isinstance(uuid, str):
            raise TypeError("Expected argument 'uuid' to be a str")
        pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter(name="activeDirectoryConfigurations")
    def active_directory_configurations(self) -> Sequence['outputs.GetOntapStorageVirtualMachineActiveDirectoryConfigurationResult']:
        """
        The Microsoft Active Directory configuration to which the SVM is joined, if applicable. See Active Directory Configuration below.
        """
        return pulumi.get(self, "active_directory_configurations")

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        Amazon Resource Name of the SVM.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        The time that the SVM was created.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def endpoints(self) -> Sequence['outputs.GetOntapStorageVirtualMachineEndpointResult']:
        """
        The endpoints that are used to access data or to manage the SVM using the NetApp ONTAP CLI, REST API, or NetApp CloudManager. They are the Iscsi, Management, Nfs, and Smb endpoints. See SVM Endpoints below.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> str:
        """
        Identifier of the file system (e.g. `fs-12345678`).
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetOntapStorageVirtualMachineFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The SVM's system generated unique ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleStatus")
    def lifecycle_status(self) -> str:
        """
        The SVM's lifecycle status.
        """
        return pulumi.get(self, "lifecycle_status")

    @property
    @pulumi.getter(name="lifecycleTransitionReasons")
    def lifecycle_transition_reasons(self) -> Sequence['outputs.GetOntapStorageVirtualMachineLifecycleTransitionReasonResult']:
        """
        Describes why the SVM lifecycle state changed. See Lifecycle Transition Reason below.
        """
        return pulumi.get(self, "lifecycle_transition_reasons")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the SVM, if provisioned.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def subtype(self) -> str:
        """
        The SVM's subtype.
        """
        return pulumi.get(self, "subtype")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def uuid(self) -> str:
        """
        The SVM's UUID.
        """
        return pulumi.get(self, "uuid")


class AwaitableGetOntapStorageVirtualMachineResult(GetOntapStorageVirtualMachineResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOntapStorageVirtualMachineResult(
            active_directory_configurations=self.active_directory_configurations,
            arn=self.arn,
            creation_time=self.creation_time,
            endpoints=self.endpoints,
            file_system_id=self.file_system_id,
            filters=self.filters,
            id=self.id,
            lifecycle_status=self.lifecycle_status,
            lifecycle_transition_reasons=self.lifecycle_transition_reasons,
            name=self.name,
            subtype=self.subtype,
            tags=self.tags,
            uuid=self.uuid)


def get_ontap_storage_virtual_machine(filters: Optional[Sequence[pulumi.InputType['GetOntapStorageVirtualMachineFilterArgs']]] = None,
                                      id: Optional[str] = None,
                                      tags: Optional[Mapping[str, str]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOntapStorageVirtualMachineResult:
    """
    Retrieve information on FSx ONTAP Storage Virtual Machine (SVM).

    ## Example Usage

    ### Basic Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.fsx.get_ontap_storage_virtual_machine(id="svm-12345678")
    ```
    <!--End PulumiCodeChooser -->

    ### Filter Example

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.fsx.get_ontap_storage_virtual_machine(filters=[aws.fsx.GetOntapStorageVirtualMachineFilterArgs(
        name="file-system-id",
        values=["fs-12345678"],
    )])
    ```
    <!--End PulumiCodeChooser -->


    :param Sequence[pulumi.InputType['GetOntapStorageVirtualMachineFilterArgs']] filters: Configuration block. Detailed below.
    :param str id: Identifier of the storage virtual machine (e.g. `svm-12345678`).
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:fsx/getOntapStorageVirtualMachine:getOntapStorageVirtualMachine', __args__, opts=opts, typ=GetOntapStorageVirtualMachineResult).value

    return AwaitableGetOntapStorageVirtualMachineResult(
        active_directory_configurations=pulumi.get(__ret__, 'active_directory_configurations'),
        arn=pulumi.get(__ret__, 'arn'),
        creation_time=pulumi.get(__ret__, 'creation_time'),
        endpoints=pulumi.get(__ret__, 'endpoints'),
        file_system_id=pulumi.get(__ret__, 'file_system_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_status=pulumi.get(__ret__, 'lifecycle_status'),
        lifecycle_transition_reasons=pulumi.get(__ret__, 'lifecycle_transition_reasons'),
        name=pulumi.get(__ret__, 'name'),
        subtype=pulumi.get(__ret__, 'subtype'),
        tags=pulumi.get(__ret__, 'tags'),
        uuid=pulumi.get(__ret__, 'uuid'))


@_utilities.lift_output_func(get_ontap_storage_virtual_machine)
def get_ontap_storage_virtual_machine_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetOntapStorageVirtualMachineFilterArgs']]]]] = None,
                                             id: Optional[pulumi.Input[Optional[str]]] = None,
                                             tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOntapStorageVirtualMachineResult]:
    """
    Retrieve information on FSx ONTAP Storage Virtual Machine (SVM).

    ## Example Usage

    ### Basic Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.fsx.get_ontap_storage_virtual_machine(id="svm-12345678")
    ```
    <!--End PulumiCodeChooser -->

    ### Filter Example

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.fsx.get_ontap_storage_virtual_machine(filters=[aws.fsx.GetOntapStorageVirtualMachineFilterArgs(
        name="file-system-id",
        values=["fs-12345678"],
    )])
    ```
    <!--End PulumiCodeChooser -->


    :param Sequence[pulumi.InputType['GetOntapStorageVirtualMachineFilterArgs']] filters: Configuration block. Detailed below.
    :param str id: Identifier of the storage virtual machine (e.g. `svm-12345678`).
    """
    ...
