# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OntapFileSystemArgs', 'OntapFileSystem']

@pulumi.input_type
class OntapFileSystemArgs:
    def __init__(__self__, *,
                 deployment_type: pulumi.Input[str],
                 preferred_subnet_id: pulumi.Input[str],
                 subnet_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 automatic_backup_retention_days: Optional[pulumi.Input[int]] = None,
                 daily_automatic_backup_start_time: Optional[pulumi.Input[str]] = None,
                 disk_iops_configuration: Optional[pulumi.Input['OntapFileSystemDiskIopsConfigurationArgs']] = None,
                 endpoint_ip_address_range: Optional[pulumi.Input[str]] = None,
                 fsx_admin_password: Optional[pulumi.Input[str]] = None,
                 ha_pairs: Optional[pulumi.Input[int]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 route_table_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 storage_capacity: Optional[pulumi.Input[int]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 throughput_capacity: Optional[pulumi.Input[int]] = None,
                 throughput_capacity_per_ha_pair: Optional[pulumi.Input[int]] = None,
                 weekly_maintenance_start_time: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a OntapFileSystem resource.
        :param pulumi.Input[str] deployment_type: The filesystem deployment type. Supports `MULTI_AZ_1` and `SINGLE_AZ_1`.
        :param pulumi.Input[str] preferred_subnet_id: The ID for a subnet. A subnet is a range of IP addresses in your virtual private cloud (VPC).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: A list of IDs for the subnets that the file system will be accessible from. Up to 2 subnets can be provided.
        :param pulumi.Input[int] automatic_backup_retention_days: The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days.
        :param pulumi.Input[str] daily_automatic_backup_start_time: A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00 specifies 5 AM daily. Requires `automatic_backup_retention_days` to be set.
        :param pulumi.Input['OntapFileSystemDiskIopsConfigurationArgs'] disk_iops_configuration: The SSD IOPS configuration for the Amazon FSx for NetApp ONTAP file system. See Disk Iops Configuration below.
        :param pulumi.Input[str] endpoint_ip_address_range: Specifies the IP address range in which the endpoints to access your file system will be created. By default, Amazon FSx selects an unused IP address range for you from the 198.19.* range.
        :param pulumi.Input[str] fsx_admin_password: The ONTAP administrative password for the fsxadmin user that you can use to administer your file system using the ONTAP CLI and REST API.
        :param pulumi.Input[int] ha_pairs: The number of ha_pairs to deploy for the file system. Valid values are 1 through 6. Recommend only using this parameter for 2 or more ha pairs.
        :param pulumi.Input[str] kms_key_id: ARN for the KMS Key to encrypt the file system at rest, Defaults to an AWS managed KMS Key.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] route_table_ids: Specifies the VPC route tables in which your file system's endpoints will be created. You should specify all VPC route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
        :param pulumi.Input[int] storage_capacity: The storage capacity (GiB) of the file system. Valid values between `1024` and `196608`.
        :param pulumi.Input[str] storage_type: The filesystem storage type. defaults to `SSD`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[int] throughput_capacity: Sets the throughput capacity (in MBps) for the file system that you're creating. Valid values are `128`, `256`, `512`, `1024`, `2048`, and `4096`. This parameter should only be used when specifying not using the ha_pairs parameter. Either throughput_capacity or throughput_capacity_per_ha_pair must be specified.
        :param pulumi.Input[int] throughput_capacity_per_ha_pair: Sets the throughput capacity (in MBps) for the file system that you're creating. Valid values are `3072`,`6144`. This parameter should only be used when specifying the ha_pairs parameter. Either throughput_capacity or throughput_capacity_per_ha_pair must be specified.
        :param pulumi.Input[str] weekly_maintenance_start_time: The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
        """
        pulumi.set(__self__, "deployment_type", deployment_type)
        pulumi.set(__self__, "preferred_subnet_id", preferred_subnet_id)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if automatic_backup_retention_days is not None:
            pulumi.set(__self__, "automatic_backup_retention_days", automatic_backup_retention_days)
        if daily_automatic_backup_start_time is not None:
            pulumi.set(__self__, "daily_automatic_backup_start_time", daily_automatic_backup_start_time)
        if disk_iops_configuration is not None:
            pulumi.set(__self__, "disk_iops_configuration", disk_iops_configuration)
        if endpoint_ip_address_range is not None:
            pulumi.set(__self__, "endpoint_ip_address_range", endpoint_ip_address_range)
        if fsx_admin_password is not None:
            pulumi.set(__self__, "fsx_admin_password", fsx_admin_password)
        if ha_pairs is not None:
            pulumi.set(__self__, "ha_pairs", ha_pairs)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if route_table_ids is not None:
            pulumi.set(__self__, "route_table_ids", route_table_ids)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if storage_capacity is not None:
            pulumi.set(__self__, "storage_capacity", storage_capacity)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if throughput_capacity is not None:
            pulumi.set(__self__, "throughput_capacity", throughput_capacity)
        if throughput_capacity_per_ha_pair is not None:
            pulumi.set(__self__, "throughput_capacity_per_ha_pair", throughput_capacity_per_ha_pair)
        if weekly_maintenance_start_time is not None:
            pulumi.set(__self__, "weekly_maintenance_start_time", weekly_maintenance_start_time)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> pulumi.Input[str]:
        """
        The filesystem deployment type. Supports `MULTI_AZ_1` and `SINGLE_AZ_1`.
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter(name="preferredSubnetId")
    def preferred_subnet_id(self) -> pulumi.Input[str]:
        """
        The ID for a subnet. A subnet is a range of IP addresses in your virtual private cloud (VPC).
        """
        return pulumi.get(self, "preferred_subnet_id")

    @preferred_subnet_id.setter
    def preferred_subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "preferred_subnet_id", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of IDs for the subnets that the file system will be accessible from. Up to 2 subnets can be provided.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="automaticBackupRetentionDays")
    def automatic_backup_retention_days(self) -> Optional[pulumi.Input[int]]:
        """
        The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days.
        """
        return pulumi.get(self, "automatic_backup_retention_days")

    @automatic_backup_retention_days.setter
    def automatic_backup_retention_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "automatic_backup_retention_days", value)

    @property
    @pulumi.getter(name="dailyAutomaticBackupStartTime")
    def daily_automatic_backup_start_time(self) -> Optional[pulumi.Input[str]]:
        """
        A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00 specifies 5 AM daily. Requires `automatic_backup_retention_days` to be set.
        """
        return pulumi.get(self, "daily_automatic_backup_start_time")

    @daily_automatic_backup_start_time.setter
    def daily_automatic_backup_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "daily_automatic_backup_start_time", value)

    @property
    @pulumi.getter(name="diskIopsConfiguration")
    def disk_iops_configuration(self) -> Optional[pulumi.Input['OntapFileSystemDiskIopsConfigurationArgs']]:
        """
        The SSD IOPS configuration for the Amazon FSx for NetApp ONTAP file system. See Disk Iops Configuration below.
        """
        return pulumi.get(self, "disk_iops_configuration")

    @disk_iops_configuration.setter
    def disk_iops_configuration(self, value: Optional[pulumi.Input['OntapFileSystemDiskIopsConfigurationArgs']]):
        pulumi.set(self, "disk_iops_configuration", value)

    @property
    @pulumi.getter(name="endpointIpAddressRange")
    def endpoint_ip_address_range(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the IP address range in which the endpoints to access your file system will be created. By default, Amazon FSx selects an unused IP address range for you from the 198.19.* range.
        """
        return pulumi.get(self, "endpoint_ip_address_range")

    @endpoint_ip_address_range.setter
    def endpoint_ip_address_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_ip_address_range", value)

    @property
    @pulumi.getter(name="fsxAdminPassword")
    def fsx_admin_password(self) -> Optional[pulumi.Input[str]]:
        """
        The ONTAP administrative password for the fsxadmin user that you can use to administer your file system using the ONTAP CLI and REST API.
        """
        return pulumi.get(self, "fsx_admin_password")

    @fsx_admin_password.setter
    def fsx_admin_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fsx_admin_password", value)

    @property
    @pulumi.getter(name="haPairs")
    def ha_pairs(self) -> Optional[pulumi.Input[int]]:
        """
        The number of ha_pairs to deploy for the file system. Valid values are 1 through 6. Recommend only using this parameter for 2 or more ha pairs.
        """
        return pulumi.get(self, "ha_pairs")

    @ha_pairs.setter
    def ha_pairs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ha_pairs", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARN for the KMS Key to encrypt the file system at rest, Defaults to an AWS managed KMS Key.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="routeTableIds")
    def route_table_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the VPC route tables in which your file system's endpoints will be created. You should specify all VPC route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
        """
        return pulumi.get(self, "route_table_ids")

    @route_table_ids.setter
    def route_table_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "route_table_ids", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="storageCapacity")
    def storage_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The storage capacity (GiB) of the file system. Valid values between `1024` and `196608`.
        """
        return pulumi.get(self, "storage_capacity")

    @storage_capacity.setter
    def storage_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_capacity", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[str]]:
        """
        The filesystem storage type. defaults to `SSD`.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="throughputCapacity")
    def throughput_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Sets the throughput capacity (in MBps) for the file system that you're creating. Valid values are `128`, `256`, `512`, `1024`, `2048`, and `4096`. This parameter should only be used when specifying not using the ha_pairs parameter. Either throughput_capacity or throughput_capacity_per_ha_pair must be specified.
        """
        return pulumi.get(self, "throughput_capacity")

    @throughput_capacity.setter
    def throughput_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "throughput_capacity", value)

    @property
    @pulumi.getter(name="throughputCapacityPerHaPair")
    def throughput_capacity_per_ha_pair(self) -> Optional[pulumi.Input[int]]:
        """
        Sets the throughput capacity (in MBps) for the file system that you're creating. Valid values are `3072`,`6144`. This parameter should only be used when specifying the ha_pairs parameter. Either throughput_capacity or throughput_capacity_per_ha_pair must be specified.
        """
        return pulumi.get(self, "throughput_capacity_per_ha_pair")

    @throughput_capacity_per_ha_pair.setter
    def throughput_capacity_per_ha_pair(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "throughput_capacity_per_ha_pair", value)

    @property
    @pulumi.getter(name="weeklyMaintenanceStartTime")
    def weekly_maintenance_start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
        """
        return pulumi.get(self, "weekly_maintenance_start_time")

    @weekly_maintenance_start_time.setter
    def weekly_maintenance_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "weekly_maintenance_start_time", value)


@pulumi.input_type
class _OntapFileSystemState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 automatic_backup_retention_days: Optional[pulumi.Input[int]] = None,
                 daily_automatic_backup_start_time: Optional[pulumi.Input[str]] = None,
                 deployment_type: Optional[pulumi.Input[str]] = None,
                 disk_iops_configuration: Optional[pulumi.Input['OntapFileSystemDiskIopsConfigurationArgs']] = None,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 endpoint_ip_address_range: Optional[pulumi.Input[str]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['OntapFileSystemEndpointArgs']]]] = None,
                 fsx_admin_password: Optional[pulumi.Input[str]] = None,
                 ha_pairs: Optional[pulumi.Input[int]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 network_interface_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 owner_id: Optional[pulumi.Input[str]] = None,
                 preferred_subnet_id: Optional[pulumi.Input[str]] = None,
                 route_table_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 storage_capacity: Optional[pulumi.Input[int]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 throughput_capacity: Optional[pulumi.Input[int]] = None,
                 throughput_capacity_per_ha_pair: Optional[pulumi.Input[int]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 weekly_maintenance_start_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering OntapFileSystem resources.
        :param pulumi.Input[str] arn: Amazon Resource Name of the file system.
        :param pulumi.Input[int] automatic_backup_retention_days: The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days.
        :param pulumi.Input[str] daily_automatic_backup_start_time: A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00 specifies 5 AM daily. Requires `automatic_backup_retention_days` to be set.
        :param pulumi.Input[str] deployment_type: The filesystem deployment type. Supports `MULTI_AZ_1` and `SINGLE_AZ_1`.
        :param pulumi.Input['OntapFileSystemDiskIopsConfigurationArgs'] disk_iops_configuration: The SSD IOPS configuration for the Amazon FSx for NetApp ONTAP file system. See Disk Iops Configuration below.
        :param pulumi.Input[str] dns_name: The Domain Name Service (DNS) name for the file system. You can mount your file system using its DNS name.
        :param pulumi.Input[str] endpoint_ip_address_range: Specifies the IP address range in which the endpoints to access your file system will be created. By default, Amazon FSx selects an unused IP address range for you from the 198.19.* range.
        :param pulumi.Input[Sequence[pulumi.Input['OntapFileSystemEndpointArgs']]] endpoints: The endpoints that are used to access data or to manage the file system using the NetApp ONTAP CLI, REST API, or NetApp SnapMirror. See Endpoints below.
        :param pulumi.Input[str] fsx_admin_password: The ONTAP administrative password for the fsxadmin user that you can use to administer your file system using the ONTAP CLI and REST API.
        :param pulumi.Input[int] ha_pairs: The number of ha_pairs to deploy for the file system. Valid values are 1 through 6. Recommend only using this parameter for 2 or more ha pairs.
        :param pulumi.Input[str] kms_key_id: ARN for the KMS Key to encrypt the file system at rest, Defaults to an AWS managed KMS Key.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_interface_ids: Set of Elastic Network Interface identifiers from which the file system is accessible The first network interface returned is the primary network interface.
        :param pulumi.Input[str] owner_id: AWS account identifier that created the file system.
        :param pulumi.Input[str] preferred_subnet_id: The ID for a subnet. A subnet is a range of IP addresses in your virtual private cloud (VPC).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] route_table_ids: Specifies the VPC route tables in which your file system's endpoints will be created. You should specify all VPC route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
        :param pulumi.Input[int] storage_capacity: The storage capacity (GiB) of the file system. Valid values between `1024` and `196608`.
        :param pulumi.Input[str] storage_type: The filesystem storage type. defaults to `SSD`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: A list of IDs for the subnets that the file system will be accessible from. Up to 2 subnets can be provided.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[int] throughput_capacity: Sets the throughput capacity (in MBps) for the file system that you're creating. Valid values are `128`, `256`, `512`, `1024`, `2048`, and `4096`. This parameter should only be used when specifying not using the ha_pairs parameter. Either throughput_capacity or throughput_capacity_per_ha_pair must be specified.
        :param pulumi.Input[int] throughput_capacity_per_ha_pair: Sets the throughput capacity (in MBps) for the file system that you're creating. Valid values are `3072`,`6144`. This parameter should only be used when specifying the ha_pairs parameter. Either throughput_capacity or throughput_capacity_per_ha_pair must be specified.
        :param pulumi.Input[str] vpc_id: Identifier of the Virtual Private Cloud for the file system.
        :param pulumi.Input[str] weekly_maintenance_start_time: The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if automatic_backup_retention_days is not None:
            pulumi.set(__self__, "automatic_backup_retention_days", automatic_backup_retention_days)
        if daily_automatic_backup_start_time is not None:
            pulumi.set(__self__, "daily_automatic_backup_start_time", daily_automatic_backup_start_time)
        if deployment_type is not None:
            pulumi.set(__self__, "deployment_type", deployment_type)
        if disk_iops_configuration is not None:
            pulumi.set(__self__, "disk_iops_configuration", disk_iops_configuration)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if endpoint_ip_address_range is not None:
            pulumi.set(__self__, "endpoint_ip_address_range", endpoint_ip_address_range)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if fsx_admin_password is not None:
            pulumi.set(__self__, "fsx_admin_password", fsx_admin_password)
        if ha_pairs is not None:
            pulumi.set(__self__, "ha_pairs", ha_pairs)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if network_interface_ids is not None:
            pulumi.set(__self__, "network_interface_ids", network_interface_ids)
        if owner_id is not None:
            pulumi.set(__self__, "owner_id", owner_id)
        if preferred_subnet_id is not None:
            pulumi.set(__self__, "preferred_subnet_id", preferred_subnet_id)
        if route_table_ids is not None:
            pulumi.set(__self__, "route_table_ids", route_table_ids)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if storage_capacity is not None:
            pulumi.set(__self__, "storage_capacity", storage_capacity)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if throughput_capacity is not None:
            pulumi.set(__self__, "throughput_capacity", throughput_capacity)
        if throughput_capacity_per_ha_pair is not None:
            pulumi.set(__self__, "throughput_capacity_per_ha_pair", throughput_capacity_per_ha_pair)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if weekly_maintenance_start_time is not None:
            pulumi.set(__self__, "weekly_maintenance_start_time", weekly_maintenance_start_time)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name of the file system.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="automaticBackupRetentionDays")
    def automatic_backup_retention_days(self) -> Optional[pulumi.Input[int]]:
        """
        The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days.
        """
        return pulumi.get(self, "automatic_backup_retention_days")

    @automatic_backup_retention_days.setter
    def automatic_backup_retention_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "automatic_backup_retention_days", value)

    @property
    @pulumi.getter(name="dailyAutomaticBackupStartTime")
    def daily_automatic_backup_start_time(self) -> Optional[pulumi.Input[str]]:
        """
        A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00 specifies 5 AM daily. Requires `automatic_backup_retention_days` to be set.
        """
        return pulumi.get(self, "daily_automatic_backup_start_time")

    @daily_automatic_backup_start_time.setter
    def daily_automatic_backup_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "daily_automatic_backup_start_time", value)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The filesystem deployment type. Supports `MULTI_AZ_1` and `SINGLE_AZ_1`.
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter(name="diskIopsConfiguration")
    def disk_iops_configuration(self) -> Optional[pulumi.Input['OntapFileSystemDiskIopsConfigurationArgs']]:
        """
        The SSD IOPS configuration for the Amazon FSx for NetApp ONTAP file system. See Disk Iops Configuration below.
        """
        return pulumi.get(self, "disk_iops_configuration")

    @disk_iops_configuration.setter
    def disk_iops_configuration(self, value: Optional[pulumi.Input['OntapFileSystemDiskIopsConfigurationArgs']]):
        pulumi.set(self, "disk_iops_configuration", value)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Domain Name Service (DNS) name for the file system. You can mount your file system using its DNS name.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="endpointIpAddressRange")
    def endpoint_ip_address_range(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the IP address range in which the endpoints to access your file system will be created. By default, Amazon FSx selects an unused IP address range for you from the 198.19.* range.
        """
        return pulumi.get(self, "endpoint_ip_address_range")

    @endpoint_ip_address_range.setter
    def endpoint_ip_address_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_ip_address_range", value)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OntapFileSystemEndpointArgs']]]]:
        """
        The endpoints that are used to access data or to manage the file system using the NetApp ONTAP CLI, REST API, or NetApp SnapMirror. See Endpoints below.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OntapFileSystemEndpointArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter(name="fsxAdminPassword")
    def fsx_admin_password(self) -> Optional[pulumi.Input[str]]:
        """
        The ONTAP administrative password for the fsxadmin user that you can use to administer your file system using the ONTAP CLI and REST API.
        """
        return pulumi.get(self, "fsx_admin_password")

    @fsx_admin_password.setter
    def fsx_admin_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fsx_admin_password", value)

    @property
    @pulumi.getter(name="haPairs")
    def ha_pairs(self) -> Optional[pulumi.Input[int]]:
        """
        The number of ha_pairs to deploy for the file system. Valid values are 1 through 6. Recommend only using this parameter for 2 or more ha pairs.
        """
        return pulumi.get(self, "ha_pairs")

    @ha_pairs.setter
    def ha_pairs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ha_pairs", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARN for the KMS Key to encrypt the file system at rest, Defaults to an AWS managed KMS Key.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="networkInterfaceIds")
    def network_interface_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of Elastic Network Interface identifiers from which the file system is accessible The first network interface returned is the primary network interface.
        """
        return pulumi.get(self, "network_interface_ids")

    @network_interface_ids.setter
    def network_interface_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "network_interface_ids", value)

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[pulumi.Input[str]]:
        """
        AWS account identifier that created the file system.
        """
        return pulumi.get(self, "owner_id")

    @owner_id.setter
    def owner_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner_id", value)

    @property
    @pulumi.getter(name="preferredSubnetId")
    def preferred_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID for a subnet. A subnet is a range of IP addresses in your virtual private cloud (VPC).
        """
        return pulumi.get(self, "preferred_subnet_id")

    @preferred_subnet_id.setter
    def preferred_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_subnet_id", value)

    @property
    @pulumi.getter(name="routeTableIds")
    def route_table_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the VPC route tables in which your file system's endpoints will be created. You should specify all VPC route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
        """
        return pulumi.get(self, "route_table_ids")

    @route_table_ids.setter
    def route_table_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "route_table_ids", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="storageCapacity")
    def storage_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The storage capacity (GiB) of the file system. Valid values between `1024` and `196608`.
        """
        return pulumi.get(self, "storage_capacity")

    @storage_capacity.setter
    def storage_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_capacity", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[str]]:
        """
        The filesystem storage type. defaults to `SSD`.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of IDs for the subnets that the file system will be accessible from. Up to 2 subnets can be provided.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="throughputCapacity")
    def throughput_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Sets the throughput capacity (in MBps) for the file system that you're creating. Valid values are `128`, `256`, `512`, `1024`, `2048`, and `4096`. This parameter should only be used when specifying not using the ha_pairs parameter. Either throughput_capacity or throughput_capacity_per_ha_pair must be specified.
        """
        return pulumi.get(self, "throughput_capacity")

    @throughput_capacity.setter
    def throughput_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "throughput_capacity", value)

    @property
    @pulumi.getter(name="throughputCapacityPerHaPair")
    def throughput_capacity_per_ha_pair(self) -> Optional[pulumi.Input[int]]:
        """
        Sets the throughput capacity (in MBps) for the file system that you're creating. Valid values are `3072`,`6144`. This parameter should only be used when specifying the ha_pairs parameter. Either throughput_capacity or throughput_capacity_per_ha_pair must be specified.
        """
        return pulumi.get(self, "throughput_capacity_per_ha_pair")

    @throughput_capacity_per_ha_pair.setter
    def throughput_capacity_per_ha_pair(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "throughput_capacity_per_ha_pair", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the Virtual Private Cloud for the file system.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="weeklyMaintenanceStartTime")
    def weekly_maintenance_start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
        """
        return pulumi.get(self, "weekly_maintenance_start_time")

    @weekly_maintenance_start_time.setter
    def weekly_maintenance_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "weekly_maintenance_start_time", value)


class OntapFileSystem(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automatic_backup_retention_days: Optional[pulumi.Input[int]] = None,
                 daily_automatic_backup_start_time: Optional[pulumi.Input[str]] = None,
                 deployment_type: Optional[pulumi.Input[str]] = None,
                 disk_iops_configuration: Optional[pulumi.Input[pulumi.InputType['OntapFileSystemDiskIopsConfigurationArgs']]] = None,
                 endpoint_ip_address_range: Optional[pulumi.Input[str]] = None,
                 fsx_admin_password: Optional[pulumi.Input[str]] = None,
                 ha_pairs: Optional[pulumi.Input[int]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 preferred_subnet_id: Optional[pulumi.Input[str]] = None,
                 route_table_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 storage_capacity: Optional[pulumi.Input[int]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 throughput_capacity: Optional[pulumi.Input[int]] = None,
                 throughput_capacity_per_ha_pair: Optional[pulumi.Input[int]] = None,
                 weekly_maintenance_start_time: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages an Amazon FSx for NetApp ONTAP file system.
        See the [FSx ONTAP User Guide](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/what-is-fsx-ontap.html) for more information.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.fsx.OntapFileSystem("test",
            storage_capacity=1024,
            subnet_ids=[
                test1["id"],
                test2["id"],
            ],
            deployment_type="MULTI_AZ_1",
            throughput_capacity=512,
            preferred_subnet_id=test1["id"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import FSx File Systems using the `id`. For example:

        ```sh
        $ pulumi import aws:fsx/ontapFileSystem:OntapFileSystem example fs-543ab12b1ca672f33
        ```
        Certain resource arguments, like `security_group_ids`, do not have a FSx API method for reading the information after creation. If the argument is set in the Pulumi program on an imported resource, Pulumi will always show a difference. To workaround this behavior, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] automatic_backup_retention_days: The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days.
        :param pulumi.Input[str] daily_automatic_backup_start_time: A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00 specifies 5 AM daily. Requires `automatic_backup_retention_days` to be set.
        :param pulumi.Input[str] deployment_type: The filesystem deployment type. Supports `MULTI_AZ_1` and `SINGLE_AZ_1`.
        :param pulumi.Input[pulumi.InputType['OntapFileSystemDiskIopsConfigurationArgs']] disk_iops_configuration: The SSD IOPS configuration for the Amazon FSx for NetApp ONTAP file system. See Disk Iops Configuration below.
        :param pulumi.Input[str] endpoint_ip_address_range: Specifies the IP address range in which the endpoints to access your file system will be created. By default, Amazon FSx selects an unused IP address range for you from the 198.19.* range.
        :param pulumi.Input[str] fsx_admin_password: The ONTAP administrative password for the fsxadmin user that you can use to administer your file system using the ONTAP CLI and REST API.
        :param pulumi.Input[int] ha_pairs: The number of ha_pairs to deploy for the file system. Valid values are 1 through 6. Recommend only using this parameter for 2 or more ha pairs.
        :param pulumi.Input[str] kms_key_id: ARN for the KMS Key to encrypt the file system at rest, Defaults to an AWS managed KMS Key.
        :param pulumi.Input[str] preferred_subnet_id: The ID for a subnet. A subnet is a range of IP addresses in your virtual private cloud (VPC).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] route_table_ids: Specifies the VPC route tables in which your file system's endpoints will be created. You should specify all VPC route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
        :param pulumi.Input[int] storage_capacity: The storage capacity (GiB) of the file system. Valid values between `1024` and `196608`.
        :param pulumi.Input[str] storage_type: The filesystem storage type. defaults to `SSD`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: A list of IDs for the subnets that the file system will be accessible from. Up to 2 subnets can be provided.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[int] throughput_capacity: Sets the throughput capacity (in MBps) for the file system that you're creating. Valid values are `128`, `256`, `512`, `1024`, `2048`, and `4096`. This parameter should only be used when specifying not using the ha_pairs parameter. Either throughput_capacity or throughput_capacity_per_ha_pair must be specified.
        :param pulumi.Input[int] throughput_capacity_per_ha_pair: Sets the throughput capacity (in MBps) for the file system that you're creating. Valid values are `3072`,`6144`. This parameter should only be used when specifying the ha_pairs parameter. Either throughput_capacity or throughput_capacity_per_ha_pair must be specified.
        :param pulumi.Input[str] weekly_maintenance_start_time: The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OntapFileSystemArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Amazon FSx for NetApp ONTAP file system.
        See the [FSx ONTAP User Guide](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/what-is-fsx-ontap.html) for more information.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.fsx.OntapFileSystem("test",
            storage_capacity=1024,
            subnet_ids=[
                test1["id"],
                test2["id"],
            ],
            deployment_type="MULTI_AZ_1",
            throughput_capacity=512,
            preferred_subnet_id=test1["id"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import FSx File Systems using the `id`. For example:

        ```sh
        $ pulumi import aws:fsx/ontapFileSystem:OntapFileSystem example fs-543ab12b1ca672f33
        ```
        Certain resource arguments, like `security_group_ids`, do not have a FSx API method for reading the information after creation. If the argument is set in the Pulumi program on an imported resource, Pulumi will always show a difference. To workaround this behavior, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:

        :param str resource_name: The name of the resource.
        :param OntapFileSystemArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OntapFileSystemArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automatic_backup_retention_days: Optional[pulumi.Input[int]] = None,
                 daily_automatic_backup_start_time: Optional[pulumi.Input[str]] = None,
                 deployment_type: Optional[pulumi.Input[str]] = None,
                 disk_iops_configuration: Optional[pulumi.Input[pulumi.InputType['OntapFileSystemDiskIopsConfigurationArgs']]] = None,
                 endpoint_ip_address_range: Optional[pulumi.Input[str]] = None,
                 fsx_admin_password: Optional[pulumi.Input[str]] = None,
                 ha_pairs: Optional[pulumi.Input[int]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 preferred_subnet_id: Optional[pulumi.Input[str]] = None,
                 route_table_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 storage_capacity: Optional[pulumi.Input[int]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 throughput_capacity: Optional[pulumi.Input[int]] = None,
                 throughput_capacity_per_ha_pair: Optional[pulumi.Input[int]] = None,
                 weekly_maintenance_start_time: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OntapFileSystemArgs.__new__(OntapFileSystemArgs)

            __props__.__dict__["automatic_backup_retention_days"] = automatic_backup_retention_days
            __props__.__dict__["daily_automatic_backup_start_time"] = daily_automatic_backup_start_time
            if deployment_type is None and not opts.urn:
                raise TypeError("Missing required property 'deployment_type'")
            __props__.__dict__["deployment_type"] = deployment_type
            __props__.__dict__["disk_iops_configuration"] = disk_iops_configuration
            __props__.__dict__["endpoint_ip_address_range"] = endpoint_ip_address_range
            __props__.__dict__["fsx_admin_password"] = None if fsx_admin_password is None else pulumi.Output.secret(fsx_admin_password)
            __props__.__dict__["ha_pairs"] = ha_pairs
            __props__.__dict__["kms_key_id"] = kms_key_id
            if preferred_subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'preferred_subnet_id'")
            __props__.__dict__["preferred_subnet_id"] = preferred_subnet_id
            __props__.__dict__["route_table_ids"] = route_table_ids
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["storage_capacity"] = storage_capacity
            __props__.__dict__["storage_type"] = storage_type
            if subnet_ids is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_ids'")
            __props__.__dict__["subnet_ids"] = subnet_ids
            __props__.__dict__["tags"] = tags
            __props__.__dict__["throughput_capacity"] = throughput_capacity
            __props__.__dict__["throughput_capacity_per_ha_pair"] = throughput_capacity_per_ha_pair
            __props__.__dict__["weekly_maintenance_start_time"] = weekly_maintenance_start_time
            __props__.__dict__["arn"] = None
            __props__.__dict__["dns_name"] = None
            __props__.__dict__["endpoints"] = None
            __props__.__dict__["network_interface_ids"] = None
            __props__.__dict__["owner_id"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["vpc_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["fsxAdminPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(OntapFileSystem, __self__).__init__(
            'aws:fsx/ontapFileSystem:OntapFileSystem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            automatic_backup_retention_days: Optional[pulumi.Input[int]] = None,
            daily_automatic_backup_start_time: Optional[pulumi.Input[str]] = None,
            deployment_type: Optional[pulumi.Input[str]] = None,
            disk_iops_configuration: Optional[pulumi.Input[pulumi.InputType['OntapFileSystemDiskIopsConfigurationArgs']]] = None,
            dns_name: Optional[pulumi.Input[str]] = None,
            endpoint_ip_address_range: Optional[pulumi.Input[str]] = None,
            endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OntapFileSystemEndpointArgs']]]]] = None,
            fsx_admin_password: Optional[pulumi.Input[str]] = None,
            ha_pairs: Optional[pulumi.Input[int]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            network_interface_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            owner_id: Optional[pulumi.Input[str]] = None,
            preferred_subnet_id: Optional[pulumi.Input[str]] = None,
            route_table_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            storage_capacity: Optional[pulumi.Input[int]] = None,
            storage_type: Optional[pulumi.Input[str]] = None,
            subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            throughput_capacity: Optional[pulumi.Input[int]] = None,
            throughput_capacity_per_ha_pair: Optional[pulumi.Input[int]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            weekly_maintenance_start_time: Optional[pulumi.Input[str]] = None) -> 'OntapFileSystem':
        """
        Get an existing OntapFileSystem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: Amazon Resource Name of the file system.
        :param pulumi.Input[int] automatic_backup_retention_days: The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days.
        :param pulumi.Input[str] daily_automatic_backup_start_time: A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00 specifies 5 AM daily. Requires `automatic_backup_retention_days` to be set.
        :param pulumi.Input[str] deployment_type: The filesystem deployment type. Supports `MULTI_AZ_1` and `SINGLE_AZ_1`.
        :param pulumi.Input[pulumi.InputType['OntapFileSystemDiskIopsConfigurationArgs']] disk_iops_configuration: The SSD IOPS configuration for the Amazon FSx for NetApp ONTAP file system. See Disk Iops Configuration below.
        :param pulumi.Input[str] dns_name: The Domain Name Service (DNS) name for the file system. You can mount your file system using its DNS name.
        :param pulumi.Input[str] endpoint_ip_address_range: Specifies the IP address range in which the endpoints to access your file system will be created. By default, Amazon FSx selects an unused IP address range for you from the 198.19.* range.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OntapFileSystemEndpointArgs']]]] endpoints: The endpoints that are used to access data or to manage the file system using the NetApp ONTAP CLI, REST API, or NetApp SnapMirror. See Endpoints below.
        :param pulumi.Input[str] fsx_admin_password: The ONTAP administrative password for the fsxadmin user that you can use to administer your file system using the ONTAP CLI and REST API.
        :param pulumi.Input[int] ha_pairs: The number of ha_pairs to deploy for the file system. Valid values are 1 through 6. Recommend only using this parameter for 2 or more ha pairs.
        :param pulumi.Input[str] kms_key_id: ARN for the KMS Key to encrypt the file system at rest, Defaults to an AWS managed KMS Key.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_interface_ids: Set of Elastic Network Interface identifiers from which the file system is accessible The first network interface returned is the primary network interface.
        :param pulumi.Input[str] owner_id: AWS account identifier that created the file system.
        :param pulumi.Input[str] preferred_subnet_id: The ID for a subnet. A subnet is a range of IP addresses in your virtual private cloud (VPC).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] route_table_ids: Specifies the VPC route tables in which your file system's endpoints will be created. You should specify all VPC route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
        :param pulumi.Input[int] storage_capacity: The storage capacity (GiB) of the file system. Valid values between `1024` and `196608`.
        :param pulumi.Input[str] storage_type: The filesystem storage type. defaults to `SSD`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: A list of IDs for the subnets that the file system will be accessible from. Up to 2 subnets can be provided.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[int] throughput_capacity: Sets the throughput capacity (in MBps) for the file system that you're creating. Valid values are `128`, `256`, `512`, `1024`, `2048`, and `4096`. This parameter should only be used when specifying not using the ha_pairs parameter. Either throughput_capacity or throughput_capacity_per_ha_pair must be specified.
        :param pulumi.Input[int] throughput_capacity_per_ha_pair: Sets the throughput capacity (in MBps) for the file system that you're creating. Valid values are `3072`,`6144`. This parameter should only be used when specifying the ha_pairs parameter. Either throughput_capacity or throughput_capacity_per_ha_pair must be specified.
        :param pulumi.Input[str] vpc_id: Identifier of the Virtual Private Cloud for the file system.
        :param pulumi.Input[str] weekly_maintenance_start_time: The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OntapFileSystemState.__new__(_OntapFileSystemState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["automatic_backup_retention_days"] = automatic_backup_retention_days
        __props__.__dict__["daily_automatic_backup_start_time"] = daily_automatic_backup_start_time
        __props__.__dict__["deployment_type"] = deployment_type
        __props__.__dict__["disk_iops_configuration"] = disk_iops_configuration
        __props__.__dict__["dns_name"] = dns_name
        __props__.__dict__["endpoint_ip_address_range"] = endpoint_ip_address_range
        __props__.__dict__["endpoints"] = endpoints
        __props__.__dict__["fsx_admin_password"] = fsx_admin_password
        __props__.__dict__["ha_pairs"] = ha_pairs
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["network_interface_ids"] = network_interface_ids
        __props__.__dict__["owner_id"] = owner_id
        __props__.__dict__["preferred_subnet_id"] = preferred_subnet_id
        __props__.__dict__["route_table_ids"] = route_table_ids
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["storage_capacity"] = storage_capacity
        __props__.__dict__["storage_type"] = storage_type
        __props__.__dict__["subnet_ids"] = subnet_ids
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["throughput_capacity"] = throughput_capacity
        __props__.__dict__["throughput_capacity_per_ha_pair"] = throughput_capacity_per_ha_pair
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["weekly_maintenance_start_time"] = weekly_maintenance_start_time
        return OntapFileSystem(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        Amazon Resource Name of the file system.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="automaticBackupRetentionDays")
    def automatic_backup_retention_days(self) -> pulumi.Output[Optional[int]]:
        """
        The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days.
        """
        return pulumi.get(self, "automatic_backup_retention_days")

    @property
    @pulumi.getter(name="dailyAutomaticBackupStartTime")
    def daily_automatic_backup_start_time(self) -> pulumi.Output[str]:
        """
        A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00 specifies 5 AM daily. Requires `automatic_backup_retention_days` to be set.
        """
        return pulumi.get(self, "daily_automatic_backup_start_time")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> pulumi.Output[str]:
        """
        The filesystem deployment type. Supports `MULTI_AZ_1` and `SINGLE_AZ_1`.
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="diskIopsConfiguration")
    def disk_iops_configuration(self) -> pulumi.Output['outputs.OntapFileSystemDiskIopsConfiguration']:
        """
        The SSD IOPS configuration for the Amazon FSx for NetApp ONTAP file system. See Disk Iops Configuration below.
        """
        return pulumi.get(self, "disk_iops_configuration")

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> pulumi.Output[str]:
        """
        The Domain Name Service (DNS) name for the file system. You can mount your file system using its DNS name.
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="endpointIpAddressRange")
    def endpoint_ip_address_range(self) -> pulumi.Output[str]:
        """
        Specifies the IP address range in which the endpoints to access your file system will be created. By default, Amazon FSx selects an unused IP address range for you from the 198.19.* range.
        """
        return pulumi.get(self, "endpoint_ip_address_range")

    @property
    @pulumi.getter
    def endpoints(self) -> pulumi.Output[Sequence['outputs.OntapFileSystemEndpoint']]:
        """
        The endpoints that are used to access data or to manage the file system using the NetApp ONTAP CLI, REST API, or NetApp SnapMirror. See Endpoints below.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="fsxAdminPassword")
    def fsx_admin_password(self) -> pulumi.Output[Optional[str]]:
        """
        The ONTAP administrative password for the fsxadmin user that you can use to administer your file system using the ONTAP CLI and REST API.
        """
        return pulumi.get(self, "fsx_admin_password")

    @property
    @pulumi.getter(name="haPairs")
    def ha_pairs(self) -> pulumi.Output[int]:
        """
        The number of ha_pairs to deploy for the file system. Valid values are 1 through 6. Recommend only using this parameter for 2 or more ha pairs.
        """
        return pulumi.get(self, "ha_pairs")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[str]:
        """
        ARN for the KMS Key to encrypt the file system at rest, Defaults to an AWS managed KMS Key.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="networkInterfaceIds")
    def network_interface_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        Set of Elastic Network Interface identifiers from which the file system is accessible The first network interface returned is the primary network interface.
        """
        return pulumi.get(self, "network_interface_ids")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> pulumi.Output[str]:
        """
        AWS account identifier that created the file system.
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter(name="preferredSubnetId")
    def preferred_subnet_id(self) -> pulumi.Output[str]:
        """
        The ID for a subnet. A subnet is a range of IP addresses in your virtual private cloud (VPC).
        """
        return pulumi.get(self, "preferred_subnet_id")

    @property
    @pulumi.getter(name="routeTableIds")
    def route_table_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        Specifies the VPC route tables in which your file system's endpoints will be created. You should specify all VPC route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
        """
        return pulumi.get(self, "route_table_ids")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="storageCapacity")
    def storage_capacity(self) -> pulumi.Output[Optional[int]]:
        """
        The storage capacity (GiB) of the file system. Valid values between `1024` and `196608`.
        """
        return pulumi.get(self, "storage_capacity")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Output[Optional[str]]:
        """
        The filesystem storage type. defaults to `SSD`.
        """
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of IDs for the subnets that the file system will be accessible from. Up to 2 subnets can be provided.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="throughputCapacity")
    def throughput_capacity(self) -> pulumi.Output[Optional[int]]:
        """
        Sets the throughput capacity (in MBps) for the file system that you're creating. Valid values are `128`, `256`, `512`, `1024`, `2048`, and `4096`. This parameter should only be used when specifying not using the ha_pairs parameter. Either throughput_capacity or throughput_capacity_per_ha_pair must be specified.
        """
        return pulumi.get(self, "throughput_capacity")

    @property
    @pulumi.getter(name="throughputCapacityPerHaPair")
    def throughput_capacity_per_ha_pair(self) -> pulumi.Output[Optional[int]]:
        """
        Sets the throughput capacity (in MBps) for the file system that you're creating. Valid values are `3072`,`6144`. This parameter should only be used when specifying the ha_pairs parameter. Either throughput_capacity or throughput_capacity_per_ha_pair must be specified.
        """
        return pulumi.get(self, "throughput_capacity_per_ha_pair")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        Identifier of the Virtual Private Cloud for the file system.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="weeklyMaintenanceStartTime")
    def weekly_maintenance_start_time(self) -> pulumi.Output[str]:
        """
        The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
        """
        return pulumi.get(self, "weekly_maintenance_start_time")

