# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'DataRepositoryAssociationS3',
    'DataRepositoryAssociationS3AutoExportPolicy',
    'DataRepositoryAssociationS3AutoImportPolicy',
    'FileCacheDataRepositoryAssociation',
    'FileCacheDataRepositoryAssociationNf',
    'FileCacheLustreConfiguration',
    'FileCacheLustreConfigurationLogConfiguration',
    'FileCacheLustreConfigurationMetadataConfiguration',
    'LustreFileSystemLogConfiguration',
    'LustreFileSystemRootSquashConfiguration',
    'OntapFileSystemDiskIopsConfiguration',
    'OntapFileSystemEndpoint',
    'OntapFileSystemEndpointIntercluster',
    'OntapFileSystemEndpointManagement',
    'OntapStorageVirtualMachineActiveDirectoryConfiguration',
    'OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfiguration',
    'OntapStorageVirtualMachineEndpoint',
    'OntapStorageVirtualMachineEndpointIscsi',
    'OntapStorageVirtualMachineEndpointManagement',
    'OntapStorageVirtualMachineEndpointNf',
    'OntapStorageVirtualMachineEndpointSmb',
    'OntapVolumeSnaplockConfiguration',
    'OntapVolumeSnaplockConfigurationAutocommitPeriod',
    'OntapVolumeSnaplockConfigurationRetentionPeriod',
    'OntapVolumeSnaplockConfigurationRetentionPeriodDefaultRetention',
    'OntapVolumeSnaplockConfigurationRetentionPeriodMaximumRetention',
    'OntapVolumeSnaplockConfigurationRetentionPeriodMinimumRetention',
    'OntapVolumeTieringPolicy',
    'OpenZfsFileSystemDiskIopsConfiguration',
    'OpenZfsFileSystemRootVolumeConfiguration',
    'OpenZfsFileSystemRootVolumeConfigurationNfsExports',
    'OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfiguration',
    'OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuota',
    'OpenZfsVolumeNfsExports',
    'OpenZfsVolumeNfsExportsClientConfiguration',
    'OpenZfsVolumeOriginSnapshot',
    'OpenZfsVolumeUserAndGroupQuota',
    'WindowsFileSystemAuditLogConfiguration',
    'WindowsFileSystemDiskIopsConfiguration',
    'WindowsFileSystemSelfManagedActiveDirectory',
    'GetOntapFileSystemDiskIopsConfigurationResult',
    'GetOntapFileSystemEndpointResult',
    'GetOntapFileSystemEndpointInterclusterResult',
    'GetOntapFileSystemEndpointManagementResult',
    'GetOntapStorageVirtualMachineActiveDirectoryConfigurationResult',
    'GetOntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfigurationResult',
    'GetOntapStorageVirtualMachineEndpointResult',
    'GetOntapStorageVirtualMachineEndpointIscsiResult',
    'GetOntapStorageVirtualMachineEndpointManagementResult',
    'GetOntapStorageVirtualMachineEndpointNfResult',
    'GetOntapStorageVirtualMachineEndpointSmbResult',
    'GetOntapStorageVirtualMachineFilterResult',
    'GetOntapStorageVirtualMachineLifecycleTransitionReasonResult',
    'GetOntapStorageVirtualMachinesFilterResult',
    'GetOpenZfsSnapshotFilterResult',
    'GetWindowsFileSystemAuditLogConfigurationResult',
    'GetWindowsFileSystemDiskIopsConfigurationResult',
]

@pulumi.output_type
class DataRepositoryAssociationS3(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoExportPolicy":
            suggest = "auto_export_policy"
        elif key == "autoImportPolicy":
            suggest = "auto_import_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataRepositoryAssociationS3. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataRepositoryAssociationS3.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataRepositoryAssociationS3.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_export_policy: Optional['outputs.DataRepositoryAssociationS3AutoExportPolicy'] = None,
                 auto_import_policy: Optional['outputs.DataRepositoryAssociationS3AutoImportPolicy'] = None):
        """
        :param 'DataRepositoryAssociationS3AutoExportPolicyArgs' auto_export_policy: Specifies the type of updated objects that will be automatically exported from your file system to the linked S3 bucket. See the `events` configuration block.
        :param 'DataRepositoryAssociationS3AutoImportPolicyArgs' auto_import_policy: Specifies the type of updated objects that will be automatically imported from the linked S3 bucket to your file system. See the `events` configuration block.
        """
        if auto_export_policy is not None:
            pulumi.set(__self__, "auto_export_policy", auto_export_policy)
        if auto_import_policy is not None:
            pulumi.set(__self__, "auto_import_policy", auto_import_policy)

    @property
    @pulumi.getter(name="autoExportPolicy")
    def auto_export_policy(self) -> Optional['outputs.DataRepositoryAssociationS3AutoExportPolicy']:
        """
        Specifies the type of updated objects that will be automatically exported from your file system to the linked S3 bucket. See the `events` configuration block.
        """
        return pulumi.get(self, "auto_export_policy")

    @property
    @pulumi.getter(name="autoImportPolicy")
    def auto_import_policy(self) -> Optional['outputs.DataRepositoryAssociationS3AutoImportPolicy']:
        """
        Specifies the type of updated objects that will be automatically imported from the linked S3 bucket to your file system. See the `events` configuration block.
        """
        return pulumi.get(self, "auto_import_policy")


@pulumi.output_type
class DataRepositoryAssociationS3AutoExportPolicy(dict):
    def __init__(__self__, *,
                 events: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] events: A list of file event types to automatically export to your linked S3 bucket or import from the linked S3 bucket. Valid values are `NEW`, `CHANGED`, `DELETED`. Max of 3.
        """
        if events is not None:
            pulumi.set(__self__, "events", events)

    @property
    @pulumi.getter
    def events(self) -> Optional[Sequence[str]]:
        """
        A list of file event types to automatically export to your linked S3 bucket or import from the linked S3 bucket. Valid values are `NEW`, `CHANGED`, `DELETED`. Max of 3.
        """
        return pulumi.get(self, "events")


@pulumi.output_type
class DataRepositoryAssociationS3AutoImportPolicy(dict):
    def __init__(__self__, *,
                 events: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] events: A list of file event types to automatically export to your linked S3 bucket or import from the linked S3 bucket. Valid values are `NEW`, `CHANGED`, `DELETED`. Max of 3.
        """
        if events is not None:
            pulumi.set(__self__, "events", events)

    @property
    @pulumi.getter
    def events(self) -> Optional[Sequence[str]]:
        """
        A list of file event types to automatically export to your linked S3 bucket or import from the linked S3 bucket. Valid values are `NEW`, `CHANGED`, `DELETED`. Max of 3.
        """
        return pulumi.get(self, "events")


@pulumi.output_type
class FileCacheDataRepositoryAssociation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataRepositoryPath":
            suggest = "data_repository_path"
        elif key == "fileCachePath":
            suggest = "file_cache_path"
        elif key == "associationId":
            suggest = "association_id"
        elif key == "dataRepositorySubdirectories":
            suggest = "data_repository_subdirectories"
        elif key == "fileCacheId":
            suggest = "file_cache_id"
        elif key == "fileSystemId":
            suggest = "file_system_id"
        elif key == "fileSystemPath":
            suggest = "file_system_path"
        elif key == "importedFileChunkSize":
            suggest = "imported_file_chunk_size"
        elif key == "resourceArn":
            suggest = "resource_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileCacheDataRepositoryAssociation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileCacheDataRepositoryAssociation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileCacheDataRepositoryAssociation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_repository_path: str,
                 file_cache_path: str,
                 association_id: Optional[str] = None,
                 data_repository_subdirectories: Optional[Sequence[str]] = None,
                 file_cache_id: Optional[str] = None,
                 file_system_id: Optional[str] = None,
                 file_system_path: Optional[str] = None,
                 imported_file_chunk_size: Optional[int] = None,
                 nfs: Optional[Sequence['outputs.FileCacheDataRepositoryAssociationNf']] = None,
                 resource_arn: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        :param str data_repository_path: The path to the S3 or NFS data repository that links to the cache.
        :param str file_cache_path: A path on the cache that points to a high-level directory (such as /ns1/) or subdirectory (such as /ns1/subdir/) that will be mapped 1-1 with DataRepositoryPath. The leading forward slash in the name is required. Two data repository associations cannot have overlapping cache paths. For example, if a data repository is associated with cache path /ns1/, then you cannot link another data repository with cache path /ns1/ns2. This path specifies where in your cache files will be exported from. This cache directory can be linked to only one data repository, and no data repository other can be linked to the directory. Note: The cache path can only be set to root (/) on an NFS DRA when DataRepositorySubdirectories is specified. If you specify root (/) as the cache path, you can create only one DRA on the cache. The cache path cannot be set to root (/) for an S3 DRA.
        :param Sequence[str] data_repository_subdirectories: A list of NFS Exports that will be linked with this data repository association. The Export paths are in the format /exportpath1. To use this parameter, you must configure DataRepositoryPath as the domain name of the NFS file system. The NFS file system domain name in effect is the root of the subdirectories. Note that DataRepositorySubdirectories is not supported for S3 data repositories. Max of 500.
        :param str file_cache_id: The system-generated, unique ID of the cache.
        :param Sequence['FileCacheDataRepositoryAssociationNfArgs'] nfs: (Optional) See the `nfs` configuration block.
        :param Mapping[str, str] tags: A map of tags to assign to the file cache. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "data_repository_path", data_repository_path)
        pulumi.set(__self__, "file_cache_path", file_cache_path)
        if association_id is not None:
            pulumi.set(__self__, "association_id", association_id)
        if data_repository_subdirectories is not None:
            pulumi.set(__self__, "data_repository_subdirectories", data_repository_subdirectories)
        if file_cache_id is not None:
            pulumi.set(__self__, "file_cache_id", file_cache_id)
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if file_system_path is not None:
            pulumi.set(__self__, "file_system_path", file_system_path)
        if imported_file_chunk_size is not None:
            pulumi.set(__self__, "imported_file_chunk_size", imported_file_chunk_size)
        if nfs is not None:
            pulumi.set(__self__, "nfs", nfs)
        if resource_arn is not None:
            pulumi.set(__self__, "resource_arn", resource_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="dataRepositoryPath")
    def data_repository_path(self) -> str:
        """
        The path to the S3 or NFS data repository that links to the cache.
        """
        return pulumi.get(self, "data_repository_path")

    @property
    @pulumi.getter(name="fileCachePath")
    def file_cache_path(self) -> str:
        """
        A path on the cache that points to a high-level directory (such as /ns1/) or subdirectory (such as /ns1/subdir/) that will be mapped 1-1 with DataRepositoryPath. The leading forward slash in the name is required. Two data repository associations cannot have overlapping cache paths. For example, if a data repository is associated with cache path /ns1/, then you cannot link another data repository with cache path /ns1/ns2. This path specifies where in your cache files will be exported from. This cache directory can be linked to only one data repository, and no data repository other can be linked to the directory. Note: The cache path can only be set to root (/) on an NFS DRA when DataRepositorySubdirectories is specified. If you specify root (/) as the cache path, you can create only one DRA on the cache. The cache path cannot be set to root (/) for an S3 DRA.
        """
        return pulumi.get(self, "file_cache_path")

    @property
    @pulumi.getter(name="associationId")
    def association_id(self) -> Optional[str]:
        return pulumi.get(self, "association_id")

    @property
    @pulumi.getter(name="dataRepositorySubdirectories")
    def data_repository_subdirectories(self) -> Optional[Sequence[str]]:
        """
        A list of NFS Exports that will be linked with this data repository association. The Export paths are in the format /exportpath1. To use this parameter, you must configure DataRepositoryPath as the domain name of the NFS file system. The NFS file system domain name in effect is the root of the subdirectories. Note that DataRepositorySubdirectories is not supported for S3 data repositories. Max of 500.
        """
        return pulumi.get(self, "data_repository_subdirectories")

    @property
    @pulumi.getter(name="fileCacheId")
    def file_cache_id(self) -> Optional[str]:
        """
        The system-generated, unique ID of the cache.
        """
        return pulumi.get(self, "file_cache_id")

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[str]:
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter(name="fileSystemPath")
    def file_system_path(self) -> Optional[str]:
        return pulumi.get(self, "file_system_path")

    @property
    @pulumi.getter(name="importedFileChunkSize")
    def imported_file_chunk_size(self) -> Optional[int]:
        return pulumi.get(self, "imported_file_chunk_size")

    @property
    @pulumi.getter
    def nfs(self) -> Optional[Sequence['outputs.FileCacheDataRepositoryAssociationNf']]:
        """
        (Optional) See the `nfs` configuration block.
        """
        return pulumi.get(self, "nfs")

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> Optional[str]:
        return pulumi.get(self, "resource_arn")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        A map of tags to assign to the file cache. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class FileCacheDataRepositoryAssociationNf(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsIps":
            suggest = "dns_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileCacheDataRepositoryAssociationNf. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileCacheDataRepositoryAssociationNf.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileCacheDataRepositoryAssociationNf.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 version: str,
                 dns_ips: Optional[Sequence[str]] = None):
        """
        :param str version: The version of the NFS (Network File System) protocol of the NFS data repository. The only supported value is NFS3, which indicates that the data repository must support the NFSv3 protocol. The only supported value is `NFS3`.
        :param Sequence[str] dns_ips: A list of up to 2 IP addresses of DNS servers used to resolve the NFS file system domain name. The provided IP addresses can either be the IP addresses of a DNS forwarder or resolver that the customer manages and runs inside the customer VPC, or the IP addresses of the on-premises DNS servers.
        """
        pulumi.set(__self__, "version", version)
        if dns_ips is not None:
            pulumi.set(__self__, "dns_ips", dns_ips)

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version of the NFS (Network File System) protocol of the NFS data repository. The only supported value is NFS3, which indicates that the data repository must support the NFSv3 protocol. The only supported value is `NFS3`.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="dnsIps")
    def dns_ips(self) -> Optional[Sequence[str]]:
        """
        A list of up to 2 IP addresses of DNS servers used to resolve the NFS file system domain name. The provided IP addresses can either be the IP addresses of a DNS forwarder or resolver that the customer manages and runs inside the customer VPC, or the IP addresses of the on-premises DNS servers.
        """
        return pulumi.get(self, "dns_ips")


@pulumi.output_type
class FileCacheLustreConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deploymentType":
            suggest = "deployment_type"
        elif key == "metadataConfigurations":
            suggest = "metadata_configurations"
        elif key == "perUnitStorageThroughput":
            suggest = "per_unit_storage_throughput"
        elif key == "logConfigurations":
            suggest = "log_configurations"
        elif key == "mountName":
            suggest = "mount_name"
        elif key == "weeklyMaintenanceStartTime":
            suggest = "weekly_maintenance_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileCacheLustreConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileCacheLustreConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileCacheLustreConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deployment_type: str,
                 metadata_configurations: Sequence['outputs.FileCacheLustreConfigurationMetadataConfiguration'],
                 per_unit_storage_throughput: int,
                 log_configurations: Optional[Sequence['outputs.FileCacheLustreConfigurationLogConfiguration']] = None,
                 mount_name: Optional[str] = None,
                 weekly_maintenance_start_time: Optional[str] = None):
        """
        :param str deployment_type: Specifies the cache deployment type. The only supported value is `CACHE_1`.
        :param Sequence['FileCacheLustreConfigurationMetadataConfigurationArgs'] metadata_configurations: The configuration for a Lustre MDT (Metadata Target) storage volume. See the `metadata_configuration` block.
        :param int per_unit_storage_throughput: Provisions the amount of read and write throughput for each 1 tebibyte (TiB) of cache storage capacity, in MB/s/TiB. The only supported value is `1000`.
        :param str weekly_maintenance_start_time: A recurring weekly time, in the format `D:HH:MM`. `D` is the day of the week, for which `1` represents Monday and `7` represents Sunday. `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour. For example, 1:05:00 specifies maintenance at 5 AM Monday. See the [ISO week date](https://en.wikipedia.org/wiki/ISO_week_date) for more information.
        """
        pulumi.set(__self__, "deployment_type", deployment_type)
        pulumi.set(__self__, "metadata_configurations", metadata_configurations)
        pulumi.set(__self__, "per_unit_storage_throughput", per_unit_storage_throughput)
        if log_configurations is not None:
            pulumi.set(__self__, "log_configurations", log_configurations)
        if mount_name is not None:
            pulumi.set(__self__, "mount_name", mount_name)
        if weekly_maintenance_start_time is not None:
            pulumi.set(__self__, "weekly_maintenance_start_time", weekly_maintenance_start_time)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> str:
        """
        Specifies the cache deployment type. The only supported value is `CACHE_1`.
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="metadataConfigurations")
    def metadata_configurations(self) -> Sequence['outputs.FileCacheLustreConfigurationMetadataConfiguration']:
        """
        The configuration for a Lustre MDT (Metadata Target) storage volume. See the `metadata_configuration` block.
        """
        return pulumi.get(self, "metadata_configurations")

    @property
    @pulumi.getter(name="perUnitStorageThroughput")
    def per_unit_storage_throughput(self) -> int:
        """
        Provisions the amount of read and write throughput for each 1 tebibyte (TiB) of cache storage capacity, in MB/s/TiB. The only supported value is `1000`.
        """
        return pulumi.get(self, "per_unit_storage_throughput")

    @property
    @pulumi.getter(name="logConfigurations")
    def log_configurations(self) -> Optional[Sequence['outputs.FileCacheLustreConfigurationLogConfiguration']]:
        return pulumi.get(self, "log_configurations")

    @property
    @pulumi.getter(name="mountName")
    def mount_name(self) -> Optional[str]:
        return pulumi.get(self, "mount_name")

    @property
    @pulumi.getter(name="weeklyMaintenanceStartTime")
    def weekly_maintenance_start_time(self) -> Optional[str]:
        """
        A recurring weekly time, in the format `D:HH:MM`. `D` is the day of the week, for which `1` represents Monday and `7` represents Sunday. `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour. For example, 1:05:00 specifies maintenance at 5 AM Monday. See the [ISO week date](https://en.wikipedia.org/wiki/ISO_week_date) for more information.
        """
        return pulumi.get(self, "weekly_maintenance_start_time")


@pulumi.output_type
class FileCacheLustreConfigurationLogConfiguration(dict):
    def __init__(__self__, *,
                 destination: Optional[str] = None,
                 level: Optional[str] = None):
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if level is not None:
            pulumi.set(__self__, "level", level)

    @property
    @pulumi.getter
    def destination(self) -> Optional[str]:
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def level(self) -> Optional[str]:
        return pulumi.get(self, "level")


@pulumi.output_type
class FileCacheLustreConfigurationMetadataConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageCapacity":
            suggest = "storage_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileCacheLustreConfigurationMetadataConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileCacheLustreConfigurationMetadataConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileCacheLustreConfigurationMetadataConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_capacity: int):
        """
        :param int storage_capacity: The storage capacity of the Lustre MDT (Metadata Target) storage volume in gibibytes (GiB). The only supported value is `2400` GiB.
        """
        pulumi.set(__self__, "storage_capacity", storage_capacity)

    @property
    @pulumi.getter(name="storageCapacity")
    def storage_capacity(self) -> int:
        """
        The storage capacity of the Lustre MDT (Metadata Target) storage volume in gibibytes (GiB). The only supported value is `2400` GiB.
        """
        return pulumi.get(self, "storage_capacity")


@pulumi.output_type
class LustreFileSystemLogConfiguration(dict):
    def __init__(__self__, *,
                 destination: Optional[str] = None,
                 level: Optional[str] = None):
        """
        :param str destination: The Amazon Resource Name (ARN) that specifies the destination of the logs. The name of the Amazon CloudWatch Logs log group must begin with the `/aws/fsx` prefix. If you do not provide a destination, Amazon FSx will create and use a log stream in the CloudWatch Logs `/aws/fsx/lustre` log group.
        :param str level: Sets which data repository events are logged by Amazon FSx. Valid values are `WARN_ONLY`, `FAILURE_ONLY`, `ERROR_ONLY`, `WARN_ERROR` and `DISABLED`. Default value is `DISABLED`.
        """
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if level is not None:
            pulumi.set(__self__, "level", level)

    @property
    @pulumi.getter
    def destination(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) that specifies the destination of the logs. The name of the Amazon CloudWatch Logs log group must begin with the `/aws/fsx` prefix. If you do not provide a destination, Amazon FSx will create and use a log stream in the CloudWatch Logs `/aws/fsx/lustre` log group.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def level(self) -> Optional[str]:
        """
        Sets which data repository events are logged by Amazon FSx. Valid values are `WARN_ONLY`, `FAILURE_ONLY`, `ERROR_ONLY`, `WARN_ERROR` and `DISABLED`. Default value is `DISABLED`.
        """
        return pulumi.get(self, "level")


@pulumi.output_type
class LustreFileSystemRootSquashConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "noSquashNids":
            suggest = "no_squash_nids"
        elif key == "rootSquash":
            suggest = "root_squash"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LustreFileSystemRootSquashConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LustreFileSystemRootSquashConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LustreFileSystemRootSquashConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 no_squash_nids: Optional[Sequence[str]] = None,
                 root_squash: Optional[str] = None):
        """
        :param Sequence[str] no_squash_nids: When root squash is enabled, you can optionally specify an array of NIDs of clients for which root squash does not apply. A client NID is a Lustre Network Identifier used to uniquely identify a client. You can specify the NID as either a single address or a range of addresses: 1. A single address is described in standard Lustre NID format by specifying the client’s IP address followed by the Lustre network ID (for example, 10.0.1.6@tcp). 2. An address range is described using a dash to separate the range (for example, 10.0.[2-10].[1-255]@tcp).
        :param str root_squash: You enable root squash by setting a user ID (UID) and group ID (GID) for the file system in the format UID:GID (for example, 365534:65534). The UID and GID values can range from 0 to 4294967294.
        """
        if no_squash_nids is not None:
            pulumi.set(__self__, "no_squash_nids", no_squash_nids)
        if root_squash is not None:
            pulumi.set(__self__, "root_squash", root_squash)

    @property
    @pulumi.getter(name="noSquashNids")
    def no_squash_nids(self) -> Optional[Sequence[str]]:
        """
        When root squash is enabled, you can optionally specify an array of NIDs of clients for which root squash does not apply. A client NID is a Lustre Network Identifier used to uniquely identify a client. You can specify the NID as either a single address or a range of addresses: 1. A single address is described in standard Lustre NID format by specifying the client’s IP address followed by the Lustre network ID (for example, 10.0.1.6@tcp). 2. An address range is described using a dash to separate the range (for example, 10.0.[2-10].[1-255]@tcp).
        """
        return pulumi.get(self, "no_squash_nids")

    @property
    @pulumi.getter(name="rootSquash")
    def root_squash(self) -> Optional[str]:
        """
        You enable root squash by setting a user ID (UID) and group ID (GID) for the file system in the format UID:GID (for example, 365534:65534). The UID and GID values can range from 0 to 4294967294.
        """
        return pulumi.get(self, "root_squash")


@pulumi.output_type
class OntapFileSystemDiskIopsConfiguration(dict):
    def __init__(__self__, *,
                 iops: Optional[int] = None,
                 mode: Optional[str] = None):
        """
        :param int iops: The total number of SSD IOPS provisioned for the file system.
        :param str mode: Specifies whether the number of IOPS for the file system is using the system. Valid values are `AUTOMATIC` and `USER_PROVISIONED`. Default value is `AUTOMATIC`.
        """
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        The total number of SSD IOPS provisioned for the file system.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Specifies whether the number of IOPS for the file system is using the system. Valid values are `AUTOMATIC` and `USER_PROVISIONED`. Default value is `AUTOMATIC`.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class OntapFileSystemEndpoint(dict):
    def __init__(__self__, *,
                 interclusters: Optional[Sequence['outputs.OntapFileSystemEndpointIntercluster']] = None,
                 managements: Optional[Sequence['outputs.OntapFileSystemEndpointManagement']] = None):
        """
        :param Sequence['OntapFileSystemEndpointInterclusterArgs'] interclusters: An endpoint for managing your file system by setting up NetApp SnapMirror with other ONTAP systems. See Endpoint.
        :param Sequence['OntapFileSystemEndpointManagementArgs'] managements: An endpoint for managing your file system using the NetApp ONTAP CLI and NetApp ONTAP API. See Endpoint.
        """
        if interclusters is not None:
            pulumi.set(__self__, "interclusters", interclusters)
        if managements is not None:
            pulumi.set(__self__, "managements", managements)

    @property
    @pulumi.getter
    def interclusters(self) -> Optional[Sequence['outputs.OntapFileSystemEndpointIntercluster']]:
        """
        An endpoint for managing your file system by setting up NetApp SnapMirror with other ONTAP systems. See Endpoint.
        """
        return pulumi.get(self, "interclusters")

    @property
    @pulumi.getter
    def managements(self) -> Optional[Sequence['outputs.OntapFileSystemEndpointManagement']]:
        """
        An endpoint for managing your file system using the NetApp ONTAP CLI and NetApp ONTAP API. See Endpoint.
        """
        return pulumi.get(self, "managements")


@pulumi.output_type
class OntapFileSystemEndpointIntercluster(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsName":
            suggest = "dns_name"
        elif key == "ipAddresses":
            suggest = "ip_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OntapFileSystemEndpointIntercluster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OntapFileSystemEndpointIntercluster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OntapFileSystemEndpointIntercluster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_name: Optional[str] = None,
                 ip_addresses: Optional[Sequence[str]] = None):
        """
        :param str dns_name: The Domain Name Service (DNS) name for the file system. You can mount your file system using its DNS name.
        :param Sequence[str] ip_addresses: IP addresses of the file system endpoint.
        """
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[str]:
        """
        The Domain Name Service (DNS) name for the file system. You can mount your file system using its DNS name.
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[Sequence[str]]:
        """
        IP addresses of the file system endpoint.
        """
        return pulumi.get(self, "ip_addresses")


@pulumi.output_type
class OntapFileSystemEndpointManagement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsName":
            suggest = "dns_name"
        elif key == "ipAddresses":
            suggest = "ip_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OntapFileSystemEndpointManagement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OntapFileSystemEndpointManagement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OntapFileSystemEndpointManagement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_name: Optional[str] = None,
                 ip_addresses: Optional[Sequence[str]] = None):
        """
        :param str dns_name: The Domain Name Service (DNS) name for the file system. You can mount your file system using its DNS name.
        :param Sequence[str] ip_addresses: IP addresses of the file system endpoint.
        """
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[str]:
        """
        The Domain Name Service (DNS) name for the file system. You can mount your file system using its DNS name.
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[Sequence[str]]:
        """
        IP addresses of the file system endpoint.
        """
        return pulumi.get(self, "ip_addresses")


@pulumi.output_type
class OntapStorageVirtualMachineActiveDirectoryConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "netbiosName":
            suggest = "netbios_name"
        elif key == "selfManagedActiveDirectoryConfiguration":
            suggest = "self_managed_active_directory_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OntapStorageVirtualMachineActiveDirectoryConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OntapStorageVirtualMachineActiveDirectoryConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OntapStorageVirtualMachineActiveDirectoryConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 netbios_name: Optional[str] = None,
                 self_managed_active_directory_configuration: Optional['outputs.OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfiguration'] = None):
        """
        :param str netbios_name: The NetBIOS name of the Active Directory computer object that will be created for your SVM. This is often the same as the SVM name but can be different. AWS limits to 15 characters because of standard NetBIOS naming limits.
        """
        if netbios_name is not None:
            pulumi.set(__self__, "netbios_name", netbios_name)
        if self_managed_active_directory_configuration is not None:
            pulumi.set(__self__, "self_managed_active_directory_configuration", self_managed_active_directory_configuration)

    @property
    @pulumi.getter(name="netbiosName")
    def netbios_name(self) -> Optional[str]:
        """
        The NetBIOS name of the Active Directory computer object that will be created for your SVM. This is often the same as the SVM name but can be different. AWS limits to 15 characters because of standard NetBIOS naming limits.
        """
        return pulumi.get(self, "netbios_name")

    @property
    @pulumi.getter(name="selfManagedActiveDirectoryConfiguration")
    def self_managed_active_directory_configuration(self) -> Optional['outputs.OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfiguration']:
        return pulumi.get(self, "self_managed_active_directory_configuration")


@pulumi.output_type
class OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsIps":
            suggest = "dns_ips"
        elif key == "domainName":
            suggest = "domain_name"
        elif key == "fileSystemAdministratorsGroup":
            suggest = "file_system_administrators_group"
        elif key == "organizationalUnitDistinguishedName":
            suggest = "organizational_unit_distinguished_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_ips: Sequence[str],
                 domain_name: str,
                 password: str,
                 username: str,
                 file_system_administrators_group: Optional[str] = None,
                 organizational_unit_distinguished_name: Optional[str] = None):
        """
        :param Sequence[str] dns_ips: A list of up to three IP addresses of DNS servers or domain controllers in the self-managed AD directory.
        :param str domain_name: The fully qualified domain name of the self-managed AD directory. For example, `corp.example.com`.
        :param str password: The password for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        :param str username: The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        :param str file_system_administrators_group: The name of the domain group whose members are granted administrative privileges for the SVM. The group that you specify must already exist in your domain. Defaults to `Domain Admins`.
        :param str organizational_unit_distinguished_name: The fully qualified distinguished name of the organizational unit within your self-managed AD directory that the Windows File Server instance will join. For example, `OU=FSx,DC=yourdomain,DC=corp,DC=com`. Only accepts OU as the direct parent of the SVM. If none is provided, the SVM is created in the default location of your self-managed AD directory. To learn more, see [RFC 2253](https://tools.ietf.org/html/rfc2253).
        """
        pulumi.set(__self__, "dns_ips", dns_ips)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if file_system_administrators_group is not None:
            pulumi.set(__self__, "file_system_administrators_group", file_system_administrators_group)
        if organizational_unit_distinguished_name is not None:
            pulumi.set(__self__, "organizational_unit_distinguished_name", organizational_unit_distinguished_name)

    @property
    @pulumi.getter(name="dnsIps")
    def dns_ips(self) -> Sequence[str]:
        """
        A list of up to three IP addresses of DNS servers or domain controllers in the self-managed AD directory.
        """
        return pulumi.get(self, "dns_ips")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> str:
        """
        The fully qualified domain name of the self-managed AD directory. For example, `corp.example.com`.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="fileSystemAdministratorsGroup")
    def file_system_administrators_group(self) -> Optional[str]:
        """
        The name of the domain group whose members are granted administrative privileges for the SVM. The group that you specify must already exist in your domain. Defaults to `Domain Admins`.
        """
        return pulumi.get(self, "file_system_administrators_group")

    @property
    @pulumi.getter(name="organizationalUnitDistinguishedName")
    def organizational_unit_distinguished_name(self) -> Optional[str]:
        """
        The fully qualified distinguished name of the organizational unit within your self-managed AD directory that the Windows File Server instance will join. For example, `OU=FSx,DC=yourdomain,DC=corp,DC=com`. Only accepts OU as the direct parent of the SVM. If none is provided, the SVM is created in the default location of your self-managed AD directory. To learn more, see [RFC 2253](https://tools.ietf.org/html/rfc2253).
        """
        return pulumi.get(self, "organizational_unit_distinguished_name")


@pulumi.output_type
class OntapStorageVirtualMachineEndpoint(dict):
    def __init__(__self__, *,
                 iscsis: Optional[Sequence['outputs.OntapStorageVirtualMachineEndpointIscsi']] = None,
                 managements: Optional[Sequence['outputs.OntapStorageVirtualMachineEndpointManagement']] = None,
                 nfs: Optional[Sequence['outputs.OntapStorageVirtualMachineEndpointNf']] = None,
                 smbs: Optional[Sequence['outputs.OntapStorageVirtualMachineEndpointSmb']] = None):
        """
        :param Sequence['OntapStorageVirtualMachineEndpointIscsiArgs'] iscsis: An endpoint for accessing data on your storage virtual machine via iSCSI protocol. See Endpoint.
        :param Sequence['OntapStorageVirtualMachineEndpointManagementArgs'] managements: An endpoint for managing your file system using the NetApp ONTAP CLI and NetApp ONTAP API. See Endpoint.
        :param Sequence['OntapStorageVirtualMachineEndpointNfArgs'] nfs: An endpoint for accessing data on your storage virtual machine via NFS protocol. See Endpoint.
        :param Sequence['OntapStorageVirtualMachineEndpointSmbArgs'] smbs: An endpoint for accessing data on your storage virtual machine via SMB protocol. This is only set if an active_directory_configuration has been set. See Endpoint.
        """
        if iscsis is not None:
            pulumi.set(__self__, "iscsis", iscsis)
        if managements is not None:
            pulumi.set(__self__, "managements", managements)
        if nfs is not None:
            pulumi.set(__self__, "nfs", nfs)
        if smbs is not None:
            pulumi.set(__self__, "smbs", smbs)

    @property
    @pulumi.getter
    def iscsis(self) -> Optional[Sequence['outputs.OntapStorageVirtualMachineEndpointIscsi']]:
        """
        An endpoint for accessing data on your storage virtual machine via iSCSI protocol. See Endpoint.
        """
        return pulumi.get(self, "iscsis")

    @property
    @pulumi.getter
    def managements(self) -> Optional[Sequence['outputs.OntapStorageVirtualMachineEndpointManagement']]:
        """
        An endpoint for managing your file system using the NetApp ONTAP CLI and NetApp ONTAP API. See Endpoint.
        """
        return pulumi.get(self, "managements")

    @property
    @pulumi.getter
    def nfs(self) -> Optional[Sequence['outputs.OntapStorageVirtualMachineEndpointNf']]:
        """
        An endpoint for accessing data on your storage virtual machine via NFS protocol. See Endpoint.
        """
        return pulumi.get(self, "nfs")

    @property
    @pulumi.getter
    def smbs(self) -> Optional[Sequence['outputs.OntapStorageVirtualMachineEndpointSmb']]:
        """
        An endpoint for accessing data on your storage virtual machine via SMB protocol. This is only set if an active_directory_configuration has been set. See Endpoint.
        """
        return pulumi.get(self, "smbs")


@pulumi.output_type
class OntapStorageVirtualMachineEndpointIscsi(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsName":
            suggest = "dns_name"
        elif key == "ipAddresses":
            suggest = "ip_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OntapStorageVirtualMachineEndpointIscsi. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OntapStorageVirtualMachineEndpointIscsi.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OntapStorageVirtualMachineEndpointIscsi.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_name: Optional[str] = None,
                 ip_addresses: Optional[Sequence[str]] = None):
        """
        :param str dns_name: The Domain Name Service (DNS) name for the storage virtual machine. You can mount your storage virtual machine using its DNS name.
        :param Sequence[str] ip_addresses: IP addresses of the storage virtual machine endpoint.
        """
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[str]:
        """
        The Domain Name Service (DNS) name for the storage virtual machine. You can mount your storage virtual machine using its DNS name.
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[Sequence[str]]:
        """
        IP addresses of the storage virtual machine endpoint.
        """
        return pulumi.get(self, "ip_addresses")


@pulumi.output_type
class OntapStorageVirtualMachineEndpointManagement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsName":
            suggest = "dns_name"
        elif key == "ipAddresses":
            suggest = "ip_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OntapStorageVirtualMachineEndpointManagement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OntapStorageVirtualMachineEndpointManagement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OntapStorageVirtualMachineEndpointManagement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_name: Optional[str] = None,
                 ip_addresses: Optional[Sequence[str]] = None):
        """
        :param str dns_name: The Domain Name Service (DNS) name for the storage virtual machine. You can mount your storage virtual machine using its DNS name.
        :param Sequence[str] ip_addresses: IP addresses of the storage virtual machine endpoint.
        """
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[str]:
        """
        The Domain Name Service (DNS) name for the storage virtual machine. You can mount your storage virtual machine using its DNS name.
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[Sequence[str]]:
        """
        IP addresses of the storage virtual machine endpoint.
        """
        return pulumi.get(self, "ip_addresses")


@pulumi.output_type
class OntapStorageVirtualMachineEndpointNf(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsName":
            suggest = "dns_name"
        elif key == "ipAddresses":
            suggest = "ip_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OntapStorageVirtualMachineEndpointNf. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OntapStorageVirtualMachineEndpointNf.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OntapStorageVirtualMachineEndpointNf.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_name: Optional[str] = None,
                 ip_addresses: Optional[Sequence[str]] = None):
        """
        :param str dns_name: The Domain Name Service (DNS) name for the storage virtual machine. You can mount your storage virtual machine using its DNS name.
        :param Sequence[str] ip_addresses: IP addresses of the storage virtual machine endpoint.
        """
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[str]:
        """
        The Domain Name Service (DNS) name for the storage virtual machine. You can mount your storage virtual machine using its DNS name.
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[Sequence[str]]:
        """
        IP addresses of the storage virtual machine endpoint.
        """
        return pulumi.get(self, "ip_addresses")


@pulumi.output_type
class OntapStorageVirtualMachineEndpointSmb(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsName":
            suggest = "dns_name"
        elif key == "ipAddresses":
            suggest = "ip_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OntapStorageVirtualMachineEndpointSmb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OntapStorageVirtualMachineEndpointSmb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OntapStorageVirtualMachineEndpointSmb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_name: Optional[str] = None,
                 ip_addresses: Optional[Sequence[str]] = None):
        """
        :param str dns_name: The Domain Name Service (DNS) name for the storage virtual machine. You can mount your storage virtual machine using its DNS name.
        :param Sequence[str] ip_addresses: IP addresses of the storage virtual machine endpoint.
        """
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[str]:
        """
        The Domain Name Service (DNS) name for the storage virtual machine. You can mount your storage virtual machine using its DNS name.
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[Sequence[str]]:
        """
        IP addresses of the storage virtual machine endpoint.
        """
        return pulumi.get(self, "ip_addresses")


@pulumi.output_type
class OntapVolumeSnaplockConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snaplockType":
            suggest = "snaplock_type"
        elif key == "auditLogVolume":
            suggest = "audit_log_volume"
        elif key == "autocommitPeriod":
            suggest = "autocommit_period"
        elif key == "privilegedDelete":
            suggest = "privileged_delete"
        elif key == "retentionPeriod":
            suggest = "retention_period"
        elif key == "volumeAppendModeEnabled":
            suggest = "volume_append_mode_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OntapVolumeSnaplockConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OntapVolumeSnaplockConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OntapVolumeSnaplockConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 snaplock_type: str,
                 audit_log_volume: Optional[bool] = None,
                 autocommit_period: Optional['outputs.OntapVolumeSnaplockConfigurationAutocommitPeriod'] = None,
                 privileged_delete: Optional[str] = None,
                 retention_period: Optional['outputs.OntapVolumeSnaplockConfigurationRetentionPeriod'] = None,
                 volume_append_mode_enabled: Optional[bool] = None):
        """
        :param str snaplock_type: Specifies the retention mode of an FSx for ONTAP SnapLock volume. After it is set, it can't be changed. Valid values: `COMPLIANCE`, `ENTERPRISE`.
        :param bool audit_log_volume: Enables or disables the audit log volume for an FSx for ONTAP SnapLock volume. The default value is `false`.
        :param 'OntapVolumeSnaplockConfigurationAutocommitPeriodArgs' autocommit_period: The configuration object for setting the autocommit period of files in an FSx for ONTAP SnapLock volume. See Autocommit Period below.
        :param str privileged_delete: Enables, disables, or permanently disables privileged delete on an FSx for ONTAP SnapLock Enterprise volume. Valid values: `DISABLED`, `ENABLED`, `PERMANENTLY_DISABLED`. The default value is `DISABLED`.
        :param 'OntapVolumeSnaplockConfigurationRetentionPeriodArgs' retention_period: The retention period of an FSx for ONTAP SnapLock volume. See SnapLock Retention Period below.
        :param bool volume_append_mode_enabled: Enables or disables volume-append mode on an FSx for ONTAP SnapLock volume. The default value is `false`.
        """
        pulumi.set(__self__, "snaplock_type", snaplock_type)
        if audit_log_volume is not None:
            pulumi.set(__self__, "audit_log_volume", audit_log_volume)
        if autocommit_period is not None:
            pulumi.set(__self__, "autocommit_period", autocommit_period)
        if privileged_delete is not None:
            pulumi.set(__self__, "privileged_delete", privileged_delete)
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)
        if volume_append_mode_enabled is not None:
            pulumi.set(__self__, "volume_append_mode_enabled", volume_append_mode_enabled)

    @property
    @pulumi.getter(name="snaplockType")
    def snaplock_type(self) -> str:
        """
        Specifies the retention mode of an FSx for ONTAP SnapLock volume. After it is set, it can't be changed. Valid values: `COMPLIANCE`, `ENTERPRISE`.
        """
        return pulumi.get(self, "snaplock_type")

    @property
    @pulumi.getter(name="auditLogVolume")
    def audit_log_volume(self) -> Optional[bool]:
        """
        Enables or disables the audit log volume for an FSx for ONTAP SnapLock volume. The default value is `false`.
        """
        return pulumi.get(self, "audit_log_volume")

    @property
    @pulumi.getter(name="autocommitPeriod")
    def autocommit_period(self) -> Optional['outputs.OntapVolumeSnaplockConfigurationAutocommitPeriod']:
        """
        The configuration object for setting the autocommit period of files in an FSx for ONTAP SnapLock volume. See Autocommit Period below.
        """
        return pulumi.get(self, "autocommit_period")

    @property
    @pulumi.getter(name="privilegedDelete")
    def privileged_delete(self) -> Optional[str]:
        """
        Enables, disables, or permanently disables privileged delete on an FSx for ONTAP SnapLock Enterprise volume. Valid values: `DISABLED`, `ENABLED`, `PERMANENTLY_DISABLED`. The default value is `DISABLED`.
        """
        return pulumi.get(self, "privileged_delete")

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional['outputs.OntapVolumeSnaplockConfigurationRetentionPeriod']:
        """
        The retention period of an FSx for ONTAP SnapLock volume. See SnapLock Retention Period below.
        """
        return pulumi.get(self, "retention_period")

    @property
    @pulumi.getter(name="volumeAppendModeEnabled")
    def volume_append_mode_enabled(self) -> Optional[bool]:
        """
        Enables or disables volume-append mode on an FSx for ONTAP SnapLock volume. The default value is `false`.
        """
        return pulumi.get(self, "volume_append_mode_enabled")


@pulumi.output_type
class OntapVolumeSnaplockConfigurationAutocommitPeriod(dict):
    def __init__(__self__, *,
                 type: Optional[str] = None,
                 value: Optional[int] = None):
        """
        :param str type: The type of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume. Setting this value to `NONE` disables autocommit. Valid values: `MINUTES`, `HOURS`, `DAYS`, `MONTHS`, `YEARS`, `NONE`.
        :param int value: The amount of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume. Setting this value to `NONE` disables autocommit. Valid values: `MINUTES`, `HOURS`, `DAYS`, `MONTHS`, `YEARS`, `NONE`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[int]:
        """
        The amount of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class OntapVolumeSnaplockConfigurationRetentionPeriod(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultRetention":
            suggest = "default_retention"
        elif key == "maximumRetention":
            suggest = "maximum_retention"
        elif key == "minimumRetention":
            suggest = "minimum_retention"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OntapVolumeSnaplockConfigurationRetentionPeriod. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OntapVolumeSnaplockConfigurationRetentionPeriod.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OntapVolumeSnaplockConfigurationRetentionPeriod.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_retention: Optional['outputs.OntapVolumeSnaplockConfigurationRetentionPeriodDefaultRetention'] = None,
                 maximum_retention: Optional['outputs.OntapVolumeSnaplockConfigurationRetentionPeriodMaximumRetention'] = None,
                 minimum_retention: Optional['outputs.OntapVolumeSnaplockConfigurationRetentionPeriodMinimumRetention'] = None):
        """
        :param 'OntapVolumeSnaplockConfigurationRetentionPeriodDefaultRetentionArgs' default_retention: The retention period assigned to a write once, read many (WORM) file by default if an explicit retention period is not set for an FSx for ONTAP SnapLock volume. The default retention period must be greater than or equal to the minimum retention period and less than or equal to the maximum retention period. See Retention Period below.
        :param 'OntapVolumeSnaplockConfigurationRetentionPeriodMaximumRetentionArgs' maximum_retention: The longest retention period that can be assigned to a WORM file on an FSx for ONTAP SnapLock volume. See Retention Period below.
        :param 'OntapVolumeSnaplockConfigurationRetentionPeriodMinimumRetentionArgs' minimum_retention: The shortest retention period that can be assigned to a WORM file on an FSx for ONTAP SnapLock volume. See Retention Period below.
        """
        if default_retention is not None:
            pulumi.set(__self__, "default_retention", default_retention)
        if maximum_retention is not None:
            pulumi.set(__self__, "maximum_retention", maximum_retention)
        if minimum_retention is not None:
            pulumi.set(__self__, "minimum_retention", minimum_retention)

    @property
    @pulumi.getter(name="defaultRetention")
    def default_retention(self) -> Optional['outputs.OntapVolumeSnaplockConfigurationRetentionPeriodDefaultRetention']:
        """
        The retention period assigned to a write once, read many (WORM) file by default if an explicit retention period is not set for an FSx for ONTAP SnapLock volume. The default retention period must be greater than or equal to the minimum retention period and less than or equal to the maximum retention period. See Retention Period below.
        """
        return pulumi.get(self, "default_retention")

    @property
    @pulumi.getter(name="maximumRetention")
    def maximum_retention(self) -> Optional['outputs.OntapVolumeSnaplockConfigurationRetentionPeriodMaximumRetention']:
        """
        The longest retention period that can be assigned to a WORM file on an FSx for ONTAP SnapLock volume. See Retention Period below.
        """
        return pulumi.get(self, "maximum_retention")

    @property
    @pulumi.getter(name="minimumRetention")
    def minimum_retention(self) -> Optional['outputs.OntapVolumeSnaplockConfigurationRetentionPeriodMinimumRetention']:
        """
        The shortest retention period that can be assigned to a WORM file on an FSx for ONTAP SnapLock volume. See Retention Period below.
        """
        return pulumi.get(self, "minimum_retention")


@pulumi.output_type
class OntapVolumeSnaplockConfigurationRetentionPeriodDefaultRetention(dict):
    def __init__(__self__, *,
                 type: Optional[str] = None,
                 value: Optional[int] = None):
        """
        :param str type: The type of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume. Setting this value to `NONE` disables autocommit. Valid values: `MINUTES`, `HOURS`, `DAYS`, `MONTHS`, `YEARS`, `NONE`.
        :param int value: The amount of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume. Setting this value to `NONE` disables autocommit. Valid values: `MINUTES`, `HOURS`, `DAYS`, `MONTHS`, `YEARS`, `NONE`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[int]:
        """
        The amount of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class OntapVolumeSnaplockConfigurationRetentionPeriodMaximumRetention(dict):
    def __init__(__self__, *,
                 type: Optional[str] = None,
                 value: Optional[int] = None):
        """
        :param str type: The type of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume. Setting this value to `NONE` disables autocommit. Valid values: `MINUTES`, `HOURS`, `DAYS`, `MONTHS`, `YEARS`, `NONE`.
        :param int value: The amount of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume. Setting this value to `NONE` disables autocommit. Valid values: `MINUTES`, `HOURS`, `DAYS`, `MONTHS`, `YEARS`, `NONE`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[int]:
        """
        The amount of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class OntapVolumeSnaplockConfigurationRetentionPeriodMinimumRetention(dict):
    def __init__(__self__, *,
                 type: Optional[str] = None,
                 value: Optional[int] = None):
        """
        :param str type: The type of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume. Setting this value to `NONE` disables autocommit. Valid values: `MINUTES`, `HOURS`, `DAYS`, `MONTHS`, `YEARS`, `NONE`.
        :param int value: The amount of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume. Setting this value to `NONE` disables autocommit. Valid values: `MINUTES`, `HOURS`, `DAYS`, `MONTHS`, `YEARS`, `NONE`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[int]:
        """
        The amount of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class OntapVolumeTieringPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "coolingPeriod":
            suggest = "cooling_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OntapVolumeTieringPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OntapVolumeTieringPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OntapVolumeTieringPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cooling_period: Optional[int] = None,
                 name: Optional[str] = None):
        """
        :param int cooling_period: Specifies the number of days that user data in a volume must remain inactive before it is considered "cold" and moved to the capacity pool. Used with `AUTO` and `SNAPSHOT_ONLY` tiering policies only. Valid values are whole numbers between 2 and 183. Default values are 31 days for `AUTO` and 2 days for `SNAPSHOT_ONLY`.
        :param str name: Specifies the tiering policy for the ONTAP volume for moving data to the capacity pool storage. Valid values are `SNAPSHOT_ONLY`, `AUTO`, `ALL`, `NONE`. Default value is `SNAPSHOT_ONLY`.
        """
        if cooling_period is not None:
            pulumi.set(__self__, "cooling_period", cooling_period)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="coolingPeriod")
    def cooling_period(self) -> Optional[int]:
        """
        Specifies the number of days that user data in a volume must remain inactive before it is considered "cold" and moved to the capacity pool. Used with `AUTO` and `SNAPSHOT_ONLY` tiering policies only. Valid values are whole numbers between 2 and 183. Default values are 31 days for `AUTO` and 2 days for `SNAPSHOT_ONLY`.
        """
        return pulumi.get(self, "cooling_period")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Specifies the tiering policy for the ONTAP volume for moving data to the capacity pool storage. Valid values are `SNAPSHOT_ONLY`, `AUTO`, `ALL`, `NONE`. Default value is `SNAPSHOT_ONLY`.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class OpenZfsFileSystemDiskIopsConfiguration(dict):
    def __init__(__self__, *,
                 iops: Optional[int] = None,
                 mode: Optional[str] = None):
        """
        :param int iops: The total number of SSD IOPS provisioned for the file system.
        :param str mode: Specifies whether the number of IOPS for the file system is using the system. Valid values are `AUTOMATIC` and `USER_PROVISIONED`. Default value is `AUTOMATIC`.
        """
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        The total number of SSD IOPS provisioned for the file system.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Specifies whether the number of IOPS for the file system is using the system. Valid values are `AUTOMATIC` and `USER_PROVISIONED`. Default value is `AUTOMATIC`.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class OpenZfsFileSystemRootVolumeConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "copyTagsToSnapshots":
            suggest = "copy_tags_to_snapshots"
        elif key == "dataCompressionType":
            suggest = "data_compression_type"
        elif key == "nfsExports":
            suggest = "nfs_exports"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "recordSizeKib":
            suggest = "record_size_kib"
        elif key == "userAndGroupQuotas":
            suggest = "user_and_group_quotas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OpenZfsFileSystemRootVolumeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OpenZfsFileSystemRootVolumeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OpenZfsFileSystemRootVolumeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 copy_tags_to_snapshots: Optional[bool] = None,
                 data_compression_type: Optional[str] = None,
                 nfs_exports: Optional['outputs.OpenZfsFileSystemRootVolumeConfigurationNfsExports'] = None,
                 read_only: Optional[bool] = None,
                 record_size_kib: Optional[int] = None,
                 user_and_group_quotas: Optional[Sequence['outputs.OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuota']] = None):
        """
        :param bool copy_tags_to_snapshots: A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
        :param str data_compression_type: Method used to compress the data on the volume. Valid values are `LZ4`, `NONE` or `ZSTD`. Child volumes that don't specify compression option will inherit from parent volume. This option on file system applies to the root volume.
        :param 'OpenZfsFileSystemRootVolumeConfigurationNfsExportsArgs' nfs_exports: NFS export configuration for the root volume. Exactly 1 item. See NFS Exports Below.
        :param bool read_only: specifies whether the volume is read-only. Default is false.
        :param int record_size_kib: Specifies the record size of an OpenZFS root volume, in kibibytes (KiB). Valid values are `4`, `8`, `16`, `32`, `64`, `128`, `256`, `512`, or `1024` KiB. The default is `128` KiB.
        :param Sequence['OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgs'] user_and_group_quotas: Specify how much storage users or groups can use on the volume. Maximum of 100 items. See User and Group Quotas Below.
        """
        if copy_tags_to_snapshots is not None:
            pulumi.set(__self__, "copy_tags_to_snapshots", copy_tags_to_snapshots)
        if data_compression_type is not None:
            pulumi.set(__self__, "data_compression_type", data_compression_type)
        if nfs_exports is not None:
            pulumi.set(__self__, "nfs_exports", nfs_exports)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if record_size_kib is not None:
            pulumi.set(__self__, "record_size_kib", record_size_kib)
        if user_and_group_quotas is not None:
            pulumi.set(__self__, "user_and_group_quotas", user_and_group_quotas)

    @property
    @pulumi.getter(name="copyTagsToSnapshots")
    def copy_tags_to_snapshots(self) -> Optional[bool]:
        """
        A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
        """
        return pulumi.get(self, "copy_tags_to_snapshots")

    @property
    @pulumi.getter(name="dataCompressionType")
    def data_compression_type(self) -> Optional[str]:
        """
        Method used to compress the data on the volume. Valid values are `LZ4`, `NONE` or `ZSTD`. Child volumes that don't specify compression option will inherit from parent volume. This option on file system applies to the root volume.
        """
        return pulumi.get(self, "data_compression_type")

    @property
    @pulumi.getter(name="nfsExports")
    def nfs_exports(self) -> Optional['outputs.OpenZfsFileSystemRootVolumeConfigurationNfsExports']:
        """
        NFS export configuration for the root volume. Exactly 1 item. See NFS Exports Below.
        """
        return pulumi.get(self, "nfs_exports")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[bool]:
        """
        specifies whether the volume is read-only. Default is false.
        """
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter(name="recordSizeKib")
    def record_size_kib(self) -> Optional[int]:
        """
        Specifies the record size of an OpenZFS root volume, in kibibytes (KiB). Valid values are `4`, `8`, `16`, `32`, `64`, `128`, `256`, `512`, or `1024` KiB. The default is `128` KiB.
        """
        return pulumi.get(self, "record_size_kib")

    @property
    @pulumi.getter(name="userAndGroupQuotas")
    def user_and_group_quotas(self) -> Optional[Sequence['outputs.OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuota']]:
        """
        Specify how much storage users or groups can use on the volume. Maximum of 100 items. See User and Group Quotas Below.
        """
        return pulumi.get(self, "user_and_group_quotas")


@pulumi.output_type
class OpenZfsFileSystemRootVolumeConfigurationNfsExports(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientConfigurations":
            suggest = "client_configurations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OpenZfsFileSystemRootVolumeConfigurationNfsExports. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OpenZfsFileSystemRootVolumeConfigurationNfsExports.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OpenZfsFileSystemRootVolumeConfigurationNfsExports.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_configurations: Sequence['outputs.OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfiguration']):
        """
        :param Sequence['OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfigurationArgs'] client_configurations: A list of configuration objects that contain the client and options for mounting the OpenZFS file system. Maximum of 25 items. See Client Configurations Below.
        """
        pulumi.set(__self__, "client_configurations", client_configurations)

    @property
    @pulumi.getter(name="clientConfigurations")
    def client_configurations(self) -> Sequence['outputs.OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfiguration']:
        """
        A list of configuration objects that contain the client and options for mounting the OpenZFS file system. Maximum of 25 items. See Client Configurations Below.
        """
        return pulumi.get(self, "client_configurations")


@pulumi.output_type
class OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfiguration(dict):
    def __init__(__self__, *,
                 clients: str,
                 options: Sequence[str]):
        """
        :param str clients: A value that specifies who can mount the file system. You can provide a wildcard character (*), an IP address (0.0.0.0), or a CIDR address (192.0.2.0/24. By default, Amazon FSx uses the wildcard character when specifying the client.
        :param Sequence[str] options: The options to use when mounting the file system. Maximum of 20 items. See the [Linix NFS exports man page](https://linux.die.net/man/5/exports) for more information. `crossmount` and `sync` are used by default.
        """
        pulumi.set(__self__, "clients", clients)
        pulumi.set(__self__, "options", options)

    @property
    @pulumi.getter
    def clients(self) -> str:
        """
        A value that specifies who can mount the file system. You can provide a wildcard character (*), an IP address (0.0.0.0), or a CIDR address (192.0.2.0/24. By default, Amazon FSx uses the wildcard character when specifying the client.
        """
        return pulumi.get(self, "clients")

    @property
    @pulumi.getter
    def options(self) -> Sequence[str]:
        """
        The options to use when mounting the file system. Maximum of 20 items. See the [Linix NFS exports man page](https://linux.die.net/man/5/exports) for more information. `crossmount` and `sync` are used by default.
        """
        return pulumi.get(self, "options")


@pulumi.output_type
class OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuota(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageCapacityQuotaGib":
            suggest = "storage_capacity_quota_gib"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuota. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuota.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuota.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: int,
                 storage_capacity_quota_gib: int,
                 type: str):
        """
        :param int id: The ID of the user or group. Valid values between `0` and `2147483647`
        :param int storage_capacity_quota_gib: The amount of storage that the user or group can use in gibibytes (GiB). Valid values between `0` and `2147483647`
        :param str type: A value that specifies whether the quota applies to a user or group. Valid values are `USER` or `GROUP`.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "storage_capacity_quota_gib", storage_capacity_quota_gib)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        The ID of the user or group. Valid values between `0` and `2147483647`
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="storageCapacityQuotaGib")
    def storage_capacity_quota_gib(self) -> int:
        """
        The amount of storage that the user or group can use in gibibytes (GiB). Valid values between `0` and `2147483647`
        """
        return pulumi.get(self, "storage_capacity_quota_gib")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        A value that specifies whether the quota applies to a user or group. Valid values are `USER` or `GROUP`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class OpenZfsVolumeNfsExports(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientConfigurations":
            suggest = "client_configurations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OpenZfsVolumeNfsExports. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OpenZfsVolumeNfsExports.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OpenZfsVolumeNfsExports.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_configurations: Sequence['outputs.OpenZfsVolumeNfsExportsClientConfiguration']):
        """
        :param Sequence['OpenZfsVolumeNfsExportsClientConfigurationArgs'] client_configurations: A list of configuration objects that contain the client and options for mounting the OpenZFS file system. Maximum of 25 items. See `client_configurations` Block below for details.
        """
        pulumi.set(__self__, "client_configurations", client_configurations)

    @property
    @pulumi.getter(name="clientConfigurations")
    def client_configurations(self) -> Sequence['outputs.OpenZfsVolumeNfsExportsClientConfiguration']:
        """
        A list of configuration objects that contain the client and options for mounting the OpenZFS file system. Maximum of 25 items. See `client_configurations` Block below for details.
        """
        return pulumi.get(self, "client_configurations")


@pulumi.output_type
class OpenZfsVolumeNfsExportsClientConfiguration(dict):
    def __init__(__self__, *,
                 clients: str,
                 options: Sequence[str]):
        """
        :param str clients: A value that specifies who can mount the file system. You can provide a wildcard character (*), an IP address (0.0.0.0), or a CIDR address (192.0.2.0/24. By default, Amazon FSx uses the wildcard character when specifying the client.
        :param Sequence[str] options: The options to use when mounting the file system. Maximum of 20 items. See the [Linix NFS exports man page](https://linux.die.net/man/5/exports) for more information. `crossmount` and `sync` are used by default.
        """
        pulumi.set(__self__, "clients", clients)
        pulumi.set(__self__, "options", options)

    @property
    @pulumi.getter
    def clients(self) -> str:
        """
        A value that specifies who can mount the file system. You can provide a wildcard character (*), an IP address (0.0.0.0), or a CIDR address (192.0.2.0/24. By default, Amazon FSx uses the wildcard character when specifying the client.
        """
        return pulumi.get(self, "clients")

    @property
    @pulumi.getter
    def options(self) -> Sequence[str]:
        """
        The options to use when mounting the file system. Maximum of 20 items. See the [Linix NFS exports man page](https://linux.die.net/man/5/exports) for more information. `crossmount` and `sync` are used by default.
        """
        return pulumi.get(self, "options")


@pulumi.output_type
class OpenZfsVolumeOriginSnapshot(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "copyStrategy":
            suggest = "copy_strategy"
        elif key == "snapshotArn":
            suggest = "snapshot_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OpenZfsVolumeOriginSnapshot. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OpenZfsVolumeOriginSnapshot.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OpenZfsVolumeOriginSnapshot.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 copy_strategy: str,
                 snapshot_arn: str):
        """
        :param str copy_strategy: Specifies the strategy used when copying data from the snapshot to the new volume. Valid values are `CLONE`, `FULL_COPY`, `INCREMENTAL_COPY`.
        :param str snapshot_arn: The Amazon Resource Name (ARN) of the origin snapshot.
        """
        pulumi.set(__self__, "copy_strategy", copy_strategy)
        pulumi.set(__self__, "snapshot_arn", snapshot_arn)

    @property
    @pulumi.getter(name="copyStrategy")
    def copy_strategy(self) -> str:
        """
        Specifies the strategy used when copying data from the snapshot to the new volume. Valid values are `CLONE`, `FULL_COPY`, `INCREMENTAL_COPY`.
        """
        return pulumi.get(self, "copy_strategy")

    @property
    @pulumi.getter(name="snapshotArn")
    def snapshot_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the origin snapshot.
        """
        return pulumi.get(self, "snapshot_arn")


@pulumi.output_type
class OpenZfsVolumeUserAndGroupQuota(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageCapacityQuotaGib":
            suggest = "storage_capacity_quota_gib"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OpenZfsVolumeUserAndGroupQuota. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OpenZfsVolumeUserAndGroupQuota.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OpenZfsVolumeUserAndGroupQuota.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: int,
                 storage_capacity_quota_gib: int,
                 type: str):
        """
        :param int id: The ID of the user or group. Valid values between `0` and `2147483647`
        :param int storage_capacity_quota_gib: The amount of storage that the user or group can use in gibibytes (GiB). Valid values between `0` and `2147483647`
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "storage_capacity_quota_gib", storage_capacity_quota_gib)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        The ID of the user or group. Valid values between `0` and `2147483647`
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="storageCapacityQuotaGib")
    def storage_capacity_quota_gib(self) -> int:
        """
        The amount of storage that the user or group can use in gibibytes (GiB). Valid values between `0` and `2147483647`
        """
        return pulumi.get(self, "storage_capacity_quota_gib")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class WindowsFileSystemAuditLogConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditLogDestination":
            suggest = "audit_log_destination"
        elif key == "fileAccessAuditLogLevel":
            suggest = "file_access_audit_log_level"
        elif key == "fileShareAccessAuditLogLevel":
            suggest = "file_share_access_audit_log_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsFileSystemAuditLogConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsFileSystemAuditLogConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsFileSystemAuditLogConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_log_destination: Optional[str] = None,
                 file_access_audit_log_level: Optional[str] = None,
                 file_share_access_audit_log_level: Optional[str] = None):
        """
        :param str audit_log_destination: The Amazon Resource Name (ARN) for the destination of the audit logs. The destination can be any Amazon CloudWatch Logs log group ARN or Amazon Kinesis Data Firehose delivery stream ARN. Can be specified when `file_access_audit_log_level` and `file_share_access_audit_log_level` are not set to `DISABLED`. The name of the Amazon CloudWatch Logs log group must begin with the `/aws/fsx` prefix. The name of the Amazon Kinesis Data Firehouse delivery stream must begin with the `aws-fsx` prefix. If you do not provide a destination in `audit_log_destionation`, Amazon FSx will create and use a log stream in the CloudWatch Logs /aws/fsx/windows log group.
        :param str file_access_audit_log_level: Sets which attempt type is logged by Amazon FSx for file and folder accesses. Valid values are `SUCCESS_ONLY`, `FAILURE_ONLY`, `SUCCESS_AND_FAILURE`, and `DISABLED`. Default value is `DISABLED`.
        :param str file_share_access_audit_log_level: Sets which attempt type is logged by Amazon FSx for file share accesses. Valid values are `SUCCESS_ONLY`, `FAILURE_ONLY`, `SUCCESS_AND_FAILURE`, and `DISABLED`. Default value is `DISABLED`.
        """
        if audit_log_destination is not None:
            pulumi.set(__self__, "audit_log_destination", audit_log_destination)
        if file_access_audit_log_level is not None:
            pulumi.set(__self__, "file_access_audit_log_level", file_access_audit_log_level)
        if file_share_access_audit_log_level is not None:
            pulumi.set(__self__, "file_share_access_audit_log_level", file_share_access_audit_log_level)

    @property
    @pulumi.getter(name="auditLogDestination")
    def audit_log_destination(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) for the destination of the audit logs. The destination can be any Amazon CloudWatch Logs log group ARN or Amazon Kinesis Data Firehose delivery stream ARN. Can be specified when `file_access_audit_log_level` and `file_share_access_audit_log_level` are not set to `DISABLED`. The name of the Amazon CloudWatch Logs log group must begin with the `/aws/fsx` prefix. The name of the Amazon Kinesis Data Firehouse delivery stream must begin with the `aws-fsx` prefix. If you do not provide a destination in `audit_log_destionation`, Amazon FSx will create and use a log stream in the CloudWatch Logs /aws/fsx/windows log group.
        """
        return pulumi.get(self, "audit_log_destination")

    @property
    @pulumi.getter(name="fileAccessAuditLogLevel")
    def file_access_audit_log_level(self) -> Optional[str]:
        """
        Sets which attempt type is logged by Amazon FSx for file and folder accesses. Valid values are `SUCCESS_ONLY`, `FAILURE_ONLY`, `SUCCESS_AND_FAILURE`, and `DISABLED`. Default value is `DISABLED`.
        """
        return pulumi.get(self, "file_access_audit_log_level")

    @property
    @pulumi.getter(name="fileShareAccessAuditLogLevel")
    def file_share_access_audit_log_level(self) -> Optional[str]:
        """
        Sets which attempt type is logged by Amazon FSx for file share accesses. Valid values are `SUCCESS_ONLY`, `FAILURE_ONLY`, `SUCCESS_AND_FAILURE`, and `DISABLED`. Default value is `DISABLED`.
        """
        return pulumi.get(self, "file_share_access_audit_log_level")


@pulumi.output_type
class WindowsFileSystemDiskIopsConfiguration(dict):
    def __init__(__self__, *,
                 iops: Optional[int] = None,
                 mode: Optional[str] = None):
        """
        :param int iops: The total number of SSD IOPS provisioned for the file system.
        :param str mode: Specifies whether the number of IOPS for the file system is using the system. Valid values are `AUTOMATIC` and `USER_PROVISIONED`. Default value is `AUTOMATIC`.
        """
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        The total number of SSD IOPS provisioned for the file system.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Specifies whether the number of IOPS for the file system is using the system. Valid values are `AUTOMATIC` and `USER_PROVISIONED`. Default value is `AUTOMATIC`.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class WindowsFileSystemSelfManagedActiveDirectory(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsIps":
            suggest = "dns_ips"
        elif key == "domainName":
            suggest = "domain_name"
        elif key == "fileSystemAdministratorsGroup":
            suggest = "file_system_administrators_group"
        elif key == "organizationalUnitDistinguishedName":
            suggest = "organizational_unit_distinguished_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsFileSystemSelfManagedActiveDirectory. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsFileSystemSelfManagedActiveDirectory.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsFileSystemSelfManagedActiveDirectory.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_ips: Sequence[str],
                 domain_name: str,
                 password: str,
                 username: str,
                 file_system_administrators_group: Optional[str] = None,
                 organizational_unit_distinguished_name: Optional[str] = None):
        """
        :param Sequence[str] dns_ips: A list of up to two IP addresses of DNS servers or domain controllers in the self-managed AD directory. The IP addresses need to be either in the same VPC CIDR range as the file system or in the private IP version 4 (IPv4) address ranges as specified in [RFC 1918](https://tools.ietf.org/html/rfc1918).
        :param str domain_name: The fully qualified domain name of the self-managed AD directory. For example, `corp.example.com`.
        :param str password: The password for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        :param str username: The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        :param str file_system_administrators_group: The name of the domain group whose members are granted administrative privileges for the file system. Administrative privileges include taking ownership of files and folders, and setting audit controls (audit ACLs) on files and folders. The group that you specify must already exist in your domain. Defaults to `Domain Admins`.
        :param str organizational_unit_distinguished_name: The fully qualified distinguished name of the organizational unit within your self-managed AD directory that the Windows File Server instance will join. For example, `OU=FSx,DC=yourdomain,DC=corp,DC=com`. Only accepts OU as the direct parent of the file system. If none is provided, the FSx file system is created in the default location of your self-managed AD directory. To learn more, see [RFC 2253](https://tools.ietf.org/html/rfc2253).
        """
        pulumi.set(__self__, "dns_ips", dns_ips)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if file_system_administrators_group is not None:
            pulumi.set(__self__, "file_system_administrators_group", file_system_administrators_group)
        if organizational_unit_distinguished_name is not None:
            pulumi.set(__self__, "organizational_unit_distinguished_name", organizational_unit_distinguished_name)

    @property
    @pulumi.getter(name="dnsIps")
    def dns_ips(self) -> Sequence[str]:
        """
        A list of up to two IP addresses of DNS servers or domain controllers in the self-managed AD directory. The IP addresses need to be either in the same VPC CIDR range as the file system or in the private IP version 4 (IPv4) address ranges as specified in [RFC 1918](https://tools.ietf.org/html/rfc1918).
        """
        return pulumi.get(self, "dns_ips")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> str:
        """
        The fully qualified domain name of the self-managed AD directory. For example, `corp.example.com`.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="fileSystemAdministratorsGroup")
    def file_system_administrators_group(self) -> Optional[str]:
        """
        The name of the domain group whose members are granted administrative privileges for the file system. Administrative privileges include taking ownership of files and folders, and setting audit controls (audit ACLs) on files and folders. The group that you specify must already exist in your domain. Defaults to `Domain Admins`.
        """
        return pulumi.get(self, "file_system_administrators_group")

    @property
    @pulumi.getter(name="organizationalUnitDistinguishedName")
    def organizational_unit_distinguished_name(self) -> Optional[str]:
        """
        The fully qualified distinguished name of the organizational unit within your self-managed AD directory that the Windows File Server instance will join. For example, `OU=FSx,DC=yourdomain,DC=corp,DC=com`. Only accepts OU as the direct parent of the file system. If none is provided, the FSx file system is created in the default location of your self-managed AD directory. To learn more, see [RFC 2253](https://tools.ietf.org/html/rfc2253).
        """
        return pulumi.get(self, "organizational_unit_distinguished_name")


@pulumi.output_type
class GetOntapFileSystemDiskIopsConfigurationResult(dict):
    def __init__(__self__, *,
                 iops: int,
                 mode: str):
        """
        :param int iops: The total number of SSD IOPS provisioned for the file system.
        :param str mode: Specifies whether the file system is using the `AUTOMATIC` setting of SSD IOPS of 3 IOPS per GB of storage capacity, or if it using a `USER_PROVISIONED` value.
        """
        pulumi.set(__self__, "iops", iops)
        pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def iops(self) -> int:
        """
        The total number of SSD IOPS provisioned for the file system.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Specifies whether the file system is using the `AUTOMATIC` setting of SSD IOPS of 3 IOPS per GB of storage capacity, or if it using a `USER_PROVISIONED` value.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class GetOntapFileSystemEndpointResult(dict):
    def __init__(__self__, *,
                 interclusters: Sequence['outputs.GetOntapFileSystemEndpointInterclusterResult'],
                 managements: Sequence['outputs.GetOntapFileSystemEndpointManagementResult']):
        """
        :param Sequence['GetOntapFileSystemEndpointInterclusterArgs'] interclusters: A FileSystemEndpoint for managing your file system by setting up NetApp SnapMirror with other ONTAP systems. See FileSystemEndpoint below.
        :param Sequence['GetOntapFileSystemEndpointManagementArgs'] managements: A FileSystemEndpoint for managing your file system using the NetApp ONTAP CLI and NetApp ONTAP API. See FileSystemEndpoint below.
        """
        pulumi.set(__self__, "interclusters", interclusters)
        pulumi.set(__self__, "managements", managements)

    @property
    @pulumi.getter
    def interclusters(self) -> Sequence['outputs.GetOntapFileSystemEndpointInterclusterResult']:
        """
        A FileSystemEndpoint for managing your file system by setting up NetApp SnapMirror with other ONTAP systems. See FileSystemEndpoint below.
        """
        return pulumi.get(self, "interclusters")

    @property
    @pulumi.getter
    def managements(self) -> Sequence['outputs.GetOntapFileSystemEndpointManagementResult']:
        """
        A FileSystemEndpoint for managing your file system using the NetApp ONTAP CLI and NetApp ONTAP API. See FileSystemEndpoint below.
        """
        return pulumi.get(self, "managements")


@pulumi.output_type
class GetOntapFileSystemEndpointInterclusterResult(dict):
    def __init__(__self__, *,
                 dns_name: str,
                 ip_addresses: Sequence[str]):
        """
        :param str dns_name: DNS name for the file system (e.g. `fs-12345678.corp.example.com`).
        """
        pulumi.set(__self__, "dns_name", dns_name)
        pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> str:
        """
        DNS name for the file system (e.g. `fs-12345678.corp.example.com`).
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[str]:
        return pulumi.get(self, "ip_addresses")


@pulumi.output_type
class GetOntapFileSystemEndpointManagementResult(dict):
    def __init__(__self__, *,
                 dns_name: str,
                 ip_addresses: Sequence[str]):
        """
        :param str dns_name: DNS name for the file system (e.g. `fs-12345678.corp.example.com`).
        """
        pulumi.set(__self__, "dns_name", dns_name)
        pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> str:
        """
        DNS name for the file system (e.g. `fs-12345678.corp.example.com`).
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[str]:
        return pulumi.get(self, "ip_addresses")


@pulumi.output_type
class GetOntapStorageVirtualMachineActiveDirectoryConfigurationResult(dict):
    def __init__(__self__, *,
                 netbios_name: str,
                 self_managed_active_directory_configurations: Sequence['outputs.GetOntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfigurationResult']):
        """
        :param str netbios_name: The NetBIOS name of the AD computer object to which the SVM is joined.
        """
        pulumi.set(__self__, "netbios_name", netbios_name)
        pulumi.set(__self__, "self_managed_active_directory_configurations", self_managed_active_directory_configurations)

    @property
    @pulumi.getter(name="netbiosName")
    def netbios_name(self) -> str:
        """
        The NetBIOS name of the AD computer object to which the SVM is joined.
        """
        return pulumi.get(self, "netbios_name")

    @property
    @pulumi.getter(name="selfManagedActiveDirectoryConfigurations")
    def self_managed_active_directory_configurations(self) -> Sequence['outputs.GetOntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfigurationResult']:
        return pulumi.get(self, "self_managed_active_directory_configurations")


@pulumi.output_type
class GetOntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfigurationResult(dict):
    def __init__(__self__, *,
                 dns_ips: Sequence[str],
                 domain_name: str,
                 file_system_administrators_group: str,
                 organizational_unit_distinguished_name: str,
                 username: str):
        """
        :param Sequence[str] dns_ips: A list of up to three IP addresses of DNS servers or domain controllers in the self-managed AD directory.
        :param str domain_name: The fully qualified domain name of the self-managed AD directory.
        :param str file_system_administrators_group: The name of the domain group whose members have administrative privileges for the FSx file system.
        :param str organizational_unit_distinguished_name: The fully qualified distinguished name of the organizational unit within the self-managed AD directory to which the Windows File Server or ONTAP storage virtual machine (SVM) instance is joined.
        :param str username: The user name for the service account on your self-managed AD domain that FSx uses to join to your AD domain.
        """
        pulumi.set(__self__, "dns_ips", dns_ips)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "file_system_administrators_group", file_system_administrators_group)
        pulumi.set(__self__, "organizational_unit_distinguished_name", organizational_unit_distinguished_name)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="dnsIps")
    def dns_ips(self) -> Sequence[str]:
        """
        A list of up to three IP addresses of DNS servers or domain controllers in the self-managed AD directory.
        """
        return pulumi.get(self, "dns_ips")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> str:
        """
        The fully qualified domain name of the self-managed AD directory.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="fileSystemAdministratorsGroup")
    def file_system_administrators_group(self) -> str:
        """
        The name of the domain group whose members have administrative privileges for the FSx file system.
        """
        return pulumi.get(self, "file_system_administrators_group")

    @property
    @pulumi.getter(name="organizationalUnitDistinguishedName")
    def organizational_unit_distinguished_name(self) -> str:
        """
        The fully qualified distinguished name of the organizational unit within the self-managed AD directory to which the Windows File Server or ONTAP storage virtual machine (SVM) instance is joined.
        """
        return pulumi.get(self, "organizational_unit_distinguished_name")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The user name for the service account on your self-managed AD domain that FSx uses to join to your AD domain.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetOntapStorageVirtualMachineEndpointResult(dict):
    def __init__(__self__, *,
                 iscsis: Sequence['outputs.GetOntapStorageVirtualMachineEndpointIscsiResult'],
                 managements: Sequence['outputs.GetOntapStorageVirtualMachineEndpointManagementResult'],
                 nfs: Sequence['outputs.GetOntapStorageVirtualMachineEndpointNfResult'],
                 smbs: Sequence['outputs.GetOntapStorageVirtualMachineEndpointSmbResult']):
        """
        :param Sequence['GetOntapStorageVirtualMachineEndpointManagementArgs'] managements: An endpoint for managing SVMs using the NetApp ONTAP CLI, NetApp ONTAP API, or NetApp CloudManager. See SVM Endpoint below.
        :param Sequence['GetOntapStorageVirtualMachineEndpointNfArgs'] nfs: An endpoint for connecting using the Network File System (NFS) protocol. See SVM Endpoint below.
        :param Sequence['GetOntapStorageVirtualMachineEndpointSmbArgs'] smbs: An endpoint for connecting using the Server Message Block (SMB) protocol. See SVM Endpoint below.
        """
        pulumi.set(__self__, "iscsis", iscsis)
        pulumi.set(__self__, "managements", managements)
        pulumi.set(__self__, "nfs", nfs)
        pulumi.set(__self__, "smbs", smbs)

    @property
    @pulumi.getter
    def iscsis(self) -> Sequence['outputs.GetOntapStorageVirtualMachineEndpointIscsiResult']:
        return pulumi.get(self, "iscsis")

    @property
    @pulumi.getter
    def managements(self) -> Sequence['outputs.GetOntapStorageVirtualMachineEndpointManagementResult']:
        """
        An endpoint for managing SVMs using the NetApp ONTAP CLI, NetApp ONTAP API, or NetApp CloudManager. See SVM Endpoint below.
        """
        return pulumi.get(self, "managements")

    @property
    @pulumi.getter
    def nfs(self) -> Sequence['outputs.GetOntapStorageVirtualMachineEndpointNfResult']:
        """
        An endpoint for connecting using the Network File System (NFS) protocol. See SVM Endpoint below.
        """
        return pulumi.get(self, "nfs")

    @property
    @pulumi.getter
    def smbs(self) -> Sequence['outputs.GetOntapStorageVirtualMachineEndpointSmbResult']:
        """
        An endpoint for connecting using the Server Message Block (SMB) protocol. See SVM Endpoint below.
        """
        return pulumi.get(self, "smbs")


@pulumi.output_type
class GetOntapStorageVirtualMachineEndpointIscsiResult(dict):
    def __init__(__self__, *,
                 dns_name: str,
                 ip_addresses: Sequence[str]):
        pulumi.set(__self__, "dns_name", dns_name)
        pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> str:
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[str]:
        return pulumi.get(self, "ip_addresses")


@pulumi.output_type
class GetOntapStorageVirtualMachineEndpointManagementResult(dict):
    def __init__(__self__, *,
                 dns_name: str,
                 ip_addresses: Sequence[str]):
        pulumi.set(__self__, "dns_name", dns_name)
        pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> str:
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[str]:
        return pulumi.get(self, "ip_addresses")


@pulumi.output_type
class GetOntapStorageVirtualMachineEndpointNfResult(dict):
    def __init__(__self__, *,
                 dns_name: str,
                 ip_addresses: Sequence[str]):
        pulumi.set(__self__, "dns_name", dns_name)
        pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> str:
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[str]:
        return pulumi.get(self, "ip_addresses")


@pulumi.output_type
class GetOntapStorageVirtualMachineEndpointSmbResult(dict):
    def __init__(__self__, *,
                 dns_name: str,
                 ip_addresses: Sequence[str]):
        pulumi.set(__self__, "dns_name", dns_name)
        pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> str:
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[str]:
        return pulumi.get(self, "ip_addresses")


@pulumi.output_type
class GetOntapStorageVirtualMachineFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Name of the field to filter by, as defined by [the underlying AWS API](https://docs.aws.amazon.com/fsx/latest/APIReference/API_StorageVirtualMachineFilter.html).
        :param Sequence[str] values: Set of values that are accepted for the given field. An SVM will be selected if any one of the given values matches.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the field to filter by, as defined by [the underlying AWS API](https://docs.aws.amazon.com/fsx/latest/APIReference/API_StorageVirtualMachineFilter.html).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Set of values that are accepted for the given field. An SVM will be selected if any one of the given values matches.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetOntapStorageVirtualMachineLifecycleTransitionReasonResult(dict):
    def __init__(__self__, *,
                 message: str):
        """
        :param str message: A detailed message.
        """
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A detailed message.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class GetOntapStorageVirtualMachinesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Name of the field to filter by, as defined by [the underlying AWS API](https://docs.aws.amazon.com/fsx/latest/APIReference/API_StorageVirtualMachineFilter.html).
        :param Sequence[str] values: Set of values that are accepted for the given field. An SVM will be selected if any one of the given values matches.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the field to filter by, as defined by [the underlying AWS API](https://docs.aws.amazon.com/fsx/latest/APIReference/API_StorageVirtualMachineFilter.html).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Set of values that are accepted for the given field. An SVM will be selected if any one of the given values matches.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetOpenZfsSnapshotFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Name of the snapshot.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the snapshot.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")


@pulumi.output_type
class GetWindowsFileSystemAuditLogConfigurationResult(dict):
    def __init__(__self__, *,
                 audit_log_destination: str,
                 file_access_audit_log_level: str,
                 file_share_access_audit_log_level: str):
        pulumi.set(__self__, "audit_log_destination", audit_log_destination)
        pulumi.set(__self__, "file_access_audit_log_level", file_access_audit_log_level)
        pulumi.set(__self__, "file_share_access_audit_log_level", file_share_access_audit_log_level)

    @property
    @pulumi.getter(name="auditLogDestination")
    def audit_log_destination(self) -> str:
        return pulumi.get(self, "audit_log_destination")

    @property
    @pulumi.getter(name="fileAccessAuditLogLevel")
    def file_access_audit_log_level(self) -> str:
        return pulumi.get(self, "file_access_audit_log_level")

    @property
    @pulumi.getter(name="fileShareAccessAuditLogLevel")
    def file_share_access_audit_log_level(self) -> str:
        return pulumi.get(self, "file_share_access_audit_log_level")


@pulumi.output_type
class GetWindowsFileSystemDiskIopsConfigurationResult(dict):
    def __init__(__self__, *,
                 iops: int,
                 mode: str):
        pulumi.set(__self__, "iops", iops)
        pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def iops(self) -> int:
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter
    def mode(self) -> str:
        return pulumi.get(self, "mode")


