# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MatchmakingConfigurationArgs', 'MatchmakingConfiguration']

@pulumi.input_type
class MatchmakingConfigurationArgs:
    def __init__(__self__, *,
                 request_timeout_seconds: pulumi.Input[int],
                 rule_set_name: pulumi.Input[str],
                 acceptance_required: Optional[pulumi.Input[bool]] = None,
                 acceptance_timeout_seconds: Optional[pulumi.Input[int]] = None,
                 additional_player_count: Optional[pulumi.Input[int]] = None,
                 backfill_mode: Optional[pulumi.Input[str]] = None,
                 custom_event_data: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 flex_match_mode: Optional[pulumi.Input[str]] = None,
                 game_properties: Optional[pulumi.Input[Sequence[pulumi.Input['MatchmakingConfigurationGamePropertyArgs']]]] = None,
                 game_session_data: Optional[pulumi.Input[str]] = None,
                 game_session_queue_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_target: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a MatchmakingConfiguration resource.
        :param pulumi.Input[int] request_timeout_seconds: The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out.
        :param pulumi.Input[str] rule_set_name: A rule set names for the matchmaking rule set to use with this configuration.
        :param pulumi.Input[bool] acceptance_required: Specifies if the match that was created with this configuration must be accepted by matched players.
        :param pulumi.Input[int] acceptance_timeout_seconds: The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required.
        :param pulumi.Input[int] additional_player_count: The number of player slots in a match to keep open for future players.
        :param pulumi.Input[str] backfill_mode: The method used to backfill game sessions that are created with this matchmaking configuration.
        :param pulumi.Input[str] custom_event_data: Information to be added to all events related to this matchmaking configuration.
        :param pulumi.Input[str] description: A human-readable description of the matchmaking configuration.
        :param pulumi.Input[str] flex_match_mode: Indicates whether this matchmaking configuration is being used with GameLift hosting or as a standalone matchmaking solution.
        :param pulumi.Input[Sequence[pulumi.Input['MatchmakingConfigurationGamePropertyArgs']]] game_properties: One or more custom game properties. See below.
        :param pulumi.Input[str] game_session_data: A set of custom game session properties.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] game_session_queue_arns: The ARNs of the GameLift game session queue resources.
        :param pulumi.Input[str] name: Name of the matchmaking configuration
        :param pulumi.Input[str] notification_target: An SNS topic ARN that is set up to receive matchmaking notifications.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "request_timeout_seconds", request_timeout_seconds)
        pulumi.set(__self__, "rule_set_name", rule_set_name)
        if acceptance_required is not None:
            pulumi.set(__self__, "acceptance_required", acceptance_required)
        if acceptance_timeout_seconds is not None:
            pulumi.set(__self__, "acceptance_timeout_seconds", acceptance_timeout_seconds)
        if additional_player_count is not None:
            pulumi.set(__self__, "additional_player_count", additional_player_count)
        if backfill_mode is not None:
            pulumi.set(__self__, "backfill_mode", backfill_mode)
        if custom_event_data is not None:
            pulumi.set(__self__, "custom_event_data", custom_event_data)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if flex_match_mode is not None:
            pulumi.set(__self__, "flex_match_mode", flex_match_mode)
        if game_properties is not None:
            pulumi.set(__self__, "game_properties", game_properties)
        if game_session_data is not None:
            pulumi.set(__self__, "game_session_data", game_session_data)
        if game_session_queue_arns is not None:
            pulumi.set(__self__, "game_session_queue_arns", game_session_queue_arns)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_target is not None:
            pulumi.set(__self__, "notification_target", notification_target)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="requestTimeoutSeconds")
    def request_timeout_seconds(self) -> pulumi.Input[int]:
        """
        The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out.
        """
        return pulumi.get(self, "request_timeout_seconds")

    @request_timeout_seconds.setter
    def request_timeout_seconds(self, value: pulumi.Input[int]):
        pulumi.set(self, "request_timeout_seconds", value)

    @property
    @pulumi.getter(name="ruleSetName")
    def rule_set_name(self) -> pulumi.Input[str]:
        """
        A rule set names for the matchmaking rule set to use with this configuration.
        """
        return pulumi.get(self, "rule_set_name")

    @rule_set_name.setter
    def rule_set_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_set_name", value)

    @property
    @pulumi.getter(name="acceptanceRequired")
    def acceptance_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if the match that was created with this configuration must be accepted by matched players.
        """
        return pulumi.get(self, "acceptance_required")

    @acceptance_required.setter
    def acceptance_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "acceptance_required", value)

    @property
    @pulumi.getter(name="acceptanceTimeoutSeconds")
    def acceptance_timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required.
        """
        return pulumi.get(self, "acceptance_timeout_seconds")

    @acceptance_timeout_seconds.setter
    def acceptance_timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "acceptance_timeout_seconds", value)

    @property
    @pulumi.getter(name="additionalPlayerCount")
    def additional_player_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of player slots in a match to keep open for future players.
        """
        return pulumi.get(self, "additional_player_count")

    @additional_player_count.setter
    def additional_player_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "additional_player_count", value)

    @property
    @pulumi.getter(name="backfillMode")
    def backfill_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The method used to backfill game sessions that are created with this matchmaking configuration.
        """
        return pulumi.get(self, "backfill_mode")

    @backfill_mode.setter
    def backfill_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backfill_mode", value)

    @property
    @pulumi.getter(name="customEventData")
    def custom_event_data(self) -> Optional[pulumi.Input[str]]:
        """
        Information to be added to all events related to this matchmaking configuration.
        """
        return pulumi.get(self, "custom_event_data")

    @custom_event_data.setter
    def custom_event_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_event_data", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A human-readable description of the matchmaking configuration.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="flexMatchMode")
    def flex_match_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether this matchmaking configuration is being used with GameLift hosting or as a standalone matchmaking solution.
        """
        return pulumi.get(self, "flex_match_mode")

    @flex_match_mode.setter
    def flex_match_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flex_match_mode", value)

    @property
    @pulumi.getter(name="gameProperties")
    def game_properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MatchmakingConfigurationGamePropertyArgs']]]]:
        """
        One or more custom game properties. See below.
        """
        return pulumi.get(self, "game_properties")

    @game_properties.setter
    def game_properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MatchmakingConfigurationGamePropertyArgs']]]]):
        pulumi.set(self, "game_properties", value)

    @property
    @pulumi.getter(name="gameSessionData")
    def game_session_data(self) -> Optional[pulumi.Input[str]]:
        """
        A set of custom game session properties.
        """
        return pulumi.get(self, "game_session_data")

    @game_session_data.setter
    def game_session_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "game_session_data", value)

    @property
    @pulumi.getter(name="gameSessionQueueArns")
    def game_session_queue_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The ARNs of the GameLift game session queue resources.
        """
        return pulumi.get(self, "game_session_queue_arns")

    @game_session_queue_arns.setter
    def game_session_queue_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "game_session_queue_arns", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the matchmaking configuration
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notificationTarget")
    def notification_target(self) -> Optional[pulumi.Input[str]]:
        """
        An SNS topic ARN that is set up to receive matchmaking notifications.
        """
        return pulumi.get(self, "notification_target")

    @notification_target.setter
    def notification_target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notification_target", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _MatchmakingConfigurationState:
    def __init__(__self__, *,
                 acceptance_required: Optional[pulumi.Input[bool]] = None,
                 acceptance_timeout_seconds: Optional[pulumi.Input[int]] = None,
                 additional_player_count: Optional[pulumi.Input[int]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 backfill_mode: Optional[pulumi.Input[str]] = None,
                 creation_time: Optional[pulumi.Input[str]] = None,
                 custom_event_data: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 flex_match_mode: Optional[pulumi.Input[str]] = None,
                 game_properties: Optional[pulumi.Input[Sequence[pulumi.Input['MatchmakingConfigurationGamePropertyArgs']]]] = None,
                 game_session_data: Optional[pulumi.Input[str]] = None,
                 game_session_queue_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_target: Optional[pulumi.Input[str]] = None,
                 request_timeout_seconds: Optional[pulumi.Input[int]] = None,
                 rule_set_arn: Optional[pulumi.Input[str]] = None,
                 rule_set_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering MatchmakingConfiguration resources.
        :param pulumi.Input[bool] acceptance_required: Specifies if the match that was created with this configuration must be accepted by matched players.
        :param pulumi.Input[int] acceptance_timeout_seconds: The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required.
        :param pulumi.Input[int] additional_player_count: The number of player slots in a match to keep open for future players.
        :param pulumi.Input[str] arn: Matchmaking Configuration ARN.
        :param pulumi.Input[str] backfill_mode: The method used to backfill game sessions that are created with this matchmaking configuration.
        :param pulumi.Input[str] creation_time: The time when the Matchmaking Configuration was created.
        :param pulumi.Input[str] custom_event_data: Information to be added to all events related to this matchmaking configuration.
        :param pulumi.Input[str] description: A human-readable description of the matchmaking configuration.
        :param pulumi.Input[str] flex_match_mode: Indicates whether this matchmaking configuration is being used with GameLift hosting or as a standalone matchmaking solution.
        :param pulumi.Input[Sequence[pulumi.Input['MatchmakingConfigurationGamePropertyArgs']]] game_properties: One or more custom game properties. See below.
        :param pulumi.Input[str] game_session_data: A set of custom game session properties.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] game_session_queue_arns: The ARNs of the GameLift game session queue resources.
        :param pulumi.Input[str] name: Name of the matchmaking configuration
        :param pulumi.Input[str] notification_target: An SNS topic ARN that is set up to receive matchmaking notifications.
        :param pulumi.Input[int] request_timeout_seconds: The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out.
        :param pulumi.Input[str] rule_set_name: A rule set names for the matchmaking rule set to use with this configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if acceptance_required is not None:
            pulumi.set(__self__, "acceptance_required", acceptance_required)
        if acceptance_timeout_seconds is not None:
            pulumi.set(__self__, "acceptance_timeout_seconds", acceptance_timeout_seconds)
        if additional_player_count is not None:
            pulumi.set(__self__, "additional_player_count", additional_player_count)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if backfill_mode is not None:
            pulumi.set(__self__, "backfill_mode", backfill_mode)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if custom_event_data is not None:
            pulumi.set(__self__, "custom_event_data", custom_event_data)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if flex_match_mode is not None:
            pulumi.set(__self__, "flex_match_mode", flex_match_mode)
        if game_properties is not None:
            pulumi.set(__self__, "game_properties", game_properties)
        if game_session_data is not None:
            pulumi.set(__self__, "game_session_data", game_session_data)
        if game_session_queue_arns is not None:
            pulumi.set(__self__, "game_session_queue_arns", game_session_queue_arns)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_target is not None:
            pulumi.set(__self__, "notification_target", notification_target)
        if request_timeout_seconds is not None:
            pulumi.set(__self__, "request_timeout_seconds", request_timeout_seconds)
        if rule_set_arn is not None:
            pulumi.set(__self__, "rule_set_arn", rule_set_arn)
        if rule_set_name is not None:
            pulumi.set(__self__, "rule_set_name", rule_set_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter(name="acceptanceRequired")
    def acceptance_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if the match that was created with this configuration must be accepted by matched players.
        """
        return pulumi.get(self, "acceptance_required")

    @acceptance_required.setter
    def acceptance_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "acceptance_required", value)

    @property
    @pulumi.getter(name="acceptanceTimeoutSeconds")
    def acceptance_timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required.
        """
        return pulumi.get(self, "acceptance_timeout_seconds")

    @acceptance_timeout_seconds.setter
    def acceptance_timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "acceptance_timeout_seconds", value)

    @property
    @pulumi.getter(name="additionalPlayerCount")
    def additional_player_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of player slots in a match to keep open for future players.
        """
        return pulumi.get(self, "additional_player_count")

    @additional_player_count.setter
    def additional_player_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "additional_player_count", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        Matchmaking Configuration ARN.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="backfillMode")
    def backfill_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The method used to backfill game sessions that are created with this matchmaking configuration.
        """
        return pulumi.get(self, "backfill_mode")

    @backfill_mode.setter
    def backfill_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backfill_mode", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the Matchmaking Configuration was created.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter(name="customEventData")
    def custom_event_data(self) -> Optional[pulumi.Input[str]]:
        """
        Information to be added to all events related to this matchmaking configuration.
        """
        return pulumi.get(self, "custom_event_data")

    @custom_event_data.setter
    def custom_event_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_event_data", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A human-readable description of the matchmaking configuration.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="flexMatchMode")
    def flex_match_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether this matchmaking configuration is being used with GameLift hosting or as a standalone matchmaking solution.
        """
        return pulumi.get(self, "flex_match_mode")

    @flex_match_mode.setter
    def flex_match_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flex_match_mode", value)

    @property
    @pulumi.getter(name="gameProperties")
    def game_properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MatchmakingConfigurationGamePropertyArgs']]]]:
        """
        One or more custom game properties. See below.
        """
        return pulumi.get(self, "game_properties")

    @game_properties.setter
    def game_properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MatchmakingConfigurationGamePropertyArgs']]]]):
        pulumi.set(self, "game_properties", value)

    @property
    @pulumi.getter(name="gameSessionData")
    def game_session_data(self) -> Optional[pulumi.Input[str]]:
        """
        A set of custom game session properties.
        """
        return pulumi.get(self, "game_session_data")

    @game_session_data.setter
    def game_session_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "game_session_data", value)

    @property
    @pulumi.getter(name="gameSessionQueueArns")
    def game_session_queue_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The ARNs of the GameLift game session queue resources.
        """
        return pulumi.get(self, "game_session_queue_arns")

    @game_session_queue_arns.setter
    def game_session_queue_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "game_session_queue_arns", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the matchmaking configuration
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notificationTarget")
    def notification_target(self) -> Optional[pulumi.Input[str]]:
        """
        An SNS topic ARN that is set up to receive matchmaking notifications.
        """
        return pulumi.get(self, "notification_target")

    @notification_target.setter
    def notification_target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notification_target", value)

    @property
    @pulumi.getter(name="requestTimeoutSeconds")
    def request_timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out.
        """
        return pulumi.get(self, "request_timeout_seconds")

    @request_timeout_seconds.setter
    def request_timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "request_timeout_seconds", value)

    @property
    @pulumi.getter(name="ruleSetArn")
    def rule_set_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "rule_set_arn")

    @rule_set_arn.setter
    def rule_set_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_set_arn", value)

    @property
    @pulumi.getter(name="ruleSetName")
    def rule_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        A rule set names for the matchmaking rule set to use with this configuration.
        """
        return pulumi.get(self, "rule_set_name")

    @rule_set_name.setter
    def rule_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_set_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)


class MatchmakingConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acceptance_required: Optional[pulumi.Input[bool]] = None,
                 acceptance_timeout_seconds: Optional[pulumi.Input[int]] = None,
                 additional_player_count: Optional[pulumi.Input[int]] = None,
                 backfill_mode: Optional[pulumi.Input[str]] = None,
                 custom_event_data: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 flex_match_mode: Optional[pulumi.Input[str]] = None,
                 game_properties: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MatchmakingConfigurationGamePropertyArgs']]]]] = None,
                 game_session_data: Optional[pulumi.Input[str]] = None,
                 game_session_queue_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_target: Optional[pulumi.Input[str]] = None,
                 request_timeout_seconds: Optional[pulumi.Input[int]] = None,
                 rule_set_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides a GameLift Alias resource.

        ## Import

        GameLift Matchmaking Configurations can be imported using the ID, e.g.,

        ```sh
        $ pulumi import aws:gamelift/matchmakingConfiguration:MatchmakingConfiguration example <matchmakingconfiguration-id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] acceptance_required: Specifies if the match that was created with this configuration must be accepted by matched players.
        :param pulumi.Input[int] acceptance_timeout_seconds: The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required.
        :param pulumi.Input[int] additional_player_count: The number of player slots in a match to keep open for future players.
        :param pulumi.Input[str] backfill_mode: The method used to backfill game sessions that are created with this matchmaking configuration.
        :param pulumi.Input[str] custom_event_data: Information to be added to all events related to this matchmaking configuration.
        :param pulumi.Input[str] description: A human-readable description of the matchmaking configuration.
        :param pulumi.Input[str] flex_match_mode: Indicates whether this matchmaking configuration is being used with GameLift hosting or as a standalone matchmaking solution.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MatchmakingConfigurationGamePropertyArgs']]]] game_properties: One or more custom game properties. See below.
        :param pulumi.Input[str] game_session_data: A set of custom game session properties.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] game_session_queue_arns: The ARNs of the GameLift game session queue resources.
        :param pulumi.Input[str] name: Name of the matchmaking configuration
        :param pulumi.Input[str] notification_target: An SNS topic ARN that is set up to receive matchmaking notifications.
        :param pulumi.Input[int] request_timeout_seconds: The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out.
        :param pulumi.Input[str] rule_set_name: A rule set names for the matchmaking rule set to use with this configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MatchmakingConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a GameLift Alias resource.

        ## Import

        GameLift Matchmaking Configurations can be imported using the ID, e.g.,

        ```sh
        $ pulumi import aws:gamelift/matchmakingConfiguration:MatchmakingConfiguration example <matchmakingconfiguration-id>
        ```

        :param str resource_name: The name of the resource.
        :param MatchmakingConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MatchmakingConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acceptance_required: Optional[pulumi.Input[bool]] = None,
                 acceptance_timeout_seconds: Optional[pulumi.Input[int]] = None,
                 additional_player_count: Optional[pulumi.Input[int]] = None,
                 backfill_mode: Optional[pulumi.Input[str]] = None,
                 custom_event_data: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 flex_match_mode: Optional[pulumi.Input[str]] = None,
                 game_properties: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MatchmakingConfigurationGamePropertyArgs']]]]] = None,
                 game_session_data: Optional[pulumi.Input[str]] = None,
                 game_session_queue_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_target: Optional[pulumi.Input[str]] = None,
                 request_timeout_seconds: Optional[pulumi.Input[int]] = None,
                 rule_set_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MatchmakingConfigurationArgs.__new__(MatchmakingConfigurationArgs)

            __props__.__dict__["acceptance_required"] = acceptance_required
            __props__.__dict__["acceptance_timeout_seconds"] = acceptance_timeout_seconds
            __props__.__dict__["additional_player_count"] = additional_player_count
            __props__.__dict__["backfill_mode"] = backfill_mode
            __props__.__dict__["custom_event_data"] = custom_event_data
            __props__.__dict__["description"] = description
            __props__.__dict__["flex_match_mode"] = flex_match_mode
            __props__.__dict__["game_properties"] = game_properties
            __props__.__dict__["game_session_data"] = game_session_data
            __props__.__dict__["game_session_queue_arns"] = game_session_queue_arns
            __props__.__dict__["name"] = name
            __props__.__dict__["notification_target"] = notification_target
            if request_timeout_seconds is None and not opts.urn:
                raise TypeError("Missing required property 'request_timeout_seconds'")
            __props__.__dict__["request_timeout_seconds"] = request_timeout_seconds
            if rule_set_name is None and not opts.urn:
                raise TypeError("Missing required property 'rule_set_name'")
            __props__.__dict__["rule_set_name"] = rule_set_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["rule_set_arn"] = None
            __props__.__dict__["tags_all"] = None
        super(MatchmakingConfiguration, __self__).__init__(
            'aws:gamelift/matchmakingConfiguration:MatchmakingConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acceptance_required: Optional[pulumi.Input[bool]] = None,
            acceptance_timeout_seconds: Optional[pulumi.Input[int]] = None,
            additional_player_count: Optional[pulumi.Input[int]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            backfill_mode: Optional[pulumi.Input[str]] = None,
            creation_time: Optional[pulumi.Input[str]] = None,
            custom_event_data: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            flex_match_mode: Optional[pulumi.Input[str]] = None,
            game_properties: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MatchmakingConfigurationGamePropertyArgs']]]]] = None,
            game_session_data: Optional[pulumi.Input[str]] = None,
            game_session_queue_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            notification_target: Optional[pulumi.Input[str]] = None,
            request_timeout_seconds: Optional[pulumi.Input[int]] = None,
            rule_set_arn: Optional[pulumi.Input[str]] = None,
            rule_set_name: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'MatchmakingConfiguration':
        """
        Get an existing MatchmakingConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] acceptance_required: Specifies if the match that was created with this configuration must be accepted by matched players.
        :param pulumi.Input[int] acceptance_timeout_seconds: The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required.
        :param pulumi.Input[int] additional_player_count: The number of player slots in a match to keep open for future players.
        :param pulumi.Input[str] arn: Matchmaking Configuration ARN.
        :param pulumi.Input[str] backfill_mode: The method used to backfill game sessions that are created with this matchmaking configuration.
        :param pulumi.Input[str] creation_time: The time when the Matchmaking Configuration was created.
        :param pulumi.Input[str] custom_event_data: Information to be added to all events related to this matchmaking configuration.
        :param pulumi.Input[str] description: A human-readable description of the matchmaking configuration.
        :param pulumi.Input[str] flex_match_mode: Indicates whether this matchmaking configuration is being used with GameLift hosting or as a standalone matchmaking solution.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MatchmakingConfigurationGamePropertyArgs']]]] game_properties: One or more custom game properties. See below.
        :param pulumi.Input[str] game_session_data: A set of custom game session properties.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] game_session_queue_arns: The ARNs of the GameLift game session queue resources.
        :param pulumi.Input[str] name: Name of the matchmaking configuration
        :param pulumi.Input[str] notification_target: An SNS topic ARN that is set up to receive matchmaking notifications.
        :param pulumi.Input[int] request_timeout_seconds: The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out.
        :param pulumi.Input[str] rule_set_name: A rule set names for the matchmaking rule set to use with this configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MatchmakingConfigurationState.__new__(_MatchmakingConfigurationState)

        __props__.__dict__["acceptance_required"] = acceptance_required
        __props__.__dict__["acceptance_timeout_seconds"] = acceptance_timeout_seconds
        __props__.__dict__["additional_player_count"] = additional_player_count
        __props__.__dict__["arn"] = arn
        __props__.__dict__["backfill_mode"] = backfill_mode
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["custom_event_data"] = custom_event_data
        __props__.__dict__["description"] = description
        __props__.__dict__["flex_match_mode"] = flex_match_mode
        __props__.__dict__["game_properties"] = game_properties
        __props__.__dict__["game_session_data"] = game_session_data
        __props__.__dict__["game_session_queue_arns"] = game_session_queue_arns
        __props__.__dict__["name"] = name
        __props__.__dict__["notification_target"] = notification_target
        __props__.__dict__["request_timeout_seconds"] = request_timeout_seconds
        __props__.__dict__["rule_set_arn"] = rule_set_arn
        __props__.__dict__["rule_set_name"] = rule_set_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return MatchmakingConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="acceptanceRequired")
    def acceptance_required(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies if the match that was created with this configuration must be accepted by matched players.
        """
        return pulumi.get(self, "acceptance_required")

    @property
    @pulumi.getter(name="acceptanceTimeoutSeconds")
    def acceptance_timeout_seconds(self) -> pulumi.Output[Optional[int]]:
        """
        The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required.
        """
        return pulumi.get(self, "acceptance_timeout_seconds")

    @property
    @pulumi.getter(name="additionalPlayerCount")
    def additional_player_count(self) -> pulumi.Output[Optional[int]]:
        """
        The number of player slots in a match to keep open for future players.
        """
        return pulumi.get(self, "additional_player_count")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        Matchmaking Configuration ARN.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="backfillMode")
    def backfill_mode(self) -> pulumi.Output[Optional[str]]:
        """
        The method used to backfill game sessions that are created with this matchmaking configuration.
        """
        return pulumi.get(self, "backfill_mode")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[str]:
        """
        The time when the Matchmaking Configuration was created.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="customEventData")
    def custom_event_data(self) -> pulumi.Output[Optional[str]]:
        """
        Information to be added to all events related to this matchmaking configuration.
        """
        return pulumi.get(self, "custom_event_data")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A human-readable description of the matchmaking configuration.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="flexMatchMode")
    def flex_match_mode(self) -> pulumi.Output[str]:
        """
        Indicates whether this matchmaking configuration is being used with GameLift hosting or as a standalone matchmaking solution.
        """
        return pulumi.get(self, "flex_match_mode")

    @property
    @pulumi.getter(name="gameProperties")
    def game_properties(self) -> pulumi.Output[Optional[Sequence['outputs.MatchmakingConfigurationGameProperty']]]:
        """
        One or more custom game properties. See below.
        """
        return pulumi.get(self, "game_properties")

    @property
    @pulumi.getter(name="gameSessionData")
    def game_session_data(self) -> pulumi.Output[Optional[str]]:
        """
        A set of custom game session properties.
        """
        return pulumi.get(self, "game_session_data")

    @property
    @pulumi.getter(name="gameSessionQueueArns")
    def game_session_queue_arns(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The ARNs of the GameLift game session queue resources.
        """
        return pulumi.get(self, "game_session_queue_arns")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the matchmaking configuration
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notificationTarget")
    def notification_target(self) -> pulumi.Output[Optional[str]]:
        """
        An SNS topic ARN that is set up to receive matchmaking notifications.
        """
        return pulumi.get(self, "notification_target")

    @property
    @pulumi.getter(name="requestTimeoutSeconds")
    def request_timeout_seconds(self) -> pulumi.Output[int]:
        """
        The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out.
        """
        return pulumi.get(self, "request_timeout_seconds")

    @property
    @pulumi.getter(name="ruleSetArn")
    def rule_set_arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "rule_set_arn")

    @property
    @pulumi.getter(name="ruleSetName")
    def rule_set_name(self) -> pulumi.Output[str]:
        """
        A rule set names for the matchmaking rule set to use with this configuration.
        """
        return pulumi.get(self, "rule_set_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

