# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetAccessKeysResult',
    'AwaitableGetAccessKeysResult',
    'get_access_keys',
    'get_access_keys_output',
]

@pulumi.output_type
class GetAccessKeysResult:
    """
    A collection of values returned by getAccessKeys.
    """
    def __init__(__self__, access_keys=None, id=None, user=None):
        if access_keys and not isinstance(access_keys, list):
            raise TypeError("Expected argument 'access_keys' to be a list")
        pulumi.set(__self__, "access_keys", access_keys)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if user and not isinstance(user, str):
            raise TypeError("Expected argument 'user' to be a str")
        pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter(name="accessKeys")
    def access_keys(self) -> Sequence['outputs.GetAccessKeysAccessKeyResult']:
        """
        List of the IAM access keys associated with the specified user. See below.
        """
        return pulumi.get(self, "access_keys")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def user(self) -> str:
        return pulumi.get(self, "user")


class AwaitableGetAccessKeysResult(GetAccessKeysResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccessKeysResult(
            access_keys=self.access_keys,
            id=self.id,
            user=self.user)


def get_access_keys(user: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccessKeysResult:
    """
    This data source can be used to fetch information about IAM access keys of a
    specific IAM user.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.iam.get_access_keys(user="an_example_user_name")
    ```
    <!--End PulumiCodeChooser -->


    :param str user: Name of the IAM user associated with the access keys.
    """
    __args__ = dict()
    __args__['user'] = user
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:iam/getAccessKeys:getAccessKeys', __args__, opts=opts, typ=GetAccessKeysResult).value

    return AwaitableGetAccessKeysResult(
        access_keys=pulumi.get(__ret__, 'access_keys'),
        id=pulumi.get(__ret__, 'id'),
        user=pulumi.get(__ret__, 'user'))


@_utilities.lift_output_func(get_access_keys)
def get_access_keys_output(user: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAccessKeysResult]:
    """
    This data source can be used to fetch information about IAM access keys of a
    specific IAM user.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.iam.get_access_keys(user="an_example_user_name")
    ```
    <!--End PulumiCodeChooser -->


    :param str user: Name of the IAM user associated with the access keys.
    """
    ...
