# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetPolicyResult',
    'AwaitableGetPolicyResult',
    'get_policy',
    'get_policy_output',
]

@pulumi.output_type
class GetPolicyResult:
    """
    A collection of values returned by getPolicy.
    """
    def __init__(__self__, arn=None, description=None, id=None, name=None, path=None, path_prefix=None, policy=None, policy_id=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if path and not isinstance(path, str):
            raise TypeError("Expected argument 'path' to be a str")
        pulumi.set(__self__, "path", path)
        if path_prefix and not isinstance(path_prefix, str):
            raise TypeError("Expected argument 'path_prefix' to be a str")
        pulumi.set(__self__, "path_prefix", path_prefix)
        if policy and not isinstance(policy, str):
            raise TypeError("Expected argument 'policy' to be a str")
        pulumi.set(__self__, "policy", policy)
        if policy_id and not isinstance(policy_id, str):
            raise TypeError("Expected argument 'policy_id' to be a str")
        pulumi.set(__self__, "policy_id", policy_id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        ARN of the policy.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Path to the policy.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="pathPrefix")
    def path_prefix(self) -> Optional[str]:
        return pulumi.get(self, "path_prefix")

    @property
    @pulumi.getter
    def policy(self) -> str:
        """
        Policy document of the policy.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> str:
        """
        Policy's ID.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        Key-value mapping of tags for the IAM Policy.
        """
        return pulumi.get(self, "tags")


class AwaitableGetPolicyResult(GetPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPolicyResult(
            arn=self.arn,
            description=self.description,
            id=self.id,
            name=self.name,
            path=self.path,
            path_prefix=self.path_prefix,
            policy=self.policy,
            policy_id=self.policy_id,
            tags=self.tags)


def get_policy(arn: Optional[str] = None,
               name: Optional[str] = None,
               path_prefix: Optional[str] = None,
               tags: Optional[Mapping[str, str]] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPolicyResult:
    """
    This data source can be used to fetch information about a specific
    IAM policy.

    ## Example Usage

    ### By ARN

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.iam.get_policy(arn="arn:aws:iam::123456789012:policy/UsersManageOwnCredentials")
    ```
    <!--End PulumiCodeChooser -->

    ### By Name

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.iam.get_policy(name="test_policy")
    ```
    <!--End PulumiCodeChooser -->


    :param str arn: ARN of the IAM policy.
           Conflicts with `name` and `path_prefix`.
    :param str name: Name of the IAM policy.
           Conflicts with `arn`.
    :param str path_prefix: Prefix of the path to the IAM policy.
           Defaults to a slash (`/`).
           Conflicts with `arn`.
    :param Mapping[str, str] tags: Key-value mapping of tags for the IAM Policy.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['name'] = name
    __args__['pathPrefix'] = path_prefix
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:iam/getPolicy:getPolicy', __args__, opts=opts, typ=GetPolicyResult).value

    return AwaitableGetPolicyResult(
        arn=pulumi.get(__ret__, 'arn'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        path=pulumi.get(__ret__, 'path'),
        path_prefix=pulumi.get(__ret__, 'path_prefix'),
        policy=pulumi.get(__ret__, 'policy'),
        policy_id=pulumi.get(__ret__, 'policy_id'),
        tags=pulumi.get(__ret__, 'tags'))


@_utilities.lift_output_func(get_policy)
def get_policy_output(arn: Optional[pulumi.Input[Optional[str]]] = None,
                      name: Optional[pulumi.Input[Optional[str]]] = None,
                      path_prefix: Optional[pulumi.Input[Optional[str]]] = None,
                      tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPolicyResult]:
    """
    This data source can be used to fetch information about a specific
    IAM policy.

    ## Example Usage

    ### By ARN

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.iam.get_policy(arn="arn:aws:iam::123456789012:policy/UsersManageOwnCredentials")
    ```
    <!--End PulumiCodeChooser -->

    ### By Name

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.iam.get_policy(name="test_policy")
    ```
    <!--End PulumiCodeChooser -->


    :param str arn: ARN of the IAM policy.
           Conflicts with `name` and `path_prefix`.
    :param str name: Name of the IAM policy.
           Conflicts with `arn`.
    :param str path_prefix: Prefix of the path to the IAM policy.
           Defaults to a slash (`/`).
           Conflicts with `arn`.
    :param Mapping[str, str] tags: Key-value mapping of tags for the IAM Policy.
    """
    ...
