# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['GroupPolicyAttachmentArgs', 'GroupPolicyAttachment']

@pulumi.input_type
class GroupPolicyAttachmentArgs:
    def __init__(__self__, *,
                 group: pulumi.Input[str],
                 policy_arn: pulumi.Input[str]):
        """
        The set of arguments for constructing a GroupPolicyAttachment resource.
        :param pulumi.Input[str] group: The group the policy should be applied to
        :param pulumi.Input[str] policy_arn: The ARN of the policy you want to apply
        """
        pulumi.set(__self__, "group", group)
        pulumi.set(__self__, "policy_arn", policy_arn)

    @property
    @pulumi.getter
    def group(self) -> pulumi.Input[str]:
        """
        The group the policy should be applied to
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: pulumi.Input[str]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter(name="policyArn")
    def policy_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the policy you want to apply
        """
        return pulumi.get(self, "policy_arn")

    @policy_arn.setter
    def policy_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy_arn", value)


@pulumi.input_type
class _GroupPolicyAttachmentState:
    def __init__(__self__, *,
                 group: Optional[pulumi.Input[str]] = None,
                 policy_arn: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering GroupPolicyAttachment resources.
        :param pulumi.Input[str] group: The group the policy should be applied to
        :param pulumi.Input[str] policy_arn: The ARN of the policy you want to apply
        """
        if group is not None:
            pulumi.set(__self__, "group", group)
        if policy_arn is not None:
            pulumi.set(__self__, "policy_arn", policy_arn)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[str]]:
        """
        The group the policy should be applied to
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter(name="policyArn")
    def policy_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the policy you want to apply
        """
        return pulumi.get(self, "policy_arn")

    @policy_arn.setter
    def policy_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_arn", value)


class GroupPolicyAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group: Optional[pulumi.Input[str]] = None,
                 policy_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Attaches a Managed IAM Policy to an IAM group

        > **NOTE:** The usage of this resource conflicts with the `iam.PolicyAttachment` resource and will permanently show a difference if both are defined.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        group = aws.iam.Group("group", name="test-group")
        policy = aws.iam.Policy("policy",
            name="test-policy",
            description="A test policy",
            policy="{ ... policy JSON ... }")
        test_attach = aws.iam.GroupPolicyAttachment("test-attach",
            group=group.name,
            policy_arn=policy.arn)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import IAM group policy attachments using the group name and policy arn separated by `/`. For example:

        ```sh
        $ pulumi import aws:iam/groupPolicyAttachment:GroupPolicyAttachment test-attach test-group/arn:aws:iam::xxxxxxxxxxxx:policy/test-policy
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] group: The group the policy should be applied to
        :param pulumi.Input[str] policy_arn: The ARN of the policy you want to apply
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GroupPolicyAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Attaches a Managed IAM Policy to an IAM group

        > **NOTE:** The usage of this resource conflicts with the `iam.PolicyAttachment` resource and will permanently show a difference if both are defined.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        group = aws.iam.Group("group", name="test-group")
        policy = aws.iam.Policy("policy",
            name="test-policy",
            description="A test policy",
            policy="{ ... policy JSON ... }")
        test_attach = aws.iam.GroupPolicyAttachment("test-attach",
            group=group.name,
            policy_arn=policy.arn)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import IAM group policy attachments using the group name and policy arn separated by `/`. For example:

        ```sh
        $ pulumi import aws:iam/groupPolicyAttachment:GroupPolicyAttachment test-attach test-group/arn:aws:iam::xxxxxxxxxxxx:policy/test-policy
        ```

        :param str resource_name: The name of the resource.
        :param GroupPolicyAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupPolicyAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group: Optional[pulumi.Input[str]] = None,
                 policy_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupPolicyAttachmentArgs.__new__(GroupPolicyAttachmentArgs)

            if group is None and not opts.urn:
                raise TypeError("Missing required property 'group'")
            __props__.__dict__["group"] = group
            if policy_arn is None and not opts.urn:
                raise TypeError("Missing required property 'policy_arn'")
            __props__.__dict__["policy_arn"] = policy_arn
        super(GroupPolicyAttachment, __self__).__init__(
            'aws:iam/groupPolicyAttachment:GroupPolicyAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            group: Optional[pulumi.Input[str]] = None,
            policy_arn: Optional[pulumi.Input[str]] = None) -> 'GroupPolicyAttachment':
        """
        Get an existing GroupPolicyAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] group: The group the policy should be applied to
        :param pulumi.Input[str] policy_arn: The ARN of the policy you want to apply
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GroupPolicyAttachmentState.__new__(_GroupPolicyAttachmentState)

        __props__.__dict__["group"] = group
        __props__.__dict__["policy_arn"] = policy_arn
        return GroupPolicyAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def group(self) -> pulumi.Output[str]:
        """
        The group the policy should be applied to
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter(name="policyArn")
    def policy_arn(self) -> pulumi.Output[str]:
        """
        The ARN of the policy you want to apply
        """
        return pulumi.get(self, "policy_arn")

