# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetGroupResult',
    'AwaitableGetGroupResult',
    'get_group',
    'get_group_output',
]

@pulumi.output_type
class GetGroupResult:
    """
    A collection of values returned by getGroup.
    """
    def __init__(__self__, alternate_identifier=None, description=None, display_name=None, external_ids=None, filter=None, group_id=None, id=None, identity_store_id=None):
        if alternate_identifier and not isinstance(alternate_identifier, dict):
            raise TypeError("Expected argument 'alternate_identifier' to be a dict")
        pulumi.set(__self__, "alternate_identifier", alternate_identifier)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if external_ids and not isinstance(external_ids, list):
            raise TypeError("Expected argument 'external_ids' to be a list")
        pulumi.set(__self__, "external_ids", external_ids)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if group_id and not isinstance(group_id, str):
            raise TypeError("Expected argument 'group_id' to be a str")
        pulumi.set(__self__, "group_id", group_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identity_store_id and not isinstance(identity_store_id, str):
            raise TypeError("Expected argument 'identity_store_id' to be a str")
        pulumi.set(__self__, "identity_store_id", identity_store_id)

    @property
    @pulumi.getter(name="alternateIdentifier")
    def alternate_identifier(self) -> Optional['outputs.GetGroupAlternateIdentifierResult']:
        return pulumi.get(self, "alternate_identifier")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the specified group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Group's display name value.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="externalIds")
    def external_ids(self) -> Sequence['outputs.GetGroupExternalIdResult']:
        """
        List of identifiers issued to this resource by an external identity provider.
        """
        return pulumi.get(self, "external_ids")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetGroupFilterResult']:
        warnings.warn("""Use the alternate_identifier attribute instead.""", DeprecationWarning)
        pulumi.log.warn("""filter is deprecated: Use the alternate_identifier attribute instead.""")

        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> str:
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="identityStoreId")
    def identity_store_id(self) -> str:
        return pulumi.get(self, "identity_store_id")


class AwaitableGetGroupResult(GetGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGroupResult(
            alternate_identifier=self.alternate_identifier,
            description=self.description,
            display_name=self.display_name,
            external_ids=self.external_ids,
            filter=self.filter,
            group_id=self.group_id,
            id=self.id,
            identity_store_id=self.identity_store_id)


def get_group(alternate_identifier: Optional[pulumi.InputType['GetGroupAlternateIdentifierArgs']] = None,
              filter: Optional[pulumi.InputType['GetGroupFilterArgs']] = None,
              group_id: Optional[str] = None,
              identity_store_id: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGroupResult:
    """
    Use this data source to get an Identity Store Group.


    :param pulumi.InputType['GetGroupAlternateIdentifierArgs'] alternate_identifier: A unique identifier for the group that is not the primary identifier. Conflicts with `group_id` and `filter`. Detailed below.
    :param pulumi.InputType['GetGroupFilterArgs'] filter: Configuration block for filtering by a unique attribute of the group. Detailed below.
    :param str group_id: The identifier for a group in the Identity Store.
           
           > Exactly one of the above arguments must be provided. Passing both `filter` and `group_id` is allowed for backwards compatibility.
    :param str identity_store_id: Identity Store ID associated with the Single Sign-On Instance.
           
           The following arguments are optional:
    """
    __args__ = dict()
    __args__['alternateIdentifier'] = alternate_identifier
    __args__['filter'] = filter
    __args__['groupId'] = group_id
    __args__['identityStoreId'] = identity_store_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:identitystore/getGroup:getGroup', __args__, opts=opts, typ=GetGroupResult).value

    return AwaitableGetGroupResult(
        alternate_identifier=pulumi.get(__ret__, 'alternate_identifier'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        external_ids=pulumi.get(__ret__, 'external_ids'),
        filter=pulumi.get(__ret__, 'filter'),
        group_id=pulumi.get(__ret__, 'group_id'),
        id=pulumi.get(__ret__, 'id'),
        identity_store_id=pulumi.get(__ret__, 'identity_store_id'))


@_utilities.lift_output_func(get_group)
def get_group_output(alternate_identifier: Optional[pulumi.Input[Optional[pulumi.InputType['GetGroupAlternateIdentifierArgs']]]] = None,
                     filter: Optional[pulumi.Input[Optional[pulumi.InputType['GetGroupFilterArgs']]]] = None,
                     group_id: Optional[pulumi.Input[Optional[str]]] = None,
                     identity_store_id: Optional[pulumi.Input[str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetGroupResult]:
    """
    Use this data source to get an Identity Store Group.


    :param pulumi.InputType['GetGroupAlternateIdentifierArgs'] alternate_identifier: A unique identifier for the group that is not the primary identifier. Conflicts with `group_id` and `filter`. Detailed below.
    :param pulumi.InputType['GetGroupFilterArgs'] filter: Configuration block for filtering by a unique attribute of the group. Detailed below.
    :param str group_id: The identifier for a group in the Identity Store.
           
           > Exactly one of the above arguments must be provided. Passing both `filter` and `group_id` is allowed for backwards compatibility.
    :param str identity_store_id: Identity Store ID associated with the Single Sign-On Instance.
           
           The following arguments are optional:
    """
    ...
