# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ContainerRecipeComponentArgs',
    'ContainerRecipeComponentParameterArgs',
    'ContainerRecipeInstanceConfigurationArgs',
    'ContainerRecipeInstanceConfigurationBlockDeviceMappingArgs',
    'ContainerRecipeInstanceConfigurationBlockDeviceMappingEbsArgs',
    'ContainerRecipeTargetRepositoryArgs',
    'DistributionConfigurationDistributionArgs',
    'DistributionConfigurationDistributionAmiDistributionConfigurationArgs',
    'DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionArgs',
    'DistributionConfigurationDistributionContainerDistributionConfigurationArgs',
    'DistributionConfigurationDistributionContainerDistributionConfigurationTargetRepositoryArgs',
    'DistributionConfigurationDistributionFastLaunchConfigurationArgs',
    'DistributionConfigurationDistributionFastLaunchConfigurationLaunchTemplateArgs',
    'DistributionConfigurationDistributionFastLaunchConfigurationSnapshotConfigurationArgs',
    'DistributionConfigurationDistributionLaunchTemplateConfigurationArgs',
    'ImageImageScanningConfigurationArgs',
    'ImageImageScanningConfigurationEcrConfigurationArgs',
    'ImageImageTestsConfigurationArgs',
    'ImageOutputResourceArgs',
    'ImageOutputResourceAmiArgs',
    'ImageOutputResourceContainerArgs',
    'ImagePipelineImageScanningConfigurationArgs',
    'ImagePipelineImageScanningConfigurationEcrConfigurationArgs',
    'ImagePipelineImageTestsConfigurationArgs',
    'ImagePipelineScheduleArgs',
    'ImageRecipeBlockDeviceMappingArgs',
    'ImageRecipeBlockDeviceMappingEbsArgs',
    'ImageRecipeComponentArgs',
    'ImageRecipeComponentParameterArgs',
    'ImageRecipeSystemsManagerAgentArgs',
    'InfrastructureConfigurationInstanceMetadataOptionsArgs',
    'InfrastructureConfigurationLoggingArgs',
    'InfrastructureConfigurationLoggingS3LogsArgs',
    'GetComponentsFilterArgs',
    'GetContainerRecipesFilterArgs',
    'GetDistributionConfigurationsFilterArgs',
    'GetImagePipelinesFilterArgs',
    'GetImageRecipesFilterArgs',
    'GetInfrastructureConfigurationsFilterArgs',
]

@pulumi.input_type
class ContainerRecipeComponentArgs:
    def __init__(__self__, *,
                 component_arn: pulumi.Input[str],
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRecipeComponentParameterArgs']]]] = None):
        """
        :param pulumi.Input[str] component_arn: Amazon Resource Name (ARN) of the Image Builder Component to associate.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerRecipeComponentParameterArgs']]] parameters: Configuration block(s) for parameters to configure the component. Detailed below.
        """
        pulumi.set(__self__, "component_arn", component_arn)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="componentArn")
    def component_arn(self) -> pulumi.Input[str]:
        """
        Amazon Resource Name (ARN) of the Image Builder Component to associate.
        """
        return pulumi.get(self, "component_arn")

    @component_arn.setter
    def component_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "component_arn", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRecipeComponentParameterArgs']]]]:
        """
        Configuration block(s) for parameters to configure the component. Detailed below.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRecipeComponentParameterArgs']]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class ContainerRecipeComponentParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: The name of the component parameter.
        :param pulumi.Input[str] value: The value for the named component parameter.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the component parameter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value for the named component parameter.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ContainerRecipeInstanceConfigurationArgs:
    def __init__(__self__, *,
                 block_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRecipeInstanceConfigurationBlockDeviceMappingArgs']]]] = None,
                 image: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ContainerRecipeInstanceConfigurationBlockDeviceMappingArgs']]] block_device_mappings: Configuration block(s) with block device mappings for the container recipe. Detailed below.
        :param pulumi.Input[str] image: The AMI ID to use as the base image for a container build and test instance. If not specified, Image Builder will use the appropriate ECS-optimized AMI as a base image.
        """
        if block_device_mappings is not None:
            pulumi.set(__self__, "block_device_mappings", block_device_mappings)
        if image is not None:
            pulumi.set(__self__, "image", image)

    @property
    @pulumi.getter(name="blockDeviceMappings")
    def block_device_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRecipeInstanceConfigurationBlockDeviceMappingArgs']]]]:
        """
        Configuration block(s) with block device mappings for the container recipe. Detailed below.
        """
        return pulumi.get(self, "block_device_mappings")

    @block_device_mappings.setter
    def block_device_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRecipeInstanceConfigurationBlockDeviceMappingArgs']]]]):
        pulumi.set(self, "block_device_mappings", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        The AMI ID to use as the base image for a container build and test instance. If not specified, Image Builder will use the appropriate ECS-optimized AMI as a base image.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)


@pulumi.input_type
class ContainerRecipeInstanceConfigurationBlockDeviceMappingArgs:
    def __init__(__self__, *,
                 device_name: Optional[pulumi.Input[str]] = None,
                 ebs: Optional[pulumi.Input['ContainerRecipeInstanceConfigurationBlockDeviceMappingEbsArgs']] = None,
                 no_device: Optional[pulumi.Input[bool]] = None,
                 virtual_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] device_name: Name of the device. For example, `/dev/sda` or `/dev/xvdb`.
        :param pulumi.Input['ContainerRecipeInstanceConfigurationBlockDeviceMappingEbsArgs'] ebs: Configuration block with Elastic Block Storage (EBS) block device mapping settings. Detailed below.
        :param pulumi.Input[bool] no_device: Set to `true` to remove a mapping from the parent image.
        :param pulumi.Input[str] virtual_name: Virtual device name. For example, `ephemeral0`. Instance store volumes are numbered starting from 0.
        """
        if device_name is not None:
            pulumi.set(__self__, "device_name", device_name)
        if ebs is not None:
            pulumi.set(__self__, "ebs", ebs)
        if no_device is not None:
            pulumi.set(__self__, "no_device", no_device)
        if virtual_name is not None:
            pulumi.set(__self__, "virtual_name", virtual_name)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the device. For example, `/dev/sda` or `/dev/xvdb`.
        """
        return pulumi.get(self, "device_name")

    @device_name.setter
    def device_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_name", value)

    @property
    @pulumi.getter
    def ebs(self) -> Optional[pulumi.Input['ContainerRecipeInstanceConfigurationBlockDeviceMappingEbsArgs']]:
        """
        Configuration block with Elastic Block Storage (EBS) block device mapping settings. Detailed below.
        """
        return pulumi.get(self, "ebs")

    @ebs.setter
    def ebs(self, value: Optional[pulumi.Input['ContainerRecipeInstanceConfigurationBlockDeviceMappingEbsArgs']]):
        pulumi.set(self, "ebs", value)

    @property
    @pulumi.getter(name="noDevice")
    def no_device(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to remove a mapping from the parent image.
        """
        return pulumi.get(self, "no_device")

    @no_device.setter
    def no_device(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_device", value)

    @property
    @pulumi.getter(name="virtualName")
    def virtual_name(self) -> Optional[pulumi.Input[str]]:
        """
        Virtual device name. For example, `ephemeral0`. Instance store volumes are numbered starting from 0.
        """
        return pulumi.get(self, "virtual_name")

    @virtual_name.setter
    def virtual_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_name", value)


@pulumi.input_type
class ContainerRecipeInstanceConfigurationBlockDeviceMappingEbsArgs:
    def __init__(__self__, *,
                 delete_on_termination: Optional[pulumi.Input[str]] = None,
                 encrypted: Optional[pulumi.Input[str]] = None,
                 iops: Optional[pulumi.Input[int]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 snapshot_id: Optional[pulumi.Input[str]] = None,
                 throughput: Optional[pulumi.Input[int]] = None,
                 volume_size: Optional[pulumi.Input[int]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] delete_on_termination: Whether to delete the volume on termination. Defaults to unset, which is the value inherited from the parent image.
        :param pulumi.Input[str] encrypted: Whether to encrypt the volume. Defaults to unset, which is the value inherited from the parent image.
        :param pulumi.Input[int] iops: Number of Input/Output (I/O) operations per second to provision for an `io1` or `io2` volume.
        :param pulumi.Input[str] kms_key_id: Amazon Resource Name (ARN) of the Key Management Service (KMS) Key for encryption.
        :param pulumi.Input[str] snapshot_id: Identifier of the EC2 Volume Snapshot.
        :param pulumi.Input[int] throughput: For GP3 volumes only. The throughput in MiB/s that the volume supports.
        :param pulumi.Input[int] volume_size: Size of the volume, in GiB.
        :param pulumi.Input[str] volume_type: Type of the volume. For example, `gp2` or `io2`.
        """
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to delete the volume on termination. Defaults to unset, which is the value inherited from the parent image.
        """
        return pulumi.get(self, "delete_on_termination")

    @delete_on_termination.setter
    def delete_on_termination(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delete_on_termination", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to encrypt the volume. Defaults to unset, which is the value inherited from the parent image.
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        Number of Input/Output (I/O) operations per second to provision for an `io1` or `io2` volume.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of the Key Management Service (KMS) Key for encryption.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the EC2 Volume Snapshot.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_id", value)

    @property
    @pulumi.getter
    def throughput(self) -> Optional[pulumi.Input[int]]:
        """
        For GP3 volumes only. The throughput in MiB/s that the volume supports.
        """
        return pulumi.get(self, "throughput")

    @throughput.setter
    def throughput(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "throughput", value)

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the volume, in GiB.
        """
        return pulumi.get(self, "volume_size")

    @volume_size.setter
    def volume_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "volume_size", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the volume. For example, `gp2` or `io2`.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_type", value)


@pulumi.input_type
class ContainerRecipeTargetRepositoryArgs:
    def __init__(__self__, *,
                 repository_name: pulumi.Input[str],
                 service: pulumi.Input[str]):
        """
        :param pulumi.Input[str] repository_name: The name of the container repository where the output container image is stored. This name is prefixed by the repository location.
        :param pulumi.Input[str] service: The service in which this image is registered. Valid values: `ECR`.
        """
        pulumi.set(__self__, "repository_name", repository_name)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> pulumi.Input[str]:
        """
        The name of the container repository where the output container image is stored. This name is prefixed by the repository location.
        """
        return pulumi.get(self, "repository_name")

    @repository_name.setter
    def repository_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "repository_name", value)

    @property
    @pulumi.getter
    def service(self) -> pulumi.Input[str]:
        """
        The service in which this image is registered. Valid values: `ECR`.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[str]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class DistributionConfigurationDistributionArgs:
    def __init__(__self__, *,
                 region: pulumi.Input[str],
                 ami_distribution_configuration: Optional[pulumi.Input['DistributionConfigurationDistributionAmiDistributionConfigurationArgs']] = None,
                 container_distribution_configuration: Optional[pulumi.Input['DistributionConfigurationDistributionContainerDistributionConfigurationArgs']] = None,
                 fast_launch_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionConfigurationDistributionFastLaunchConfigurationArgs']]]] = None,
                 launch_template_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionConfigurationDistributionLaunchTemplateConfigurationArgs']]]] = None,
                 license_configuration_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] region: AWS Region for the distribution.
               
               The following arguments are optional:
        :param pulumi.Input['DistributionConfigurationDistributionAmiDistributionConfigurationArgs'] ami_distribution_configuration: Configuration block with Amazon Machine Image (AMI) distribution settings. Detailed below.
        :param pulumi.Input['DistributionConfigurationDistributionContainerDistributionConfigurationArgs'] container_distribution_configuration: Configuration block with container distribution settings. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input['DistributionConfigurationDistributionFastLaunchConfigurationArgs']]] fast_launch_configurations: Set of Windows faster-launching configurations to use for AMI distribution. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input['DistributionConfigurationDistributionLaunchTemplateConfigurationArgs']]] launch_template_configurations: Set of launch template configuration settings that apply to image distribution. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] license_configuration_arns: Set of Amazon Resource Names (ARNs) of License Manager License Configurations.
        """
        pulumi.set(__self__, "region", region)
        if ami_distribution_configuration is not None:
            pulumi.set(__self__, "ami_distribution_configuration", ami_distribution_configuration)
        if container_distribution_configuration is not None:
            pulumi.set(__self__, "container_distribution_configuration", container_distribution_configuration)
        if fast_launch_configurations is not None:
            pulumi.set(__self__, "fast_launch_configurations", fast_launch_configurations)
        if launch_template_configurations is not None:
            pulumi.set(__self__, "launch_template_configurations", launch_template_configurations)
        if license_configuration_arns is not None:
            pulumi.set(__self__, "license_configuration_arns", license_configuration_arns)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        AWS Region for the distribution.

        The following arguments are optional:
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="amiDistributionConfiguration")
    def ami_distribution_configuration(self) -> Optional[pulumi.Input['DistributionConfigurationDistributionAmiDistributionConfigurationArgs']]:
        """
        Configuration block with Amazon Machine Image (AMI) distribution settings. Detailed below.
        """
        return pulumi.get(self, "ami_distribution_configuration")

    @ami_distribution_configuration.setter
    def ami_distribution_configuration(self, value: Optional[pulumi.Input['DistributionConfigurationDistributionAmiDistributionConfigurationArgs']]):
        pulumi.set(self, "ami_distribution_configuration", value)

    @property
    @pulumi.getter(name="containerDistributionConfiguration")
    def container_distribution_configuration(self) -> Optional[pulumi.Input['DistributionConfigurationDistributionContainerDistributionConfigurationArgs']]:
        """
        Configuration block with container distribution settings. Detailed below.
        """
        return pulumi.get(self, "container_distribution_configuration")

    @container_distribution_configuration.setter
    def container_distribution_configuration(self, value: Optional[pulumi.Input['DistributionConfigurationDistributionContainerDistributionConfigurationArgs']]):
        pulumi.set(self, "container_distribution_configuration", value)

    @property
    @pulumi.getter(name="fastLaunchConfigurations")
    def fast_launch_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionConfigurationDistributionFastLaunchConfigurationArgs']]]]:
        """
        Set of Windows faster-launching configurations to use for AMI distribution. Detailed below.
        """
        return pulumi.get(self, "fast_launch_configurations")

    @fast_launch_configurations.setter
    def fast_launch_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionConfigurationDistributionFastLaunchConfigurationArgs']]]]):
        pulumi.set(self, "fast_launch_configurations", value)

    @property
    @pulumi.getter(name="launchTemplateConfigurations")
    def launch_template_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionConfigurationDistributionLaunchTemplateConfigurationArgs']]]]:
        """
        Set of launch template configuration settings that apply to image distribution. Detailed below.
        """
        return pulumi.get(self, "launch_template_configurations")

    @launch_template_configurations.setter
    def launch_template_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionConfigurationDistributionLaunchTemplateConfigurationArgs']]]]):
        pulumi.set(self, "launch_template_configurations", value)

    @property
    @pulumi.getter(name="licenseConfigurationArns")
    def license_configuration_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of Amazon Resource Names (ARNs) of License Manager License Configurations.
        """
        return pulumi.get(self, "license_configuration_arns")

    @license_configuration_arns.setter
    def license_configuration_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "license_configuration_arns", value)


@pulumi.input_type
class DistributionConfigurationDistributionAmiDistributionConfigurationArgs:
    def __init__(__self__, *,
                 ami_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 launch_permission: Optional[pulumi.Input['DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 target_account_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] ami_tags: Key-value map of tags to apply to the distributed AMI.
        :param pulumi.Input[str] description: Description to apply to the distributed AMI.
        :param pulumi.Input[str] kms_key_id: Amazon Resource Name (ARN) of the Key Management Service (KMS) Key to encrypt the distributed AMI.
        :param pulumi.Input['DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionArgs'] launch_permission: Configuration block of EC2 launch permissions to apply to the distributed AMI. Detailed below.
        :param pulumi.Input[str] name: Name to apply to the distributed AMI.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_account_ids: Set of AWS Account identifiers to distribute the AMI.
        """
        if ami_tags is not None:
            pulumi.set(__self__, "ami_tags", ami_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if launch_permission is not None:
            pulumi.set(__self__, "launch_permission", launch_permission)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if target_account_ids is not None:
            pulumi.set(__self__, "target_account_ids", target_account_ids)

    @property
    @pulumi.getter(name="amiTags")
    def ami_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of tags to apply to the distributed AMI.
        """
        return pulumi.get(self, "ami_tags")

    @ami_tags.setter
    def ami_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "ami_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description to apply to the distributed AMI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of the Key Management Service (KMS) Key to encrypt the distributed AMI.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="launchPermission")
    def launch_permission(self) -> Optional[pulumi.Input['DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionArgs']]:
        """
        Configuration block of EC2 launch permissions to apply to the distributed AMI. Detailed below.
        """
        return pulumi.get(self, "launch_permission")

    @launch_permission.setter
    def launch_permission(self, value: Optional[pulumi.Input['DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionArgs']]):
        pulumi.set(self, "launch_permission", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name to apply to the distributed AMI.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="targetAccountIds")
    def target_account_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of AWS Account identifiers to distribute the AMI.
        """
        return pulumi.get(self, "target_account_ids")

    @target_account_ids.setter
    def target_account_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "target_account_ids", value)


@pulumi.input_type
class DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionArgs:
    def __init__(__self__, *,
                 organization_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 organizational_unit_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] organization_arns: Set of AWS Organization ARNs to assign.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] organizational_unit_arns: Set of AWS Organizational Unit ARNs to assign.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_groups: Set of EC2 launch permission user groups to assign. Use `all` to distribute a public AMI.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_ids: Set of AWS Account identifiers to assign.
        """
        if organization_arns is not None:
            pulumi.set(__self__, "organization_arns", organization_arns)
        if organizational_unit_arns is not None:
            pulumi.set(__self__, "organizational_unit_arns", organizational_unit_arns)
        if user_groups is not None:
            pulumi.set(__self__, "user_groups", user_groups)
        if user_ids is not None:
            pulumi.set(__self__, "user_ids", user_ids)

    @property
    @pulumi.getter(name="organizationArns")
    def organization_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of AWS Organization ARNs to assign.
        """
        return pulumi.get(self, "organization_arns")

    @organization_arns.setter
    def organization_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "organization_arns", value)

    @property
    @pulumi.getter(name="organizationalUnitArns")
    def organizational_unit_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of AWS Organizational Unit ARNs to assign.
        """
        return pulumi.get(self, "organizational_unit_arns")

    @organizational_unit_arns.setter
    def organizational_unit_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "organizational_unit_arns", value)

    @property
    @pulumi.getter(name="userGroups")
    def user_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of EC2 launch permission user groups to assign. Use `all` to distribute a public AMI.
        """
        return pulumi.get(self, "user_groups")

    @user_groups.setter
    def user_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "user_groups", value)

    @property
    @pulumi.getter(name="userIds")
    def user_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of AWS Account identifiers to assign.
        """
        return pulumi.get(self, "user_ids")

    @user_ids.setter
    def user_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "user_ids", value)


@pulumi.input_type
class DistributionConfigurationDistributionContainerDistributionConfigurationArgs:
    def __init__(__self__, *,
                 target_repository: pulumi.Input['DistributionConfigurationDistributionContainerDistributionConfigurationTargetRepositoryArgs'],
                 container_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['DistributionConfigurationDistributionContainerDistributionConfigurationTargetRepositoryArgs'] target_repository: Configuration block with the destination repository for the container distribution configuration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] container_tags: Set of tags that are attached to the container distribution configuration.
        :param pulumi.Input[str] description: Description of the container distribution configuration.
        """
        pulumi.set(__self__, "target_repository", target_repository)
        if container_tags is not None:
            pulumi.set(__self__, "container_tags", container_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="targetRepository")
    def target_repository(self) -> pulumi.Input['DistributionConfigurationDistributionContainerDistributionConfigurationTargetRepositoryArgs']:
        """
        Configuration block with the destination repository for the container distribution configuration.
        """
        return pulumi.get(self, "target_repository")

    @target_repository.setter
    def target_repository(self, value: pulumi.Input['DistributionConfigurationDistributionContainerDistributionConfigurationTargetRepositoryArgs']):
        pulumi.set(self, "target_repository", value)

    @property
    @pulumi.getter(name="containerTags")
    def container_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of tags that are attached to the container distribution configuration.
        """
        return pulumi.get(self, "container_tags")

    @container_tags.setter
    def container_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "container_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the container distribution configuration.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class DistributionConfigurationDistributionContainerDistributionConfigurationTargetRepositoryArgs:
    def __init__(__self__, *,
                 repository_name: pulumi.Input[str],
                 service: pulumi.Input[str]):
        """
        :param pulumi.Input[str] repository_name: The name of the container repository where the output container image is stored. This name is prefixed by the repository location.
        :param pulumi.Input[str] service: The service in which this image is registered. Valid values: `ECR`.
        """
        pulumi.set(__self__, "repository_name", repository_name)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> pulumi.Input[str]:
        """
        The name of the container repository where the output container image is stored. This name is prefixed by the repository location.
        """
        return pulumi.get(self, "repository_name")

    @repository_name.setter
    def repository_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "repository_name", value)

    @property
    @pulumi.getter
    def service(self) -> pulumi.Input[str]:
        """
        The service in which this image is registered. Valid values: `ECR`.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[str]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class DistributionConfigurationDistributionFastLaunchConfigurationArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[str],
                 enabled: pulumi.Input[bool],
                 launch_template: Optional[pulumi.Input['DistributionConfigurationDistributionFastLaunchConfigurationLaunchTemplateArgs']] = None,
                 max_parallel_launches: Optional[pulumi.Input[int]] = None,
                 snapshot_configuration: Optional[pulumi.Input['DistributionConfigurationDistributionFastLaunchConfigurationSnapshotConfigurationArgs']] = None):
        """
        :param pulumi.Input[str] account_id: The owner account ID for the fast-launch enabled Windows AMI.
        :param pulumi.Input[bool] enabled: A Boolean that represents the current state of faster launching for the Windows AMI. Set to `true` to start using Windows faster launching, or `false` to stop using it.
        :param pulumi.Input['DistributionConfigurationDistributionFastLaunchConfigurationLaunchTemplateArgs'] launch_template: Configuration block for the launch template that the fast-launch enabled Windows AMI uses when it launches Windows instances to create pre-provisioned snapshots. Detailed below.
        :param pulumi.Input[int] max_parallel_launches: The maximum number of parallel instances that are launched for creating resources.
        :param pulumi.Input['DistributionConfigurationDistributionFastLaunchConfigurationSnapshotConfigurationArgs'] snapshot_configuration: Configuration block for managing the number of snapshots that are created from pre-provisioned instances for the Windows AMI when faster launching is enabled. Detailed below.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "enabled", enabled)
        if launch_template is not None:
            pulumi.set(__self__, "launch_template", launch_template)
        if max_parallel_launches is not None:
            pulumi.set(__self__, "max_parallel_launches", max_parallel_launches)
        if snapshot_configuration is not None:
            pulumi.set(__self__, "snapshot_configuration", snapshot_configuration)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[str]:
        """
        The owner account ID for the fast-launch enabled Windows AMI.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        A Boolean that represents the current state of faster launching for the Windows AMI. Set to `true` to start using Windows faster launching, or `false` to stop using it.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> Optional[pulumi.Input['DistributionConfigurationDistributionFastLaunchConfigurationLaunchTemplateArgs']]:
        """
        Configuration block for the launch template that the fast-launch enabled Windows AMI uses when it launches Windows instances to create pre-provisioned snapshots. Detailed below.
        """
        return pulumi.get(self, "launch_template")

    @launch_template.setter
    def launch_template(self, value: Optional[pulumi.Input['DistributionConfigurationDistributionFastLaunchConfigurationLaunchTemplateArgs']]):
        pulumi.set(self, "launch_template", value)

    @property
    @pulumi.getter(name="maxParallelLaunches")
    def max_parallel_launches(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of parallel instances that are launched for creating resources.
        """
        return pulumi.get(self, "max_parallel_launches")

    @max_parallel_launches.setter
    def max_parallel_launches(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_parallel_launches", value)

    @property
    @pulumi.getter(name="snapshotConfiguration")
    def snapshot_configuration(self) -> Optional[pulumi.Input['DistributionConfigurationDistributionFastLaunchConfigurationSnapshotConfigurationArgs']]:
        """
        Configuration block for managing the number of snapshots that are created from pre-provisioned instances for the Windows AMI when faster launching is enabled. Detailed below.
        """
        return pulumi.get(self, "snapshot_configuration")

    @snapshot_configuration.setter
    def snapshot_configuration(self, value: Optional[pulumi.Input['DistributionConfigurationDistributionFastLaunchConfigurationSnapshotConfigurationArgs']]):
        pulumi.set(self, "snapshot_configuration", value)


@pulumi.input_type
class DistributionConfigurationDistributionFastLaunchConfigurationLaunchTemplateArgs:
    def __init__(__self__, *,
                 launch_template_id: Optional[pulumi.Input[str]] = None,
                 launch_template_name: Optional[pulumi.Input[str]] = None,
                 launch_template_version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] launch_template_id: The ID of the launch template to use for faster launching for a Windows AMI.
        :param pulumi.Input[str] launch_template_name: The name of the launch template to use for faster launching for a Windows AMI.
        :param pulumi.Input[str] launch_template_version: The version of the launch template to use for faster launching for a Windows AMI.
        """
        if launch_template_id is not None:
            pulumi.set(__self__, "launch_template_id", launch_template_id)
        if launch_template_name is not None:
            pulumi.set(__self__, "launch_template_name", launch_template_name)
        if launch_template_version is not None:
            pulumi.set(__self__, "launch_template_version", launch_template_version)

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the launch template to use for faster launching for a Windows AMI.
        """
        return pulumi.get(self, "launch_template_id")

    @launch_template_id.setter
    def launch_template_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_template_id", value)

    @property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the launch template to use for faster launching for a Windows AMI.
        """
        return pulumi.get(self, "launch_template_name")

    @launch_template_name.setter
    def launch_template_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_template_name", value)

    @property
    @pulumi.getter(name="launchTemplateVersion")
    def launch_template_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the launch template to use for faster launching for a Windows AMI.
        """
        return pulumi.get(self, "launch_template_version")

    @launch_template_version.setter
    def launch_template_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_template_version", value)


@pulumi.input_type
class DistributionConfigurationDistributionFastLaunchConfigurationSnapshotConfigurationArgs:
    def __init__(__self__, *,
                 target_resource_count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] target_resource_count: The number of pre-provisioned snapshots to keep on hand for a fast-launch enabled Windows AMI.
        """
        if target_resource_count is not None:
            pulumi.set(__self__, "target_resource_count", target_resource_count)

    @property
    @pulumi.getter(name="targetResourceCount")
    def target_resource_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of pre-provisioned snapshots to keep on hand for a fast-launch enabled Windows AMI.
        """
        return pulumi.get(self, "target_resource_count")

    @target_resource_count.setter
    def target_resource_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_resource_count", value)


@pulumi.input_type
class DistributionConfigurationDistributionLaunchTemplateConfigurationArgs:
    def __init__(__self__, *,
                 launch_template_id: pulumi.Input[str],
                 account_id: Optional[pulumi.Input[str]] = None,
                 default: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] launch_template_id: The ID of the Amazon EC2 launch template to use.
        :param pulumi.Input[str] account_id: The account ID that this configuration applies to.
        :param pulumi.Input[bool] default: Indicates whether to set the specified Amazon EC2 launch template as the default launch template. Defaults to `true`.
        """
        pulumi.set(__self__, "launch_template_id", launch_template_id)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if default is not None:
            pulumi.set(__self__, "default", default)

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> pulumi.Input[str]:
        """
        The ID of the Amazon EC2 launch template to use.
        """
        return pulumi.get(self, "launch_template_id")

    @launch_template_id.setter
    def launch_template_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "launch_template_id", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The account ID that this configuration applies to.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to set the specified Amazon EC2 launch template as the default launch template. Defaults to `true`.
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "default", value)


@pulumi.input_type
class ImageImageScanningConfigurationArgs:
    def __init__(__self__, *,
                 ecr_configuration: Optional[pulumi.Input['ImageImageScanningConfigurationEcrConfigurationArgs']] = None,
                 image_scanning_enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input['ImageImageScanningConfigurationEcrConfigurationArgs'] ecr_configuration: Configuration block with ECR configuration. Detailed below.
        :param pulumi.Input[bool] image_scanning_enabled: Indicates whether Image Builder keeps a snapshot of the vulnerability scans that Amazon Inspector runs against the build instance when you create a new image. Defaults to `false`.
        """
        if ecr_configuration is not None:
            pulumi.set(__self__, "ecr_configuration", ecr_configuration)
        if image_scanning_enabled is not None:
            pulumi.set(__self__, "image_scanning_enabled", image_scanning_enabled)

    @property
    @pulumi.getter(name="ecrConfiguration")
    def ecr_configuration(self) -> Optional[pulumi.Input['ImageImageScanningConfigurationEcrConfigurationArgs']]:
        """
        Configuration block with ECR configuration. Detailed below.
        """
        return pulumi.get(self, "ecr_configuration")

    @ecr_configuration.setter
    def ecr_configuration(self, value: Optional[pulumi.Input['ImageImageScanningConfigurationEcrConfigurationArgs']]):
        pulumi.set(self, "ecr_configuration", value)

    @property
    @pulumi.getter(name="imageScanningEnabled")
    def image_scanning_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether Image Builder keeps a snapshot of the vulnerability scans that Amazon Inspector runs against the build instance when you create a new image. Defaults to `false`.
        """
        return pulumi.get(self, "image_scanning_enabled")

    @image_scanning_enabled.setter
    def image_scanning_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "image_scanning_enabled", value)


@pulumi.input_type
class ImageImageScanningConfigurationEcrConfigurationArgs:
    def __init__(__self__, *,
                 container_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 repository_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] container_tags: Set of tags for Image Builder to apply to the output container image that that Amazon Inspector scans.
        :param pulumi.Input[str] repository_name: The name of the container repository that Amazon Inspector scans to identify findings for your container images.
        """
        if container_tags is not None:
            pulumi.set(__self__, "container_tags", container_tags)
        if repository_name is not None:
            pulumi.set(__self__, "repository_name", repository_name)

    @property
    @pulumi.getter(name="containerTags")
    def container_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of tags for Image Builder to apply to the output container image that that Amazon Inspector scans.
        """
        return pulumi.get(self, "container_tags")

    @container_tags.setter
    def container_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "container_tags", value)

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the container repository that Amazon Inspector scans to identify findings for your container images.
        """
        return pulumi.get(self, "repository_name")

    @repository_name.setter
    def repository_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository_name", value)


@pulumi.input_type
class ImageImageTestsConfigurationArgs:
    def __init__(__self__, *,
                 image_tests_enabled: Optional[pulumi.Input[bool]] = None,
                 timeout_minutes: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[bool] image_tests_enabled: Whether image tests are enabled. Defaults to `true`.
        :param pulumi.Input[int] timeout_minutes: Number of minutes before image tests time out. Valid values are between `60` and `1440`. Defaults to `720`.
        """
        if image_tests_enabled is not None:
            pulumi.set(__self__, "image_tests_enabled", image_tests_enabled)
        if timeout_minutes is not None:
            pulumi.set(__self__, "timeout_minutes", timeout_minutes)

    @property
    @pulumi.getter(name="imageTestsEnabled")
    def image_tests_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether image tests are enabled. Defaults to `true`.
        """
        return pulumi.get(self, "image_tests_enabled")

    @image_tests_enabled.setter
    def image_tests_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "image_tests_enabled", value)

    @property
    @pulumi.getter(name="timeoutMinutes")
    def timeout_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        Number of minutes before image tests time out. Valid values are between `60` and `1440`. Defaults to `720`.
        """
        return pulumi.get(self, "timeout_minutes")

    @timeout_minutes.setter
    def timeout_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_minutes", value)


@pulumi.input_type
class ImageOutputResourceArgs:
    def __init__(__self__, *,
                 amis: Optional[pulumi.Input[Sequence[pulumi.Input['ImageOutputResourceAmiArgs']]]] = None,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input['ImageOutputResourceContainerArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ImageOutputResourceAmiArgs']]] amis: Set of objects with each Amazon Machine Image (AMI) created.
        :param pulumi.Input[Sequence[pulumi.Input['ImageOutputResourceContainerArgs']]] containers: Set of objects with each container image created and stored in the output repository.
        """
        if amis is not None:
            pulumi.set(__self__, "amis", amis)
        if containers is not None:
            pulumi.set(__self__, "containers", containers)

    @property
    @pulumi.getter
    def amis(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageOutputResourceAmiArgs']]]]:
        """
        Set of objects with each Amazon Machine Image (AMI) created.
        """
        return pulumi.get(self, "amis")

    @amis.setter
    def amis(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageOutputResourceAmiArgs']]]]):
        pulumi.set(self, "amis", value)

    @property
    @pulumi.getter
    def containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageOutputResourceContainerArgs']]]]:
        """
        Set of objects with each container image created and stored in the output repository.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageOutputResourceContainerArgs']]]]):
        pulumi.set(self, "containers", value)


@pulumi.input_type
class ImageOutputResourceAmiArgs:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] account_id: Account identifier of the AMI.
        :param pulumi.Input[str] description: Description of the AMI.
        :param pulumi.Input[str] image: Identifier of the AMI.
        :param pulumi.Input[str] name: Name of the AMI.
        :param pulumi.Input[str] region: Region of the container image.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        Account identifier of the AMI.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the AMI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the AMI.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the AMI.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Region of the container image.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class ImageOutputResourceContainerArgs:
    def __init__(__self__, *,
                 image_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] image_uris: Set of URIs for created containers.
        :param pulumi.Input[str] region: Region of the container image.
        """
        if image_uris is not None:
            pulumi.set(__self__, "image_uris", image_uris)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="imageUris")
    def image_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of URIs for created containers.
        """
        return pulumi.get(self, "image_uris")

    @image_uris.setter
    def image_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "image_uris", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Region of the container image.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class ImagePipelineImageScanningConfigurationArgs:
    def __init__(__self__, *,
                 ecr_configuration: Optional[pulumi.Input['ImagePipelineImageScanningConfigurationEcrConfigurationArgs']] = None,
                 image_scanning_enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input['ImagePipelineImageScanningConfigurationEcrConfigurationArgs'] ecr_configuration: Configuration block with ECR configuration for image scanning. Detailed below.
        :param pulumi.Input[bool] image_scanning_enabled: Whether image scans are enabled. Defaults to `false`.
        """
        if ecr_configuration is not None:
            pulumi.set(__self__, "ecr_configuration", ecr_configuration)
        if image_scanning_enabled is not None:
            pulumi.set(__self__, "image_scanning_enabled", image_scanning_enabled)

    @property
    @pulumi.getter(name="ecrConfiguration")
    def ecr_configuration(self) -> Optional[pulumi.Input['ImagePipelineImageScanningConfigurationEcrConfigurationArgs']]:
        """
        Configuration block with ECR configuration for image scanning. Detailed below.
        """
        return pulumi.get(self, "ecr_configuration")

    @ecr_configuration.setter
    def ecr_configuration(self, value: Optional[pulumi.Input['ImagePipelineImageScanningConfigurationEcrConfigurationArgs']]):
        pulumi.set(self, "ecr_configuration", value)

    @property
    @pulumi.getter(name="imageScanningEnabled")
    def image_scanning_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether image scans are enabled. Defaults to `false`.
        """
        return pulumi.get(self, "image_scanning_enabled")

    @image_scanning_enabled.setter
    def image_scanning_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "image_scanning_enabled", value)


@pulumi.input_type
class ImagePipelineImageScanningConfigurationEcrConfigurationArgs:
    def __init__(__self__, *,
                 container_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 repository_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] repository_name: The name of the repository to scan
        """
        if container_tags is not None:
            pulumi.set(__self__, "container_tags", container_tags)
        if repository_name is not None:
            pulumi.set(__self__, "repository_name", repository_name)

    @property
    @pulumi.getter(name="containerTags")
    def container_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "container_tags")

    @container_tags.setter
    def container_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "container_tags", value)

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the repository to scan
        """
        return pulumi.get(self, "repository_name")

    @repository_name.setter
    def repository_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository_name", value)


@pulumi.input_type
class ImagePipelineImageTestsConfigurationArgs:
    def __init__(__self__, *,
                 image_tests_enabled: Optional[pulumi.Input[bool]] = None,
                 timeout_minutes: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[bool] image_tests_enabled: Whether image tests are enabled. Defaults to `true`.
        :param pulumi.Input[int] timeout_minutes: Number of minutes before image tests time out. Valid values are between `60` and `1440`. Defaults to `720`.
        """
        if image_tests_enabled is not None:
            pulumi.set(__self__, "image_tests_enabled", image_tests_enabled)
        if timeout_minutes is not None:
            pulumi.set(__self__, "timeout_minutes", timeout_minutes)

    @property
    @pulumi.getter(name="imageTestsEnabled")
    def image_tests_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether image tests are enabled. Defaults to `true`.
        """
        return pulumi.get(self, "image_tests_enabled")

    @image_tests_enabled.setter
    def image_tests_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "image_tests_enabled", value)

    @property
    @pulumi.getter(name="timeoutMinutes")
    def timeout_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        Number of minutes before image tests time out. Valid values are between `60` and `1440`. Defaults to `720`.
        """
        return pulumi.get(self, "timeout_minutes")

    @timeout_minutes.setter
    def timeout_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_minutes", value)


@pulumi.input_type
class ImagePipelineScheduleArgs:
    def __init__(__self__, *,
                 schedule_expression: pulumi.Input[str],
                 pipeline_execution_start_condition: Optional[pulumi.Input[str]] = None,
                 timezone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] schedule_expression: Cron expression of how often the pipeline start condition is evaluated. For example, `cron(0 0 * * ? *)` is evaluated every day at midnight UTC. Configurations using the five field syntax that was previously accepted by the API, such as `cron(0 0 * * *)`, must be updated to the six field syntax. For more information, see the [Image Builder User Guide](https://docs.aws.amazon.com/imagebuilder/latest/userguide/cron-expressions.html).
               
               The following arguments are optional:
        :param pulumi.Input[str] pipeline_execution_start_condition: Condition when the pipeline should trigger a new image build. Valid values are `EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE` and `EXPRESSION_MATCH_ONLY`. Defaults to `EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE`.
        :param pulumi.Input[str] timezone: The timezone that applies to the scheduling expression. For example, "Etc/UTC", "America/Los_Angeles" in the [IANA timezone format](https://www.joda.org/joda-time/timezones.html). If not specified this defaults to UTC.
        """
        pulumi.set(__self__, "schedule_expression", schedule_expression)
        if pipeline_execution_start_condition is not None:
            pulumi.set(__self__, "pipeline_execution_start_condition", pipeline_execution_start_condition)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> pulumi.Input[str]:
        """
        Cron expression of how often the pipeline start condition is evaluated. For example, `cron(0 0 * * ? *)` is evaluated every day at midnight UTC. Configurations using the five field syntax that was previously accepted by the API, such as `cron(0 0 * * *)`, must be updated to the six field syntax. For more information, see the [Image Builder User Guide](https://docs.aws.amazon.com/imagebuilder/latest/userguide/cron-expressions.html).

        The following arguments are optional:
        """
        return pulumi.get(self, "schedule_expression")

    @schedule_expression.setter
    def schedule_expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "schedule_expression", value)

    @property
    @pulumi.getter(name="pipelineExecutionStartCondition")
    def pipeline_execution_start_condition(self) -> Optional[pulumi.Input[str]]:
        """
        Condition when the pipeline should trigger a new image build. Valid values are `EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE` and `EXPRESSION_MATCH_ONLY`. Defaults to `EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE`.
        """
        return pulumi.get(self, "pipeline_execution_start_condition")

    @pipeline_execution_start_condition.setter
    def pipeline_execution_start_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pipeline_execution_start_condition", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        """
        The timezone that applies to the scheduling expression. For example, "Etc/UTC", "America/Los_Angeles" in the [IANA timezone format](https://www.joda.org/joda-time/timezones.html). If not specified this defaults to UTC.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)


@pulumi.input_type
class ImageRecipeBlockDeviceMappingArgs:
    def __init__(__self__, *,
                 device_name: Optional[pulumi.Input[str]] = None,
                 ebs: Optional[pulumi.Input['ImageRecipeBlockDeviceMappingEbsArgs']] = None,
                 no_device: Optional[pulumi.Input[bool]] = None,
                 virtual_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] device_name: Name of the device. For example, `/dev/sda` or `/dev/xvdb`.
        :param pulumi.Input['ImageRecipeBlockDeviceMappingEbsArgs'] ebs: Configuration block with Elastic Block Storage (EBS) block device mapping settings. Detailed below.
        :param pulumi.Input[bool] no_device: Set to `true` to remove a mapping from the parent image.
        :param pulumi.Input[str] virtual_name: Virtual device name. For example, `ephemeral0`. Instance store volumes are numbered starting from 0.
        """
        if device_name is not None:
            pulumi.set(__self__, "device_name", device_name)
        if ebs is not None:
            pulumi.set(__self__, "ebs", ebs)
        if no_device is not None:
            pulumi.set(__self__, "no_device", no_device)
        if virtual_name is not None:
            pulumi.set(__self__, "virtual_name", virtual_name)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the device. For example, `/dev/sda` or `/dev/xvdb`.
        """
        return pulumi.get(self, "device_name")

    @device_name.setter
    def device_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_name", value)

    @property
    @pulumi.getter
    def ebs(self) -> Optional[pulumi.Input['ImageRecipeBlockDeviceMappingEbsArgs']]:
        """
        Configuration block with Elastic Block Storage (EBS) block device mapping settings. Detailed below.
        """
        return pulumi.get(self, "ebs")

    @ebs.setter
    def ebs(self, value: Optional[pulumi.Input['ImageRecipeBlockDeviceMappingEbsArgs']]):
        pulumi.set(self, "ebs", value)

    @property
    @pulumi.getter(name="noDevice")
    def no_device(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to remove a mapping from the parent image.
        """
        return pulumi.get(self, "no_device")

    @no_device.setter
    def no_device(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_device", value)

    @property
    @pulumi.getter(name="virtualName")
    def virtual_name(self) -> Optional[pulumi.Input[str]]:
        """
        Virtual device name. For example, `ephemeral0`. Instance store volumes are numbered starting from 0.
        """
        return pulumi.get(self, "virtual_name")

    @virtual_name.setter
    def virtual_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_name", value)


@pulumi.input_type
class ImageRecipeBlockDeviceMappingEbsArgs:
    def __init__(__self__, *,
                 delete_on_termination: Optional[pulumi.Input[str]] = None,
                 encrypted: Optional[pulumi.Input[str]] = None,
                 iops: Optional[pulumi.Input[int]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 snapshot_id: Optional[pulumi.Input[str]] = None,
                 throughput: Optional[pulumi.Input[int]] = None,
                 volume_size: Optional[pulumi.Input[int]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] delete_on_termination: Whether to delete the volume on termination. Defaults to unset, which is the value inherited from the parent image.
        :param pulumi.Input[str] encrypted: Whether to encrypt the volume. Defaults to unset, which is the value inherited from the parent image.
        :param pulumi.Input[int] iops: Number of Input/Output (I/O) operations per second to provision for an `io1` or `io2` volume.
        :param pulumi.Input[str] kms_key_id: Amazon Resource Name (ARN) of the Key Management Service (KMS) Key for encryption.
        :param pulumi.Input[str] snapshot_id: Identifier of the EC2 Volume Snapshot.
        :param pulumi.Input[int] throughput: For GP3 volumes only. The throughput in MiB/s that the volume supports.
        :param pulumi.Input[int] volume_size: Size of the volume, in GiB.
        :param pulumi.Input[str] volume_type: Type of the volume. For example, `gp2` or `io2`.
        """
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to delete the volume on termination. Defaults to unset, which is the value inherited from the parent image.
        """
        return pulumi.get(self, "delete_on_termination")

    @delete_on_termination.setter
    def delete_on_termination(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delete_on_termination", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to encrypt the volume. Defaults to unset, which is the value inherited from the parent image.
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        Number of Input/Output (I/O) operations per second to provision for an `io1` or `io2` volume.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of the Key Management Service (KMS) Key for encryption.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the EC2 Volume Snapshot.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_id", value)

    @property
    @pulumi.getter
    def throughput(self) -> Optional[pulumi.Input[int]]:
        """
        For GP3 volumes only. The throughput in MiB/s that the volume supports.
        """
        return pulumi.get(self, "throughput")

    @throughput.setter
    def throughput(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "throughput", value)

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the volume, in GiB.
        """
        return pulumi.get(self, "volume_size")

    @volume_size.setter
    def volume_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "volume_size", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the volume. For example, `gp2` or `io2`.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_type", value)


@pulumi.input_type
class ImageRecipeComponentArgs:
    def __init__(__self__, *,
                 component_arn: pulumi.Input[str],
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ImageRecipeComponentParameterArgs']]]] = None):
        """
        :param pulumi.Input[str] component_arn: Amazon Resource Name (ARN) of the Image Builder Component to associate.
        :param pulumi.Input[Sequence[pulumi.Input['ImageRecipeComponentParameterArgs']]] parameters: Configuration block(s) for parameters to configure the component. Detailed below.
        """
        pulumi.set(__self__, "component_arn", component_arn)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="componentArn")
    def component_arn(self) -> pulumi.Input[str]:
        """
        Amazon Resource Name (ARN) of the Image Builder Component to associate.
        """
        return pulumi.get(self, "component_arn")

    @component_arn.setter
    def component_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "component_arn", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageRecipeComponentParameterArgs']]]]:
        """
        Configuration block(s) for parameters to configure the component. Detailed below.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageRecipeComponentParameterArgs']]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class ImageRecipeComponentParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: The name of the component parameter.
        :param pulumi.Input[str] value: The value for the named component parameter.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the component parameter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value for the named component parameter.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ImageRecipeSystemsManagerAgentArgs:
    def __init__(__self__, *,
                 uninstall_after_build: pulumi.Input[bool]):
        """
        :param pulumi.Input[bool] uninstall_after_build: Whether to remove the Systems Manager Agent after the image has been built. Defaults to `false`.
        """
        pulumi.set(__self__, "uninstall_after_build", uninstall_after_build)

    @property
    @pulumi.getter(name="uninstallAfterBuild")
    def uninstall_after_build(self) -> pulumi.Input[bool]:
        """
        Whether to remove the Systems Manager Agent after the image has been built. Defaults to `false`.
        """
        return pulumi.get(self, "uninstall_after_build")

    @uninstall_after_build.setter
    def uninstall_after_build(self, value: pulumi.Input[bool]):
        pulumi.set(self, "uninstall_after_build", value)


@pulumi.input_type
class InfrastructureConfigurationInstanceMetadataOptionsArgs:
    def __init__(__self__, *,
                 http_put_response_hop_limit: Optional[pulumi.Input[int]] = None,
                 http_tokens: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] http_put_response_hop_limit: The number of hops that an instance can traverse to reach its destonation.
        :param pulumi.Input[str] http_tokens: Whether a signed token is required for instance metadata retrieval requests. Valid values: `required`, `optional`.
        """
        if http_put_response_hop_limit is not None:
            pulumi.set(__self__, "http_put_response_hop_limit", http_put_response_hop_limit)
        if http_tokens is not None:
            pulumi.set(__self__, "http_tokens", http_tokens)

    @property
    @pulumi.getter(name="httpPutResponseHopLimit")
    def http_put_response_hop_limit(self) -> Optional[pulumi.Input[int]]:
        """
        The number of hops that an instance can traverse to reach its destonation.
        """
        return pulumi.get(self, "http_put_response_hop_limit")

    @http_put_response_hop_limit.setter
    def http_put_response_hop_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "http_put_response_hop_limit", value)

    @property
    @pulumi.getter(name="httpTokens")
    def http_tokens(self) -> Optional[pulumi.Input[str]]:
        """
        Whether a signed token is required for instance metadata retrieval requests. Valid values: `required`, `optional`.
        """
        return pulumi.get(self, "http_tokens")

    @http_tokens.setter
    def http_tokens(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_tokens", value)


@pulumi.input_type
class InfrastructureConfigurationLoggingArgs:
    def __init__(__self__, *,
                 s3_logs: pulumi.Input['InfrastructureConfigurationLoggingS3LogsArgs']):
        """
        :param pulumi.Input['InfrastructureConfigurationLoggingS3LogsArgs'] s3_logs: Configuration block with S3 logging settings. Detailed below.
        """
        pulumi.set(__self__, "s3_logs", s3_logs)

    @property
    @pulumi.getter(name="s3Logs")
    def s3_logs(self) -> pulumi.Input['InfrastructureConfigurationLoggingS3LogsArgs']:
        """
        Configuration block with S3 logging settings. Detailed below.
        """
        return pulumi.get(self, "s3_logs")

    @s3_logs.setter
    def s3_logs(self, value: pulumi.Input['InfrastructureConfigurationLoggingS3LogsArgs']):
        pulumi.set(self, "s3_logs", value)


@pulumi.input_type
class InfrastructureConfigurationLoggingS3LogsArgs:
    def __init__(__self__, *,
                 s3_bucket_name: pulumi.Input[str],
                 s3_key_prefix: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] s3_bucket_name: Name of the S3 Bucket.
               
               The following arguments are optional:
        :param pulumi.Input[str] s3_key_prefix: Prefix to use for S3 logs. Defaults to `/`.
        """
        pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        if s3_key_prefix is not None:
            pulumi.set(__self__, "s3_key_prefix", s3_key_prefix)

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> pulumi.Input[str]:
        """
        Name of the S3 Bucket.

        The following arguments are optional:
        """
        return pulumi.get(self, "s3_bucket_name")

    @s3_bucket_name.setter
    def s3_bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "s3_bucket_name", value)

    @property
    @pulumi.getter(name="s3KeyPrefix")
    def s3_key_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Prefix to use for S3 logs. Defaults to `/`.
        """
        return pulumi.get(self, "s3_key_prefix")

    @s3_key_prefix.setter
    def s3_key_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_key_prefix", value)


@pulumi.input_type
class GetComponentsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Name of the filter field. Valid values can be found in the [Image Builder ListComponents API Reference](https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ListComponents.html).
        :param Sequence[str] values: Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the filter field. Valid values can be found in the [Image Builder ListComponents API Reference](https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ListComponents.html).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetContainerRecipesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Name of the filter field. Valid values can be found in the [Image Builder ListContainerRecipes API Reference](https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ListContainerRecipes.html).
        :param Sequence[str] values: Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the filter field. Valid values can be found in the [Image Builder ListContainerRecipes API Reference](https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ListContainerRecipes.html).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetDistributionConfigurationsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Name of the filter field. Valid values can be found in the [Image Builder ListDistributionConfigurations API Reference](https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ListDistributionConfigurations.html).
        :param Sequence[str] values: Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the filter field. Valid values can be found in the [Image Builder ListDistributionConfigurations API Reference](https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ListDistributionConfigurations.html).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetImagePipelinesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Name of the filter field. Valid values can be found in the [Image Builder ListImagePipelines API Reference](https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ListImagePipelines.html).
        :param Sequence[str] values: Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the filter field. Valid values can be found in the [Image Builder ListImagePipelines API Reference](https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ListImagePipelines.html).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetImageRecipesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Name of the filter field. Valid values can be found in the [Image Builder ListImageRecipes API Reference](https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ListImageRecipes.html).
        :param Sequence[str] values: Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the filter field. Valid values can be found in the [Image Builder ListImageRecipes API Reference](https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ListImageRecipes.html).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetInfrastructureConfigurationsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Name of the filter field. Valid values can be found in the [Image Builder ListInfrastructureConfigurations API Reference](https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ListInfrastructureConfigurations.html).
        :param Sequence[str] values: Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the filter field. Valid values can be found in the [Image Builder ListInfrastructureConfigurations API Reference](https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_ListInfrastructureConfigurations.html).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


