# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetImageResult',
    'AwaitableGetImageResult',
    'get_image',
    'get_image_output',
]

@pulumi.output_type
class GetImageResult:
    """
    A collection of values returned by getImage.
    """
    def __init__(__self__, arn=None, build_version_arn=None, container_recipe_arn=None, date_created=None, distribution_configuration_arn=None, enhanced_image_metadata_enabled=None, id=None, image_recipe_arn=None, image_scanning_configurations=None, image_tests_configurations=None, infrastructure_configuration_arn=None, name=None, os_version=None, output_resources=None, platform=None, tags=None, version=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if build_version_arn and not isinstance(build_version_arn, str):
            raise TypeError("Expected argument 'build_version_arn' to be a str")
        pulumi.set(__self__, "build_version_arn", build_version_arn)
        if container_recipe_arn and not isinstance(container_recipe_arn, str):
            raise TypeError("Expected argument 'container_recipe_arn' to be a str")
        pulumi.set(__self__, "container_recipe_arn", container_recipe_arn)
        if date_created and not isinstance(date_created, str):
            raise TypeError("Expected argument 'date_created' to be a str")
        pulumi.set(__self__, "date_created", date_created)
        if distribution_configuration_arn and not isinstance(distribution_configuration_arn, str):
            raise TypeError("Expected argument 'distribution_configuration_arn' to be a str")
        pulumi.set(__self__, "distribution_configuration_arn", distribution_configuration_arn)
        if enhanced_image_metadata_enabled and not isinstance(enhanced_image_metadata_enabled, bool):
            raise TypeError("Expected argument 'enhanced_image_metadata_enabled' to be a bool")
        pulumi.set(__self__, "enhanced_image_metadata_enabled", enhanced_image_metadata_enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_recipe_arn and not isinstance(image_recipe_arn, str):
            raise TypeError("Expected argument 'image_recipe_arn' to be a str")
        pulumi.set(__self__, "image_recipe_arn", image_recipe_arn)
        if image_scanning_configurations and not isinstance(image_scanning_configurations, list):
            raise TypeError("Expected argument 'image_scanning_configurations' to be a list")
        pulumi.set(__self__, "image_scanning_configurations", image_scanning_configurations)
        if image_tests_configurations and not isinstance(image_tests_configurations, list):
            raise TypeError("Expected argument 'image_tests_configurations' to be a list")
        pulumi.set(__self__, "image_tests_configurations", image_tests_configurations)
        if infrastructure_configuration_arn and not isinstance(infrastructure_configuration_arn, str):
            raise TypeError("Expected argument 'infrastructure_configuration_arn' to be a str")
        pulumi.set(__self__, "infrastructure_configuration_arn", infrastructure_configuration_arn)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if os_version and not isinstance(os_version, str):
            raise TypeError("Expected argument 'os_version' to be a str")
        pulumi.set(__self__, "os_version", os_version)
        if output_resources and not isinstance(output_resources, list):
            raise TypeError("Expected argument 'output_resources' to be a list")
        pulumi.set(__self__, "output_resources", output_resources)
        if platform and not isinstance(platform, str):
            raise TypeError("Expected argument 'platform' to be a str")
        pulumi.set(__self__, "platform", platform)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def arn(self) -> str:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="buildVersionArn")
    def build_version_arn(self) -> str:
        """
        Build version ARN of the image. This will always have the `#.#.#/#` suffix.
        """
        return pulumi.get(self, "build_version_arn")

    @property
    @pulumi.getter(name="containerRecipeArn")
    def container_recipe_arn(self) -> str:
        """
        ARN of the container recipe.
        """
        return pulumi.get(self, "container_recipe_arn")

    @property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> str:
        """
        Date the image was created.
        """
        return pulumi.get(self, "date_created")

    @property
    @pulumi.getter(name="distributionConfigurationArn")
    def distribution_configuration_arn(self) -> str:
        """
        ARN of the Image Builder Distribution Configuration.
        """
        return pulumi.get(self, "distribution_configuration_arn")

    @property
    @pulumi.getter(name="enhancedImageMetadataEnabled")
    def enhanced_image_metadata_enabled(self) -> bool:
        """
        Whether additional information about the image being created is collected.
        """
        return pulumi.get(self, "enhanced_image_metadata_enabled")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageRecipeArn")
    def image_recipe_arn(self) -> str:
        """
        ARN of the image recipe.
        """
        return pulumi.get(self, "image_recipe_arn")

    @property
    @pulumi.getter(name="imageScanningConfigurations")
    def image_scanning_configurations(self) -> Sequence['outputs.GetImageImageScanningConfigurationResult']:
        """
        List of an object with image scanning configuration fields.
        """
        return pulumi.get(self, "image_scanning_configurations")

    @property
    @pulumi.getter(name="imageTestsConfigurations")
    def image_tests_configurations(self) -> Sequence['outputs.GetImageImageTestsConfigurationResult']:
        """
        List of an object with image tests configuration.
        """
        return pulumi.get(self, "image_tests_configurations")

    @property
    @pulumi.getter(name="infrastructureConfigurationArn")
    def infrastructure_configuration_arn(self) -> str:
        """
        ARN of the Image Builder Infrastructure Configuration.
        """
        return pulumi.get(self, "infrastructure_configuration_arn")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the AMI.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> str:
        """
        Operating System version of the image.
        """
        return pulumi.get(self, "os_version")

    @property
    @pulumi.getter(name="outputResources")
    def output_resources(self) -> Sequence['outputs.GetImageOutputResourceResult']:
        """
        List of objects with resources created by the image.
        """
        return pulumi.get(self, "output_resources")

    @property
    @pulumi.getter
    def platform(self) -> str:
        """
        Platform of the image.
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        Key-value map of resource tags for the image.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Version of the image.
        """
        return pulumi.get(self, "version")


class AwaitableGetImageResult(GetImageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetImageResult(
            arn=self.arn,
            build_version_arn=self.build_version_arn,
            container_recipe_arn=self.container_recipe_arn,
            date_created=self.date_created,
            distribution_configuration_arn=self.distribution_configuration_arn,
            enhanced_image_metadata_enabled=self.enhanced_image_metadata_enabled,
            id=self.id,
            image_recipe_arn=self.image_recipe_arn,
            image_scanning_configurations=self.image_scanning_configurations,
            image_tests_configurations=self.image_tests_configurations,
            infrastructure_configuration_arn=self.infrastructure_configuration_arn,
            name=self.name,
            os_version=self.os_version,
            output_resources=self.output_resources,
            platform=self.platform,
            tags=self.tags,
            version=self.version)


def get_image(arn: Optional[str] = None,
              tags: Optional[Mapping[str, str]] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetImageResult:
    """
    Provides details about an Image Builder Image.

    ## Example Usage

    ### Latest

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.imagebuilder.get_image(arn="arn:aws:imagebuilder:us-west-2:aws:image/amazon-linux-2-x86/x.x.x")
    ```
    <!--End PulumiCodeChooser -->


    :param str arn: ARN of the image. The suffix can either be specified with wildcards (`x.x.x`) to fetch the latest build version or a full build version (e.g., `2020.11.26/1`) to fetch an exact version.
    :param Mapping[str, str] tags: Key-value map of resource tags for the image.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:imagebuilder/getImage:getImage', __args__, opts=opts, typ=GetImageResult).value

    return AwaitableGetImageResult(
        arn=pulumi.get(__ret__, 'arn'),
        build_version_arn=pulumi.get(__ret__, 'build_version_arn'),
        container_recipe_arn=pulumi.get(__ret__, 'container_recipe_arn'),
        date_created=pulumi.get(__ret__, 'date_created'),
        distribution_configuration_arn=pulumi.get(__ret__, 'distribution_configuration_arn'),
        enhanced_image_metadata_enabled=pulumi.get(__ret__, 'enhanced_image_metadata_enabled'),
        id=pulumi.get(__ret__, 'id'),
        image_recipe_arn=pulumi.get(__ret__, 'image_recipe_arn'),
        image_scanning_configurations=pulumi.get(__ret__, 'image_scanning_configurations'),
        image_tests_configurations=pulumi.get(__ret__, 'image_tests_configurations'),
        infrastructure_configuration_arn=pulumi.get(__ret__, 'infrastructure_configuration_arn'),
        name=pulumi.get(__ret__, 'name'),
        os_version=pulumi.get(__ret__, 'os_version'),
        output_resources=pulumi.get(__ret__, 'output_resources'),
        platform=pulumi.get(__ret__, 'platform'),
        tags=pulumi.get(__ret__, 'tags'),
        version=pulumi.get(__ret__, 'version'))


@_utilities.lift_output_func(get_image)
def get_image_output(arn: Optional[pulumi.Input[str]] = None,
                     tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetImageResult]:
    """
    Provides details about an Image Builder Image.

    ## Example Usage

    ### Latest

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.imagebuilder.get_image(arn="arn:aws:imagebuilder:us-west-2:aws:image/amazon-linux-2-x86/x.x.x")
    ```
    <!--End PulumiCodeChooser -->


    :param str arn: ARN of the image. The suffix can either be specified with wildcards (`x.x.x`) to fetch the latest build version or a full build version (e.g., `2020.11.26/1`) to fetch an exact version.
    :param Mapping[str, str] tags: Key-value map of resource tags for the image.
    """
    ...
