# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetRegistrationCodeResult',
    'AwaitableGetRegistrationCodeResult',
    'get_registration_code',
    'get_registration_code_output',
]

@pulumi.output_type
class GetRegistrationCodeResult:
    """
    A collection of values returned by getRegistrationCode.
    """
    def __init__(__self__, id=None, registration_code=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if registration_code and not isinstance(registration_code, str):
            raise TypeError("Expected argument 'registration_code' to be a str")
        pulumi.set(__self__, "registration_code", registration_code)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="registrationCode")
    def registration_code(self) -> str:
        """
        The CA certificate registration code.
        """
        return pulumi.get(self, "registration_code")


class AwaitableGetRegistrationCodeResult(GetRegistrationCodeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRegistrationCodeResult(
            id=self.id,
            registration_code=self.registration_code)


def get_registration_code(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRegistrationCodeResult:
    """
    Gets a registration code used to register a CA certificate with AWS IoT.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws
    import pulumi_tls as tls

    example = aws.iot.get_registration_code()
    verification = tls.PrivateKey("verification", algorithm="RSA")
    verification_cert_request = tls.CertRequest("verification",
        key_algorithm="RSA",
        private_key_pem=verification.private_key_pem,
        subject=tls.CertRequestSubjectArgs(
            common_name=example.registration_code,
        ))
    ```
    <!--End PulumiCodeChooser -->
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:iot/getRegistrationCode:getRegistrationCode', __args__, opts=opts, typ=GetRegistrationCodeResult).value

    return AwaitableGetRegistrationCodeResult(
        id=pulumi.get(__ret__, 'id'),
        registration_code=pulumi.get(__ret__, 'registration_code'))


@_utilities.lift_output_func(get_registration_code)
def get_registration_code_output(opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRegistrationCodeResult]:
    """
    Gets a registration code used to register a CA certificate with AWS IoT.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws
    import pulumi_tls as tls

    example = aws.iot.get_registration_code()
    verification = tls.PrivateKey("verification", algorithm="RSA")
    verification_cert_request = tls.CertRequest("verification",
        key_algorithm="RSA",
        private_key_pem=verification.private_key_pem,
        subject=tls.CertRequestSubjectArgs(
            common_name=example.registration_code,
        ))
    ```
    <!--End PulumiCodeChooser -->
    """
    ...
