# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['CustomKeyStoreArgs', 'CustomKeyStore']

@pulumi.input_type
class CustomKeyStoreArgs:
    def __init__(__self__, *,
                 cloud_hsm_cluster_id: pulumi.Input[str],
                 custom_key_store_name: pulumi.Input[str],
                 key_store_password: pulumi.Input[str],
                 trust_anchor_certificate: pulumi.Input[str]):
        """
        The set of arguments for constructing a CustomKeyStore resource.
        :param pulumi.Input[str] cloud_hsm_cluster_id: Cluster ID of CloudHSM.
        :param pulumi.Input[str] custom_key_store_name: Unique name for Custom Key Store.
        :param pulumi.Input[str] key_store_password: Password for `kmsuser` on CloudHSM.
        :param pulumi.Input[str] trust_anchor_certificate: Customer certificate used for signing on CloudHSM.
        """
        pulumi.set(__self__, "cloud_hsm_cluster_id", cloud_hsm_cluster_id)
        pulumi.set(__self__, "custom_key_store_name", custom_key_store_name)
        pulumi.set(__self__, "key_store_password", key_store_password)
        pulumi.set(__self__, "trust_anchor_certificate", trust_anchor_certificate)

    @property
    @pulumi.getter(name="cloudHsmClusterId")
    def cloud_hsm_cluster_id(self) -> pulumi.Input[str]:
        """
        Cluster ID of CloudHSM.
        """
        return pulumi.get(self, "cloud_hsm_cluster_id")

    @cloud_hsm_cluster_id.setter
    def cloud_hsm_cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cloud_hsm_cluster_id", value)

    @property
    @pulumi.getter(name="customKeyStoreName")
    def custom_key_store_name(self) -> pulumi.Input[str]:
        """
        Unique name for Custom Key Store.
        """
        return pulumi.get(self, "custom_key_store_name")

    @custom_key_store_name.setter
    def custom_key_store_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "custom_key_store_name", value)

    @property
    @pulumi.getter(name="keyStorePassword")
    def key_store_password(self) -> pulumi.Input[str]:
        """
        Password for `kmsuser` on CloudHSM.
        """
        return pulumi.get(self, "key_store_password")

    @key_store_password.setter
    def key_store_password(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_store_password", value)

    @property
    @pulumi.getter(name="trustAnchorCertificate")
    def trust_anchor_certificate(self) -> pulumi.Input[str]:
        """
        Customer certificate used for signing on CloudHSM.
        """
        return pulumi.get(self, "trust_anchor_certificate")

    @trust_anchor_certificate.setter
    def trust_anchor_certificate(self, value: pulumi.Input[str]):
        pulumi.set(self, "trust_anchor_certificate", value)


@pulumi.input_type
class _CustomKeyStoreState:
    def __init__(__self__, *,
                 cloud_hsm_cluster_id: Optional[pulumi.Input[str]] = None,
                 custom_key_store_name: Optional[pulumi.Input[str]] = None,
                 key_store_password: Optional[pulumi.Input[str]] = None,
                 trust_anchor_certificate: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CustomKeyStore resources.
        :param pulumi.Input[str] cloud_hsm_cluster_id: Cluster ID of CloudHSM.
        :param pulumi.Input[str] custom_key_store_name: Unique name for Custom Key Store.
        :param pulumi.Input[str] key_store_password: Password for `kmsuser` on CloudHSM.
        :param pulumi.Input[str] trust_anchor_certificate: Customer certificate used for signing on CloudHSM.
        """
        if cloud_hsm_cluster_id is not None:
            pulumi.set(__self__, "cloud_hsm_cluster_id", cloud_hsm_cluster_id)
        if custom_key_store_name is not None:
            pulumi.set(__self__, "custom_key_store_name", custom_key_store_name)
        if key_store_password is not None:
            pulumi.set(__self__, "key_store_password", key_store_password)
        if trust_anchor_certificate is not None:
            pulumi.set(__self__, "trust_anchor_certificate", trust_anchor_certificate)

    @property
    @pulumi.getter(name="cloudHsmClusterId")
    def cloud_hsm_cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster ID of CloudHSM.
        """
        return pulumi.get(self, "cloud_hsm_cluster_id")

    @cloud_hsm_cluster_id.setter
    def cloud_hsm_cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_hsm_cluster_id", value)

    @property
    @pulumi.getter(name="customKeyStoreName")
    def custom_key_store_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name for Custom Key Store.
        """
        return pulumi.get(self, "custom_key_store_name")

    @custom_key_store_name.setter
    def custom_key_store_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_key_store_name", value)

    @property
    @pulumi.getter(name="keyStorePassword")
    def key_store_password(self) -> Optional[pulumi.Input[str]]:
        """
        Password for `kmsuser` on CloudHSM.
        """
        return pulumi.get(self, "key_store_password")

    @key_store_password.setter
    def key_store_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_store_password", value)

    @property
    @pulumi.getter(name="trustAnchorCertificate")
    def trust_anchor_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Customer certificate used for signing on CloudHSM.
        """
        return pulumi.get(self, "trust_anchor_certificate")

    @trust_anchor_certificate.setter
    def trust_anchor_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trust_anchor_certificate", value)


class CustomKeyStore(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_hsm_cluster_id: Optional[pulumi.Input[str]] = None,
                 custom_key_store_name: Optional[pulumi.Input[str]] = None,
                 key_store_password: Optional[pulumi.Input[str]] = None,
                 trust_anchor_certificate: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS KMS (Key Management) Custom Key Store.

        ## Example Usage

        ### Basic Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        test = aws.kms.CustomKeyStore("test",
            cloud_hsm_cluster_id=cloud_hsm_cluster_id,
            custom_key_store_name="kms-custom-key-store-test",
            key_store_password="noplaintextpasswords1",
            trust_anchor_certificate=std.file(input="anchor-certificate.crt").result)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import KMS (Key Management) Custom Key Store using the `id`. For example:

        ```sh
        $ pulumi import aws:kms/customKeyStore:CustomKeyStore example cks-5ebd4ef395a96288e
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cloud_hsm_cluster_id: Cluster ID of CloudHSM.
        :param pulumi.Input[str] custom_key_store_name: Unique name for Custom Key Store.
        :param pulumi.Input[str] key_store_password: Password for `kmsuser` on CloudHSM.
        :param pulumi.Input[str] trust_anchor_certificate: Customer certificate used for signing on CloudHSM.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomKeyStoreArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS KMS (Key Management) Custom Key Store.

        ## Example Usage

        ### Basic Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        test = aws.kms.CustomKeyStore("test",
            cloud_hsm_cluster_id=cloud_hsm_cluster_id,
            custom_key_store_name="kms-custom-key-store-test",
            key_store_password="noplaintextpasswords1",
            trust_anchor_certificate=std.file(input="anchor-certificate.crt").result)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import KMS (Key Management) Custom Key Store using the `id`. For example:

        ```sh
        $ pulumi import aws:kms/customKeyStore:CustomKeyStore example cks-5ebd4ef395a96288e
        ```

        :param str resource_name: The name of the resource.
        :param CustomKeyStoreArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomKeyStoreArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_hsm_cluster_id: Optional[pulumi.Input[str]] = None,
                 custom_key_store_name: Optional[pulumi.Input[str]] = None,
                 key_store_password: Optional[pulumi.Input[str]] = None,
                 trust_anchor_certificate: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomKeyStoreArgs.__new__(CustomKeyStoreArgs)

            if cloud_hsm_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_hsm_cluster_id'")
            __props__.__dict__["cloud_hsm_cluster_id"] = cloud_hsm_cluster_id
            if custom_key_store_name is None and not opts.urn:
                raise TypeError("Missing required property 'custom_key_store_name'")
            __props__.__dict__["custom_key_store_name"] = custom_key_store_name
            if key_store_password is None and not opts.urn:
                raise TypeError("Missing required property 'key_store_password'")
            __props__.__dict__["key_store_password"] = key_store_password
            if trust_anchor_certificate is None and not opts.urn:
                raise TypeError("Missing required property 'trust_anchor_certificate'")
            __props__.__dict__["trust_anchor_certificate"] = trust_anchor_certificate
        super(CustomKeyStore, __self__).__init__(
            'aws:kms/customKeyStore:CustomKeyStore',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cloud_hsm_cluster_id: Optional[pulumi.Input[str]] = None,
            custom_key_store_name: Optional[pulumi.Input[str]] = None,
            key_store_password: Optional[pulumi.Input[str]] = None,
            trust_anchor_certificate: Optional[pulumi.Input[str]] = None) -> 'CustomKeyStore':
        """
        Get an existing CustomKeyStore resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cloud_hsm_cluster_id: Cluster ID of CloudHSM.
        :param pulumi.Input[str] custom_key_store_name: Unique name for Custom Key Store.
        :param pulumi.Input[str] key_store_password: Password for `kmsuser` on CloudHSM.
        :param pulumi.Input[str] trust_anchor_certificate: Customer certificate used for signing on CloudHSM.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomKeyStoreState.__new__(_CustomKeyStoreState)

        __props__.__dict__["cloud_hsm_cluster_id"] = cloud_hsm_cluster_id
        __props__.__dict__["custom_key_store_name"] = custom_key_store_name
        __props__.__dict__["key_store_password"] = key_store_password
        __props__.__dict__["trust_anchor_certificate"] = trust_anchor_certificate
        return CustomKeyStore(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cloudHsmClusterId")
    def cloud_hsm_cluster_id(self) -> pulumi.Output[str]:
        """
        Cluster ID of CloudHSM.
        """
        return pulumi.get(self, "cloud_hsm_cluster_id")

    @property
    @pulumi.getter(name="customKeyStoreName")
    def custom_key_store_name(self) -> pulumi.Output[str]:
        """
        Unique name for Custom Key Store.
        """
        return pulumi.get(self, "custom_key_store_name")

    @property
    @pulumi.getter(name="keyStorePassword")
    def key_store_password(self) -> pulumi.Output[str]:
        """
        Password for `kmsuser` on CloudHSM.
        """
        return pulumi.get(self, "key_store_password")

    @property
    @pulumi.getter(name="trustAnchorCertificate")
    def trust_anchor_certificate(self) -> pulumi.Output[str]:
        """
        Customer certificate used for signing on CloudHSM.
        """
        return pulumi.get(self, "trust_anchor_certificate")

