# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FunctionUrlArgs', 'FunctionUrl']

@pulumi.input_type
class FunctionUrlArgs:
    def __init__(__self__, *,
                 authorization_type: pulumi.Input[str],
                 function_name: pulumi.Input[str],
                 cors: Optional[pulumi.Input['FunctionUrlCorsArgs']] = None,
                 invoke_mode: Optional[pulumi.Input[str]] = None,
                 qualifier: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a FunctionUrl resource.
        :param pulumi.Input[str] authorization_type: The type of authentication that the function URL uses. Set to `"AWS_IAM"` to restrict access to authenticated IAM users only. Set to `"NONE"` to bypass IAM authentication and create a public endpoint. See the [AWS documentation](https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html) for more details.
        :param pulumi.Input[str] function_name: The name (or ARN) of the Lambda function.
        :param pulumi.Input['FunctionUrlCorsArgs'] cors: The [cross-origin resource sharing (CORS)](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) settings for the function URL. Documented below.
        :param pulumi.Input[str] invoke_mode: Determines how the Lambda function responds to an invocation. Valid values are `BUFFERED` (default) and `RESPONSE_STREAM`. See more in [Configuring a Lambda function to stream responses](https://docs.aws.amazon.com/lambda/latest/dg/configuration-response-streaming.html).
        :param pulumi.Input[str] qualifier: The alias name or `"$LATEST"`.
        """
        pulumi.set(__self__, "authorization_type", authorization_type)
        pulumi.set(__self__, "function_name", function_name)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if invoke_mode is not None:
            pulumi.set(__self__, "invoke_mode", invoke_mode)
        if qualifier is not None:
            pulumi.set(__self__, "qualifier", qualifier)

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> pulumi.Input[str]:
        """
        The type of authentication that the function URL uses. Set to `"AWS_IAM"` to restrict access to authenticated IAM users only. Set to `"NONE"` to bypass IAM authentication and create a public endpoint. See the [AWS documentation](https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html) for more details.
        """
        return pulumi.get(self, "authorization_type")

    @authorization_type.setter
    def authorization_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "authorization_type", value)

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Input[str]:
        """
        The name (or ARN) of the Lambda function.
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "function_name", value)

    @property
    @pulumi.getter
    def cors(self) -> Optional[pulumi.Input['FunctionUrlCorsArgs']]:
        """
        The [cross-origin resource sharing (CORS)](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) settings for the function URL. Documented below.
        """
        return pulumi.get(self, "cors")

    @cors.setter
    def cors(self, value: Optional[pulumi.Input['FunctionUrlCorsArgs']]):
        pulumi.set(self, "cors", value)

    @property
    @pulumi.getter(name="invokeMode")
    def invoke_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Determines how the Lambda function responds to an invocation. Valid values are `BUFFERED` (default) and `RESPONSE_STREAM`. See more in [Configuring a Lambda function to stream responses](https://docs.aws.amazon.com/lambda/latest/dg/configuration-response-streaming.html).
        """
        return pulumi.get(self, "invoke_mode")

    @invoke_mode.setter
    def invoke_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "invoke_mode", value)

    @property
    @pulumi.getter
    def qualifier(self) -> Optional[pulumi.Input[str]]:
        """
        The alias name or `"$LATEST"`.
        """
        return pulumi.get(self, "qualifier")

    @qualifier.setter
    def qualifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "qualifier", value)


@pulumi.input_type
class _FunctionUrlState:
    def __init__(__self__, *,
                 authorization_type: Optional[pulumi.Input[str]] = None,
                 cors: Optional[pulumi.Input['FunctionUrlCorsArgs']] = None,
                 function_arn: Optional[pulumi.Input[str]] = None,
                 function_name: Optional[pulumi.Input[str]] = None,
                 function_url: Optional[pulumi.Input[str]] = None,
                 invoke_mode: Optional[pulumi.Input[str]] = None,
                 qualifier: Optional[pulumi.Input[str]] = None,
                 url_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering FunctionUrl resources.
        :param pulumi.Input[str] authorization_type: The type of authentication that the function URL uses. Set to `"AWS_IAM"` to restrict access to authenticated IAM users only. Set to `"NONE"` to bypass IAM authentication and create a public endpoint. See the [AWS documentation](https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html) for more details.
        :param pulumi.Input['FunctionUrlCorsArgs'] cors: The [cross-origin resource sharing (CORS)](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) settings for the function URL. Documented below.
        :param pulumi.Input[str] function_arn: The Amazon Resource Name (ARN) of the function.
        :param pulumi.Input[str] function_name: The name (or ARN) of the Lambda function.
        :param pulumi.Input[str] function_url: The HTTP URL endpoint for the function in the format `https://<url_id>.lambda-url.<region>.on.aws/`.
        :param pulumi.Input[str] invoke_mode: Determines how the Lambda function responds to an invocation. Valid values are `BUFFERED` (default) and `RESPONSE_STREAM`. See more in [Configuring a Lambda function to stream responses](https://docs.aws.amazon.com/lambda/latest/dg/configuration-response-streaming.html).
        :param pulumi.Input[str] qualifier: The alias name or `"$LATEST"`.
        :param pulumi.Input[str] url_id: A generated ID for the endpoint.
        """
        if authorization_type is not None:
            pulumi.set(__self__, "authorization_type", authorization_type)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if function_arn is not None:
            pulumi.set(__self__, "function_arn", function_arn)
        if function_name is not None:
            pulumi.set(__self__, "function_name", function_name)
        if function_url is not None:
            pulumi.set(__self__, "function_url", function_url)
        if invoke_mode is not None:
            pulumi.set(__self__, "invoke_mode", invoke_mode)
        if qualifier is not None:
            pulumi.set(__self__, "qualifier", qualifier)
        if url_id is not None:
            pulumi.set(__self__, "url_id", url_id)

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of authentication that the function URL uses. Set to `"AWS_IAM"` to restrict access to authenticated IAM users only. Set to `"NONE"` to bypass IAM authentication and create a public endpoint. See the [AWS documentation](https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html) for more details.
        """
        return pulumi.get(self, "authorization_type")

    @authorization_type.setter
    def authorization_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization_type", value)

    @property
    @pulumi.getter
    def cors(self) -> Optional[pulumi.Input['FunctionUrlCorsArgs']]:
        """
        The [cross-origin resource sharing (CORS)](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) settings for the function URL. Documented below.
        """
        return pulumi.get(self, "cors")

    @cors.setter
    def cors(self, value: Optional[pulumi.Input['FunctionUrlCorsArgs']]):
        pulumi.set(self, "cors", value)

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the function.
        """
        return pulumi.get(self, "function_arn")

    @function_arn.setter
    def function_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_arn", value)

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name (or ARN) of the Lambda function.
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_name", value)

    @property
    @pulumi.getter(name="functionUrl")
    def function_url(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP URL endpoint for the function in the format `https://<url_id>.lambda-url.<region>.on.aws/`.
        """
        return pulumi.get(self, "function_url")

    @function_url.setter
    def function_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_url", value)

    @property
    @pulumi.getter(name="invokeMode")
    def invoke_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Determines how the Lambda function responds to an invocation. Valid values are `BUFFERED` (default) and `RESPONSE_STREAM`. See more in [Configuring a Lambda function to stream responses](https://docs.aws.amazon.com/lambda/latest/dg/configuration-response-streaming.html).
        """
        return pulumi.get(self, "invoke_mode")

    @invoke_mode.setter
    def invoke_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "invoke_mode", value)

    @property
    @pulumi.getter
    def qualifier(self) -> Optional[pulumi.Input[str]]:
        """
        The alias name or `"$LATEST"`.
        """
        return pulumi.get(self, "qualifier")

    @qualifier.setter
    def qualifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "qualifier", value)

    @property
    @pulumi.getter(name="urlId")
    def url_id(self) -> Optional[pulumi.Input[str]]:
        """
        A generated ID for the endpoint.
        """
        return pulumi.get(self, "url_id")

    @url_id.setter
    def url_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url_id", value)


class FunctionUrl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization_type: Optional[pulumi.Input[str]] = None,
                 cors: Optional[pulumi.Input[pulumi.InputType['FunctionUrlCorsArgs']]] = None,
                 function_name: Optional[pulumi.Input[str]] = None,
                 invoke_mode: Optional[pulumi.Input[str]] = None,
                 qualifier: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Lambda function URL resource. A function URL is a dedicated HTTP(S) endpoint for a Lambda function.

        See the [AWS Lambda documentation](https://docs.aws.amazon.com/lambda/latest/dg/lambda-urls.html) for more information.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        test_latest = aws.lambda_.FunctionUrl("test_latest",
            function_name=test["functionName"],
            authorization_type="NONE")
        test_live = aws.lambda_.FunctionUrl("test_live",
            function_name=test["functionName"],
            qualifier="my_alias",
            authorization_type="AWS_IAM",
            cors=aws.lambda_.FunctionUrlCorsArgs(
                allow_credentials=True,
                allow_origins=["*"],
                allow_methods=["*"],
                allow_headers=[
                    "date",
                    "keep-alive",
                ],
                expose_headers=[
                    "keep-alive",
                    "date",
                ],
                max_age=86400,
            ))
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Lambda function URLs using the `function_name` or `function_name/qualifier`. For example:

        ```sh
        $ pulumi import aws:lambda/functionUrl:FunctionUrl test_lambda_url my_test_lambda_function
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] authorization_type: The type of authentication that the function URL uses. Set to `"AWS_IAM"` to restrict access to authenticated IAM users only. Set to `"NONE"` to bypass IAM authentication and create a public endpoint. See the [AWS documentation](https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html) for more details.
        :param pulumi.Input[pulumi.InputType['FunctionUrlCorsArgs']] cors: The [cross-origin resource sharing (CORS)](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) settings for the function URL. Documented below.
        :param pulumi.Input[str] function_name: The name (or ARN) of the Lambda function.
        :param pulumi.Input[str] invoke_mode: Determines how the Lambda function responds to an invocation. Valid values are `BUFFERED` (default) and `RESPONSE_STREAM`. See more in [Configuring a Lambda function to stream responses](https://docs.aws.amazon.com/lambda/latest/dg/configuration-response-streaming.html).
        :param pulumi.Input[str] qualifier: The alias name or `"$LATEST"`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FunctionUrlArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Lambda function URL resource. A function URL is a dedicated HTTP(S) endpoint for a Lambda function.

        See the [AWS Lambda documentation](https://docs.aws.amazon.com/lambda/latest/dg/lambda-urls.html) for more information.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        test_latest = aws.lambda_.FunctionUrl("test_latest",
            function_name=test["functionName"],
            authorization_type="NONE")
        test_live = aws.lambda_.FunctionUrl("test_live",
            function_name=test["functionName"],
            qualifier="my_alias",
            authorization_type="AWS_IAM",
            cors=aws.lambda_.FunctionUrlCorsArgs(
                allow_credentials=True,
                allow_origins=["*"],
                allow_methods=["*"],
                allow_headers=[
                    "date",
                    "keep-alive",
                ],
                expose_headers=[
                    "keep-alive",
                    "date",
                ],
                max_age=86400,
            ))
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Lambda function URLs using the `function_name` or `function_name/qualifier`. For example:

        ```sh
        $ pulumi import aws:lambda/functionUrl:FunctionUrl test_lambda_url my_test_lambda_function
        ```

        :param str resource_name: The name of the resource.
        :param FunctionUrlArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FunctionUrlArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization_type: Optional[pulumi.Input[str]] = None,
                 cors: Optional[pulumi.Input[pulumi.InputType['FunctionUrlCorsArgs']]] = None,
                 function_name: Optional[pulumi.Input[str]] = None,
                 invoke_mode: Optional[pulumi.Input[str]] = None,
                 qualifier: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FunctionUrlArgs.__new__(FunctionUrlArgs)

            if authorization_type is None and not opts.urn:
                raise TypeError("Missing required property 'authorization_type'")
            __props__.__dict__["authorization_type"] = authorization_type
            __props__.__dict__["cors"] = cors
            if function_name is None and not opts.urn:
                raise TypeError("Missing required property 'function_name'")
            __props__.__dict__["function_name"] = function_name
            __props__.__dict__["invoke_mode"] = invoke_mode
            __props__.__dict__["qualifier"] = qualifier
            __props__.__dict__["function_arn"] = None
            __props__.__dict__["function_url"] = None
            __props__.__dict__["url_id"] = None
        super(FunctionUrl, __self__).__init__(
            'aws:lambda/functionUrl:FunctionUrl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authorization_type: Optional[pulumi.Input[str]] = None,
            cors: Optional[pulumi.Input[pulumi.InputType['FunctionUrlCorsArgs']]] = None,
            function_arn: Optional[pulumi.Input[str]] = None,
            function_name: Optional[pulumi.Input[str]] = None,
            function_url: Optional[pulumi.Input[str]] = None,
            invoke_mode: Optional[pulumi.Input[str]] = None,
            qualifier: Optional[pulumi.Input[str]] = None,
            url_id: Optional[pulumi.Input[str]] = None) -> 'FunctionUrl':
        """
        Get an existing FunctionUrl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] authorization_type: The type of authentication that the function URL uses. Set to `"AWS_IAM"` to restrict access to authenticated IAM users only. Set to `"NONE"` to bypass IAM authentication and create a public endpoint. See the [AWS documentation](https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html) for more details.
        :param pulumi.Input[pulumi.InputType['FunctionUrlCorsArgs']] cors: The [cross-origin resource sharing (CORS)](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) settings for the function URL. Documented below.
        :param pulumi.Input[str] function_arn: The Amazon Resource Name (ARN) of the function.
        :param pulumi.Input[str] function_name: The name (or ARN) of the Lambda function.
        :param pulumi.Input[str] function_url: The HTTP URL endpoint for the function in the format `https://<url_id>.lambda-url.<region>.on.aws/`.
        :param pulumi.Input[str] invoke_mode: Determines how the Lambda function responds to an invocation. Valid values are `BUFFERED` (default) and `RESPONSE_STREAM`. See more in [Configuring a Lambda function to stream responses](https://docs.aws.amazon.com/lambda/latest/dg/configuration-response-streaming.html).
        :param pulumi.Input[str] qualifier: The alias name or `"$LATEST"`.
        :param pulumi.Input[str] url_id: A generated ID for the endpoint.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FunctionUrlState.__new__(_FunctionUrlState)

        __props__.__dict__["authorization_type"] = authorization_type
        __props__.__dict__["cors"] = cors
        __props__.__dict__["function_arn"] = function_arn
        __props__.__dict__["function_name"] = function_name
        __props__.__dict__["function_url"] = function_url
        __props__.__dict__["invoke_mode"] = invoke_mode
        __props__.__dict__["qualifier"] = qualifier
        __props__.__dict__["url_id"] = url_id
        return FunctionUrl(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> pulumi.Output[str]:
        """
        The type of authentication that the function URL uses. Set to `"AWS_IAM"` to restrict access to authenticated IAM users only. Set to `"NONE"` to bypass IAM authentication and create a public endpoint. See the [AWS documentation](https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html) for more details.
        """
        return pulumi.get(self, "authorization_type")

    @property
    @pulumi.getter
    def cors(self) -> pulumi.Output[Optional['outputs.FunctionUrlCors']]:
        """
        The [cross-origin resource sharing (CORS)](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) settings for the function URL. Documented below.
        """
        return pulumi.get(self, "cors")

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the function.
        """
        return pulumi.get(self, "function_arn")

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Output[str]:
        """
        The name (or ARN) of the Lambda function.
        """
        return pulumi.get(self, "function_name")

    @property
    @pulumi.getter(name="functionUrl")
    def function_url(self) -> pulumi.Output[str]:
        """
        The HTTP URL endpoint for the function in the format `https://<url_id>.lambda-url.<region>.on.aws/`.
        """
        return pulumi.get(self, "function_url")

    @property
    @pulumi.getter(name="invokeMode")
    def invoke_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Determines how the Lambda function responds to an invocation. Valid values are `BUFFERED` (default) and `RESPONSE_STREAM`. See more in [Configuring a Lambda function to stream responses](https://docs.aws.amazon.com/lambda/latest/dg/configuration-response-streaming.html).
        """
        return pulumi.get(self, "invoke_mode")

    @property
    @pulumi.getter
    def qualifier(self) -> pulumi.Output[Optional[str]]:
        """
        The alias name or `"$LATEST"`.
        """
        return pulumi.get(self, "qualifier")

    @property
    @pulumi.getter(name="urlId")
    def url_id(self) -> pulumi.Output[str]:
        """
        A generated ID for the endpoint.
        """
        return pulumi.get(self, "url_id")

