# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AliasRoutingConfig',
    'CodeSigningConfigAllowedPublishers',
    'CodeSigningConfigPolicies',
    'EventSourceMappingAmazonManagedKafkaEventSourceConfig',
    'EventSourceMappingDestinationConfig',
    'EventSourceMappingDestinationConfigOnFailure',
    'EventSourceMappingDocumentDbEventSourceConfig',
    'EventSourceMappingFilterCriteria',
    'EventSourceMappingFilterCriteriaFilter',
    'EventSourceMappingScalingConfig',
    'EventSourceMappingSelfManagedEventSource',
    'EventSourceMappingSelfManagedKafkaEventSourceConfig',
    'EventSourceMappingSourceAccessConfiguration',
    'FunctionDeadLetterConfig',
    'FunctionEnvironment',
    'FunctionEphemeralStorage',
    'FunctionEventInvokeConfigDestinationConfig',
    'FunctionEventInvokeConfigDestinationConfigOnFailure',
    'FunctionEventInvokeConfigDestinationConfigOnSuccess',
    'FunctionFileSystemConfig',
    'FunctionImageConfig',
    'FunctionLoggingConfig',
    'FunctionSnapStart',
    'FunctionTracingConfig',
    'FunctionUrlCors',
    'FunctionVpcConfig',
    'GetCodeSigningConfigAllowedPublisherResult',
    'GetCodeSigningConfigPolicyResult',
    'GetFunctionDeadLetterConfigResult',
    'GetFunctionEnvironmentResult',
    'GetFunctionEphemeralStorageResult',
    'GetFunctionFileSystemConfigResult',
    'GetFunctionLoggingConfigResult',
    'GetFunctionTracingConfigResult',
    'GetFunctionUrlCorResult',
    'GetFunctionVpcConfigResult',
]

@pulumi.output_type
class AliasRoutingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalVersionWeights":
            suggest = "additional_version_weights"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AliasRoutingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AliasRoutingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AliasRoutingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_version_weights: Optional[Mapping[str, float]] = None):
        """
        :param Mapping[str, float] additional_version_weights: A map that defines the proportion of events that should be sent to different versions of a lambda function.
        """
        if additional_version_weights is not None:
            pulumi.set(__self__, "additional_version_weights", additional_version_weights)

    @property
    @pulumi.getter(name="additionalVersionWeights")
    def additional_version_weights(self) -> Optional[Mapping[str, float]]:
        """
        A map that defines the proportion of events that should be sent to different versions of a lambda function.
        """
        return pulumi.get(self, "additional_version_weights")


@pulumi.output_type
class CodeSigningConfigAllowedPublishers(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "signingProfileVersionArns":
            suggest = "signing_profile_version_arns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CodeSigningConfigAllowedPublishers. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CodeSigningConfigAllowedPublishers.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CodeSigningConfigAllowedPublishers.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 signing_profile_version_arns: Sequence[str]):
        """
        :param Sequence[str] signing_profile_version_arns: The Amazon Resource Name (ARN) for each of the signing profiles. A signing profile defines a trusted user who can sign a code package.
        """
        pulumi.set(__self__, "signing_profile_version_arns", signing_profile_version_arns)

    @property
    @pulumi.getter(name="signingProfileVersionArns")
    def signing_profile_version_arns(self) -> Sequence[str]:
        """
        The Amazon Resource Name (ARN) for each of the signing profiles. A signing profile defines a trusted user who can sign a code package.
        """
        return pulumi.get(self, "signing_profile_version_arns")


@pulumi.output_type
class CodeSigningConfigPolicies(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "untrustedArtifactOnDeployment":
            suggest = "untrusted_artifact_on_deployment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CodeSigningConfigPolicies. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CodeSigningConfigPolicies.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CodeSigningConfigPolicies.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 untrusted_artifact_on_deployment: str):
        """
        :param str untrusted_artifact_on_deployment: Code signing configuration policy for deployment validation failure. If you set the policy to Enforce, Lambda blocks the deployment request if code-signing validation checks fail. If you set the policy to Warn, Lambda allows the deployment and creates a CloudWatch log. Valid values: `Warn`, `Enforce`. Default value: `Warn`.
        """
        pulumi.set(__self__, "untrusted_artifact_on_deployment", untrusted_artifact_on_deployment)

    @property
    @pulumi.getter(name="untrustedArtifactOnDeployment")
    def untrusted_artifact_on_deployment(self) -> str:
        """
        Code signing configuration policy for deployment validation failure. If you set the policy to Enforce, Lambda blocks the deployment request if code-signing validation checks fail. If you set the policy to Warn, Lambda allows the deployment and creates a CloudWatch log. Valid values: `Warn`, `Enforce`. Default value: `Warn`.
        """
        return pulumi.get(self, "untrusted_artifact_on_deployment")


@pulumi.output_type
class EventSourceMappingAmazonManagedKafkaEventSourceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consumerGroupId":
            suggest = "consumer_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSourceMappingAmazonManagedKafkaEventSourceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSourceMappingAmazonManagedKafkaEventSourceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSourceMappingAmazonManagedKafkaEventSourceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consumer_group_id: Optional[str] = None):
        """
        :param str consumer_group_id: A Kafka consumer group ID between 1 and 200 characters for use when creating this event source mapping. If one is not specified, this value will be automatically generated. See [AmazonManagedKafkaEventSourceConfig Syntax](https://docs.aws.amazon.com/lambda/latest/dg/API_AmazonManagedKafkaEventSourceConfig.html).
        """
        if consumer_group_id is not None:
            pulumi.set(__self__, "consumer_group_id", consumer_group_id)

    @property
    @pulumi.getter(name="consumerGroupId")
    def consumer_group_id(self) -> Optional[str]:
        """
        A Kafka consumer group ID between 1 and 200 characters for use when creating this event source mapping. If one is not specified, this value will be automatically generated. See [AmazonManagedKafkaEventSourceConfig Syntax](https://docs.aws.amazon.com/lambda/latest/dg/API_AmazonManagedKafkaEventSourceConfig.html).
        """
        return pulumi.get(self, "consumer_group_id")


@pulumi.output_type
class EventSourceMappingDestinationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onFailure":
            suggest = "on_failure"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSourceMappingDestinationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSourceMappingDestinationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSourceMappingDestinationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 on_failure: Optional['outputs.EventSourceMappingDestinationConfigOnFailure'] = None):
        """
        :param 'EventSourceMappingDestinationConfigOnFailureArgs' on_failure: The destination configuration for failed invocations. Detailed below.
        """
        if on_failure is not None:
            pulumi.set(__self__, "on_failure", on_failure)

    @property
    @pulumi.getter(name="onFailure")
    def on_failure(self) -> Optional['outputs.EventSourceMappingDestinationConfigOnFailure']:
        """
        The destination configuration for failed invocations. Detailed below.
        """
        return pulumi.get(self, "on_failure")


@pulumi.output_type
class EventSourceMappingDestinationConfigOnFailure(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationArn":
            suggest = "destination_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSourceMappingDestinationConfigOnFailure. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSourceMappingDestinationConfigOnFailure.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSourceMappingDestinationConfigOnFailure.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_arn: str):
        """
        :param str destination_arn: The Amazon Resource Name (ARN) of the destination resource.
        """
        pulumi.set(__self__, "destination_arn", destination_arn)

    @property
    @pulumi.getter(name="destinationArn")
    def destination_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the destination resource.
        """
        return pulumi.get(self, "destination_arn")


@pulumi.output_type
class EventSourceMappingDocumentDbEventSourceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "collectionName":
            suggest = "collection_name"
        elif key == "fullDocument":
            suggest = "full_document"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSourceMappingDocumentDbEventSourceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSourceMappingDocumentDbEventSourceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSourceMappingDocumentDbEventSourceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: str,
                 collection_name: Optional[str] = None,
                 full_document: Optional[str] = None):
        """
        :param str database_name: The name of the database to consume within the DocumentDB cluster.
        :param str collection_name: The name of the collection to consume within the database. If you do not specify a collection, Lambda consumes all collections.
        :param str full_document: Determines what DocumentDB sends to your event stream during document update operations. If set to `UpdateLookup`, DocumentDB sends a delta describing the changes, along with a copy of the entire document. Otherwise, DocumentDB sends only a partial document that contains the changes. Valid values: `UpdateLookup`, `Default`.
        """
        pulumi.set(__self__, "database_name", database_name)
        if collection_name is not None:
            pulumi.set(__self__, "collection_name", collection_name)
        if full_document is not None:
            pulumi.set(__self__, "full_document", full_document)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        The name of the database to consume within the DocumentDB cluster.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="collectionName")
    def collection_name(self) -> Optional[str]:
        """
        The name of the collection to consume within the database. If you do not specify a collection, Lambda consumes all collections.
        """
        return pulumi.get(self, "collection_name")

    @property
    @pulumi.getter(name="fullDocument")
    def full_document(self) -> Optional[str]:
        """
        Determines what DocumentDB sends to your event stream during document update operations. If set to `UpdateLookup`, DocumentDB sends a delta describing the changes, along with a copy of the entire document. Otherwise, DocumentDB sends only a partial document that contains the changes. Valid values: `UpdateLookup`, `Default`.
        """
        return pulumi.get(self, "full_document")


@pulumi.output_type
class EventSourceMappingFilterCriteria(dict):
    def __init__(__self__, *,
                 filters: Optional[Sequence['outputs.EventSourceMappingFilterCriteriaFilter']] = None):
        """
        :param Sequence['EventSourceMappingFilterCriteriaFilterArgs'] filters: A set of up to 5 filter. If an event satisfies at least one, Lambda sends the event to the function or adds it to the next batch. Detailed below.
        """
        if filters is not None:
            pulumi.set(__self__, "filters", filters)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.EventSourceMappingFilterCriteriaFilter']]:
        """
        A set of up to 5 filter. If an event satisfies at least one, Lambda sends the event to the function or adds it to the next batch. Detailed below.
        """
        return pulumi.get(self, "filters")


@pulumi.output_type
class EventSourceMappingFilterCriteriaFilter(dict):
    def __init__(__self__, *,
                 pattern: Optional[str] = None):
        """
        :param str pattern: A filter pattern up to 4096 characters. See [Filter Rule Syntax](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html#filtering-syntax).
        """
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)

    @property
    @pulumi.getter
    def pattern(self) -> Optional[str]:
        """
        A filter pattern up to 4096 characters. See [Filter Rule Syntax](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html#filtering-syntax).
        """
        return pulumi.get(self, "pattern")


@pulumi.output_type
class EventSourceMappingScalingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumConcurrency":
            suggest = "maximum_concurrency"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSourceMappingScalingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSourceMappingScalingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSourceMappingScalingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maximum_concurrency: Optional[int] = None):
        """
        :param int maximum_concurrency: Limits the number of concurrent instances that the Amazon SQS event source can invoke. Must be between `2` and `1000`. See [Configuring maximum concurrency for Amazon SQS event sources](https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency).
        """
        if maximum_concurrency is not None:
            pulumi.set(__self__, "maximum_concurrency", maximum_concurrency)

    @property
    @pulumi.getter(name="maximumConcurrency")
    def maximum_concurrency(self) -> Optional[int]:
        """
        Limits the number of concurrent instances that the Amazon SQS event source can invoke. Must be between `2` and `1000`. See [Configuring maximum concurrency for Amazon SQS event sources](https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency).
        """
        return pulumi.get(self, "maximum_concurrency")


@pulumi.output_type
class EventSourceMappingSelfManagedEventSource(dict):
    def __init__(__self__, *,
                 endpoints: Mapping[str, str]):
        """
        :param Mapping[str, str] endpoints: A map of endpoints for the self managed source.  For Kafka self-managed sources, the key should be `KAFKA_BOOTSTRAP_SERVERS` and the value should be a string with a comma separated list of broker endpoints.
        """
        pulumi.set(__self__, "endpoints", endpoints)

    @property
    @pulumi.getter
    def endpoints(self) -> Mapping[str, str]:
        """
        A map of endpoints for the self managed source.  For Kafka self-managed sources, the key should be `KAFKA_BOOTSTRAP_SERVERS` and the value should be a string with a comma separated list of broker endpoints.
        """
        return pulumi.get(self, "endpoints")


@pulumi.output_type
class EventSourceMappingSelfManagedKafkaEventSourceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consumerGroupId":
            suggest = "consumer_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSourceMappingSelfManagedKafkaEventSourceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSourceMappingSelfManagedKafkaEventSourceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSourceMappingSelfManagedKafkaEventSourceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consumer_group_id: Optional[str] = None):
        """
        :param str consumer_group_id: A Kafka consumer group ID between 1 and 200 characters for use when creating this event source mapping. If one is not specified, this value will be automatically generated. See [SelfManagedKafkaEventSourceConfig Syntax](https://docs.aws.amazon.com/lambda/latest/dg/API_SelfManagedKafkaEventSourceConfig.html).
        """
        if consumer_group_id is not None:
            pulumi.set(__self__, "consumer_group_id", consumer_group_id)

    @property
    @pulumi.getter(name="consumerGroupId")
    def consumer_group_id(self) -> Optional[str]:
        """
        A Kafka consumer group ID between 1 and 200 characters for use when creating this event source mapping. If one is not specified, this value will be automatically generated. See [SelfManagedKafkaEventSourceConfig Syntax](https://docs.aws.amazon.com/lambda/latest/dg/API_SelfManagedKafkaEventSourceConfig.html).
        """
        return pulumi.get(self, "consumer_group_id")


@pulumi.output_type
class EventSourceMappingSourceAccessConfiguration(dict):
    def __init__(__self__, *,
                 type: str,
                 uri: str):
        """
        :param str type: The type of authentication protocol, VPC components, or virtual host for your event source. For valid values, refer to the [AWS documentation](https://docs.aws.amazon.com/lambda/latest/api/API_SourceAccessConfiguration.html).
        :param str uri: The URI for this configuration.  For type `VPC_SUBNET` the value should be `subnet:subnet_id` where `subnet_id` is the value you would find in an ec2.Subnet resource's id attribute.  For type `VPC_SECURITY_GROUP` the value should be `security_group:security_group_id` where `security_group_id` is the value you would find in an ec2.SecurityGroup resource's id attribute.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of authentication protocol, VPC components, or virtual host for your event source. For valid values, refer to the [AWS documentation](https://docs.aws.amazon.com/lambda/latest/api/API_SourceAccessConfiguration.html).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        The URI for this configuration.  For type `VPC_SUBNET` the value should be `subnet:subnet_id` where `subnet_id` is the value you would find in an ec2.Subnet resource's id attribute.  For type `VPC_SECURITY_GROUP` the value should be `security_group:security_group_id` where `security_group_id` is the value you would find in an ec2.SecurityGroup resource's id attribute.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class FunctionDeadLetterConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetArn":
            suggest = "target_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionDeadLetterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionDeadLetterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionDeadLetterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_arn: str):
        """
        :param str target_arn: ARN of an SNS topic or SQS queue to notify when an invocation fails. If this option is used, the function's IAM role must be granted suitable access to write to the target object, which means allowing either the `sns:Publish` or `sqs:SendMessage` action on this ARN, depending on which service is targeted.
        """
        pulumi.set(__self__, "target_arn", target_arn)

    @property
    @pulumi.getter(name="targetArn")
    def target_arn(self) -> str:
        """
        ARN of an SNS topic or SQS queue to notify when an invocation fails. If this option is used, the function's IAM role must be granted suitable access to write to the target object, which means allowing either the `sns:Publish` or `sqs:SendMessage` action on this ARN, depending on which service is targeted.
        """
        return pulumi.get(self, "target_arn")


@pulumi.output_type
class FunctionEnvironment(dict):
    def __init__(__self__, *,
                 variables: Optional[Mapping[str, str]] = None):
        """
        :param Mapping[str, str] variables: Map of environment variables that are accessible from the function code during execution. If provided at least one key must be present.
        """
        if variables is not None:
            pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter
    def variables(self) -> Optional[Mapping[str, str]]:
        """
        Map of environment variables that are accessible from the function code during execution. If provided at least one key must be present.
        """
        return pulumi.get(self, "variables")


@pulumi.output_type
class FunctionEphemeralStorage(dict):
    def __init__(__self__, *,
                 size: Optional[int] = None):
        """
        :param int size: The size of the Lambda function Ephemeral storage(`/tmp`) represented in MB. The minimum supported `ephemeral_storage` value defaults to `512`MB and the maximum supported value is `10240`MB.
        """
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def size(self) -> Optional[int]:
        """
        The size of the Lambda function Ephemeral storage(`/tmp`) represented in MB. The minimum supported `ephemeral_storage` value defaults to `512`MB and the maximum supported value is `10240`MB.
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class FunctionEventInvokeConfigDestinationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onFailure":
            suggest = "on_failure"
        elif key == "onSuccess":
            suggest = "on_success"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionEventInvokeConfigDestinationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionEventInvokeConfigDestinationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionEventInvokeConfigDestinationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 on_failure: Optional['outputs.FunctionEventInvokeConfigDestinationConfigOnFailure'] = None,
                 on_success: Optional['outputs.FunctionEventInvokeConfigDestinationConfigOnSuccess'] = None):
        """
        :param 'FunctionEventInvokeConfigDestinationConfigOnFailureArgs' on_failure: Configuration block with destination configuration for failed asynchronous invocations. See below for details.
        :param 'FunctionEventInvokeConfigDestinationConfigOnSuccessArgs' on_success: Configuration block with destination configuration for successful asynchronous invocations. See below for details.
        """
        if on_failure is not None:
            pulumi.set(__self__, "on_failure", on_failure)
        if on_success is not None:
            pulumi.set(__self__, "on_success", on_success)

    @property
    @pulumi.getter(name="onFailure")
    def on_failure(self) -> Optional['outputs.FunctionEventInvokeConfigDestinationConfigOnFailure']:
        """
        Configuration block with destination configuration for failed asynchronous invocations. See below for details.
        """
        return pulumi.get(self, "on_failure")

    @property
    @pulumi.getter(name="onSuccess")
    def on_success(self) -> Optional['outputs.FunctionEventInvokeConfigDestinationConfigOnSuccess']:
        """
        Configuration block with destination configuration for successful asynchronous invocations. See below for details.
        """
        return pulumi.get(self, "on_success")


@pulumi.output_type
class FunctionEventInvokeConfigDestinationConfigOnFailure(dict):
    def __init__(__self__, *,
                 destination: str):
        """
        :param str destination: Amazon Resource Name (ARN) of the destination resource. See the [Lambda Developer Guide](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-async-destinations) for acceptable resource types and associated IAM permissions.
        """
        pulumi.set(__self__, "destination", destination)

    @property
    @pulumi.getter
    def destination(self) -> str:
        """
        Amazon Resource Name (ARN) of the destination resource. See the [Lambda Developer Guide](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-async-destinations) for acceptable resource types and associated IAM permissions.
        """
        return pulumi.get(self, "destination")


@pulumi.output_type
class FunctionEventInvokeConfigDestinationConfigOnSuccess(dict):
    def __init__(__self__, *,
                 destination: str):
        """
        :param str destination: Amazon Resource Name (ARN) of the destination resource. See the [Lambda Developer Guide](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-async-destinations) for acceptable resource types and associated IAM permissions.
        """
        pulumi.set(__self__, "destination", destination)

    @property
    @pulumi.getter
    def destination(self) -> str:
        """
        Amazon Resource Name (ARN) of the destination resource. See the [Lambda Developer Guide](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-async-destinations) for acceptable resource types and associated IAM permissions.
        """
        return pulumi.get(self, "destination")


@pulumi.output_type
class FunctionFileSystemConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localMountPath":
            suggest = "local_mount_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionFileSystemConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionFileSystemConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionFileSystemConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arn: str,
                 local_mount_path: str):
        """
        :param str arn: Amazon Resource Name (ARN) of the Amazon EFS Access Point that provides access to the file system.
        :param str local_mount_path: Path where the function can access the file system, starting with /mnt/.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "local_mount_path", local_mount_path)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        Amazon Resource Name (ARN) of the Amazon EFS Access Point that provides access to the file system.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="localMountPath")
    def local_mount_path(self) -> str:
        """
        Path where the function can access the file system, starting with /mnt/.
        """
        return pulumi.get(self, "local_mount_path")


@pulumi.output_type
class FunctionImageConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entryPoints":
            suggest = "entry_points"
        elif key == "workingDirectory":
            suggest = "working_directory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionImageConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionImageConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionImageConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 commands: Optional[Sequence[str]] = None,
                 entry_points: Optional[Sequence[str]] = None,
                 working_directory: Optional[str] = None):
        """
        :param Sequence[str] commands: Parameters that you want to pass in with `entry_point`.
        :param Sequence[str] entry_points: Entry point to your application, which is typically the location of the runtime executable.
        :param str working_directory: Working directory.
        """
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if entry_points is not None:
            pulumi.set(__self__, "entry_points", entry_points)
        if working_directory is not None:
            pulumi.set(__self__, "working_directory", working_directory)

    @property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[str]]:
        """
        Parameters that you want to pass in with `entry_point`.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter(name="entryPoints")
    def entry_points(self) -> Optional[Sequence[str]]:
        """
        Entry point to your application, which is typically the location of the runtime executable.
        """
        return pulumi.get(self, "entry_points")

    @property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> Optional[str]:
        """
        Working directory.
        """
        return pulumi.get(self, "working_directory")


@pulumi.output_type
class FunctionLoggingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logFormat":
            suggest = "log_format"
        elif key == "applicationLogLevel":
            suggest = "application_log_level"
        elif key == "logGroup":
            suggest = "log_group"
        elif key == "systemLogLevel":
            suggest = "system_log_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionLoggingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionLoggingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionLoggingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_format: str,
                 application_log_level: Optional[str] = None,
                 log_group: Optional[str] = None,
                 system_log_level: Optional[str] = None):
        """
        :param str log_format: select between `Text` and structured `JSON` format for your function's logs.
        :param str application_log_level: for JSON structured logs, choose the detail level of the logs your application sends to CloudWatch when using supported logging libraries.
        :param str log_group: the CloudWatch log group your function sends logs to.
        :param str system_log_level: for JSON structured logs, choose the detail level of the Lambda platform event logs sent to CloudWatch, such as `ERROR`, `DEBUG`, or `INFO`.
        """
        pulumi.set(__self__, "log_format", log_format)
        if application_log_level is not None:
            pulumi.set(__self__, "application_log_level", application_log_level)
        if log_group is not None:
            pulumi.set(__self__, "log_group", log_group)
        if system_log_level is not None:
            pulumi.set(__self__, "system_log_level", system_log_level)

    @property
    @pulumi.getter(name="logFormat")
    def log_format(self) -> str:
        """
        select between `Text` and structured `JSON` format for your function's logs.
        """
        return pulumi.get(self, "log_format")

    @property
    @pulumi.getter(name="applicationLogLevel")
    def application_log_level(self) -> Optional[str]:
        """
        for JSON structured logs, choose the detail level of the logs your application sends to CloudWatch when using supported logging libraries.
        """
        return pulumi.get(self, "application_log_level")

    @property
    @pulumi.getter(name="logGroup")
    def log_group(self) -> Optional[str]:
        """
        the CloudWatch log group your function sends logs to.
        """
        return pulumi.get(self, "log_group")

    @property
    @pulumi.getter(name="systemLogLevel")
    def system_log_level(self) -> Optional[str]:
        """
        for JSON structured logs, choose the detail level of the Lambda platform event logs sent to CloudWatch, such as `ERROR`, `DEBUG`, or `INFO`.
        """
        return pulumi.get(self, "system_log_level")


@pulumi.output_type
class FunctionSnapStart(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applyOn":
            suggest = "apply_on"
        elif key == "optimizationStatus":
            suggest = "optimization_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionSnapStart. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionSnapStart.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionSnapStart.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 apply_on: str,
                 optimization_status: Optional[str] = None):
        """
        :param str apply_on: Conditions where snap start is enabled. Valid values are `PublishedVersions`.
        """
        pulumi.set(__self__, "apply_on", apply_on)
        if optimization_status is not None:
            pulumi.set(__self__, "optimization_status", optimization_status)

    @property
    @pulumi.getter(name="applyOn")
    def apply_on(self) -> str:
        """
        Conditions where snap start is enabled. Valid values are `PublishedVersions`.
        """
        return pulumi.get(self, "apply_on")

    @property
    @pulumi.getter(name="optimizationStatus")
    def optimization_status(self) -> Optional[str]:
        return pulumi.get(self, "optimization_status")


@pulumi.output_type
class FunctionTracingConfig(dict):
    def __init__(__self__, *,
                 mode: str):
        """
        :param str mode: Whether to sample and trace a subset of incoming requests with AWS X-Ray. Valid values are `PassThrough` and `Active`. If `PassThrough`, Lambda will only trace the request from an upstream service if it contains a tracing header with "sampled=1". If `Active`, Lambda will respect any tracing header it receives from an upstream service. If no tracing header is received, Lambda will call X-Ray for a tracing decision.
        """
        pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Whether to sample and trace a subset of incoming requests with AWS X-Ray. Valid values are `PassThrough` and `Active`. If `PassThrough`, Lambda will only trace the request from an upstream service if it contains a tracing header with "sampled=1". If `Active`, Lambda will respect any tracing header it receives from an upstream service. If no tracing header is received, Lambda will call X-Ray for a tracing decision.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class FunctionUrlCors(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowCredentials":
            suggest = "allow_credentials"
        elif key == "allowHeaders":
            suggest = "allow_headers"
        elif key == "allowMethods":
            suggest = "allow_methods"
        elif key == "allowOrigins":
            suggest = "allow_origins"
        elif key == "exposeHeaders":
            suggest = "expose_headers"
        elif key == "maxAge":
            suggest = "max_age"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionUrlCors. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionUrlCors.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionUrlCors.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_credentials: Optional[bool] = None,
                 allow_headers: Optional[Sequence[str]] = None,
                 allow_methods: Optional[Sequence[str]] = None,
                 allow_origins: Optional[Sequence[str]] = None,
                 expose_headers: Optional[Sequence[str]] = None,
                 max_age: Optional[int] = None):
        """
        :param bool allow_credentials: Whether to allow cookies or other credentials in requests to the function URL. The default is `false`.
        :param Sequence[str] allow_headers: The HTTP headers that origins can include in requests to the function URL. For example: `["date", "keep-alive", "x-custom-header"]`.
        :param Sequence[str] allow_methods: The HTTP methods that are allowed when calling the function URL. For example: `["GET", "POST", "DELETE"]`, or the wildcard character (`["*"]`).
        :param Sequence[str] allow_origins: The origins that can access the function URL. You can list any number of specific origins (or the wildcard character (`"*"`)), separated by a comma. For example: `["https://www.example.com", "http://localhost:60905"]`.
        :param Sequence[str] expose_headers: The HTTP headers in your function response that you want to expose to origins that call the function URL.
        :param int max_age: The maximum amount of time, in seconds, that web browsers can cache results of a preflight request. By default, this is set to `0`, which means that the browser doesn't cache results. The maximum value is `86400`.
        """
        if allow_credentials is not None:
            pulumi.set(__self__, "allow_credentials", allow_credentials)
        if allow_headers is not None:
            pulumi.set(__self__, "allow_headers", allow_headers)
        if allow_methods is not None:
            pulumi.set(__self__, "allow_methods", allow_methods)
        if allow_origins is not None:
            pulumi.set(__self__, "allow_origins", allow_origins)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age is not None:
            pulumi.set(__self__, "max_age", max_age)

    @property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> Optional[bool]:
        """
        Whether to allow cookies or other credentials in requests to the function URL. The default is `false`.
        """
        return pulumi.get(self, "allow_credentials")

    @property
    @pulumi.getter(name="allowHeaders")
    def allow_headers(self) -> Optional[Sequence[str]]:
        """
        The HTTP headers that origins can include in requests to the function URL. For example: `["date", "keep-alive", "x-custom-header"]`.
        """
        return pulumi.get(self, "allow_headers")

    @property
    @pulumi.getter(name="allowMethods")
    def allow_methods(self) -> Optional[Sequence[str]]:
        """
        The HTTP methods that are allowed when calling the function URL. For example: `["GET", "POST", "DELETE"]`, or the wildcard character (`["*"]`).
        """
        return pulumi.get(self, "allow_methods")

    @property
    @pulumi.getter(name="allowOrigins")
    def allow_origins(self) -> Optional[Sequence[str]]:
        """
        The origins that can access the function URL. You can list any number of specific origins (or the wildcard character (`"*"`)), separated by a comma. For example: `["https://www.example.com", "http://localhost:60905"]`.
        """
        return pulumi.get(self, "allow_origins")

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[Sequence[str]]:
        """
        The HTTP headers in your function response that you want to expose to origins that call the function URL.
        """
        return pulumi.get(self, "expose_headers")

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> Optional[int]:
        """
        The maximum amount of time, in seconds, that web browsers can cache results of a preflight request. By default, this is set to `0`, which means that the browser doesn't cache results. The maximum value is `86400`.
        """
        return pulumi.get(self, "max_age")


@pulumi.output_type
class FunctionVpcConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "subnetIds":
            suggest = "subnet_ids"
        elif key == "ipv6AllowedForDualStack":
            suggest = "ipv6_allowed_for_dual_stack"
        elif key == "vpcId":
            suggest = "vpc_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_ids: Sequence[str],
                 subnet_ids: Sequence[str],
                 ipv6_allowed_for_dual_stack: Optional[bool] = None,
                 vpc_id: Optional[str] = None):
        """
        :param Sequence[str] security_group_ids: List of security group IDs associated with the Lambda function.
        :param Sequence[str] subnet_ids: List of subnet IDs associated with the Lambda function.
        :param bool ipv6_allowed_for_dual_stack: Allows outbound IPv6 traffic on VPC functions that are connected to dual-stack subnets. Default is `false`.
        """
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if ipv6_allowed_for_dual_stack is not None:
            pulumi.set(__self__, "ipv6_allowed_for_dual_stack", ipv6_allowed_for_dual_stack)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[str]:
        """
        List of security group IDs associated with the Lambda function.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[str]:
        """
        List of subnet IDs associated with the Lambda function.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="ipv6AllowedForDualStack")
    def ipv6_allowed_for_dual_stack(self) -> Optional[bool]:
        """
        Allows outbound IPv6 traffic on VPC functions that are connected to dual-stack subnets. Default is `false`.
        """
        return pulumi.get(self, "ipv6_allowed_for_dual_stack")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[str]:
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetCodeSigningConfigAllowedPublisherResult(dict):
    def __init__(__self__, *,
                 signing_profile_version_arns: Sequence[str]):
        """
        :param Sequence[str] signing_profile_version_arns: The ARN for each of the signing profiles. A signing profile defines a trusted user who can sign a code package.
        """
        pulumi.set(__self__, "signing_profile_version_arns", signing_profile_version_arns)

    @property
    @pulumi.getter(name="signingProfileVersionArns")
    def signing_profile_version_arns(self) -> Sequence[str]:
        """
        The ARN for each of the signing profiles. A signing profile defines a trusted user who can sign a code package.
        """
        return pulumi.get(self, "signing_profile_version_arns")


@pulumi.output_type
class GetCodeSigningConfigPolicyResult(dict):
    def __init__(__self__, *,
                 untrusted_artifact_on_deployment: str):
        """
        :param str untrusted_artifact_on_deployment: Code signing configuration policy for deployment validation failure.
        """
        pulumi.set(__self__, "untrusted_artifact_on_deployment", untrusted_artifact_on_deployment)

    @property
    @pulumi.getter(name="untrustedArtifactOnDeployment")
    def untrusted_artifact_on_deployment(self) -> str:
        """
        Code signing configuration policy for deployment validation failure.
        """
        return pulumi.get(self, "untrusted_artifact_on_deployment")


@pulumi.output_type
class GetFunctionDeadLetterConfigResult(dict):
    def __init__(__self__, *,
                 target_arn: str):
        pulumi.set(__self__, "target_arn", target_arn)

    @property
    @pulumi.getter(name="targetArn")
    def target_arn(self) -> str:
        return pulumi.get(self, "target_arn")


@pulumi.output_type
class GetFunctionEnvironmentResult(dict):
    def __init__(__self__, *,
                 variables: Mapping[str, str]):
        pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter
    def variables(self) -> Mapping[str, str]:
        return pulumi.get(self, "variables")


@pulumi.output_type
class GetFunctionEphemeralStorageResult(dict):
    def __init__(__self__, *,
                 size: int):
        pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def size(self) -> int:
        return pulumi.get(self, "size")


@pulumi.output_type
class GetFunctionFileSystemConfigResult(dict):
    def __init__(__self__, *,
                 arn: str,
                 local_mount_path: str):
        """
        :param str arn: Unqualified (no `:QUALIFIER` or `:VERSION` suffix) ARN identifying your Lambda Function. See also `qualified_arn`.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "local_mount_path", local_mount_path)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        Unqualified (no `:QUALIFIER` or `:VERSION` suffix) ARN identifying your Lambda Function. See also `qualified_arn`.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="localMountPath")
    def local_mount_path(self) -> str:
        return pulumi.get(self, "local_mount_path")


@pulumi.output_type
class GetFunctionLoggingConfigResult(dict):
    def __init__(__self__, *,
                 application_log_level: str,
                 log_format: str,
                 log_group: str,
                 system_log_level: str):
        pulumi.set(__self__, "application_log_level", application_log_level)
        pulumi.set(__self__, "log_format", log_format)
        pulumi.set(__self__, "log_group", log_group)
        pulumi.set(__self__, "system_log_level", system_log_level)

    @property
    @pulumi.getter(name="applicationLogLevel")
    def application_log_level(self) -> str:
        return pulumi.get(self, "application_log_level")

    @property
    @pulumi.getter(name="logFormat")
    def log_format(self) -> str:
        return pulumi.get(self, "log_format")

    @property
    @pulumi.getter(name="logGroup")
    def log_group(self) -> str:
        return pulumi.get(self, "log_group")

    @property
    @pulumi.getter(name="systemLogLevel")
    def system_log_level(self) -> str:
        return pulumi.get(self, "system_log_level")


@pulumi.output_type
class GetFunctionTracingConfigResult(dict):
    def __init__(__self__, *,
                 mode: str):
        pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def mode(self) -> str:
        return pulumi.get(self, "mode")


@pulumi.output_type
class GetFunctionUrlCorResult(dict):
    def __init__(__self__, *,
                 allow_credentials: bool,
                 allow_headers: Sequence[str],
                 allow_methods: Sequence[str],
                 allow_origins: Sequence[str],
                 expose_headers: Sequence[str],
                 max_age: int):
        pulumi.set(__self__, "allow_credentials", allow_credentials)
        pulumi.set(__self__, "allow_headers", allow_headers)
        pulumi.set(__self__, "allow_methods", allow_methods)
        pulumi.set(__self__, "allow_origins", allow_origins)
        pulumi.set(__self__, "expose_headers", expose_headers)
        pulumi.set(__self__, "max_age", max_age)

    @property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> bool:
        return pulumi.get(self, "allow_credentials")

    @property
    @pulumi.getter(name="allowHeaders")
    def allow_headers(self) -> Sequence[str]:
        return pulumi.get(self, "allow_headers")

    @property
    @pulumi.getter(name="allowMethods")
    def allow_methods(self) -> Sequence[str]:
        return pulumi.get(self, "allow_methods")

    @property
    @pulumi.getter(name="allowOrigins")
    def allow_origins(self) -> Sequence[str]:
        return pulumi.get(self, "allow_origins")

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Sequence[str]:
        return pulumi.get(self, "expose_headers")

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> int:
        return pulumi.get(self, "max_age")


@pulumi.output_type
class GetFunctionVpcConfigResult(dict):
    def __init__(__self__, *,
                 ipv6_allowed_for_dual_stack: bool,
                 security_group_ids: Sequence[str],
                 subnet_ids: Sequence[str],
                 vpc_id: str):
        pulumi.set(__self__, "ipv6_allowed_for_dual_stack", ipv6_allowed_for_dual_stack)
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="ipv6AllowedForDualStack")
    def ipv6_allowed_for_dual_stack(self) -> bool:
        return pulumi.get(self, "ipv6_allowed_for_dual_stack")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[str]:
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[str]:
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        return pulumi.get(self, "vpc_id")


