# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TargetGroupArgs', 'TargetGroup']

@pulumi.input_type
class TargetGroupArgs:
    def __init__(__self__, *,
                 connection_termination: Optional[pulumi.Input[bool]] = None,
                 deregistration_delay: Optional[pulumi.Input[int]] = None,
                 health_check: Optional[pulumi.Input['TargetGroupHealthCheckArgs']] = None,
                 ip_address_type: Optional[pulumi.Input[str]] = None,
                 lambda_multi_value_headers_enabled: Optional[pulumi.Input[bool]] = None,
                 load_balancing_algorithm_type: Optional[pulumi.Input[str]] = None,
                 load_balancing_anomaly_mitigation: Optional[pulumi.Input[str]] = None,
                 load_balancing_cross_zone_enabled: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 preserve_client_ip: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 protocol_version: Optional[pulumi.Input[str]] = None,
                 proxy_protocol_v2: Optional[pulumi.Input[bool]] = None,
                 slow_start: Optional[pulumi.Input[int]] = None,
                 stickiness: Optional[pulumi.Input['TargetGroupStickinessArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 target_failovers: Optional[pulumi.Input[Sequence[pulumi.Input['TargetGroupTargetFailoverArgs']]]] = None,
                 target_health_states: Optional[pulumi.Input[Sequence[pulumi.Input['TargetGroupTargetHealthStateArgs']]]] = None,
                 target_type: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a TargetGroup resource.
        :param pulumi.Input[bool] connection_termination: Whether to terminate connections at the end of the deregistration timeout on Network Load Balancers. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#deregistration-delay) for more information. Default is `false`.
        :param pulumi.Input[int] deregistration_delay: Amount time for Elastic Load Balancing to wait before changing the state of a deregistering target from draining to unused. The range is 0-3600 seconds. The default value is 300 seconds.
        :param pulumi.Input['TargetGroupHealthCheckArgs'] health_check: Health Check configuration block. Detailed below.
        :param pulumi.Input[str] ip_address_type: The type of IP addresses used by the target group, only supported when target type is set to `ip`. Possible values are `ipv4` or `ipv6`.
        :param pulumi.Input[bool] lambda_multi_value_headers_enabled: Whether the request and response headers exchanged between the load balancer and the Lambda function include arrays of values or strings. Only applies when `target_type` is `lambda`. Default is `false`.
        :param pulumi.Input[str] load_balancing_algorithm_type: Determines how the load balancer selects targets when routing requests. Only applicable for Application Load Balancer Target Groups. The value is `round_robin`, `least_outstanding_requests`, or `weighted_random`. The default is `round_robin`.
        :param pulumi.Input[str] load_balancing_anomaly_mitigation: Determines whether to enable target anomaly mitigation.  Target anomaly mitigation is only supported by the `weighted_random` load balancing algorithm type.  See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#automatic-target-weights) for more information.  The value is `"on"` or `"off"`. The default is `"off"`.
        :param pulumi.Input[str] load_balancing_cross_zone_enabled: Indicates whether cross zone load balancing is enabled. The value is `"true"`, `"false"` or `"use_load_balancer_configuration"`. The default is `"use_load_balancer_configuration"`.
        :param pulumi.Input[str] name: Name of the target group. If omitted, this provider will assign a random, unique name. This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.
        :param pulumi.Input[str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`. Cannot be longer than 6 characters.
        :param pulumi.Input[int] port: Port on which targets receive traffic, unless overridden when registering a specific target. Required when `target_type` is `instance`, `ip` or `alb`. Does not apply when `target_type` is `lambda`.
        :param pulumi.Input[str] preserve_client_ip: Whether client IP preservation is enabled. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#client-ip-preservation) for more information.
        :param pulumi.Input[str] protocol: Protocol to use for routing traffic to the targets.
               Should be one of `GENEVE`, `HTTP`, `HTTPS`, `TCP`, `TCP_UDP`, `TLS`, or `UDP`.
               Required when `target_type` is `instance`, `ip`, or `alb`.
               Does not apply when `target_type` is `lambda`.
        :param pulumi.Input[str] protocol_version: Only applicable when `protocol` is `HTTP` or `HTTPS`. The protocol version. Specify `GRPC` to send requests to targets using gRPC. Specify `HTTP2` to send requests to targets using HTTP/2. The default is `HTTP1`, which sends requests to targets using HTTP/1.1
        :param pulumi.Input[bool] proxy_protocol_v2: Whether to enable support for proxy protocol v2 on Network Load Balancers. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#proxy-protocol) for more information. Default is `false`.
        :param pulumi.Input[int] slow_start: Amount time for targets to warm up before the load balancer sends them a full share of requests. The range is 30-900 seconds or 0 to disable. The default value is 0 seconds.
        :param pulumi.Input['TargetGroupStickinessArgs'] stickiness: Stickiness configuration block. Detailed below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input['TargetGroupTargetFailoverArgs']]] target_failovers: Target failover block. Only applicable for Gateway Load Balancer target groups. See target_failover for more information.
        :param pulumi.Input[Sequence[pulumi.Input['TargetGroupTargetHealthStateArgs']]] target_health_states: Target health state block. Only applicable for Network Load Balancer target groups when `protocol` is `TCP` or `TLS`. See target_health_state for more information.
        :param pulumi.Input[str] target_type: Type of target that you must specify when registering targets with this target group.
               See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_CreateTargetGroup.html) for supported values.
               The default is `instance`.
               
               Note that you can't specify targets for a target group using both instance IDs and IP addresses.
               
               If the target type is `ip`, specify IP addresses from the subnets of the virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP addresses.
               
               Network Load Balancers do not support the `lambda` target type.
               
               Application Load Balancers do not support the `alb` target type.
        :param pulumi.Input[str] vpc_id: Identifier of the VPC in which to create the target group. Required when `target_type` is `instance`, `ip` or `alb`. Does not apply when `target_type` is `lambda`.
        """
        if connection_termination is not None:
            pulumi.set(__self__, "connection_termination", connection_termination)
        if deregistration_delay is not None:
            pulumi.set(__self__, "deregistration_delay", deregistration_delay)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)
        if lambda_multi_value_headers_enabled is not None:
            pulumi.set(__self__, "lambda_multi_value_headers_enabled", lambda_multi_value_headers_enabled)
        if load_balancing_algorithm_type is not None:
            pulumi.set(__self__, "load_balancing_algorithm_type", load_balancing_algorithm_type)
        if load_balancing_anomaly_mitigation is not None:
            pulumi.set(__self__, "load_balancing_anomaly_mitigation", load_balancing_anomaly_mitigation)
        if load_balancing_cross_zone_enabled is not None:
            pulumi.set(__self__, "load_balancing_cross_zone_enabled", load_balancing_cross_zone_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if preserve_client_ip is not None:
            pulumi.set(__self__, "preserve_client_ip", preserve_client_ip)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if protocol_version is not None:
            pulumi.set(__self__, "protocol_version", protocol_version)
        if proxy_protocol_v2 is not None:
            pulumi.set(__self__, "proxy_protocol_v2", proxy_protocol_v2)
        if slow_start is not None:
            pulumi.set(__self__, "slow_start", slow_start)
        if stickiness is not None:
            pulumi.set(__self__, "stickiness", stickiness)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_failovers is not None:
            pulumi.set(__self__, "target_failovers", target_failovers)
        if target_health_states is not None:
            pulumi.set(__self__, "target_health_states", target_health_states)
        if target_type is not None:
            pulumi.set(__self__, "target_type", target_type)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="connectionTermination")
    def connection_termination(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to terminate connections at the end of the deregistration timeout on Network Load Balancers. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#deregistration-delay) for more information. Default is `false`.
        """
        return pulumi.get(self, "connection_termination")

    @connection_termination.setter
    def connection_termination(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "connection_termination", value)

    @property
    @pulumi.getter(name="deregistrationDelay")
    def deregistration_delay(self) -> Optional[pulumi.Input[int]]:
        """
        Amount time for Elastic Load Balancing to wait before changing the state of a deregistering target from draining to unused. The range is 0-3600 seconds. The default value is 300 seconds.
        """
        return pulumi.get(self, "deregistration_delay")

    @deregistration_delay.setter
    def deregistration_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "deregistration_delay", value)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[pulumi.Input['TargetGroupHealthCheckArgs']]:
        """
        Health Check configuration block. Detailed below.
        """
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[pulumi.Input['TargetGroupHealthCheckArgs']]):
        pulumi.set(self, "health_check", value)

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of IP addresses used by the target group, only supported when target type is set to `ip`. Possible values are `ipv4` or `ipv6`.
        """
        return pulumi.get(self, "ip_address_type")

    @ip_address_type.setter
    def ip_address_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address_type", value)

    @property
    @pulumi.getter(name="lambdaMultiValueHeadersEnabled")
    def lambda_multi_value_headers_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the request and response headers exchanged between the load balancer and the Lambda function include arrays of values or strings. Only applies when `target_type` is `lambda`. Default is `false`.
        """
        return pulumi.get(self, "lambda_multi_value_headers_enabled")

    @lambda_multi_value_headers_enabled.setter
    def lambda_multi_value_headers_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "lambda_multi_value_headers_enabled", value)

    @property
    @pulumi.getter(name="loadBalancingAlgorithmType")
    def load_balancing_algorithm_type(self) -> Optional[pulumi.Input[str]]:
        """
        Determines how the load balancer selects targets when routing requests. Only applicable for Application Load Balancer Target Groups. The value is `round_robin`, `least_outstanding_requests`, or `weighted_random`. The default is `round_robin`.
        """
        return pulumi.get(self, "load_balancing_algorithm_type")

    @load_balancing_algorithm_type.setter
    def load_balancing_algorithm_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancing_algorithm_type", value)

    @property
    @pulumi.getter(name="loadBalancingAnomalyMitigation")
    def load_balancing_anomaly_mitigation(self) -> Optional[pulumi.Input[str]]:
        """
        Determines whether to enable target anomaly mitigation.  Target anomaly mitigation is only supported by the `weighted_random` load balancing algorithm type.  See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#automatic-target-weights) for more information.  The value is `"on"` or `"off"`. The default is `"off"`.
        """
        return pulumi.get(self, "load_balancing_anomaly_mitigation")

    @load_balancing_anomaly_mitigation.setter
    def load_balancing_anomaly_mitigation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancing_anomaly_mitigation", value)

    @property
    @pulumi.getter(name="loadBalancingCrossZoneEnabled")
    def load_balancing_cross_zone_enabled(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether cross zone load balancing is enabled. The value is `"true"`, `"false"` or `"use_load_balancer_configuration"`. The default is `"use_load_balancer_configuration"`.
        """
        return pulumi.get(self, "load_balancing_cross_zone_enabled")

    @load_balancing_cross_zone_enabled.setter
    def load_balancing_cross_zone_enabled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancing_cross_zone_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the target group. If omitted, this provider will assign a random, unique name. This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with `name`. Cannot be longer than 6 characters.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port on which targets receive traffic, unless overridden when registering a specific target. Required when `target_type` is `instance`, `ip` or `alb`. Does not apply when `target_type` is `lambda`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="preserveClientIp")
    def preserve_client_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Whether client IP preservation is enabled. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#client-ip-preservation) for more information.
        """
        return pulumi.get(self, "preserve_client_ip")

    @preserve_client_ip.setter
    def preserve_client_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preserve_client_ip", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Protocol to use for routing traffic to the targets.
        Should be one of `GENEVE`, `HTTP`, `HTTPS`, `TCP`, `TCP_UDP`, `TLS`, or `UDP`.
        Required when `target_type` is `instance`, `ip`, or `alb`.
        Does not apply when `target_type` is `lambda`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="protocolVersion")
    def protocol_version(self) -> Optional[pulumi.Input[str]]:
        """
        Only applicable when `protocol` is `HTTP` or `HTTPS`. The protocol version. Specify `GRPC` to send requests to targets using gRPC. Specify `HTTP2` to send requests to targets using HTTP/2. The default is `HTTP1`, which sends requests to targets using HTTP/1.1
        """
        return pulumi.get(self, "protocol_version")

    @protocol_version.setter
    def protocol_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol_version", value)

    @property
    @pulumi.getter(name="proxyProtocolV2")
    def proxy_protocol_v2(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable support for proxy protocol v2 on Network Load Balancers. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#proxy-protocol) for more information. Default is `false`.
        """
        return pulumi.get(self, "proxy_protocol_v2")

    @proxy_protocol_v2.setter
    def proxy_protocol_v2(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "proxy_protocol_v2", value)

    @property
    @pulumi.getter(name="slowStart")
    def slow_start(self) -> Optional[pulumi.Input[int]]:
        """
        Amount time for targets to warm up before the load balancer sends them a full share of requests. The range is 30-900 seconds or 0 to disable. The default value is 0 seconds.
        """
        return pulumi.get(self, "slow_start")

    @slow_start.setter
    def slow_start(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "slow_start", value)

    @property
    @pulumi.getter
    def stickiness(self) -> Optional[pulumi.Input['TargetGroupStickinessArgs']]:
        """
        Stickiness configuration block. Detailed below.
        """
        return pulumi.get(self, "stickiness")

    @stickiness.setter
    def stickiness(self, value: Optional[pulumi.Input['TargetGroupStickinessArgs']]):
        pulumi.set(self, "stickiness", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetFailovers")
    def target_failovers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TargetGroupTargetFailoverArgs']]]]:
        """
        Target failover block. Only applicable for Gateway Load Balancer target groups. See target_failover for more information.
        """
        return pulumi.get(self, "target_failovers")

    @target_failovers.setter
    def target_failovers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TargetGroupTargetFailoverArgs']]]]):
        pulumi.set(self, "target_failovers", value)

    @property
    @pulumi.getter(name="targetHealthStates")
    def target_health_states(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TargetGroupTargetHealthStateArgs']]]]:
        """
        Target health state block. Only applicable for Network Load Balancer target groups when `protocol` is `TCP` or `TLS`. See target_health_state for more information.
        """
        return pulumi.get(self, "target_health_states")

    @target_health_states.setter
    def target_health_states(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TargetGroupTargetHealthStateArgs']]]]):
        pulumi.set(self, "target_health_states", value)

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of target that you must specify when registering targets with this target group.
        See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_CreateTargetGroup.html) for supported values.
        The default is `instance`.

        Note that you can't specify targets for a target group using both instance IDs and IP addresses.

        If the target type is `ip`, specify IP addresses from the subnets of the virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP addresses.

        Network Load Balancers do not support the `lambda` target type.

        Application Load Balancers do not support the `alb` target type.
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_type", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the VPC in which to create the target group. Required when `target_type` is `instance`, `ip` or `alb`. Does not apply when `target_type` is `lambda`.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.input_type
class _TargetGroupState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 arn_suffix: Optional[pulumi.Input[str]] = None,
                 connection_termination: Optional[pulumi.Input[bool]] = None,
                 deregistration_delay: Optional[pulumi.Input[int]] = None,
                 health_check: Optional[pulumi.Input['TargetGroupHealthCheckArgs']] = None,
                 ip_address_type: Optional[pulumi.Input[str]] = None,
                 lambda_multi_value_headers_enabled: Optional[pulumi.Input[bool]] = None,
                 load_balancer_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 load_balancing_algorithm_type: Optional[pulumi.Input[str]] = None,
                 load_balancing_anomaly_mitigation: Optional[pulumi.Input[str]] = None,
                 load_balancing_cross_zone_enabled: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 preserve_client_ip: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 protocol_version: Optional[pulumi.Input[str]] = None,
                 proxy_protocol_v2: Optional[pulumi.Input[bool]] = None,
                 slow_start: Optional[pulumi.Input[int]] = None,
                 stickiness: Optional[pulumi.Input['TargetGroupStickinessArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 target_failovers: Optional[pulumi.Input[Sequence[pulumi.Input['TargetGroupTargetFailoverArgs']]]] = None,
                 target_health_states: Optional[pulumi.Input[Sequence[pulumi.Input['TargetGroupTargetHealthStateArgs']]]] = None,
                 target_type: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TargetGroup resources.
        :param pulumi.Input[str] arn: ARN of the Target Group (matches `id`).
        :param pulumi.Input[str] arn_suffix: ARN suffix for use with CloudWatch Metrics.
        :param pulumi.Input[bool] connection_termination: Whether to terminate connections at the end of the deregistration timeout on Network Load Balancers. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#deregistration-delay) for more information. Default is `false`.
        :param pulumi.Input[int] deregistration_delay: Amount time for Elastic Load Balancing to wait before changing the state of a deregistering target from draining to unused. The range is 0-3600 seconds. The default value is 300 seconds.
        :param pulumi.Input['TargetGroupHealthCheckArgs'] health_check: Health Check configuration block. Detailed below.
        :param pulumi.Input[str] ip_address_type: The type of IP addresses used by the target group, only supported when target type is set to `ip`. Possible values are `ipv4` or `ipv6`.
        :param pulumi.Input[bool] lambda_multi_value_headers_enabled: Whether the request and response headers exchanged between the load balancer and the Lambda function include arrays of values or strings. Only applies when `target_type` is `lambda`. Default is `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] load_balancer_arns: ARNs of the Load Balancers associated with the Target Group.
        :param pulumi.Input[str] load_balancing_algorithm_type: Determines how the load balancer selects targets when routing requests. Only applicable for Application Load Balancer Target Groups. The value is `round_robin`, `least_outstanding_requests`, or `weighted_random`. The default is `round_robin`.
        :param pulumi.Input[str] load_balancing_anomaly_mitigation: Determines whether to enable target anomaly mitigation.  Target anomaly mitigation is only supported by the `weighted_random` load balancing algorithm type.  See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#automatic-target-weights) for more information.  The value is `"on"` or `"off"`. The default is `"off"`.
        :param pulumi.Input[str] load_balancing_cross_zone_enabled: Indicates whether cross zone load balancing is enabled. The value is `"true"`, `"false"` or `"use_load_balancer_configuration"`. The default is `"use_load_balancer_configuration"`.
        :param pulumi.Input[str] name: Name of the target group. If omitted, this provider will assign a random, unique name. This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.
        :param pulumi.Input[str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`. Cannot be longer than 6 characters.
        :param pulumi.Input[int] port: Port on which targets receive traffic, unless overridden when registering a specific target. Required when `target_type` is `instance`, `ip` or `alb`. Does not apply when `target_type` is `lambda`.
        :param pulumi.Input[str] preserve_client_ip: Whether client IP preservation is enabled. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#client-ip-preservation) for more information.
        :param pulumi.Input[str] protocol: Protocol to use for routing traffic to the targets.
               Should be one of `GENEVE`, `HTTP`, `HTTPS`, `TCP`, `TCP_UDP`, `TLS`, or `UDP`.
               Required when `target_type` is `instance`, `ip`, or `alb`.
               Does not apply when `target_type` is `lambda`.
        :param pulumi.Input[str] protocol_version: Only applicable when `protocol` is `HTTP` or `HTTPS`. The protocol version. Specify `GRPC` to send requests to targets using gRPC. Specify `HTTP2` to send requests to targets using HTTP/2. The default is `HTTP1`, which sends requests to targets using HTTP/1.1
        :param pulumi.Input[bool] proxy_protocol_v2: Whether to enable support for proxy protocol v2 on Network Load Balancers. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#proxy-protocol) for more information. Default is `false`.
        :param pulumi.Input[int] slow_start: Amount time for targets to warm up before the load balancer sends them a full share of requests. The range is 30-900 seconds or 0 to disable. The default value is 0 seconds.
        :param pulumi.Input['TargetGroupStickinessArgs'] stickiness: Stickiness configuration block. Detailed below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input['TargetGroupTargetFailoverArgs']]] target_failovers: Target failover block. Only applicable for Gateway Load Balancer target groups. See target_failover for more information.
        :param pulumi.Input[Sequence[pulumi.Input['TargetGroupTargetHealthStateArgs']]] target_health_states: Target health state block. Only applicable for Network Load Balancer target groups when `protocol` is `TCP` or `TLS`. See target_health_state for more information.
        :param pulumi.Input[str] target_type: Type of target that you must specify when registering targets with this target group.
               See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_CreateTargetGroup.html) for supported values.
               The default is `instance`.
               
               Note that you can't specify targets for a target group using both instance IDs and IP addresses.
               
               If the target type is `ip`, specify IP addresses from the subnets of the virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP addresses.
               
               Network Load Balancers do not support the `lambda` target type.
               
               Application Load Balancers do not support the `alb` target type.
        :param pulumi.Input[str] vpc_id: Identifier of the VPC in which to create the target group. Required when `target_type` is `instance`, `ip` or `alb`. Does not apply when `target_type` is `lambda`.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if arn_suffix is not None:
            pulumi.set(__self__, "arn_suffix", arn_suffix)
        if connection_termination is not None:
            pulumi.set(__self__, "connection_termination", connection_termination)
        if deregistration_delay is not None:
            pulumi.set(__self__, "deregistration_delay", deregistration_delay)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)
        if lambda_multi_value_headers_enabled is not None:
            pulumi.set(__self__, "lambda_multi_value_headers_enabled", lambda_multi_value_headers_enabled)
        if load_balancer_arns is not None:
            pulumi.set(__self__, "load_balancer_arns", load_balancer_arns)
        if load_balancing_algorithm_type is not None:
            pulumi.set(__self__, "load_balancing_algorithm_type", load_balancing_algorithm_type)
        if load_balancing_anomaly_mitigation is not None:
            pulumi.set(__self__, "load_balancing_anomaly_mitigation", load_balancing_anomaly_mitigation)
        if load_balancing_cross_zone_enabled is not None:
            pulumi.set(__self__, "load_balancing_cross_zone_enabled", load_balancing_cross_zone_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if preserve_client_ip is not None:
            pulumi.set(__self__, "preserve_client_ip", preserve_client_ip)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if protocol_version is not None:
            pulumi.set(__self__, "protocol_version", protocol_version)
        if proxy_protocol_v2 is not None:
            pulumi.set(__self__, "proxy_protocol_v2", proxy_protocol_v2)
        if slow_start is not None:
            pulumi.set(__self__, "slow_start", slow_start)
        if stickiness is not None:
            pulumi.set(__self__, "stickiness", stickiness)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if target_failovers is not None:
            pulumi.set(__self__, "target_failovers", target_failovers)
        if target_health_states is not None:
            pulumi.set(__self__, "target_health_states", target_health_states)
        if target_type is not None:
            pulumi.set(__self__, "target_type", target_type)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the Target Group (matches `id`).
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="arnSuffix")
    def arn_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        ARN suffix for use with CloudWatch Metrics.
        """
        return pulumi.get(self, "arn_suffix")

    @arn_suffix.setter
    def arn_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn_suffix", value)

    @property
    @pulumi.getter(name="connectionTermination")
    def connection_termination(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to terminate connections at the end of the deregistration timeout on Network Load Balancers. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#deregistration-delay) for more information. Default is `false`.
        """
        return pulumi.get(self, "connection_termination")

    @connection_termination.setter
    def connection_termination(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "connection_termination", value)

    @property
    @pulumi.getter(name="deregistrationDelay")
    def deregistration_delay(self) -> Optional[pulumi.Input[int]]:
        """
        Amount time for Elastic Load Balancing to wait before changing the state of a deregistering target from draining to unused. The range is 0-3600 seconds. The default value is 300 seconds.
        """
        return pulumi.get(self, "deregistration_delay")

    @deregistration_delay.setter
    def deregistration_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "deregistration_delay", value)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[pulumi.Input['TargetGroupHealthCheckArgs']]:
        """
        Health Check configuration block. Detailed below.
        """
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[pulumi.Input['TargetGroupHealthCheckArgs']]):
        pulumi.set(self, "health_check", value)

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of IP addresses used by the target group, only supported when target type is set to `ip`. Possible values are `ipv4` or `ipv6`.
        """
        return pulumi.get(self, "ip_address_type")

    @ip_address_type.setter
    def ip_address_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address_type", value)

    @property
    @pulumi.getter(name="lambdaMultiValueHeadersEnabled")
    def lambda_multi_value_headers_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the request and response headers exchanged between the load balancer and the Lambda function include arrays of values or strings. Only applies when `target_type` is `lambda`. Default is `false`.
        """
        return pulumi.get(self, "lambda_multi_value_headers_enabled")

    @lambda_multi_value_headers_enabled.setter
    def lambda_multi_value_headers_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "lambda_multi_value_headers_enabled", value)

    @property
    @pulumi.getter(name="loadBalancerArns")
    def load_balancer_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        ARNs of the Load Balancers associated with the Target Group.
        """
        return pulumi.get(self, "load_balancer_arns")

    @load_balancer_arns.setter
    def load_balancer_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "load_balancer_arns", value)

    @property
    @pulumi.getter(name="loadBalancingAlgorithmType")
    def load_balancing_algorithm_type(self) -> Optional[pulumi.Input[str]]:
        """
        Determines how the load balancer selects targets when routing requests. Only applicable for Application Load Balancer Target Groups. The value is `round_robin`, `least_outstanding_requests`, or `weighted_random`. The default is `round_robin`.
        """
        return pulumi.get(self, "load_balancing_algorithm_type")

    @load_balancing_algorithm_type.setter
    def load_balancing_algorithm_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancing_algorithm_type", value)

    @property
    @pulumi.getter(name="loadBalancingAnomalyMitigation")
    def load_balancing_anomaly_mitigation(self) -> Optional[pulumi.Input[str]]:
        """
        Determines whether to enable target anomaly mitigation.  Target anomaly mitigation is only supported by the `weighted_random` load balancing algorithm type.  See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#automatic-target-weights) for more information.  The value is `"on"` or `"off"`. The default is `"off"`.
        """
        return pulumi.get(self, "load_balancing_anomaly_mitigation")

    @load_balancing_anomaly_mitigation.setter
    def load_balancing_anomaly_mitigation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancing_anomaly_mitigation", value)

    @property
    @pulumi.getter(name="loadBalancingCrossZoneEnabled")
    def load_balancing_cross_zone_enabled(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether cross zone load balancing is enabled. The value is `"true"`, `"false"` or `"use_load_balancer_configuration"`. The default is `"use_load_balancer_configuration"`.
        """
        return pulumi.get(self, "load_balancing_cross_zone_enabled")

    @load_balancing_cross_zone_enabled.setter
    def load_balancing_cross_zone_enabled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancing_cross_zone_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the target group. If omitted, this provider will assign a random, unique name. This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with `name`. Cannot be longer than 6 characters.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port on which targets receive traffic, unless overridden when registering a specific target. Required when `target_type` is `instance`, `ip` or `alb`. Does not apply when `target_type` is `lambda`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="preserveClientIp")
    def preserve_client_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Whether client IP preservation is enabled. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#client-ip-preservation) for more information.
        """
        return pulumi.get(self, "preserve_client_ip")

    @preserve_client_ip.setter
    def preserve_client_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preserve_client_ip", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Protocol to use for routing traffic to the targets.
        Should be one of `GENEVE`, `HTTP`, `HTTPS`, `TCP`, `TCP_UDP`, `TLS`, or `UDP`.
        Required when `target_type` is `instance`, `ip`, or `alb`.
        Does not apply when `target_type` is `lambda`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="protocolVersion")
    def protocol_version(self) -> Optional[pulumi.Input[str]]:
        """
        Only applicable when `protocol` is `HTTP` or `HTTPS`. The protocol version. Specify `GRPC` to send requests to targets using gRPC. Specify `HTTP2` to send requests to targets using HTTP/2. The default is `HTTP1`, which sends requests to targets using HTTP/1.1
        """
        return pulumi.get(self, "protocol_version")

    @protocol_version.setter
    def protocol_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol_version", value)

    @property
    @pulumi.getter(name="proxyProtocolV2")
    def proxy_protocol_v2(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable support for proxy protocol v2 on Network Load Balancers. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#proxy-protocol) for more information. Default is `false`.
        """
        return pulumi.get(self, "proxy_protocol_v2")

    @proxy_protocol_v2.setter
    def proxy_protocol_v2(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "proxy_protocol_v2", value)

    @property
    @pulumi.getter(name="slowStart")
    def slow_start(self) -> Optional[pulumi.Input[int]]:
        """
        Amount time for targets to warm up before the load balancer sends them a full share of requests. The range is 30-900 seconds or 0 to disable. The default value is 0 seconds.
        """
        return pulumi.get(self, "slow_start")

    @slow_start.setter
    def slow_start(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "slow_start", value)

    @property
    @pulumi.getter
    def stickiness(self) -> Optional[pulumi.Input['TargetGroupStickinessArgs']]:
        """
        Stickiness configuration block. Detailed below.
        """
        return pulumi.get(self, "stickiness")

    @stickiness.setter
    def stickiness(self, value: Optional[pulumi.Input['TargetGroupStickinessArgs']]):
        pulumi.set(self, "stickiness", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="targetFailovers")
    def target_failovers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TargetGroupTargetFailoverArgs']]]]:
        """
        Target failover block. Only applicable for Gateway Load Balancer target groups. See target_failover for more information.
        """
        return pulumi.get(self, "target_failovers")

    @target_failovers.setter
    def target_failovers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TargetGroupTargetFailoverArgs']]]]):
        pulumi.set(self, "target_failovers", value)

    @property
    @pulumi.getter(name="targetHealthStates")
    def target_health_states(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TargetGroupTargetHealthStateArgs']]]]:
        """
        Target health state block. Only applicable for Network Load Balancer target groups when `protocol` is `TCP` or `TLS`. See target_health_state for more information.
        """
        return pulumi.get(self, "target_health_states")

    @target_health_states.setter
    def target_health_states(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TargetGroupTargetHealthStateArgs']]]]):
        pulumi.set(self, "target_health_states", value)

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of target that you must specify when registering targets with this target group.
        See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_CreateTargetGroup.html) for supported values.
        The default is `instance`.

        Note that you can't specify targets for a target group using both instance IDs and IP addresses.

        If the target type is `ip`, specify IP addresses from the subnets of the virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP addresses.

        Network Load Balancers do not support the `lambda` target type.

        Application Load Balancers do not support the `alb` target type.
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_type", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the VPC in which to create the target group. Required when `target_type` is `instance`, `ip` or `alb`. Does not apply when `target_type` is `lambda`.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class TargetGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_termination: Optional[pulumi.Input[bool]] = None,
                 deregistration_delay: Optional[pulumi.Input[int]] = None,
                 health_check: Optional[pulumi.Input[pulumi.InputType['TargetGroupHealthCheckArgs']]] = None,
                 ip_address_type: Optional[pulumi.Input[str]] = None,
                 lambda_multi_value_headers_enabled: Optional[pulumi.Input[bool]] = None,
                 load_balancing_algorithm_type: Optional[pulumi.Input[str]] = None,
                 load_balancing_anomaly_mitigation: Optional[pulumi.Input[str]] = None,
                 load_balancing_cross_zone_enabled: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 preserve_client_ip: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 protocol_version: Optional[pulumi.Input[str]] = None,
                 proxy_protocol_v2: Optional[pulumi.Input[bool]] = None,
                 slow_start: Optional[pulumi.Input[int]] = None,
                 stickiness: Optional[pulumi.Input[pulumi.InputType['TargetGroupStickinessArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 target_failovers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TargetGroupTargetFailoverArgs']]]]] = None,
                 target_health_states: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TargetGroupTargetHealthStateArgs']]]]] = None,
                 target_type: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Target Group resource for use with Load Balancer resources.

        > **Note:** `alb.TargetGroup` is known as `lb.TargetGroup`. The functionality is identical.

        ## Example Usage

        ### Instance Target Group

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        main = aws.ec2.Vpc("main", cidr_block="10.0.0.0/16")
        test = aws.lb.TargetGroup("test",
            name="tf-example-lb-tg",
            port=80,
            protocol="HTTP",
            vpc_id=main.id)
        ```
        <!--End PulumiCodeChooser -->

        ### IP Target Group

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        main = aws.ec2.Vpc("main", cidr_block="10.0.0.0/16")
        ip_example = aws.lb.TargetGroup("ip-example",
            name="tf-example-lb-tg",
            port=80,
            protocol="HTTP",
            target_type="ip",
            vpc_id=main.id)
        ```
        <!--End PulumiCodeChooser -->

        ### Lambda Target Group

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        lambda_example = aws.lb.TargetGroup("lambda-example",
            name="tf-example-lb-tg",
            target_type="lambda")
        ```
        <!--End PulumiCodeChooser -->

        ### ALB Target Group

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        alb_example = aws.lb.TargetGroup("alb-example",
            name="tf-example-lb-alb-tg",
            target_type="alb",
            port=80,
            protocol="TCP",
            vpc_id=main["id"])
        ```
        <!--End PulumiCodeChooser -->

        ### Target group with unhealthy connection termination disabled

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        tcp_example = aws.lb.TargetGroup("tcp-example",
            name="tf-example-lb-nlb-tg",
            port=25,
            protocol="TCP",
            vpc_id=main["id"],
            target_health_states=[aws.lb.TargetGroupTargetHealthStateArgs(
                enable_unhealthy_connection_termination=False,
            )])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Target Groups using their ARN. For example:

        ```sh
        $ pulumi import aws:lb/targetGroup:TargetGroup app_front_end arn:aws:elasticloadbalancing:us-west-2:187416307283:targetgroup/app-front-end/20cfe21448b66314
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] connection_termination: Whether to terminate connections at the end of the deregistration timeout on Network Load Balancers. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#deregistration-delay) for more information. Default is `false`.
        :param pulumi.Input[int] deregistration_delay: Amount time for Elastic Load Balancing to wait before changing the state of a deregistering target from draining to unused. The range is 0-3600 seconds. The default value is 300 seconds.
        :param pulumi.Input[pulumi.InputType['TargetGroupHealthCheckArgs']] health_check: Health Check configuration block. Detailed below.
        :param pulumi.Input[str] ip_address_type: The type of IP addresses used by the target group, only supported when target type is set to `ip`. Possible values are `ipv4` or `ipv6`.
        :param pulumi.Input[bool] lambda_multi_value_headers_enabled: Whether the request and response headers exchanged between the load balancer and the Lambda function include arrays of values or strings. Only applies when `target_type` is `lambda`. Default is `false`.
        :param pulumi.Input[str] load_balancing_algorithm_type: Determines how the load balancer selects targets when routing requests. Only applicable for Application Load Balancer Target Groups. The value is `round_robin`, `least_outstanding_requests`, or `weighted_random`. The default is `round_robin`.
        :param pulumi.Input[str] load_balancing_anomaly_mitigation: Determines whether to enable target anomaly mitigation.  Target anomaly mitigation is only supported by the `weighted_random` load balancing algorithm type.  See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#automatic-target-weights) for more information.  The value is `"on"` or `"off"`. The default is `"off"`.
        :param pulumi.Input[str] load_balancing_cross_zone_enabled: Indicates whether cross zone load balancing is enabled. The value is `"true"`, `"false"` or `"use_load_balancer_configuration"`. The default is `"use_load_balancer_configuration"`.
        :param pulumi.Input[str] name: Name of the target group. If omitted, this provider will assign a random, unique name. This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.
        :param pulumi.Input[str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`. Cannot be longer than 6 characters.
        :param pulumi.Input[int] port: Port on which targets receive traffic, unless overridden when registering a specific target. Required when `target_type` is `instance`, `ip` or `alb`. Does not apply when `target_type` is `lambda`.
        :param pulumi.Input[str] preserve_client_ip: Whether client IP preservation is enabled. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#client-ip-preservation) for more information.
        :param pulumi.Input[str] protocol: Protocol to use for routing traffic to the targets.
               Should be one of `GENEVE`, `HTTP`, `HTTPS`, `TCP`, `TCP_UDP`, `TLS`, or `UDP`.
               Required when `target_type` is `instance`, `ip`, or `alb`.
               Does not apply when `target_type` is `lambda`.
        :param pulumi.Input[str] protocol_version: Only applicable when `protocol` is `HTTP` or `HTTPS`. The protocol version. Specify `GRPC` to send requests to targets using gRPC. Specify `HTTP2` to send requests to targets using HTTP/2. The default is `HTTP1`, which sends requests to targets using HTTP/1.1
        :param pulumi.Input[bool] proxy_protocol_v2: Whether to enable support for proxy protocol v2 on Network Load Balancers. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#proxy-protocol) for more information. Default is `false`.
        :param pulumi.Input[int] slow_start: Amount time for targets to warm up before the load balancer sends them a full share of requests. The range is 30-900 seconds or 0 to disable. The default value is 0 seconds.
        :param pulumi.Input[pulumi.InputType['TargetGroupStickinessArgs']] stickiness: Stickiness configuration block. Detailed below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TargetGroupTargetFailoverArgs']]]] target_failovers: Target failover block. Only applicable for Gateway Load Balancer target groups. See target_failover for more information.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TargetGroupTargetHealthStateArgs']]]] target_health_states: Target health state block. Only applicable for Network Load Balancer target groups when `protocol` is `TCP` or `TLS`. See target_health_state for more information.
        :param pulumi.Input[str] target_type: Type of target that you must specify when registering targets with this target group.
               See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_CreateTargetGroup.html) for supported values.
               The default is `instance`.
               
               Note that you can't specify targets for a target group using both instance IDs and IP addresses.
               
               If the target type is `ip`, specify IP addresses from the subnets of the virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP addresses.
               
               Network Load Balancers do not support the `lambda` target type.
               
               Application Load Balancers do not support the `alb` target type.
        :param pulumi.Input[str] vpc_id: Identifier of the VPC in which to create the target group. Required when `target_type` is `instance`, `ip` or `alb`. Does not apply when `target_type` is `lambda`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[TargetGroupArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Target Group resource for use with Load Balancer resources.

        > **Note:** `alb.TargetGroup` is known as `lb.TargetGroup`. The functionality is identical.

        ## Example Usage

        ### Instance Target Group

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        main = aws.ec2.Vpc("main", cidr_block="10.0.0.0/16")
        test = aws.lb.TargetGroup("test",
            name="tf-example-lb-tg",
            port=80,
            protocol="HTTP",
            vpc_id=main.id)
        ```
        <!--End PulumiCodeChooser -->

        ### IP Target Group

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        main = aws.ec2.Vpc("main", cidr_block="10.0.0.0/16")
        ip_example = aws.lb.TargetGroup("ip-example",
            name="tf-example-lb-tg",
            port=80,
            protocol="HTTP",
            target_type="ip",
            vpc_id=main.id)
        ```
        <!--End PulumiCodeChooser -->

        ### Lambda Target Group

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        lambda_example = aws.lb.TargetGroup("lambda-example",
            name="tf-example-lb-tg",
            target_type="lambda")
        ```
        <!--End PulumiCodeChooser -->

        ### ALB Target Group

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        alb_example = aws.lb.TargetGroup("alb-example",
            name="tf-example-lb-alb-tg",
            target_type="alb",
            port=80,
            protocol="TCP",
            vpc_id=main["id"])
        ```
        <!--End PulumiCodeChooser -->

        ### Target group with unhealthy connection termination disabled

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        tcp_example = aws.lb.TargetGroup("tcp-example",
            name="tf-example-lb-nlb-tg",
            port=25,
            protocol="TCP",
            vpc_id=main["id"],
            target_health_states=[aws.lb.TargetGroupTargetHealthStateArgs(
                enable_unhealthy_connection_termination=False,
            )])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Target Groups using their ARN. For example:

        ```sh
        $ pulumi import aws:lb/targetGroup:TargetGroup app_front_end arn:aws:elasticloadbalancing:us-west-2:187416307283:targetgroup/app-front-end/20cfe21448b66314
        ```

        :param str resource_name: The name of the resource.
        :param TargetGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TargetGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_termination: Optional[pulumi.Input[bool]] = None,
                 deregistration_delay: Optional[pulumi.Input[int]] = None,
                 health_check: Optional[pulumi.Input[pulumi.InputType['TargetGroupHealthCheckArgs']]] = None,
                 ip_address_type: Optional[pulumi.Input[str]] = None,
                 lambda_multi_value_headers_enabled: Optional[pulumi.Input[bool]] = None,
                 load_balancing_algorithm_type: Optional[pulumi.Input[str]] = None,
                 load_balancing_anomaly_mitigation: Optional[pulumi.Input[str]] = None,
                 load_balancing_cross_zone_enabled: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 preserve_client_ip: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 protocol_version: Optional[pulumi.Input[str]] = None,
                 proxy_protocol_v2: Optional[pulumi.Input[bool]] = None,
                 slow_start: Optional[pulumi.Input[int]] = None,
                 stickiness: Optional[pulumi.Input[pulumi.InputType['TargetGroupStickinessArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 target_failovers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TargetGroupTargetFailoverArgs']]]]] = None,
                 target_health_states: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TargetGroupTargetHealthStateArgs']]]]] = None,
                 target_type: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TargetGroupArgs.__new__(TargetGroupArgs)

            __props__.__dict__["connection_termination"] = connection_termination
            __props__.__dict__["deregistration_delay"] = deregistration_delay
            __props__.__dict__["health_check"] = health_check
            __props__.__dict__["ip_address_type"] = ip_address_type
            __props__.__dict__["lambda_multi_value_headers_enabled"] = lambda_multi_value_headers_enabled
            __props__.__dict__["load_balancing_algorithm_type"] = load_balancing_algorithm_type
            __props__.__dict__["load_balancing_anomaly_mitigation"] = load_balancing_anomaly_mitigation
            __props__.__dict__["load_balancing_cross_zone_enabled"] = load_balancing_cross_zone_enabled
            __props__.__dict__["name"] = name
            __props__.__dict__["name_prefix"] = name_prefix
            __props__.__dict__["port"] = port
            __props__.__dict__["preserve_client_ip"] = preserve_client_ip
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["protocol_version"] = protocol_version
            __props__.__dict__["proxy_protocol_v2"] = proxy_protocol_v2
            __props__.__dict__["slow_start"] = slow_start
            __props__.__dict__["stickiness"] = stickiness
            __props__.__dict__["tags"] = tags
            __props__.__dict__["target_failovers"] = target_failovers
            __props__.__dict__["target_health_states"] = target_health_states
            __props__.__dict__["target_type"] = target_type
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["arn"] = None
            __props__.__dict__["arn_suffix"] = None
            __props__.__dict__["load_balancer_arns"] = None
            __props__.__dict__["tags_all"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="aws:elasticloadbalancingv2/targetGroup:TargetGroup")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(TargetGroup, __self__).__init__(
            'aws:lb/targetGroup:TargetGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            arn_suffix: Optional[pulumi.Input[str]] = None,
            connection_termination: Optional[pulumi.Input[bool]] = None,
            deregistration_delay: Optional[pulumi.Input[int]] = None,
            health_check: Optional[pulumi.Input[pulumi.InputType['TargetGroupHealthCheckArgs']]] = None,
            ip_address_type: Optional[pulumi.Input[str]] = None,
            lambda_multi_value_headers_enabled: Optional[pulumi.Input[bool]] = None,
            load_balancer_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            load_balancing_algorithm_type: Optional[pulumi.Input[str]] = None,
            load_balancing_anomaly_mitigation: Optional[pulumi.Input[str]] = None,
            load_balancing_cross_zone_enabled: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            name_prefix: Optional[pulumi.Input[str]] = None,
            port: Optional[pulumi.Input[int]] = None,
            preserve_client_ip: Optional[pulumi.Input[str]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            protocol_version: Optional[pulumi.Input[str]] = None,
            proxy_protocol_v2: Optional[pulumi.Input[bool]] = None,
            slow_start: Optional[pulumi.Input[int]] = None,
            stickiness: Optional[pulumi.Input[pulumi.InputType['TargetGroupStickinessArgs']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            target_failovers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TargetGroupTargetFailoverArgs']]]]] = None,
            target_health_states: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TargetGroupTargetHealthStateArgs']]]]] = None,
            target_type: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'TargetGroup':
        """
        Get an existing TargetGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: ARN of the Target Group (matches `id`).
        :param pulumi.Input[str] arn_suffix: ARN suffix for use with CloudWatch Metrics.
        :param pulumi.Input[bool] connection_termination: Whether to terminate connections at the end of the deregistration timeout on Network Load Balancers. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#deregistration-delay) for more information. Default is `false`.
        :param pulumi.Input[int] deregistration_delay: Amount time for Elastic Load Balancing to wait before changing the state of a deregistering target from draining to unused. The range is 0-3600 seconds. The default value is 300 seconds.
        :param pulumi.Input[pulumi.InputType['TargetGroupHealthCheckArgs']] health_check: Health Check configuration block. Detailed below.
        :param pulumi.Input[str] ip_address_type: The type of IP addresses used by the target group, only supported when target type is set to `ip`. Possible values are `ipv4` or `ipv6`.
        :param pulumi.Input[bool] lambda_multi_value_headers_enabled: Whether the request and response headers exchanged between the load balancer and the Lambda function include arrays of values or strings. Only applies when `target_type` is `lambda`. Default is `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] load_balancer_arns: ARNs of the Load Balancers associated with the Target Group.
        :param pulumi.Input[str] load_balancing_algorithm_type: Determines how the load balancer selects targets when routing requests. Only applicable for Application Load Balancer Target Groups. The value is `round_robin`, `least_outstanding_requests`, or `weighted_random`. The default is `round_robin`.
        :param pulumi.Input[str] load_balancing_anomaly_mitigation: Determines whether to enable target anomaly mitigation.  Target anomaly mitigation is only supported by the `weighted_random` load balancing algorithm type.  See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#automatic-target-weights) for more information.  The value is `"on"` or `"off"`. The default is `"off"`.
        :param pulumi.Input[str] load_balancing_cross_zone_enabled: Indicates whether cross zone load balancing is enabled. The value is `"true"`, `"false"` or `"use_load_balancer_configuration"`. The default is `"use_load_balancer_configuration"`.
        :param pulumi.Input[str] name: Name of the target group. If omitted, this provider will assign a random, unique name. This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.
        :param pulumi.Input[str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`. Cannot be longer than 6 characters.
        :param pulumi.Input[int] port: Port on which targets receive traffic, unless overridden when registering a specific target. Required when `target_type` is `instance`, `ip` or `alb`. Does not apply when `target_type` is `lambda`.
        :param pulumi.Input[str] preserve_client_ip: Whether client IP preservation is enabled. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#client-ip-preservation) for more information.
        :param pulumi.Input[str] protocol: Protocol to use for routing traffic to the targets.
               Should be one of `GENEVE`, `HTTP`, `HTTPS`, `TCP`, `TCP_UDP`, `TLS`, or `UDP`.
               Required when `target_type` is `instance`, `ip`, or `alb`.
               Does not apply when `target_type` is `lambda`.
        :param pulumi.Input[str] protocol_version: Only applicable when `protocol` is `HTTP` or `HTTPS`. The protocol version. Specify `GRPC` to send requests to targets using gRPC. Specify `HTTP2` to send requests to targets using HTTP/2. The default is `HTTP1`, which sends requests to targets using HTTP/1.1
        :param pulumi.Input[bool] proxy_protocol_v2: Whether to enable support for proxy protocol v2 on Network Load Balancers. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#proxy-protocol) for more information. Default is `false`.
        :param pulumi.Input[int] slow_start: Amount time for targets to warm up before the load balancer sends them a full share of requests. The range is 30-900 seconds or 0 to disable. The default value is 0 seconds.
        :param pulumi.Input[pulumi.InputType['TargetGroupStickinessArgs']] stickiness: Stickiness configuration block. Detailed below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TargetGroupTargetFailoverArgs']]]] target_failovers: Target failover block. Only applicable for Gateway Load Balancer target groups. See target_failover for more information.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TargetGroupTargetHealthStateArgs']]]] target_health_states: Target health state block. Only applicable for Network Load Balancer target groups when `protocol` is `TCP` or `TLS`. See target_health_state for more information.
        :param pulumi.Input[str] target_type: Type of target that you must specify when registering targets with this target group.
               See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_CreateTargetGroup.html) for supported values.
               The default is `instance`.
               
               Note that you can't specify targets for a target group using both instance IDs and IP addresses.
               
               If the target type is `ip`, specify IP addresses from the subnets of the virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP addresses.
               
               Network Load Balancers do not support the `lambda` target type.
               
               Application Load Balancers do not support the `alb` target type.
        :param pulumi.Input[str] vpc_id: Identifier of the VPC in which to create the target group. Required when `target_type` is `instance`, `ip` or `alb`. Does not apply when `target_type` is `lambda`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TargetGroupState.__new__(_TargetGroupState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["arn_suffix"] = arn_suffix
        __props__.__dict__["connection_termination"] = connection_termination
        __props__.__dict__["deregistration_delay"] = deregistration_delay
        __props__.__dict__["health_check"] = health_check
        __props__.__dict__["ip_address_type"] = ip_address_type
        __props__.__dict__["lambda_multi_value_headers_enabled"] = lambda_multi_value_headers_enabled
        __props__.__dict__["load_balancer_arns"] = load_balancer_arns
        __props__.__dict__["load_balancing_algorithm_type"] = load_balancing_algorithm_type
        __props__.__dict__["load_balancing_anomaly_mitigation"] = load_balancing_anomaly_mitigation
        __props__.__dict__["load_balancing_cross_zone_enabled"] = load_balancing_cross_zone_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["name_prefix"] = name_prefix
        __props__.__dict__["port"] = port
        __props__.__dict__["preserve_client_ip"] = preserve_client_ip
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["protocol_version"] = protocol_version
        __props__.__dict__["proxy_protocol_v2"] = proxy_protocol_v2
        __props__.__dict__["slow_start"] = slow_start
        __props__.__dict__["stickiness"] = stickiness
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["target_failovers"] = target_failovers
        __props__.__dict__["target_health_states"] = target_health_states
        __props__.__dict__["target_type"] = target_type
        __props__.__dict__["vpc_id"] = vpc_id
        return TargetGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN of the Target Group (matches `id`).
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="arnSuffix")
    def arn_suffix(self) -> pulumi.Output[str]:
        """
        ARN suffix for use with CloudWatch Metrics.
        """
        return pulumi.get(self, "arn_suffix")

    @property
    @pulumi.getter(name="connectionTermination")
    def connection_termination(self) -> pulumi.Output[bool]:
        """
        Whether to terminate connections at the end of the deregistration timeout on Network Load Balancers. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#deregistration-delay) for more information. Default is `false`.
        """
        return pulumi.get(self, "connection_termination")

    @property
    @pulumi.getter(name="deregistrationDelay")
    def deregistration_delay(self) -> pulumi.Output[Optional[int]]:
        """
        Amount time for Elastic Load Balancing to wait before changing the state of a deregistering target from draining to unused. The range is 0-3600 seconds. The default value is 300 seconds.
        """
        return pulumi.get(self, "deregistration_delay")

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> pulumi.Output['outputs.TargetGroupHealthCheck']:
        """
        Health Check configuration block. Detailed below.
        """
        return pulumi.get(self, "health_check")

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> pulumi.Output[str]:
        """
        The type of IP addresses used by the target group, only supported when target type is set to `ip`. Possible values are `ipv4` or `ipv6`.
        """
        return pulumi.get(self, "ip_address_type")

    @property
    @pulumi.getter(name="lambdaMultiValueHeadersEnabled")
    def lambda_multi_value_headers_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the request and response headers exchanged between the load balancer and the Lambda function include arrays of values or strings. Only applies when `target_type` is `lambda`. Default is `false`.
        """
        return pulumi.get(self, "lambda_multi_value_headers_enabled")

    @property
    @pulumi.getter(name="loadBalancerArns")
    def load_balancer_arns(self) -> pulumi.Output[Sequence[str]]:
        """
        ARNs of the Load Balancers associated with the Target Group.
        """
        return pulumi.get(self, "load_balancer_arns")

    @property
    @pulumi.getter(name="loadBalancingAlgorithmType")
    def load_balancing_algorithm_type(self) -> pulumi.Output[str]:
        """
        Determines how the load balancer selects targets when routing requests. Only applicable for Application Load Balancer Target Groups. The value is `round_robin`, `least_outstanding_requests`, or `weighted_random`. The default is `round_robin`.
        """
        return pulumi.get(self, "load_balancing_algorithm_type")

    @property
    @pulumi.getter(name="loadBalancingAnomalyMitigation")
    def load_balancing_anomaly_mitigation(self) -> pulumi.Output[str]:
        """
        Determines whether to enable target anomaly mitigation.  Target anomaly mitigation is only supported by the `weighted_random` load balancing algorithm type.  See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#automatic-target-weights) for more information.  The value is `"on"` or `"off"`. The default is `"off"`.
        """
        return pulumi.get(self, "load_balancing_anomaly_mitigation")

    @property
    @pulumi.getter(name="loadBalancingCrossZoneEnabled")
    def load_balancing_cross_zone_enabled(self) -> pulumi.Output[str]:
        """
        Indicates whether cross zone load balancing is enabled. The value is `"true"`, `"false"` or `"use_load_balancer_configuration"`. The default is `"use_load_balancer_configuration"`.
        """
        return pulumi.get(self, "load_balancing_cross_zone_enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the target group. If omitted, this provider will assign a random, unique name. This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> pulumi.Output[str]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with `name`. Cannot be longer than 6 characters.
        """
        return pulumi.get(self, "name_prefix")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[int]]:
        """
        Port on which targets receive traffic, unless overridden when registering a specific target. Required when `target_type` is `instance`, `ip` or `alb`. Does not apply when `target_type` is `lambda`.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="preserveClientIp")
    def preserve_client_ip(self) -> pulumi.Output[str]:
        """
        Whether client IP preservation is enabled. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#client-ip-preservation) for more information.
        """
        return pulumi.get(self, "preserve_client_ip")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[Optional[str]]:
        """
        Protocol to use for routing traffic to the targets.
        Should be one of `GENEVE`, `HTTP`, `HTTPS`, `TCP`, `TCP_UDP`, `TLS`, or `UDP`.
        Required when `target_type` is `instance`, `ip`, or `alb`.
        Does not apply when `target_type` is `lambda`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="protocolVersion")
    def protocol_version(self) -> pulumi.Output[str]:
        """
        Only applicable when `protocol` is `HTTP` or `HTTPS`. The protocol version. Specify `GRPC` to send requests to targets using gRPC. Specify `HTTP2` to send requests to targets using HTTP/2. The default is `HTTP1`, which sends requests to targets using HTTP/1.1
        """
        return pulumi.get(self, "protocol_version")

    @property
    @pulumi.getter(name="proxyProtocolV2")
    def proxy_protocol_v2(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enable support for proxy protocol v2 on Network Load Balancers. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#proxy-protocol) for more information. Default is `false`.
        """
        return pulumi.get(self, "proxy_protocol_v2")

    @property
    @pulumi.getter(name="slowStart")
    def slow_start(self) -> pulumi.Output[Optional[int]]:
        """
        Amount time for targets to warm up before the load balancer sends them a full share of requests. The range is 30-900 seconds or 0 to disable. The default value is 0 seconds.
        """
        return pulumi.get(self, "slow_start")

    @property
    @pulumi.getter
    def stickiness(self) -> pulumi.Output['outputs.TargetGroupStickiness']:
        """
        Stickiness configuration block. Detailed below.
        """
        return pulumi.get(self, "stickiness")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="targetFailovers")
    def target_failovers(self) -> pulumi.Output[Sequence['outputs.TargetGroupTargetFailover']]:
        """
        Target failover block. Only applicable for Gateway Load Balancer target groups. See target_failover for more information.
        """
        return pulumi.get(self, "target_failovers")

    @property
    @pulumi.getter(name="targetHealthStates")
    def target_health_states(self) -> pulumi.Output[Sequence['outputs.TargetGroupTargetHealthState']]:
        """
        Target health state block. Only applicable for Network Load Balancer target groups when `protocol` is `TCP` or `TLS`. See target_health_state for more information.
        """
        return pulumi.get(self, "target_health_states")

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> pulumi.Output[Optional[str]]:
        """
        Type of target that you must specify when registering targets with this target group.
        See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_CreateTargetGroup.html) for supported values.
        The default is `instance`.

        Note that you can't specify targets for a target group using both instance IDs and IP addresses.

        If the target type is `ip`, specify IP addresses from the subnets of the virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP addresses.

        Network Load Balancers do not support the `lambda` target type.

        Application Load Balancers do not support the `alb` target type.
        """
        return pulumi.get(self, "target_type")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[Optional[str]]:
        """
        Identifier of the VPC in which to create the target group. Required when `target_type` is `instance`, `ip` or `alb`. Does not apply when `target_type` is `lambda`.
        """
        return pulumi.get(self, "vpc_id")

