# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['V2modelsSlotTypeArgs', 'V2modelsSlotType']

@pulumi.input_type
class V2modelsSlotTypeArgs:
    def __init__(__self__, *,
                 bot_id: pulumi.Input[str],
                 bot_version: pulumi.Input[str],
                 locale_id: pulumi.Input[str],
                 composite_slot_type_setting: Optional[pulumi.Input['V2modelsSlotTypeCompositeSlotTypeSettingArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 external_source_setting: Optional[pulumi.Input['V2modelsSlotTypeExternalSourceSettingArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent_slot_type_signature: Optional[pulumi.Input[str]] = None,
                 slot_type_values: Optional[pulumi.Input['V2modelsSlotTypeSlotTypeValuesArgs']] = None,
                 timeouts: Optional[pulumi.Input['V2modelsSlotTypeTimeoutsArgs']] = None,
                 value_selection_setting: Optional[pulumi.Input['V2modelsSlotTypeValueSelectionSettingArgs']] = None):
        """
        The set of arguments for constructing a V2modelsSlotType resource.
        :param pulumi.Input[str] bot_id: Identifier of the bot associated with this slot type.
        :param pulumi.Input[str] bot_version: Version of the bot associated with this slot type.
        :param pulumi.Input[str] locale_id: Identifier of the language and locale where this slot type is used. All of the bots, slot types, and slots used by the intent must have the same locale.
        :param pulumi.Input['V2modelsSlotTypeCompositeSlotTypeSettingArgs'] composite_slot_type_setting: Specifications for a composite slot type. See `composite_slot_type_setting` argument reference below.
        :param pulumi.Input[str] description: Description of the slot type.
        :param pulumi.Input['V2modelsSlotTypeExternalSourceSettingArgs'] external_source_setting: Type of external information used to create the slot type. See `external_source_setting` argument reference below.
        :param pulumi.Input[str] name: Name of the slot type
               
               The following arguments are optional:
        :param pulumi.Input[str] parent_slot_type_signature: Built-in slot type used as a parent of this slot type. When you define a parent slot type, the new slot type has the configuration of the parent slot type. Only AMAZON.AlphaNumeric is supported.
        :param pulumi.Input['V2modelsSlotTypeSlotTypeValuesArgs'] slot_type_values: List of SlotTypeValue objects that defines the values that the slot type can take. Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot. See `slot_type_values` argument reference below.
        :param pulumi.Input['V2modelsSlotTypeValueSelectionSettingArgs'] value_selection_setting: Determines the strategy that Amazon Lex uses to select a value from the list of possible values. The field can be set to one of the following values: `ORIGINAL_VALUE` returns the value entered by the user, if the user value is similar to the slot value. `TOP_RESOLUTION` if there is a resolution list for the slot, return the first value in the resolution list. If there is no resolution list, return null. If you don't specify the valueSelectionSetting parameter, the default is ORIGINAL_VALUE. See `value_selection_setting` argument reference below.
        """
        pulumi.set(__self__, "bot_id", bot_id)
        pulumi.set(__self__, "bot_version", bot_version)
        pulumi.set(__self__, "locale_id", locale_id)
        if composite_slot_type_setting is not None:
            pulumi.set(__self__, "composite_slot_type_setting", composite_slot_type_setting)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_source_setting is not None:
            pulumi.set(__self__, "external_source_setting", external_source_setting)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_slot_type_signature is not None:
            pulumi.set(__self__, "parent_slot_type_signature", parent_slot_type_signature)
        if slot_type_values is not None:
            pulumi.set(__self__, "slot_type_values", slot_type_values)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if value_selection_setting is not None:
            pulumi.set(__self__, "value_selection_setting", value_selection_setting)

    @property
    @pulumi.getter(name="botId")
    def bot_id(self) -> pulumi.Input[str]:
        """
        Identifier of the bot associated with this slot type.
        """
        return pulumi.get(self, "bot_id")

    @bot_id.setter
    def bot_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "bot_id", value)

    @property
    @pulumi.getter(name="botVersion")
    def bot_version(self) -> pulumi.Input[str]:
        """
        Version of the bot associated with this slot type.
        """
        return pulumi.get(self, "bot_version")

    @bot_version.setter
    def bot_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "bot_version", value)

    @property
    @pulumi.getter(name="localeId")
    def locale_id(self) -> pulumi.Input[str]:
        """
        Identifier of the language and locale where this slot type is used. All of the bots, slot types, and slots used by the intent must have the same locale.
        """
        return pulumi.get(self, "locale_id")

    @locale_id.setter
    def locale_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "locale_id", value)

    @property
    @pulumi.getter(name="compositeSlotTypeSetting")
    def composite_slot_type_setting(self) -> Optional[pulumi.Input['V2modelsSlotTypeCompositeSlotTypeSettingArgs']]:
        """
        Specifications for a composite slot type. See `composite_slot_type_setting` argument reference below.
        """
        return pulumi.get(self, "composite_slot_type_setting")

    @composite_slot_type_setting.setter
    def composite_slot_type_setting(self, value: Optional[pulumi.Input['V2modelsSlotTypeCompositeSlotTypeSettingArgs']]):
        pulumi.set(self, "composite_slot_type_setting", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the slot type.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="externalSourceSetting")
    def external_source_setting(self) -> Optional[pulumi.Input['V2modelsSlotTypeExternalSourceSettingArgs']]:
        """
        Type of external information used to create the slot type. See `external_source_setting` argument reference below.
        """
        return pulumi.get(self, "external_source_setting")

    @external_source_setting.setter
    def external_source_setting(self, value: Optional[pulumi.Input['V2modelsSlotTypeExternalSourceSettingArgs']]):
        pulumi.set(self, "external_source_setting", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the slot type

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parentSlotTypeSignature")
    def parent_slot_type_signature(self) -> Optional[pulumi.Input[str]]:
        """
        Built-in slot type used as a parent of this slot type. When you define a parent slot type, the new slot type has the configuration of the parent slot type. Only AMAZON.AlphaNumeric is supported.
        """
        return pulumi.get(self, "parent_slot_type_signature")

    @parent_slot_type_signature.setter
    def parent_slot_type_signature(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_slot_type_signature", value)

    @property
    @pulumi.getter(name="slotTypeValues")
    def slot_type_values(self) -> Optional[pulumi.Input['V2modelsSlotTypeSlotTypeValuesArgs']]:
        """
        List of SlotTypeValue objects that defines the values that the slot type can take. Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot. See `slot_type_values` argument reference below.
        """
        return pulumi.get(self, "slot_type_values")

    @slot_type_values.setter
    def slot_type_values(self, value: Optional[pulumi.Input['V2modelsSlotTypeSlotTypeValuesArgs']]):
        pulumi.set(self, "slot_type_values", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['V2modelsSlotTypeTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['V2modelsSlotTypeTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="valueSelectionSetting")
    def value_selection_setting(self) -> Optional[pulumi.Input['V2modelsSlotTypeValueSelectionSettingArgs']]:
        """
        Determines the strategy that Amazon Lex uses to select a value from the list of possible values. The field can be set to one of the following values: `ORIGINAL_VALUE` returns the value entered by the user, if the user value is similar to the slot value. `TOP_RESOLUTION` if there is a resolution list for the slot, return the first value in the resolution list. If there is no resolution list, return null. If you don't specify the valueSelectionSetting parameter, the default is ORIGINAL_VALUE. See `value_selection_setting` argument reference below.
        """
        return pulumi.get(self, "value_selection_setting")

    @value_selection_setting.setter
    def value_selection_setting(self, value: Optional[pulumi.Input['V2modelsSlotTypeValueSelectionSettingArgs']]):
        pulumi.set(self, "value_selection_setting", value)


@pulumi.input_type
class _V2modelsSlotTypeState:
    def __init__(__self__, *,
                 bot_id: Optional[pulumi.Input[str]] = None,
                 bot_version: Optional[pulumi.Input[str]] = None,
                 composite_slot_type_setting: Optional[pulumi.Input['V2modelsSlotTypeCompositeSlotTypeSettingArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 external_source_setting: Optional[pulumi.Input['V2modelsSlotTypeExternalSourceSettingArgs']] = None,
                 locale_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent_slot_type_signature: Optional[pulumi.Input[str]] = None,
                 slot_type_id: Optional[pulumi.Input[str]] = None,
                 slot_type_values: Optional[pulumi.Input['V2modelsSlotTypeSlotTypeValuesArgs']] = None,
                 timeouts: Optional[pulumi.Input['V2modelsSlotTypeTimeoutsArgs']] = None,
                 value_selection_setting: Optional[pulumi.Input['V2modelsSlotTypeValueSelectionSettingArgs']] = None):
        """
        Input properties used for looking up and filtering V2modelsSlotType resources.
        :param pulumi.Input[str] bot_id: Identifier of the bot associated with this slot type.
        :param pulumi.Input[str] bot_version: Version of the bot associated with this slot type.
        :param pulumi.Input['V2modelsSlotTypeCompositeSlotTypeSettingArgs'] composite_slot_type_setting: Specifications for a composite slot type. See `composite_slot_type_setting` argument reference below.
        :param pulumi.Input[str] description: Description of the slot type.
        :param pulumi.Input['V2modelsSlotTypeExternalSourceSettingArgs'] external_source_setting: Type of external information used to create the slot type. See `external_source_setting` argument reference below.
        :param pulumi.Input[str] locale_id: Identifier of the language and locale where this slot type is used. All of the bots, slot types, and slots used by the intent must have the same locale.
        :param pulumi.Input[str] name: Name of the slot type
               
               The following arguments are optional:
        :param pulumi.Input[str] parent_slot_type_signature: Built-in slot type used as a parent of this slot type. When you define a parent slot type, the new slot type has the configuration of the parent slot type. Only AMAZON.AlphaNumeric is supported.
        :param pulumi.Input[str] slot_type_id: Unique identifier assigned to a slot type. This refers to either a built-in slot type or the unique slotTypeId of a custom slot type.
        :param pulumi.Input['V2modelsSlotTypeSlotTypeValuesArgs'] slot_type_values: List of SlotTypeValue objects that defines the values that the slot type can take. Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot. See `slot_type_values` argument reference below.
        :param pulumi.Input['V2modelsSlotTypeValueSelectionSettingArgs'] value_selection_setting: Determines the strategy that Amazon Lex uses to select a value from the list of possible values. The field can be set to one of the following values: `ORIGINAL_VALUE` returns the value entered by the user, if the user value is similar to the slot value. `TOP_RESOLUTION` if there is a resolution list for the slot, return the first value in the resolution list. If there is no resolution list, return null. If you don't specify the valueSelectionSetting parameter, the default is ORIGINAL_VALUE. See `value_selection_setting` argument reference below.
        """
        if bot_id is not None:
            pulumi.set(__self__, "bot_id", bot_id)
        if bot_version is not None:
            pulumi.set(__self__, "bot_version", bot_version)
        if composite_slot_type_setting is not None:
            pulumi.set(__self__, "composite_slot_type_setting", composite_slot_type_setting)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_source_setting is not None:
            pulumi.set(__self__, "external_source_setting", external_source_setting)
        if locale_id is not None:
            pulumi.set(__self__, "locale_id", locale_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_slot_type_signature is not None:
            pulumi.set(__self__, "parent_slot_type_signature", parent_slot_type_signature)
        if slot_type_id is not None:
            pulumi.set(__self__, "slot_type_id", slot_type_id)
        if slot_type_values is not None:
            pulumi.set(__self__, "slot_type_values", slot_type_values)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if value_selection_setting is not None:
            pulumi.set(__self__, "value_selection_setting", value_selection_setting)

    @property
    @pulumi.getter(name="botId")
    def bot_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the bot associated with this slot type.
        """
        return pulumi.get(self, "bot_id")

    @bot_id.setter
    def bot_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bot_id", value)

    @property
    @pulumi.getter(name="botVersion")
    def bot_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the bot associated with this slot type.
        """
        return pulumi.get(self, "bot_version")

    @bot_version.setter
    def bot_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bot_version", value)

    @property
    @pulumi.getter(name="compositeSlotTypeSetting")
    def composite_slot_type_setting(self) -> Optional[pulumi.Input['V2modelsSlotTypeCompositeSlotTypeSettingArgs']]:
        """
        Specifications for a composite slot type. See `composite_slot_type_setting` argument reference below.
        """
        return pulumi.get(self, "composite_slot_type_setting")

    @composite_slot_type_setting.setter
    def composite_slot_type_setting(self, value: Optional[pulumi.Input['V2modelsSlotTypeCompositeSlotTypeSettingArgs']]):
        pulumi.set(self, "composite_slot_type_setting", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the slot type.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="externalSourceSetting")
    def external_source_setting(self) -> Optional[pulumi.Input['V2modelsSlotTypeExternalSourceSettingArgs']]:
        """
        Type of external information used to create the slot type. See `external_source_setting` argument reference below.
        """
        return pulumi.get(self, "external_source_setting")

    @external_source_setting.setter
    def external_source_setting(self, value: Optional[pulumi.Input['V2modelsSlotTypeExternalSourceSettingArgs']]):
        pulumi.set(self, "external_source_setting", value)

    @property
    @pulumi.getter(name="localeId")
    def locale_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the language and locale where this slot type is used. All of the bots, slot types, and slots used by the intent must have the same locale.
        """
        return pulumi.get(self, "locale_id")

    @locale_id.setter
    def locale_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "locale_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the slot type

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parentSlotTypeSignature")
    def parent_slot_type_signature(self) -> Optional[pulumi.Input[str]]:
        """
        Built-in slot type used as a parent of this slot type. When you define a parent slot type, the new slot type has the configuration of the parent slot type. Only AMAZON.AlphaNumeric is supported.
        """
        return pulumi.get(self, "parent_slot_type_signature")

    @parent_slot_type_signature.setter
    def parent_slot_type_signature(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_slot_type_signature", value)

    @property
    @pulumi.getter(name="slotTypeId")
    def slot_type_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier assigned to a slot type. This refers to either a built-in slot type or the unique slotTypeId of a custom slot type.
        """
        return pulumi.get(self, "slot_type_id")

    @slot_type_id.setter
    def slot_type_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slot_type_id", value)

    @property
    @pulumi.getter(name="slotTypeValues")
    def slot_type_values(self) -> Optional[pulumi.Input['V2modelsSlotTypeSlotTypeValuesArgs']]:
        """
        List of SlotTypeValue objects that defines the values that the slot type can take. Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot. See `slot_type_values` argument reference below.
        """
        return pulumi.get(self, "slot_type_values")

    @slot_type_values.setter
    def slot_type_values(self, value: Optional[pulumi.Input['V2modelsSlotTypeSlotTypeValuesArgs']]):
        pulumi.set(self, "slot_type_values", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['V2modelsSlotTypeTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['V2modelsSlotTypeTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="valueSelectionSetting")
    def value_selection_setting(self) -> Optional[pulumi.Input['V2modelsSlotTypeValueSelectionSettingArgs']]:
        """
        Determines the strategy that Amazon Lex uses to select a value from the list of possible values. The field can be set to one of the following values: `ORIGINAL_VALUE` returns the value entered by the user, if the user value is similar to the slot value. `TOP_RESOLUTION` if there is a resolution list for the slot, return the first value in the resolution list. If there is no resolution list, return null. If you don't specify the valueSelectionSetting parameter, the default is ORIGINAL_VALUE. See `value_selection_setting` argument reference below.
        """
        return pulumi.get(self, "value_selection_setting")

    @value_selection_setting.setter
    def value_selection_setting(self, value: Optional[pulumi.Input['V2modelsSlotTypeValueSelectionSettingArgs']]):
        pulumi.set(self, "value_selection_setting", value)


class V2modelsSlotType(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bot_id: Optional[pulumi.Input[str]] = None,
                 bot_version: Optional[pulumi.Input[str]] = None,
                 composite_slot_type_setting: Optional[pulumi.Input[pulumi.InputType['V2modelsSlotTypeCompositeSlotTypeSettingArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 external_source_setting: Optional[pulumi.Input[pulumi.InputType['V2modelsSlotTypeExternalSourceSettingArgs']]] = None,
                 locale_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent_slot_type_signature: Optional[pulumi.Input[str]] = None,
                 slot_type_values: Optional[pulumi.Input[pulumi.InputType['V2modelsSlotTypeSlotTypeValuesArgs']]] = None,
                 timeouts: Optional[pulumi.Input[pulumi.InputType['V2modelsSlotTypeTimeoutsArgs']]] = None,
                 value_selection_setting: Optional[pulumi.Input[pulumi.InputType['V2modelsSlotTypeValueSelectionSettingArgs']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Lex V2 Models Slot Type.

        ## Example Usage

        ### Basic Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.iam.RolePolicyAttachment("test",
            role=test_aws_iam_role["name"],
            policy_arn=f"arn:{current['partition']}:iam::aws:policy/AmazonLexFullAccess")
        test_v2models_bot = aws.lex.V2modelsBot("test",
            name="testbot",
            idle_session_ttl_in_seconds=60,
            role_arn=test_aws_iam_role["arn"],
            data_privacies=[aws.lex.V2modelsBotDataPrivacyArgs(
                child_directed=True,
            )])
        test_v2models_bot_locale = aws.lex.V2modelsBotLocale("test",
            locale_id="en_US",
            bot_id=test_v2models_bot.id,
            bot_version="DRAFT",
            n_lu_intent_confidence_threshold=0.7)
        test_v2models_bot_version = aws.lex.V2modelsBotVersion("test",
            bot_id=test_v2models_bot.id,
            locale_specification=test_v2models_bot_locale.locale_id.apply(lambda locale_id: {
                locale_id: {
                    "sourceBotVersion": "DRAFT",
                },
            }))
        test_v2models_slot_type = aws.lex.V2modelsSlotType("test",
            bot_id=test_v2models_bot.id,
            bot_version=test_v2models_bot_locale.bot_version,
            name="test",
            locale_id=test_v2models_bot_locale.locale_id)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Lex V2 Models Slot Type using the `example_id_arg`. For example:

        ```sh
        $ pulumi import aws:lex/v2modelsSlotType:V2modelsSlotType example bot-1234,DRAFT,en_US,slot_type-id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bot_id: Identifier of the bot associated with this slot type.
        :param pulumi.Input[str] bot_version: Version of the bot associated with this slot type.
        :param pulumi.Input[pulumi.InputType['V2modelsSlotTypeCompositeSlotTypeSettingArgs']] composite_slot_type_setting: Specifications for a composite slot type. See `composite_slot_type_setting` argument reference below.
        :param pulumi.Input[str] description: Description of the slot type.
        :param pulumi.Input[pulumi.InputType['V2modelsSlotTypeExternalSourceSettingArgs']] external_source_setting: Type of external information used to create the slot type. See `external_source_setting` argument reference below.
        :param pulumi.Input[str] locale_id: Identifier of the language and locale where this slot type is used. All of the bots, slot types, and slots used by the intent must have the same locale.
        :param pulumi.Input[str] name: Name of the slot type
               
               The following arguments are optional:
        :param pulumi.Input[str] parent_slot_type_signature: Built-in slot type used as a parent of this slot type. When you define a parent slot type, the new slot type has the configuration of the parent slot type. Only AMAZON.AlphaNumeric is supported.
        :param pulumi.Input[pulumi.InputType['V2modelsSlotTypeSlotTypeValuesArgs']] slot_type_values: List of SlotTypeValue objects that defines the values that the slot type can take. Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot. See `slot_type_values` argument reference below.
        :param pulumi.Input[pulumi.InputType['V2modelsSlotTypeValueSelectionSettingArgs']] value_selection_setting: Determines the strategy that Amazon Lex uses to select a value from the list of possible values. The field can be set to one of the following values: `ORIGINAL_VALUE` returns the value entered by the user, if the user value is similar to the slot value. `TOP_RESOLUTION` if there is a resolution list for the slot, return the first value in the resolution list. If there is no resolution list, return null. If you don't specify the valueSelectionSetting parameter, the default is ORIGINAL_VALUE. See `value_selection_setting` argument reference below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: V2modelsSlotTypeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Lex V2 Models Slot Type.

        ## Example Usage

        ### Basic Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.iam.RolePolicyAttachment("test",
            role=test_aws_iam_role["name"],
            policy_arn=f"arn:{current['partition']}:iam::aws:policy/AmazonLexFullAccess")
        test_v2models_bot = aws.lex.V2modelsBot("test",
            name="testbot",
            idle_session_ttl_in_seconds=60,
            role_arn=test_aws_iam_role["arn"],
            data_privacies=[aws.lex.V2modelsBotDataPrivacyArgs(
                child_directed=True,
            )])
        test_v2models_bot_locale = aws.lex.V2modelsBotLocale("test",
            locale_id="en_US",
            bot_id=test_v2models_bot.id,
            bot_version="DRAFT",
            n_lu_intent_confidence_threshold=0.7)
        test_v2models_bot_version = aws.lex.V2modelsBotVersion("test",
            bot_id=test_v2models_bot.id,
            locale_specification=test_v2models_bot_locale.locale_id.apply(lambda locale_id: {
                locale_id: {
                    "sourceBotVersion": "DRAFT",
                },
            }))
        test_v2models_slot_type = aws.lex.V2modelsSlotType("test",
            bot_id=test_v2models_bot.id,
            bot_version=test_v2models_bot_locale.bot_version,
            name="test",
            locale_id=test_v2models_bot_locale.locale_id)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Lex V2 Models Slot Type using the `example_id_arg`. For example:

        ```sh
        $ pulumi import aws:lex/v2modelsSlotType:V2modelsSlotType example bot-1234,DRAFT,en_US,slot_type-id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param V2modelsSlotTypeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(V2modelsSlotTypeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bot_id: Optional[pulumi.Input[str]] = None,
                 bot_version: Optional[pulumi.Input[str]] = None,
                 composite_slot_type_setting: Optional[pulumi.Input[pulumi.InputType['V2modelsSlotTypeCompositeSlotTypeSettingArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 external_source_setting: Optional[pulumi.Input[pulumi.InputType['V2modelsSlotTypeExternalSourceSettingArgs']]] = None,
                 locale_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent_slot_type_signature: Optional[pulumi.Input[str]] = None,
                 slot_type_values: Optional[pulumi.Input[pulumi.InputType['V2modelsSlotTypeSlotTypeValuesArgs']]] = None,
                 timeouts: Optional[pulumi.Input[pulumi.InputType['V2modelsSlotTypeTimeoutsArgs']]] = None,
                 value_selection_setting: Optional[pulumi.Input[pulumi.InputType['V2modelsSlotTypeValueSelectionSettingArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = V2modelsSlotTypeArgs.__new__(V2modelsSlotTypeArgs)

            if bot_id is None and not opts.urn:
                raise TypeError("Missing required property 'bot_id'")
            __props__.__dict__["bot_id"] = bot_id
            if bot_version is None and not opts.urn:
                raise TypeError("Missing required property 'bot_version'")
            __props__.__dict__["bot_version"] = bot_version
            __props__.__dict__["composite_slot_type_setting"] = composite_slot_type_setting
            __props__.__dict__["description"] = description
            __props__.__dict__["external_source_setting"] = external_source_setting
            if locale_id is None and not opts.urn:
                raise TypeError("Missing required property 'locale_id'")
            __props__.__dict__["locale_id"] = locale_id
            __props__.__dict__["name"] = name
            __props__.__dict__["parent_slot_type_signature"] = parent_slot_type_signature
            __props__.__dict__["slot_type_values"] = slot_type_values
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["value_selection_setting"] = value_selection_setting
            __props__.__dict__["slot_type_id"] = None
        super(V2modelsSlotType, __self__).__init__(
            'aws:lex/v2modelsSlotType:V2modelsSlotType',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bot_id: Optional[pulumi.Input[str]] = None,
            bot_version: Optional[pulumi.Input[str]] = None,
            composite_slot_type_setting: Optional[pulumi.Input[pulumi.InputType['V2modelsSlotTypeCompositeSlotTypeSettingArgs']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            external_source_setting: Optional[pulumi.Input[pulumi.InputType['V2modelsSlotTypeExternalSourceSettingArgs']]] = None,
            locale_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            parent_slot_type_signature: Optional[pulumi.Input[str]] = None,
            slot_type_id: Optional[pulumi.Input[str]] = None,
            slot_type_values: Optional[pulumi.Input[pulumi.InputType['V2modelsSlotTypeSlotTypeValuesArgs']]] = None,
            timeouts: Optional[pulumi.Input[pulumi.InputType['V2modelsSlotTypeTimeoutsArgs']]] = None,
            value_selection_setting: Optional[pulumi.Input[pulumi.InputType['V2modelsSlotTypeValueSelectionSettingArgs']]] = None) -> 'V2modelsSlotType':
        """
        Get an existing V2modelsSlotType resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bot_id: Identifier of the bot associated with this slot type.
        :param pulumi.Input[str] bot_version: Version of the bot associated with this slot type.
        :param pulumi.Input[pulumi.InputType['V2modelsSlotTypeCompositeSlotTypeSettingArgs']] composite_slot_type_setting: Specifications for a composite slot type. See `composite_slot_type_setting` argument reference below.
        :param pulumi.Input[str] description: Description of the slot type.
        :param pulumi.Input[pulumi.InputType['V2modelsSlotTypeExternalSourceSettingArgs']] external_source_setting: Type of external information used to create the slot type. See `external_source_setting` argument reference below.
        :param pulumi.Input[str] locale_id: Identifier of the language and locale where this slot type is used. All of the bots, slot types, and slots used by the intent must have the same locale.
        :param pulumi.Input[str] name: Name of the slot type
               
               The following arguments are optional:
        :param pulumi.Input[str] parent_slot_type_signature: Built-in slot type used as a parent of this slot type. When you define a parent slot type, the new slot type has the configuration of the parent slot type. Only AMAZON.AlphaNumeric is supported.
        :param pulumi.Input[str] slot_type_id: Unique identifier assigned to a slot type. This refers to either a built-in slot type or the unique slotTypeId of a custom slot type.
        :param pulumi.Input[pulumi.InputType['V2modelsSlotTypeSlotTypeValuesArgs']] slot_type_values: List of SlotTypeValue objects that defines the values that the slot type can take. Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot. See `slot_type_values` argument reference below.
        :param pulumi.Input[pulumi.InputType['V2modelsSlotTypeValueSelectionSettingArgs']] value_selection_setting: Determines the strategy that Amazon Lex uses to select a value from the list of possible values. The field can be set to one of the following values: `ORIGINAL_VALUE` returns the value entered by the user, if the user value is similar to the slot value. `TOP_RESOLUTION` if there is a resolution list for the slot, return the first value in the resolution list. If there is no resolution list, return null. If you don't specify the valueSelectionSetting parameter, the default is ORIGINAL_VALUE. See `value_selection_setting` argument reference below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _V2modelsSlotTypeState.__new__(_V2modelsSlotTypeState)

        __props__.__dict__["bot_id"] = bot_id
        __props__.__dict__["bot_version"] = bot_version
        __props__.__dict__["composite_slot_type_setting"] = composite_slot_type_setting
        __props__.__dict__["description"] = description
        __props__.__dict__["external_source_setting"] = external_source_setting
        __props__.__dict__["locale_id"] = locale_id
        __props__.__dict__["name"] = name
        __props__.__dict__["parent_slot_type_signature"] = parent_slot_type_signature
        __props__.__dict__["slot_type_id"] = slot_type_id
        __props__.__dict__["slot_type_values"] = slot_type_values
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["value_selection_setting"] = value_selection_setting
        return V2modelsSlotType(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="botId")
    def bot_id(self) -> pulumi.Output[str]:
        """
        Identifier of the bot associated with this slot type.
        """
        return pulumi.get(self, "bot_id")

    @property
    @pulumi.getter(name="botVersion")
    def bot_version(self) -> pulumi.Output[str]:
        """
        Version of the bot associated with this slot type.
        """
        return pulumi.get(self, "bot_version")

    @property
    @pulumi.getter(name="compositeSlotTypeSetting")
    def composite_slot_type_setting(self) -> pulumi.Output[Optional['outputs.V2modelsSlotTypeCompositeSlotTypeSetting']]:
        """
        Specifications for a composite slot type. See `composite_slot_type_setting` argument reference below.
        """
        return pulumi.get(self, "composite_slot_type_setting")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the slot type.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="externalSourceSetting")
    def external_source_setting(self) -> pulumi.Output[Optional['outputs.V2modelsSlotTypeExternalSourceSetting']]:
        """
        Type of external information used to create the slot type. See `external_source_setting` argument reference below.
        """
        return pulumi.get(self, "external_source_setting")

    @property
    @pulumi.getter(name="localeId")
    def locale_id(self) -> pulumi.Output[str]:
        """
        Identifier of the language and locale where this slot type is used. All of the bots, slot types, and slots used by the intent must have the same locale.
        """
        return pulumi.get(self, "locale_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the slot type

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parentSlotTypeSignature")
    def parent_slot_type_signature(self) -> pulumi.Output[Optional[str]]:
        """
        Built-in slot type used as a parent of this slot type. When you define a parent slot type, the new slot type has the configuration of the parent slot type. Only AMAZON.AlphaNumeric is supported.
        """
        return pulumi.get(self, "parent_slot_type_signature")

    @property
    @pulumi.getter(name="slotTypeId")
    def slot_type_id(self) -> pulumi.Output[str]:
        """
        Unique identifier assigned to a slot type. This refers to either a built-in slot type or the unique slotTypeId of a custom slot type.
        """
        return pulumi.get(self, "slot_type_id")

    @property
    @pulumi.getter(name="slotTypeValues")
    def slot_type_values(self) -> pulumi.Output[Optional['outputs.V2modelsSlotTypeSlotTypeValues']]:
        """
        List of SlotTypeValue objects that defines the values that the slot type can take. Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot. See `slot_type_values` argument reference below.
        """
        return pulumi.get(self, "slot_type_values")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.V2modelsSlotTypeTimeouts']]:
        return pulumi.get(self, "timeouts")

    @property
    @pulumi.getter(name="valueSelectionSetting")
    def value_selection_setting(self) -> pulumi.Output[Optional['outputs.V2modelsSlotTypeValueSelectionSetting']]:
        """
        Determines the strategy that Amazon Lex uses to select a value from the list of possible values. The field can be set to one of the following values: `ORIGINAL_VALUE` returns the value entered by the user, if the user value is similar to the slot value. `TOP_RESOLUTION` if there is a resolution list for the slot, return the first value in the resolution list. If there is no resolution list, return null. If you don't specify the valueSelectionSetting parameter, the default is ORIGINAL_VALUE. See `value_selection_setting` argument reference below.
        """
        return pulumi.get(self, "value_selection_setting")

