# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['LbStickinessPolicyArgs', 'LbStickinessPolicy']

@pulumi.input_type
class LbStickinessPolicyArgs:
    def __init__(__self__, *,
                 cookie_duration: pulumi.Input[int],
                 enabled: pulumi.Input[bool],
                 lb_name: pulumi.Input[str]):
        """
        The set of arguments for constructing a LbStickinessPolicy resource.
        :param pulumi.Input[int] cookie_duration: The cookie duration in seconds. This determines the length of the session stickiness.
        :param pulumi.Input[bool] enabled: The Session Stickiness state of the load balancer. `true` to activate session stickiness or `false` to deactivate session stickiness.
        :param pulumi.Input[str] lb_name: The name of the load balancer to which you want to enable session stickiness.
        """
        pulumi.set(__self__, "cookie_duration", cookie_duration)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "lb_name", lb_name)

    @property
    @pulumi.getter(name="cookieDuration")
    def cookie_duration(self) -> pulumi.Input[int]:
        """
        The cookie duration in seconds. This determines the length of the session stickiness.
        """
        return pulumi.get(self, "cookie_duration")

    @cookie_duration.setter
    def cookie_duration(self, value: pulumi.Input[int]):
        pulumi.set(self, "cookie_duration", value)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        The Session Stickiness state of the load balancer. `true` to activate session stickiness or `false` to deactivate session stickiness.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="lbName")
    def lb_name(self) -> pulumi.Input[str]:
        """
        The name of the load balancer to which you want to enable session stickiness.
        """
        return pulumi.get(self, "lb_name")

    @lb_name.setter
    def lb_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "lb_name", value)


@pulumi.input_type
class _LbStickinessPolicyState:
    def __init__(__self__, *,
                 cookie_duration: Optional[pulumi.Input[int]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 lb_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering LbStickinessPolicy resources.
        :param pulumi.Input[int] cookie_duration: The cookie duration in seconds. This determines the length of the session stickiness.
        :param pulumi.Input[bool] enabled: The Session Stickiness state of the load balancer. `true` to activate session stickiness or `false` to deactivate session stickiness.
        :param pulumi.Input[str] lb_name: The name of the load balancer to which you want to enable session stickiness.
        """
        if cookie_duration is not None:
            pulumi.set(__self__, "cookie_duration", cookie_duration)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if lb_name is not None:
            pulumi.set(__self__, "lb_name", lb_name)

    @property
    @pulumi.getter(name="cookieDuration")
    def cookie_duration(self) -> Optional[pulumi.Input[int]]:
        """
        The cookie duration in seconds. This determines the length of the session stickiness.
        """
        return pulumi.get(self, "cookie_duration")

    @cookie_duration.setter
    def cookie_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cookie_duration", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The Session Stickiness state of the load balancer. `true` to activate session stickiness or `false` to deactivate session stickiness.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="lbName")
    def lb_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the load balancer to which you want to enable session stickiness.
        """
        return pulumi.get(self, "lb_name")

    @lb_name.setter
    def lb_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lb_name", value)


class LbStickinessPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cookie_duration: Optional[pulumi.Input[int]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 lb_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Configures Session Stickiness for a Lightsail Load Balancer.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.lightsail.Lb("test",
            name="test-load-balancer",
            health_check_path="/",
            instance_port=80,
            tags={
                "foo": "bar",
            })
        test_lb_stickiness_policy = aws.lightsail.LbStickinessPolicy("test",
            lb_name=test.name,
            cookie_duration=900,
            enabled=True)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import `aws_lightsail_lb_stickiness_policy` using the `lb_name` attribute. For example:

        ```sh
        $ pulumi import aws:lightsail/lbStickinessPolicy:LbStickinessPolicy test example-load-balancer
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] cookie_duration: The cookie duration in seconds. This determines the length of the session stickiness.
        :param pulumi.Input[bool] enabled: The Session Stickiness state of the load balancer. `true` to activate session stickiness or `false` to deactivate session stickiness.
        :param pulumi.Input[str] lb_name: The name of the load balancer to which you want to enable session stickiness.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LbStickinessPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Configures Session Stickiness for a Lightsail Load Balancer.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.lightsail.Lb("test",
            name="test-load-balancer",
            health_check_path="/",
            instance_port=80,
            tags={
                "foo": "bar",
            })
        test_lb_stickiness_policy = aws.lightsail.LbStickinessPolicy("test",
            lb_name=test.name,
            cookie_duration=900,
            enabled=True)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import `aws_lightsail_lb_stickiness_policy` using the `lb_name` attribute. For example:

        ```sh
        $ pulumi import aws:lightsail/lbStickinessPolicy:LbStickinessPolicy test example-load-balancer
        ```

        :param str resource_name: The name of the resource.
        :param LbStickinessPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LbStickinessPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cookie_duration: Optional[pulumi.Input[int]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 lb_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LbStickinessPolicyArgs.__new__(LbStickinessPolicyArgs)

            if cookie_duration is None and not opts.urn:
                raise TypeError("Missing required property 'cookie_duration'")
            __props__.__dict__["cookie_duration"] = cookie_duration
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            if lb_name is None and not opts.urn:
                raise TypeError("Missing required property 'lb_name'")
            __props__.__dict__["lb_name"] = lb_name
        super(LbStickinessPolicy, __self__).__init__(
            'aws:lightsail/lbStickinessPolicy:LbStickinessPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cookie_duration: Optional[pulumi.Input[int]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            lb_name: Optional[pulumi.Input[str]] = None) -> 'LbStickinessPolicy':
        """
        Get an existing LbStickinessPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] cookie_duration: The cookie duration in seconds. This determines the length of the session stickiness.
        :param pulumi.Input[bool] enabled: The Session Stickiness state of the load balancer. `true` to activate session stickiness or `false` to deactivate session stickiness.
        :param pulumi.Input[str] lb_name: The name of the load balancer to which you want to enable session stickiness.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LbStickinessPolicyState.__new__(_LbStickinessPolicyState)

        __props__.__dict__["cookie_duration"] = cookie_duration
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["lb_name"] = lb_name
        return LbStickinessPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cookieDuration")
    def cookie_duration(self) -> pulumi.Output[int]:
        """
        The cookie duration in seconds. This determines the length of the session stickiness.
        """
        return pulumi.get(self, "cookie_duration")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        The Session Stickiness state of the load balancer. `true` to activate session stickiness or `false` to deactivate session stickiness.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="lbName")
    def lb_name(self) -> pulumi.Output[str]:
        """
        The name of the load balancer to which you want to enable session stickiness.
        """
        return pulumi.get(self, "lb_name")

