# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['StaticIpAttachmentArgs', 'StaticIpAttachment']

@pulumi.input_type
class StaticIpAttachmentArgs:
    def __init__(__self__, *,
                 instance_name: pulumi.Input[str],
                 static_ip_name: pulumi.Input[str]):
        """
        The set of arguments for constructing a StaticIpAttachment resource.
        :param pulumi.Input[str] instance_name: The name of the Lightsail instance to attach the IP to
        :param pulumi.Input[str] static_ip_name: The name of the allocated static IP
        """
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "static_ip_name", static_ip_name)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Input[str]:
        """
        The name of the Lightsail instance to attach the IP to
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="staticIpName")
    def static_ip_name(self) -> pulumi.Input[str]:
        """
        The name of the allocated static IP
        """
        return pulumi.get(self, "static_ip_name")

    @static_ip_name.setter
    def static_ip_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "static_ip_name", value)


@pulumi.input_type
class _StaticIpAttachmentState:
    def __init__(__self__, *,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 static_ip_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering StaticIpAttachment resources.
        :param pulumi.Input[str] instance_name: The name of the Lightsail instance to attach the IP to
        :param pulumi.Input[str] ip_address: The allocated static IP address
        :param pulumi.Input[str] static_ip_name: The name of the allocated static IP
        """
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if static_ip_name is not None:
            pulumi.set(__self__, "static_ip_name", static_ip_name)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Lightsail instance to attach the IP to
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The allocated static IP address
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="staticIpName")
    def static_ip_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the allocated static IP
        """
        return pulumi.get(self, "static_ip_name")

    @static_ip_name.setter
    def static_ip_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "static_ip_name", value)


class StaticIpAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 static_ip_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a static IP address attachment - relationship between a Lightsail static IP & Lightsail instance.

        > **Note:** Lightsail is currently only supported in a limited number of AWS Regions, please see ["Regions and Availability Zones in Amazon Lightsail"](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail) for more details

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        test_static_ip = aws.lightsail.StaticIp("test", name="example")
        test_instance = aws.lightsail.Instance("test",
            name="example",
            availability_zone="us-east-1b",
            blueprint_id="string",
            bundle_id="string",
            key_pair_name="some_key_name")
        test = aws.lightsail.StaticIpAttachment("test",
            static_ip_name=test_static_ip.id,
            instance_name=test_instance.id)
        ```
        <!--End PulumiCodeChooser -->

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] instance_name: The name of the Lightsail instance to attach the IP to
        :param pulumi.Input[str] static_ip_name: The name of the allocated static IP
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StaticIpAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a static IP address attachment - relationship between a Lightsail static IP & Lightsail instance.

        > **Note:** Lightsail is currently only supported in a limited number of AWS Regions, please see ["Regions and Availability Zones in Amazon Lightsail"](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail) for more details

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        test_static_ip = aws.lightsail.StaticIp("test", name="example")
        test_instance = aws.lightsail.Instance("test",
            name="example",
            availability_zone="us-east-1b",
            blueprint_id="string",
            bundle_id="string",
            key_pair_name="some_key_name")
        test = aws.lightsail.StaticIpAttachment("test",
            static_ip_name=test_static_ip.id,
            instance_name=test_instance.id)
        ```
        <!--End PulumiCodeChooser -->

        :param str resource_name: The name of the resource.
        :param StaticIpAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StaticIpAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 static_ip_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StaticIpAttachmentArgs.__new__(StaticIpAttachmentArgs)

            if instance_name is None and not opts.urn:
                raise TypeError("Missing required property 'instance_name'")
            __props__.__dict__["instance_name"] = instance_name
            if static_ip_name is None and not opts.urn:
                raise TypeError("Missing required property 'static_ip_name'")
            __props__.__dict__["static_ip_name"] = static_ip_name
            __props__.__dict__["ip_address"] = None
        super(StaticIpAttachment, __self__).__init__(
            'aws:lightsail/staticIpAttachment:StaticIpAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            instance_name: Optional[pulumi.Input[str]] = None,
            ip_address: Optional[pulumi.Input[str]] = None,
            static_ip_name: Optional[pulumi.Input[str]] = None) -> 'StaticIpAttachment':
        """
        Get an existing StaticIpAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] instance_name: The name of the Lightsail instance to attach the IP to
        :param pulumi.Input[str] ip_address: The allocated static IP address
        :param pulumi.Input[str] static_ip_name: The name of the allocated static IP
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StaticIpAttachmentState.__new__(_StaticIpAttachmentState)

        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["static_ip_name"] = static_ip_name
        return StaticIpAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[str]:
        """
        The name of the Lightsail instance to attach the IP to
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[str]:
        """
        The allocated static IP address
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="staticIpName")
    def static_ip_name(self) -> pulumi.Output[str]:
        """
        The name of the allocated static IP
        """
        return pulumi.get(self, "static_ip_name")

