# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetPlaceIndexResult',
    'AwaitableGetPlaceIndexResult',
    'get_place_index',
    'get_place_index_output',
]

@pulumi.output_type
class GetPlaceIndexResult:
    """
    A collection of values returned by getPlaceIndex.
    """
    def __init__(__self__, create_time=None, data_source=None, data_source_configurations=None, description=None, id=None, index_arn=None, index_name=None, tags=None, update_time=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if data_source and not isinstance(data_source, str):
            raise TypeError("Expected argument 'data_source' to be a str")
        pulumi.set(__self__, "data_source", data_source)
        if data_source_configurations and not isinstance(data_source_configurations, list):
            raise TypeError("Expected argument 'data_source_configurations' to be a list")
        pulumi.set(__self__, "data_source_configurations", data_source_configurations)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if index_arn and not isinstance(index_arn, str):
            raise TypeError("Expected argument 'index_arn' to be a str")
        pulumi.set(__self__, "index_arn", index_arn)
        if index_name and not isinstance(index_name, str):
            raise TypeError("Expected argument 'index_name' to be a str")
        pulumi.set(__self__, "index_name", index_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Timestamp for when the place index resource was created in ISO 8601 format.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> str:
        """
        Data provider of geospatial data.
        """
        return pulumi.get(self, "data_source")

    @property
    @pulumi.getter(name="dataSourceConfigurations")
    def data_source_configurations(self) -> Sequence['outputs.GetPlaceIndexDataSourceConfigurationResult']:
        """
        List of configurations that specify data storage option for requesting Places.
        """
        return pulumi.get(self, "data_source_configurations")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional description for the place index resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="indexArn")
    def index_arn(self) -> str:
        """
        ARN for the place index resource.
        """
        return pulumi.get(self, "index_arn")

    @property
    @pulumi.getter(name="indexName")
    def index_name(self) -> str:
        return pulumi.get(self, "index_name")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        Key-value map of resource tags for the place index.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Timestamp for when the place index resource was last updated in ISO 8601 format.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetPlaceIndexResult(GetPlaceIndexResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPlaceIndexResult(
            create_time=self.create_time,
            data_source=self.data_source,
            data_source_configurations=self.data_source_configurations,
            description=self.description,
            id=self.id,
            index_arn=self.index_arn,
            index_name=self.index_name,
            tags=self.tags,
            update_time=self.update_time)


def get_place_index(index_name: Optional[str] = None,
                    tags: Optional[Mapping[str, str]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPlaceIndexResult:
    """
    Retrieve information about a Location Service Place Index.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.location.get_place_index(index_name="example")
    ```
    <!--End PulumiCodeChooser -->


    :param str index_name: Name of the place index resource.
    :param Mapping[str, str] tags: Key-value map of resource tags for the place index.
    """
    __args__ = dict()
    __args__['indexName'] = index_name
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:location/getPlaceIndex:getPlaceIndex', __args__, opts=opts, typ=GetPlaceIndexResult).value

    return AwaitableGetPlaceIndexResult(
        create_time=pulumi.get(__ret__, 'create_time'),
        data_source=pulumi.get(__ret__, 'data_source'),
        data_source_configurations=pulumi.get(__ret__, 'data_source_configurations'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        index_arn=pulumi.get(__ret__, 'index_arn'),
        index_name=pulumi.get(__ret__, 'index_name'),
        tags=pulumi.get(__ret__, 'tags'),
        update_time=pulumi.get(__ret__, 'update_time'))


@_utilities.lift_output_func(get_place_index)
def get_place_index_output(index_name: Optional[pulumi.Input[str]] = None,
                           tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPlaceIndexResult]:
    """
    Retrieve information about a Location Service Place Index.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.location.get_place_index(index_name="example")
    ```
    <!--End PulumiCodeChooser -->


    :param str index_name: Name of the place index resource.
    :param Mapping[str, str] tags: Key-value map of resource tags for the place index.
    """
    ...
