# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['TrackerAssociationArgs', 'TrackerAssociation']

@pulumi.input_type
class TrackerAssociationArgs:
    def __init__(__self__, *,
                 consumer_arn: pulumi.Input[str],
                 tracker_name: pulumi.Input[str]):
        """
        The set of arguments for constructing a TrackerAssociation resource.
        :param pulumi.Input[str] consumer_arn: The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker resource. Used when you need to specify a resource across all AWS.
        :param pulumi.Input[str] tracker_name: The name of the tracker resource to be associated with a geofence collection.
        """
        pulumi.set(__self__, "consumer_arn", consumer_arn)
        pulumi.set(__self__, "tracker_name", tracker_name)

    @property
    @pulumi.getter(name="consumerArn")
    def consumer_arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker resource. Used when you need to specify a resource across all AWS.
        """
        return pulumi.get(self, "consumer_arn")

    @consumer_arn.setter
    def consumer_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "consumer_arn", value)

    @property
    @pulumi.getter(name="trackerName")
    def tracker_name(self) -> pulumi.Input[str]:
        """
        The name of the tracker resource to be associated with a geofence collection.
        """
        return pulumi.get(self, "tracker_name")

    @tracker_name.setter
    def tracker_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "tracker_name", value)


@pulumi.input_type
class _TrackerAssociationState:
    def __init__(__self__, *,
                 consumer_arn: Optional[pulumi.Input[str]] = None,
                 tracker_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TrackerAssociation resources.
        :param pulumi.Input[str] consumer_arn: The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker resource. Used when you need to specify a resource across all AWS.
        :param pulumi.Input[str] tracker_name: The name of the tracker resource to be associated with a geofence collection.
        """
        if consumer_arn is not None:
            pulumi.set(__self__, "consumer_arn", consumer_arn)
        if tracker_name is not None:
            pulumi.set(__self__, "tracker_name", tracker_name)

    @property
    @pulumi.getter(name="consumerArn")
    def consumer_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker resource. Used when you need to specify a resource across all AWS.
        """
        return pulumi.get(self, "consumer_arn")

    @consumer_arn.setter
    def consumer_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consumer_arn", value)

    @property
    @pulumi.getter(name="trackerName")
    def tracker_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the tracker resource to be associated with a geofence collection.
        """
        return pulumi.get(self, "tracker_name")

    @tracker_name.setter
    def tracker_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tracker_name", value)


class TrackerAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 consumer_arn: Optional[pulumi.Input[str]] = None,
                 tracker_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Location Tracker Association.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.location.GeofenceCollection("example", collection_name="example")
        example_tracker = aws.location.Tracker("example", tracker_name="example")
        example_tracker_association = aws.location.TrackerAssociation("example",
            consumer_arn=example.collection_arn,
            tracker_name=example_tracker.tracker_name)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Location Tracker Association using the `tracker_name|consumer_arn`. For example:

        ```sh
        $ pulumi import aws:location/trackerAssociation:TrackerAssociation example "tracker_name|consumer_arn"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] consumer_arn: The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker resource. Used when you need to specify a resource across all AWS.
        :param pulumi.Input[str] tracker_name: The name of the tracker resource to be associated with a geofence collection.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TrackerAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Location Tracker Association.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.location.GeofenceCollection("example", collection_name="example")
        example_tracker = aws.location.Tracker("example", tracker_name="example")
        example_tracker_association = aws.location.TrackerAssociation("example",
            consumer_arn=example.collection_arn,
            tracker_name=example_tracker.tracker_name)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Location Tracker Association using the `tracker_name|consumer_arn`. For example:

        ```sh
        $ pulumi import aws:location/trackerAssociation:TrackerAssociation example "tracker_name|consumer_arn"
        ```

        :param str resource_name: The name of the resource.
        :param TrackerAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TrackerAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 consumer_arn: Optional[pulumi.Input[str]] = None,
                 tracker_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TrackerAssociationArgs.__new__(TrackerAssociationArgs)

            if consumer_arn is None and not opts.urn:
                raise TypeError("Missing required property 'consumer_arn'")
            __props__.__dict__["consumer_arn"] = consumer_arn
            if tracker_name is None and not opts.urn:
                raise TypeError("Missing required property 'tracker_name'")
            __props__.__dict__["tracker_name"] = tracker_name
        super(TrackerAssociation, __self__).__init__(
            'aws:location/trackerAssociation:TrackerAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            consumer_arn: Optional[pulumi.Input[str]] = None,
            tracker_name: Optional[pulumi.Input[str]] = None) -> 'TrackerAssociation':
        """
        Get an existing TrackerAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] consumer_arn: The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker resource. Used when you need to specify a resource across all AWS.
        :param pulumi.Input[str] tracker_name: The name of the tracker resource to be associated with a geofence collection.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TrackerAssociationState.__new__(_TrackerAssociationState)

        __props__.__dict__["consumer_arn"] = consumer_arn
        __props__.__dict__["tracker_name"] = tracker_name
        return TrackerAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="consumerArn")
    def consumer_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker resource. Used when you need to specify a resource across all AWS.
        """
        return pulumi.get(self, "consumer_arn")

    @property
    @pulumi.getter(name="trackerName")
    def tracker_name(self) -> pulumi.Output[str]:
        """
        The name of the tracker resource to be associated with a geofence collection.
        """
        return pulumi.get(self, "tracker_name")

